Several complete examples (COMBINE/OMEX archives with linked SED-ML and Vega files) are available [here](https://github.com/biosimulators/Biosimulators_test_suite/tree/deploy/examples#compatibility-of-the-example-archives-with-simulation-tools). These examples illustrate how Vega can be combined with a broad range of modeling formalisms, simulation algorithms, model formats, and simulation tools.

* Activity flux diagram created with GINsim with a menu for selecting a perturbation condition (gene knockout) and a slider for scrolling through simulation time
    * Interactive visualization: [synchronous logical updating with SBML-qual, BoolNet](https://biosimulations.org/projects/Yeast-cell-cycle-Irons-J-Theor-Biol-2009#tab=select-viz)
    * COMBINE/OMEX archive: [synchronous logical updating with SBML-qual](https://github.com/biosimulators/Biosimulators_test_suite/blob/deploy/examples/sbml-qual/Irons-J-Theor-Biol-2009-yeast-cell-cycle.omex?raw=true)
    * Individual files: [synchronous logical updating with SBML-qual](https://github.com/biosimulators/Biosimulators_test_suite/tree/deploy/examples/sbml-qual/Irons-J-Theor-Biol-2009-yeast-cell-cycle)
* Line chart with an interactive legend 
    * Interactive visualization: [LSODA with SBML, PySCeS](https://biosimulations.org/projects/Nicotinic-excitation-Edelstein-Biol-Cybern-1996#tab=select-viz)
    * COMBINE/OMEX archive: [LSODA with SBML](https://github.com/biosimulators/Biosimulators_test_suite/blob/deploy/examples/sbml-core/Edelstein-Biol-Cybern-1996-Nicotinic-excitation.omex?raw=true)
    * Individual files: [LSODA with SBML](https://github.com/biosimulators/Biosimulators_test_suite/tree/deploy/examples/sbml-core/Edelstein-Biol-Cybern-1996-Nicotinic-excitation)
* Figure with multiple panels
    * Interactive visualization: [CVODE method with SBML, tellurium](https://biosimulations.org/projects/Morphogenesis-checkpoint-continuous-Ciliberto-J-Cell-Biol-2003#tab=select-viz)
    * COMBINE/OMEX archive: [CVODE method with SBML](https://github.com/biosimulators/Biosimulators_test_suite/blob/deploy/examples/sbml-core/Ciliberto-J-Cell-Biol-2003-morphogenesis-checkpoint-continuous.omex?raw=true)
    * Individual files: [CVODE method with SBML](https://github.com/biosimulators/Biosimulators_test_suite/tree/deploy/examples/sbml-core/Ciliberto-J-Cell-Biol-2003-morphogenesis-checkpoint-continuous)
* Process description map created with SBGN with a slider for scrolling through simulation time 
    * Interactive visualization: [LSODA with SBML, COPASI](https://biosimulations.org/projects/Repressilator-Elowitz-Nature-2000#tab=select-viz)
    * COMBINE/OMEX archive: [CVODE with CellML](https://github.com/biosimulators/Biosimulators_test_suite/blob/deploy/examples/cellml/Elowitz-Nature-2000-Repressilator.omex?raw=true) 
    * COMBINE/OMEX archive: [CVODE with SBML](https://github.com/biosimulators/Biosimulators_test_suite/blob/deploy/examples/sbml-core/Elowitz-Nature-2000-Repressilator.omex?raw=true)
    * Individual files: [CVODE with CellML](https://github.com/biosimulators/Biosimulators_test_suite/tree/deploy/examples/cellml/Elowitz-Nature-2000-Repressilator) 
    * Individual files: [CVODE with SBML](https://github.com/biosimulators/Biosimulators_test_suite/tree/deploy/examples/sbml-core/Elowitz-Nature-2000-Repressilator)
* Reaction flux map created with Escher with interactive metabolites and reactions
    * Interactive visualization: [FBA with SBML-fbc, COBRApy](https://biosimulations.org/projects/Escherichia-coli-core-metabolism-textbook#tab=select-viz)
    * Interactive visualization: [RBA with RBA XML, RBApy](https://biosimulations.org/projects/Escherichia-coli-resource-allocation-Bulovic-Metab-Eng-2019#tab=select-viz)
    * COMBINE/OMEX archive: [FBA with SBML-fbc](https://github.com/biosimulators/Biosimulators_test_suite/blob/deploy/examples/sbml-fbc/
    Escherichia-coli-core-metabolism.omex?raw=true)
    * COMBINE/OMEX archive: [RBA with RBA XML](https://github.com/biosimulators/Biosimulators_test_suite/blob/deploy/examples/rba/Escherichia-coli-K12-WT.omex?raw=true)
    * Individual files: [FBA with SBML-fbc](https://github.com/biosimulators/Biosimulators_test_suite/tree/deploy/examples/sbml-fbc/
    Escherichia-coli-core-metabolism)
    * Individual files: [RBA with RBA XML](https://github.com/biosimulators/Biosimulators_test_suite/tree/deploy/examples/rba/Escherichia-coli-K12-WT)
