; ModuleID = 'bc/Cipher/sm4-trace_instru.bc'
source_filename = "llvm-link"
target datalayout = "e-m:e-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

%struct.SM4_KEY_st = type { [32 x i32] }

@SM4_set_key.FK = internal constant [4 x i32] [i32 -1548633402, i32 1453994832, i32 1736282519, i32 -1301273892], align 16, !dbg !0
@SM4_set_key.CK = internal constant [32 x i32] [i32 462357, i32 472066609, i32 943670861, i32 1415275113, i32 1886879365, i32 -1936483679, i32 -1464879427, i32 -993275175, i32 -521670923, i32 -66909679, i32 404694573, i32 876298825, i32 1347903077, i32 1819507329, i32 -2003855715, i32 -1532251463, i32 -1060647211, i32 -589042959, i32 -117504499, i32 337322537, i32 808926789, i32 1280531041, i32 1752135293, i32 -2071227751, i32 -1599623499, i32 -1128019247, i32 -656414995, i32 -184876535, i32 269950501, i32 741554753, i32 1213159005, i32 1684763257], align 16, !dbg !30
@SM4_S = internal constant [256 x i8] c"\D6\90\E9\FE\CC\E1=\B7\16\B6\14\C2(\FB,\05+g\9Av*\BE\04\C3\AAD\13&I\86\06\99\9CBP\F4\91\EF\98z3T\0BC\ED\CF\ACb\E4\B3\1C\A9\C9\08\E8\95\80\DF\94\FAu\8F?\A6G\07\A7\FC\F3s\17\BA\83Y<\19\E6\85O\A8hk\81\B2qd\DA\8B\F8\EB\0FKpV\9D5\1E$\0E^cX\D1\A2%\22|;\01!x\87\D4\00FW\9F\D3'RL6\02\E7\A0\C4\C8\9E\EA\BF\8A\D2@\C78\B5\A3\F7\F2\CE\F9a\15\A1\E0\AE]\A4\9B4\1AU\AD\9320\F5\8C\B1\E3\1D\F6\E2.\82f\CA`\C0)#\AB\0DSNo\D5\DB7E\DE\FD\8E/\03\FFjrml[Q\8D\1B\AF\92\BB\DD\BC\7F\11\D9\\A\1F\10Z\D8\0A\C11\88\A5\CD{\BD-t\D0\12\B8\E5\B4\B0\89i\97J\0C\96w~e\B9\F1\09\C5n\C6\84\18\F0}\EC:\DCM y\EE_>\D7\CB9H", align 16, !dbg !34
@.str = private unnamed_addr constant [5 x i8] c"mark\00", section "llvm.metadata"
@.str.1 = private unnamed_addr constant [13 x i8] c"Cipher/sm4.c\00", section "llvm.metadata"
@SM4_SBOX_T = internal constant [256 x i32] [i32 -1898620069, i32 -795721150, i32 1307223975, i32 117308411, i32 -53529805, i32 1709344647, i32 -918686476, i32 1807081182, i32 1310087256, i32 1857346266, i32 1142181968, i32 -893318389, i32 -2010603360, i32 402190319, i32 -1674792784, i32 285545492, i32 -2027180884, i32 -77161059, i32 -224892310, i32 -1367877159, i32 -2111133528, i32 1186790138, i32 335810576, i32 -809496817, i32 44608170, i32 1413812497, i32 1595100236, i32 -1104766824, i32 1833444645, i32 -1635509734, i32 503715864, i32 -40147354, i32 -325160334, i32 1245907209, i32 273760577, i32 620221395, i32 -711768506, i32 1408024511, i32 -124099998, i32 -1837372951, i32 -13382452, i32 72700241, i32 655043628, i32 1329728781, i32 1508816823, i32 -204718273, i32 481211058, i32 -362575479, i32 1961333651, i32 2142359246, i32 1813803120, i32 229353126, i32 -305518809, i32 671621152, i32 1223402403, i32 -1047046570, i32 -2138963454, i32 -1545830529, i32 -996781486, i32 318368747, i32 -1586178603, i32 -1282589122, i32 -1019216644, i32 1050974874, i32 1531321629, i32 453450780, i32 1000709790, i32 218100723, i32 1072746447, i32 -1082995251, i32 1259822172, i32 1387850474, i32 -1887367666, i32 1029203301, i32 -868421392, i32 2098816100, i32 2128976795, i32 -1853417962, i32 1934507325, i32 145400482, i32 -932601439, i32 -949310035, i32 -2055010810, i32 2058406602, i32 -1250900539, i32 -194670191, i32 -1294374037, i32 -1484181970, i32 419161059, i32 1206431663, i32 856636476, i32 1732914477, i32 -1334722111, i32 240605529, i32 -375425418, i32 -516565804, i32 1713272952, i32 -1272672112, i32 906901560, i32 643791225, i32 -278753907, i32 945381729, i32 -1781381305, i32 715164298, i32 -1322937196, i32 -1440577400, i32 -1937903119, i32 -683938580, i32 83952644, i32 -1524530044, i32 -1736842783, i32 -1685774818, i32 -2066263213, i32 0, i32 1581717785, i32 190209373, i32 -476217730, i32 -1613738161, i32 -1155031908, i32 441665865, i32 2085433649, i32 -298395432, i32 167905288, i32 2078580639, i32 547521154, i32 -725150957, i32 -389340381, i32 -425952646, i32 1122610091, i32 1136525054, i32 -1568134614, i32 -1697559733, i32 1078001921, i32 -607903969, i32 -667361056, i32 1639438038, i32 799116942, i32 737468383, i32 988924875, i32 -154322117, i32 502982631, i32 -446659195, i32 1091916884, i32 631473798, i32 1625523075, i32 380418746, i32 693925237, i32 883331730, i32 -140939666, i32 -466300720, i32 1914333288, i32 22304085, i32 430945974, i32 -544125362, i32 -97335096, i32 -265240384, i32 569825239, i32 -1131531726, i32 1974716102, i32 1876987791, i32 1763538036, i32 787864539, i32 1793166219, i32 -1775322952, i32 -1971320310, i32 -26764903, i32 -490132693, i32 -530480767, i32 -1060961533, i32 -1926650716, i32 -1356624756, i32 128560814, i32 957166644, i32 525487437, i32 1984903481, i32 -747717187, i32 -2116659369, i32 -1210552465, i32 -348660516, i32 1363416341, i32 -1495434373, i32 167704567, i32 -1232324038, i32 -1825588036, i32 251857932, i32 66912255, i32 -1033131607, i32 -1166816823, i32 -647187019, i32 -596790863, i32 928673133, i32 357582149, i32 -1181796810, i32 1998285932, i32 330153662, i32 -628078006, i32 1471803118, i32 -1445038217, i32 1287582450, i32 -2088829443, i32 1427194948, i32 -1109760153, i32 744321393, i32 1161823493, i32 1663007868, i32 1343242304, i32 844851561, i32 -1193581725, i32 571090984, i32 -977139961, i32 -181287740, i32 -1467342302, i32 833066646, i32 -103925961, i32 -1753551379, i32 1237317366, i32 -1725057868, i32 -1535782447, i32 -1865202877, i32 1511147592, i32 1488642786, i32 1910937495, i32 1689703122, i32 1890763458, i32 -1383389658, i32 -848779867, i32 -879403426, i32 1649092905, i32 1007431728, i32 -829138342, i32 -1418273315, i32 -2038433287, i32 -245066347, i32 1572595430, i32 905103303, i32 755573796, i32 -775547113, i32 -697321031, i32 -557507813, i32 -1803152878, i32 2014863456, i32 821281731, i32 -1988299275, i32 1559212979, i32 -767891224, i32 -1394642061, i32 2035037493, i32 -1608482688, i32 -1653021211, i32 1458420667, i32 593395069, i32 -968951560, i32 -1949016225, i32 -406311121, i32 -583408412, i32 1749623073], align 16, !dbg !39
@key = internal constant [32 x i8] c"\00\11\223DUfw\88\99\AA\BB\CC\DD\EE\FF\00\01\02\03\04\05\06\07\08\09\0A\0B\0C\0D\0E\0F", align 16, !dbg !42
@__const.main.charset = private unnamed_addr constant [94 x i8] c"!#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\00", align 16
@.str.2 = private unnamed_addr constant [28 x i8] c"DDEP: SrcID: %d DestID: %d\0A\00", align 1
@.str.1.3 = private unnamed_addr constant [28 x i8] c"CDEP: SrcID: %d DestID: %d\0A\00", align 1
@.str.2.4 = private unnamed_addr constant [37 x i8] c"Store: 0x%llx ID: %d @Ln,Col: %d,%d\0A\00", align 1
@.str.3 = private unnamed_addr constant [36 x i8] c"Load: 0x%llx ID: %d @Ln,Col: %d,%d\0A\00", align 1
@.str.4 = private unnamed_addr constant [102 x i8] c"SymbolicStore: Concrete: 0x%llx Symbolic: From: 0x%llx To: 0x%llx StepSize: %d ID: %d @Ln,Col: %d,%d\0A\00", align 1
@.str.5 = private unnamed_addr constant [101 x i8] c"SymbolicLoad: Concrete: 0x%llx Symbolic: From: 0x%llx To: 0x%llx StepSize: %d ID: %d @Ln,Col: %d,%d\0A\00", align 1
@.str.6 = private unnamed_addr constant [17 x i8] c"InstCounter: %d\0A\00", align 1
@Inst_Counter = common dso_local global i32 0

; Function Attrs: alwaysinline nounwind uwtable
define dso_local i32 @SM4_set_key(i8* %key, %struct.SM4_KEY_st* %ks) #0 !dbg !2 {
entry:
  %b.addr.i125 = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i125, metadata !53, metadata !DIExpression()), !dbg !57
  %n.addr.i126 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %n.addr.i126, metadata !59, metadata !DIExpression()), !dbg !60
  %b.addr.i98 = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i98, metadata !53, metadata !DIExpression()), !dbg !61
  %n.addr.i99 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %n.addr.i99, metadata !59, metadata !DIExpression()), !dbg !63
  %b.addr.i71 = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i71, metadata !53, metadata !DIExpression()), !dbg !64
  %n.addr.i72 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %n.addr.i72, metadata !59, metadata !DIExpression()), !dbg !66
  %a.addr.i63 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i63, metadata !67, metadata !DIExpression()), !dbg !71
  %n.addr.i64 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i64, metadata !76, metadata !DIExpression()), !dbg !77
  %a.addr.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i, metadata !67, metadata !DIExpression()), !dbg !78
  %n.addr.i59 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i59, metadata !76, metadata !DIExpression()), !dbg !80
  %b.addr.i = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i, metadata !53, metadata !DIExpression()), !dbg !81
  %n.addr.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %n.addr.i, metadata !59, metadata !DIExpression()), !dbg !83
  %key.addr = alloca i8*, align 8
  %ks.addr = alloca %struct.SM4_KEY_st*, align 8
  %K = alloca [4 x i32], align 16
  %i = alloca i32, align 4
  %X = alloca i32, align 4
  %t = alloca i32, align 4
  store i8* %key, i8** %key.addr, align 8
  call void @llvm.dbg.declare(metadata i8** %key.addr, metadata !84, metadata !DIExpression()), !dbg !85
  store %struct.SM4_KEY_st* %ks, %struct.SM4_KEY_st** %ks.addr, align 8
  call void @llvm.dbg.declare(metadata %struct.SM4_KEY_st** %ks.addr, metadata !86, metadata !DIExpression()), !dbg !87
  call void @llvm.dbg.declare(metadata [4 x i32]* %K, metadata !88, metadata !DIExpression()), !dbg !90
  call void @llvm.dbg.declare(metadata i32* %i, metadata !91, metadata !DIExpression()), !dbg !92
  %0 = load i8*, i8** %key.addr, align 8, !dbg !93
  store i8* %0, i8** %b.addr.i, align 8
  store i32 0, i32* %n.addr.i, align 4
  %1 = load i8*, i8** %b.addr.i, align 8, !dbg !94
  %2 = load i32, i32* %n.addr.i, align 4, !dbg !95
  %mul.i = mul i32 4, %2, !dbg !96
  %idxprom.i = zext i32 %mul.i to i64, !dbg !94
  %arrayidx.i = getelementptr inbounds i8, i8* %1, i64 %idxprom.i, !dbg !94
  %3 = load i8, i8* %arrayidx.i, align 1, !dbg !94
  %conv.i = zext i8 %3 to i32, !dbg !97
  %shl.i = shl i32 %conv.i, 24, !dbg !98
  %4 = load i8*, i8** %b.addr.i, align 8, !dbg !99
  %5 = load i32, i32* %n.addr.i, align 4, !dbg !100
  %mul1.i = mul i32 4, %5, !dbg !101
  %add.i = add i32 %mul1.i, 1, !dbg !102
  %idxprom2.i = zext i32 %add.i to i64, !dbg !99
  %arrayidx3.i = getelementptr inbounds i8, i8* %4, i64 %idxprom2.i, !dbg !99
  %6 = load i8, i8* %arrayidx3.i, align 1, !dbg !99
  %conv4.i = zext i8 %6 to i32, !dbg !103
  %shl5.i = shl i32 %conv4.i, 16, !dbg !104
  %or.i = or i32 %shl.i, %shl5.i, !dbg !105
  %7 = load i8*, i8** %b.addr.i, align 8, !dbg !106
  %8 = load i32, i32* %n.addr.i, align 4, !dbg !107
  %mul6.i = mul i32 4, %8, !dbg !108
  %add7.i = add i32 %mul6.i, 2, !dbg !109
  %idxprom8.i = zext i32 %add7.i to i64, !dbg !106
  %arrayidx9.i = getelementptr inbounds i8, i8* %7, i64 %idxprom8.i, !dbg !106
  %9 = load i8, i8* %arrayidx9.i, align 1, !dbg !106
  %conv10.i = zext i8 %9 to i32, !dbg !110
  %shl11.i = shl i32 %conv10.i, 8, !dbg !111
  %or12.i = or i32 %or.i, %shl11.i, !dbg !112
  %10 = load i8*, i8** %b.addr.i, align 8, !dbg !113
  %11 = load i32, i32* %n.addr.i, align 4, !dbg !114
  %mul13.i = mul i32 4, %11, !dbg !115
  %add14.i = add i32 %mul13.i, 3, !dbg !116
  %idxprom15.i = zext i32 %add14.i to i64, !dbg !113
  %arrayidx16.i = getelementptr inbounds i8, i8* %10, i64 %idxprom15.i, !dbg !113
  %12 = load i8, i8* %arrayidx16.i, align 1, !dbg !113
  %conv17.i = zext i8 %12 to i32, !dbg !117
  %or18.i = or i32 %or12.i, %conv17.i, !dbg !118
  %13 = load i32, i32* getelementptr inbounds ([4 x i32], [4 x i32]* @SM4_set_key.FK, i64 0, i64 0), align 16, !dbg !119
  %xor = xor i32 %or18.i, %13, !dbg !120
  %arrayidx = getelementptr inbounds [4 x i32], [4 x i32]* %K, i64 0, i64 0, !dbg !121
  store i32 %xor, i32* %arrayidx, align 16, !dbg !122
  %14 = load i8*, i8** %key.addr, align 8, !dbg !123
  store i8* %14, i8** %b.addr.i125, align 8
  store i32 1, i32* %n.addr.i126, align 4
  %15 = load i8*, i8** %b.addr.i125, align 8, !dbg !124
  %16 = load i32, i32* %n.addr.i126, align 4, !dbg !125
  %mul.i127 = mul i32 4, %16, !dbg !126
  %idxprom.i128 = zext i32 %mul.i127 to i64, !dbg !124
  %arrayidx.i129 = getelementptr inbounds i8, i8* %15, i64 %idxprom.i128, !dbg !124
  %17 = load i8, i8* %arrayidx.i129, align 1, !dbg !124
  %conv.i130 = zext i8 %17 to i32, !dbg !127
  %shl.i131 = shl i32 %conv.i130, 24, !dbg !128
  %18 = load i8*, i8** %b.addr.i125, align 8, !dbg !129
  %19 = load i32, i32* %n.addr.i126, align 4, !dbg !130
  %mul1.i132 = mul i32 4, %19, !dbg !131
  %add.i133 = add i32 %mul1.i132, 1, !dbg !132
  %idxprom2.i134 = zext i32 %add.i133 to i64, !dbg !129
  %arrayidx3.i135 = getelementptr inbounds i8, i8* %18, i64 %idxprom2.i134, !dbg !129
  %20 = load i8, i8* %arrayidx3.i135, align 1, !dbg !129
  %conv4.i136 = zext i8 %20 to i32, !dbg !133
  %shl5.i137 = shl i32 %conv4.i136, 16, !dbg !134
  %or.i138 = or i32 %shl.i131, %shl5.i137, !dbg !135
  %21 = load i8*, i8** %b.addr.i125, align 8, !dbg !136
  %22 = load i32, i32* %n.addr.i126, align 4, !dbg !137
  %mul6.i139 = mul i32 4, %22, !dbg !138
  %add7.i140 = add i32 %mul6.i139, 2, !dbg !139
  %idxprom8.i141 = zext i32 %add7.i140 to i64, !dbg !136
  %arrayidx9.i142 = getelementptr inbounds i8, i8* %21, i64 %idxprom8.i141, !dbg !136
  %23 = load i8, i8* %arrayidx9.i142, align 1, !dbg !136
  %conv10.i143 = zext i8 %23 to i32, !dbg !140
  %shl11.i144 = shl i32 %conv10.i143, 8, !dbg !141
  %or12.i145 = or i32 %or.i138, %shl11.i144, !dbg !142
  %24 = load i8*, i8** %b.addr.i125, align 8, !dbg !143
  %25 = load i32, i32* %n.addr.i126, align 4, !dbg !144
  %mul13.i146 = mul i32 4, %25, !dbg !145
  %add14.i147 = add i32 %mul13.i146, 3, !dbg !146
  %idxprom15.i148 = zext i32 %add14.i147 to i64, !dbg !143
  %arrayidx16.i149 = getelementptr inbounds i8, i8* %24, i64 %idxprom15.i148, !dbg !143
  %26 = load i8, i8* %arrayidx16.i149, align 1, !dbg !143
  %conv17.i150 = zext i8 %26 to i32, !dbg !147
  %or18.i151 = or i32 %or12.i145, %conv17.i150, !dbg !148
  %27 = load i32, i32* getelementptr inbounds ([4 x i32], [4 x i32]* @SM4_set_key.FK, i64 0, i64 1), align 4, !dbg !149
  %xor2 = xor i32 %or18.i151, %27, !dbg !150
  %arrayidx3 = getelementptr inbounds [4 x i32], [4 x i32]* %K, i64 0, i64 1, !dbg !151
  store i32 %xor2, i32* %arrayidx3, align 4, !dbg !152
  %28 = load i8*, i8** %key.addr, align 8, !dbg !153
  store i8* %28, i8** %b.addr.i98, align 8
  store i32 2, i32* %n.addr.i99, align 4
  %29 = load i8*, i8** %b.addr.i98, align 8, !dbg !154
  %30 = load i32, i32* %n.addr.i99, align 4, !dbg !155
  %mul.i100 = mul i32 4, %30, !dbg !156
  %idxprom.i101 = zext i32 %mul.i100 to i64, !dbg !154
  %arrayidx.i102 = getelementptr inbounds i8, i8* %29, i64 %idxprom.i101, !dbg !154
  %31 = load i8, i8* %arrayidx.i102, align 1, !dbg !154
  %conv.i103 = zext i8 %31 to i32, !dbg !157
  %shl.i104 = shl i32 %conv.i103, 24, !dbg !158
  %32 = load i8*, i8** %b.addr.i98, align 8, !dbg !159
  %33 = load i32, i32* %n.addr.i99, align 4, !dbg !160
  %mul1.i105 = mul i32 4, %33, !dbg !161
  %add.i106 = add i32 %mul1.i105, 1, !dbg !162
  %idxprom2.i107 = zext i32 %add.i106 to i64, !dbg !159
  %arrayidx3.i108 = getelementptr inbounds i8, i8* %32, i64 %idxprom2.i107, !dbg !159
  %34 = load i8, i8* %arrayidx3.i108, align 1, !dbg !159
  %conv4.i109 = zext i8 %34 to i32, !dbg !163
  %shl5.i110 = shl i32 %conv4.i109, 16, !dbg !164
  %or.i111 = or i32 %shl.i104, %shl5.i110, !dbg !165
  %35 = load i8*, i8** %b.addr.i98, align 8, !dbg !166
  %36 = load i32, i32* %n.addr.i99, align 4, !dbg !167
  %mul6.i112 = mul i32 4, %36, !dbg !168
  %add7.i113 = add i32 %mul6.i112, 2, !dbg !169
  %idxprom8.i114 = zext i32 %add7.i113 to i64, !dbg !166
  %arrayidx9.i115 = getelementptr inbounds i8, i8* %35, i64 %idxprom8.i114, !dbg !166
  %37 = load i8, i8* %arrayidx9.i115, align 1, !dbg !166
  %conv10.i116 = zext i8 %37 to i32, !dbg !170
  %shl11.i117 = shl i32 %conv10.i116, 8, !dbg !171
  %or12.i118 = or i32 %or.i111, %shl11.i117, !dbg !172
  %38 = load i8*, i8** %b.addr.i98, align 8, !dbg !173
  %39 = load i32, i32* %n.addr.i99, align 4, !dbg !174
  %mul13.i119 = mul i32 4, %39, !dbg !175
  %add14.i120 = add i32 %mul13.i119, 3, !dbg !176
  %idxprom15.i121 = zext i32 %add14.i120 to i64, !dbg !173
  %arrayidx16.i122 = getelementptr inbounds i8, i8* %38, i64 %idxprom15.i121, !dbg !173
  %40 = load i8, i8* %arrayidx16.i122, align 1, !dbg !173
  %conv17.i123 = zext i8 %40 to i32, !dbg !177
  %or18.i124 = or i32 %or12.i118, %conv17.i123, !dbg !178
  %41 = load i32, i32* getelementptr inbounds ([4 x i32], [4 x i32]* @SM4_set_key.FK, i64 0, i64 2), align 8, !dbg !179
  %xor5 = xor i32 %or18.i124, %41, !dbg !180
  %arrayidx6 = getelementptr inbounds [4 x i32], [4 x i32]* %K, i64 0, i64 2, !dbg !181
  store i32 %xor5, i32* %arrayidx6, align 8, !dbg !182
  %42 = load i8*, i8** %key.addr, align 8, !dbg !183
  store i8* %42, i8** %b.addr.i71, align 8
  store i32 3, i32* %n.addr.i72, align 4
  %43 = load i8*, i8** %b.addr.i71, align 8, !dbg !184
  %44 = load i32, i32* %n.addr.i72, align 4, !dbg !185
  %mul.i73 = mul i32 4, %44, !dbg !186
  %idxprom.i74 = zext i32 %mul.i73 to i64, !dbg !184
  %arrayidx.i75 = getelementptr inbounds i8, i8* %43, i64 %idxprom.i74, !dbg !184
  %45 = load i8, i8* %arrayidx.i75, align 1, !dbg !184
  %conv.i76 = zext i8 %45 to i32, !dbg !187
  %shl.i77 = shl i32 %conv.i76, 24, !dbg !188
  %46 = load i8*, i8** %b.addr.i71, align 8, !dbg !189
  %47 = load i32, i32* %n.addr.i72, align 4, !dbg !190
  %mul1.i78 = mul i32 4, %47, !dbg !191
  %add.i79 = add i32 %mul1.i78, 1, !dbg !192
  %idxprom2.i80 = zext i32 %add.i79 to i64, !dbg !189
  %arrayidx3.i81 = getelementptr inbounds i8, i8* %46, i64 %idxprom2.i80, !dbg !189
  %48 = load i8, i8* %arrayidx3.i81, align 1, !dbg !189
  %conv4.i82 = zext i8 %48 to i32, !dbg !193
  %shl5.i83 = shl i32 %conv4.i82, 16, !dbg !194
  %or.i84 = or i32 %shl.i77, %shl5.i83, !dbg !195
  %49 = load i8*, i8** %b.addr.i71, align 8, !dbg !196
  %50 = load i32, i32* %n.addr.i72, align 4, !dbg !197
  %mul6.i85 = mul i32 4, %50, !dbg !198
  %add7.i86 = add i32 %mul6.i85, 2, !dbg !199
  %idxprom8.i87 = zext i32 %add7.i86 to i64, !dbg !196
  %arrayidx9.i88 = getelementptr inbounds i8, i8* %49, i64 %idxprom8.i87, !dbg !196
  %51 = load i8, i8* %arrayidx9.i88, align 1, !dbg !196
  %conv10.i89 = zext i8 %51 to i32, !dbg !200
  %shl11.i90 = shl i32 %conv10.i89, 8, !dbg !201
  %or12.i91 = or i32 %or.i84, %shl11.i90, !dbg !202
  %52 = load i8*, i8** %b.addr.i71, align 8, !dbg !203
  %53 = load i32, i32* %n.addr.i72, align 4, !dbg !204
  %mul13.i92 = mul i32 4, %53, !dbg !205
  %add14.i93 = add i32 %mul13.i92, 3, !dbg !206
  %idxprom15.i94 = zext i32 %add14.i93 to i64, !dbg !203
  %arrayidx16.i95 = getelementptr inbounds i8, i8* %52, i64 %idxprom15.i94, !dbg !203
  %54 = load i8, i8* %arrayidx16.i95, align 1, !dbg !203
  %conv17.i96 = zext i8 %54 to i32, !dbg !207
  %or18.i97 = or i32 %or12.i91, %conv17.i96, !dbg !208
  %55 = load i32, i32* getelementptr inbounds ([4 x i32], [4 x i32]* @SM4_set_key.FK, i64 0, i64 3), align 4, !dbg !209
  %xor8 = xor i32 %or18.i97, %55, !dbg !210
  %arrayidx9 = getelementptr inbounds [4 x i32], [4 x i32]* %K, i64 0, i64 3, !dbg !211
  store i32 %xor8, i32* %arrayidx9, align 4, !dbg !212
  store i32 0, i32* %i, align 4, !dbg !213
  br label %for.cond, !dbg !214

for.cond:                                         ; preds = %for.inc, %entry
  %56 = load i32, i32* %i, align 4, !dbg !215
  %cmp = icmp ne i32 %56, 32, !dbg !216
  br i1 %cmp, label %for.body, label %for.end, !dbg !217

for.body:                                         ; preds = %for.cond
  call void @llvm.dbg.declare(metadata i32* %X, metadata !218, metadata !DIExpression()), !dbg !219
  %57 = load i32, i32* %i, align 4, !dbg !220
  %add = add nsw i32 %57, 1, !dbg !221
  %rem = srem i32 %add, 4, !dbg !222
  %idxprom = sext i32 %rem to i64, !dbg !223
  %arrayidx10 = getelementptr inbounds [4 x i32], [4 x i32]* %K, i64 0, i64 %idxprom, !dbg !223
  %58 = load i32, i32* %arrayidx10, align 4, !dbg !223
  %59 = load i32, i32* %i, align 4, !dbg !224
  %add11 = add nsw i32 %59, 2, !dbg !225
  %rem12 = srem i32 %add11, 4, !dbg !226
  %idxprom13 = sext i32 %rem12 to i64, !dbg !227
  %arrayidx14 = getelementptr inbounds [4 x i32], [4 x i32]* %K, i64 0, i64 %idxprom13, !dbg !227
  %60 = load i32, i32* %arrayidx14, align 4, !dbg !227
  %xor15 = xor i32 %58, %60, !dbg !228
  %61 = load i32, i32* %i, align 4, !dbg !229
  %add16 = add nsw i32 %61, 3, !dbg !230
  %rem17 = srem i32 %add16, 4, !dbg !231
  %idxprom18 = sext i32 %rem17 to i64, !dbg !232
  %arrayidx19 = getelementptr inbounds [4 x i32], [4 x i32]* %K, i64 0, i64 %idxprom18, !dbg !232
  %62 = load i32, i32* %arrayidx19, align 4, !dbg !232
  %xor20 = xor i32 %xor15, %62, !dbg !233
  %63 = load i32, i32* %i, align 4, !dbg !234
  %idxprom21 = sext i32 %63 to i64, !dbg !235
  %arrayidx22 = getelementptr inbounds [32 x i32], [32 x i32]* @SM4_set_key.CK, i64 0, i64 %idxprom21, !dbg !235
  %64 = load i32, i32* %arrayidx22, align 4, !dbg !235
  %xor23 = xor i32 %xor20, %64, !dbg !236
  store i32 %xor23, i32* %X, align 4, !dbg !219
  call void @llvm.dbg.declare(metadata i32* %t, metadata !237, metadata !DIExpression()), !dbg !238
  store i32 0, i32* %t, align 4, !dbg !238
  %65 = load i32, i32* %X, align 4, !dbg !239
  %shr = lshr i32 %65, 24, !dbg !240
  %conv = trunc i32 %shr to i8, !dbg !241
  %idxprom24 = zext i8 %conv to i64, !dbg !242
  %arrayidx25 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom24, !dbg !242
  %66 = load i8, i8* %arrayidx25, align 1, !dbg !242
  %conv26 = zext i8 %66 to i32, !dbg !243
  %shl = shl i32 %conv26, 24, !dbg !244
  %67 = load i32, i32* %t, align 4, !dbg !245
  %or = or i32 %67, %shl, !dbg !245
  store i32 %or, i32* %t, align 4, !dbg !245
  %68 = load i32, i32* %X, align 4, !dbg !246
  %shr27 = lshr i32 %68, 16, !dbg !247
  %conv28 = trunc i32 %shr27 to i8, !dbg !248
  %idxprom29 = zext i8 %conv28 to i64, !dbg !249
  %arrayidx30 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom29, !dbg !249
  %69 = load i8, i8* %arrayidx30, align 1, !dbg !249
  %conv31 = zext i8 %69 to i32, !dbg !250
  %shl32 = shl i32 %conv31, 16, !dbg !251
  %70 = load i32, i32* %t, align 4, !dbg !252
  %or33 = or i32 %70, %shl32, !dbg !252
  store i32 %or33, i32* %t, align 4, !dbg !252
  %71 = load i32, i32* %X, align 4, !dbg !253
  %shr34 = lshr i32 %71, 8, !dbg !254
  %conv35 = trunc i32 %shr34 to i8, !dbg !255
  %idxprom36 = zext i8 %conv35 to i64, !dbg !256
  %arrayidx37 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom36, !dbg !256
  %72 = load i8, i8* %arrayidx37, align 1, !dbg !256
  %conv38 = zext i8 %72 to i32, !dbg !257
  %shl39 = shl i32 %conv38, 8, !dbg !258
  %73 = load i32, i32* %t, align 4, !dbg !259
  %or40 = or i32 %73, %shl39, !dbg !259
  store i32 %or40, i32* %t, align 4, !dbg !259
  %74 = load i32, i32* %X, align 4, !dbg !260
  %conv41 = trunc i32 %74 to i8, !dbg !261
  %idxprom42 = zext i8 %conv41 to i64, !dbg !262
  %arrayidx43 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom42, !dbg !262
  %75 = load i8, i8* %arrayidx43, align 1, !dbg !262
  %conv44 = zext i8 %75 to i32, !dbg !262
  %76 = load i32, i32* %t, align 4, !dbg !263
  %or45 = or i32 %76, %conv44, !dbg !263
  store i32 %or45, i32* %t, align 4, !dbg !263
  %77 = load i32, i32* %t, align 4, !dbg !264
  %78 = load i32, i32* %t, align 4, !dbg !265
  store i32 %78, i32* %a.addr.i63, align 4
  store i8 13, i8* %n.addr.i64, align 1
  %79 = load i32, i32* %a.addr.i63, align 4, !dbg !266
  %80 = load i8, i8* %n.addr.i64, align 1, !dbg !267
  %conv.i65 = zext i8 %80 to i32, !dbg !267
  %shl.i66 = shl i32 %79, %conv.i65, !dbg !268
  %81 = load i32, i32* %a.addr.i63, align 4, !dbg !269
  %82 = load i8, i8* %n.addr.i64, align 1, !dbg !270
  %conv1.i67 = zext i8 %82 to i32, !dbg !270
  %sub.i68 = sub nsw i32 32, %conv1.i67, !dbg !271
  %shr.i69 = lshr i32 %81, %sub.i68, !dbg !272
  %or.i70 = or i32 %shl.i66, %shr.i69, !dbg !273
  %xor47 = xor i32 %77, %or.i70, !dbg !274
  %83 = load i32, i32* %t, align 4, !dbg !275
  store i32 %83, i32* %a.addr.i, align 4
  store i8 23, i8* %n.addr.i59, align 1
  %84 = load i32, i32* %a.addr.i, align 4, !dbg !276
  %85 = load i8, i8* %n.addr.i59, align 1, !dbg !277
  %conv.i60 = zext i8 %85 to i32, !dbg !277
  %shl.i61 = shl i32 %84, %conv.i60, !dbg !278
  %86 = load i32, i32* %a.addr.i, align 4, !dbg !279
  %87 = load i8, i8* %n.addr.i59, align 1, !dbg !280
  %conv1.i = zext i8 %87 to i32, !dbg !280
  %sub.i = sub nsw i32 32, %conv1.i, !dbg !281
  %shr.i = lshr i32 %86, %sub.i, !dbg !282
  %or.i62 = or i32 %shl.i61, %shr.i, !dbg !283
  %xor49 = xor i32 %xor47, %or.i62, !dbg !284
  store i32 %xor49, i32* %t, align 4, !dbg !285
  %88 = load i32, i32* %t, align 4, !dbg !286
  %89 = load i32, i32* %i, align 4, !dbg !287
  %rem50 = srem i32 %89, 4, !dbg !288
  %idxprom51 = sext i32 %rem50 to i64, !dbg !289
  %arrayidx52 = getelementptr inbounds [4 x i32], [4 x i32]* %K, i64 0, i64 %idxprom51, !dbg !289
  %90 = load i32, i32* %arrayidx52, align 4, !dbg !290
  %xor53 = xor i32 %90, %88, !dbg !290
  store i32 %xor53, i32* %arrayidx52, align 4, !dbg !290
  %91 = load i32, i32* %i, align 4, !dbg !291
  %rem54 = srem i32 %91, 4, !dbg !292
  %idxprom55 = sext i32 %rem54 to i64, !dbg !293
  %arrayidx56 = getelementptr inbounds [4 x i32], [4 x i32]* %K, i64 0, i64 %idxprom55, !dbg !293
  %92 = load i32, i32* %arrayidx56, align 4, !dbg !293
  %93 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !294
  %rk = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %93, i32 0, i32 0, !dbg !295
  %94 = load i32, i32* %i, align 4, !dbg !296
  %idxprom57 = sext i32 %94 to i64, !dbg !294
  %arrayidx58 = getelementptr inbounds [32 x i32], [32 x i32]* %rk, i64 0, i64 %idxprom57, !dbg !294
  store i32 %92, i32* %arrayidx58, align 4, !dbg !297
  br label %for.inc, !dbg !298

for.inc:                                          ; preds = %for.body
  %95 = load i32, i32* %i, align 4, !dbg !299
  %inc = add nsw i32 %95, 1, !dbg !299
  store i32 %inc, i32* %i, align 4, !dbg !299
  br label %for.cond, !dbg !300, !llvm.loop !301

for.end:                                          ; preds = %for.cond
  ret i32 1, !dbg !303
}

; Function Attrs: nounwind readnone speculatable willreturn
declare void @llvm.dbg.declare(metadata, metadata, metadata) #1

; Function Attrs: alwaysinline nounwind uwtable
define dso_local void @SM4_encrypt(i8* %in, i8* %out, %struct.SM4_KEY_st* %ks) #0 !dbg !304 {
entry:
  %b.addr.i1797 = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i1797, metadata !53, metadata !DIExpression()), !dbg !310
  %n.addr.i1798 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %n.addr.i1798, metadata !59, metadata !DIExpression()), !dbg !312
  %b.addr.i1770 = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i1770, metadata !53, metadata !DIExpression()), !dbg !313
  %n.addr.i1771 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %n.addr.i1771, metadata !59, metadata !DIExpression()), !dbg !315
  %b.addr.i1743 = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i1743, metadata !53, metadata !DIExpression()), !dbg !316
  %n.addr.i1744 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %n.addr.i1744, metadata !59, metadata !DIExpression()), !dbg !318
  %a.addr.i43.i1679 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i1679, metadata !67, metadata !DIExpression()), !dbg !319
  %n.addr.i44.i1680 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i1680, metadata !76, metadata !DIExpression()), !dbg !326
  %a.addr.i35.i1681 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i1681, metadata !67, metadata !DIExpression()), !dbg !327
  %n.addr.i36.i1682 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i1682, metadata !76, metadata !DIExpression()), !dbg !329
  %a.addr.i27.i1683 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i1683, metadata !67, metadata !DIExpression()), !dbg !330
  %n.addr.i28.i1684 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i1684, metadata !76, metadata !DIExpression()), !dbg !332
  %a.addr.i.i1685 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1685, metadata !67, metadata !DIExpression()), !dbg !333
  %n.addr.i.i1686 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1686, metadata !76, metadata !DIExpression()), !dbg !335
  %X.addr.i1687 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1687, metadata !336, metadata !DIExpression()), !dbg !337
  %t.i1688 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i1688, metadata !338, metadata !DIExpression()), !dbg !339
  %a.addr.i43.i1615 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i1615, metadata !67, metadata !DIExpression()), !dbg !340
  %n.addr.i44.i1616 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i1616, metadata !76, metadata !DIExpression()), !dbg !343
  %a.addr.i35.i1617 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i1617, metadata !67, metadata !DIExpression()), !dbg !344
  %n.addr.i36.i1618 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i1618, metadata !76, metadata !DIExpression()), !dbg !346
  %a.addr.i27.i1619 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i1619, metadata !67, metadata !DIExpression()), !dbg !347
  %n.addr.i28.i1620 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i1620, metadata !76, metadata !DIExpression()), !dbg !349
  %a.addr.i.i1621 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1621, metadata !67, metadata !DIExpression()), !dbg !350
  %n.addr.i.i1622 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1622, metadata !76, metadata !DIExpression()), !dbg !352
  %X.addr.i1623 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1623, metadata !336, metadata !DIExpression()), !dbg !353
  %t.i1624 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i1624, metadata !338, metadata !DIExpression()), !dbg !354
  %a.addr.i43.i1551 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i1551, metadata !67, metadata !DIExpression()), !dbg !355
  %n.addr.i44.i1552 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i1552, metadata !76, metadata !DIExpression()), !dbg !358
  %a.addr.i35.i1553 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i1553, metadata !67, metadata !DIExpression()), !dbg !359
  %n.addr.i36.i1554 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i1554, metadata !76, metadata !DIExpression()), !dbg !361
  %a.addr.i27.i1555 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i1555, metadata !67, metadata !DIExpression()), !dbg !362
  %n.addr.i28.i1556 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i1556, metadata !76, metadata !DIExpression()), !dbg !364
  %a.addr.i.i1557 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1557, metadata !67, metadata !DIExpression()), !dbg !365
  %n.addr.i.i1558 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1558, metadata !76, metadata !DIExpression()), !dbg !367
  %X.addr.i1559 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1559, metadata !336, metadata !DIExpression()), !dbg !368
  %t.i1560 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i1560, metadata !338, metadata !DIExpression()), !dbg !369
  %a.addr.i43.i1487 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i1487, metadata !67, metadata !DIExpression()), !dbg !370
  %n.addr.i44.i1488 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i1488, metadata !76, metadata !DIExpression()), !dbg !373
  %a.addr.i35.i1489 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i1489, metadata !67, metadata !DIExpression()), !dbg !374
  %n.addr.i36.i1490 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i1490, metadata !76, metadata !DIExpression()), !dbg !376
  %a.addr.i27.i1491 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i1491, metadata !67, metadata !DIExpression()), !dbg !377
  %n.addr.i28.i1492 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i1492, metadata !76, metadata !DIExpression()), !dbg !379
  %a.addr.i.i1493 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1493, metadata !67, metadata !DIExpression()), !dbg !380
  %n.addr.i.i1494 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1494, metadata !76, metadata !DIExpression()), !dbg !382
  %X.addr.i1495 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1495, metadata !336, metadata !DIExpression()), !dbg !383
  %t.i1496 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i1496, metadata !338, metadata !DIExpression()), !dbg !384
  %a.addr.i24.i1444 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1444, metadata !67, metadata !DIExpression()), !dbg !385
  %n.addr.i25.i1445 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1445, metadata !76, metadata !DIExpression()), !dbg !390
  %a.addr.i16.i1446 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1446, metadata !67, metadata !DIExpression()), !dbg !391
  %n.addr.i17.i1447 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1447, metadata !76, metadata !DIExpression()), !dbg !393
  %a.addr.i.i1448 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1448, metadata !67, metadata !DIExpression()), !dbg !394
  %n.addr.i.i1449 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1449, metadata !76, metadata !DIExpression()), !dbg !396
  %X.addr.i1450 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1450, metadata !397, metadata !DIExpression()), !dbg !398
  %a.addr.i24.i1401 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1401, metadata !67, metadata !DIExpression()), !dbg !399
  %n.addr.i25.i1402 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1402, metadata !76, metadata !DIExpression()), !dbg !402
  %a.addr.i16.i1403 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1403, metadata !67, metadata !DIExpression()), !dbg !403
  %n.addr.i17.i1404 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1404, metadata !76, metadata !DIExpression()), !dbg !405
  %a.addr.i.i1405 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1405, metadata !67, metadata !DIExpression()), !dbg !406
  %n.addr.i.i1406 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1406, metadata !76, metadata !DIExpression()), !dbg !408
  %X.addr.i1407 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1407, metadata !397, metadata !DIExpression()), !dbg !409
  %a.addr.i24.i1358 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1358, metadata !67, metadata !DIExpression()), !dbg !410
  %n.addr.i25.i1359 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1359, metadata !76, metadata !DIExpression()), !dbg !413
  %a.addr.i16.i1360 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1360, metadata !67, metadata !DIExpression()), !dbg !414
  %n.addr.i17.i1361 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1361, metadata !76, metadata !DIExpression()), !dbg !416
  %a.addr.i.i1362 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1362, metadata !67, metadata !DIExpression()), !dbg !417
  %n.addr.i.i1363 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1363, metadata !76, metadata !DIExpression()), !dbg !419
  %X.addr.i1364 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1364, metadata !397, metadata !DIExpression()), !dbg !420
  %a.addr.i24.i1315 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1315, metadata !67, metadata !DIExpression()), !dbg !421
  %n.addr.i25.i1316 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1316, metadata !76, metadata !DIExpression()), !dbg !424
  %a.addr.i16.i1317 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1317, metadata !67, metadata !DIExpression()), !dbg !425
  %n.addr.i17.i1318 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1318, metadata !76, metadata !DIExpression()), !dbg !427
  %a.addr.i.i1319 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1319, metadata !67, metadata !DIExpression()), !dbg !428
  %n.addr.i.i1320 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1320, metadata !76, metadata !DIExpression()), !dbg !430
  %X.addr.i1321 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1321, metadata !397, metadata !DIExpression()), !dbg !431
  %a.addr.i24.i1272 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1272, metadata !67, metadata !DIExpression()), !dbg !432
  %n.addr.i25.i1273 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1273, metadata !76, metadata !DIExpression()), !dbg !436
  %a.addr.i16.i1274 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1274, metadata !67, metadata !DIExpression()), !dbg !437
  %n.addr.i17.i1275 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1275, metadata !76, metadata !DIExpression()), !dbg !439
  %a.addr.i.i1276 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1276, metadata !67, metadata !DIExpression()), !dbg !440
  %n.addr.i.i1277 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1277, metadata !76, metadata !DIExpression()), !dbg !442
  %X.addr.i1278 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1278, metadata !397, metadata !DIExpression()), !dbg !443
  %a.addr.i24.i1229 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1229, metadata !67, metadata !DIExpression()), !dbg !444
  %n.addr.i25.i1230 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1230, metadata !76, metadata !DIExpression()), !dbg !447
  %a.addr.i16.i1231 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1231, metadata !67, metadata !DIExpression()), !dbg !448
  %n.addr.i17.i1232 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1232, metadata !76, metadata !DIExpression()), !dbg !450
  %a.addr.i.i1233 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1233, metadata !67, metadata !DIExpression()), !dbg !451
  %n.addr.i.i1234 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1234, metadata !76, metadata !DIExpression()), !dbg !453
  %X.addr.i1235 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1235, metadata !397, metadata !DIExpression()), !dbg !454
  %a.addr.i24.i1186 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1186, metadata !67, metadata !DIExpression()), !dbg !455
  %n.addr.i25.i1187 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1187, metadata !76, metadata !DIExpression()), !dbg !458
  %a.addr.i16.i1188 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1188, metadata !67, metadata !DIExpression()), !dbg !459
  %n.addr.i17.i1189 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1189, metadata !76, metadata !DIExpression()), !dbg !461
  %a.addr.i.i1190 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1190, metadata !67, metadata !DIExpression()), !dbg !462
  %n.addr.i.i1191 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1191, metadata !76, metadata !DIExpression()), !dbg !464
  %X.addr.i1192 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1192, metadata !397, metadata !DIExpression()), !dbg !465
  %a.addr.i24.i1143 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1143, metadata !67, metadata !DIExpression()), !dbg !466
  %n.addr.i25.i1144 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1144, metadata !76, metadata !DIExpression()), !dbg !469
  %a.addr.i16.i1145 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1145, metadata !67, metadata !DIExpression()), !dbg !470
  %n.addr.i17.i1146 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1146, metadata !76, metadata !DIExpression()), !dbg !472
  %a.addr.i.i1147 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1147, metadata !67, metadata !DIExpression()), !dbg !473
  %n.addr.i.i1148 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1148, metadata !76, metadata !DIExpression()), !dbg !475
  %X.addr.i1149 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1149, metadata !397, metadata !DIExpression()), !dbg !476
  %a.addr.i24.i1100 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1100, metadata !67, metadata !DIExpression()), !dbg !477
  %n.addr.i25.i1101 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1101, metadata !76, metadata !DIExpression()), !dbg !481
  %a.addr.i16.i1102 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1102, metadata !67, metadata !DIExpression()), !dbg !482
  %n.addr.i17.i1103 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1103, metadata !76, metadata !DIExpression()), !dbg !484
  %a.addr.i.i1104 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1104, metadata !67, metadata !DIExpression()), !dbg !485
  %n.addr.i.i1105 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1105, metadata !76, metadata !DIExpression()), !dbg !487
  %X.addr.i1106 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1106, metadata !397, metadata !DIExpression()), !dbg !488
  %a.addr.i24.i1057 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1057, metadata !67, metadata !DIExpression()), !dbg !489
  %n.addr.i25.i1058 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1058, metadata !76, metadata !DIExpression()), !dbg !492
  %a.addr.i16.i1059 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1059, metadata !67, metadata !DIExpression()), !dbg !493
  %n.addr.i17.i1060 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1060, metadata !76, metadata !DIExpression()), !dbg !495
  %a.addr.i.i1061 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1061, metadata !67, metadata !DIExpression()), !dbg !496
  %n.addr.i.i1062 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1062, metadata !76, metadata !DIExpression()), !dbg !498
  %X.addr.i1063 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1063, metadata !397, metadata !DIExpression()), !dbg !499
  %a.addr.i24.i1014 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1014, metadata !67, metadata !DIExpression()), !dbg !500
  %n.addr.i25.i1015 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1015, metadata !76, metadata !DIExpression()), !dbg !503
  %a.addr.i16.i1016 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1016, metadata !67, metadata !DIExpression()), !dbg !504
  %n.addr.i17.i1017 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1017, metadata !76, metadata !DIExpression()), !dbg !506
  %a.addr.i.i1018 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1018, metadata !67, metadata !DIExpression()), !dbg !507
  %n.addr.i.i1019 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1019, metadata !76, metadata !DIExpression()), !dbg !509
  %X.addr.i1020 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1020, metadata !397, metadata !DIExpression()), !dbg !510
  %a.addr.i24.i971 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i971, metadata !67, metadata !DIExpression()), !dbg !511
  %n.addr.i25.i972 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i972, metadata !76, metadata !DIExpression()), !dbg !514
  %a.addr.i16.i973 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i973, metadata !67, metadata !DIExpression()), !dbg !515
  %n.addr.i17.i974 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i974, metadata !76, metadata !DIExpression()), !dbg !517
  %a.addr.i.i975 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i975, metadata !67, metadata !DIExpression()), !dbg !518
  %n.addr.i.i976 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i976, metadata !76, metadata !DIExpression()), !dbg !520
  %X.addr.i977 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i977, metadata !397, metadata !DIExpression()), !dbg !521
  %a.addr.i24.i928 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i928, metadata !67, metadata !DIExpression()), !dbg !522
  %n.addr.i25.i929 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i929, metadata !76, metadata !DIExpression()), !dbg !526
  %a.addr.i16.i930 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i930, metadata !67, metadata !DIExpression()), !dbg !527
  %n.addr.i17.i931 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i931, metadata !76, metadata !DIExpression()), !dbg !529
  %a.addr.i.i932 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i932, metadata !67, metadata !DIExpression()), !dbg !530
  %n.addr.i.i933 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i933, metadata !76, metadata !DIExpression()), !dbg !532
  %X.addr.i934 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i934, metadata !397, metadata !DIExpression()), !dbg !533
  %a.addr.i24.i885 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i885, metadata !67, metadata !DIExpression()), !dbg !534
  %n.addr.i25.i886 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i886, metadata !76, metadata !DIExpression()), !dbg !537
  %a.addr.i16.i887 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i887, metadata !67, metadata !DIExpression()), !dbg !538
  %n.addr.i17.i888 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i888, metadata !76, metadata !DIExpression()), !dbg !540
  %a.addr.i.i889 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i889, metadata !67, metadata !DIExpression()), !dbg !541
  %n.addr.i.i890 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i890, metadata !76, metadata !DIExpression()), !dbg !543
  %X.addr.i891 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i891, metadata !397, metadata !DIExpression()), !dbg !544
  %a.addr.i24.i842 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i842, metadata !67, metadata !DIExpression()), !dbg !545
  %n.addr.i25.i843 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i843, metadata !76, metadata !DIExpression()), !dbg !548
  %a.addr.i16.i844 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i844, metadata !67, metadata !DIExpression()), !dbg !549
  %n.addr.i17.i845 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i845, metadata !76, metadata !DIExpression()), !dbg !551
  %a.addr.i.i846 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i846, metadata !67, metadata !DIExpression()), !dbg !552
  %n.addr.i.i847 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i847, metadata !76, metadata !DIExpression()), !dbg !554
  %X.addr.i848 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i848, metadata !397, metadata !DIExpression()), !dbg !555
  %a.addr.i24.i799 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i799, metadata !67, metadata !DIExpression()), !dbg !556
  %n.addr.i25.i800 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i800, metadata !76, metadata !DIExpression()), !dbg !559
  %a.addr.i16.i801 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i801, metadata !67, metadata !DIExpression()), !dbg !560
  %n.addr.i17.i802 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i802, metadata !76, metadata !DIExpression()), !dbg !562
  %a.addr.i.i803 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i803, metadata !67, metadata !DIExpression()), !dbg !563
  %n.addr.i.i804 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i804, metadata !76, metadata !DIExpression()), !dbg !565
  %X.addr.i805 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i805, metadata !397, metadata !DIExpression()), !dbg !566
  %a.addr.i24.i756 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i756, metadata !67, metadata !DIExpression()), !dbg !567
  %n.addr.i25.i757 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i757, metadata !76, metadata !DIExpression()), !dbg !571
  %a.addr.i16.i758 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i758, metadata !67, metadata !DIExpression()), !dbg !572
  %n.addr.i17.i759 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i759, metadata !76, metadata !DIExpression()), !dbg !574
  %a.addr.i.i760 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i760, metadata !67, metadata !DIExpression()), !dbg !575
  %n.addr.i.i761 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i761, metadata !76, metadata !DIExpression()), !dbg !577
  %X.addr.i762 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i762, metadata !397, metadata !DIExpression()), !dbg !578
  %a.addr.i24.i713 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i713, metadata !67, metadata !DIExpression()), !dbg !579
  %n.addr.i25.i714 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i714, metadata !76, metadata !DIExpression()), !dbg !582
  %a.addr.i16.i715 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i715, metadata !67, metadata !DIExpression()), !dbg !583
  %n.addr.i17.i716 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i716, metadata !76, metadata !DIExpression()), !dbg !585
  %a.addr.i.i717 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i717, metadata !67, metadata !DIExpression()), !dbg !586
  %n.addr.i.i718 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i718, metadata !76, metadata !DIExpression()), !dbg !588
  %X.addr.i719 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i719, metadata !397, metadata !DIExpression()), !dbg !589
  %a.addr.i24.i670 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i670, metadata !67, metadata !DIExpression()), !dbg !590
  %n.addr.i25.i671 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i671, metadata !76, metadata !DIExpression()), !dbg !593
  %a.addr.i16.i672 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i672, metadata !67, metadata !DIExpression()), !dbg !594
  %n.addr.i17.i673 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i673, metadata !76, metadata !DIExpression()), !dbg !596
  %a.addr.i.i674 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i674, metadata !67, metadata !DIExpression()), !dbg !597
  %n.addr.i.i675 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i675, metadata !76, metadata !DIExpression()), !dbg !599
  %X.addr.i676 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i676, metadata !397, metadata !DIExpression()), !dbg !600
  %a.addr.i24.i627 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i627, metadata !67, metadata !DIExpression()), !dbg !601
  %n.addr.i25.i628 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i628, metadata !76, metadata !DIExpression()), !dbg !604
  %a.addr.i16.i629 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i629, metadata !67, metadata !DIExpression()), !dbg !605
  %n.addr.i17.i630 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i630, metadata !76, metadata !DIExpression()), !dbg !607
  %a.addr.i.i631 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i631, metadata !67, metadata !DIExpression()), !dbg !608
  %n.addr.i.i632 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i632, metadata !76, metadata !DIExpression()), !dbg !610
  %X.addr.i633 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i633, metadata !397, metadata !DIExpression()), !dbg !611
  %a.addr.i24.i584 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i584, metadata !67, metadata !DIExpression()), !dbg !612
  %n.addr.i25.i585 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i585, metadata !76, metadata !DIExpression()), !dbg !616
  %a.addr.i16.i586 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i586, metadata !67, metadata !DIExpression()), !dbg !617
  %n.addr.i17.i587 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i587, metadata !76, metadata !DIExpression()), !dbg !619
  %a.addr.i.i588 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i588, metadata !67, metadata !DIExpression()), !dbg !620
  %n.addr.i.i589 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i589, metadata !76, metadata !DIExpression()), !dbg !622
  %X.addr.i590 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i590, metadata !397, metadata !DIExpression()), !dbg !623
  %a.addr.i24.i541 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i541, metadata !67, metadata !DIExpression()), !dbg !624
  %n.addr.i25.i542 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i542, metadata !76, metadata !DIExpression()), !dbg !627
  %a.addr.i16.i543 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i543, metadata !67, metadata !DIExpression()), !dbg !628
  %n.addr.i17.i544 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i544, metadata !76, metadata !DIExpression()), !dbg !630
  %a.addr.i.i545 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i545, metadata !67, metadata !DIExpression()), !dbg !631
  %n.addr.i.i546 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i546, metadata !76, metadata !DIExpression()), !dbg !633
  %X.addr.i547 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i547, metadata !397, metadata !DIExpression()), !dbg !634
  %a.addr.i24.i498 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i498, metadata !67, metadata !DIExpression()), !dbg !635
  %n.addr.i25.i499 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i499, metadata !76, metadata !DIExpression()), !dbg !638
  %a.addr.i16.i500 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i500, metadata !67, metadata !DIExpression()), !dbg !639
  %n.addr.i17.i501 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i501, metadata !76, metadata !DIExpression()), !dbg !641
  %a.addr.i.i502 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i502, metadata !67, metadata !DIExpression()), !dbg !642
  %n.addr.i.i503 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i503, metadata !76, metadata !DIExpression()), !dbg !644
  %X.addr.i504 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i504, metadata !397, metadata !DIExpression()), !dbg !645
  %a.addr.i24.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i, metadata !67, metadata !DIExpression()), !dbg !646
  %n.addr.i25.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i, metadata !76, metadata !DIExpression()), !dbg !649
  %a.addr.i16.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i, metadata !67, metadata !DIExpression()), !dbg !650
  %n.addr.i17.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i, metadata !76, metadata !DIExpression()), !dbg !652
  %a.addr.i.i480 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i480, metadata !67, metadata !DIExpression()), !dbg !653
  %n.addr.i.i481 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i481, metadata !76, metadata !DIExpression()), !dbg !655
  %X.addr.i482 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i482, metadata !397, metadata !DIExpression()), !dbg !656
  %a.addr.i43.i416 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i416, metadata !67, metadata !DIExpression()), !dbg !657
  %n.addr.i44.i417 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i417, metadata !76, metadata !DIExpression()), !dbg !661
  %a.addr.i35.i418 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i418, metadata !67, metadata !DIExpression()), !dbg !662
  %n.addr.i36.i419 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i419, metadata !76, metadata !DIExpression()), !dbg !664
  %a.addr.i27.i420 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i420, metadata !67, metadata !DIExpression()), !dbg !665
  %n.addr.i28.i421 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i421, metadata !76, metadata !DIExpression()), !dbg !667
  %a.addr.i.i422 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i422, metadata !67, metadata !DIExpression()), !dbg !668
  %n.addr.i.i423 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i423, metadata !76, metadata !DIExpression()), !dbg !670
  %X.addr.i424 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i424, metadata !336, metadata !DIExpression()), !dbg !671
  %t.i425 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i425, metadata !338, metadata !DIExpression()), !dbg !672
  %a.addr.i43.i352 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i352, metadata !67, metadata !DIExpression()), !dbg !673
  %n.addr.i44.i353 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i353, metadata !76, metadata !DIExpression()), !dbg !676
  %a.addr.i35.i354 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i354, metadata !67, metadata !DIExpression()), !dbg !677
  %n.addr.i36.i355 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i355, metadata !76, metadata !DIExpression()), !dbg !679
  %a.addr.i27.i356 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i356, metadata !67, metadata !DIExpression()), !dbg !680
  %n.addr.i28.i357 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i357, metadata !76, metadata !DIExpression()), !dbg !682
  %a.addr.i.i358 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i358, metadata !67, metadata !DIExpression()), !dbg !683
  %n.addr.i.i359 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i359, metadata !76, metadata !DIExpression()), !dbg !685
  %X.addr.i360 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i360, metadata !336, metadata !DIExpression()), !dbg !686
  %t.i361 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i361, metadata !338, metadata !DIExpression()), !dbg !687
  %a.addr.i43.i288 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i288, metadata !67, metadata !DIExpression()), !dbg !688
  %n.addr.i44.i289 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i289, metadata !76, metadata !DIExpression()), !dbg !691
  %a.addr.i35.i290 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i290, metadata !67, metadata !DIExpression()), !dbg !692
  %n.addr.i36.i291 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i291, metadata !76, metadata !DIExpression()), !dbg !694
  %a.addr.i27.i292 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i292, metadata !67, metadata !DIExpression()), !dbg !695
  %n.addr.i28.i293 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i293, metadata !76, metadata !DIExpression()), !dbg !697
  %a.addr.i.i294 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i294, metadata !67, metadata !DIExpression()), !dbg !698
  %n.addr.i.i295 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i295, metadata !76, metadata !DIExpression()), !dbg !700
  %X.addr.i296 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i296, metadata !336, metadata !DIExpression()), !dbg !701
  %t.i297 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i297, metadata !338, metadata !DIExpression()), !dbg !702
  %a.addr.i43.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i, metadata !67, metadata !DIExpression()), !dbg !703
  %n.addr.i44.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i, metadata !76, metadata !DIExpression()), !dbg !706
  %a.addr.i35.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i, metadata !67, metadata !DIExpression()), !dbg !707
  %n.addr.i36.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i, metadata !76, metadata !DIExpression()), !dbg !709
  %a.addr.i27.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i, metadata !67, metadata !DIExpression()), !dbg !710
  %n.addr.i28.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i, metadata !76, metadata !DIExpression()), !dbg !712
  %a.addr.i.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i, metadata !67, metadata !DIExpression()), !dbg !713
  %n.addr.i.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i, metadata !76, metadata !DIExpression()), !dbg !715
  %X.addr.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i, metadata !336, metadata !DIExpression()), !dbg !716
  %t.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i, metadata !338, metadata !DIExpression()), !dbg !717
  %v.addr.i269 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %v.addr.i269, metadata !718, metadata !DIExpression()), !dbg !722
  %b.addr.i270 = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i270, metadata !724, metadata !DIExpression()), !dbg !725
  %v.addr.i257 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %v.addr.i257, metadata !718, metadata !DIExpression()), !dbg !726
  %b.addr.i258 = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i258, metadata !724, metadata !DIExpression()), !dbg !728
  %v.addr.i245 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %v.addr.i245, metadata !718, metadata !DIExpression()), !dbg !729
  %b.addr.i246 = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i246, metadata !724, metadata !DIExpression()), !dbg !731
  %v.addr.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %v.addr.i, metadata !718, metadata !DIExpression()), !dbg !732
  %b.addr.i242 = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i242, metadata !724, metadata !DIExpression()), !dbg !734
  %b.addr.i = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i, metadata !53, metadata !DIExpression()), !dbg !735
  %n.addr.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %n.addr.i, metadata !59, metadata !DIExpression()), !dbg !737
  %in.addr = alloca i8*, align 8
  %out.addr = alloca i8*, align 8
  %ks.addr = alloca %struct.SM4_KEY_st*, align 8
  %B0 = alloca i32, align 4
  %B1 = alloca i32, align 4
  %B2 = alloca i32, align 4
  %B3 = alloca i32, align 4
  store i8* %in, i8** %in.addr, align 8
  call void @llvm.dbg.declare(metadata i8** %in.addr, metadata !738, metadata !DIExpression()), !dbg !739
  store i8* %out, i8** %out.addr, align 8
  call void @llvm.dbg.declare(metadata i8** %out.addr, metadata !740, metadata !DIExpression()), !dbg !741
  store %struct.SM4_KEY_st* %ks, %struct.SM4_KEY_st** %ks.addr, align 8
  call void @llvm.dbg.declare(metadata %struct.SM4_KEY_st** %ks.addr, metadata !742, metadata !DIExpression()), !dbg !743
  %ks.addr1 = bitcast %struct.SM4_KEY_st** %ks.addr to i8*
  call void @llvm.var.annotation(i8* %ks.addr1, i8* getelementptr inbounds ([5 x i8], [5 x i8]* @.str, i32 0, i32 0), i8* getelementptr inbounds ([13 x i8], [13 x i8]* @.str.1, i32 0, i32 0), i32 189)
  call void @llvm.dbg.declare(metadata i32* %B0, metadata !744, metadata !DIExpression()), !dbg !745
  %0 = load i8*, i8** %in.addr, align 8, !dbg !746
  store i8* %0, i8** %b.addr.i, align 8
  store i32 0, i32* %n.addr.i, align 4
  %1 = load i8*, i8** %b.addr.i, align 8, !dbg !747
  %2 = load i32, i32* %n.addr.i, align 4, !dbg !748
  %mul.i = mul i32 4, %2, !dbg !749
  %idxprom.i = zext i32 %mul.i to i64, !dbg !747
  %arrayidx.i = getelementptr inbounds i8, i8* %1, i64 %idxprom.i, !dbg !747
  %3 = load i8, i8* %arrayidx.i, align 1, !dbg !747
  %conv.i = zext i8 %3 to i32, !dbg !750
  %shl.i = shl i32 %conv.i, 24, !dbg !751
  %4 = load i8*, i8** %b.addr.i, align 8, !dbg !752
  %5 = load i32, i32* %n.addr.i, align 4, !dbg !753
  %mul1.i = mul i32 4, %5, !dbg !754
  %add.i = add i32 %mul1.i, 1, !dbg !755
  %idxprom2.i = zext i32 %add.i to i64, !dbg !752
  %arrayidx3.i = getelementptr inbounds i8, i8* %4, i64 %idxprom2.i, !dbg !752
  %6 = load i8, i8* %arrayidx3.i, align 1, !dbg !752
  %conv4.i = zext i8 %6 to i32, !dbg !756
  %shl5.i = shl i32 %conv4.i, 16, !dbg !757
  %or.i = or i32 %shl.i, %shl5.i, !dbg !758
  %7 = load i8*, i8** %b.addr.i, align 8, !dbg !759
  %8 = load i32, i32* %n.addr.i, align 4, !dbg !760
  %mul6.i = mul i32 4, %8, !dbg !761
  %add7.i = add i32 %mul6.i, 2, !dbg !762
  %idxprom8.i = zext i32 %add7.i to i64, !dbg !759
  %arrayidx9.i = getelementptr inbounds i8, i8* %7, i64 %idxprom8.i, !dbg !759
  %9 = load i8, i8* %arrayidx9.i, align 1, !dbg !759
  %conv10.i = zext i8 %9 to i32, !dbg !763
  %shl11.i = shl i32 %conv10.i, 8, !dbg !764
  %or12.i = or i32 %or.i, %shl11.i, !dbg !765
  %10 = load i8*, i8** %b.addr.i, align 8, !dbg !766
  %11 = load i32, i32* %n.addr.i, align 4, !dbg !767
  %mul13.i = mul i32 4, %11, !dbg !768
  %add14.i = add i32 %mul13.i, 3, !dbg !769
  %idxprom15.i = zext i32 %add14.i to i64, !dbg !766
  %arrayidx16.i = getelementptr inbounds i8, i8* %10, i64 %idxprom15.i, !dbg !766
  %12 = load i8, i8* %arrayidx16.i, align 1, !dbg !766
  %conv17.i = zext i8 %12 to i32, !dbg !770
  %or18.i = or i32 %or12.i, %conv17.i, !dbg !771
  store i32 %or18.i, i32* %B0, align 4, !dbg !745
  call void @llvm.dbg.declare(metadata i32* %B1, metadata !772, metadata !DIExpression()), !dbg !773
  %13 = load i8*, i8** %in.addr, align 8, !dbg !774
  store i8* %13, i8** %b.addr.i1797, align 8
  store i32 1, i32* %n.addr.i1798, align 4
  %14 = load i8*, i8** %b.addr.i1797, align 8, !dbg !775
  %15 = load i32, i32* %n.addr.i1798, align 4, !dbg !776
  %mul.i1799 = mul i32 4, %15, !dbg !777
  %idxprom.i1800 = zext i32 %mul.i1799 to i64, !dbg !775
  %arrayidx.i1801 = getelementptr inbounds i8, i8* %14, i64 %idxprom.i1800, !dbg !775
  %16 = load i8, i8* %arrayidx.i1801, align 1, !dbg !775
  %conv.i1802 = zext i8 %16 to i32, !dbg !778
  %shl.i1803 = shl i32 %conv.i1802, 24, !dbg !779
  %17 = load i8*, i8** %b.addr.i1797, align 8, !dbg !780
  %18 = load i32, i32* %n.addr.i1798, align 4, !dbg !781
  %mul1.i1804 = mul i32 4, %18, !dbg !782
  %add.i1805 = add i32 %mul1.i1804, 1, !dbg !783
  %idxprom2.i1806 = zext i32 %add.i1805 to i64, !dbg !780
  %arrayidx3.i1807 = getelementptr inbounds i8, i8* %17, i64 %idxprom2.i1806, !dbg !780
  %19 = load i8, i8* %arrayidx3.i1807, align 1, !dbg !780
  %conv4.i1808 = zext i8 %19 to i32, !dbg !784
  %shl5.i1809 = shl i32 %conv4.i1808, 16, !dbg !785
  %or.i1810 = or i32 %shl.i1803, %shl5.i1809, !dbg !786
  %20 = load i8*, i8** %b.addr.i1797, align 8, !dbg !787
  %21 = load i32, i32* %n.addr.i1798, align 4, !dbg !788
  %mul6.i1811 = mul i32 4, %21, !dbg !789
  %add7.i1812 = add i32 %mul6.i1811, 2, !dbg !790
  %idxprom8.i1813 = zext i32 %add7.i1812 to i64, !dbg !787
  %arrayidx9.i1814 = getelementptr inbounds i8, i8* %20, i64 %idxprom8.i1813, !dbg !787
  %22 = load i8, i8* %arrayidx9.i1814, align 1, !dbg !787
  %conv10.i1815 = zext i8 %22 to i32, !dbg !791
  %shl11.i1816 = shl i32 %conv10.i1815, 8, !dbg !792
  %or12.i1817 = or i32 %or.i1810, %shl11.i1816, !dbg !793
  %23 = load i8*, i8** %b.addr.i1797, align 8, !dbg !794
  %24 = load i32, i32* %n.addr.i1798, align 4, !dbg !795
  %mul13.i1818 = mul i32 4, %24, !dbg !796
  %add14.i1819 = add i32 %mul13.i1818, 3, !dbg !797
  %idxprom15.i1820 = zext i32 %add14.i1819 to i64, !dbg !794
  %arrayidx16.i1821 = getelementptr inbounds i8, i8* %23, i64 %idxprom15.i1820, !dbg !794
  %25 = load i8, i8* %arrayidx16.i1821, align 1, !dbg !794
  %conv17.i1822 = zext i8 %25 to i32, !dbg !798
  %or18.i1823 = or i32 %or12.i1817, %conv17.i1822, !dbg !799
  store i32 %or18.i1823, i32* %B1, align 4, !dbg !773
  call void @llvm.dbg.declare(metadata i32* %B2, metadata !800, metadata !DIExpression()), !dbg !801
  %26 = load i8*, i8** %in.addr, align 8, !dbg !802
  store i8* %26, i8** %b.addr.i1770, align 8
  store i32 2, i32* %n.addr.i1771, align 4
  %27 = load i8*, i8** %b.addr.i1770, align 8, !dbg !803
  %28 = load i32, i32* %n.addr.i1771, align 4, !dbg !804
  %mul.i1772 = mul i32 4, %28, !dbg !805
  %idxprom.i1773 = zext i32 %mul.i1772 to i64, !dbg !803
  %arrayidx.i1774 = getelementptr inbounds i8, i8* %27, i64 %idxprom.i1773, !dbg !803
  %29 = load i8, i8* %arrayidx.i1774, align 1, !dbg !803
  %conv.i1775 = zext i8 %29 to i32, !dbg !806
  %shl.i1776 = shl i32 %conv.i1775, 24, !dbg !807
  %30 = load i8*, i8** %b.addr.i1770, align 8, !dbg !808
  %31 = load i32, i32* %n.addr.i1771, align 4, !dbg !809
  %mul1.i1777 = mul i32 4, %31, !dbg !810
  %add.i1778 = add i32 %mul1.i1777, 1, !dbg !811
  %idxprom2.i1779 = zext i32 %add.i1778 to i64, !dbg !808
  %arrayidx3.i1780 = getelementptr inbounds i8, i8* %30, i64 %idxprom2.i1779, !dbg !808
  %32 = load i8, i8* %arrayidx3.i1780, align 1, !dbg !808
  %conv4.i1781 = zext i8 %32 to i32, !dbg !812
  %shl5.i1782 = shl i32 %conv4.i1781, 16, !dbg !813
  %or.i1783 = or i32 %shl.i1776, %shl5.i1782, !dbg !814
  %33 = load i8*, i8** %b.addr.i1770, align 8, !dbg !815
  %34 = load i32, i32* %n.addr.i1771, align 4, !dbg !816
  %mul6.i1784 = mul i32 4, %34, !dbg !817
  %add7.i1785 = add i32 %mul6.i1784, 2, !dbg !818
  %idxprom8.i1786 = zext i32 %add7.i1785 to i64, !dbg !815
  %arrayidx9.i1787 = getelementptr inbounds i8, i8* %33, i64 %idxprom8.i1786, !dbg !815
  %35 = load i8, i8* %arrayidx9.i1787, align 1, !dbg !815
  %conv10.i1788 = zext i8 %35 to i32, !dbg !819
  %shl11.i1789 = shl i32 %conv10.i1788, 8, !dbg !820
  %or12.i1790 = or i32 %or.i1783, %shl11.i1789, !dbg !821
  %36 = load i8*, i8** %b.addr.i1770, align 8, !dbg !822
  %37 = load i32, i32* %n.addr.i1771, align 4, !dbg !823
  %mul13.i1791 = mul i32 4, %37, !dbg !824
  %add14.i1792 = add i32 %mul13.i1791, 3, !dbg !825
  %idxprom15.i1793 = zext i32 %add14.i1792 to i64, !dbg !822
  %arrayidx16.i1794 = getelementptr inbounds i8, i8* %36, i64 %idxprom15.i1793, !dbg !822
  %38 = load i8, i8* %arrayidx16.i1794, align 1, !dbg !822
  %conv17.i1795 = zext i8 %38 to i32, !dbg !826
  %or18.i1796 = or i32 %or12.i1790, %conv17.i1795, !dbg !827
  store i32 %or18.i1796, i32* %B2, align 4, !dbg !801
  call void @llvm.dbg.declare(metadata i32* %B3, metadata !828, metadata !DIExpression()), !dbg !829
  %39 = load i8*, i8** %in.addr, align 8, !dbg !830
  store i8* %39, i8** %b.addr.i1743, align 8
  store i32 3, i32* %n.addr.i1744, align 4
  %40 = load i8*, i8** %b.addr.i1743, align 8, !dbg !831
  %41 = load i32, i32* %n.addr.i1744, align 4, !dbg !832
  %mul.i1745 = mul i32 4, %41, !dbg !833
  %idxprom.i1746 = zext i32 %mul.i1745 to i64, !dbg !831
  %arrayidx.i1747 = getelementptr inbounds i8, i8* %40, i64 %idxprom.i1746, !dbg !831
  %42 = load i8, i8* %arrayidx.i1747, align 1, !dbg !831
  %conv.i1748 = zext i8 %42 to i32, !dbg !834
  %shl.i1749 = shl i32 %conv.i1748, 24, !dbg !835
  %43 = load i8*, i8** %b.addr.i1743, align 8, !dbg !836
  %44 = load i32, i32* %n.addr.i1744, align 4, !dbg !837
  %mul1.i1750 = mul i32 4, %44, !dbg !838
  %add.i1751 = add i32 %mul1.i1750, 1, !dbg !839
  %idxprom2.i1752 = zext i32 %add.i1751 to i64, !dbg !836
  %arrayidx3.i1753 = getelementptr inbounds i8, i8* %43, i64 %idxprom2.i1752, !dbg !836
  %45 = load i8, i8* %arrayidx3.i1753, align 1, !dbg !836
  %conv4.i1754 = zext i8 %45 to i32, !dbg !840
  %shl5.i1755 = shl i32 %conv4.i1754, 16, !dbg !841
  %or.i1756 = or i32 %shl.i1749, %shl5.i1755, !dbg !842
  %46 = load i8*, i8** %b.addr.i1743, align 8, !dbg !843
  %47 = load i32, i32* %n.addr.i1744, align 4, !dbg !844
  %mul6.i1757 = mul i32 4, %47, !dbg !845
  %add7.i1758 = add i32 %mul6.i1757, 2, !dbg !846
  %idxprom8.i1759 = zext i32 %add7.i1758 to i64, !dbg !843
  %arrayidx9.i1760 = getelementptr inbounds i8, i8* %46, i64 %idxprom8.i1759, !dbg !843
  %48 = load i8, i8* %arrayidx9.i1760, align 1, !dbg !843
  %conv10.i1761 = zext i8 %48 to i32, !dbg !847
  %shl11.i1762 = shl i32 %conv10.i1761, 8, !dbg !848
  %or12.i1763 = or i32 %or.i1756, %shl11.i1762, !dbg !849
  %49 = load i8*, i8** %b.addr.i1743, align 8, !dbg !850
  %50 = load i32, i32* %n.addr.i1744, align 4, !dbg !851
  %mul13.i1764 = mul i32 4, %50, !dbg !852
  %add14.i1765 = add i32 %mul13.i1764, 3, !dbg !853
  %idxprom15.i1766 = zext i32 %add14.i1765 to i64, !dbg !850
  %arrayidx16.i1767 = getelementptr inbounds i8, i8* %49, i64 %idxprom15.i1766, !dbg !850
  %51 = load i8, i8* %arrayidx16.i1767, align 1, !dbg !850
  %conv17.i1768 = zext i8 %51 to i32, !dbg !854
  %or18.i1769 = or i32 %or12.i1763, %conv17.i1768, !dbg !855
  store i32 %or18.i1769, i32* %B3, align 4, !dbg !829
  br label %do.body, !dbg !856

do.body:                                          ; preds = %entry
  %52 = load i32, i32* %B1, align 4, !dbg !857
  %53 = load i32, i32* %B2, align 4, !dbg !857
  %xor = xor i32 %52, %53, !dbg !857
  %54 = load i32, i32* %B3, align 4, !dbg !857
  %xor5 = xor i32 %xor, %54, !dbg !857
  %55 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !857
  %rk = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %55, i32 0, i32 0, !dbg !857
  %arrayidx = getelementptr inbounds [32 x i32], [32 x i32]* %rk, i64 0, i64 0, !dbg !857
  %56 = load i32, i32* %arrayidx, align 4, !dbg !857
  %xor6 = xor i32 %xor5, %56, !dbg !857
  store i32 %xor6, i32* %X.addr.i1687, align 4
  store i32 0, i32* %t.i1688, align 4, !dbg !339
  %57 = load i32, i32* %X.addr.i1687, align 4, !dbg !858
  %shr.i1689 = lshr i32 %57, 24, !dbg !859
  %conv.i1690 = trunc i32 %shr.i1689 to i8, !dbg !860
  %idxprom.i1691 = zext i8 %conv.i1690 to i64, !dbg !861
  %arrayidx.i1692 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom.i1691, !dbg !861
  %58 = load i8, i8* %arrayidx.i1692, align 1, !dbg !861
  %conv1.i1693 = zext i8 %58 to i32, !dbg !862
  %shl.i1694 = shl i32 %conv1.i1693, 24, !dbg !863
  %59 = load i32, i32* %t.i1688, align 4, !dbg !864
  %or.i1695 = or i32 %59, %shl.i1694, !dbg !864
  store i32 %or.i1695, i32* %t.i1688, align 4, !dbg !864
  %60 = load i32, i32* %X.addr.i1687, align 4, !dbg !865
  %shr2.i1696 = lshr i32 %60, 16, !dbg !866
  %conv3.i1697 = trunc i32 %shr2.i1696 to i8, !dbg !867
  %idxprom4.i1698 = zext i8 %conv3.i1697 to i64, !dbg !868
  %arrayidx5.i1699 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom4.i1698, !dbg !868
  %61 = load i8, i8* %arrayidx5.i1699, align 1, !dbg !868
  %conv6.i1700 = zext i8 %61 to i32, !dbg !869
  %shl7.i1701 = shl i32 %conv6.i1700, 16, !dbg !870
  %62 = load i32, i32* %t.i1688, align 4, !dbg !871
  %or8.i1702 = or i32 %62, %shl7.i1701, !dbg !871
  store i32 %or8.i1702, i32* %t.i1688, align 4, !dbg !871
  %63 = load i32, i32* %X.addr.i1687, align 4, !dbg !872
  %shr9.i1703 = lshr i32 %63, 8, !dbg !873
  %conv10.i1704 = trunc i32 %shr9.i1703 to i8, !dbg !874
  %idxprom11.i1705 = zext i8 %conv10.i1704 to i64, !dbg !875
  %arrayidx12.i1706 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom11.i1705, !dbg !875
  %64 = load i8, i8* %arrayidx12.i1706, align 1, !dbg !875
  %conv13.i1707 = zext i8 %64 to i32, !dbg !876
  %shl14.i1708 = shl i32 %conv13.i1707, 8, !dbg !877
  %65 = load i32, i32* %t.i1688, align 4, !dbg !878
  %or15.i1709 = or i32 %65, %shl14.i1708, !dbg !878
  store i32 %or15.i1709, i32* %t.i1688, align 4, !dbg !878
  %66 = load i32, i32* %X.addr.i1687, align 4, !dbg !879
  %conv16.i1710 = trunc i32 %66 to i8, !dbg !880
  %idxprom17.i1711 = zext i8 %conv16.i1710 to i64, !dbg !881
  %arrayidx18.i1712 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom17.i1711, !dbg !881
  %67 = load i8, i8* %arrayidx18.i1712, align 1, !dbg !881
  %conv19.i1713 = zext i8 %67 to i32, !dbg !881
  %68 = load i32, i32* %t.i1688, align 4, !dbg !882
  %or20.i1714 = or i32 %68, %conv19.i1713, !dbg !882
  store i32 %or20.i1714, i32* %t.i1688, align 4, !dbg !882
  %69 = load i32, i32* %t.i1688, align 4, !dbg !883
  %70 = load i32, i32* %t.i1688, align 4, !dbg !884
  store i32 %70, i32* %a.addr.i.i1685, align 4
  store i8 2, i8* %n.addr.i.i1686, align 1
  %71 = load i32, i32* %a.addr.i.i1685, align 4, !dbg !885
  %72 = load i8, i8* %n.addr.i.i1686, align 1, !dbg !886
  %conv.i.i1715 = zext i8 %72 to i32, !dbg !886
  %shl.i.i1716 = shl i32 %71, %conv.i.i1715, !dbg !887
  %73 = load i32, i32* %a.addr.i.i1685, align 4, !dbg !888
  %74 = load i8, i8* %n.addr.i.i1686, align 1, !dbg !889
  %conv1.i.i1717 = zext i8 %74 to i32, !dbg !889
  %sub.i.i1718 = sub nsw i32 32, %conv1.i.i1717, !dbg !890
  %shr.i.i1719 = lshr i32 %73, %sub.i.i1718, !dbg !891
  %or.i.i1720 = or i32 %shl.i.i1716, %shr.i.i1719, !dbg !892
  %xor.i1721 = xor i32 %69, %or.i.i1720, !dbg !893
  %75 = load i32, i32* %t.i1688, align 4, !dbg !894
  store i32 %75, i32* %a.addr.i43.i1679, align 4
  store i8 10, i8* %n.addr.i44.i1680, align 1
  %76 = load i32, i32* %a.addr.i43.i1679, align 4, !dbg !895
  %77 = load i8, i8* %n.addr.i44.i1680, align 1, !dbg !896
  %conv.i45.i1722 = zext i8 %77 to i32, !dbg !896
  %shl.i46.i1723 = shl i32 %76, %conv.i45.i1722, !dbg !897
  %78 = load i32, i32* %a.addr.i43.i1679, align 4, !dbg !898
  %79 = load i8, i8* %n.addr.i44.i1680, align 1, !dbg !899
  %conv1.i47.i1724 = zext i8 %79 to i32, !dbg !899
  %sub.i48.i1725 = sub nsw i32 32, %conv1.i47.i1724, !dbg !900
  %shr.i49.i1726 = lshr i32 %78, %sub.i48.i1725, !dbg !901
  %or.i50.i1727 = or i32 %shl.i46.i1723, %shr.i49.i1726, !dbg !902
  %xor22.i1728 = xor i32 %xor.i1721, %or.i50.i1727, !dbg !903
  %80 = load i32, i32* %t.i1688, align 4, !dbg !904
  store i32 %80, i32* %a.addr.i35.i1681, align 4
  store i8 18, i8* %n.addr.i36.i1682, align 1
  %81 = load i32, i32* %a.addr.i35.i1681, align 4, !dbg !905
  %82 = load i8, i8* %n.addr.i36.i1682, align 1, !dbg !906
  %conv.i37.i1729 = zext i8 %82 to i32, !dbg !906
  %shl.i38.i1730 = shl i32 %81, %conv.i37.i1729, !dbg !907
  %83 = load i32, i32* %a.addr.i35.i1681, align 4, !dbg !908
  %84 = load i8, i8* %n.addr.i36.i1682, align 1, !dbg !909
  %conv1.i39.i1731 = zext i8 %84 to i32, !dbg !909
  %sub.i40.i1732 = sub nsw i32 32, %conv1.i39.i1731, !dbg !910
  %shr.i41.i1733 = lshr i32 %83, %sub.i40.i1732, !dbg !911
  %or.i42.i1734 = or i32 %shl.i38.i1730, %shr.i41.i1733, !dbg !912
  %xor24.i1735 = xor i32 %xor22.i1728, %or.i42.i1734, !dbg !913
  %85 = load i32, i32* %t.i1688, align 4, !dbg !914
  store i32 %85, i32* %a.addr.i27.i1683, align 4
  store i8 24, i8* %n.addr.i28.i1684, align 1
  %86 = load i32, i32* %a.addr.i27.i1683, align 4, !dbg !915
  %87 = load i8, i8* %n.addr.i28.i1684, align 1, !dbg !916
  %conv.i29.i1736 = zext i8 %87 to i32, !dbg !916
  %shl.i30.i1737 = shl i32 %86, %conv.i29.i1736, !dbg !917
  %88 = load i32, i32* %a.addr.i27.i1683, align 4, !dbg !918
  %89 = load i8, i8* %n.addr.i28.i1684, align 1, !dbg !919
  %conv1.i31.i1738 = zext i8 %89 to i32, !dbg !919
  %sub.i32.i1739 = sub nsw i32 32, %conv1.i31.i1738, !dbg !920
  %shr.i33.i1740 = lshr i32 %88, %sub.i32.i1739, !dbg !921
  %or.i34.i1741 = or i32 %shl.i30.i1737, %shr.i33.i1740, !dbg !922
  %xor26.i1742 = xor i32 %xor24.i1735, %or.i34.i1741, !dbg !923
  %90 = load i32, i32* %B0, align 4, !dbg !857
  %xor8 = xor i32 %90, %xor26.i1742, !dbg !857
  store i32 %xor8, i32* %B0, align 4, !dbg !857
  %91 = load i32, i32* %B0, align 4, !dbg !857
  %92 = load i32, i32* %B2, align 4, !dbg !857
  %xor9 = xor i32 %91, %92, !dbg !857
  %93 = load i32, i32* %B3, align 4, !dbg !857
  %xor10 = xor i32 %xor9, %93, !dbg !857
  %94 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !857
  %rk11 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %94, i32 0, i32 0, !dbg !857
  %arrayidx12 = getelementptr inbounds [32 x i32], [32 x i32]* %rk11, i64 0, i64 1, !dbg !857
  %95 = load i32, i32* %arrayidx12, align 4, !dbg !857
  %xor13 = xor i32 %xor10, %95, !dbg !857
  store i32 %xor13, i32* %X.addr.i1623, align 4
  store i32 0, i32* %t.i1624, align 4, !dbg !354
  %96 = load i32, i32* %X.addr.i1623, align 4, !dbg !924
  %shr.i1625 = lshr i32 %96, 24, !dbg !925
  %conv.i1626 = trunc i32 %shr.i1625 to i8, !dbg !926
  %idxprom.i1627 = zext i8 %conv.i1626 to i64, !dbg !927
  %arrayidx.i1628 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom.i1627, !dbg !927
  %97 = load i8, i8* %arrayidx.i1628, align 1, !dbg !927
  %conv1.i1629 = zext i8 %97 to i32, !dbg !928
  %shl.i1630 = shl i32 %conv1.i1629, 24, !dbg !929
  %98 = load i32, i32* %t.i1624, align 4, !dbg !930
  %or.i1631 = or i32 %98, %shl.i1630, !dbg !930
  store i32 %or.i1631, i32* %t.i1624, align 4, !dbg !930
  %99 = load i32, i32* %X.addr.i1623, align 4, !dbg !931
  %shr2.i1632 = lshr i32 %99, 16, !dbg !932
  %conv3.i1633 = trunc i32 %shr2.i1632 to i8, !dbg !933
  %idxprom4.i1634 = zext i8 %conv3.i1633 to i64, !dbg !934
  %arrayidx5.i1635 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom4.i1634, !dbg !934
  %100 = load i8, i8* %arrayidx5.i1635, align 1, !dbg !934
  %conv6.i1636 = zext i8 %100 to i32, !dbg !935
  %shl7.i1637 = shl i32 %conv6.i1636, 16, !dbg !936
  %101 = load i32, i32* %t.i1624, align 4, !dbg !937
  %or8.i1638 = or i32 %101, %shl7.i1637, !dbg !937
  store i32 %or8.i1638, i32* %t.i1624, align 4, !dbg !937
  %102 = load i32, i32* %X.addr.i1623, align 4, !dbg !938
  %shr9.i1639 = lshr i32 %102, 8, !dbg !939
  %conv10.i1640 = trunc i32 %shr9.i1639 to i8, !dbg !940
  %idxprom11.i1641 = zext i8 %conv10.i1640 to i64, !dbg !941
  %arrayidx12.i1642 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom11.i1641, !dbg !941
  %103 = load i8, i8* %arrayidx12.i1642, align 1, !dbg !941
  %conv13.i1643 = zext i8 %103 to i32, !dbg !942
  %shl14.i1644 = shl i32 %conv13.i1643, 8, !dbg !943
  %104 = load i32, i32* %t.i1624, align 4, !dbg !944
  %or15.i1645 = or i32 %104, %shl14.i1644, !dbg !944
  store i32 %or15.i1645, i32* %t.i1624, align 4, !dbg !944
  %105 = load i32, i32* %X.addr.i1623, align 4, !dbg !945
  %conv16.i1646 = trunc i32 %105 to i8, !dbg !946
  %idxprom17.i1647 = zext i8 %conv16.i1646 to i64, !dbg !947
  %arrayidx18.i1648 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom17.i1647, !dbg !947
  %106 = load i8, i8* %arrayidx18.i1648, align 1, !dbg !947
  %conv19.i1649 = zext i8 %106 to i32, !dbg !947
  %107 = load i32, i32* %t.i1624, align 4, !dbg !948
  %or20.i1650 = or i32 %107, %conv19.i1649, !dbg !948
  store i32 %or20.i1650, i32* %t.i1624, align 4, !dbg !948
  %108 = load i32, i32* %t.i1624, align 4, !dbg !949
  %109 = load i32, i32* %t.i1624, align 4, !dbg !950
  store i32 %109, i32* %a.addr.i.i1621, align 4
  store i8 2, i8* %n.addr.i.i1622, align 1
  %110 = load i32, i32* %a.addr.i.i1621, align 4, !dbg !951
  %111 = load i8, i8* %n.addr.i.i1622, align 1, !dbg !952
  %conv.i.i1651 = zext i8 %111 to i32, !dbg !952
  %shl.i.i1652 = shl i32 %110, %conv.i.i1651, !dbg !953
  %112 = load i32, i32* %a.addr.i.i1621, align 4, !dbg !954
  %113 = load i8, i8* %n.addr.i.i1622, align 1, !dbg !955
  %conv1.i.i1653 = zext i8 %113 to i32, !dbg !955
  %sub.i.i1654 = sub nsw i32 32, %conv1.i.i1653, !dbg !956
  %shr.i.i1655 = lshr i32 %112, %sub.i.i1654, !dbg !957
  %or.i.i1656 = or i32 %shl.i.i1652, %shr.i.i1655, !dbg !958
  %xor.i1657 = xor i32 %108, %or.i.i1656, !dbg !959
  %114 = load i32, i32* %t.i1624, align 4, !dbg !960
  store i32 %114, i32* %a.addr.i43.i1615, align 4
  store i8 10, i8* %n.addr.i44.i1616, align 1
  %115 = load i32, i32* %a.addr.i43.i1615, align 4, !dbg !961
  %116 = load i8, i8* %n.addr.i44.i1616, align 1, !dbg !962
  %conv.i45.i1658 = zext i8 %116 to i32, !dbg !962
  %shl.i46.i1659 = shl i32 %115, %conv.i45.i1658, !dbg !963
  %117 = load i32, i32* %a.addr.i43.i1615, align 4, !dbg !964
  %118 = load i8, i8* %n.addr.i44.i1616, align 1, !dbg !965
  %conv1.i47.i1660 = zext i8 %118 to i32, !dbg !965
  %sub.i48.i1661 = sub nsw i32 32, %conv1.i47.i1660, !dbg !966
  %shr.i49.i1662 = lshr i32 %117, %sub.i48.i1661, !dbg !967
  %or.i50.i1663 = or i32 %shl.i46.i1659, %shr.i49.i1662, !dbg !968
  %xor22.i1664 = xor i32 %xor.i1657, %or.i50.i1663, !dbg !969
  %119 = load i32, i32* %t.i1624, align 4, !dbg !970
  store i32 %119, i32* %a.addr.i35.i1617, align 4
  store i8 18, i8* %n.addr.i36.i1618, align 1
  %120 = load i32, i32* %a.addr.i35.i1617, align 4, !dbg !971
  %121 = load i8, i8* %n.addr.i36.i1618, align 1, !dbg !972
  %conv.i37.i1665 = zext i8 %121 to i32, !dbg !972
  %shl.i38.i1666 = shl i32 %120, %conv.i37.i1665, !dbg !973
  %122 = load i32, i32* %a.addr.i35.i1617, align 4, !dbg !974
  %123 = load i8, i8* %n.addr.i36.i1618, align 1, !dbg !975
  %conv1.i39.i1667 = zext i8 %123 to i32, !dbg !975
  %sub.i40.i1668 = sub nsw i32 32, %conv1.i39.i1667, !dbg !976
  %shr.i41.i1669 = lshr i32 %122, %sub.i40.i1668, !dbg !977
  %or.i42.i1670 = or i32 %shl.i38.i1666, %shr.i41.i1669, !dbg !978
  %xor24.i1671 = xor i32 %xor22.i1664, %or.i42.i1670, !dbg !979
  %124 = load i32, i32* %t.i1624, align 4, !dbg !980
  store i32 %124, i32* %a.addr.i27.i1619, align 4
  store i8 24, i8* %n.addr.i28.i1620, align 1
  %125 = load i32, i32* %a.addr.i27.i1619, align 4, !dbg !981
  %126 = load i8, i8* %n.addr.i28.i1620, align 1, !dbg !982
  %conv.i29.i1672 = zext i8 %126 to i32, !dbg !982
  %shl.i30.i1673 = shl i32 %125, %conv.i29.i1672, !dbg !983
  %127 = load i32, i32* %a.addr.i27.i1619, align 4, !dbg !984
  %128 = load i8, i8* %n.addr.i28.i1620, align 1, !dbg !985
  %conv1.i31.i1674 = zext i8 %128 to i32, !dbg !985
  %sub.i32.i1675 = sub nsw i32 32, %conv1.i31.i1674, !dbg !986
  %shr.i33.i1676 = lshr i32 %127, %sub.i32.i1675, !dbg !987
  %or.i34.i1677 = or i32 %shl.i30.i1673, %shr.i33.i1676, !dbg !988
  %xor26.i1678 = xor i32 %xor24.i1671, %or.i34.i1677, !dbg !989
  %129 = load i32, i32* %B1, align 4, !dbg !857
  %xor15 = xor i32 %129, %xor26.i1678, !dbg !857
  store i32 %xor15, i32* %B1, align 4, !dbg !857
  %130 = load i32, i32* %B0, align 4, !dbg !857
  %131 = load i32, i32* %B1, align 4, !dbg !857
  %xor16 = xor i32 %130, %131, !dbg !857
  %132 = load i32, i32* %B3, align 4, !dbg !857
  %xor17 = xor i32 %xor16, %132, !dbg !857
  %133 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !857
  %rk18 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %133, i32 0, i32 0, !dbg !857
  %arrayidx19 = getelementptr inbounds [32 x i32], [32 x i32]* %rk18, i64 0, i64 2, !dbg !857
  %134 = load i32, i32* %arrayidx19, align 4, !dbg !857
  %xor20 = xor i32 %xor17, %134, !dbg !857
  store i32 %xor20, i32* %X.addr.i1559, align 4
  store i32 0, i32* %t.i1560, align 4, !dbg !369
  %135 = load i32, i32* %X.addr.i1559, align 4, !dbg !990
  %shr.i1561 = lshr i32 %135, 24, !dbg !991
  %conv.i1562 = trunc i32 %shr.i1561 to i8, !dbg !992
  %idxprom.i1563 = zext i8 %conv.i1562 to i64, !dbg !993
  %arrayidx.i1564 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom.i1563, !dbg !993
  %136 = load i8, i8* %arrayidx.i1564, align 1, !dbg !993
  %conv1.i1565 = zext i8 %136 to i32, !dbg !994
  %shl.i1566 = shl i32 %conv1.i1565, 24, !dbg !995
  %137 = load i32, i32* %t.i1560, align 4, !dbg !996
  %or.i1567 = or i32 %137, %shl.i1566, !dbg !996
  store i32 %or.i1567, i32* %t.i1560, align 4, !dbg !996
  %138 = load i32, i32* %X.addr.i1559, align 4, !dbg !997
  %shr2.i1568 = lshr i32 %138, 16, !dbg !998
  %conv3.i1569 = trunc i32 %shr2.i1568 to i8, !dbg !999
  %idxprom4.i1570 = zext i8 %conv3.i1569 to i64, !dbg !1000
  %arrayidx5.i1571 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom4.i1570, !dbg !1000
  %139 = load i8, i8* %arrayidx5.i1571, align 1, !dbg !1000
  %conv6.i1572 = zext i8 %139 to i32, !dbg !1001
  %shl7.i1573 = shl i32 %conv6.i1572, 16, !dbg !1002
  %140 = load i32, i32* %t.i1560, align 4, !dbg !1003
  %or8.i1574 = or i32 %140, %shl7.i1573, !dbg !1003
  store i32 %or8.i1574, i32* %t.i1560, align 4, !dbg !1003
  %141 = load i32, i32* %X.addr.i1559, align 4, !dbg !1004
  %shr9.i1575 = lshr i32 %141, 8, !dbg !1005
  %conv10.i1576 = trunc i32 %shr9.i1575 to i8, !dbg !1006
  %idxprom11.i1577 = zext i8 %conv10.i1576 to i64, !dbg !1007
  %arrayidx12.i1578 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom11.i1577, !dbg !1007
  %142 = load i8, i8* %arrayidx12.i1578, align 1, !dbg !1007
  %conv13.i1579 = zext i8 %142 to i32, !dbg !1008
  %shl14.i1580 = shl i32 %conv13.i1579, 8, !dbg !1009
  %143 = load i32, i32* %t.i1560, align 4, !dbg !1010
  %or15.i1581 = or i32 %143, %shl14.i1580, !dbg !1010
  store i32 %or15.i1581, i32* %t.i1560, align 4, !dbg !1010
  %144 = load i32, i32* %X.addr.i1559, align 4, !dbg !1011
  %conv16.i1582 = trunc i32 %144 to i8, !dbg !1012
  %idxprom17.i1583 = zext i8 %conv16.i1582 to i64, !dbg !1013
  %arrayidx18.i1584 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom17.i1583, !dbg !1013
  %145 = load i8, i8* %arrayidx18.i1584, align 1, !dbg !1013
  %conv19.i1585 = zext i8 %145 to i32, !dbg !1013
  %146 = load i32, i32* %t.i1560, align 4, !dbg !1014
  %or20.i1586 = or i32 %146, %conv19.i1585, !dbg !1014
  store i32 %or20.i1586, i32* %t.i1560, align 4, !dbg !1014
  %147 = load i32, i32* %t.i1560, align 4, !dbg !1015
  %148 = load i32, i32* %t.i1560, align 4, !dbg !1016
  store i32 %148, i32* %a.addr.i.i1557, align 4
  store i8 2, i8* %n.addr.i.i1558, align 1
  %149 = load i32, i32* %a.addr.i.i1557, align 4, !dbg !1017
  %150 = load i8, i8* %n.addr.i.i1558, align 1, !dbg !1018
  %conv.i.i1587 = zext i8 %150 to i32, !dbg !1018
  %shl.i.i1588 = shl i32 %149, %conv.i.i1587, !dbg !1019
  %151 = load i32, i32* %a.addr.i.i1557, align 4, !dbg !1020
  %152 = load i8, i8* %n.addr.i.i1558, align 1, !dbg !1021
  %conv1.i.i1589 = zext i8 %152 to i32, !dbg !1021
  %sub.i.i1590 = sub nsw i32 32, %conv1.i.i1589, !dbg !1022
  %shr.i.i1591 = lshr i32 %151, %sub.i.i1590, !dbg !1023
  %or.i.i1592 = or i32 %shl.i.i1588, %shr.i.i1591, !dbg !1024
  %xor.i1593 = xor i32 %147, %or.i.i1592, !dbg !1025
  %153 = load i32, i32* %t.i1560, align 4, !dbg !1026
  store i32 %153, i32* %a.addr.i43.i1551, align 4
  store i8 10, i8* %n.addr.i44.i1552, align 1
  %154 = load i32, i32* %a.addr.i43.i1551, align 4, !dbg !1027
  %155 = load i8, i8* %n.addr.i44.i1552, align 1, !dbg !1028
  %conv.i45.i1594 = zext i8 %155 to i32, !dbg !1028
  %shl.i46.i1595 = shl i32 %154, %conv.i45.i1594, !dbg !1029
  %156 = load i32, i32* %a.addr.i43.i1551, align 4, !dbg !1030
  %157 = load i8, i8* %n.addr.i44.i1552, align 1, !dbg !1031
  %conv1.i47.i1596 = zext i8 %157 to i32, !dbg !1031
  %sub.i48.i1597 = sub nsw i32 32, %conv1.i47.i1596, !dbg !1032
  %shr.i49.i1598 = lshr i32 %156, %sub.i48.i1597, !dbg !1033
  %or.i50.i1599 = or i32 %shl.i46.i1595, %shr.i49.i1598, !dbg !1034
  %xor22.i1600 = xor i32 %xor.i1593, %or.i50.i1599, !dbg !1035
  %158 = load i32, i32* %t.i1560, align 4, !dbg !1036
  store i32 %158, i32* %a.addr.i35.i1553, align 4
  store i8 18, i8* %n.addr.i36.i1554, align 1
  %159 = load i32, i32* %a.addr.i35.i1553, align 4, !dbg !1037
  %160 = load i8, i8* %n.addr.i36.i1554, align 1, !dbg !1038
  %conv.i37.i1601 = zext i8 %160 to i32, !dbg !1038
  %shl.i38.i1602 = shl i32 %159, %conv.i37.i1601, !dbg !1039
  %161 = load i32, i32* %a.addr.i35.i1553, align 4, !dbg !1040
  %162 = load i8, i8* %n.addr.i36.i1554, align 1, !dbg !1041
  %conv1.i39.i1603 = zext i8 %162 to i32, !dbg !1041
  %sub.i40.i1604 = sub nsw i32 32, %conv1.i39.i1603, !dbg !1042
  %shr.i41.i1605 = lshr i32 %161, %sub.i40.i1604, !dbg !1043
  %or.i42.i1606 = or i32 %shl.i38.i1602, %shr.i41.i1605, !dbg !1044
  %xor24.i1607 = xor i32 %xor22.i1600, %or.i42.i1606, !dbg !1045
  %163 = load i32, i32* %t.i1560, align 4, !dbg !1046
  store i32 %163, i32* %a.addr.i27.i1555, align 4
  store i8 24, i8* %n.addr.i28.i1556, align 1
  %164 = load i32, i32* %a.addr.i27.i1555, align 4, !dbg !1047
  %165 = load i8, i8* %n.addr.i28.i1556, align 1, !dbg !1048
  %conv.i29.i1608 = zext i8 %165 to i32, !dbg !1048
  %shl.i30.i1609 = shl i32 %164, %conv.i29.i1608, !dbg !1049
  %166 = load i32, i32* %a.addr.i27.i1555, align 4, !dbg !1050
  %167 = load i8, i8* %n.addr.i28.i1556, align 1, !dbg !1051
  %conv1.i31.i1610 = zext i8 %167 to i32, !dbg !1051
  %sub.i32.i1611 = sub nsw i32 32, %conv1.i31.i1610, !dbg !1052
  %shr.i33.i1612 = lshr i32 %166, %sub.i32.i1611, !dbg !1053
  %or.i34.i1613 = or i32 %shl.i30.i1609, %shr.i33.i1612, !dbg !1054
  %xor26.i1614 = xor i32 %xor24.i1607, %or.i34.i1613, !dbg !1055
  %168 = load i32, i32* %B2, align 4, !dbg !857
  %xor22 = xor i32 %168, %xor26.i1614, !dbg !857
  store i32 %xor22, i32* %B2, align 4, !dbg !857
  %169 = load i32, i32* %B0, align 4, !dbg !857
  %170 = load i32, i32* %B1, align 4, !dbg !857
  %xor23 = xor i32 %169, %170, !dbg !857
  %171 = load i32, i32* %B2, align 4, !dbg !857
  %xor24 = xor i32 %xor23, %171, !dbg !857
  %172 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !857
  %rk25 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %172, i32 0, i32 0, !dbg !857
  %arrayidx26 = getelementptr inbounds [32 x i32], [32 x i32]* %rk25, i64 0, i64 3, !dbg !857
  %173 = load i32, i32* %arrayidx26, align 4, !dbg !857
  %xor27 = xor i32 %xor24, %173, !dbg !857
  store i32 %xor27, i32* %X.addr.i1495, align 4
  store i32 0, i32* %t.i1496, align 4, !dbg !384
  %174 = load i32, i32* %X.addr.i1495, align 4, !dbg !1056
  %shr.i1497 = lshr i32 %174, 24, !dbg !1057
  %conv.i1498 = trunc i32 %shr.i1497 to i8, !dbg !1058
  %idxprom.i1499 = zext i8 %conv.i1498 to i64, !dbg !1059
  %arrayidx.i1500 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom.i1499, !dbg !1059
  %175 = load i8, i8* %arrayidx.i1500, align 1, !dbg !1059
  %conv1.i1501 = zext i8 %175 to i32, !dbg !1060
  %shl.i1502 = shl i32 %conv1.i1501, 24, !dbg !1061
  %176 = load i32, i32* %t.i1496, align 4, !dbg !1062
  %or.i1503 = or i32 %176, %shl.i1502, !dbg !1062
  store i32 %or.i1503, i32* %t.i1496, align 4, !dbg !1062
  %177 = load i32, i32* %X.addr.i1495, align 4, !dbg !1063
  %shr2.i1504 = lshr i32 %177, 16, !dbg !1064
  %conv3.i1505 = trunc i32 %shr2.i1504 to i8, !dbg !1065
  %idxprom4.i1506 = zext i8 %conv3.i1505 to i64, !dbg !1066
  %arrayidx5.i1507 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom4.i1506, !dbg !1066
  %178 = load i8, i8* %arrayidx5.i1507, align 1, !dbg !1066
  %conv6.i1508 = zext i8 %178 to i32, !dbg !1067
  %shl7.i1509 = shl i32 %conv6.i1508, 16, !dbg !1068
  %179 = load i32, i32* %t.i1496, align 4, !dbg !1069
  %or8.i1510 = or i32 %179, %shl7.i1509, !dbg !1069
  store i32 %or8.i1510, i32* %t.i1496, align 4, !dbg !1069
  %180 = load i32, i32* %X.addr.i1495, align 4, !dbg !1070
  %shr9.i1511 = lshr i32 %180, 8, !dbg !1071
  %conv10.i1512 = trunc i32 %shr9.i1511 to i8, !dbg !1072
  %idxprom11.i1513 = zext i8 %conv10.i1512 to i64, !dbg !1073
  %arrayidx12.i1514 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom11.i1513, !dbg !1073
  %181 = load i8, i8* %arrayidx12.i1514, align 1, !dbg !1073
  %conv13.i1515 = zext i8 %181 to i32, !dbg !1074
  %shl14.i1516 = shl i32 %conv13.i1515, 8, !dbg !1075
  %182 = load i32, i32* %t.i1496, align 4, !dbg !1076
  %or15.i1517 = or i32 %182, %shl14.i1516, !dbg !1076
  store i32 %or15.i1517, i32* %t.i1496, align 4, !dbg !1076
  %183 = load i32, i32* %X.addr.i1495, align 4, !dbg !1077
  %conv16.i1518 = trunc i32 %183 to i8, !dbg !1078
  %idxprom17.i1519 = zext i8 %conv16.i1518 to i64, !dbg !1079
  %arrayidx18.i1520 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom17.i1519, !dbg !1079
  %184 = load i8, i8* %arrayidx18.i1520, align 1, !dbg !1079
  %conv19.i1521 = zext i8 %184 to i32, !dbg !1079
  %185 = load i32, i32* %t.i1496, align 4, !dbg !1080
  %or20.i1522 = or i32 %185, %conv19.i1521, !dbg !1080
  store i32 %or20.i1522, i32* %t.i1496, align 4, !dbg !1080
  %186 = load i32, i32* %t.i1496, align 4, !dbg !1081
  %187 = load i32, i32* %t.i1496, align 4, !dbg !1082
  store i32 %187, i32* %a.addr.i.i1493, align 4
  store i8 2, i8* %n.addr.i.i1494, align 1
  %188 = load i32, i32* %a.addr.i.i1493, align 4, !dbg !1083
  %189 = load i8, i8* %n.addr.i.i1494, align 1, !dbg !1084
  %conv.i.i1523 = zext i8 %189 to i32, !dbg !1084
  %shl.i.i1524 = shl i32 %188, %conv.i.i1523, !dbg !1085
  %190 = load i32, i32* %a.addr.i.i1493, align 4, !dbg !1086
  %191 = load i8, i8* %n.addr.i.i1494, align 1, !dbg !1087
  %conv1.i.i1525 = zext i8 %191 to i32, !dbg !1087
  %sub.i.i1526 = sub nsw i32 32, %conv1.i.i1525, !dbg !1088
  %shr.i.i1527 = lshr i32 %190, %sub.i.i1526, !dbg !1089
  %or.i.i1528 = or i32 %shl.i.i1524, %shr.i.i1527, !dbg !1090
  %xor.i1529 = xor i32 %186, %or.i.i1528, !dbg !1091
  %192 = load i32, i32* %t.i1496, align 4, !dbg !1092
  store i32 %192, i32* %a.addr.i43.i1487, align 4
  store i8 10, i8* %n.addr.i44.i1488, align 1
  %193 = load i32, i32* %a.addr.i43.i1487, align 4, !dbg !1093
  %194 = load i8, i8* %n.addr.i44.i1488, align 1, !dbg !1094
  %conv.i45.i1530 = zext i8 %194 to i32, !dbg !1094
  %shl.i46.i1531 = shl i32 %193, %conv.i45.i1530, !dbg !1095
  %195 = load i32, i32* %a.addr.i43.i1487, align 4, !dbg !1096
  %196 = load i8, i8* %n.addr.i44.i1488, align 1, !dbg !1097
  %conv1.i47.i1532 = zext i8 %196 to i32, !dbg !1097
  %sub.i48.i1533 = sub nsw i32 32, %conv1.i47.i1532, !dbg !1098
  %shr.i49.i1534 = lshr i32 %195, %sub.i48.i1533, !dbg !1099
  %or.i50.i1535 = or i32 %shl.i46.i1531, %shr.i49.i1534, !dbg !1100
  %xor22.i1536 = xor i32 %xor.i1529, %or.i50.i1535, !dbg !1101
  %197 = load i32, i32* %t.i1496, align 4, !dbg !1102
  store i32 %197, i32* %a.addr.i35.i1489, align 4
  store i8 18, i8* %n.addr.i36.i1490, align 1
  %198 = load i32, i32* %a.addr.i35.i1489, align 4, !dbg !1103
  %199 = load i8, i8* %n.addr.i36.i1490, align 1, !dbg !1104
  %conv.i37.i1537 = zext i8 %199 to i32, !dbg !1104
  %shl.i38.i1538 = shl i32 %198, %conv.i37.i1537, !dbg !1105
  %200 = load i32, i32* %a.addr.i35.i1489, align 4, !dbg !1106
  %201 = load i8, i8* %n.addr.i36.i1490, align 1, !dbg !1107
  %conv1.i39.i1539 = zext i8 %201 to i32, !dbg !1107
  %sub.i40.i1540 = sub nsw i32 32, %conv1.i39.i1539, !dbg !1108
  %shr.i41.i1541 = lshr i32 %200, %sub.i40.i1540, !dbg !1109
  %or.i42.i1542 = or i32 %shl.i38.i1538, %shr.i41.i1541, !dbg !1110
  %xor24.i1543 = xor i32 %xor22.i1536, %or.i42.i1542, !dbg !1111
  %202 = load i32, i32* %t.i1496, align 4, !dbg !1112
  store i32 %202, i32* %a.addr.i27.i1491, align 4
  store i8 24, i8* %n.addr.i28.i1492, align 1
  %203 = load i32, i32* %a.addr.i27.i1491, align 4, !dbg !1113
  %204 = load i8, i8* %n.addr.i28.i1492, align 1, !dbg !1114
  %conv.i29.i1544 = zext i8 %204 to i32, !dbg !1114
  %shl.i30.i1545 = shl i32 %203, %conv.i29.i1544, !dbg !1115
  %205 = load i32, i32* %a.addr.i27.i1491, align 4, !dbg !1116
  %206 = load i8, i8* %n.addr.i28.i1492, align 1, !dbg !1117
  %conv1.i31.i1546 = zext i8 %206 to i32, !dbg !1117
  %sub.i32.i1547 = sub nsw i32 32, %conv1.i31.i1546, !dbg !1118
  %shr.i33.i1548 = lshr i32 %205, %sub.i32.i1547, !dbg !1119
  %or.i34.i1549 = or i32 %shl.i30.i1545, %shr.i33.i1548, !dbg !1120
  %xor26.i1550 = xor i32 %xor24.i1543, %or.i34.i1549, !dbg !1121
  %207 = load i32, i32* %B3, align 4, !dbg !857
  %xor29 = xor i32 %207, %xor26.i1550, !dbg !857
  store i32 %xor29, i32* %B3, align 4, !dbg !857
  br label %do.end, !dbg !857

do.end:                                           ; preds = %do.body
  br label %do.body30, !dbg !1122

do.body30:                                        ; preds = %do.end
  %208 = load i32, i32* %B1, align 4, !dbg !1123
  %209 = load i32, i32* %B2, align 4, !dbg !1123
  %xor31 = xor i32 %208, %209, !dbg !1123
  %210 = load i32, i32* %B3, align 4, !dbg !1123
  %xor32 = xor i32 %xor31, %210, !dbg !1123
  %211 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1123
  %rk33 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %211, i32 0, i32 0, !dbg !1123
  %arrayidx34 = getelementptr inbounds [32 x i32], [32 x i32]* %rk33, i64 0, i64 4, !dbg !1123
  %212 = load i32, i32* %arrayidx34, align 4, !dbg !1123
  %xor35 = xor i32 %xor32, %212, !dbg !1123
  store i32 %xor35, i32* %X.addr.i1450, align 4
  %213 = load i32, i32* %X.addr.i1450, align 4, !dbg !1124
  %shr.i1451 = lshr i32 %213, 24, !dbg !1125
  %conv.i1452 = trunc i32 %shr.i1451 to i8, !dbg !1126
  %idxprom.i1453 = zext i8 %conv.i1452 to i64, !dbg !1127
  %arrayidx.i1454 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1453, !dbg !1127
  %214 = load i32, i32* %arrayidx.i1454, align 4, !dbg !1127
  %215 = load i32, i32* %X.addr.i1450, align 4, !dbg !1128
  %shr1.i1455 = lshr i32 %215, 16, !dbg !1129
  %conv2.i1456 = trunc i32 %shr1.i1455 to i8, !dbg !1130
  %idxprom3.i1457 = zext i8 %conv2.i1456 to i64, !dbg !1131
  %arrayidx4.i1458 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1457, !dbg !1131
  %216 = load i32, i32* %arrayidx4.i1458, align 4, !dbg !1131
  store i32 %216, i32* %a.addr.i.i1448, align 4
  store i8 24, i8* %n.addr.i.i1449, align 1
  %217 = load i32, i32* %a.addr.i.i1448, align 4, !dbg !1132
  %218 = load i8, i8* %n.addr.i.i1449, align 1, !dbg !1133
  %conv.i.i1459 = zext i8 %218 to i32, !dbg !1133
  %shl.i.i1460 = shl i32 %217, %conv.i.i1459, !dbg !1134
  %219 = load i32, i32* %a.addr.i.i1448, align 4, !dbg !1135
  %220 = load i8, i8* %n.addr.i.i1449, align 1, !dbg !1136
  %conv1.i.i1461 = zext i8 %220 to i32, !dbg !1136
  %sub.i.i1462 = sub nsw i32 32, %conv1.i.i1461, !dbg !1137
  %shr.i.i1463 = lshr i32 %219, %sub.i.i1462, !dbg !1138
  %or.i.i1464 = or i32 %shl.i.i1460, %shr.i.i1463, !dbg !1139
  %xor.i1465 = xor i32 %214, %or.i.i1464, !dbg !1140
  %221 = load i32, i32* %X.addr.i1450, align 4, !dbg !1141
  %shr5.i1466 = lshr i32 %221, 8, !dbg !1142
  %conv6.i1467 = trunc i32 %shr5.i1466 to i8, !dbg !1143
  %idxprom7.i1468 = zext i8 %conv6.i1467 to i64, !dbg !1144
  %arrayidx8.i1469 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1468, !dbg !1144
  %222 = load i32, i32* %arrayidx8.i1469, align 4, !dbg !1144
  store i32 %222, i32* %a.addr.i24.i1444, align 4
  store i8 16, i8* %n.addr.i25.i1445, align 1
  %223 = load i32, i32* %a.addr.i24.i1444, align 4, !dbg !1145
  %224 = load i8, i8* %n.addr.i25.i1445, align 1, !dbg !1146
  %conv.i26.i1470 = zext i8 %224 to i32, !dbg !1146
  %shl.i27.i1471 = shl i32 %223, %conv.i26.i1470, !dbg !1147
  %225 = load i32, i32* %a.addr.i24.i1444, align 4, !dbg !1148
  %226 = load i8, i8* %n.addr.i25.i1445, align 1, !dbg !1149
  %conv1.i28.i1472 = zext i8 %226 to i32, !dbg !1149
  %sub.i29.i1473 = sub nsw i32 32, %conv1.i28.i1472, !dbg !1150
  %shr.i30.i1474 = lshr i32 %225, %sub.i29.i1473, !dbg !1151
  %or.i31.i1475 = or i32 %shl.i27.i1471, %shr.i30.i1474, !dbg !1152
  %xor10.i1476 = xor i32 %xor.i1465, %or.i31.i1475, !dbg !1153
  %227 = load i32, i32* %X.addr.i1450, align 4, !dbg !1154
  %conv11.i1477 = trunc i32 %227 to i8, !dbg !1155
  %idxprom12.i1478 = zext i8 %conv11.i1477 to i64, !dbg !1156
  %arrayidx13.i1479 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1478, !dbg !1156
  %228 = load i32, i32* %arrayidx13.i1479, align 4, !dbg !1156
  store i32 %228, i32* %a.addr.i16.i1446, align 4
  store i8 8, i8* %n.addr.i17.i1447, align 1
  %229 = load i32, i32* %a.addr.i16.i1446, align 4, !dbg !1157
  %230 = load i8, i8* %n.addr.i17.i1447, align 1, !dbg !1158
  %conv.i18.i1480 = zext i8 %230 to i32, !dbg !1158
  %shl.i19.i1481 = shl i32 %229, %conv.i18.i1480, !dbg !1159
  %231 = load i32, i32* %a.addr.i16.i1446, align 4, !dbg !1160
  %232 = load i8, i8* %n.addr.i17.i1447, align 1, !dbg !1161
  %conv1.i20.i1482 = zext i8 %232 to i32, !dbg !1161
  %sub.i21.i1483 = sub nsw i32 32, %conv1.i20.i1482, !dbg !1162
  %shr.i22.i1484 = lshr i32 %231, %sub.i21.i1483, !dbg !1163
  %or.i23.i1485 = or i32 %shl.i19.i1481, %shr.i22.i1484, !dbg !1164
  %xor15.i1486 = xor i32 %xor10.i1476, %or.i23.i1485, !dbg !1165
  %233 = load i32, i32* %B0, align 4, !dbg !1123
  %xor37 = xor i32 %233, %xor15.i1486, !dbg !1123
  store i32 %xor37, i32* %B0, align 4, !dbg !1123
  %234 = load i32, i32* %B0, align 4, !dbg !1123
  %235 = load i32, i32* %B2, align 4, !dbg !1123
  %xor38 = xor i32 %234, %235, !dbg !1123
  %236 = load i32, i32* %B3, align 4, !dbg !1123
  %xor39 = xor i32 %xor38, %236, !dbg !1123
  %237 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1123
  %rk40 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %237, i32 0, i32 0, !dbg !1123
  %arrayidx41 = getelementptr inbounds [32 x i32], [32 x i32]* %rk40, i64 0, i64 5, !dbg !1123
  %238 = load i32, i32* %arrayidx41, align 4, !dbg !1123
  %xor42 = xor i32 %xor39, %238, !dbg !1123
  store i32 %xor42, i32* %X.addr.i1407, align 4
  %239 = load i32, i32* %X.addr.i1407, align 4, !dbg !1166
  %shr.i1408 = lshr i32 %239, 24, !dbg !1167
  %conv.i1409 = trunc i32 %shr.i1408 to i8, !dbg !1168
  %idxprom.i1410 = zext i8 %conv.i1409 to i64, !dbg !1169
  %arrayidx.i1411 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1410, !dbg !1169
  %240 = load i32, i32* %arrayidx.i1411, align 4, !dbg !1169
  %241 = load i32, i32* %X.addr.i1407, align 4, !dbg !1170
  %shr1.i1412 = lshr i32 %241, 16, !dbg !1171
  %conv2.i1413 = trunc i32 %shr1.i1412 to i8, !dbg !1172
  %idxprom3.i1414 = zext i8 %conv2.i1413 to i64, !dbg !1173
  %arrayidx4.i1415 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1414, !dbg !1173
  %242 = load i32, i32* %arrayidx4.i1415, align 4, !dbg !1173
  store i32 %242, i32* %a.addr.i.i1405, align 4
  store i8 24, i8* %n.addr.i.i1406, align 1
  %243 = load i32, i32* %a.addr.i.i1405, align 4, !dbg !1174
  %244 = load i8, i8* %n.addr.i.i1406, align 1, !dbg !1175
  %conv.i.i1416 = zext i8 %244 to i32, !dbg !1175
  %shl.i.i1417 = shl i32 %243, %conv.i.i1416, !dbg !1176
  %245 = load i32, i32* %a.addr.i.i1405, align 4, !dbg !1177
  %246 = load i8, i8* %n.addr.i.i1406, align 1, !dbg !1178
  %conv1.i.i1418 = zext i8 %246 to i32, !dbg !1178
  %sub.i.i1419 = sub nsw i32 32, %conv1.i.i1418, !dbg !1179
  %shr.i.i1420 = lshr i32 %245, %sub.i.i1419, !dbg !1180
  %or.i.i1421 = or i32 %shl.i.i1417, %shr.i.i1420, !dbg !1181
  %xor.i1422 = xor i32 %240, %or.i.i1421, !dbg !1182
  %247 = load i32, i32* %X.addr.i1407, align 4, !dbg !1183
  %shr5.i1423 = lshr i32 %247, 8, !dbg !1184
  %conv6.i1424 = trunc i32 %shr5.i1423 to i8, !dbg !1185
  %idxprom7.i1425 = zext i8 %conv6.i1424 to i64, !dbg !1186
  %arrayidx8.i1426 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1425, !dbg !1186
  %248 = load i32, i32* %arrayidx8.i1426, align 4, !dbg !1186
  store i32 %248, i32* %a.addr.i24.i1401, align 4
  store i8 16, i8* %n.addr.i25.i1402, align 1
  %249 = load i32, i32* %a.addr.i24.i1401, align 4, !dbg !1187
  %250 = load i8, i8* %n.addr.i25.i1402, align 1, !dbg !1188
  %conv.i26.i1427 = zext i8 %250 to i32, !dbg !1188
  %shl.i27.i1428 = shl i32 %249, %conv.i26.i1427, !dbg !1189
  %251 = load i32, i32* %a.addr.i24.i1401, align 4, !dbg !1190
  %252 = load i8, i8* %n.addr.i25.i1402, align 1, !dbg !1191
  %conv1.i28.i1429 = zext i8 %252 to i32, !dbg !1191
  %sub.i29.i1430 = sub nsw i32 32, %conv1.i28.i1429, !dbg !1192
  %shr.i30.i1431 = lshr i32 %251, %sub.i29.i1430, !dbg !1193
  %or.i31.i1432 = or i32 %shl.i27.i1428, %shr.i30.i1431, !dbg !1194
  %xor10.i1433 = xor i32 %xor.i1422, %or.i31.i1432, !dbg !1195
  %253 = load i32, i32* %X.addr.i1407, align 4, !dbg !1196
  %conv11.i1434 = trunc i32 %253 to i8, !dbg !1197
  %idxprom12.i1435 = zext i8 %conv11.i1434 to i64, !dbg !1198
  %arrayidx13.i1436 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1435, !dbg !1198
  %254 = load i32, i32* %arrayidx13.i1436, align 4, !dbg !1198
  store i32 %254, i32* %a.addr.i16.i1403, align 4
  store i8 8, i8* %n.addr.i17.i1404, align 1
  %255 = load i32, i32* %a.addr.i16.i1403, align 4, !dbg !1199
  %256 = load i8, i8* %n.addr.i17.i1404, align 1, !dbg !1200
  %conv.i18.i1437 = zext i8 %256 to i32, !dbg !1200
  %shl.i19.i1438 = shl i32 %255, %conv.i18.i1437, !dbg !1201
  %257 = load i32, i32* %a.addr.i16.i1403, align 4, !dbg !1202
  %258 = load i8, i8* %n.addr.i17.i1404, align 1, !dbg !1203
  %conv1.i20.i1439 = zext i8 %258 to i32, !dbg !1203
  %sub.i21.i1440 = sub nsw i32 32, %conv1.i20.i1439, !dbg !1204
  %shr.i22.i1441 = lshr i32 %257, %sub.i21.i1440, !dbg !1205
  %or.i23.i1442 = or i32 %shl.i19.i1438, %shr.i22.i1441, !dbg !1206
  %xor15.i1443 = xor i32 %xor10.i1433, %or.i23.i1442, !dbg !1207
  %259 = load i32, i32* %B1, align 4, !dbg !1123
  %xor44 = xor i32 %259, %xor15.i1443, !dbg !1123
  store i32 %xor44, i32* %B1, align 4, !dbg !1123
  %260 = load i32, i32* %B0, align 4, !dbg !1123
  %261 = load i32, i32* %B1, align 4, !dbg !1123
  %xor45 = xor i32 %260, %261, !dbg !1123
  %262 = load i32, i32* %B3, align 4, !dbg !1123
  %xor46 = xor i32 %xor45, %262, !dbg !1123
  %263 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1123
  %rk47 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %263, i32 0, i32 0, !dbg !1123
  %arrayidx48 = getelementptr inbounds [32 x i32], [32 x i32]* %rk47, i64 0, i64 6, !dbg !1123
  %264 = load i32, i32* %arrayidx48, align 4, !dbg !1123
  %xor49 = xor i32 %xor46, %264, !dbg !1123
  store i32 %xor49, i32* %X.addr.i1364, align 4
  %265 = load i32, i32* %X.addr.i1364, align 4, !dbg !1208
  %shr.i1365 = lshr i32 %265, 24, !dbg !1209
  %conv.i1366 = trunc i32 %shr.i1365 to i8, !dbg !1210
  %idxprom.i1367 = zext i8 %conv.i1366 to i64, !dbg !1211
  %arrayidx.i1368 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1367, !dbg !1211
  %266 = load i32, i32* %arrayidx.i1368, align 4, !dbg !1211
  %267 = load i32, i32* %X.addr.i1364, align 4, !dbg !1212
  %shr1.i1369 = lshr i32 %267, 16, !dbg !1213
  %conv2.i1370 = trunc i32 %shr1.i1369 to i8, !dbg !1214
  %idxprom3.i1371 = zext i8 %conv2.i1370 to i64, !dbg !1215
  %arrayidx4.i1372 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1371, !dbg !1215
  %268 = load i32, i32* %arrayidx4.i1372, align 4, !dbg !1215
  store i32 %268, i32* %a.addr.i.i1362, align 4
  store i8 24, i8* %n.addr.i.i1363, align 1
  %269 = load i32, i32* %a.addr.i.i1362, align 4, !dbg !1216
  %270 = load i8, i8* %n.addr.i.i1363, align 1, !dbg !1217
  %conv.i.i1373 = zext i8 %270 to i32, !dbg !1217
  %shl.i.i1374 = shl i32 %269, %conv.i.i1373, !dbg !1218
  %271 = load i32, i32* %a.addr.i.i1362, align 4, !dbg !1219
  %272 = load i8, i8* %n.addr.i.i1363, align 1, !dbg !1220
  %conv1.i.i1375 = zext i8 %272 to i32, !dbg !1220
  %sub.i.i1376 = sub nsw i32 32, %conv1.i.i1375, !dbg !1221
  %shr.i.i1377 = lshr i32 %271, %sub.i.i1376, !dbg !1222
  %or.i.i1378 = or i32 %shl.i.i1374, %shr.i.i1377, !dbg !1223
  %xor.i1379 = xor i32 %266, %or.i.i1378, !dbg !1224
  %273 = load i32, i32* %X.addr.i1364, align 4, !dbg !1225
  %shr5.i1380 = lshr i32 %273, 8, !dbg !1226
  %conv6.i1381 = trunc i32 %shr5.i1380 to i8, !dbg !1227
  %idxprom7.i1382 = zext i8 %conv6.i1381 to i64, !dbg !1228
  %arrayidx8.i1383 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1382, !dbg !1228
  %274 = load i32, i32* %arrayidx8.i1383, align 4, !dbg !1228
  store i32 %274, i32* %a.addr.i24.i1358, align 4
  store i8 16, i8* %n.addr.i25.i1359, align 1
  %275 = load i32, i32* %a.addr.i24.i1358, align 4, !dbg !1229
  %276 = load i8, i8* %n.addr.i25.i1359, align 1, !dbg !1230
  %conv.i26.i1384 = zext i8 %276 to i32, !dbg !1230
  %shl.i27.i1385 = shl i32 %275, %conv.i26.i1384, !dbg !1231
  %277 = load i32, i32* %a.addr.i24.i1358, align 4, !dbg !1232
  %278 = load i8, i8* %n.addr.i25.i1359, align 1, !dbg !1233
  %conv1.i28.i1386 = zext i8 %278 to i32, !dbg !1233
  %sub.i29.i1387 = sub nsw i32 32, %conv1.i28.i1386, !dbg !1234
  %shr.i30.i1388 = lshr i32 %277, %sub.i29.i1387, !dbg !1235
  %or.i31.i1389 = or i32 %shl.i27.i1385, %shr.i30.i1388, !dbg !1236
  %xor10.i1390 = xor i32 %xor.i1379, %or.i31.i1389, !dbg !1237
  %279 = load i32, i32* %X.addr.i1364, align 4, !dbg !1238
  %conv11.i1391 = trunc i32 %279 to i8, !dbg !1239
  %idxprom12.i1392 = zext i8 %conv11.i1391 to i64, !dbg !1240
  %arrayidx13.i1393 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1392, !dbg !1240
  %280 = load i32, i32* %arrayidx13.i1393, align 4, !dbg !1240
  store i32 %280, i32* %a.addr.i16.i1360, align 4
  store i8 8, i8* %n.addr.i17.i1361, align 1
  %281 = load i32, i32* %a.addr.i16.i1360, align 4, !dbg !1241
  %282 = load i8, i8* %n.addr.i17.i1361, align 1, !dbg !1242
  %conv.i18.i1394 = zext i8 %282 to i32, !dbg !1242
  %shl.i19.i1395 = shl i32 %281, %conv.i18.i1394, !dbg !1243
  %283 = load i32, i32* %a.addr.i16.i1360, align 4, !dbg !1244
  %284 = load i8, i8* %n.addr.i17.i1361, align 1, !dbg !1245
  %conv1.i20.i1396 = zext i8 %284 to i32, !dbg !1245
  %sub.i21.i1397 = sub nsw i32 32, %conv1.i20.i1396, !dbg !1246
  %shr.i22.i1398 = lshr i32 %283, %sub.i21.i1397, !dbg !1247
  %or.i23.i1399 = or i32 %shl.i19.i1395, %shr.i22.i1398, !dbg !1248
  %xor15.i1400 = xor i32 %xor10.i1390, %or.i23.i1399, !dbg !1249
  %285 = load i32, i32* %B2, align 4, !dbg !1123
  %xor51 = xor i32 %285, %xor15.i1400, !dbg !1123
  store i32 %xor51, i32* %B2, align 4, !dbg !1123
  %286 = load i32, i32* %B0, align 4, !dbg !1123
  %287 = load i32, i32* %B1, align 4, !dbg !1123
  %xor52 = xor i32 %286, %287, !dbg !1123
  %288 = load i32, i32* %B2, align 4, !dbg !1123
  %xor53 = xor i32 %xor52, %288, !dbg !1123
  %289 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1123
  %rk54 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %289, i32 0, i32 0, !dbg !1123
  %arrayidx55 = getelementptr inbounds [32 x i32], [32 x i32]* %rk54, i64 0, i64 7, !dbg !1123
  %290 = load i32, i32* %arrayidx55, align 4, !dbg !1123
  %xor56 = xor i32 %xor53, %290, !dbg !1123
  store i32 %xor56, i32* %X.addr.i1321, align 4
  %291 = load i32, i32* %X.addr.i1321, align 4, !dbg !1250
  %shr.i1322 = lshr i32 %291, 24, !dbg !1251
  %conv.i1323 = trunc i32 %shr.i1322 to i8, !dbg !1252
  %idxprom.i1324 = zext i8 %conv.i1323 to i64, !dbg !1253
  %arrayidx.i1325 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1324, !dbg !1253
  %292 = load i32, i32* %arrayidx.i1325, align 4, !dbg !1253
  %293 = load i32, i32* %X.addr.i1321, align 4, !dbg !1254
  %shr1.i1326 = lshr i32 %293, 16, !dbg !1255
  %conv2.i1327 = trunc i32 %shr1.i1326 to i8, !dbg !1256
  %idxprom3.i1328 = zext i8 %conv2.i1327 to i64, !dbg !1257
  %arrayidx4.i1329 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1328, !dbg !1257
  %294 = load i32, i32* %arrayidx4.i1329, align 4, !dbg !1257
  store i32 %294, i32* %a.addr.i.i1319, align 4
  store i8 24, i8* %n.addr.i.i1320, align 1
  %295 = load i32, i32* %a.addr.i.i1319, align 4, !dbg !1258
  %296 = load i8, i8* %n.addr.i.i1320, align 1, !dbg !1259
  %conv.i.i1330 = zext i8 %296 to i32, !dbg !1259
  %shl.i.i1331 = shl i32 %295, %conv.i.i1330, !dbg !1260
  %297 = load i32, i32* %a.addr.i.i1319, align 4, !dbg !1261
  %298 = load i8, i8* %n.addr.i.i1320, align 1, !dbg !1262
  %conv1.i.i1332 = zext i8 %298 to i32, !dbg !1262
  %sub.i.i1333 = sub nsw i32 32, %conv1.i.i1332, !dbg !1263
  %shr.i.i1334 = lshr i32 %297, %sub.i.i1333, !dbg !1264
  %or.i.i1335 = or i32 %shl.i.i1331, %shr.i.i1334, !dbg !1265
  %xor.i1336 = xor i32 %292, %or.i.i1335, !dbg !1266
  %299 = load i32, i32* %X.addr.i1321, align 4, !dbg !1267
  %shr5.i1337 = lshr i32 %299, 8, !dbg !1268
  %conv6.i1338 = trunc i32 %shr5.i1337 to i8, !dbg !1269
  %idxprom7.i1339 = zext i8 %conv6.i1338 to i64, !dbg !1270
  %arrayidx8.i1340 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1339, !dbg !1270
  %300 = load i32, i32* %arrayidx8.i1340, align 4, !dbg !1270
  store i32 %300, i32* %a.addr.i24.i1315, align 4
  store i8 16, i8* %n.addr.i25.i1316, align 1
  %301 = load i32, i32* %a.addr.i24.i1315, align 4, !dbg !1271
  %302 = load i8, i8* %n.addr.i25.i1316, align 1, !dbg !1272
  %conv.i26.i1341 = zext i8 %302 to i32, !dbg !1272
  %shl.i27.i1342 = shl i32 %301, %conv.i26.i1341, !dbg !1273
  %303 = load i32, i32* %a.addr.i24.i1315, align 4, !dbg !1274
  %304 = load i8, i8* %n.addr.i25.i1316, align 1, !dbg !1275
  %conv1.i28.i1343 = zext i8 %304 to i32, !dbg !1275
  %sub.i29.i1344 = sub nsw i32 32, %conv1.i28.i1343, !dbg !1276
  %shr.i30.i1345 = lshr i32 %303, %sub.i29.i1344, !dbg !1277
  %or.i31.i1346 = or i32 %shl.i27.i1342, %shr.i30.i1345, !dbg !1278
  %xor10.i1347 = xor i32 %xor.i1336, %or.i31.i1346, !dbg !1279
  %305 = load i32, i32* %X.addr.i1321, align 4, !dbg !1280
  %conv11.i1348 = trunc i32 %305 to i8, !dbg !1281
  %idxprom12.i1349 = zext i8 %conv11.i1348 to i64, !dbg !1282
  %arrayidx13.i1350 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1349, !dbg !1282
  %306 = load i32, i32* %arrayidx13.i1350, align 4, !dbg !1282
  store i32 %306, i32* %a.addr.i16.i1317, align 4
  store i8 8, i8* %n.addr.i17.i1318, align 1
  %307 = load i32, i32* %a.addr.i16.i1317, align 4, !dbg !1283
  %308 = load i8, i8* %n.addr.i17.i1318, align 1, !dbg !1284
  %conv.i18.i1351 = zext i8 %308 to i32, !dbg !1284
  %shl.i19.i1352 = shl i32 %307, %conv.i18.i1351, !dbg !1285
  %309 = load i32, i32* %a.addr.i16.i1317, align 4, !dbg !1286
  %310 = load i8, i8* %n.addr.i17.i1318, align 1, !dbg !1287
  %conv1.i20.i1353 = zext i8 %310 to i32, !dbg !1287
  %sub.i21.i1354 = sub nsw i32 32, %conv1.i20.i1353, !dbg !1288
  %shr.i22.i1355 = lshr i32 %309, %sub.i21.i1354, !dbg !1289
  %or.i23.i1356 = or i32 %shl.i19.i1352, %shr.i22.i1355, !dbg !1290
  %xor15.i1357 = xor i32 %xor10.i1347, %or.i23.i1356, !dbg !1291
  %311 = load i32, i32* %B3, align 4, !dbg !1123
  %xor58 = xor i32 %311, %xor15.i1357, !dbg !1123
  store i32 %xor58, i32* %B3, align 4, !dbg !1123
  br label %do.end59, !dbg !1123

do.end59:                                         ; preds = %do.body30
  br label %do.body60, !dbg !1292

do.body60:                                        ; preds = %do.end59
  %312 = load i32, i32* %B1, align 4, !dbg !1293
  %313 = load i32, i32* %B2, align 4, !dbg !1293
  %xor61 = xor i32 %312, %313, !dbg !1293
  %314 = load i32, i32* %B3, align 4, !dbg !1293
  %xor62 = xor i32 %xor61, %314, !dbg !1293
  %315 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1293
  %rk63 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %315, i32 0, i32 0, !dbg !1293
  %arrayidx64 = getelementptr inbounds [32 x i32], [32 x i32]* %rk63, i64 0, i64 8, !dbg !1293
  %316 = load i32, i32* %arrayidx64, align 4, !dbg !1293
  %xor65 = xor i32 %xor62, %316, !dbg !1293
  store i32 %xor65, i32* %X.addr.i1278, align 4
  %317 = load i32, i32* %X.addr.i1278, align 4, !dbg !1294
  %shr.i1279 = lshr i32 %317, 24, !dbg !1295
  %conv.i1280 = trunc i32 %shr.i1279 to i8, !dbg !1296
  %idxprom.i1281 = zext i8 %conv.i1280 to i64, !dbg !1297
  %arrayidx.i1282 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1281, !dbg !1297
  %318 = load i32, i32* %arrayidx.i1282, align 4, !dbg !1297
  %319 = load i32, i32* %X.addr.i1278, align 4, !dbg !1298
  %shr1.i1283 = lshr i32 %319, 16, !dbg !1299
  %conv2.i1284 = trunc i32 %shr1.i1283 to i8, !dbg !1300
  %idxprom3.i1285 = zext i8 %conv2.i1284 to i64, !dbg !1301
  %arrayidx4.i1286 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1285, !dbg !1301
  %320 = load i32, i32* %arrayidx4.i1286, align 4, !dbg !1301
  store i32 %320, i32* %a.addr.i.i1276, align 4
  store i8 24, i8* %n.addr.i.i1277, align 1
  %321 = load i32, i32* %a.addr.i.i1276, align 4, !dbg !1302
  %322 = load i8, i8* %n.addr.i.i1277, align 1, !dbg !1303
  %conv.i.i1287 = zext i8 %322 to i32, !dbg !1303
  %shl.i.i1288 = shl i32 %321, %conv.i.i1287, !dbg !1304
  %323 = load i32, i32* %a.addr.i.i1276, align 4, !dbg !1305
  %324 = load i8, i8* %n.addr.i.i1277, align 1, !dbg !1306
  %conv1.i.i1289 = zext i8 %324 to i32, !dbg !1306
  %sub.i.i1290 = sub nsw i32 32, %conv1.i.i1289, !dbg !1307
  %shr.i.i1291 = lshr i32 %323, %sub.i.i1290, !dbg !1308
  %or.i.i1292 = or i32 %shl.i.i1288, %shr.i.i1291, !dbg !1309
  %xor.i1293 = xor i32 %318, %or.i.i1292, !dbg !1310
  %325 = load i32, i32* %X.addr.i1278, align 4, !dbg !1311
  %shr5.i1294 = lshr i32 %325, 8, !dbg !1312
  %conv6.i1295 = trunc i32 %shr5.i1294 to i8, !dbg !1313
  %idxprom7.i1296 = zext i8 %conv6.i1295 to i64, !dbg !1314
  %arrayidx8.i1297 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1296, !dbg !1314
  %326 = load i32, i32* %arrayidx8.i1297, align 4, !dbg !1314
  store i32 %326, i32* %a.addr.i24.i1272, align 4
  store i8 16, i8* %n.addr.i25.i1273, align 1
  %327 = load i32, i32* %a.addr.i24.i1272, align 4, !dbg !1315
  %328 = load i8, i8* %n.addr.i25.i1273, align 1, !dbg !1316
  %conv.i26.i1298 = zext i8 %328 to i32, !dbg !1316
  %shl.i27.i1299 = shl i32 %327, %conv.i26.i1298, !dbg !1317
  %329 = load i32, i32* %a.addr.i24.i1272, align 4, !dbg !1318
  %330 = load i8, i8* %n.addr.i25.i1273, align 1, !dbg !1319
  %conv1.i28.i1300 = zext i8 %330 to i32, !dbg !1319
  %sub.i29.i1301 = sub nsw i32 32, %conv1.i28.i1300, !dbg !1320
  %shr.i30.i1302 = lshr i32 %329, %sub.i29.i1301, !dbg !1321
  %or.i31.i1303 = or i32 %shl.i27.i1299, %shr.i30.i1302, !dbg !1322
  %xor10.i1304 = xor i32 %xor.i1293, %or.i31.i1303, !dbg !1323
  %331 = load i32, i32* %X.addr.i1278, align 4, !dbg !1324
  %conv11.i1305 = trunc i32 %331 to i8, !dbg !1325
  %idxprom12.i1306 = zext i8 %conv11.i1305 to i64, !dbg !1326
  %arrayidx13.i1307 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1306, !dbg !1326
  %332 = load i32, i32* %arrayidx13.i1307, align 4, !dbg !1326
  store i32 %332, i32* %a.addr.i16.i1274, align 4
  store i8 8, i8* %n.addr.i17.i1275, align 1
  %333 = load i32, i32* %a.addr.i16.i1274, align 4, !dbg !1327
  %334 = load i8, i8* %n.addr.i17.i1275, align 1, !dbg !1328
  %conv.i18.i1308 = zext i8 %334 to i32, !dbg !1328
  %shl.i19.i1309 = shl i32 %333, %conv.i18.i1308, !dbg !1329
  %335 = load i32, i32* %a.addr.i16.i1274, align 4, !dbg !1330
  %336 = load i8, i8* %n.addr.i17.i1275, align 1, !dbg !1331
  %conv1.i20.i1310 = zext i8 %336 to i32, !dbg !1331
  %sub.i21.i1311 = sub nsw i32 32, %conv1.i20.i1310, !dbg !1332
  %shr.i22.i1312 = lshr i32 %335, %sub.i21.i1311, !dbg !1333
  %or.i23.i1313 = or i32 %shl.i19.i1309, %shr.i22.i1312, !dbg !1334
  %xor15.i1314 = xor i32 %xor10.i1304, %or.i23.i1313, !dbg !1335
  %337 = load i32, i32* %B0, align 4, !dbg !1293
  %xor67 = xor i32 %337, %xor15.i1314, !dbg !1293
  store i32 %xor67, i32* %B0, align 4, !dbg !1293
  %338 = load i32, i32* %B0, align 4, !dbg !1293
  %339 = load i32, i32* %B2, align 4, !dbg !1293
  %xor68 = xor i32 %338, %339, !dbg !1293
  %340 = load i32, i32* %B3, align 4, !dbg !1293
  %xor69 = xor i32 %xor68, %340, !dbg !1293
  %341 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1293
  %rk70 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %341, i32 0, i32 0, !dbg !1293
  %arrayidx71 = getelementptr inbounds [32 x i32], [32 x i32]* %rk70, i64 0, i64 9, !dbg !1293
  %342 = load i32, i32* %arrayidx71, align 4, !dbg !1293
  %xor72 = xor i32 %xor69, %342, !dbg !1293
  store i32 %xor72, i32* %X.addr.i1235, align 4
  %343 = load i32, i32* %X.addr.i1235, align 4, !dbg !1336
  %shr.i1236 = lshr i32 %343, 24, !dbg !1337
  %conv.i1237 = trunc i32 %shr.i1236 to i8, !dbg !1338
  %idxprom.i1238 = zext i8 %conv.i1237 to i64, !dbg !1339
  %arrayidx.i1239 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1238, !dbg !1339
  %344 = load i32, i32* %arrayidx.i1239, align 4, !dbg !1339
  %345 = load i32, i32* %X.addr.i1235, align 4, !dbg !1340
  %shr1.i1240 = lshr i32 %345, 16, !dbg !1341
  %conv2.i1241 = trunc i32 %shr1.i1240 to i8, !dbg !1342
  %idxprom3.i1242 = zext i8 %conv2.i1241 to i64, !dbg !1343
  %arrayidx4.i1243 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1242, !dbg !1343
  %346 = load i32, i32* %arrayidx4.i1243, align 4, !dbg !1343
  store i32 %346, i32* %a.addr.i.i1233, align 4
  store i8 24, i8* %n.addr.i.i1234, align 1
  %347 = load i32, i32* %a.addr.i.i1233, align 4, !dbg !1344
  %348 = load i8, i8* %n.addr.i.i1234, align 1, !dbg !1345
  %conv.i.i1244 = zext i8 %348 to i32, !dbg !1345
  %shl.i.i1245 = shl i32 %347, %conv.i.i1244, !dbg !1346
  %349 = load i32, i32* %a.addr.i.i1233, align 4, !dbg !1347
  %350 = load i8, i8* %n.addr.i.i1234, align 1, !dbg !1348
  %conv1.i.i1246 = zext i8 %350 to i32, !dbg !1348
  %sub.i.i1247 = sub nsw i32 32, %conv1.i.i1246, !dbg !1349
  %shr.i.i1248 = lshr i32 %349, %sub.i.i1247, !dbg !1350
  %or.i.i1249 = or i32 %shl.i.i1245, %shr.i.i1248, !dbg !1351
  %xor.i1250 = xor i32 %344, %or.i.i1249, !dbg !1352
  %351 = load i32, i32* %X.addr.i1235, align 4, !dbg !1353
  %shr5.i1251 = lshr i32 %351, 8, !dbg !1354
  %conv6.i1252 = trunc i32 %shr5.i1251 to i8, !dbg !1355
  %idxprom7.i1253 = zext i8 %conv6.i1252 to i64, !dbg !1356
  %arrayidx8.i1254 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1253, !dbg !1356
  %352 = load i32, i32* %arrayidx8.i1254, align 4, !dbg !1356
  store i32 %352, i32* %a.addr.i24.i1229, align 4
  store i8 16, i8* %n.addr.i25.i1230, align 1
  %353 = load i32, i32* %a.addr.i24.i1229, align 4, !dbg !1357
  %354 = load i8, i8* %n.addr.i25.i1230, align 1, !dbg !1358
  %conv.i26.i1255 = zext i8 %354 to i32, !dbg !1358
  %shl.i27.i1256 = shl i32 %353, %conv.i26.i1255, !dbg !1359
  %355 = load i32, i32* %a.addr.i24.i1229, align 4, !dbg !1360
  %356 = load i8, i8* %n.addr.i25.i1230, align 1, !dbg !1361
  %conv1.i28.i1257 = zext i8 %356 to i32, !dbg !1361
  %sub.i29.i1258 = sub nsw i32 32, %conv1.i28.i1257, !dbg !1362
  %shr.i30.i1259 = lshr i32 %355, %sub.i29.i1258, !dbg !1363
  %or.i31.i1260 = or i32 %shl.i27.i1256, %shr.i30.i1259, !dbg !1364
  %xor10.i1261 = xor i32 %xor.i1250, %or.i31.i1260, !dbg !1365
  %357 = load i32, i32* %X.addr.i1235, align 4, !dbg !1366
  %conv11.i1262 = trunc i32 %357 to i8, !dbg !1367
  %idxprom12.i1263 = zext i8 %conv11.i1262 to i64, !dbg !1368
  %arrayidx13.i1264 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1263, !dbg !1368
  %358 = load i32, i32* %arrayidx13.i1264, align 4, !dbg !1368
  store i32 %358, i32* %a.addr.i16.i1231, align 4
  store i8 8, i8* %n.addr.i17.i1232, align 1
  %359 = load i32, i32* %a.addr.i16.i1231, align 4, !dbg !1369
  %360 = load i8, i8* %n.addr.i17.i1232, align 1, !dbg !1370
  %conv.i18.i1265 = zext i8 %360 to i32, !dbg !1370
  %shl.i19.i1266 = shl i32 %359, %conv.i18.i1265, !dbg !1371
  %361 = load i32, i32* %a.addr.i16.i1231, align 4, !dbg !1372
  %362 = load i8, i8* %n.addr.i17.i1232, align 1, !dbg !1373
  %conv1.i20.i1267 = zext i8 %362 to i32, !dbg !1373
  %sub.i21.i1268 = sub nsw i32 32, %conv1.i20.i1267, !dbg !1374
  %shr.i22.i1269 = lshr i32 %361, %sub.i21.i1268, !dbg !1375
  %or.i23.i1270 = or i32 %shl.i19.i1266, %shr.i22.i1269, !dbg !1376
  %xor15.i1271 = xor i32 %xor10.i1261, %or.i23.i1270, !dbg !1377
  %363 = load i32, i32* %B1, align 4, !dbg !1293
  %xor74 = xor i32 %363, %xor15.i1271, !dbg !1293
  store i32 %xor74, i32* %B1, align 4, !dbg !1293
  %364 = load i32, i32* %B0, align 4, !dbg !1293
  %365 = load i32, i32* %B1, align 4, !dbg !1293
  %xor75 = xor i32 %364, %365, !dbg !1293
  %366 = load i32, i32* %B3, align 4, !dbg !1293
  %xor76 = xor i32 %xor75, %366, !dbg !1293
  %367 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1293
  %rk77 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %367, i32 0, i32 0, !dbg !1293
  %arrayidx78 = getelementptr inbounds [32 x i32], [32 x i32]* %rk77, i64 0, i64 10, !dbg !1293
  %368 = load i32, i32* %arrayidx78, align 4, !dbg !1293
  %xor79 = xor i32 %xor76, %368, !dbg !1293
  store i32 %xor79, i32* %X.addr.i1192, align 4
  %369 = load i32, i32* %X.addr.i1192, align 4, !dbg !1378
  %shr.i1193 = lshr i32 %369, 24, !dbg !1379
  %conv.i1194 = trunc i32 %shr.i1193 to i8, !dbg !1380
  %idxprom.i1195 = zext i8 %conv.i1194 to i64, !dbg !1381
  %arrayidx.i1196 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1195, !dbg !1381
  %370 = load i32, i32* %arrayidx.i1196, align 4, !dbg !1381
  %371 = load i32, i32* %X.addr.i1192, align 4, !dbg !1382
  %shr1.i1197 = lshr i32 %371, 16, !dbg !1383
  %conv2.i1198 = trunc i32 %shr1.i1197 to i8, !dbg !1384
  %idxprom3.i1199 = zext i8 %conv2.i1198 to i64, !dbg !1385
  %arrayidx4.i1200 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1199, !dbg !1385
  %372 = load i32, i32* %arrayidx4.i1200, align 4, !dbg !1385
  store i32 %372, i32* %a.addr.i.i1190, align 4
  store i8 24, i8* %n.addr.i.i1191, align 1
  %373 = load i32, i32* %a.addr.i.i1190, align 4, !dbg !1386
  %374 = load i8, i8* %n.addr.i.i1191, align 1, !dbg !1387
  %conv.i.i1201 = zext i8 %374 to i32, !dbg !1387
  %shl.i.i1202 = shl i32 %373, %conv.i.i1201, !dbg !1388
  %375 = load i32, i32* %a.addr.i.i1190, align 4, !dbg !1389
  %376 = load i8, i8* %n.addr.i.i1191, align 1, !dbg !1390
  %conv1.i.i1203 = zext i8 %376 to i32, !dbg !1390
  %sub.i.i1204 = sub nsw i32 32, %conv1.i.i1203, !dbg !1391
  %shr.i.i1205 = lshr i32 %375, %sub.i.i1204, !dbg !1392
  %or.i.i1206 = or i32 %shl.i.i1202, %shr.i.i1205, !dbg !1393
  %xor.i1207 = xor i32 %370, %or.i.i1206, !dbg !1394
  %377 = load i32, i32* %X.addr.i1192, align 4, !dbg !1395
  %shr5.i1208 = lshr i32 %377, 8, !dbg !1396
  %conv6.i1209 = trunc i32 %shr5.i1208 to i8, !dbg !1397
  %idxprom7.i1210 = zext i8 %conv6.i1209 to i64, !dbg !1398
  %arrayidx8.i1211 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1210, !dbg !1398
  %378 = load i32, i32* %arrayidx8.i1211, align 4, !dbg !1398
  store i32 %378, i32* %a.addr.i24.i1186, align 4
  store i8 16, i8* %n.addr.i25.i1187, align 1
  %379 = load i32, i32* %a.addr.i24.i1186, align 4, !dbg !1399
  %380 = load i8, i8* %n.addr.i25.i1187, align 1, !dbg !1400
  %conv.i26.i1212 = zext i8 %380 to i32, !dbg !1400
  %shl.i27.i1213 = shl i32 %379, %conv.i26.i1212, !dbg !1401
  %381 = load i32, i32* %a.addr.i24.i1186, align 4, !dbg !1402
  %382 = load i8, i8* %n.addr.i25.i1187, align 1, !dbg !1403
  %conv1.i28.i1214 = zext i8 %382 to i32, !dbg !1403
  %sub.i29.i1215 = sub nsw i32 32, %conv1.i28.i1214, !dbg !1404
  %shr.i30.i1216 = lshr i32 %381, %sub.i29.i1215, !dbg !1405
  %or.i31.i1217 = or i32 %shl.i27.i1213, %shr.i30.i1216, !dbg !1406
  %xor10.i1218 = xor i32 %xor.i1207, %or.i31.i1217, !dbg !1407
  %383 = load i32, i32* %X.addr.i1192, align 4, !dbg !1408
  %conv11.i1219 = trunc i32 %383 to i8, !dbg !1409
  %idxprom12.i1220 = zext i8 %conv11.i1219 to i64, !dbg !1410
  %arrayidx13.i1221 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1220, !dbg !1410
  %384 = load i32, i32* %arrayidx13.i1221, align 4, !dbg !1410
  store i32 %384, i32* %a.addr.i16.i1188, align 4
  store i8 8, i8* %n.addr.i17.i1189, align 1
  %385 = load i32, i32* %a.addr.i16.i1188, align 4, !dbg !1411
  %386 = load i8, i8* %n.addr.i17.i1189, align 1, !dbg !1412
  %conv.i18.i1222 = zext i8 %386 to i32, !dbg !1412
  %shl.i19.i1223 = shl i32 %385, %conv.i18.i1222, !dbg !1413
  %387 = load i32, i32* %a.addr.i16.i1188, align 4, !dbg !1414
  %388 = load i8, i8* %n.addr.i17.i1189, align 1, !dbg !1415
  %conv1.i20.i1224 = zext i8 %388 to i32, !dbg !1415
  %sub.i21.i1225 = sub nsw i32 32, %conv1.i20.i1224, !dbg !1416
  %shr.i22.i1226 = lshr i32 %387, %sub.i21.i1225, !dbg !1417
  %or.i23.i1227 = or i32 %shl.i19.i1223, %shr.i22.i1226, !dbg !1418
  %xor15.i1228 = xor i32 %xor10.i1218, %or.i23.i1227, !dbg !1419
  %389 = load i32, i32* %B2, align 4, !dbg !1293
  %xor81 = xor i32 %389, %xor15.i1228, !dbg !1293
  store i32 %xor81, i32* %B2, align 4, !dbg !1293
  %390 = load i32, i32* %B0, align 4, !dbg !1293
  %391 = load i32, i32* %B1, align 4, !dbg !1293
  %xor82 = xor i32 %390, %391, !dbg !1293
  %392 = load i32, i32* %B2, align 4, !dbg !1293
  %xor83 = xor i32 %xor82, %392, !dbg !1293
  %393 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1293
  %rk84 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %393, i32 0, i32 0, !dbg !1293
  %arrayidx85 = getelementptr inbounds [32 x i32], [32 x i32]* %rk84, i64 0, i64 11, !dbg !1293
  %394 = load i32, i32* %arrayidx85, align 4, !dbg !1293
  %xor86 = xor i32 %xor83, %394, !dbg !1293
  store i32 %xor86, i32* %X.addr.i1149, align 4
  %395 = load i32, i32* %X.addr.i1149, align 4, !dbg !1420
  %shr.i1150 = lshr i32 %395, 24, !dbg !1421
  %conv.i1151 = trunc i32 %shr.i1150 to i8, !dbg !1422
  %idxprom.i1152 = zext i8 %conv.i1151 to i64, !dbg !1423
  %arrayidx.i1153 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1152, !dbg !1423
  %396 = load i32, i32* %arrayidx.i1153, align 4, !dbg !1423
  %397 = load i32, i32* %X.addr.i1149, align 4, !dbg !1424
  %shr1.i1154 = lshr i32 %397, 16, !dbg !1425
  %conv2.i1155 = trunc i32 %shr1.i1154 to i8, !dbg !1426
  %idxprom3.i1156 = zext i8 %conv2.i1155 to i64, !dbg !1427
  %arrayidx4.i1157 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1156, !dbg !1427
  %398 = load i32, i32* %arrayidx4.i1157, align 4, !dbg !1427
  store i32 %398, i32* %a.addr.i.i1147, align 4
  store i8 24, i8* %n.addr.i.i1148, align 1
  %399 = load i32, i32* %a.addr.i.i1147, align 4, !dbg !1428
  %400 = load i8, i8* %n.addr.i.i1148, align 1, !dbg !1429
  %conv.i.i1158 = zext i8 %400 to i32, !dbg !1429
  %shl.i.i1159 = shl i32 %399, %conv.i.i1158, !dbg !1430
  %401 = load i32, i32* %a.addr.i.i1147, align 4, !dbg !1431
  %402 = load i8, i8* %n.addr.i.i1148, align 1, !dbg !1432
  %conv1.i.i1160 = zext i8 %402 to i32, !dbg !1432
  %sub.i.i1161 = sub nsw i32 32, %conv1.i.i1160, !dbg !1433
  %shr.i.i1162 = lshr i32 %401, %sub.i.i1161, !dbg !1434
  %or.i.i1163 = or i32 %shl.i.i1159, %shr.i.i1162, !dbg !1435
  %xor.i1164 = xor i32 %396, %or.i.i1163, !dbg !1436
  %403 = load i32, i32* %X.addr.i1149, align 4, !dbg !1437
  %shr5.i1165 = lshr i32 %403, 8, !dbg !1438
  %conv6.i1166 = trunc i32 %shr5.i1165 to i8, !dbg !1439
  %idxprom7.i1167 = zext i8 %conv6.i1166 to i64, !dbg !1440
  %arrayidx8.i1168 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1167, !dbg !1440
  %404 = load i32, i32* %arrayidx8.i1168, align 4, !dbg !1440
  store i32 %404, i32* %a.addr.i24.i1143, align 4
  store i8 16, i8* %n.addr.i25.i1144, align 1
  %405 = load i32, i32* %a.addr.i24.i1143, align 4, !dbg !1441
  %406 = load i8, i8* %n.addr.i25.i1144, align 1, !dbg !1442
  %conv.i26.i1169 = zext i8 %406 to i32, !dbg !1442
  %shl.i27.i1170 = shl i32 %405, %conv.i26.i1169, !dbg !1443
  %407 = load i32, i32* %a.addr.i24.i1143, align 4, !dbg !1444
  %408 = load i8, i8* %n.addr.i25.i1144, align 1, !dbg !1445
  %conv1.i28.i1171 = zext i8 %408 to i32, !dbg !1445
  %sub.i29.i1172 = sub nsw i32 32, %conv1.i28.i1171, !dbg !1446
  %shr.i30.i1173 = lshr i32 %407, %sub.i29.i1172, !dbg !1447
  %or.i31.i1174 = or i32 %shl.i27.i1170, %shr.i30.i1173, !dbg !1448
  %xor10.i1175 = xor i32 %xor.i1164, %or.i31.i1174, !dbg !1449
  %409 = load i32, i32* %X.addr.i1149, align 4, !dbg !1450
  %conv11.i1176 = trunc i32 %409 to i8, !dbg !1451
  %idxprom12.i1177 = zext i8 %conv11.i1176 to i64, !dbg !1452
  %arrayidx13.i1178 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1177, !dbg !1452
  %410 = load i32, i32* %arrayidx13.i1178, align 4, !dbg !1452
  store i32 %410, i32* %a.addr.i16.i1145, align 4
  store i8 8, i8* %n.addr.i17.i1146, align 1
  %411 = load i32, i32* %a.addr.i16.i1145, align 4, !dbg !1453
  %412 = load i8, i8* %n.addr.i17.i1146, align 1, !dbg !1454
  %conv.i18.i1179 = zext i8 %412 to i32, !dbg !1454
  %shl.i19.i1180 = shl i32 %411, %conv.i18.i1179, !dbg !1455
  %413 = load i32, i32* %a.addr.i16.i1145, align 4, !dbg !1456
  %414 = load i8, i8* %n.addr.i17.i1146, align 1, !dbg !1457
  %conv1.i20.i1181 = zext i8 %414 to i32, !dbg !1457
  %sub.i21.i1182 = sub nsw i32 32, %conv1.i20.i1181, !dbg !1458
  %shr.i22.i1183 = lshr i32 %413, %sub.i21.i1182, !dbg !1459
  %or.i23.i1184 = or i32 %shl.i19.i1180, %shr.i22.i1183, !dbg !1460
  %xor15.i1185 = xor i32 %xor10.i1175, %or.i23.i1184, !dbg !1461
  %415 = load i32, i32* %B3, align 4, !dbg !1293
  %xor88 = xor i32 %415, %xor15.i1185, !dbg !1293
  store i32 %xor88, i32* %B3, align 4, !dbg !1293
  br label %do.end89, !dbg !1293

do.end89:                                         ; preds = %do.body60
  br label %do.body90, !dbg !1462

do.body90:                                        ; preds = %do.end89
  %416 = load i32, i32* %B1, align 4, !dbg !1463
  %417 = load i32, i32* %B2, align 4, !dbg !1463
  %xor91 = xor i32 %416, %417, !dbg !1463
  %418 = load i32, i32* %B3, align 4, !dbg !1463
  %xor92 = xor i32 %xor91, %418, !dbg !1463
  %419 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1463
  %rk93 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %419, i32 0, i32 0, !dbg !1463
  %arrayidx94 = getelementptr inbounds [32 x i32], [32 x i32]* %rk93, i64 0, i64 12, !dbg !1463
  %420 = load i32, i32* %arrayidx94, align 4, !dbg !1463
  %xor95 = xor i32 %xor92, %420, !dbg !1463
  store i32 %xor95, i32* %X.addr.i1106, align 4
  %421 = load i32, i32* %X.addr.i1106, align 4, !dbg !1464
  %shr.i1107 = lshr i32 %421, 24, !dbg !1465
  %conv.i1108 = trunc i32 %shr.i1107 to i8, !dbg !1466
  %idxprom.i1109 = zext i8 %conv.i1108 to i64, !dbg !1467
  %arrayidx.i1110 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1109, !dbg !1467
  %422 = load i32, i32* %arrayidx.i1110, align 4, !dbg !1467
  %423 = load i32, i32* %X.addr.i1106, align 4, !dbg !1468
  %shr1.i1111 = lshr i32 %423, 16, !dbg !1469
  %conv2.i1112 = trunc i32 %shr1.i1111 to i8, !dbg !1470
  %idxprom3.i1113 = zext i8 %conv2.i1112 to i64, !dbg !1471
  %arrayidx4.i1114 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1113, !dbg !1471
  %424 = load i32, i32* %arrayidx4.i1114, align 4, !dbg !1471
  store i32 %424, i32* %a.addr.i.i1104, align 4
  store i8 24, i8* %n.addr.i.i1105, align 1
  %425 = load i32, i32* %a.addr.i.i1104, align 4, !dbg !1472
  %426 = load i8, i8* %n.addr.i.i1105, align 1, !dbg !1473
  %conv.i.i1115 = zext i8 %426 to i32, !dbg !1473
  %shl.i.i1116 = shl i32 %425, %conv.i.i1115, !dbg !1474
  %427 = load i32, i32* %a.addr.i.i1104, align 4, !dbg !1475
  %428 = load i8, i8* %n.addr.i.i1105, align 1, !dbg !1476
  %conv1.i.i1117 = zext i8 %428 to i32, !dbg !1476
  %sub.i.i1118 = sub nsw i32 32, %conv1.i.i1117, !dbg !1477
  %shr.i.i1119 = lshr i32 %427, %sub.i.i1118, !dbg !1478
  %or.i.i1120 = or i32 %shl.i.i1116, %shr.i.i1119, !dbg !1479
  %xor.i1121 = xor i32 %422, %or.i.i1120, !dbg !1480
  %429 = load i32, i32* %X.addr.i1106, align 4, !dbg !1481
  %shr5.i1122 = lshr i32 %429, 8, !dbg !1482
  %conv6.i1123 = trunc i32 %shr5.i1122 to i8, !dbg !1483
  %idxprom7.i1124 = zext i8 %conv6.i1123 to i64, !dbg !1484
  %arrayidx8.i1125 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1124, !dbg !1484
  %430 = load i32, i32* %arrayidx8.i1125, align 4, !dbg !1484
  store i32 %430, i32* %a.addr.i24.i1100, align 4
  store i8 16, i8* %n.addr.i25.i1101, align 1
  %431 = load i32, i32* %a.addr.i24.i1100, align 4, !dbg !1485
  %432 = load i8, i8* %n.addr.i25.i1101, align 1, !dbg !1486
  %conv.i26.i1126 = zext i8 %432 to i32, !dbg !1486
  %shl.i27.i1127 = shl i32 %431, %conv.i26.i1126, !dbg !1487
  %433 = load i32, i32* %a.addr.i24.i1100, align 4, !dbg !1488
  %434 = load i8, i8* %n.addr.i25.i1101, align 1, !dbg !1489
  %conv1.i28.i1128 = zext i8 %434 to i32, !dbg !1489
  %sub.i29.i1129 = sub nsw i32 32, %conv1.i28.i1128, !dbg !1490
  %shr.i30.i1130 = lshr i32 %433, %sub.i29.i1129, !dbg !1491
  %or.i31.i1131 = or i32 %shl.i27.i1127, %shr.i30.i1130, !dbg !1492
  %xor10.i1132 = xor i32 %xor.i1121, %or.i31.i1131, !dbg !1493
  %435 = load i32, i32* %X.addr.i1106, align 4, !dbg !1494
  %conv11.i1133 = trunc i32 %435 to i8, !dbg !1495
  %idxprom12.i1134 = zext i8 %conv11.i1133 to i64, !dbg !1496
  %arrayidx13.i1135 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1134, !dbg !1496
  %436 = load i32, i32* %arrayidx13.i1135, align 4, !dbg !1496
  store i32 %436, i32* %a.addr.i16.i1102, align 4
  store i8 8, i8* %n.addr.i17.i1103, align 1
  %437 = load i32, i32* %a.addr.i16.i1102, align 4, !dbg !1497
  %438 = load i8, i8* %n.addr.i17.i1103, align 1, !dbg !1498
  %conv.i18.i1136 = zext i8 %438 to i32, !dbg !1498
  %shl.i19.i1137 = shl i32 %437, %conv.i18.i1136, !dbg !1499
  %439 = load i32, i32* %a.addr.i16.i1102, align 4, !dbg !1500
  %440 = load i8, i8* %n.addr.i17.i1103, align 1, !dbg !1501
  %conv1.i20.i1138 = zext i8 %440 to i32, !dbg !1501
  %sub.i21.i1139 = sub nsw i32 32, %conv1.i20.i1138, !dbg !1502
  %shr.i22.i1140 = lshr i32 %439, %sub.i21.i1139, !dbg !1503
  %or.i23.i1141 = or i32 %shl.i19.i1137, %shr.i22.i1140, !dbg !1504
  %xor15.i1142 = xor i32 %xor10.i1132, %or.i23.i1141, !dbg !1505
  %441 = load i32, i32* %B0, align 4, !dbg !1463
  %xor97 = xor i32 %441, %xor15.i1142, !dbg !1463
  store i32 %xor97, i32* %B0, align 4, !dbg !1463
  %442 = load i32, i32* %B0, align 4, !dbg !1463
  %443 = load i32, i32* %B2, align 4, !dbg !1463
  %xor98 = xor i32 %442, %443, !dbg !1463
  %444 = load i32, i32* %B3, align 4, !dbg !1463
  %xor99 = xor i32 %xor98, %444, !dbg !1463
  %445 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1463
  %rk100 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %445, i32 0, i32 0, !dbg !1463
  %arrayidx101 = getelementptr inbounds [32 x i32], [32 x i32]* %rk100, i64 0, i64 13, !dbg !1463
  %446 = load i32, i32* %arrayidx101, align 4, !dbg !1463
  %xor102 = xor i32 %xor99, %446, !dbg !1463
  store i32 %xor102, i32* %X.addr.i1063, align 4
  %447 = load i32, i32* %X.addr.i1063, align 4, !dbg !1506
  %shr.i1064 = lshr i32 %447, 24, !dbg !1507
  %conv.i1065 = trunc i32 %shr.i1064 to i8, !dbg !1508
  %idxprom.i1066 = zext i8 %conv.i1065 to i64, !dbg !1509
  %arrayidx.i1067 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1066, !dbg !1509
  %448 = load i32, i32* %arrayidx.i1067, align 4, !dbg !1509
  %449 = load i32, i32* %X.addr.i1063, align 4, !dbg !1510
  %shr1.i1068 = lshr i32 %449, 16, !dbg !1511
  %conv2.i1069 = trunc i32 %shr1.i1068 to i8, !dbg !1512
  %idxprom3.i1070 = zext i8 %conv2.i1069 to i64, !dbg !1513
  %arrayidx4.i1071 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1070, !dbg !1513
  %450 = load i32, i32* %arrayidx4.i1071, align 4, !dbg !1513
  store i32 %450, i32* %a.addr.i.i1061, align 4
  store i8 24, i8* %n.addr.i.i1062, align 1
  %451 = load i32, i32* %a.addr.i.i1061, align 4, !dbg !1514
  %452 = load i8, i8* %n.addr.i.i1062, align 1, !dbg !1515
  %conv.i.i1072 = zext i8 %452 to i32, !dbg !1515
  %shl.i.i1073 = shl i32 %451, %conv.i.i1072, !dbg !1516
  %453 = load i32, i32* %a.addr.i.i1061, align 4, !dbg !1517
  %454 = load i8, i8* %n.addr.i.i1062, align 1, !dbg !1518
  %conv1.i.i1074 = zext i8 %454 to i32, !dbg !1518
  %sub.i.i1075 = sub nsw i32 32, %conv1.i.i1074, !dbg !1519
  %shr.i.i1076 = lshr i32 %453, %sub.i.i1075, !dbg !1520
  %or.i.i1077 = or i32 %shl.i.i1073, %shr.i.i1076, !dbg !1521
  %xor.i1078 = xor i32 %448, %or.i.i1077, !dbg !1522
  %455 = load i32, i32* %X.addr.i1063, align 4, !dbg !1523
  %shr5.i1079 = lshr i32 %455, 8, !dbg !1524
  %conv6.i1080 = trunc i32 %shr5.i1079 to i8, !dbg !1525
  %idxprom7.i1081 = zext i8 %conv6.i1080 to i64, !dbg !1526
  %arrayidx8.i1082 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1081, !dbg !1526
  %456 = load i32, i32* %arrayidx8.i1082, align 4, !dbg !1526
  store i32 %456, i32* %a.addr.i24.i1057, align 4
  store i8 16, i8* %n.addr.i25.i1058, align 1
  %457 = load i32, i32* %a.addr.i24.i1057, align 4, !dbg !1527
  %458 = load i8, i8* %n.addr.i25.i1058, align 1, !dbg !1528
  %conv.i26.i1083 = zext i8 %458 to i32, !dbg !1528
  %shl.i27.i1084 = shl i32 %457, %conv.i26.i1083, !dbg !1529
  %459 = load i32, i32* %a.addr.i24.i1057, align 4, !dbg !1530
  %460 = load i8, i8* %n.addr.i25.i1058, align 1, !dbg !1531
  %conv1.i28.i1085 = zext i8 %460 to i32, !dbg !1531
  %sub.i29.i1086 = sub nsw i32 32, %conv1.i28.i1085, !dbg !1532
  %shr.i30.i1087 = lshr i32 %459, %sub.i29.i1086, !dbg !1533
  %or.i31.i1088 = or i32 %shl.i27.i1084, %shr.i30.i1087, !dbg !1534
  %xor10.i1089 = xor i32 %xor.i1078, %or.i31.i1088, !dbg !1535
  %461 = load i32, i32* %X.addr.i1063, align 4, !dbg !1536
  %conv11.i1090 = trunc i32 %461 to i8, !dbg !1537
  %idxprom12.i1091 = zext i8 %conv11.i1090 to i64, !dbg !1538
  %arrayidx13.i1092 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1091, !dbg !1538
  %462 = load i32, i32* %arrayidx13.i1092, align 4, !dbg !1538
  store i32 %462, i32* %a.addr.i16.i1059, align 4
  store i8 8, i8* %n.addr.i17.i1060, align 1
  %463 = load i32, i32* %a.addr.i16.i1059, align 4, !dbg !1539
  %464 = load i8, i8* %n.addr.i17.i1060, align 1, !dbg !1540
  %conv.i18.i1093 = zext i8 %464 to i32, !dbg !1540
  %shl.i19.i1094 = shl i32 %463, %conv.i18.i1093, !dbg !1541
  %465 = load i32, i32* %a.addr.i16.i1059, align 4, !dbg !1542
  %466 = load i8, i8* %n.addr.i17.i1060, align 1, !dbg !1543
  %conv1.i20.i1095 = zext i8 %466 to i32, !dbg !1543
  %sub.i21.i1096 = sub nsw i32 32, %conv1.i20.i1095, !dbg !1544
  %shr.i22.i1097 = lshr i32 %465, %sub.i21.i1096, !dbg !1545
  %or.i23.i1098 = or i32 %shl.i19.i1094, %shr.i22.i1097, !dbg !1546
  %xor15.i1099 = xor i32 %xor10.i1089, %or.i23.i1098, !dbg !1547
  %467 = load i32, i32* %B1, align 4, !dbg !1463
  %xor104 = xor i32 %467, %xor15.i1099, !dbg !1463
  store i32 %xor104, i32* %B1, align 4, !dbg !1463
  %468 = load i32, i32* %B0, align 4, !dbg !1463
  %469 = load i32, i32* %B1, align 4, !dbg !1463
  %xor105 = xor i32 %468, %469, !dbg !1463
  %470 = load i32, i32* %B3, align 4, !dbg !1463
  %xor106 = xor i32 %xor105, %470, !dbg !1463
  %471 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1463
  %rk107 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %471, i32 0, i32 0, !dbg !1463
  %arrayidx108 = getelementptr inbounds [32 x i32], [32 x i32]* %rk107, i64 0, i64 14, !dbg !1463
  %472 = load i32, i32* %arrayidx108, align 4, !dbg !1463
  %xor109 = xor i32 %xor106, %472, !dbg !1463
  store i32 %xor109, i32* %X.addr.i1020, align 4
  %473 = load i32, i32* %X.addr.i1020, align 4, !dbg !1548
  %shr.i1021 = lshr i32 %473, 24, !dbg !1549
  %conv.i1022 = trunc i32 %shr.i1021 to i8, !dbg !1550
  %idxprom.i1023 = zext i8 %conv.i1022 to i64, !dbg !1551
  %arrayidx.i1024 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1023, !dbg !1551
  %474 = load i32, i32* %arrayidx.i1024, align 4, !dbg !1551
  %475 = load i32, i32* %X.addr.i1020, align 4, !dbg !1552
  %shr1.i1025 = lshr i32 %475, 16, !dbg !1553
  %conv2.i1026 = trunc i32 %shr1.i1025 to i8, !dbg !1554
  %idxprom3.i1027 = zext i8 %conv2.i1026 to i64, !dbg !1555
  %arrayidx4.i1028 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1027, !dbg !1555
  %476 = load i32, i32* %arrayidx4.i1028, align 4, !dbg !1555
  store i32 %476, i32* %a.addr.i.i1018, align 4
  store i8 24, i8* %n.addr.i.i1019, align 1
  %477 = load i32, i32* %a.addr.i.i1018, align 4, !dbg !1556
  %478 = load i8, i8* %n.addr.i.i1019, align 1, !dbg !1557
  %conv.i.i1029 = zext i8 %478 to i32, !dbg !1557
  %shl.i.i1030 = shl i32 %477, %conv.i.i1029, !dbg !1558
  %479 = load i32, i32* %a.addr.i.i1018, align 4, !dbg !1559
  %480 = load i8, i8* %n.addr.i.i1019, align 1, !dbg !1560
  %conv1.i.i1031 = zext i8 %480 to i32, !dbg !1560
  %sub.i.i1032 = sub nsw i32 32, %conv1.i.i1031, !dbg !1561
  %shr.i.i1033 = lshr i32 %479, %sub.i.i1032, !dbg !1562
  %or.i.i1034 = or i32 %shl.i.i1030, %shr.i.i1033, !dbg !1563
  %xor.i1035 = xor i32 %474, %or.i.i1034, !dbg !1564
  %481 = load i32, i32* %X.addr.i1020, align 4, !dbg !1565
  %shr5.i1036 = lshr i32 %481, 8, !dbg !1566
  %conv6.i1037 = trunc i32 %shr5.i1036 to i8, !dbg !1567
  %idxprom7.i1038 = zext i8 %conv6.i1037 to i64, !dbg !1568
  %arrayidx8.i1039 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1038, !dbg !1568
  %482 = load i32, i32* %arrayidx8.i1039, align 4, !dbg !1568
  store i32 %482, i32* %a.addr.i24.i1014, align 4
  store i8 16, i8* %n.addr.i25.i1015, align 1
  %483 = load i32, i32* %a.addr.i24.i1014, align 4, !dbg !1569
  %484 = load i8, i8* %n.addr.i25.i1015, align 1, !dbg !1570
  %conv.i26.i1040 = zext i8 %484 to i32, !dbg !1570
  %shl.i27.i1041 = shl i32 %483, %conv.i26.i1040, !dbg !1571
  %485 = load i32, i32* %a.addr.i24.i1014, align 4, !dbg !1572
  %486 = load i8, i8* %n.addr.i25.i1015, align 1, !dbg !1573
  %conv1.i28.i1042 = zext i8 %486 to i32, !dbg !1573
  %sub.i29.i1043 = sub nsw i32 32, %conv1.i28.i1042, !dbg !1574
  %shr.i30.i1044 = lshr i32 %485, %sub.i29.i1043, !dbg !1575
  %or.i31.i1045 = or i32 %shl.i27.i1041, %shr.i30.i1044, !dbg !1576
  %xor10.i1046 = xor i32 %xor.i1035, %or.i31.i1045, !dbg !1577
  %487 = load i32, i32* %X.addr.i1020, align 4, !dbg !1578
  %conv11.i1047 = trunc i32 %487 to i8, !dbg !1579
  %idxprom12.i1048 = zext i8 %conv11.i1047 to i64, !dbg !1580
  %arrayidx13.i1049 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1048, !dbg !1580
  %488 = load i32, i32* %arrayidx13.i1049, align 4, !dbg !1580
  store i32 %488, i32* %a.addr.i16.i1016, align 4
  store i8 8, i8* %n.addr.i17.i1017, align 1
  %489 = load i32, i32* %a.addr.i16.i1016, align 4, !dbg !1581
  %490 = load i8, i8* %n.addr.i17.i1017, align 1, !dbg !1582
  %conv.i18.i1050 = zext i8 %490 to i32, !dbg !1582
  %shl.i19.i1051 = shl i32 %489, %conv.i18.i1050, !dbg !1583
  %491 = load i32, i32* %a.addr.i16.i1016, align 4, !dbg !1584
  %492 = load i8, i8* %n.addr.i17.i1017, align 1, !dbg !1585
  %conv1.i20.i1052 = zext i8 %492 to i32, !dbg !1585
  %sub.i21.i1053 = sub nsw i32 32, %conv1.i20.i1052, !dbg !1586
  %shr.i22.i1054 = lshr i32 %491, %sub.i21.i1053, !dbg !1587
  %or.i23.i1055 = or i32 %shl.i19.i1051, %shr.i22.i1054, !dbg !1588
  %xor15.i1056 = xor i32 %xor10.i1046, %or.i23.i1055, !dbg !1589
  %493 = load i32, i32* %B2, align 4, !dbg !1463
  %xor111 = xor i32 %493, %xor15.i1056, !dbg !1463
  store i32 %xor111, i32* %B2, align 4, !dbg !1463
  %494 = load i32, i32* %B0, align 4, !dbg !1463
  %495 = load i32, i32* %B1, align 4, !dbg !1463
  %xor112 = xor i32 %494, %495, !dbg !1463
  %496 = load i32, i32* %B2, align 4, !dbg !1463
  %xor113 = xor i32 %xor112, %496, !dbg !1463
  %497 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1463
  %rk114 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %497, i32 0, i32 0, !dbg !1463
  %arrayidx115 = getelementptr inbounds [32 x i32], [32 x i32]* %rk114, i64 0, i64 15, !dbg !1463
  %498 = load i32, i32* %arrayidx115, align 4, !dbg !1463
  %xor116 = xor i32 %xor113, %498, !dbg !1463
  store i32 %xor116, i32* %X.addr.i977, align 4
  %499 = load i32, i32* %X.addr.i977, align 4, !dbg !1590
  %shr.i978 = lshr i32 %499, 24, !dbg !1591
  %conv.i979 = trunc i32 %shr.i978 to i8, !dbg !1592
  %idxprom.i980 = zext i8 %conv.i979 to i64, !dbg !1593
  %arrayidx.i981 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i980, !dbg !1593
  %500 = load i32, i32* %arrayidx.i981, align 4, !dbg !1593
  %501 = load i32, i32* %X.addr.i977, align 4, !dbg !1594
  %shr1.i982 = lshr i32 %501, 16, !dbg !1595
  %conv2.i983 = trunc i32 %shr1.i982 to i8, !dbg !1596
  %idxprom3.i984 = zext i8 %conv2.i983 to i64, !dbg !1597
  %arrayidx4.i985 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i984, !dbg !1597
  %502 = load i32, i32* %arrayidx4.i985, align 4, !dbg !1597
  store i32 %502, i32* %a.addr.i.i975, align 4
  store i8 24, i8* %n.addr.i.i976, align 1
  %503 = load i32, i32* %a.addr.i.i975, align 4, !dbg !1598
  %504 = load i8, i8* %n.addr.i.i976, align 1, !dbg !1599
  %conv.i.i986 = zext i8 %504 to i32, !dbg !1599
  %shl.i.i987 = shl i32 %503, %conv.i.i986, !dbg !1600
  %505 = load i32, i32* %a.addr.i.i975, align 4, !dbg !1601
  %506 = load i8, i8* %n.addr.i.i976, align 1, !dbg !1602
  %conv1.i.i988 = zext i8 %506 to i32, !dbg !1602
  %sub.i.i989 = sub nsw i32 32, %conv1.i.i988, !dbg !1603
  %shr.i.i990 = lshr i32 %505, %sub.i.i989, !dbg !1604
  %or.i.i991 = or i32 %shl.i.i987, %shr.i.i990, !dbg !1605
  %xor.i992 = xor i32 %500, %or.i.i991, !dbg !1606
  %507 = load i32, i32* %X.addr.i977, align 4, !dbg !1607
  %shr5.i993 = lshr i32 %507, 8, !dbg !1608
  %conv6.i994 = trunc i32 %shr5.i993 to i8, !dbg !1609
  %idxprom7.i995 = zext i8 %conv6.i994 to i64, !dbg !1610
  %arrayidx8.i996 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i995, !dbg !1610
  %508 = load i32, i32* %arrayidx8.i996, align 4, !dbg !1610
  store i32 %508, i32* %a.addr.i24.i971, align 4
  store i8 16, i8* %n.addr.i25.i972, align 1
  %509 = load i32, i32* %a.addr.i24.i971, align 4, !dbg !1611
  %510 = load i8, i8* %n.addr.i25.i972, align 1, !dbg !1612
  %conv.i26.i997 = zext i8 %510 to i32, !dbg !1612
  %shl.i27.i998 = shl i32 %509, %conv.i26.i997, !dbg !1613
  %511 = load i32, i32* %a.addr.i24.i971, align 4, !dbg !1614
  %512 = load i8, i8* %n.addr.i25.i972, align 1, !dbg !1615
  %conv1.i28.i999 = zext i8 %512 to i32, !dbg !1615
  %sub.i29.i1000 = sub nsw i32 32, %conv1.i28.i999, !dbg !1616
  %shr.i30.i1001 = lshr i32 %511, %sub.i29.i1000, !dbg !1617
  %or.i31.i1002 = or i32 %shl.i27.i998, %shr.i30.i1001, !dbg !1618
  %xor10.i1003 = xor i32 %xor.i992, %or.i31.i1002, !dbg !1619
  %513 = load i32, i32* %X.addr.i977, align 4, !dbg !1620
  %conv11.i1004 = trunc i32 %513 to i8, !dbg !1621
  %idxprom12.i1005 = zext i8 %conv11.i1004 to i64, !dbg !1622
  %arrayidx13.i1006 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1005, !dbg !1622
  %514 = load i32, i32* %arrayidx13.i1006, align 4, !dbg !1622
  store i32 %514, i32* %a.addr.i16.i973, align 4
  store i8 8, i8* %n.addr.i17.i974, align 1
  %515 = load i32, i32* %a.addr.i16.i973, align 4, !dbg !1623
  %516 = load i8, i8* %n.addr.i17.i974, align 1, !dbg !1624
  %conv.i18.i1007 = zext i8 %516 to i32, !dbg !1624
  %shl.i19.i1008 = shl i32 %515, %conv.i18.i1007, !dbg !1625
  %517 = load i32, i32* %a.addr.i16.i973, align 4, !dbg !1626
  %518 = load i8, i8* %n.addr.i17.i974, align 1, !dbg !1627
  %conv1.i20.i1009 = zext i8 %518 to i32, !dbg !1627
  %sub.i21.i1010 = sub nsw i32 32, %conv1.i20.i1009, !dbg !1628
  %shr.i22.i1011 = lshr i32 %517, %sub.i21.i1010, !dbg !1629
  %or.i23.i1012 = or i32 %shl.i19.i1008, %shr.i22.i1011, !dbg !1630
  %xor15.i1013 = xor i32 %xor10.i1003, %or.i23.i1012, !dbg !1631
  %519 = load i32, i32* %B3, align 4, !dbg !1463
  %xor118 = xor i32 %519, %xor15.i1013, !dbg !1463
  store i32 %xor118, i32* %B3, align 4, !dbg !1463
  br label %do.end119, !dbg !1463

do.end119:                                        ; preds = %do.body90
  br label %do.body120, !dbg !1632

do.body120:                                       ; preds = %do.end119
  %520 = load i32, i32* %B1, align 4, !dbg !1633
  %521 = load i32, i32* %B2, align 4, !dbg !1633
  %xor121 = xor i32 %520, %521, !dbg !1633
  %522 = load i32, i32* %B3, align 4, !dbg !1633
  %xor122 = xor i32 %xor121, %522, !dbg !1633
  %523 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1633
  %rk123 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %523, i32 0, i32 0, !dbg !1633
  %arrayidx124 = getelementptr inbounds [32 x i32], [32 x i32]* %rk123, i64 0, i64 16, !dbg !1633
  %524 = load i32, i32* %arrayidx124, align 4, !dbg !1633
  %xor125 = xor i32 %xor122, %524, !dbg !1633
  store i32 %xor125, i32* %X.addr.i934, align 4
  %525 = load i32, i32* %X.addr.i934, align 4, !dbg !1634
  %shr.i935 = lshr i32 %525, 24, !dbg !1635
  %conv.i936 = trunc i32 %shr.i935 to i8, !dbg !1636
  %idxprom.i937 = zext i8 %conv.i936 to i64, !dbg !1637
  %arrayidx.i938 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i937, !dbg !1637
  %526 = load i32, i32* %arrayidx.i938, align 4, !dbg !1637
  %527 = load i32, i32* %X.addr.i934, align 4, !dbg !1638
  %shr1.i939 = lshr i32 %527, 16, !dbg !1639
  %conv2.i940 = trunc i32 %shr1.i939 to i8, !dbg !1640
  %idxprom3.i941 = zext i8 %conv2.i940 to i64, !dbg !1641
  %arrayidx4.i942 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i941, !dbg !1641
  %528 = load i32, i32* %arrayidx4.i942, align 4, !dbg !1641
  store i32 %528, i32* %a.addr.i.i932, align 4
  store i8 24, i8* %n.addr.i.i933, align 1
  %529 = load i32, i32* %a.addr.i.i932, align 4, !dbg !1642
  %530 = load i8, i8* %n.addr.i.i933, align 1, !dbg !1643
  %conv.i.i943 = zext i8 %530 to i32, !dbg !1643
  %shl.i.i944 = shl i32 %529, %conv.i.i943, !dbg !1644
  %531 = load i32, i32* %a.addr.i.i932, align 4, !dbg !1645
  %532 = load i8, i8* %n.addr.i.i933, align 1, !dbg !1646
  %conv1.i.i945 = zext i8 %532 to i32, !dbg !1646
  %sub.i.i946 = sub nsw i32 32, %conv1.i.i945, !dbg !1647
  %shr.i.i947 = lshr i32 %531, %sub.i.i946, !dbg !1648
  %or.i.i948 = or i32 %shl.i.i944, %shr.i.i947, !dbg !1649
  %xor.i949 = xor i32 %526, %or.i.i948, !dbg !1650
  %533 = load i32, i32* %X.addr.i934, align 4, !dbg !1651
  %shr5.i950 = lshr i32 %533, 8, !dbg !1652
  %conv6.i951 = trunc i32 %shr5.i950 to i8, !dbg !1653
  %idxprom7.i952 = zext i8 %conv6.i951 to i64, !dbg !1654
  %arrayidx8.i953 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i952, !dbg !1654
  %534 = load i32, i32* %arrayidx8.i953, align 4, !dbg !1654
  store i32 %534, i32* %a.addr.i24.i928, align 4
  store i8 16, i8* %n.addr.i25.i929, align 1
  %535 = load i32, i32* %a.addr.i24.i928, align 4, !dbg !1655
  %536 = load i8, i8* %n.addr.i25.i929, align 1, !dbg !1656
  %conv.i26.i954 = zext i8 %536 to i32, !dbg !1656
  %shl.i27.i955 = shl i32 %535, %conv.i26.i954, !dbg !1657
  %537 = load i32, i32* %a.addr.i24.i928, align 4, !dbg !1658
  %538 = load i8, i8* %n.addr.i25.i929, align 1, !dbg !1659
  %conv1.i28.i956 = zext i8 %538 to i32, !dbg !1659
  %sub.i29.i957 = sub nsw i32 32, %conv1.i28.i956, !dbg !1660
  %shr.i30.i958 = lshr i32 %537, %sub.i29.i957, !dbg !1661
  %or.i31.i959 = or i32 %shl.i27.i955, %shr.i30.i958, !dbg !1662
  %xor10.i960 = xor i32 %xor.i949, %or.i31.i959, !dbg !1663
  %539 = load i32, i32* %X.addr.i934, align 4, !dbg !1664
  %conv11.i961 = trunc i32 %539 to i8, !dbg !1665
  %idxprom12.i962 = zext i8 %conv11.i961 to i64, !dbg !1666
  %arrayidx13.i963 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i962, !dbg !1666
  %540 = load i32, i32* %arrayidx13.i963, align 4, !dbg !1666
  store i32 %540, i32* %a.addr.i16.i930, align 4
  store i8 8, i8* %n.addr.i17.i931, align 1
  %541 = load i32, i32* %a.addr.i16.i930, align 4, !dbg !1667
  %542 = load i8, i8* %n.addr.i17.i931, align 1, !dbg !1668
  %conv.i18.i964 = zext i8 %542 to i32, !dbg !1668
  %shl.i19.i965 = shl i32 %541, %conv.i18.i964, !dbg !1669
  %543 = load i32, i32* %a.addr.i16.i930, align 4, !dbg !1670
  %544 = load i8, i8* %n.addr.i17.i931, align 1, !dbg !1671
  %conv1.i20.i966 = zext i8 %544 to i32, !dbg !1671
  %sub.i21.i967 = sub nsw i32 32, %conv1.i20.i966, !dbg !1672
  %shr.i22.i968 = lshr i32 %543, %sub.i21.i967, !dbg !1673
  %or.i23.i969 = or i32 %shl.i19.i965, %shr.i22.i968, !dbg !1674
  %xor15.i970 = xor i32 %xor10.i960, %or.i23.i969, !dbg !1675
  %545 = load i32, i32* %B0, align 4, !dbg !1633
  %xor127 = xor i32 %545, %xor15.i970, !dbg !1633
  store i32 %xor127, i32* %B0, align 4, !dbg !1633
  %546 = load i32, i32* %B0, align 4, !dbg !1633
  %547 = load i32, i32* %B2, align 4, !dbg !1633
  %xor128 = xor i32 %546, %547, !dbg !1633
  %548 = load i32, i32* %B3, align 4, !dbg !1633
  %xor129 = xor i32 %xor128, %548, !dbg !1633
  %549 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1633
  %rk130 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %549, i32 0, i32 0, !dbg !1633
  %arrayidx131 = getelementptr inbounds [32 x i32], [32 x i32]* %rk130, i64 0, i64 17, !dbg !1633
  %550 = load i32, i32* %arrayidx131, align 4, !dbg !1633
  %xor132 = xor i32 %xor129, %550, !dbg !1633
  store i32 %xor132, i32* %X.addr.i891, align 4
  %551 = load i32, i32* %X.addr.i891, align 4, !dbg !1676
  %shr.i892 = lshr i32 %551, 24, !dbg !1677
  %conv.i893 = trunc i32 %shr.i892 to i8, !dbg !1678
  %idxprom.i894 = zext i8 %conv.i893 to i64, !dbg !1679
  %arrayidx.i895 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i894, !dbg !1679
  %552 = load i32, i32* %arrayidx.i895, align 4, !dbg !1679
  %553 = load i32, i32* %X.addr.i891, align 4, !dbg !1680
  %shr1.i896 = lshr i32 %553, 16, !dbg !1681
  %conv2.i897 = trunc i32 %shr1.i896 to i8, !dbg !1682
  %idxprom3.i898 = zext i8 %conv2.i897 to i64, !dbg !1683
  %arrayidx4.i899 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i898, !dbg !1683
  %554 = load i32, i32* %arrayidx4.i899, align 4, !dbg !1683
  store i32 %554, i32* %a.addr.i.i889, align 4
  store i8 24, i8* %n.addr.i.i890, align 1
  %555 = load i32, i32* %a.addr.i.i889, align 4, !dbg !1684
  %556 = load i8, i8* %n.addr.i.i890, align 1, !dbg !1685
  %conv.i.i900 = zext i8 %556 to i32, !dbg !1685
  %shl.i.i901 = shl i32 %555, %conv.i.i900, !dbg !1686
  %557 = load i32, i32* %a.addr.i.i889, align 4, !dbg !1687
  %558 = load i8, i8* %n.addr.i.i890, align 1, !dbg !1688
  %conv1.i.i902 = zext i8 %558 to i32, !dbg !1688
  %sub.i.i903 = sub nsw i32 32, %conv1.i.i902, !dbg !1689
  %shr.i.i904 = lshr i32 %557, %sub.i.i903, !dbg !1690
  %or.i.i905 = or i32 %shl.i.i901, %shr.i.i904, !dbg !1691
  %xor.i906 = xor i32 %552, %or.i.i905, !dbg !1692
  %559 = load i32, i32* %X.addr.i891, align 4, !dbg !1693
  %shr5.i907 = lshr i32 %559, 8, !dbg !1694
  %conv6.i908 = trunc i32 %shr5.i907 to i8, !dbg !1695
  %idxprom7.i909 = zext i8 %conv6.i908 to i64, !dbg !1696
  %arrayidx8.i910 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i909, !dbg !1696
  %560 = load i32, i32* %arrayidx8.i910, align 4, !dbg !1696
  store i32 %560, i32* %a.addr.i24.i885, align 4
  store i8 16, i8* %n.addr.i25.i886, align 1
  %561 = load i32, i32* %a.addr.i24.i885, align 4, !dbg !1697
  %562 = load i8, i8* %n.addr.i25.i886, align 1, !dbg !1698
  %conv.i26.i911 = zext i8 %562 to i32, !dbg !1698
  %shl.i27.i912 = shl i32 %561, %conv.i26.i911, !dbg !1699
  %563 = load i32, i32* %a.addr.i24.i885, align 4, !dbg !1700
  %564 = load i8, i8* %n.addr.i25.i886, align 1, !dbg !1701
  %conv1.i28.i913 = zext i8 %564 to i32, !dbg !1701
  %sub.i29.i914 = sub nsw i32 32, %conv1.i28.i913, !dbg !1702
  %shr.i30.i915 = lshr i32 %563, %sub.i29.i914, !dbg !1703
  %or.i31.i916 = or i32 %shl.i27.i912, %shr.i30.i915, !dbg !1704
  %xor10.i917 = xor i32 %xor.i906, %or.i31.i916, !dbg !1705
  %565 = load i32, i32* %X.addr.i891, align 4, !dbg !1706
  %conv11.i918 = trunc i32 %565 to i8, !dbg !1707
  %idxprom12.i919 = zext i8 %conv11.i918 to i64, !dbg !1708
  %arrayidx13.i920 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i919, !dbg !1708
  %566 = load i32, i32* %arrayidx13.i920, align 4, !dbg !1708
  store i32 %566, i32* %a.addr.i16.i887, align 4
  store i8 8, i8* %n.addr.i17.i888, align 1
  %567 = load i32, i32* %a.addr.i16.i887, align 4, !dbg !1709
  %568 = load i8, i8* %n.addr.i17.i888, align 1, !dbg !1710
  %conv.i18.i921 = zext i8 %568 to i32, !dbg !1710
  %shl.i19.i922 = shl i32 %567, %conv.i18.i921, !dbg !1711
  %569 = load i32, i32* %a.addr.i16.i887, align 4, !dbg !1712
  %570 = load i8, i8* %n.addr.i17.i888, align 1, !dbg !1713
  %conv1.i20.i923 = zext i8 %570 to i32, !dbg !1713
  %sub.i21.i924 = sub nsw i32 32, %conv1.i20.i923, !dbg !1714
  %shr.i22.i925 = lshr i32 %569, %sub.i21.i924, !dbg !1715
  %or.i23.i926 = or i32 %shl.i19.i922, %shr.i22.i925, !dbg !1716
  %xor15.i927 = xor i32 %xor10.i917, %or.i23.i926, !dbg !1717
  %571 = load i32, i32* %B1, align 4, !dbg !1633
  %xor134 = xor i32 %571, %xor15.i927, !dbg !1633
  store i32 %xor134, i32* %B1, align 4, !dbg !1633
  %572 = load i32, i32* %B0, align 4, !dbg !1633
  %573 = load i32, i32* %B1, align 4, !dbg !1633
  %xor135 = xor i32 %572, %573, !dbg !1633
  %574 = load i32, i32* %B3, align 4, !dbg !1633
  %xor136 = xor i32 %xor135, %574, !dbg !1633
  %575 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1633
  %rk137 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %575, i32 0, i32 0, !dbg !1633
  %arrayidx138 = getelementptr inbounds [32 x i32], [32 x i32]* %rk137, i64 0, i64 18, !dbg !1633
  %576 = load i32, i32* %arrayidx138, align 4, !dbg !1633
  %xor139 = xor i32 %xor136, %576, !dbg !1633
  store i32 %xor139, i32* %X.addr.i848, align 4
  %577 = load i32, i32* %X.addr.i848, align 4, !dbg !1718
  %shr.i849 = lshr i32 %577, 24, !dbg !1719
  %conv.i850 = trunc i32 %shr.i849 to i8, !dbg !1720
  %idxprom.i851 = zext i8 %conv.i850 to i64, !dbg !1721
  %arrayidx.i852 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i851, !dbg !1721
  %578 = load i32, i32* %arrayidx.i852, align 4, !dbg !1721
  %579 = load i32, i32* %X.addr.i848, align 4, !dbg !1722
  %shr1.i853 = lshr i32 %579, 16, !dbg !1723
  %conv2.i854 = trunc i32 %shr1.i853 to i8, !dbg !1724
  %idxprom3.i855 = zext i8 %conv2.i854 to i64, !dbg !1725
  %arrayidx4.i856 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i855, !dbg !1725
  %580 = load i32, i32* %arrayidx4.i856, align 4, !dbg !1725
  store i32 %580, i32* %a.addr.i.i846, align 4
  store i8 24, i8* %n.addr.i.i847, align 1
  %581 = load i32, i32* %a.addr.i.i846, align 4, !dbg !1726
  %582 = load i8, i8* %n.addr.i.i847, align 1, !dbg !1727
  %conv.i.i857 = zext i8 %582 to i32, !dbg !1727
  %shl.i.i858 = shl i32 %581, %conv.i.i857, !dbg !1728
  %583 = load i32, i32* %a.addr.i.i846, align 4, !dbg !1729
  %584 = load i8, i8* %n.addr.i.i847, align 1, !dbg !1730
  %conv1.i.i859 = zext i8 %584 to i32, !dbg !1730
  %sub.i.i860 = sub nsw i32 32, %conv1.i.i859, !dbg !1731
  %shr.i.i861 = lshr i32 %583, %sub.i.i860, !dbg !1732
  %or.i.i862 = or i32 %shl.i.i858, %shr.i.i861, !dbg !1733
  %xor.i863 = xor i32 %578, %or.i.i862, !dbg !1734
  %585 = load i32, i32* %X.addr.i848, align 4, !dbg !1735
  %shr5.i864 = lshr i32 %585, 8, !dbg !1736
  %conv6.i865 = trunc i32 %shr5.i864 to i8, !dbg !1737
  %idxprom7.i866 = zext i8 %conv6.i865 to i64, !dbg !1738
  %arrayidx8.i867 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i866, !dbg !1738
  %586 = load i32, i32* %arrayidx8.i867, align 4, !dbg !1738
  store i32 %586, i32* %a.addr.i24.i842, align 4
  store i8 16, i8* %n.addr.i25.i843, align 1
  %587 = load i32, i32* %a.addr.i24.i842, align 4, !dbg !1739
  %588 = load i8, i8* %n.addr.i25.i843, align 1, !dbg !1740
  %conv.i26.i868 = zext i8 %588 to i32, !dbg !1740
  %shl.i27.i869 = shl i32 %587, %conv.i26.i868, !dbg !1741
  %589 = load i32, i32* %a.addr.i24.i842, align 4, !dbg !1742
  %590 = load i8, i8* %n.addr.i25.i843, align 1, !dbg !1743
  %conv1.i28.i870 = zext i8 %590 to i32, !dbg !1743
  %sub.i29.i871 = sub nsw i32 32, %conv1.i28.i870, !dbg !1744
  %shr.i30.i872 = lshr i32 %589, %sub.i29.i871, !dbg !1745
  %or.i31.i873 = or i32 %shl.i27.i869, %shr.i30.i872, !dbg !1746
  %xor10.i874 = xor i32 %xor.i863, %or.i31.i873, !dbg !1747
  %591 = load i32, i32* %X.addr.i848, align 4, !dbg !1748
  %conv11.i875 = trunc i32 %591 to i8, !dbg !1749
  %idxprom12.i876 = zext i8 %conv11.i875 to i64, !dbg !1750
  %arrayidx13.i877 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i876, !dbg !1750
  %592 = load i32, i32* %arrayidx13.i877, align 4, !dbg !1750
  store i32 %592, i32* %a.addr.i16.i844, align 4
  store i8 8, i8* %n.addr.i17.i845, align 1
  %593 = load i32, i32* %a.addr.i16.i844, align 4, !dbg !1751
  %594 = load i8, i8* %n.addr.i17.i845, align 1, !dbg !1752
  %conv.i18.i878 = zext i8 %594 to i32, !dbg !1752
  %shl.i19.i879 = shl i32 %593, %conv.i18.i878, !dbg !1753
  %595 = load i32, i32* %a.addr.i16.i844, align 4, !dbg !1754
  %596 = load i8, i8* %n.addr.i17.i845, align 1, !dbg !1755
  %conv1.i20.i880 = zext i8 %596 to i32, !dbg !1755
  %sub.i21.i881 = sub nsw i32 32, %conv1.i20.i880, !dbg !1756
  %shr.i22.i882 = lshr i32 %595, %sub.i21.i881, !dbg !1757
  %or.i23.i883 = or i32 %shl.i19.i879, %shr.i22.i882, !dbg !1758
  %xor15.i884 = xor i32 %xor10.i874, %or.i23.i883, !dbg !1759
  %597 = load i32, i32* %B2, align 4, !dbg !1633
  %xor141 = xor i32 %597, %xor15.i884, !dbg !1633
  store i32 %xor141, i32* %B2, align 4, !dbg !1633
  %598 = load i32, i32* %B0, align 4, !dbg !1633
  %599 = load i32, i32* %B1, align 4, !dbg !1633
  %xor142 = xor i32 %598, %599, !dbg !1633
  %600 = load i32, i32* %B2, align 4, !dbg !1633
  %xor143 = xor i32 %xor142, %600, !dbg !1633
  %601 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1633
  %rk144 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %601, i32 0, i32 0, !dbg !1633
  %arrayidx145 = getelementptr inbounds [32 x i32], [32 x i32]* %rk144, i64 0, i64 19, !dbg !1633
  %602 = load i32, i32* %arrayidx145, align 4, !dbg !1633
  %xor146 = xor i32 %xor143, %602, !dbg !1633
  store i32 %xor146, i32* %X.addr.i805, align 4
  %603 = load i32, i32* %X.addr.i805, align 4, !dbg !1760
  %shr.i806 = lshr i32 %603, 24, !dbg !1761
  %conv.i807 = trunc i32 %shr.i806 to i8, !dbg !1762
  %idxprom.i808 = zext i8 %conv.i807 to i64, !dbg !1763
  %arrayidx.i809 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i808, !dbg !1763
  %604 = load i32, i32* %arrayidx.i809, align 4, !dbg !1763
  %605 = load i32, i32* %X.addr.i805, align 4, !dbg !1764
  %shr1.i810 = lshr i32 %605, 16, !dbg !1765
  %conv2.i811 = trunc i32 %shr1.i810 to i8, !dbg !1766
  %idxprom3.i812 = zext i8 %conv2.i811 to i64, !dbg !1767
  %arrayidx4.i813 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i812, !dbg !1767
  %606 = load i32, i32* %arrayidx4.i813, align 4, !dbg !1767
  store i32 %606, i32* %a.addr.i.i803, align 4
  store i8 24, i8* %n.addr.i.i804, align 1
  %607 = load i32, i32* %a.addr.i.i803, align 4, !dbg !1768
  %608 = load i8, i8* %n.addr.i.i804, align 1, !dbg !1769
  %conv.i.i814 = zext i8 %608 to i32, !dbg !1769
  %shl.i.i815 = shl i32 %607, %conv.i.i814, !dbg !1770
  %609 = load i32, i32* %a.addr.i.i803, align 4, !dbg !1771
  %610 = load i8, i8* %n.addr.i.i804, align 1, !dbg !1772
  %conv1.i.i816 = zext i8 %610 to i32, !dbg !1772
  %sub.i.i817 = sub nsw i32 32, %conv1.i.i816, !dbg !1773
  %shr.i.i818 = lshr i32 %609, %sub.i.i817, !dbg !1774
  %or.i.i819 = or i32 %shl.i.i815, %shr.i.i818, !dbg !1775
  %xor.i820 = xor i32 %604, %or.i.i819, !dbg !1776
  %611 = load i32, i32* %X.addr.i805, align 4, !dbg !1777
  %shr5.i821 = lshr i32 %611, 8, !dbg !1778
  %conv6.i822 = trunc i32 %shr5.i821 to i8, !dbg !1779
  %idxprom7.i823 = zext i8 %conv6.i822 to i64, !dbg !1780
  %arrayidx8.i824 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i823, !dbg !1780
  %612 = load i32, i32* %arrayidx8.i824, align 4, !dbg !1780
  store i32 %612, i32* %a.addr.i24.i799, align 4
  store i8 16, i8* %n.addr.i25.i800, align 1
  %613 = load i32, i32* %a.addr.i24.i799, align 4, !dbg !1781
  %614 = load i8, i8* %n.addr.i25.i800, align 1, !dbg !1782
  %conv.i26.i825 = zext i8 %614 to i32, !dbg !1782
  %shl.i27.i826 = shl i32 %613, %conv.i26.i825, !dbg !1783
  %615 = load i32, i32* %a.addr.i24.i799, align 4, !dbg !1784
  %616 = load i8, i8* %n.addr.i25.i800, align 1, !dbg !1785
  %conv1.i28.i827 = zext i8 %616 to i32, !dbg !1785
  %sub.i29.i828 = sub nsw i32 32, %conv1.i28.i827, !dbg !1786
  %shr.i30.i829 = lshr i32 %615, %sub.i29.i828, !dbg !1787
  %or.i31.i830 = or i32 %shl.i27.i826, %shr.i30.i829, !dbg !1788
  %xor10.i831 = xor i32 %xor.i820, %or.i31.i830, !dbg !1789
  %617 = load i32, i32* %X.addr.i805, align 4, !dbg !1790
  %conv11.i832 = trunc i32 %617 to i8, !dbg !1791
  %idxprom12.i833 = zext i8 %conv11.i832 to i64, !dbg !1792
  %arrayidx13.i834 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i833, !dbg !1792
  %618 = load i32, i32* %arrayidx13.i834, align 4, !dbg !1792
  store i32 %618, i32* %a.addr.i16.i801, align 4
  store i8 8, i8* %n.addr.i17.i802, align 1
  %619 = load i32, i32* %a.addr.i16.i801, align 4, !dbg !1793
  %620 = load i8, i8* %n.addr.i17.i802, align 1, !dbg !1794
  %conv.i18.i835 = zext i8 %620 to i32, !dbg !1794
  %shl.i19.i836 = shl i32 %619, %conv.i18.i835, !dbg !1795
  %621 = load i32, i32* %a.addr.i16.i801, align 4, !dbg !1796
  %622 = load i8, i8* %n.addr.i17.i802, align 1, !dbg !1797
  %conv1.i20.i837 = zext i8 %622 to i32, !dbg !1797
  %sub.i21.i838 = sub nsw i32 32, %conv1.i20.i837, !dbg !1798
  %shr.i22.i839 = lshr i32 %621, %sub.i21.i838, !dbg !1799
  %or.i23.i840 = or i32 %shl.i19.i836, %shr.i22.i839, !dbg !1800
  %xor15.i841 = xor i32 %xor10.i831, %or.i23.i840, !dbg !1801
  %623 = load i32, i32* %B3, align 4, !dbg !1633
  %xor148 = xor i32 %623, %xor15.i841, !dbg !1633
  store i32 %xor148, i32* %B3, align 4, !dbg !1633
  br label %do.end149, !dbg !1633

do.end149:                                        ; preds = %do.body120
  br label %do.body150, !dbg !1802

do.body150:                                       ; preds = %do.end149
  %624 = load i32, i32* %B1, align 4, !dbg !1803
  %625 = load i32, i32* %B2, align 4, !dbg !1803
  %xor151 = xor i32 %624, %625, !dbg !1803
  %626 = load i32, i32* %B3, align 4, !dbg !1803
  %xor152 = xor i32 %xor151, %626, !dbg !1803
  %627 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1803
  %rk153 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %627, i32 0, i32 0, !dbg !1803
  %arrayidx154 = getelementptr inbounds [32 x i32], [32 x i32]* %rk153, i64 0, i64 20, !dbg !1803
  %628 = load i32, i32* %arrayidx154, align 4, !dbg !1803
  %xor155 = xor i32 %xor152, %628, !dbg !1803
  store i32 %xor155, i32* %X.addr.i762, align 4
  %629 = load i32, i32* %X.addr.i762, align 4, !dbg !1804
  %shr.i763 = lshr i32 %629, 24, !dbg !1805
  %conv.i764 = trunc i32 %shr.i763 to i8, !dbg !1806
  %idxprom.i765 = zext i8 %conv.i764 to i64, !dbg !1807
  %arrayidx.i766 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i765, !dbg !1807
  %630 = load i32, i32* %arrayidx.i766, align 4, !dbg !1807
  %631 = load i32, i32* %X.addr.i762, align 4, !dbg !1808
  %shr1.i767 = lshr i32 %631, 16, !dbg !1809
  %conv2.i768 = trunc i32 %shr1.i767 to i8, !dbg !1810
  %idxprom3.i769 = zext i8 %conv2.i768 to i64, !dbg !1811
  %arrayidx4.i770 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i769, !dbg !1811
  %632 = load i32, i32* %arrayidx4.i770, align 4, !dbg !1811
  store i32 %632, i32* %a.addr.i.i760, align 4
  store i8 24, i8* %n.addr.i.i761, align 1
  %633 = load i32, i32* %a.addr.i.i760, align 4, !dbg !1812
  %634 = load i8, i8* %n.addr.i.i761, align 1, !dbg !1813
  %conv.i.i771 = zext i8 %634 to i32, !dbg !1813
  %shl.i.i772 = shl i32 %633, %conv.i.i771, !dbg !1814
  %635 = load i32, i32* %a.addr.i.i760, align 4, !dbg !1815
  %636 = load i8, i8* %n.addr.i.i761, align 1, !dbg !1816
  %conv1.i.i773 = zext i8 %636 to i32, !dbg !1816
  %sub.i.i774 = sub nsw i32 32, %conv1.i.i773, !dbg !1817
  %shr.i.i775 = lshr i32 %635, %sub.i.i774, !dbg !1818
  %or.i.i776 = or i32 %shl.i.i772, %shr.i.i775, !dbg !1819
  %xor.i777 = xor i32 %630, %or.i.i776, !dbg !1820
  %637 = load i32, i32* %X.addr.i762, align 4, !dbg !1821
  %shr5.i778 = lshr i32 %637, 8, !dbg !1822
  %conv6.i779 = trunc i32 %shr5.i778 to i8, !dbg !1823
  %idxprom7.i780 = zext i8 %conv6.i779 to i64, !dbg !1824
  %arrayidx8.i781 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i780, !dbg !1824
  %638 = load i32, i32* %arrayidx8.i781, align 4, !dbg !1824
  store i32 %638, i32* %a.addr.i24.i756, align 4
  store i8 16, i8* %n.addr.i25.i757, align 1
  %639 = load i32, i32* %a.addr.i24.i756, align 4, !dbg !1825
  %640 = load i8, i8* %n.addr.i25.i757, align 1, !dbg !1826
  %conv.i26.i782 = zext i8 %640 to i32, !dbg !1826
  %shl.i27.i783 = shl i32 %639, %conv.i26.i782, !dbg !1827
  %641 = load i32, i32* %a.addr.i24.i756, align 4, !dbg !1828
  %642 = load i8, i8* %n.addr.i25.i757, align 1, !dbg !1829
  %conv1.i28.i784 = zext i8 %642 to i32, !dbg !1829
  %sub.i29.i785 = sub nsw i32 32, %conv1.i28.i784, !dbg !1830
  %shr.i30.i786 = lshr i32 %641, %sub.i29.i785, !dbg !1831
  %or.i31.i787 = or i32 %shl.i27.i783, %shr.i30.i786, !dbg !1832
  %xor10.i788 = xor i32 %xor.i777, %or.i31.i787, !dbg !1833
  %643 = load i32, i32* %X.addr.i762, align 4, !dbg !1834
  %conv11.i789 = trunc i32 %643 to i8, !dbg !1835
  %idxprom12.i790 = zext i8 %conv11.i789 to i64, !dbg !1836
  %arrayidx13.i791 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i790, !dbg !1836
  %644 = load i32, i32* %arrayidx13.i791, align 4, !dbg !1836
  store i32 %644, i32* %a.addr.i16.i758, align 4
  store i8 8, i8* %n.addr.i17.i759, align 1
  %645 = load i32, i32* %a.addr.i16.i758, align 4, !dbg !1837
  %646 = load i8, i8* %n.addr.i17.i759, align 1, !dbg !1838
  %conv.i18.i792 = zext i8 %646 to i32, !dbg !1838
  %shl.i19.i793 = shl i32 %645, %conv.i18.i792, !dbg !1839
  %647 = load i32, i32* %a.addr.i16.i758, align 4, !dbg !1840
  %648 = load i8, i8* %n.addr.i17.i759, align 1, !dbg !1841
  %conv1.i20.i794 = zext i8 %648 to i32, !dbg !1841
  %sub.i21.i795 = sub nsw i32 32, %conv1.i20.i794, !dbg !1842
  %shr.i22.i796 = lshr i32 %647, %sub.i21.i795, !dbg !1843
  %or.i23.i797 = or i32 %shl.i19.i793, %shr.i22.i796, !dbg !1844
  %xor15.i798 = xor i32 %xor10.i788, %or.i23.i797, !dbg !1845
  %649 = load i32, i32* %B0, align 4, !dbg !1803
  %xor157 = xor i32 %649, %xor15.i798, !dbg !1803
  store i32 %xor157, i32* %B0, align 4, !dbg !1803
  %650 = load i32, i32* %B0, align 4, !dbg !1803
  %651 = load i32, i32* %B2, align 4, !dbg !1803
  %xor158 = xor i32 %650, %651, !dbg !1803
  %652 = load i32, i32* %B3, align 4, !dbg !1803
  %xor159 = xor i32 %xor158, %652, !dbg !1803
  %653 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1803
  %rk160 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %653, i32 0, i32 0, !dbg !1803
  %arrayidx161 = getelementptr inbounds [32 x i32], [32 x i32]* %rk160, i64 0, i64 21, !dbg !1803
  %654 = load i32, i32* %arrayidx161, align 4, !dbg !1803
  %xor162 = xor i32 %xor159, %654, !dbg !1803
  store i32 %xor162, i32* %X.addr.i719, align 4
  %655 = load i32, i32* %X.addr.i719, align 4, !dbg !1846
  %shr.i720 = lshr i32 %655, 24, !dbg !1847
  %conv.i721 = trunc i32 %shr.i720 to i8, !dbg !1848
  %idxprom.i722 = zext i8 %conv.i721 to i64, !dbg !1849
  %arrayidx.i723 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i722, !dbg !1849
  %656 = load i32, i32* %arrayidx.i723, align 4, !dbg !1849
  %657 = load i32, i32* %X.addr.i719, align 4, !dbg !1850
  %shr1.i724 = lshr i32 %657, 16, !dbg !1851
  %conv2.i725 = trunc i32 %shr1.i724 to i8, !dbg !1852
  %idxprom3.i726 = zext i8 %conv2.i725 to i64, !dbg !1853
  %arrayidx4.i727 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i726, !dbg !1853
  %658 = load i32, i32* %arrayidx4.i727, align 4, !dbg !1853
  store i32 %658, i32* %a.addr.i.i717, align 4
  store i8 24, i8* %n.addr.i.i718, align 1
  %659 = load i32, i32* %a.addr.i.i717, align 4, !dbg !1854
  %660 = load i8, i8* %n.addr.i.i718, align 1, !dbg !1855
  %conv.i.i728 = zext i8 %660 to i32, !dbg !1855
  %shl.i.i729 = shl i32 %659, %conv.i.i728, !dbg !1856
  %661 = load i32, i32* %a.addr.i.i717, align 4, !dbg !1857
  %662 = load i8, i8* %n.addr.i.i718, align 1, !dbg !1858
  %conv1.i.i730 = zext i8 %662 to i32, !dbg !1858
  %sub.i.i731 = sub nsw i32 32, %conv1.i.i730, !dbg !1859
  %shr.i.i732 = lshr i32 %661, %sub.i.i731, !dbg !1860
  %or.i.i733 = or i32 %shl.i.i729, %shr.i.i732, !dbg !1861
  %xor.i734 = xor i32 %656, %or.i.i733, !dbg !1862
  %663 = load i32, i32* %X.addr.i719, align 4, !dbg !1863
  %shr5.i735 = lshr i32 %663, 8, !dbg !1864
  %conv6.i736 = trunc i32 %shr5.i735 to i8, !dbg !1865
  %idxprom7.i737 = zext i8 %conv6.i736 to i64, !dbg !1866
  %arrayidx8.i738 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i737, !dbg !1866
  %664 = load i32, i32* %arrayidx8.i738, align 4, !dbg !1866
  store i32 %664, i32* %a.addr.i24.i713, align 4
  store i8 16, i8* %n.addr.i25.i714, align 1
  %665 = load i32, i32* %a.addr.i24.i713, align 4, !dbg !1867
  %666 = load i8, i8* %n.addr.i25.i714, align 1, !dbg !1868
  %conv.i26.i739 = zext i8 %666 to i32, !dbg !1868
  %shl.i27.i740 = shl i32 %665, %conv.i26.i739, !dbg !1869
  %667 = load i32, i32* %a.addr.i24.i713, align 4, !dbg !1870
  %668 = load i8, i8* %n.addr.i25.i714, align 1, !dbg !1871
  %conv1.i28.i741 = zext i8 %668 to i32, !dbg !1871
  %sub.i29.i742 = sub nsw i32 32, %conv1.i28.i741, !dbg !1872
  %shr.i30.i743 = lshr i32 %667, %sub.i29.i742, !dbg !1873
  %or.i31.i744 = or i32 %shl.i27.i740, %shr.i30.i743, !dbg !1874
  %xor10.i745 = xor i32 %xor.i734, %or.i31.i744, !dbg !1875
  %669 = load i32, i32* %X.addr.i719, align 4, !dbg !1876
  %conv11.i746 = trunc i32 %669 to i8, !dbg !1877
  %idxprom12.i747 = zext i8 %conv11.i746 to i64, !dbg !1878
  %arrayidx13.i748 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i747, !dbg !1878
  %670 = load i32, i32* %arrayidx13.i748, align 4, !dbg !1878
  store i32 %670, i32* %a.addr.i16.i715, align 4
  store i8 8, i8* %n.addr.i17.i716, align 1
  %671 = load i32, i32* %a.addr.i16.i715, align 4, !dbg !1879
  %672 = load i8, i8* %n.addr.i17.i716, align 1, !dbg !1880
  %conv.i18.i749 = zext i8 %672 to i32, !dbg !1880
  %shl.i19.i750 = shl i32 %671, %conv.i18.i749, !dbg !1881
  %673 = load i32, i32* %a.addr.i16.i715, align 4, !dbg !1882
  %674 = load i8, i8* %n.addr.i17.i716, align 1, !dbg !1883
  %conv1.i20.i751 = zext i8 %674 to i32, !dbg !1883
  %sub.i21.i752 = sub nsw i32 32, %conv1.i20.i751, !dbg !1884
  %shr.i22.i753 = lshr i32 %673, %sub.i21.i752, !dbg !1885
  %or.i23.i754 = or i32 %shl.i19.i750, %shr.i22.i753, !dbg !1886
  %xor15.i755 = xor i32 %xor10.i745, %or.i23.i754, !dbg !1887
  %675 = load i32, i32* %B1, align 4, !dbg !1803
  %xor164 = xor i32 %675, %xor15.i755, !dbg !1803
  store i32 %xor164, i32* %B1, align 4, !dbg !1803
  %676 = load i32, i32* %B0, align 4, !dbg !1803
  %677 = load i32, i32* %B1, align 4, !dbg !1803
  %xor165 = xor i32 %676, %677, !dbg !1803
  %678 = load i32, i32* %B3, align 4, !dbg !1803
  %xor166 = xor i32 %xor165, %678, !dbg !1803
  %679 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1803
  %rk167 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %679, i32 0, i32 0, !dbg !1803
  %arrayidx168 = getelementptr inbounds [32 x i32], [32 x i32]* %rk167, i64 0, i64 22, !dbg !1803
  %680 = load i32, i32* %arrayidx168, align 4, !dbg !1803
  %xor169 = xor i32 %xor166, %680, !dbg !1803
  store i32 %xor169, i32* %X.addr.i676, align 4
  %681 = load i32, i32* %X.addr.i676, align 4, !dbg !1888
  %shr.i677 = lshr i32 %681, 24, !dbg !1889
  %conv.i678 = trunc i32 %shr.i677 to i8, !dbg !1890
  %idxprom.i679 = zext i8 %conv.i678 to i64, !dbg !1891
  %arrayidx.i680 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i679, !dbg !1891
  %682 = load i32, i32* %arrayidx.i680, align 4, !dbg !1891
  %683 = load i32, i32* %X.addr.i676, align 4, !dbg !1892
  %shr1.i681 = lshr i32 %683, 16, !dbg !1893
  %conv2.i682 = trunc i32 %shr1.i681 to i8, !dbg !1894
  %idxprom3.i683 = zext i8 %conv2.i682 to i64, !dbg !1895
  %arrayidx4.i684 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i683, !dbg !1895
  %684 = load i32, i32* %arrayidx4.i684, align 4, !dbg !1895
  store i32 %684, i32* %a.addr.i.i674, align 4
  store i8 24, i8* %n.addr.i.i675, align 1
  %685 = load i32, i32* %a.addr.i.i674, align 4, !dbg !1896
  %686 = load i8, i8* %n.addr.i.i675, align 1, !dbg !1897
  %conv.i.i685 = zext i8 %686 to i32, !dbg !1897
  %shl.i.i686 = shl i32 %685, %conv.i.i685, !dbg !1898
  %687 = load i32, i32* %a.addr.i.i674, align 4, !dbg !1899
  %688 = load i8, i8* %n.addr.i.i675, align 1, !dbg !1900
  %conv1.i.i687 = zext i8 %688 to i32, !dbg !1900
  %sub.i.i688 = sub nsw i32 32, %conv1.i.i687, !dbg !1901
  %shr.i.i689 = lshr i32 %687, %sub.i.i688, !dbg !1902
  %or.i.i690 = or i32 %shl.i.i686, %shr.i.i689, !dbg !1903
  %xor.i691 = xor i32 %682, %or.i.i690, !dbg !1904
  %689 = load i32, i32* %X.addr.i676, align 4, !dbg !1905
  %shr5.i692 = lshr i32 %689, 8, !dbg !1906
  %conv6.i693 = trunc i32 %shr5.i692 to i8, !dbg !1907
  %idxprom7.i694 = zext i8 %conv6.i693 to i64, !dbg !1908
  %arrayidx8.i695 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i694, !dbg !1908
  %690 = load i32, i32* %arrayidx8.i695, align 4, !dbg !1908
  store i32 %690, i32* %a.addr.i24.i670, align 4
  store i8 16, i8* %n.addr.i25.i671, align 1
  %691 = load i32, i32* %a.addr.i24.i670, align 4, !dbg !1909
  %692 = load i8, i8* %n.addr.i25.i671, align 1, !dbg !1910
  %conv.i26.i696 = zext i8 %692 to i32, !dbg !1910
  %shl.i27.i697 = shl i32 %691, %conv.i26.i696, !dbg !1911
  %693 = load i32, i32* %a.addr.i24.i670, align 4, !dbg !1912
  %694 = load i8, i8* %n.addr.i25.i671, align 1, !dbg !1913
  %conv1.i28.i698 = zext i8 %694 to i32, !dbg !1913
  %sub.i29.i699 = sub nsw i32 32, %conv1.i28.i698, !dbg !1914
  %shr.i30.i700 = lshr i32 %693, %sub.i29.i699, !dbg !1915
  %or.i31.i701 = or i32 %shl.i27.i697, %shr.i30.i700, !dbg !1916
  %xor10.i702 = xor i32 %xor.i691, %or.i31.i701, !dbg !1917
  %695 = load i32, i32* %X.addr.i676, align 4, !dbg !1918
  %conv11.i703 = trunc i32 %695 to i8, !dbg !1919
  %idxprom12.i704 = zext i8 %conv11.i703 to i64, !dbg !1920
  %arrayidx13.i705 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i704, !dbg !1920
  %696 = load i32, i32* %arrayidx13.i705, align 4, !dbg !1920
  store i32 %696, i32* %a.addr.i16.i672, align 4
  store i8 8, i8* %n.addr.i17.i673, align 1
  %697 = load i32, i32* %a.addr.i16.i672, align 4, !dbg !1921
  %698 = load i8, i8* %n.addr.i17.i673, align 1, !dbg !1922
  %conv.i18.i706 = zext i8 %698 to i32, !dbg !1922
  %shl.i19.i707 = shl i32 %697, %conv.i18.i706, !dbg !1923
  %699 = load i32, i32* %a.addr.i16.i672, align 4, !dbg !1924
  %700 = load i8, i8* %n.addr.i17.i673, align 1, !dbg !1925
  %conv1.i20.i708 = zext i8 %700 to i32, !dbg !1925
  %sub.i21.i709 = sub nsw i32 32, %conv1.i20.i708, !dbg !1926
  %shr.i22.i710 = lshr i32 %699, %sub.i21.i709, !dbg !1927
  %or.i23.i711 = or i32 %shl.i19.i707, %shr.i22.i710, !dbg !1928
  %xor15.i712 = xor i32 %xor10.i702, %or.i23.i711, !dbg !1929
  %701 = load i32, i32* %B2, align 4, !dbg !1803
  %xor171 = xor i32 %701, %xor15.i712, !dbg !1803
  store i32 %xor171, i32* %B2, align 4, !dbg !1803
  %702 = load i32, i32* %B0, align 4, !dbg !1803
  %703 = load i32, i32* %B1, align 4, !dbg !1803
  %xor172 = xor i32 %702, %703, !dbg !1803
  %704 = load i32, i32* %B2, align 4, !dbg !1803
  %xor173 = xor i32 %xor172, %704, !dbg !1803
  %705 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1803
  %rk174 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %705, i32 0, i32 0, !dbg !1803
  %arrayidx175 = getelementptr inbounds [32 x i32], [32 x i32]* %rk174, i64 0, i64 23, !dbg !1803
  %706 = load i32, i32* %arrayidx175, align 4, !dbg !1803
  %xor176 = xor i32 %xor173, %706, !dbg !1803
  store i32 %xor176, i32* %X.addr.i633, align 4
  %707 = load i32, i32* %X.addr.i633, align 4, !dbg !1930
  %shr.i634 = lshr i32 %707, 24, !dbg !1931
  %conv.i635 = trunc i32 %shr.i634 to i8, !dbg !1932
  %idxprom.i636 = zext i8 %conv.i635 to i64, !dbg !1933
  %arrayidx.i637 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i636, !dbg !1933
  %708 = load i32, i32* %arrayidx.i637, align 4, !dbg !1933
  %709 = load i32, i32* %X.addr.i633, align 4, !dbg !1934
  %shr1.i638 = lshr i32 %709, 16, !dbg !1935
  %conv2.i639 = trunc i32 %shr1.i638 to i8, !dbg !1936
  %idxprom3.i640 = zext i8 %conv2.i639 to i64, !dbg !1937
  %arrayidx4.i641 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i640, !dbg !1937
  %710 = load i32, i32* %arrayidx4.i641, align 4, !dbg !1937
  store i32 %710, i32* %a.addr.i.i631, align 4
  store i8 24, i8* %n.addr.i.i632, align 1
  %711 = load i32, i32* %a.addr.i.i631, align 4, !dbg !1938
  %712 = load i8, i8* %n.addr.i.i632, align 1, !dbg !1939
  %conv.i.i642 = zext i8 %712 to i32, !dbg !1939
  %shl.i.i643 = shl i32 %711, %conv.i.i642, !dbg !1940
  %713 = load i32, i32* %a.addr.i.i631, align 4, !dbg !1941
  %714 = load i8, i8* %n.addr.i.i632, align 1, !dbg !1942
  %conv1.i.i644 = zext i8 %714 to i32, !dbg !1942
  %sub.i.i645 = sub nsw i32 32, %conv1.i.i644, !dbg !1943
  %shr.i.i646 = lshr i32 %713, %sub.i.i645, !dbg !1944
  %or.i.i647 = or i32 %shl.i.i643, %shr.i.i646, !dbg !1945
  %xor.i648 = xor i32 %708, %or.i.i647, !dbg !1946
  %715 = load i32, i32* %X.addr.i633, align 4, !dbg !1947
  %shr5.i649 = lshr i32 %715, 8, !dbg !1948
  %conv6.i650 = trunc i32 %shr5.i649 to i8, !dbg !1949
  %idxprom7.i651 = zext i8 %conv6.i650 to i64, !dbg !1950
  %arrayidx8.i652 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i651, !dbg !1950
  %716 = load i32, i32* %arrayidx8.i652, align 4, !dbg !1950
  store i32 %716, i32* %a.addr.i24.i627, align 4
  store i8 16, i8* %n.addr.i25.i628, align 1
  %717 = load i32, i32* %a.addr.i24.i627, align 4, !dbg !1951
  %718 = load i8, i8* %n.addr.i25.i628, align 1, !dbg !1952
  %conv.i26.i653 = zext i8 %718 to i32, !dbg !1952
  %shl.i27.i654 = shl i32 %717, %conv.i26.i653, !dbg !1953
  %719 = load i32, i32* %a.addr.i24.i627, align 4, !dbg !1954
  %720 = load i8, i8* %n.addr.i25.i628, align 1, !dbg !1955
  %conv1.i28.i655 = zext i8 %720 to i32, !dbg !1955
  %sub.i29.i656 = sub nsw i32 32, %conv1.i28.i655, !dbg !1956
  %shr.i30.i657 = lshr i32 %719, %sub.i29.i656, !dbg !1957
  %or.i31.i658 = or i32 %shl.i27.i654, %shr.i30.i657, !dbg !1958
  %xor10.i659 = xor i32 %xor.i648, %or.i31.i658, !dbg !1959
  %721 = load i32, i32* %X.addr.i633, align 4, !dbg !1960
  %conv11.i660 = trunc i32 %721 to i8, !dbg !1961
  %idxprom12.i661 = zext i8 %conv11.i660 to i64, !dbg !1962
  %arrayidx13.i662 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i661, !dbg !1962
  %722 = load i32, i32* %arrayidx13.i662, align 4, !dbg !1962
  store i32 %722, i32* %a.addr.i16.i629, align 4
  store i8 8, i8* %n.addr.i17.i630, align 1
  %723 = load i32, i32* %a.addr.i16.i629, align 4, !dbg !1963
  %724 = load i8, i8* %n.addr.i17.i630, align 1, !dbg !1964
  %conv.i18.i663 = zext i8 %724 to i32, !dbg !1964
  %shl.i19.i664 = shl i32 %723, %conv.i18.i663, !dbg !1965
  %725 = load i32, i32* %a.addr.i16.i629, align 4, !dbg !1966
  %726 = load i8, i8* %n.addr.i17.i630, align 1, !dbg !1967
  %conv1.i20.i665 = zext i8 %726 to i32, !dbg !1967
  %sub.i21.i666 = sub nsw i32 32, %conv1.i20.i665, !dbg !1968
  %shr.i22.i667 = lshr i32 %725, %sub.i21.i666, !dbg !1969
  %or.i23.i668 = or i32 %shl.i19.i664, %shr.i22.i667, !dbg !1970
  %xor15.i669 = xor i32 %xor10.i659, %or.i23.i668, !dbg !1971
  %727 = load i32, i32* %B3, align 4, !dbg !1803
  %xor178 = xor i32 %727, %xor15.i669, !dbg !1803
  store i32 %xor178, i32* %B3, align 4, !dbg !1803
  br label %do.end179, !dbg !1803

do.end179:                                        ; preds = %do.body150
  br label %do.body180, !dbg !1972

do.body180:                                       ; preds = %do.end179
  %728 = load i32, i32* %B1, align 4, !dbg !1973
  %729 = load i32, i32* %B2, align 4, !dbg !1973
  %xor181 = xor i32 %728, %729, !dbg !1973
  %730 = load i32, i32* %B3, align 4, !dbg !1973
  %xor182 = xor i32 %xor181, %730, !dbg !1973
  %731 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1973
  %rk183 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %731, i32 0, i32 0, !dbg !1973
  %arrayidx184 = getelementptr inbounds [32 x i32], [32 x i32]* %rk183, i64 0, i64 24, !dbg !1973
  %732 = load i32, i32* %arrayidx184, align 4, !dbg !1973
  %xor185 = xor i32 %xor182, %732, !dbg !1973
  store i32 %xor185, i32* %X.addr.i590, align 4
  %733 = load i32, i32* %X.addr.i590, align 4, !dbg !1974
  %shr.i591 = lshr i32 %733, 24, !dbg !1975
  %conv.i592 = trunc i32 %shr.i591 to i8, !dbg !1976
  %idxprom.i593 = zext i8 %conv.i592 to i64, !dbg !1977
  %arrayidx.i594 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i593, !dbg !1977
  %734 = load i32, i32* %arrayidx.i594, align 4, !dbg !1977
  %735 = load i32, i32* %X.addr.i590, align 4, !dbg !1978
  %shr1.i595 = lshr i32 %735, 16, !dbg !1979
  %conv2.i596 = trunc i32 %shr1.i595 to i8, !dbg !1980
  %idxprom3.i597 = zext i8 %conv2.i596 to i64, !dbg !1981
  %arrayidx4.i598 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i597, !dbg !1981
  %736 = load i32, i32* %arrayidx4.i598, align 4, !dbg !1981
  store i32 %736, i32* %a.addr.i.i588, align 4
  store i8 24, i8* %n.addr.i.i589, align 1
  %737 = load i32, i32* %a.addr.i.i588, align 4, !dbg !1982
  %738 = load i8, i8* %n.addr.i.i589, align 1, !dbg !1983
  %conv.i.i599 = zext i8 %738 to i32, !dbg !1983
  %shl.i.i600 = shl i32 %737, %conv.i.i599, !dbg !1984
  %739 = load i32, i32* %a.addr.i.i588, align 4, !dbg !1985
  %740 = load i8, i8* %n.addr.i.i589, align 1, !dbg !1986
  %conv1.i.i601 = zext i8 %740 to i32, !dbg !1986
  %sub.i.i602 = sub nsw i32 32, %conv1.i.i601, !dbg !1987
  %shr.i.i603 = lshr i32 %739, %sub.i.i602, !dbg !1988
  %or.i.i604 = or i32 %shl.i.i600, %shr.i.i603, !dbg !1989
  %xor.i605 = xor i32 %734, %or.i.i604, !dbg !1990
  %741 = load i32, i32* %X.addr.i590, align 4, !dbg !1991
  %shr5.i606 = lshr i32 %741, 8, !dbg !1992
  %conv6.i607 = trunc i32 %shr5.i606 to i8, !dbg !1993
  %idxprom7.i608 = zext i8 %conv6.i607 to i64, !dbg !1994
  %arrayidx8.i609 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i608, !dbg !1994
  %742 = load i32, i32* %arrayidx8.i609, align 4, !dbg !1994
  store i32 %742, i32* %a.addr.i24.i584, align 4
  store i8 16, i8* %n.addr.i25.i585, align 1
  %743 = load i32, i32* %a.addr.i24.i584, align 4, !dbg !1995
  %744 = load i8, i8* %n.addr.i25.i585, align 1, !dbg !1996
  %conv.i26.i610 = zext i8 %744 to i32, !dbg !1996
  %shl.i27.i611 = shl i32 %743, %conv.i26.i610, !dbg !1997
  %745 = load i32, i32* %a.addr.i24.i584, align 4, !dbg !1998
  %746 = load i8, i8* %n.addr.i25.i585, align 1, !dbg !1999
  %conv1.i28.i612 = zext i8 %746 to i32, !dbg !1999
  %sub.i29.i613 = sub nsw i32 32, %conv1.i28.i612, !dbg !2000
  %shr.i30.i614 = lshr i32 %745, %sub.i29.i613, !dbg !2001
  %or.i31.i615 = or i32 %shl.i27.i611, %shr.i30.i614, !dbg !2002
  %xor10.i616 = xor i32 %xor.i605, %or.i31.i615, !dbg !2003
  %747 = load i32, i32* %X.addr.i590, align 4, !dbg !2004
  %conv11.i617 = trunc i32 %747 to i8, !dbg !2005
  %idxprom12.i618 = zext i8 %conv11.i617 to i64, !dbg !2006
  %arrayidx13.i619 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i618, !dbg !2006
  %748 = load i32, i32* %arrayidx13.i619, align 4, !dbg !2006
  store i32 %748, i32* %a.addr.i16.i586, align 4
  store i8 8, i8* %n.addr.i17.i587, align 1
  %749 = load i32, i32* %a.addr.i16.i586, align 4, !dbg !2007
  %750 = load i8, i8* %n.addr.i17.i587, align 1, !dbg !2008
  %conv.i18.i620 = zext i8 %750 to i32, !dbg !2008
  %shl.i19.i621 = shl i32 %749, %conv.i18.i620, !dbg !2009
  %751 = load i32, i32* %a.addr.i16.i586, align 4, !dbg !2010
  %752 = load i8, i8* %n.addr.i17.i587, align 1, !dbg !2011
  %conv1.i20.i622 = zext i8 %752 to i32, !dbg !2011
  %sub.i21.i623 = sub nsw i32 32, %conv1.i20.i622, !dbg !2012
  %shr.i22.i624 = lshr i32 %751, %sub.i21.i623, !dbg !2013
  %or.i23.i625 = or i32 %shl.i19.i621, %shr.i22.i624, !dbg !2014
  %xor15.i626 = xor i32 %xor10.i616, %or.i23.i625, !dbg !2015
  %753 = load i32, i32* %B0, align 4, !dbg !1973
  %xor187 = xor i32 %753, %xor15.i626, !dbg !1973
  store i32 %xor187, i32* %B0, align 4, !dbg !1973
  %754 = load i32, i32* %B0, align 4, !dbg !1973
  %755 = load i32, i32* %B2, align 4, !dbg !1973
  %xor188 = xor i32 %754, %755, !dbg !1973
  %756 = load i32, i32* %B3, align 4, !dbg !1973
  %xor189 = xor i32 %xor188, %756, !dbg !1973
  %757 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1973
  %rk190 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %757, i32 0, i32 0, !dbg !1973
  %arrayidx191 = getelementptr inbounds [32 x i32], [32 x i32]* %rk190, i64 0, i64 25, !dbg !1973
  %758 = load i32, i32* %arrayidx191, align 4, !dbg !1973
  %xor192 = xor i32 %xor189, %758, !dbg !1973
  store i32 %xor192, i32* %X.addr.i547, align 4
  %759 = load i32, i32* %X.addr.i547, align 4, !dbg !2016
  %shr.i548 = lshr i32 %759, 24, !dbg !2017
  %conv.i549 = trunc i32 %shr.i548 to i8, !dbg !2018
  %idxprom.i550 = zext i8 %conv.i549 to i64, !dbg !2019
  %arrayidx.i551 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i550, !dbg !2019
  %760 = load i32, i32* %arrayidx.i551, align 4, !dbg !2019
  %761 = load i32, i32* %X.addr.i547, align 4, !dbg !2020
  %shr1.i552 = lshr i32 %761, 16, !dbg !2021
  %conv2.i553 = trunc i32 %shr1.i552 to i8, !dbg !2022
  %idxprom3.i554 = zext i8 %conv2.i553 to i64, !dbg !2023
  %arrayidx4.i555 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i554, !dbg !2023
  %762 = load i32, i32* %arrayidx4.i555, align 4, !dbg !2023
  store i32 %762, i32* %a.addr.i.i545, align 4
  store i8 24, i8* %n.addr.i.i546, align 1
  %763 = load i32, i32* %a.addr.i.i545, align 4, !dbg !2024
  %764 = load i8, i8* %n.addr.i.i546, align 1, !dbg !2025
  %conv.i.i556 = zext i8 %764 to i32, !dbg !2025
  %shl.i.i557 = shl i32 %763, %conv.i.i556, !dbg !2026
  %765 = load i32, i32* %a.addr.i.i545, align 4, !dbg !2027
  %766 = load i8, i8* %n.addr.i.i546, align 1, !dbg !2028
  %conv1.i.i558 = zext i8 %766 to i32, !dbg !2028
  %sub.i.i559 = sub nsw i32 32, %conv1.i.i558, !dbg !2029
  %shr.i.i560 = lshr i32 %765, %sub.i.i559, !dbg !2030
  %or.i.i561 = or i32 %shl.i.i557, %shr.i.i560, !dbg !2031
  %xor.i562 = xor i32 %760, %or.i.i561, !dbg !2032
  %767 = load i32, i32* %X.addr.i547, align 4, !dbg !2033
  %shr5.i563 = lshr i32 %767, 8, !dbg !2034
  %conv6.i564 = trunc i32 %shr5.i563 to i8, !dbg !2035
  %idxprom7.i565 = zext i8 %conv6.i564 to i64, !dbg !2036
  %arrayidx8.i566 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i565, !dbg !2036
  %768 = load i32, i32* %arrayidx8.i566, align 4, !dbg !2036
  store i32 %768, i32* %a.addr.i24.i541, align 4
  store i8 16, i8* %n.addr.i25.i542, align 1
  %769 = load i32, i32* %a.addr.i24.i541, align 4, !dbg !2037
  %770 = load i8, i8* %n.addr.i25.i542, align 1, !dbg !2038
  %conv.i26.i567 = zext i8 %770 to i32, !dbg !2038
  %shl.i27.i568 = shl i32 %769, %conv.i26.i567, !dbg !2039
  %771 = load i32, i32* %a.addr.i24.i541, align 4, !dbg !2040
  %772 = load i8, i8* %n.addr.i25.i542, align 1, !dbg !2041
  %conv1.i28.i569 = zext i8 %772 to i32, !dbg !2041
  %sub.i29.i570 = sub nsw i32 32, %conv1.i28.i569, !dbg !2042
  %shr.i30.i571 = lshr i32 %771, %sub.i29.i570, !dbg !2043
  %or.i31.i572 = or i32 %shl.i27.i568, %shr.i30.i571, !dbg !2044
  %xor10.i573 = xor i32 %xor.i562, %or.i31.i572, !dbg !2045
  %773 = load i32, i32* %X.addr.i547, align 4, !dbg !2046
  %conv11.i574 = trunc i32 %773 to i8, !dbg !2047
  %idxprom12.i575 = zext i8 %conv11.i574 to i64, !dbg !2048
  %arrayidx13.i576 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i575, !dbg !2048
  %774 = load i32, i32* %arrayidx13.i576, align 4, !dbg !2048
  store i32 %774, i32* %a.addr.i16.i543, align 4
  store i8 8, i8* %n.addr.i17.i544, align 1
  %775 = load i32, i32* %a.addr.i16.i543, align 4, !dbg !2049
  %776 = load i8, i8* %n.addr.i17.i544, align 1, !dbg !2050
  %conv.i18.i577 = zext i8 %776 to i32, !dbg !2050
  %shl.i19.i578 = shl i32 %775, %conv.i18.i577, !dbg !2051
  %777 = load i32, i32* %a.addr.i16.i543, align 4, !dbg !2052
  %778 = load i8, i8* %n.addr.i17.i544, align 1, !dbg !2053
  %conv1.i20.i579 = zext i8 %778 to i32, !dbg !2053
  %sub.i21.i580 = sub nsw i32 32, %conv1.i20.i579, !dbg !2054
  %shr.i22.i581 = lshr i32 %777, %sub.i21.i580, !dbg !2055
  %or.i23.i582 = or i32 %shl.i19.i578, %shr.i22.i581, !dbg !2056
  %xor15.i583 = xor i32 %xor10.i573, %or.i23.i582, !dbg !2057
  %779 = load i32, i32* %B1, align 4, !dbg !1973
  %xor194 = xor i32 %779, %xor15.i583, !dbg !1973
  store i32 %xor194, i32* %B1, align 4, !dbg !1973
  %780 = load i32, i32* %B0, align 4, !dbg !1973
  %781 = load i32, i32* %B1, align 4, !dbg !1973
  %xor195 = xor i32 %780, %781, !dbg !1973
  %782 = load i32, i32* %B3, align 4, !dbg !1973
  %xor196 = xor i32 %xor195, %782, !dbg !1973
  %783 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1973
  %rk197 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %783, i32 0, i32 0, !dbg !1973
  %arrayidx198 = getelementptr inbounds [32 x i32], [32 x i32]* %rk197, i64 0, i64 26, !dbg !1973
  %784 = load i32, i32* %arrayidx198, align 4, !dbg !1973
  %xor199 = xor i32 %xor196, %784, !dbg !1973
  store i32 %xor199, i32* %X.addr.i504, align 4
  %785 = load i32, i32* %X.addr.i504, align 4, !dbg !2058
  %shr.i505 = lshr i32 %785, 24, !dbg !2059
  %conv.i506 = trunc i32 %shr.i505 to i8, !dbg !2060
  %idxprom.i507 = zext i8 %conv.i506 to i64, !dbg !2061
  %arrayidx.i508 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i507, !dbg !2061
  %786 = load i32, i32* %arrayidx.i508, align 4, !dbg !2061
  %787 = load i32, i32* %X.addr.i504, align 4, !dbg !2062
  %shr1.i509 = lshr i32 %787, 16, !dbg !2063
  %conv2.i510 = trunc i32 %shr1.i509 to i8, !dbg !2064
  %idxprom3.i511 = zext i8 %conv2.i510 to i64, !dbg !2065
  %arrayidx4.i512 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i511, !dbg !2065
  %788 = load i32, i32* %arrayidx4.i512, align 4, !dbg !2065
  store i32 %788, i32* %a.addr.i.i502, align 4
  store i8 24, i8* %n.addr.i.i503, align 1
  %789 = load i32, i32* %a.addr.i.i502, align 4, !dbg !2066
  %790 = load i8, i8* %n.addr.i.i503, align 1, !dbg !2067
  %conv.i.i513 = zext i8 %790 to i32, !dbg !2067
  %shl.i.i514 = shl i32 %789, %conv.i.i513, !dbg !2068
  %791 = load i32, i32* %a.addr.i.i502, align 4, !dbg !2069
  %792 = load i8, i8* %n.addr.i.i503, align 1, !dbg !2070
  %conv1.i.i515 = zext i8 %792 to i32, !dbg !2070
  %sub.i.i516 = sub nsw i32 32, %conv1.i.i515, !dbg !2071
  %shr.i.i517 = lshr i32 %791, %sub.i.i516, !dbg !2072
  %or.i.i518 = or i32 %shl.i.i514, %shr.i.i517, !dbg !2073
  %xor.i519 = xor i32 %786, %or.i.i518, !dbg !2074
  %793 = load i32, i32* %X.addr.i504, align 4, !dbg !2075
  %shr5.i520 = lshr i32 %793, 8, !dbg !2076
  %conv6.i521 = trunc i32 %shr5.i520 to i8, !dbg !2077
  %idxprom7.i522 = zext i8 %conv6.i521 to i64, !dbg !2078
  %arrayidx8.i523 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i522, !dbg !2078
  %794 = load i32, i32* %arrayidx8.i523, align 4, !dbg !2078
  store i32 %794, i32* %a.addr.i24.i498, align 4
  store i8 16, i8* %n.addr.i25.i499, align 1
  %795 = load i32, i32* %a.addr.i24.i498, align 4, !dbg !2079
  %796 = load i8, i8* %n.addr.i25.i499, align 1, !dbg !2080
  %conv.i26.i524 = zext i8 %796 to i32, !dbg !2080
  %shl.i27.i525 = shl i32 %795, %conv.i26.i524, !dbg !2081
  %797 = load i32, i32* %a.addr.i24.i498, align 4, !dbg !2082
  %798 = load i8, i8* %n.addr.i25.i499, align 1, !dbg !2083
  %conv1.i28.i526 = zext i8 %798 to i32, !dbg !2083
  %sub.i29.i527 = sub nsw i32 32, %conv1.i28.i526, !dbg !2084
  %shr.i30.i528 = lshr i32 %797, %sub.i29.i527, !dbg !2085
  %or.i31.i529 = or i32 %shl.i27.i525, %shr.i30.i528, !dbg !2086
  %xor10.i530 = xor i32 %xor.i519, %or.i31.i529, !dbg !2087
  %799 = load i32, i32* %X.addr.i504, align 4, !dbg !2088
  %conv11.i531 = trunc i32 %799 to i8, !dbg !2089
  %idxprom12.i532 = zext i8 %conv11.i531 to i64, !dbg !2090
  %arrayidx13.i533 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i532, !dbg !2090
  %800 = load i32, i32* %arrayidx13.i533, align 4, !dbg !2090
  store i32 %800, i32* %a.addr.i16.i500, align 4
  store i8 8, i8* %n.addr.i17.i501, align 1
  %801 = load i32, i32* %a.addr.i16.i500, align 4, !dbg !2091
  %802 = load i8, i8* %n.addr.i17.i501, align 1, !dbg !2092
  %conv.i18.i534 = zext i8 %802 to i32, !dbg !2092
  %shl.i19.i535 = shl i32 %801, %conv.i18.i534, !dbg !2093
  %803 = load i32, i32* %a.addr.i16.i500, align 4, !dbg !2094
  %804 = load i8, i8* %n.addr.i17.i501, align 1, !dbg !2095
  %conv1.i20.i536 = zext i8 %804 to i32, !dbg !2095
  %sub.i21.i537 = sub nsw i32 32, %conv1.i20.i536, !dbg !2096
  %shr.i22.i538 = lshr i32 %803, %sub.i21.i537, !dbg !2097
  %or.i23.i539 = or i32 %shl.i19.i535, %shr.i22.i538, !dbg !2098
  %xor15.i540 = xor i32 %xor10.i530, %or.i23.i539, !dbg !2099
  %805 = load i32, i32* %B2, align 4, !dbg !1973
  %xor201 = xor i32 %805, %xor15.i540, !dbg !1973
  store i32 %xor201, i32* %B2, align 4, !dbg !1973
  %806 = load i32, i32* %B0, align 4, !dbg !1973
  %807 = load i32, i32* %B1, align 4, !dbg !1973
  %xor202 = xor i32 %806, %807, !dbg !1973
  %808 = load i32, i32* %B2, align 4, !dbg !1973
  %xor203 = xor i32 %xor202, %808, !dbg !1973
  %809 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !1973
  %rk204 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %809, i32 0, i32 0, !dbg !1973
  %arrayidx205 = getelementptr inbounds [32 x i32], [32 x i32]* %rk204, i64 0, i64 27, !dbg !1973
  %810 = load i32, i32* %arrayidx205, align 4, !dbg !1973
  %xor206 = xor i32 %xor203, %810, !dbg !1973
  store i32 %xor206, i32* %X.addr.i482, align 4
  %811 = load i32, i32* %X.addr.i482, align 4, !dbg !2100
  %shr.i483 = lshr i32 %811, 24, !dbg !2101
  %conv.i484 = trunc i32 %shr.i483 to i8, !dbg !2102
  %idxprom.i485 = zext i8 %conv.i484 to i64, !dbg !2103
  %arrayidx.i486 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i485, !dbg !2103
  %812 = load i32, i32* %arrayidx.i486, align 4, !dbg !2103
  %813 = load i32, i32* %X.addr.i482, align 4, !dbg !2104
  %shr1.i487 = lshr i32 %813, 16, !dbg !2105
  %conv2.i488 = trunc i32 %shr1.i487 to i8, !dbg !2106
  %idxprom3.i = zext i8 %conv2.i488 to i64, !dbg !2107
  %arrayidx4.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i, !dbg !2107
  %814 = load i32, i32* %arrayidx4.i, align 4, !dbg !2107
  store i32 %814, i32* %a.addr.i.i480, align 4
  store i8 24, i8* %n.addr.i.i481, align 1
  %815 = load i32, i32* %a.addr.i.i480, align 4, !dbg !2108
  %816 = load i8, i8* %n.addr.i.i481, align 1, !dbg !2109
  %conv.i.i489 = zext i8 %816 to i32, !dbg !2109
  %shl.i.i490 = shl i32 %815, %conv.i.i489, !dbg !2110
  %817 = load i32, i32* %a.addr.i.i480, align 4, !dbg !2111
  %818 = load i8, i8* %n.addr.i.i481, align 1, !dbg !2112
  %conv1.i.i491 = zext i8 %818 to i32, !dbg !2112
  %sub.i.i492 = sub nsw i32 32, %conv1.i.i491, !dbg !2113
  %shr.i.i493 = lshr i32 %817, %sub.i.i492, !dbg !2114
  %or.i.i494 = or i32 %shl.i.i490, %shr.i.i493, !dbg !2115
  %xor.i495 = xor i32 %812, %or.i.i494, !dbg !2116
  %819 = load i32, i32* %X.addr.i482, align 4, !dbg !2117
  %shr5.i = lshr i32 %819, 8, !dbg !2118
  %conv6.i496 = trunc i32 %shr5.i to i8, !dbg !2119
  %idxprom7.i = zext i8 %conv6.i496 to i64, !dbg !2120
  %arrayidx8.i497 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i, !dbg !2120
  %820 = load i32, i32* %arrayidx8.i497, align 4, !dbg !2120
  store i32 %820, i32* %a.addr.i24.i, align 4
  store i8 16, i8* %n.addr.i25.i, align 1
  %821 = load i32, i32* %a.addr.i24.i, align 4, !dbg !2121
  %822 = load i8, i8* %n.addr.i25.i, align 1, !dbg !2122
  %conv.i26.i = zext i8 %822 to i32, !dbg !2122
  %shl.i27.i = shl i32 %821, %conv.i26.i, !dbg !2123
  %823 = load i32, i32* %a.addr.i24.i, align 4, !dbg !2124
  %824 = load i8, i8* %n.addr.i25.i, align 1, !dbg !2125
  %conv1.i28.i = zext i8 %824 to i32, !dbg !2125
  %sub.i29.i = sub nsw i32 32, %conv1.i28.i, !dbg !2126
  %shr.i30.i = lshr i32 %823, %sub.i29.i, !dbg !2127
  %or.i31.i = or i32 %shl.i27.i, %shr.i30.i, !dbg !2128
  %xor10.i = xor i32 %xor.i495, %or.i31.i, !dbg !2129
  %825 = load i32, i32* %X.addr.i482, align 4, !dbg !2130
  %conv11.i = trunc i32 %825 to i8, !dbg !2131
  %idxprom12.i = zext i8 %conv11.i to i64, !dbg !2132
  %arrayidx13.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i, !dbg !2132
  %826 = load i32, i32* %arrayidx13.i, align 4, !dbg !2132
  store i32 %826, i32* %a.addr.i16.i, align 4
  store i8 8, i8* %n.addr.i17.i, align 1
  %827 = load i32, i32* %a.addr.i16.i, align 4, !dbg !2133
  %828 = load i8, i8* %n.addr.i17.i, align 1, !dbg !2134
  %conv.i18.i = zext i8 %828 to i32, !dbg !2134
  %shl.i19.i = shl i32 %827, %conv.i18.i, !dbg !2135
  %829 = load i32, i32* %a.addr.i16.i, align 4, !dbg !2136
  %830 = load i8, i8* %n.addr.i17.i, align 1, !dbg !2137
  %conv1.i20.i = zext i8 %830 to i32, !dbg !2137
  %sub.i21.i = sub nsw i32 32, %conv1.i20.i, !dbg !2138
  %shr.i22.i = lshr i32 %829, %sub.i21.i, !dbg !2139
  %or.i23.i = or i32 %shl.i19.i, %shr.i22.i, !dbg !2140
  %xor15.i = xor i32 %xor10.i, %or.i23.i, !dbg !2141
  %831 = load i32, i32* %B3, align 4, !dbg !1973
  %xor208 = xor i32 %831, %xor15.i, !dbg !1973
  store i32 %xor208, i32* %B3, align 4, !dbg !1973
  br label %do.end209, !dbg !1973

do.end209:                                        ; preds = %do.body180
  br label %do.body210, !dbg !2142

do.body210:                                       ; preds = %do.end209
  %832 = load i32, i32* %B1, align 4, !dbg !2143
  %833 = load i32, i32* %B2, align 4, !dbg !2143
  %xor211 = xor i32 %832, %833, !dbg !2143
  %834 = load i32, i32* %B3, align 4, !dbg !2143
  %xor212 = xor i32 %xor211, %834, !dbg !2143
  %835 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !2143
  %rk213 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %835, i32 0, i32 0, !dbg !2143
  %arrayidx214 = getelementptr inbounds [32 x i32], [32 x i32]* %rk213, i64 0, i64 28, !dbg !2143
  %836 = load i32, i32* %arrayidx214, align 4, !dbg !2143
  %xor215 = xor i32 %xor212, %836, !dbg !2143
  store i32 %xor215, i32* %X.addr.i424, align 4
  store i32 0, i32* %t.i425, align 4, !dbg !672
  %837 = load i32, i32* %X.addr.i424, align 4, !dbg !2144
  %shr.i426 = lshr i32 %837, 24, !dbg !2145
  %conv.i427 = trunc i32 %shr.i426 to i8, !dbg !2146
  %idxprom.i428 = zext i8 %conv.i427 to i64, !dbg !2147
  %arrayidx.i429 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom.i428, !dbg !2147
  %838 = load i8, i8* %arrayidx.i429, align 1, !dbg !2147
  %conv1.i430 = zext i8 %838 to i32, !dbg !2148
  %shl.i431 = shl i32 %conv1.i430, 24, !dbg !2149
  %839 = load i32, i32* %t.i425, align 4, !dbg !2150
  %or.i432 = or i32 %839, %shl.i431, !dbg !2150
  store i32 %or.i432, i32* %t.i425, align 4, !dbg !2150
  %840 = load i32, i32* %X.addr.i424, align 4, !dbg !2151
  %shr2.i433 = lshr i32 %840, 16, !dbg !2152
  %conv3.i434 = trunc i32 %shr2.i433 to i8, !dbg !2153
  %idxprom4.i435 = zext i8 %conv3.i434 to i64, !dbg !2154
  %arrayidx5.i436 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom4.i435, !dbg !2154
  %841 = load i8, i8* %arrayidx5.i436, align 1, !dbg !2154
  %conv6.i437 = zext i8 %841 to i32, !dbg !2155
  %shl7.i438 = shl i32 %conv6.i437, 16, !dbg !2156
  %842 = load i32, i32* %t.i425, align 4, !dbg !2157
  %or8.i439 = or i32 %842, %shl7.i438, !dbg !2157
  store i32 %or8.i439, i32* %t.i425, align 4, !dbg !2157
  %843 = load i32, i32* %X.addr.i424, align 4, !dbg !2158
  %shr9.i440 = lshr i32 %843, 8, !dbg !2159
  %conv10.i441 = trunc i32 %shr9.i440 to i8, !dbg !2160
  %idxprom11.i442 = zext i8 %conv10.i441 to i64, !dbg !2161
  %arrayidx12.i443 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom11.i442, !dbg !2161
  %844 = load i8, i8* %arrayidx12.i443, align 1, !dbg !2161
  %conv13.i444 = zext i8 %844 to i32, !dbg !2162
  %shl14.i445 = shl i32 %conv13.i444, 8, !dbg !2163
  %845 = load i32, i32* %t.i425, align 4, !dbg !2164
  %or15.i446 = or i32 %845, %shl14.i445, !dbg !2164
  store i32 %or15.i446, i32* %t.i425, align 4, !dbg !2164
  %846 = load i32, i32* %X.addr.i424, align 4, !dbg !2165
  %conv16.i447 = trunc i32 %846 to i8, !dbg !2166
  %idxprom17.i448 = zext i8 %conv16.i447 to i64, !dbg !2167
  %arrayidx18.i449 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom17.i448, !dbg !2167
  %847 = load i8, i8* %arrayidx18.i449, align 1, !dbg !2167
  %conv19.i450 = zext i8 %847 to i32, !dbg !2167
  %848 = load i32, i32* %t.i425, align 4, !dbg !2168
  %or20.i451 = or i32 %848, %conv19.i450, !dbg !2168
  store i32 %or20.i451, i32* %t.i425, align 4, !dbg !2168
  %849 = load i32, i32* %t.i425, align 4, !dbg !2169
  %850 = load i32, i32* %t.i425, align 4, !dbg !2170
  store i32 %850, i32* %a.addr.i.i422, align 4
  store i8 2, i8* %n.addr.i.i423, align 1
  %851 = load i32, i32* %a.addr.i.i422, align 4, !dbg !2171
  %852 = load i8, i8* %n.addr.i.i423, align 1, !dbg !2172
  %conv.i.i452 = zext i8 %852 to i32, !dbg !2172
  %shl.i.i453 = shl i32 %851, %conv.i.i452, !dbg !2173
  %853 = load i32, i32* %a.addr.i.i422, align 4, !dbg !2174
  %854 = load i8, i8* %n.addr.i.i423, align 1, !dbg !2175
  %conv1.i.i454 = zext i8 %854 to i32, !dbg !2175
  %sub.i.i455 = sub nsw i32 32, %conv1.i.i454, !dbg !2176
  %shr.i.i456 = lshr i32 %853, %sub.i.i455, !dbg !2177
  %or.i.i457 = or i32 %shl.i.i453, %shr.i.i456, !dbg !2178
  %xor.i458 = xor i32 %849, %or.i.i457, !dbg !2179
  %855 = load i32, i32* %t.i425, align 4, !dbg !2180
  store i32 %855, i32* %a.addr.i43.i416, align 4
  store i8 10, i8* %n.addr.i44.i417, align 1
  %856 = load i32, i32* %a.addr.i43.i416, align 4, !dbg !2181
  %857 = load i8, i8* %n.addr.i44.i417, align 1, !dbg !2182
  %conv.i45.i459 = zext i8 %857 to i32, !dbg !2182
  %shl.i46.i460 = shl i32 %856, %conv.i45.i459, !dbg !2183
  %858 = load i32, i32* %a.addr.i43.i416, align 4, !dbg !2184
  %859 = load i8, i8* %n.addr.i44.i417, align 1, !dbg !2185
  %conv1.i47.i461 = zext i8 %859 to i32, !dbg !2185
  %sub.i48.i462 = sub nsw i32 32, %conv1.i47.i461, !dbg !2186
  %shr.i49.i463 = lshr i32 %858, %sub.i48.i462, !dbg !2187
  %or.i50.i464 = or i32 %shl.i46.i460, %shr.i49.i463, !dbg !2188
  %xor22.i465 = xor i32 %xor.i458, %or.i50.i464, !dbg !2189
  %860 = load i32, i32* %t.i425, align 4, !dbg !2190
  store i32 %860, i32* %a.addr.i35.i418, align 4
  store i8 18, i8* %n.addr.i36.i419, align 1
  %861 = load i32, i32* %a.addr.i35.i418, align 4, !dbg !2191
  %862 = load i8, i8* %n.addr.i36.i419, align 1, !dbg !2192
  %conv.i37.i466 = zext i8 %862 to i32, !dbg !2192
  %shl.i38.i467 = shl i32 %861, %conv.i37.i466, !dbg !2193
  %863 = load i32, i32* %a.addr.i35.i418, align 4, !dbg !2194
  %864 = load i8, i8* %n.addr.i36.i419, align 1, !dbg !2195
  %conv1.i39.i468 = zext i8 %864 to i32, !dbg !2195
  %sub.i40.i469 = sub nsw i32 32, %conv1.i39.i468, !dbg !2196
  %shr.i41.i470 = lshr i32 %863, %sub.i40.i469, !dbg !2197
  %or.i42.i471 = or i32 %shl.i38.i467, %shr.i41.i470, !dbg !2198
  %xor24.i472 = xor i32 %xor22.i465, %or.i42.i471, !dbg !2199
  %865 = load i32, i32* %t.i425, align 4, !dbg !2200
  store i32 %865, i32* %a.addr.i27.i420, align 4
  store i8 24, i8* %n.addr.i28.i421, align 1
  %866 = load i32, i32* %a.addr.i27.i420, align 4, !dbg !2201
  %867 = load i8, i8* %n.addr.i28.i421, align 1, !dbg !2202
  %conv.i29.i473 = zext i8 %867 to i32, !dbg !2202
  %shl.i30.i474 = shl i32 %866, %conv.i29.i473, !dbg !2203
  %868 = load i32, i32* %a.addr.i27.i420, align 4, !dbg !2204
  %869 = load i8, i8* %n.addr.i28.i421, align 1, !dbg !2205
  %conv1.i31.i475 = zext i8 %869 to i32, !dbg !2205
  %sub.i32.i476 = sub nsw i32 32, %conv1.i31.i475, !dbg !2206
  %shr.i33.i477 = lshr i32 %868, %sub.i32.i476, !dbg !2207
  %or.i34.i478 = or i32 %shl.i30.i474, %shr.i33.i477, !dbg !2208
  %xor26.i479 = xor i32 %xor24.i472, %or.i34.i478, !dbg !2209
  %870 = load i32, i32* %B0, align 4, !dbg !2143
  %xor217 = xor i32 %870, %xor26.i479, !dbg !2143
  store i32 %xor217, i32* %B0, align 4, !dbg !2143
  %871 = load i32, i32* %B0, align 4, !dbg !2143
  %872 = load i32, i32* %B2, align 4, !dbg !2143
  %xor218 = xor i32 %871, %872, !dbg !2143
  %873 = load i32, i32* %B3, align 4, !dbg !2143
  %xor219 = xor i32 %xor218, %873, !dbg !2143
  %874 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !2143
  %rk220 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %874, i32 0, i32 0, !dbg !2143
  %arrayidx221 = getelementptr inbounds [32 x i32], [32 x i32]* %rk220, i64 0, i64 29, !dbg !2143
  %875 = load i32, i32* %arrayidx221, align 4, !dbg !2143
  %xor222 = xor i32 %xor219, %875, !dbg !2143
  store i32 %xor222, i32* %X.addr.i360, align 4
  store i32 0, i32* %t.i361, align 4, !dbg !687
  %876 = load i32, i32* %X.addr.i360, align 4, !dbg !2210
  %shr.i362 = lshr i32 %876, 24, !dbg !2211
  %conv.i363 = trunc i32 %shr.i362 to i8, !dbg !2212
  %idxprom.i364 = zext i8 %conv.i363 to i64, !dbg !2213
  %arrayidx.i365 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom.i364, !dbg !2213
  %877 = load i8, i8* %arrayidx.i365, align 1, !dbg !2213
  %conv1.i366 = zext i8 %877 to i32, !dbg !2214
  %shl.i367 = shl i32 %conv1.i366, 24, !dbg !2215
  %878 = load i32, i32* %t.i361, align 4, !dbg !2216
  %or.i368 = or i32 %878, %shl.i367, !dbg !2216
  store i32 %or.i368, i32* %t.i361, align 4, !dbg !2216
  %879 = load i32, i32* %X.addr.i360, align 4, !dbg !2217
  %shr2.i369 = lshr i32 %879, 16, !dbg !2218
  %conv3.i370 = trunc i32 %shr2.i369 to i8, !dbg !2219
  %idxprom4.i371 = zext i8 %conv3.i370 to i64, !dbg !2220
  %arrayidx5.i372 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom4.i371, !dbg !2220
  %880 = load i8, i8* %arrayidx5.i372, align 1, !dbg !2220
  %conv6.i373 = zext i8 %880 to i32, !dbg !2221
  %shl7.i374 = shl i32 %conv6.i373, 16, !dbg !2222
  %881 = load i32, i32* %t.i361, align 4, !dbg !2223
  %or8.i375 = or i32 %881, %shl7.i374, !dbg !2223
  store i32 %or8.i375, i32* %t.i361, align 4, !dbg !2223
  %882 = load i32, i32* %X.addr.i360, align 4, !dbg !2224
  %shr9.i376 = lshr i32 %882, 8, !dbg !2225
  %conv10.i377 = trunc i32 %shr9.i376 to i8, !dbg !2226
  %idxprom11.i378 = zext i8 %conv10.i377 to i64, !dbg !2227
  %arrayidx12.i379 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom11.i378, !dbg !2227
  %883 = load i8, i8* %arrayidx12.i379, align 1, !dbg !2227
  %conv13.i380 = zext i8 %883 to i32, !dbg !2228
  %shl14.i381 = shl i32 %conv13.i380, 8, !dbg !2229
  %884 = load i32, i32* %t.i361, align 4, !dbg !2230
  %or15.i382 = or i32 %884, %shl14.i381, !dbg !2230
  store i32 %or15.i382, i32* %t.i361, align 4, !dbg !2230
  %885 = load i32, i32* %X.addr.i360, align 4, !dbg !2231
  %conv16.i383 = trunc i32 %885 to i8, !dbg !2232
  %idxprom17.i384 = zext i8 %conv16.i383 to i64, !dbg !2233
  %arrayidx18.i385 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom17.i384, !dbg !2233
  %886 = load i8, i8* %arrayidx18.i385, align 1, !dbg !2233
  %conv19.i386 = zext i8 %886 to i32, !dbg !2233
  %887 = load i32, i32* %t.i361, align 4, !dbg !2234
  %or20.i387 = or i32 %887, %conv19.i386, !dbg !2234
  store i32 %or20.i387, i32* %t.i361, align 4, !dbg !2234
  %888 = load i32, i32* %t.i361, align 4, !dbg !2235
  %889 = load i32, i32* %t.i361, align 4, !dbg !2236
  store i32 %889, i32* %a.addr.i.i358, align 4
  store i8 2, i8* %n.addr.i.i359, align 1
  %890 = load i32, i32* %a.addr.i.i358, align 4, !dbg !2237
  %891 = load i8, i8* %n.addr.i.i359, align 1, !dbg !2238
  %conv.i.i388 = zext i8 %891 to i32, !dbg !2238
  %shl.i.i389 = shl i32 %890, %conv.i.i388, !dbg !2239
  %892 = load i32, i32* %a.addr.i.i358, align 4, !dbg !2240
  %893 = load i8, i8* %n.addr.i.i359, align 1, !dbg !2241
  %conv1.i.i390 = zext i8 %893 to i32, !dbg !2241
  %sub.i.i391 = sub nsw i32 32, %conv1.i.i390, !dbg !2242
  %shr.i.i392 = lshr i32 %892, %sub.i.i391, !dbg !2243
  %or.i.i393 = or i32 %shl.i.i389, %shr.i.i392, !dbg !2244
  %xor.i394 = xor i32 %888, %or.i.i393, !dbg !2245
  %894 = load i32, i32* %t.i361, align 4, !dbg !2246
  store i32 %894, i32* %a.addr.i43.i352, align 4
  store i8 10, i8* %n.addr.i44.i353, align 1
  %895 = load i32, i32* %a.addr.i43.i352, align 4, !dbg !2247
  %896 = load i8, i8* %n.addr.i44.i353, align 1, !dbg !2248
  %conv.i45.i395 = zext i8 %896 to i32, !dbg !2248
  %shl.i46.i396 = shl i32 %895, %conv.i45.i395, !dbg !2249
  %897 = load i32, i32* %a.addr.i43.i352, align 4, !dbg !2250
  %898 = load i8, i8* %n.addr.i44.i353, align 1, !dbg !2251
  %conv1.i47.i397 = zext i8 %898 to i32, !dbg !2251
  %sub.i48.i398 = sub nsw i32 32, %conv1.i47.i397, !dbg !2252
  %shr.i49.i399 = lshr i32 %897, %sub.i48.i398, !dbg !2253
  %or.i50.i400 = or i32 %shl.i46.i396, %shr.i49.i399, !dbg !2254
  %xor22.i401 = xor i32 %xor.i394, %or.i50.i400, !dbg !2255
  %899 = load i32, i32* %t.i361, align 4, !dbg !2256
  store i32 %899, i32* %a.addr.i35.i354, align 4
  store i8 18, i8* %n.addr.i36.i355, align 1
  %900 = load i32, i32* %a.addr.i35.i354, align 4, !dbg !2257
  %901 = load i8, i8* %n.addr.i36.i355, align 1, !dbg !2258
  %conv.i37.i402 = zext i8 %901 to i32, !dbg !2258
  %shl.i38.i403 = shl i32 %900, %conv.i37.i402, !dbg !2259
  %902 = load i32, i32* %a.addr.i35.i354, align 4, !dbg !2260
  %903 = load i8, i8* %n.addr.i36.i355, align 1, !dbg !2261
  %conv1.i39.i404 = zext i8 %903 to i32, !dbg !2261
  %sub.i40.i405 = sub nsw i32 32, %conv1.i39.i404, !dbg !2262
  %shr.i41.i406 = lshr i32 %902, %sub.i40.i405, !dbg !2263
  %or.i42.i407 = or i32 %shl.i38.i403, %shr.i41.i406, !dbg !2264
  %xor24.i408 = xor i32 %xor22.i401, %or.i42.i407, !dbg !2265
  %904 = load i32, i32* %t.i361, align 4, !dbg !2266
  store i32 %904, i32* %a.addr.i27.i356, align 4
  store i8 24, i8* %n.addr.i28.i357, align 1
  %905 = load i32, i32* %a.addr.i27.i356, align 4, !dbg !2267
  %906 = load i8, i8* %n.addr.i28.i357, align 1, !dbg !2268
  %conv.i29.i409 = zext i8 %906 to i32, !dbg !2268
  %shl.i30.i410 = shl i32 %905, %conv.i29.i409, !dbg !2269
  %907 = load i32, i32* %a.addr.i27.i356, align 4, !dbg !2270
  %908 = load i8, i8* %n.addr.i28.i357, align 1, !dbg !2271
  %conv1.i31.i411 = zext i8 %908 to i32, !dbg !2271
  %sub.i32.i412 = sub nsw i32 32, %conv1.i31.i411, !dbg !2272
  %shr.i33.i413 = lshr i32 %907, %sub.i32.i412, !dbg !2273
  %or.i34.i414 = or i32 %shl.i30.i410, %shr.i33.i413, !dbg !2274
  %xor26.i415 = xor i32 %xor24.i408, %or.i34.i414, !dbg !2275
  %909 = load i32, i32* %B1, align 4, !dbg !2143
  %xor224 = xor i32 %909, %xor26.i415, !dbg !2143
  store i32 %xor224, i32* %B1, align 4, !dbg !2143
  %910 = load i32, i32* %B0, align 4, !dbg !2143
  %911 = load i32, i32* %B1, align 4, !dbg !2143
  %xor225 = xor i32 %910, %911, !dbg !2143
  %912 = load i32, i32* %B3, align 4, !dbg !2143
  %xor226 = xor i32 %xor225, %912, !dbg !2143
  %913 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !2143
  %rk227 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %913, i32 0, i32 0, !dbg !2143
  %arrayidx228 = getelementptr inbounds [32 x i32], [32 x i32]* %rk227, i64 0, i64 30, !dbg !2143
  %914 = load i32, i32* %arrayidx228, align 4, !dbg !2143
  %xor229 = xor i32 %xor226, %914, !dbg !2143
  store i32 %xor229, i32* %X.addr.i296, align 4
  store i32 0, i32* %t.i297, align 4, !dbg !702
  %915 = load i32, i32* %X.addr.i296, align 4, !dbg !2276
  %shr.i298 = lshr i32 %915, 24, !dbg !2277
  %conv.i299 = trunc i32 %shr.i298 to i8, !dbg !2278
  %idxprom.i300 = zext i8 %conv.i299 to i64, !dbg !2279
  %arrayidx.i301 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom.i300, !dbg !2279
  %916 = load i8, i8* %arrayidx.i301, align 1, !dbg !2279
  %conv1.i302 = zext i8 %916 to i32, !dbg !2280
  %shl.i303 = shl i32 %conv1.i302, 24, !dbg !2281
  %917 = load i32, i32* %t.i297, align 4, !dbg !2282
  %or.i304 = or i32 %917, %shl.i303, !dbg !2282
  store i32 %or.i304, i32* %t.i297, align 4, !dbg !2282
  %918 = load i32, i32* %X.addr.i296, align 4, !dbg !2283
  %shr2.i305 = lshr i32 %918, 16, !dbg !2284
  %conv3.i306 = trunc i32 %shr2.i305 to i8, !dbg !2285
  %idxprom4.i307 = zext i8 %conv3.i306 to i64, !dbg !2286
  %arrayidx5.i308 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom4.i307, !dbg !2286
  %919 = load i8, i8* %arrayidx5.i308, align 1, !dbg !2286
  %conv6.i309 = zext i8 %919 to i32, !dbg !2287
  %shl7.i310 = shl i32 %conv6.i309, 16, !dbg !2288
  %920 = load i32, i32* %t.i297, align 4, !dbg !2289
  %or8.i311 = or i32 %920, %shl7.i310, !dbg !2289
  store i32 %or8.i311, i32* %t.i297, align 4, !dbg !2289
  %921 = load i32, i32* %X.addr.i296, align 4, !dbg !2290
  %shr9.i312 = lshr i32 %921, 8, !dbg !2291
  %conv10.i313 = trunc i32 %shr9.i312 to i8, !dbg !2292
  %idxprom11.i314 = zext i8 %conv10.i313 to i64, !dbg !2293
  %arrayidx12.i315 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom11.i314, !dbg !2293
  %922 = load i8, i8* %arrayidx12.i315, align 1, !dbg !2293
  %conv13.i316 = zext i8 %922 to i32, !dbg !2294
  %shl14.i317 = shl i32 %conv13.i316, 8, !dbg !2295
  %923 = load i32, i32* %t.i297, align 4, !dbg !2296
  %or15.i318 = or i32 %923, %shl14.i317, !dbg !2296
  store i32 %or15.i318, i32* %t.i297, align 4, !dbg !2296
  %924 = load i32, i32* %X.addr.i296, align 4, !dbg !2297
  %conv16.i319 = trunc i32 %924 to i8, !dbg !2298
  %idxprom17.i320 = zext i8 %conv16.i319 to i64, !dbg !2299
  %arrayidx18.i321 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom17.i320, !dbg !2299
  %925 = load i8, i8* %arrayidx18.i321, align 1, !dbg !2299
  %conv19.i322 = zext i8 %925 to i32, !dbg !2299
  %926 = load i32, i32* %t.i297, align 4, !dbg !2300
  %or20.i323 = or i32 %926, %conv19.i322, !dbg !2300
  store i32 %or20.i323, i32* %t.i297, align 4, !dbg !2300
  %927 = load i32, i32* %t.i297, align 4, !dbg !2301
  %928 = load i32, i32* %t.i297, align 4, !dbg !2302
  store i32 %928, i32* %a.addr.i.i294, align 4
  store i8 2, i8* %n.addr.i.i295, align 1
  %929 = load i32, i32* %a.addr.i.i294, align 4, !dbg !2303
  %930 = load i8, i8* %n.addr.i.i295, align 1, !dbg !2304
  %conv.i.i324 = zext i8 %930 to i32, !dbg !2304
  %shl.i.i325 = shl i32 %929, %conv.i.i324, !dbg !2305
  %931 = load i32, i32* %a.addr.i.i294, align 4, !dbg !2306
  %932 = load i8, i8* %n.addr.i.i295, align 1, !dbg !2307
  %conv1.i.i326 = zext i8 %932 to i32, !dbg !2307
  %sub.i.i327 = sub nsw i32 32, %conv1.i.i326, !dbg !2308
  %shr.i.i328 = lshr i32 %931, %sub.i.i327, !dbg !2309
  %or.i.i329 = or i32 %shl.i.i325, %shr.i.i328, !dbg !2310
  %xor.i330 = xor i32 %927, %or.i.i329, !dbg !2311
  %933 = load i32, i32* %t.i297, align 4, !dbg !2312
  store i32 %933, i32* %a.addr.i43.i288, align 4
  store i8 10, i8* %n.addr.i44.i289, align 1
  %934 = load i32, i32* %a.addr.i43.i288, align 4, !dbg !2313
  %935 = load i8, i8* %n.addr.i44.i289, align 1, !dbg !2314
  %conv.i45.i331 = zext i8 %935 to i32, !dbg !2314
  %shl.i46.i332 = shl i32 %934, %conv.i45.i331, !dbg !2315
  %936 = load i32, i32* %a.addr.i43.i288, align 4, !dbg !2316
  %937 = load i8, i8* %n.addr.i44.i289, align 1, !dbg !2317
  %conv1.i47.i333 = zext i8 %937 to i32, !dbg !2317
  %sub.i48.i334 = sub nsw i32 32, %conv1.i47.i333, !dbg !2318
  %shr.i49.i335 = lshr i32 %936, %sub.i48.i334, !dbg !2319
  %or.i50.i336 = or i32 %shl.i46.i332, %shr.i49.i335, !dbg !2320
  %xor22.i337 = xor i32 %xor.i330, %or.i50.i336, !dbg !2321
  %938 = load i32, i32* %t.i297, align 4, !dbg !2322
  store i32 %938, i32* %a.addr.i35.i290, align 4
  store i8 18, i8* %n.addr.i36.i291, align 1
  %939 = load i32, i32* %a.addr.i35.i290, align 4, !dbg !2323
  %940 = load i8, i8* %n.addr.i36.i291, align 1, !dbg !2324
  %conv.i37.i338 = zext i8 %940 to i32, !dbg !2324
  %shl.i38.i339 = shl i32 %939, %conv.i37.i338, !dbg !2325
  %941 = load i32, i32* %a.addr.i35.i290, align 4, !dbg !2326
  %942 = load i8, i8* %n.addr.i36.i291, align 1, !dbg !2327
  %conv1.i39.i340 = zext i8 %942 to i32, !dbg !2327
  %sub.i40.i341 = sub nsw i32 32, %conv1.i39.i340, !dbg !2328
  %shr.i41.i342 = lshr i32 %941, %sub.i40.i341, !dbg !2329
  %or.i42.i343 = or i32 %shl.i38.i339, %shr.i41.i342, !dbg !2330
  %xor24.i344 = xor i32 %xor22.i337, %or.i42.i343, !dbg !2331
  %943 = load i32, i32* %t.i297, align 4, !dbg !2332
  store i32 %943, i32* %a.addr.i27.i292, align 4
  store i8 24, i8* %n.addr.i28.i293, align 1
  %944 = load i32, i32* %a.addr.i27.i292, align 4, !dbg !2333
  %945 = load i8, i8* %n.addr.i28.i293, align 1, !dbg !2334
  %conv.i29.i345 = zext i8 %945 to i32, !dbg !2334
  %shl.i30.i346 = shl i32 %944, %conv.i29.i345, !dbg !2335
  %946 = load i32, i32* %a.addr.i27.i292, align 4, !dbg !2336
  %947 = load i8, i8* %n.addr.i28.i293, align 1, !dbg !2337
  %conv1.i31.i347 = zext i8 %947 to i32, !dbg !2337
  %sub.i32.i348 = sub nsw i32 32, %conv1.i31.i347, !dbg !2338
  %shr.i33.i349 = lshr i32 %946, %sub.i32.i348, !dbg !2339
  %or.i34.i350 = or i32 %shl.i30.i346, %shr.i33.i349, !dbg !2340
  %xor26.i351 = xor i32 %xor24.i344, %or.i34.i350, !dbg !2341
  %948 = load i32, i32* %B2, align 4, !dbg !2143
  %xor231 = xor i32 %948, %xor26.i351, !dbg !2143
  store i32 %xor231, i32* %B2, align 4, !dbg !2143
  %949 = load i32, i32* %B0, align 4, !dbg !2143
  %950 = load i32, i32* %B1, align 4, !dbg !2143
  %xor232 = xor i32 %949, %950, !dbg !2143
  %951 = load i32, i32* %B2, align 4, !dbg !2143
  %xor233 = xor i32 %xor232, %951, !dbg !2143
  %952 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !2143
  %rk234 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %952, i32 0, i32 0, !dbg !2143
  %arrayidx235 = getelementptr inbounds [32 x i32], [32 x i32]* %rk234, i64 0, i64 31, !dbg !2143
  %953 = load i32, i32* %arrayidx235, align 4, !dbg !2143
  %xor236 = xor i32 %xor233, %953, !dbg !2143
  store i32 %xor236, i32* %X.addr.i, align 4
  store i32 0, i32* %t.i, align 4, !dbg !717
  %954 = load i32, i32* %X.addr.i, align 4, !dbg !2342
  %shr.i281 = lshr i32 %954, 24, !dbg !2343
  %conv.i282 = trunc i32 %shr.i281 to i8, !dbg !2344
  %idxprom.i283 = zext i8 %conv.i282 to i64, !dbg !2345
  %arrayidx.i284 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom.i283, !dbg !2345
  %955 = load i8, i8* %arrayidx.i284, align 1, !dbg !2345
  %conv1.i = zext i8 %955 to i32, !dbg !2346
  %shl.i285 = shl i32 %conv1.i, 24, !dbg !2347
  %956 = load i32, i32* %t.i, align 4, !dbg !2348
  %or.i286 = or i32 %956, %shl.i285, !dbg !2348
  store i32 %or.i286, i32* %t.i, align 4, !dbg !2348
  %957 = load i32, i32* %X.addr.i, align 4, !dbg !2349
  %shr2.i = lshr i32 %957, 16, !dbg !2350
  %conv3.i = trunc i32 %shr2.i to i8, !dbg !2351
  %idxprom4.i = zext i8 %conv3.i to i64, !dbg !2352
  %arrayidx5.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom4.i, !dbg !2352
  %958 = load i8, i8* %arrayidx5.i, align 1, !dbg !2352
  %conv6.i = zext i8 %958 to i32, !dbg !2353
  %shl7.i = shl i32 %conv6.i, 16, !dbg !2354
  %959 = load i32, i32* %t.i, align 4, !dbg !2355
  %or8.i = or i32 %959, %shl7.i, !dbg !2355
  store i32 %or8.i, i32* %t.i, align 4, !dbg !2355
  %960 = load i32, i32* %X.addr.i, align 4, !dbg !2356
  %shr9.i = lshr i32 %960, 8, !dbg !2357
  %conv10.i287 = trunc i32 %shr9.i to i8, !dbg !2358
  %idxprom11.i = zext i8 %conv10.i287 to i64, !dbg !2359
  %arrayidx12.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom11.i, !dbg !2359
  %961 = load i8, i8* %arrayidx12.i, align 1, !dbg !2359
  %conv13.i = zext i8 %961 to i32, !dbg !2360
  %shl14.i = shl i32 %conv13.i, 8, !dbg !2361
  %962 = load i32, i32* %t.i, align 4, !dbg !2362
  %or15.i = or i32 %962, %shl14.i, !dbg !2362
  store i32 %or15.i, i32* %t.i, align 4, !dbg !2362
  %963 = load i32, i32* %X.addr.i, align 4, !dbg !2363
  %conv16.i = trunc i32 %963 to i8, !dbg !2364
  %idxprom17.i = zext i8 %conv16.i to i64, !dbg !2365
  %arrayidx18.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom17.i, !dbg !2365
  %964 = load i8, i8* %arrayidx18.i, align 1, !dbg !2365
  %conv19.i = zext i8 %964 to i32, !dbg !2365
  %965 = load i32, i32* %t.i, align 4, !dbg !2366
  %or20.i = or i32 %965, %conv19.i, !dbg !2366
  store i32 %or20.i, i32* %t.i, align 4, !dbg !2366
  %966 = load i32, i32* %t.i, align 4, !dbg !2367
  %967 = load i32, i32* %t.i, align 4, !dbg !2368
  store i32 %967, i32* %a.addr.i.i, align 4
  store i8 2, i8* %n.addr.i.i, align 1
  %968 = load i32, i32* %a.addr.i.i, align 4, !dbg !2369
  %969 = load i8, i8* %n.addr.i.i, align 1, !dbg !2370
  %conv.i.i = zext i8 %969 to i32, !dbg !2370
  %shl.i.i = shl i32 %968, %conv.i.i, !dbg !2371
  %970 = load i32, i32* %a.addr.i.i, align 4, !dbg !2372
  %971 = load i8, i8* %n.addr.i.i, align 1, !dbg !2373
  %conv1.i.i = zext i8 %971 to i32, !dbg !2373
  %sub.i.i = sub nsw i32 32, %conv1.i.i, !dbg !2374
  %shr.i.i = lshr i32 %970, %sub.i.i, !dbg !2375
  %or.i.i = or i32 %shl.i.i, %shr.i.i, !dbg !2376
  %xor.i = xor i32 %966, %or.i.i, !dbg !2377
  %972 = load i32, i32* %t.i, align 4, !dbg !2378
  store i32 %972, i32* %a.addr.i43.i, align 4
  store i8 10, i8* %n.addr.i44.i, align 1
  %973 = load i32, i32* %a.addr.i43.i, align 4, !dbg !2379
  %974 = load i8, i8* %n.addr.i44.i, align 1, !dbg !2380
  %conv.i45.i = zext i8 %974 to i32, !dbg !2380
  %shl.i46.i = shl i32 %973, %conv.i45.i, !dbg !2381
  %975 = load i32, i32* %a.addr.i43.i, align 4, !dbg !2382
  %976 = load i8, i8* %n.addr.i44.i, align 1, !dbg !2383
  %conv1.i47.i = zext i8 %976 to i32, !dbg !2383
  %sub.i48.i = sub nsw i32 32, %conv1.i47.i, !dbg !2384
  %shr.i49.i = lshr i32 %975, %sub.i48.i, !dbg !2385
  %or.i50.i = or i32 %shl.i46.i, %shr.i49.i, !dbg !2386
  %xor22.i = xor i32 %xor.i, %or.i50.i, !dbg !2387
  %977 = load i32, i32* %t.i, align 4, !dbg !2388
  store i32 %977, i32* %a.addr.i35.i, align 4
  store i8 18, i8* %n.addr.i36.i, align 1
  %978 = load i32, i32* %a.addr.i35.i, align 4, !dbg !2389
  %979 = load i8, i8* %n.addr.i36.i, align 1, !dbg !2390
  %conv.i37.i = zext i8 %979 to i32, !dbg !2390
  %shl.i38.i = shl i32 %978, %conv.i37.i, !dbg !2391
  %980 = load i32, i32* %a.addr.i35.i, align 4, !dbg !2392
  %981 = load i8, i8* %n.addr.i36.i, align 1, !dbg !2393
  %conv1.i39.i = zext i8 %981 to i32, !dbg !2393
  %sub.i40.i = sub nsw i32 32, %conv1.i39.i, !dbg !2394
  %shr.i41.i = lshr i32 %980, %sub.i40.i, !dbg !2395
  %or.i42.i = or i32 %shl.i38.i, %shr.i41.i, !dbg !2396
  %xor24.i = xor i32 %xor22.i, %or.i42.i, !dbg !2397
  %982 = load i32, i32* %t.i, align 4, !dbg !2398
  store i32 %982, i32* %a.addr.i27.i, align 4
  store i8 24, i8* %n.addr.i28.i, align 1
  %983 = load i32, i32* %a.addr.i27.i, align 4, !dbg !2399
  %984 = load i8, i8* %n.addr.i28.i, align 1, !dbg !2400
  %conv.i29.i = zext i8 %984 to i32, !dbg !2400
  %shl.i30.i = shl i32 %983, %conv.i29.i, !dbg !2401
  %985 = load i32, i32* %a.addr.i27.i, align 4, !dbg !2402
  %986 = load i8, i8* %n.addr.i28.i, align 1, !dbg !2403
  %conv1.i31.i = zext i8 %986 to i32, !dbg !2403
  %sub.i32.i = sub nsw i32 32, %conv1.i31.i, !dbg !2404
  %shr.i33.i = lshr i32 %985, %sub.i32.i, !dbg !2405
  %or.i34.i = or i32 %shl.i30.i, %shr.i33.i, !dbg !2406
  %xor26.i = xor i32 %xor24.i, %or.i34.i, !dbg !2407
  %987 = load i32, i32* %B3, align 4, !dbg !2143
  %xor238 = xor i32 %987, %xor26.i, !dbg !2143
  store i32 %xor238, i32* %B3, align 4, !dbg !2143
  br label %do.end239, !dbg !2143

do.end239:                                        ; preds = %do.body210
  %988 = load i32, i32* %B3, align 4, !dbg !2408
  %989 = load i8*, i8** %out.addr, align 8, !dbg !2409
  store i32 %988, i32* %v.addr.i269, align 4
  store i8* %989, i8** %b.addr.i270, align 8
  %990 = load i32, i32* %v.addr.i269, align 4, !dbg !2410
  %shr.i271 = lshr i32 %990, 24, !dbg !2411
  %conv.i272 = trunc i32 %shr.i271 to i8, !dbg !2412
  %991 = load i8*, i8** %b.addr.i270, align 8, !dbg !2413
  store i8 %conv.i272, i8* %991, align 1, !dbg !2414
  %992 = load i32, i32* %v.addr.i269, align 4, !dbg !2415
  %shr1.i273 = lshr i32 %992, 16, !dbg !2416
  %conv2.i274 = trunc i32 %shr1.i273 to i8, !dbg !2417
  %993 = load i8*, i8** %b.addr.i270, align 8, !dbg !2418
  %arrayidx3.i275 = getelementptr inbounds i8, i8* %993, i64 1, !dbg !2418
  store i8 %conv2.i274, i8* %arrayidx3.i275, align 1, !dbg !2419
  %994 = load i32, i32* %v.addr.i269, align 4, !dbg !2420
  %shr4.i276 = lshr i32 %994, 8, !dbg !2421
  %conv5.i277 = trunc i32 %shr4.i276 to i8, !dbg !2422
  %995 = load i8*, i8** %b.addr.i270, align 8, !dbg !2423
  %arrayidx6.i278 = getelementptr inbounds i8, i8* %995, i64 2, !dbg !2423
  store i8 %conv5.i277, i8* %arrayidx6.i278, align 1, !dbg !2424
  %996 = load i32, i32* %v.addr.i269, align 4, !dbg !2425
  %conv7.i279 = trunc i32 %996 to i8, !dbg !2426
  %997 = load i8*, i8** %b.addr.i270, align 8, !dbg !2427
  %arrayidx8.i280 = getelementptr inbounds i8, i8* %997, i64 3, !dbg !2427
  store i8 %conv7.i279, i8* %arrayidx8.i280, align 1, !dbg !2428
  %998 = load i32, i32* %B2, align 4, !dbg !2429
  %999 = load i8*, i8** %out.addr, align 8, !dbg !2430
  %add.ptr = getelementptr inbounds i8, i8* %999, i64 4, !dbg !2431
  store i32 %998, i32* %v.addr.i257, align 4
  store i8* %add.ptr, i8** %b.addr.i258, align 8
  %1000 = load i32, i32* %v.addr.i257, align 4, !dbg !2432
  %shr.i259 = lshr i32 %1000, 24, !dbg !2433
  %conv.i260 = trunc i32 %shr.i259 to i8, !dbg !2434
  %1001 = load i8*, i8** %b.addr.i258, align 8, !dbg !2435
  store i8 %conv.i260, i8* %1001, align 1, !dbg !2436
  %1002 = load i32, i32* %v.addr.i257, align 4, !dbg !2437
  %shr1.i261 = lshr i32 %1002, 16, !dbg !2438
  %conv2.i262 = trunc i32 %shr1.i261 to i8, !dbg !2439
  %1003 = load i8*, i8** %b.addr.i258, align 8, !dbg !2440
  %arrayidx3.i263 = getelementptr inbounds i8, i8* %1003, i64 1, !dbg !2440
  store i8 %conv2.i262, i8* %arrayidx3.i263, align 1, !dbg !2441
  %1004 = load i32, i32* %v.addr.i257, align 4, !dbg !2442
  %shr4.i264 = lshr i32 %1004, 8, !dbg !2443
  %conv5.i265 = trunc i32 %shr4.i264 to i8, !dbg !2444
  %1005 = load i8*, i8** %b.addr.i258, align 8, !dbg !2445
  %arrayidx6.i266 = getelementptr inbounds i8, i8* %1005, i64 2, !dbg !2445
  store i8 %conv5.i265, i8* %arrayidx6.i266, align 1, !dbg !2446
  %1006 = load i32, i32* %v.addr.i257, align 4, !dbg !2447
  %conv7.i267 = trunc i32 %1006 to i8, !dbg !2448
  %1007 = load i8*, i8** %b.addr.i258, align 8, !dbg !2449
  %arrayidx8.i268 = getelementptr inbounds i8, i8* %1007, i64 3, !dbg !2449
  store i8 %conv7.i267, i8* %arrayidx8.i268, align 1, !dbg !2450
  %1008 = load i32, i32* %B1, align 4, !dbg !2451
  %1009 = load i8*, i8** %out.addr, align 8, !dbg !2452
  %add.ptr240 = getelementptr inbounds i8, i8* %1009, i64 8, !dbg !2453
  store i32 %1008, i32* %v.addr.i245, align 4
  store i8* %add.ptr240, i8** %b.addr.i246, align 8
  %1010 = load i32, i32* %v.addr.i245, align 4, !dbg !2454
  %shr.i247 = lshr i32 %1010, 24, !dbg !2455
  %conv.i248 = trunc i32 %shr.i247 to i8, !dbg !2456
  %1011 = load i8*, i8** %b.addr.i246, align 8, !dbg !2457
  store i8 %conv.i248, i8* %1011, align 1, !dbg !2458
  %1012 = load i32, i32* %v.addr.i245, align 4, !dbg !2459
  %shr1.i249 = lshr i32 %1012, 16, !dbg !2460
  %conv2.i250 = trunc i32 %shr1.i249 to i8, !dbg !2461
  %1013 = load i8*, i8** %b.addr.i246, align 8, !dbg !2462
  %arrayidx3.i251 = getelementptr inbounds i8, i8* %1013, i64 1, !dbg !2462
  store i8 %conv2.i250, i8* %arrayidx3.i251, align 1, !dbg !2463
  %1014 = load i32, i32* %v.addr.i245, align 4, !dbg !2464
  %shr4.i252 = lshr i32 %1014, 8, !dbg !2465
  %conv5.i253 = trunc i32 %shr4.i252 to i8, !dbg !2466
  %1015 = load i8*, i8** %b.addr.i246, align 8, !dbg !2467
  %arrayidx6.i254 = getelementptr inbounds i8, i8* %1015, i64 2, !dbg !2467
  store i8 %conv5.i253, i8* %arrayidx6.i254, align 1, !dbg !2468
  %1016 = load i32, i32* %v.addr.i245, align 4, !dbg !2469
  %conv7.i255 = trunc i32 %1016 to i8, !dbg !2470
  %1017 = load i8*, i8** %b.addr.i246, align 8, !dbg !2471
  %arrayidx8.i256 = getelementptr inbounds i8, i8* %1017, i64 3, !dbg !2471
  store i8 %conv7.i255, i8* %arrayidx8.i256, align 1, !dbg !2472
  %1018 = load i32, i32* %B0, align 4, !dbg !2473
  %1019 = load i8*, i8** %out.addr, align 8, !dbg !2474
  %add.ptr241 = getelementptr inbounds i8, i8* %1019, i64 12, !dbg !2475
  store i32 %1018, i32* %v.addr.i, align 4
  store i8* %add.ptr241, i8** %b.addr.i242, align 8
  %1020 = load i32, i32* %v.addr.i, align 4, !dbg !2476
  %shr.i = lshr i32 %1020, 24, !dbg !2477
  %conv.i243 = trunc i32 %shr.i to i8, !dbg !2478
  %1021 = load i8*, i8** %b.addr.i242, align 8, !dbg !2479
  store i8 %conv.i243, i8* %1021, align 1, !dbg !2480
  %1022 = load i32, i32* %v.addr.i, align 4, !dbg !2481
  %shr1.i = lshr i32 %1022, 16, !dbg !2482
  %conv2.i = trunc i32 %shr1.i to i8, !dbg !2483
  %1023 = load i8*, i8** %b.addr.i242, align 8, !dbg !2484
  %arrayidx3.i244 = getelementptr inbounds i8, i8* %1023, i64 1, !dbg !2484
  store i8 %conv2.i, i8* %arrayidx3.i244, align 1, !dbg !2485
  %1024 = load i32, i32* %v.addr.i, align 4, !dbg !2486
  %shr4.i = lshr i32 %1024, 8, !dbg !2487
  %conv5.i = trunc i32 %shr4.i to i8, !dbg !2488
  %1025 = load i8*, i8** %b.addr.i242, align 8, !dbg !2489
  %arrayidx6.i = getelementptr inbounds i8, i8* %1025, i64 2, !dbg !2489
  store i8 %conv5.i, i8* %arrayidx6.i, align 1, !dbg !2490
  %1026 = load i32, i32* %v.addr.i, align 4, !dbg !2491
  %conv7.i = trunc i32 %1026 to i8, !dbg !2492
  %1027 = load i8*, i8** %b.addr.i242, align 8, !dbg !2493
  %arrayidx8.i = getelementptr inbounds i8, i8* %1027, i64 3, !dbg !2493
  store i8 %conv7.i, i8* %arrayidx8.i, align 1, !dbg !2494
  ret void, !dbg !2495
}

; Function Attrs: nounwind willreturn
declare void @llvm.var.annotation(i8*, i8*, i8*, i32) #2

; Function Attrs: noinline nounwind optnone uwtable
define dso_local void @SM4_decrypt(i8* %in, i8* %out, %struct.SM4_KEY_st* %ks) #3 !dbg !2496 {
entry:
  %b.addr.i1796 = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i1796, metadata !53, metadata !DIExpression()), !dbg !2497
  %n.addr.i1797 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %n.addr.i1797, metadata !59, metadata !DIExpression()), !dbg !2499
  %b.addr.i1769 = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i1769, metadata !53, metadata !DIExpression()), !dbg !2500
  %n.addr.i1770 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %n.addr.i1770, metadata !59, metadata !DIExpression()), !dbg !2502
  %b.addr.i1742 = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i1742, metadata !53, metadata !DIExpression()), !dbg !2503
  %n.addr.i1743 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %n.addr.i1743, metadata !59, metadata !DIExpression()), !dbg !2505
  %a.addr.i43.i1678 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i1678, metadata !67, metadata !DIExpression()), !dbg !2506
  %n.addr.i44.i1679 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i1679, metadata !76, metadata !DIExpression()), !dbg !2510
  %a.addr.i35.i1680 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i1680, metadata !67, metadata !DIExpression()), !dbg !2511
  %n.addr.i36.i1681 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i1681, metadata !76, metadata !DIExpression()), !dbg !2513
  %a.addr.i27.i1682 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i1682, metadata !67, metadata !DIExpression()), !dbg !2514
  %n.addr.i28.i1683 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i1683, metadata !76, metadata !DIExpression()), !dbg !2516
  %a.addr.i.i1684 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1684, metadata !67, metadata !DIExpression()), !dbg !2517
  %n.addr.i.i1685 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1685, metadata !76, metadata !DIExpression()), !dbg !2519
  %X.addr.i1686 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1686, metadata !336, metadata !DIExpression()), !dbg !2520
  %t.i1687 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i1687, metadata !338, metadata !DIExpression()), !dbg !2521
  %a.addr.i43.i1614 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i1614, metadata !67, metadata !DIExpression()), !dbg !2522
  %n.addr.i44.i1615 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i1615, metadata !76, metadata !DIExpression()), !dbg !2525
  %a.addr.i35.i1616 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i1616, metadata !67, metadata !DIExpression()), !dbg !2526
  %n.addr.i36.i1617 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i1617, metadata !76, metadata !DIExpression()), !dbg !2528
  %a.addr.i27.i1618 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i1618, metadata !67, metadata !DIExpression()), !dbg !2529
  %n.addr.i28.i1619 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i1619, metadata !76, metadata !DIExpression()), !dbg !2531
  %a.addr.i.i1620 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1620, metadata !67, metadata !DIExpression()), !dbg !2532
  %n.addr.i.i1621 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1621, metadata !76, metadata !DIExpression()), !dbg !2534
  %X.addr.i1622 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1622, metadata !336, metadata !DIExpression()), !dbg !2535
  %t.i1623 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i1623, metadata !338, metadata !DIExpression()), !dbg !2536
  %a.addr.i43.i1550 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i1550, metadata !67, metadata !DIExpression()), !dbg !2537
  %n.addr.i44.i1551 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i1551, metadata !76, metadata !DIExpression()), !dbg !2540
  %a.addr.i35.i1552 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i1552, metadata !67, metadata !DIExpression()), !dbg !2541
  %n.addr.i36.i1553 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i1553, metadata !76, metadata !DIExpression()), !dbg !2543
  %a.addr.i27.i1554 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i1554, metadata !67, metadata !DIExpression()), !dbg !2544
  %n.addr.i28.i1555 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i1555, metadata !76, metadata !DIExpression()), !dbg !2546
  %a.addr.i.i1556 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1556, metadata !67, metadata !DIExpression()), !dbg !2547
  %n.addr.i.i1557 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1557, metadata !76, metadata !DIExpression()), !dbg !2549
  %X.addr.i1558 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1558, metadata !336, metadata !DIExpression()), !dbg !2550
  %t.i1559 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i1559, metadata !338, metadata !DIExpression()), !dbg !2551
  %a.addr.i43.i1486 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i1486, metadata !67, metadata !DIExpression()), !dbg !2552
  %n.addr.i44.i1487 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i1487, metadata !76, metadata !DIExpression()), !dbg !2555
  %a.addr.i35.i1488 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i1488, metadata !67, metadata !DIExpression()), !dbg !2556
  %n.addr.i36.i1489 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i1489, metadata !76, metadata !DIExpression()), !dbg !2558
  %a.addr.i27.i1490 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i1490, metadata !67, metadata !DIExpression()), !dbg !2559
  %n.addr.i28.i1491 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i1491, metadata !76, metadata !DIExpression()), !dbg !2561
  %a.addr.i.i1492 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1492, metadata !67, metadata !DIExpression()), !dbg !2562
  %n.addr.i.i1493 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1493, metadata !76, metadata !DIExpression()), !dbg !2564
  %X.addr.i1494 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1494, metadata !336, metadata !DIExpression()), !dbg !2565
  %t.i1495 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i1495, metadata !338, metadata !DIExpression()), !dbg !2566
  %a.addr.i24.i1443 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1443, metadata !67, metadata !DIExpression()), !dbg !2567
  %n.addr.i25.i1444 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1444, metadata !76, metadata !DIExpression()), !dbg !2571
  %a.addr.i16.i1445 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1445, metadata !67, metadata !DIExpression()), !dbg !2572
  %n.addr.i17.i1446 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1446, metadata !76, metadata !DIExpression()), !dbg !2574
  %a.addr.i.i1447 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1447, metadata !67, metadata !DIExpression()), !dbg !2575
  %n.addr.i.i1448 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1448, metadata !76, metadata !DIExpression()), !dbg !2577
  %X.addr.i1449 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1449, metadata !397, metadata !DIExpression()), !dbg !2578
  %a.addr.i24.i1400 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1400, metadata !67, metadata !DIExpression()), !dbg !2579
  %n.addr.i25.i1401 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1401, metadata !76, metadata !DIExpression()), !dbg !2582
  %a.addr.i16.i1402 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1402, metadata !67, metadata !DIExpression()), !dbg !2583
  %n.addr.i17.i1403 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1403, metadata !76, metadata !DIExpression()), !dbg !2585
  %a.addr.i.i1404 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1404, metadata !67, metadata !DIExpression()), !dbg !2586
  %n.addr.i.i1405 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1405, metadata !76, metadata !DIExpression()), !dbg !2588
  %X.addr.i1406 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1406, metadata !397, metadata !DIExpression()), !dbg !2589
  %a.addr.i24.i1357 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1357, metadata !67, metadata !DIExpression()), !dbg !2590
  %n.addr.i25.i1358 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1358, metadata !76, metadata !DIExpression()), !dbg !2593
  %a.addr.i16.i1359 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1359, metadata !67, metadata !DIExpression()), !dbg !2594
  %n.addr.i17.i1360 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1360, metadata !76, metadata !DIExpression()), !dbg !2596
  %a.addr.i.i1361 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1361, metadata !67, metadata !DIExpression()), !dbg !2597
  %n.addr.i.i1362 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1362, metadata !76, metadata !DIExpression()), !dbg !2599
  %X.addr.i1363 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1363, metadata !397, metadata !DIExpression()), !dbg !2600
  %a.addr.i24.i1314 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1314, metadata !67, metadata !DIExpression()), !dbg !2601
  %n.addr.i25.i1315 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1315, metadata !76, metadata !DIExpression()), !dbg !2604
  %a.addr.i16.i1316 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1316, metadata !67, metadata !DIExpression()), !dbg !2605
  %n.addr.i17.i1317 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1317, metadata !76, metadata !DIExpression()), !dbg !2607
  %a.addr.i.i1318 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1318, metadata !67, metadata !DIExpression()), !dbg !2608
  %n.addr.i.i1319 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1319, metadata !76, metadata !DIExpression()), !dbg !2610
  %X.addr.i1320 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1320, metadata !397, metadata !DIExpression()), !dbg !2611
  %a.addr.i24.i1271 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1271, metadata !67, metadata !DIExpression()), !dbg !2612
  %n.addr.i25.i1272 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1272, metadata !76, metadata !DIExpression()), !dbg !2616
  %a.addr.i16.i1273 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1273, metadata !67, metadata !DIExpression()), !dbg !2617
  %n.addr.i17.i1274 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1274, metadata !76, metadata !DIExpression()), !dbg !2619
  %a.addr.i.i1275 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1275, metadata !67, metadata !DIExpression()), !dbg !2620
  %n.addr.i.i1276 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1276, metadata !76, metadata !DIExpression()), !dbg !2622
  %X.addr.i1277 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1277, metadata !397, metadata !DIExpression()), !dbg !2623
  %a.addr.i24.i1228 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1228, metadata !67, metadata !DIExpression()), !dbg !2624
  %n.addr.i25.i1229 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1229, metadata !76, metadata !DIExpression()), !dbg !2627
  %a.addr.i16.i1230 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1230, metadata !67, metadata !DIExpression()), !dbg !2628
  %n.addr.i17.i1231 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1231, metadata !76, metadata !DIExpression()), !dbg !2630
  %a.addr.i.i1232 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1232, metadata !67, metadata !DIExpression()), !dbg !2631
  %n.addr.i.i1233 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1233, metadata !76, metadata !DIExpression()), !dbg !2633
  %X.addr.i1234 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1234, metadata !397, metadata !DIExpression()), !dbg !2634
  %a.addr.i24.i1185 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1185, metadata !67, metadata !DIExpression()), !dbg !2635
  %n.addr.i25.i1186 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1186, metadata !76, metadata !DIExpression()), !dbg !2638
  %a.addr.i16.i1187 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1187, metadata !67, metadata !DIExpression()), !dbg !2639
  %n.addr.i17.i1188 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1188, metadata !76, metadata !DIExpression()), !dbg !2641
  %a.addr.i.i1189 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1189, metadata !67, metadata !DIExpression()), !dbg !2642
  %n.addr.i.i1190 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1190, metadata !76, metadata !DIExpression()), !dbg !2644
  %X.addr.i1191 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1191, metadata !397, metadata !DIExpression()), !dbg !2645
  %a.addr.i24.i1142 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1142, metadata !67, metadata !DIExpression()), !dbg !2646
  %n.addr.i25.i1143 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1143, metadata !76, metadata !DIExpression()), !dbg !2649
  %a.addr.i16.i1144 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1144, metadata !67, metadata !DIExpression()), !dbg !2650
  %n.addr.i17.i1145 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1145, metadata !76, metadata !DIExpression()), !dbg !2652
  %a.addr.i.i1146 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1146, metadata !67, metadata !DIExpression()), !dbg !2653
  %n.addr.i.i1147 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1147, metadata !76, metadata !DIExpression()), !dbg !2655
  %X.addr.i1148 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1148, metadata !397, metadata !DIExpression()), !dbg !2656
  %a.addr.i24.i1099 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1099, metadata !67, metadata !DIExpression()), !dbg !2657
  %n.addr.i25.i1100 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1100, metadata !76, metadata !DIExpression()), !dbg !2661
  %a.addr.i16.i1101 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1101, metadata !67, metadata !DIExpression()), !dbg !2662
  %n.addr.i17.i1102 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1102, metadata !76, metadata !DIExpression()), !dbg !2664
  %a.addr.i.i1103 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1103, metadata !67, metadata !DIExpression()), !dbg !2665
  %n.addr.i.i1104 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1104, metadata !76, metadata !DIExpression()), !dbg !2667
  %X.addr.i1105 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1105, metadata !397, metadata !DIExpression()), !dbg !2668
  %a.addr.i24.i1056 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1056, metadata !67, metadata !DIExpression()), !dbg !2669
  %n.addr.i25.i1057 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1057, metadata !76, metadata !DIExpression()), !dbg !2672
  %a.addr.i16.i1058 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1058, metadata !67, metadata !DIExpression()), !dbg !2673
  %n.addr.i17.i1059 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1059, metadata !76, metadata !DIExpression()), !dbg !2675
  %a.addr.i.i1060 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1060, metadata !67, metadata !DIExpression()), !dbg !2676
  %n.addr.i.i1061 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1061, metadata !76, metadata !DIExpression()), !dbg !2678
  %X.addr.i1062 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1062, metadata !397, metadata !DIExpression()), !dbg !2679
  %a.addr.i24.i1013 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1013, metadata !67, metadata !DIExpression()), !dbg !2680
  %n.addr.i25.i1014 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1014, metadata !76, metadata !DIExpression()), !dbg !2683
  %a.addr.i16.i1015 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1015, metadata !67, metadata !DIExpression()), !dbg !2684
  %n.addr.i17.i1016 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1016, metadata !76, metadata !DIExpression()), !dbg !2686
  %a.addr.i.i1017 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1017, metadata !67, metadata !DIExpression()), !dbg !2687
  %n.addr.i.i1018 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1018, metadata !76, metadata !DIExpression()), !dbg !2689
  %X.addr.i1019 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1019, metadata !397, metadata !DIExpression()), !dbg !2690
  %a.addr.i24.i970 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i970, metadata !67, metadata !DIExpression()), !dbg !2691
  %n.addr.i25.i971 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i971, metadata !76, metadata !DIExpression()), !dbg !2694
  %a.addr.i16.i972 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i972, metadata !67, metadata !DIExpression()), !dbg !2695
  %n.addr.i17.i973 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i973, metadata !76, metadata !DIExpression()), !dbg !2697
  %a.addr.i.i974 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i974, metadata !67, metadata !DIExpression()), !dbg !2698
  %n.addr.i.i975 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i975, metadata !76, metadata !DIExpression()), !dbg !2700
  %X.addr.i976 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i976, metadata !397, metadata !DIExpression()), !dbg !2701
  %a.addr.i24.i927 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i927, metadata !67, metadata !DIExpression()), !dbg !2702
  %n.addr.i25.i928 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i928, metadata !76, metadata !DIExpression()), !dbg !2706
  %a.addr.i16.i929 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i929, metadata !67, metadata !DIExpression()), !dbg !2707
  %n.addr.i17.i930 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i930, metadata !76, metadata !DIExpression()), !dbg !2709
  %a.addr.i.i931 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i931, metadata !67, metadata !DIExpression()), !dbg !2710
  %n.addr.i.i932 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i932, metadata !76, metadata !DIExpression()), !dbg !2712
  %X.addr.i933 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i933, metadata !397, metadata !DIExpression()), !dbg !2713
  %a.addr.i24.i884 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i884, metadata !67, metadata !DIExpression()), !dbg !2714
  %n.addr.i25.i885 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i885, metadata !76, metadata !DIExpression()), !dbg !2717
  %a.addr.i16.i886 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i886, metadata !67, metadata !DIExpression()), !dbg !2718
  %n.addr.i17.i887 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i887, metadata !76, metadata !DIExpression()), !dbg !2720
  %a.addr.i.i888 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i888, metadata !67, metadata !DIExpression()), !dbg !2721
  %n.addr.i.i889 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i889, metadata !76, metadata !DIExpression()), !dbg !2723
  %X.addr.i890 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i890, metadata !397, metadata !DIExpression()), !dbg !2724
  %a.addr.i24.i841 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i841, metadata !67, metadata !DIExpression()), !dbg !2725
  %n.addr.i25.i842 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i842, metadata !76, metadata !DIExpression()), !dbg !2728
  %a.addr.i16.i843 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i843, metadata !67, metadata !DIExpression()), !dbg !2729
  %n.addr.i17.i844 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i844, metadata !76, metadata !DIExpression()), !dbg !2731
  %a.addr.i.i845 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i845, metadata !67, metadata !DIExpression()), !dbg !2732
  %n.addr.i.i846 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i846, metadata !76, metadata !DIExpression()), !dbg !2734
  %X.addr.i847 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i847, metadata !397, metadata !DIExpression()), !dbg !2735
  %a.addr.i24.i798 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i798, metadata !67, metadata !DIExpression()), !dbg !2736
  %n.addr.i25.i799 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i799, metadata !76, metadata !DIExpression()), !dbg !2739
  %a.addr.i16.i800 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i800, metadata !67, metadata !DIExpression()), !dbg !2740
  %n.addr.i17.i801 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i801, metadata !76, metadata !DIExpression()), !dbg !2742
  %a.addr.i.i802 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i802, metadata !67, metadata !DIExpression()), !dbg !2743
  %n.addr.i.i803 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i803, metadata !76, metadata !DIExpression()), !dbg !2745
  %X.addr.i804 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i804, metadata !397, metadata !DIExpression()), !dbg !2746
  %a.addr.i24.i755 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i755, metadata !67, metadata !DIExpression()), !dbg !2747
  %n.addr.i25.i756 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i756, metadata !76, metadata !DIExpression()), !dbg !2751
  %a.addr.i16.i757 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i757, metadata !67, metadata !DIExpression()), !dbg !2752
  %n.addr.i17.i758 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i758, metadata !76, metadata !DIExpression()), !dbg !2754
  %a.addr.i.i759 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i759, metadata !67, metadata !DIExpression()), !dbg !2755
  %n.addr.i.i760 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i760, metadata !76, metadata !DIExpression()), !dbg !2757
  %X.addr.i761 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i761, metadata !397, metadata !DIExpression()), !dbg !2758
  %a.addr.i24.i712 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i712, metadata !67, metadata !DIExpression()), !dbg !2759
  %n.addr.i25.i713 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i713, metadata !76, metadata !DIExpression()), !dbg !2762
  %a.addr.i16.i714 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i714, metadata !67, metadata !DIExpression()), !dbg !2763
  %n.addr.i17.i715 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i715, metadata !76, metadata !DIExpression()), !dbg !2765
  %a.addr.i.i716 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i716, metadata !67, metadata !DIExpression()), !dbg !2766
  %n.addr.i.i717 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i717, metadata !76, metadata !DIExpression()), !dbg !2768
  %X.addr.i718 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i718, metadata !397, metadata !DIExpression()), !dbg !2769
  %a.addr.i24.i669 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i669, metadata !67, metadata !DIExpression()), !dbg !2770
  %n.addr.i25.i670 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i670, metadata !76, metadata !DIExpression()), !dbg !2773
  %a.addr.i16.i671 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i671, metadata !67, metadata !DIExpression()), !dbg !2774
  %n.addr.i17.i672 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i672, metadata !76, metadata !DIExpression()), !dbg !2776
  %a.addr.i.i673 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i673, metadata !67, metadata !DIExpression()), !dbg !2777
  %n.addr.i.i674 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i674, metadata !76, metadata !DIExpression()), !dbg !2779
  %X.addr.i675 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i675, metadata !397, metadata !DIExpression()), !dbg !2780
  %a.addr.i24.i626 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i626, metadata !67, metadata !DIExpression()), !dbg !2781
  %n.addr.i25.i627 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i627, metadata !76, metadata !DIExpression()), !dbg !2784
  %a.addr.i16.i628 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i628, metadata !67, metadata !DIExpression()), !dbg !2785
  %n.addr.i17.i629 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i629, metadata !76, metadata !DIExpression()), !dbg !2787
  %a.addr.i.i630 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i630, metadata !67, metadata !DIExpression()), !dbg !2788
  %n.addr.i.i631 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i631, metadata !76, metadata !DIExpression()), !dbg !2790
  %X.addr.i632 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i632, metadata !397, metadata !DIExpression()), !dbg !2791
  %a.addr.i24.i583 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i583, metadata !67, metadata !DIExpression()), !dbg !2792
  %n.addr.i25.i584 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i584, metadata !76, metadata !DIExpression()), !dbg !2796
  %a.addr.i16.i585 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i585, metadata !67, metadata !DIExpression()), !dbg !2797
  %n.addr.i17.i586 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i586, metadata !76, metadata !DIExpression()), !dbg !2799
  %a.addr.i.i587 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i587, metadata !67, metadata !DIExpression()), !dbg !2800
  %n.addr.i.i588 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i588, metadata !76, metadata !DIExpression()), !dbg !2802
  %X.addr.i589 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i589, metadata !397, metadata !DIExpression()), !dbg !2803
  %a.addr.i24.i540 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i540, metadata !67, metadata !DIExpression()), !dbg !2804
  %n.addr.i25.i541 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i541, metadata !76, metadata !DIExpression()), !dbg !2807
  %a.addr.i16.i542 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i542, metadata !67, metadata !DIExpression()), !dbg !2808
  %n.addr.i17.i543 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i543, metadata !76, metadata !DIExpression()), !dbg !2810
  %a.addr.i.i544 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i544, metadata !67, metadata !DIExpression()), !dbg !2811
  %n.addr.i.i545 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i545, metadata !76, metadata !DIExpression()), !dbg !2813
  %X.addr.i546 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i546, metadata !397, metadata !DIExpression()), !dbg !2814
  %a.addr.i24.i497 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i497, metadata !67, metadata !DIExpression()), !dbg !2815
  %n.addr.i25.i498 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i498, metadata !76, metadata !DIExpression()), !dbg !2818
  %a.addr.i16.i499 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i499, metadata !67, metadata !DIExpression()), !dbg !2819
  %n.addr.i17.i500 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i500, metadata !76, metadata !DIExpression()), !dbg !2821
  %a.addr.i.i501 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i501, metadata !67, metadata !DIExpression()), !dbg !2822
  %n.addr.i.i502 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i502, metadata !76, metadata !DIExpression()), !dbg !2824
  %X.addr.i503 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i503, metadata !397, metadata !DIExpression()), !dbg !2825
  %a.addr.i24.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i, metadata !67, metadata !DIExpression()), !dbg !2826
  %n.addr.i25.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i, metadata !76, metadata !DIExpression()), !dbg !2829
  %a.addr.i16.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i, metadata !67, metadata !DIExpression()), !dbg !2830
  %n.addr.i17.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i, metadata !76, metadata !DIExpression()), !dbg !2832
  %a.addr.i.i479 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i479, metadata !67, metadata !DIExpression()), !dbg !2833
  %n.addr.i.i480 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i480, metadata !76, metadata !DIExpression()), !dbg !2835
  %X.addr.i481 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i481, metadata !397, metadata !DIExpression()), !dbg !2836
  %a.addr.i43.i415 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i415, metadata !67, metadata !DIExpression()), !dbg !2837
  %n.addr.i44.i416 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i416, metadata !76, metadata !DIExpression()), !dbg !2841
  %a.addr.i35.i417 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i417, metadata !67, metadata !DIExpression()), !dbg !2842
  %n.addr.i36.i418 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i418, metadata !76, metadata !DIExpression()), !dbg !2844
  %a.addr.i27.i419 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i419, metadata !67, metadata !DIExpression()), !dbg !2845
  %n.addr.i28.i420 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i420, metadata !76, metadata !DIExpression()), !dbg !2847
  %a.addr.i.i421 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i421, metadata !67, metadata !DIExpression()), !dbg !2848
  %n.addr.i.i422 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i422, metadata !76, metadata !DIExpression()), !dbg !2850
  %X.addr.i423 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i423, metadata !336, metadata !DIExpression()), !dbg !2851
  %t.i424 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i424, metadata !338, metadata !DIExpression()), !dbg !2852
  %a.addr.i43.i351 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i351, metadata !67, metadata !DIExpression()), !dbg !2853
  %n.addr.i44.i352 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i352, metadata !76, metadata !DIExpression()), !dbg !2856
  %a.addr.i35.i353 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i353, metadata !67, metadata !DIExpression()), !dbg !2857
  %n.addr.i36.i354 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i354, metadata !76, metadata !DIExpression()), !dbg !2859
  %a.addr.i27.i355 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i355, metadata !67, metadata !DIExpression()), !dbg !2860
  %n.addr.i28.i356 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i356, metadata !76, metadata !DIExpression()), !dbg !2862
  %a.addr.i.i357 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i357, metadata !67, metadata !DIExpression()), !dbg !2863
  %n.addr.i.i358 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i358, metadata !76, metadata !DIExpression()), !dbg !2865
  %X.addr.i359 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i359, metadata !336, metadata !DIExpression()), !dbg !2866
  %t.i360 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i360, metadata !338, metadata !DIExpression()), !dbg !2867
  %a.addr.i43.i287 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i287, metadata !67, metadata !DIExpression()), !dbg !2868
  %n.addr.i44.i288 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i288, metadata !76, metadata !DIExpression()), !dbg !2871
  %a.addr.i35.i289 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i289, metadata !67, metadata !DIExpression()), !dbg !2872
  %n.addr.i36.i290 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i290, metadata !76, metadata !DIExpression()), !dbg !2874
  %a.addr.i27.i291 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i291, metadata !67, metadata !DIExpression()), !dbg !2875
  %n.addr.i28.i292 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i292, metadata !76, metadata !DIExpression()), !dbg !2877
  %a.addr.i.i293 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i293, metadata !67, metadata !DIExpression()), !dbg !2878
  %n.addr.i.i294 = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i294, metadata !76, metadata !DIExpression()), !dbg !2880
  %X.addr.i295 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i295, metadata !336, metadata !DIExpression()), !dbg !2881
  %t.i296 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i296, metadata !338, metadata !DIExpression()), !dbg !2882
  %a.addr.i43.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i, metadata !67, metadata !DIExpression()), !dbg !2883
  %n.addr.i44.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i, metadata !76, metadata !DIExpression()), !dbg !2886
  %a.addr.i35.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i, metadata !67, metadata !DIExpression()), !dbg !2887
  %n.addr.i36.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i, metadata !76, metadata !DIExpression()), !dbg !2889
  %a.addr.i27.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i, metadata !67, metadata !DIExpression()), !dbg !2890
  %n.addr.i28.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i, metadata !76, metadata !DIExpression()), !dbg !2892
  %a.addr.i.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i, metadata !67, metadata !DIExpression()), !dbg !2893
  %n.addr.i.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i, metadata !76, metadata !DIExpression()), !dbg !2895
  %X.addr.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i, metadata !336, metadata !DIExpression()), !dbg !2896
  %t.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i, metadata !338, metadata !DIExpression()), !dbg !2897
  %v.addr.i268 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %v.addr.i268, metadata !718, metadata !DIExpression()), !dbg !2898
  %b.addr.i269 = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i269, metadata !724, metadata !DIExpression()), !dbg !2900
  %v.addr.i256 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %v.addr.i256, metadata !718, metadata !DIExpression()), !dbg !2901
  %b.addr.i257 = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i257, metadata !724, metadata !DIExpression()), !dbg !2903
  %v.addr.i244 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %v.addr.i244, metadata !718, metadata !DIExpression()), !dbg !2904
  %b.addr.i245 = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i245, metadata !724, metadata !DIExpression()), !dbg !2906
  %v.addr.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %v.addr.i, metadata !718, metadata !DIExpression()), !dbg !2907
  %b.addr.i241 = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i241, metadata !724, metadata !DIExpression()), !dbg !2909
  %b.addr.i = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i, metadata !53, metadata !DIExpression()), !dbg !2910
  %n.addr.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %n.addr.i, metadata !59, metadata !DIExpression()), !dbg !2912
  %in.addr = alloca i8*, align 8
  %out.addr = alloca i8*, align 8
  %ks.addr = alloca %struct.SM4_KEY_st*, align 8
  %B0 = alloca i32, align 4
  %B1 = alloca i32, align 4
  %B2 = alloca i32, align 4
  %B3 = alloca i32, align 4
  store i8* %in, i8** %in.addr, align 8
  call void @llvm.dbg.declare(metadata i8** %in.addr, metadata !2913, metadata !DIExpression()), !dbg !2914
  store i8* %out, i8** %out.addr, align 8
  call void @llvm.dbg.declare(metadata i8** %out.addr, metadata !2915, metadata !DIExpression()), !dbg !2916
  store %struct.SM4_KEY_st* %ks, %struct.SM4_KEY_st** %ks.addr, align 8
  call void @llvm.dbg.declare(metadata %struct.SM4_KEY_st** %ks.addr, metadata !2917, metadata !DIExpression()), !dbg !2918
  call void @llvm.dbg.declare(metadata i32* %B0, metadata !2919, metadata !DIExpression()), !dbg !2920
  %0 = load i8*, i8** %in.addr, align 8, !dbg !2921
  store i8* %0, i8** %b.addr.i, align 8
  store i32 0, i32* %n.addr.i, align 4
  %1 = load i8*, i8** %b.addr.i, align 8, !dbg !2922
  %2 = load i32, i32* %n.addr.i, align 4, !dbg !2923
  %mul.i = mul i32 4, %2, !dbg !2924
  %idxprom.i = zext i32 %mul.i to i64, !dbg !2922
  %arrayidx.i = getelementptr inbounds i8, i8* %1, i64 %idxprom.i, !dbg !2922
  %3 = load i8, i8* %arrayidx.i, align 1, !dbg !2922
  %conv.i = zext i8 %3 to i32, !dbg !2925
  %shl.i = shl i32 %conv.i, 24, !dbg !2926
  %4 = load i8*, i8** %b.addr.i, align 8, !dbg !2927
  %5 = load i32, i32* %n.addr.i, align 4, !dbg !2928
  %mul1.i = mul i32 4, %5, !dbg !2929
  %add.i = add i32 %mul1.i, 1, !dbg !2930
  %idxprom2.i = zext i32 %add.i to i64, !dbg !2927
  %arrayidx3.i = getelementptr inbounds i8, i8* %4, i64 %idxprom2.i, !dbg !2927
  %6 = load i8, i8* %arrayidx3.i, align 1, !dbg !2927
  %conv4.i = zext i8 %6 to i32, !dbg !2931
  %shl5.i = shl i32 %conv4.i, 16, !dbg !2932
  %or.i = or i32 %shl.i, %shl5.i, !dbg !2933
  %7 = load i8*, i8** %b.addr.i, align 8, !dbg !2934
  %8 = load i32, i32* %n.addr.i, align 4, !dbg !2935
  %mul6.i = mul i32 4, %8, !dbg !2936
  %add7.i = add i32 %mul6.i, 2, !dbg !2937
  %idxprom8.i = zext i32 %add7.i to i64, !dbg !2934
  %arrayidx9.i = getelementptr inbounds i8, i8* %7, i64 %idxprom8.i, !dbg !2934
  %9 = load i8, i8* %arrayidx9.i, align 1, !dbg !2934
  %conv10.i = zext i8 %9 to i32, !dbg !2938
  %shl11.i = shl i32 %conv10.i, 8, !dbg !2939
  %or12.i = or i32 %or.i, %shl11.i, !dbg !2940
  %10 = load i8*, i8** %b.addr.i, align 8, !dbg !2941
  %11 = load i32, i32* %n.addr.i, align 4, !dbg !2942
  %mul13.i = mul i32 4, %11, !dbg !2943
  %add14.i = add i32 %mul13.i, 3, !dbg !2944
  %idxprom15.i = zext i32 %add14.i to i64, !dbg !2941
  %arrayidx16.i = getelementptr inbounds i8, i8* %10, i64 %idxprom15.i, !dbg !2941
  %12 = load i8, i8* %arrayidx16.i, align 1, !dbg !2941
  %conv17.i = zext i8 %12 to i32, !dbg !2945
  %or18.i = or i32 %or12.i, %conv17.i, !dbg !2946
  store i32 %or18.i, i32* %B0, align 4, !dbg !2920
  call void @llvm.dbg.declare(metadata i32* %B1, metadata !2947, metadata !DIExpression()), !dbg !2948
  %13 = load i8*, i8** %in.addr, align 8, !dbg !2949
  store i8* %13, i8** %b.addr.i1796, align 8
  store i32 1, i32* %n.addr.i1797, align 4
  %14 = load i8*, i8** %b.addr.i1796, align 8, !dbg !2950
  %15 = load i32, i32* %n.addr.i1797, align 4, !dbg !2951
  %mul.i1798 = mul i32 4, %15, !dbg !2952
  %idxprom.i1799 = zext i32 %mul.i1798 to i64, !dbg !2950
  %arrayidx.i1800 = getelementptr inbounds i8, i8* %14, i64 %idxprom.i1799, !dbg !2950
  %16 = load i8, i8* %arrayidx.i1800, align 1, !dbg !2950
  %conv.i1801 = zext i8 %16 to i32, !dbg !2953
  %shl.i1802 = shl i32 %conv.i1801, 24, !dbg !2954
  %17 = load i8*, i8** %b.addr.i1796, align 8, !dbg !2955
  %18 = load i32, i32* %n.addr.i1797, align 4, !dbg !2956
  %mul1.i1803 = mul i32 4, %18, !dbg !2957
  %add.i1804 = add i32 %mul1.i1803, 1, !dbg !2958
  %idxprom2.i1805 = zext i32 %add.i1804 to i64, !dbg !2955
  %arrayidx3.i1806 = getelementptr inbounds i8, i8* %17, i64 %idxprom2.i1805, !dbg !2955
  %19 = load i8, i8* %arrayidx3.i1806, align 1, !dbg !2955
  %conv4.i1807 = zext i8 %19 to i32, !dbg !2959
  %shl5.i1808 = shl i32 %conv4.i1807, 16, !dbg !2960
  %or.i1809 = or i32 %shl.i1802, %shl5.i1808, !dbg !2961
  %20 = load i8*, i8** %b.addr.i1796, align 8, !dbg !2962
  %21 = load i32, i32* %n.addr.i1797, align 4, !dbg !2963
  %mul6.i1810 = mul i32 4, %21, !dbg !2964
  %add7.i1811 = add i32 %mul6.i1810, 2, !dbg !2965
  %idxprom8.i1812 = zext i32 %add7.i1811 to i64, !dbg !2962
  %arrayidx9.i1813 = getelementptr inbounds i8, i8* %20, i64 %idxprom8.i1812, !dbg !2962
  %22 = load i8, i8* %arrayidx9.i1813, align 1, !dbg !2962
  %conv10.i1814 = zext i8 %22 to i32, !dbg !2966
  %shl11.i1815 = shl i32 %conv10.i1814, 8, !dbg !2967
  %or12.i1816 = or i32 %or.i1809, %shl11.i1815, !dbg !2968
  %23 = load i8*, i8** %b.addr.i1796, align 8, !dbg !2969
  %24 = load i32, i32* %n.addr.i1797, align 4, !dbg !2970
  %mul13.i1817 = mul i32 4, %24, !dbg !2971
  %add14.i1818 = add i32 %mul13.i1817, 3, !dbg !2972
  %idxprom15.i1819 = zext i32 %add14.i1818 to i64, !dbg !2969
  %arrayidx16.i1820 = getelementptr inbounds i8, i8* %23, i64 %idxprom15.i1819, !dbg !2969
  %25 = load i8, i8* %arrayidx16.i1820, align 1, !dbg !2969
  %conv17.i1821 = zext i8 %25 to i32, !dbg !2973
  %or18.i1822 = or i32 %or12.i1816, %conv17.i1821, !dbg !2974
  store i32 %or18.i1822, i32* %B1, align 4, !dbg !2948
  call void @llvm.dbg.declare(metadata i32* %B2, metadata !2975, metadata !DIExpression()), !dbg !2976
  %26 = load i8*, i8** %in.addr, align 8, !dbg !2977
  store i8* %26, i8** %b.addr.i1769, align 8
  store i32 2, i32* %n.addr.i1770, align 4
  %27 = load i8*, i8** %b.addr.i1769, align 8, !dbg !2978
  %28 = load i32, i32* %n.addr.i1770, align 4, !dbg !2979
  %mul.i1771 = mul i32 4, %28, !dbg !2980
  %idxprom.i1772 = zext i32 %mul.i1771 to i64, !dbg !2978
  %arrayidx.i1773 = getelementptr inbounds i8, i8* %27, i64 %idxprom.i1772, !dbg !2978
  %29 = load i8, i8* %arrayidx.i1773, align 1, !dbg !2978
  %conv.i1774 = zext i8 %29 to i32, !dbg !2981
  %shl.i1775 = shl i32 %conv.i1774, 24, !dbg !2982
  %30 = load i8*, i8** %b.addr.i1769, align 8, !dbg !2983
  %31 = load i32, i32* %n.addr.i1770, align 4, !dbg !2984
  %mul1.i1776 = mul i32 4, %31, !dbg !2985
  %add.i1777 = add i32 %mul1.i1776, 1, !dbg !2986
  %idxprom2.i1778 = zext i32 %add.i1777 to i64, !dbg !2983
  %arrayidx3.i1779 = getelementptr inbounds i8, i8* %30, i64 %idxprom2.i1778, !dbg !2983
  %32 = load i8, i8* %arrayidx3.i1779, align 1, !dbg !2983
  %conv4.i1780 = zext i8 %32 to i32, !dbg !2987
  %shl5.i1781 = shl i32 %conv4.i1780, 16, !dbg !2988
  %or.i1782 = or i32 %shl.i1775, %shl5.i1781, !dbg !2989
  %33 = load i8*, i8** %b.addr.i1769, align 8, !dbg !2990
  %34 = load i32, i32* %n.addr.i1770, align 4, !dbg !2991
  %mul6.i1783 = mul i32 4, %34, !dbg !2992
  %add7.i1784 = add i32 %mul6.i1783, 2, !dbg !2993
  %idxprom8.i1785 = zext i32 %add7.i1784 to i64, !dbg !2990
  %arrayidx9.i1786 = getelementptr inbounds i8, i8* %33, i64 %idxprom8.i1785, !dbg !2990
  %35 = load i8, i8* %arrayidx9.i1786, align 1, !dbg !2990
  %conv10.i1787 = zext i8 %35 to i32, !dbg !2994
  %shl11.i1788 = shl i32 %conv10.i1787, 8, !dbg !2995
  %or12.i1789 = or i32 %or.i1782, %shl11.i1788, !dbg !2996
  %36 = load i8*, i8** %b.addr.i1769, align 8, !dbg !2997
  %37 = load i32, i32* %n.addr.i1770, align 4, !dbg !2998
  %mul13.i1790 = mul i32 4, %37, !dbg !2999
  %add14.i1791 = add i32 %mul13.i1790, 3, !dbg !3000
  %idxprom15.i1792 = zext i32 %add14.i1791 to i64, !dbg !2997
  %arrayidx16.i1793 = getelementptr inbounds i8, i8* %36, i64 %idxprom15.i1792, !dbg !2997
  %38 = load i8, i8* %arrayidx16.i1793, align 1, !dbg !2997
  %conv17.i1794 = zext i8 %38 to i32, !dbg !3001
  %or18.i1795 = or i32 %or12.i1789, %conv17.i1794, !dbg !3002
  store i32 %or18.i1795, i32* %B2, align 4, !dbg !2976
  call void @llvm.dbg.declare(metadata i32* %B3, metadata !3003, metadata !DIExpression()), !dbg !3004
  %39 = load i8*, i8** %in.addr, align 8, !dbg !3005
  store i8* %39, i8** %b.addr.i1742, align 8
  store i32 3, i32* %n.addr.i1743, align 4
  %40 = load i8*, i8** %b.addr.i1742, align 8, !dbg !3006
  %41 = load i32, i32* %n.addr.i1743, align 4, !dbg !3007
  %mul.i1744 = mul i32 4, %41, !dbg !3008
  %idxprom.i1745 = zext i32 %mul.i1744 to i64, !dbg !3006
  %arrayidx.i1746 = getelementptr inbounds i8, i8* %40, i64 %idxprom.i1745, !dbg !3006
  %42 = load i8, i8* %arrayidx.i1746, align 1, !dbg !3006
  %conv.i1747 = zext i8 %42 to i32, !dbg !3009
  %shl.i1748 = shl i32 %conv.i1747, 24, !dbg !3010
  %43 = load i8*, i8** %b.addr.i1742, align 8, !dbg !3011
  %44 = load i32, i32* %n.addr.i1743, align 4, !dbg !3012
  %mul1.i1749 = mul i32 4, %44, !dbg !3013
  %add.i1750 = add i32 %mul1.i1749, 1, !dbg !3014
  %idxprom2.i1751 = zext i32 %add.i1750 to i64, !dbg !3011
  %arrayidx3.i1752 = getelementptr inbounds i8, i8* %43, i64 %idxprom2.i1751, !dbg !3011
  %45 = load i8, i8* %arrayidx3.i1752, align 1, !dbg !3011
  %conv4.i1753 = zext i8 %45 to i32, !dbg !3015
  %shl5.i1754 = shl i32 %conv4.i1753, 16, !dbg !3016
  %or.i1755 = or i32 %shl.i1748, %shl5.i1754, !dbg !3017
  %46 = load i8*, i8** %b.addr.i1742, align 8, !dbg !3018
  %47 = load i32, i32* %n.addr.i1743, align 4, !dbg !3019
  %mul6.i1756 = mul i32 4, %47, !dbg !3020
  %add7.i1757 = add i32 %mul6.i1756, 2, !dbg !3021
  %idxprom8.i1758 = zext i32 %add7.i1757 to i64, !dbg !3018
  %arrayidx9.i1759 = getelementptr inbounds i8, i8* %46, i64 %idxprom8.i1758, !dbg !3018
  %48 = load i8, i8* %arrayidx9.i1759, align 1, !dbg !3018
  %conv10.i1760 = zext i8 %48 to i32, !dbg !3022
  %shl11.i1761 = shl i32 %conv10.i1760, 8, !dbg !3023
  %or12.i1762 = or i32 %or.i1755, %shl11.i1761, !dbg !3024
  %49 = load i8*, i8** %b.addr.i1742, align 8, !dbg !3025
  %50 = load i32, i32* %n.addr.i1743, align 4, !dbg !3026
  %mul13.i1763 = mul i32 4, %50, !dbg !3027
  %add14.i1764 = add i32 %mul13.i1763, 3, !dbg !3028
  %idxprom15.i1765 = zext i32 %add14.i1764 to i64, !dbg !3025
  %arrayidx16.i1766 = getelementptr inbounds i8, i8* %49, i64 %idxprom15.i1765, !dbg !3025
  %51 = load i8, i8* %arrayidx16.i1766, align 1, !dbg !3025
  %conv17.i1767 = zext i8 %51 to i32, !dbg !3029
  %or18.i1768 = or i32 %or12.i1762, %conv17.i1767, !dbg !3030
  store i32 %or18.i1768, i32* %B3, align 4, !dbg !3004
  br label %do.body, !dbg !3031

do.body:                                          ; preds = %entry
  %52 = load i32, i32* %B1, align 4, !dbg !3032
  %53 = load i32, i32* %B2, align 4, !dbg !3032
  %xor = xor i32 %52, %53, !dbg !3032
  %54 = load i32, i32* %B3, align 4, !dbg !3032
  %xor4 = xor i32 %xor, %54, !dbg !3032
  %55 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3032
  %rk = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %55, i32 0, i32 0, !dbg !3032
  %arrayidx = getelementptr inbounds [32 x i32], [32 x i32]* %rk, i64 0, i64 31, !dbg !3032
  %56 = load i32, i32* %arrayidx, align 4, !dbg !3032
  %xor5 = xor i32 %xor4, %56, !dbg !3032
  store i32 %xor5, i32* %X.addr.i1686, align 4
  store i32 0, i32* %t.i1687, align 4, !dbg !2521
  %57 = load i32, i32* %X.addr.i1686, align 4, !dbg !3033
  %shr.i1688 = lshr i32 %57, 24, !dbg !3034
  %conv.i1689 = trunc i32 %shr.i1688 to i8, !dbg !3035
  %idxprom.i1690 = zext i8 %conv.i1689 to i64, !dbg !3036
  %arrayidx.i1691 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom.i1690, !dbg !3036
  %58 = load i8, i8* %arrayidx.i1691, align 1, !dbg !3036
  %conv1.i1692 = zext i8 %58 to i32, !dbg !3037
  %shl.i1693 = shl i32 %conv1.i1692, 24, !dbg !3038
  %59 = load i32, i32* %t.i1687, align 4, !dbg !3039
  %or.i1694 = or i32 %59, %shl.i1693, !dbg !3039
  store i32 %or.i1694, i32* %t.i1687, align 4, !dbg !3039
  %60 = load i32, i32* %X.addr.i1686, align 4, !dbg !3040
  %shr2.i1695 = lshr i32 %60, 16, !dbg !3041
  %conv3.i1696 = trunc i32 %shr2.i1695 to i8, !dbg !3042
  %idxprom4.i1697 = zext i8 %conv3.i1696 to i64, !dbg !3043
  %arrayidx5.i1698 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom4.i1697, !dbg !3043
  %61 = load i8, i8* %arrayidx5.i1698, align 1, !dbg !3043
  %conv6.i1699 = zext i8 %61 to i32, !dbg !3044
  %shl7.i1700 = shl i32 %conv6.i1699, 16, !dbg !3045
  %62 = load i32, i32* %t.i1687, align 4, !dbg !3046
  %or8.i1701 = or i32 %62, %shl7.i1700, !dbg !3046
  store i32 %or8.i1701, i32* %t.i1687, align 4, !dbg !3046
  %63 = load i32, i32* %X.addr.i1686, align 4, !dbg !3047
  %shr9.i1702 = lshr i32 %63, 8, !dbg !3048
  %conv10.i1703 = trunc i32 %shr9.i1702 to i8, !dbg !3049
  %idxprom11.i1704 = zext i8 %conv10.i1703 to i64, !dbg !3050
  %arrayidx12.i1705 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom11.i1704, !dbg !3050
  %64 = load i8, i8* %arrayidx12.i1705, align 1, !dbg !3050
  %conv13.i1706 = zext i8 %64 to i32, !dbg !3051
  %shl14.i1707 = shl i32 %conv13.i1706, 8, !dbg !3052
  %65 = load i32, i32* %t.i1687, align 4, !dbg !3053
  %or15.i1708 = or i32 %65, %shl14.i1707, !dbg !3053
  store i32 %or15.i1708, i32* %t.i1687, align 4, !dbg !3053
  %66 = load i32, i32* %X.addr.i1686, align 4, !dbg !3054
  %conv16.i1709 = trunc i32 %66 to i8, !dbg !3055
  %idxprom17.i1710 = zext i8 %conv16.i1709 to i64, !dbg !3056
  %arrayidx18.i1711 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom17.i1710, !dbg !3056
  %67 = load i8, i8* %arrayidx18.i1711, align 1, !dbg !3056
  %conv19.i1712 = zext i8 %67 to i32, !dbg !3056
  %68 = load i32, i32* %t.i1687, align 4, !dbg !3057
  %or20.i1713 = or i32 %68, %conv19.i1712, !dbg !3057
  store i32 %or20.i1713, i32* %t.i1687, align 4, !dbg !3057
  %69 = load i32, i32* %t.i1687, align 4, !dbg !3058
  %70 = load i32, i32* %t.i1687, align 4, !dbg !3059
  store i32 %70, i32* %a.addr.i.i1684, align 4
  store i8 2, i8* %n.addr.i.i1685, align 1
  %71 = load i32, i32* %a.addr.i.i1684, align 4, !dbg !3060
  %72 = load i8, i8* %n.addr.i.i1685, align 1, !dbg !3061
  %conv.i.i1714 = zext i8 %72 to i32, !dbg !3061
  %shl.i.i1715 = shl i32 %71, %conv.i.i1714, !dbg !3062
  %73 = load i32, i32* %a.addr.i.i1684, align 4, !dbg !3063
  %74 = load i8, i8* %n.addr.i.i1685, align 1, !dbg !3064
  %conv1.i.i1716 = zext i8 %74 to i32, !dbg !3064
  %sub.i.i1717 = sub nsw i32 32, %conv1.i.i1716, !dbg !3065
  %shr.i.i1718 = lshr i32 %73, %sub.i.i1717, !dbg !3066
  %or.i.i1719 = or i32 %shl.i.i1715, %shr.i.i1718, !dbg !3067
  %xor.i1720 = xor i32 %69, %or.i.i1719, !dbg !3068
  %75 = load i32, i32* %t.i1687, align 4, !dbg !3069
  store i32 %75, i32* %a.addr.i43.i1678, align 4
  store i8 10, i8* %n.addr.i44.i1679, align 1
  %76 = load i32, i32* %a.addr.i43.i1678, align 4, !dbg !3070
  %77 = load i8, i8* %n.addr.i44.i1679, align 1, !dbg !3071
  %conv.i45.i1721 = zext i8 %77 to i32, !dbg !3071
  %shl.i46.i1722 = shl i32 %76, %conv.i45.i1721, !dbg !3072
  %78 = load i32, i32* %a.addr.i43.i1678, align 4, !dbg !3073
  %79 = load i8, i8* %n.addr.i44.i1679, align 1, !dbg !3074
  %conv1.i47.i1723 = zext i8 %79 to i32, !dbg !3074
  %sub.i48.i1724 = sub nsw i32 32, %conv1.i47.i1723, !dbg !3075
  %shr.i49.i1725 = lshr i32 %78, %sub.i48.i1724, !dbg !3076
  %or.i50.i1726 = or i32 %shl.i46.i1722, %shr.i49.i1725, !dbg !3077
  %xor22.i1727 = xor i32 %xor.i1720, %or.i50.i1726, !dbg !3078
  %80 = load i32, i32* %t.i1687, align 4, !dbg !3079
  store i32 %80, i32* %a.addr.i35.i1680, align 4
  store i8 18, i8* %n.addr.i36.i1681, align 1
  %81 = load i32, i32* %a.addr.i35.i1680, align 4, !dbg !3080
  %82 = load i8, i8* %n.addr.i36.i1681, align 1, !dbg !3081
  %conv.i37.i1728 = zext i8 %82 to i32, !dbg !3081
  %shl.i38.i1729 = shl i32 %81, %conv.i37.i1728, !dbg !3082
  %83 = load i32, i32* %a.addr.i35.i1680, align 4, !dbg !3083
  %84 = load i8, i8* %n.addr.i36.i1681, align 1, !dbg !3084
  %conv1.i39.i1730 = zext i8 %84 to i32, !dbg !3084
  %sub.i40.i1731 = sub nsw i32 32, %conv1.i39.i1730, !dbg !3085
  %shr.i41.i1732 = lshr i32 %83, %sub.i40.i1731, !dbg !3086
  %or.i42.i1733 = or i32 %shl.i38.i1729, %shr.i41.i1732, !dbg !3087
  %xor24.i1734 = xor i32 %xor22.i1727, %or.i42.i1733, !dbg !3088
  %85 = load i32, i32* %t.i1687, align 4, !dbg !3089
  store i32 %85, i32* %a.addr.i27.i1682, align 4
  store i8 24, i8* %n.addr.i28.i1683, align 1
  %86 = load i32, i32* %a.addr.i27.i1682, align 4, !dbg !3090
  %87 = load i8, i8* %n.addr.i28.i1683, align 1, !dbg !3091
  %conv.i29.i1735 = zext i8 %87 to i32, !dbg !3091
  %shl.i30.i1736 = shl i32 %86, %conv.i29.i1735, !dbg !3092
  %88 = load i32, i32* %a.addr.i27.i1682, align 4, !dbg !3093
  %89 = load i8, i8* %n.addr.i28.i1683, align 1, !dbg !3094
  %conv1.i31.i1737 = zext i8 %89 to i32, !dbg !3094
  %sub.i32.i1738 = sub nsw i32 32, %conv1.i31.i1737, !dbg !3095
  %shr.i33.i1739 = lshr i32 %88, %sub.i32.i1738, !dbg !3096
  %or.i34.i1740 = or i32 %shl.i30.i1736, %shr.i33.i1739, !dbg !3097
  %xor26.i1741 = xor i32 %xor24.i1734, %or.i34.i1740, !dbg !3098
  %90 = load i32, i32* %B0, align 4, !dbg !3032
  %xor7 = xor i32 %90, %xor26.i1741, !dbg !3032
  store i32 %xor7, i32* %B0, align 4, !dbg !3032
  %91 = load i32, i32* %B0, align 4, !dbg !3032
  %92 = load i32, i32* %B2, align 4, !dbg !3032
  %xor8 = xor i32 %91, %92, !dbg !3032
  %93 = load i32, i32* %B3, align 4, !dbg !3032
  %xor9 = xor i32 %xor8, %93, !dbg !3032
  %94 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3032
  %rk10 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %94, i32 0, i32 0, !dbg !3032
  %arrayidx11 = getelementptr inbounds [32 x i32], [32 x i32]* %rk10, i64 0, i64 30, !dbg !3032
  %95 = load i32, i32* %arrayidx11, align 4, !dbg !3032
  %xor12 = xor i32 %xor9, %95, !dbg !3032
  store i32 %xor12, i32* %X.addr.i1622, align 4
  store i32 0, i32* %t.i1623, align 4, !dbg !2536
  %96 = load i32, i32* %X.addr.i1622, align 4, !dbg !3099
  %shr.i1624 = lshr i32 %96, 24, !dbg !3100
  %conv.i1625 = trunc i32 %shr.i1624 to i8, !dbg !3101
  %idxprom.i1626 = zext i8 %conv.i1625 to i64, !dbg !3102
  %arrayidx.i1627 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom.i1626, !dbg !3102
  %97 = load i8, i8* %arrayidx.i1627, align 1, !dbg !3102
  %conv1.i1628 = zext i8 %97 to i32, !dbg !3103
  %shl.i1629 = shl i32 %conv1.i1628, 24, !dbg !3104
  %98 = load i32, i32* %t.i1623, align 4, !dbg !3105
  %or.i1630 = or i32 %98, %shl.i1629, !dbg !3105
  store i32 %or.i1630, i32* %t.i1623, align 4, !dbg !3105
  %99 = load i32, i32* %X.addr.i1622, align 4, !dbg !3106
  %shr2.i1631 = lshr i32 %99, 16, !dbg !3107
  %conv3.i1632 = trunc i32 %shr2.i1631 to i8, !dbg !3108
  %idxprom4.i1633 = zext i8 %conv3.i1632 to i64, !dbg !3109
  %arrayidx5.i1634 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom4.i1633, !dbg !3109
  %100 = load i8, i8* %arrayidx5.i1634, align 1, !dbg !3109
  %conv6.i1635 = zext i8 %100 to i32, !dbg !3110
  %shl7.i1636 = shl i32 %conv6.i1635, 16, !dbg !3111
  %101 = load i32, i32* %t.i1623, align 4, !dbg !3112
  %or8.i1637 = or i32 %101, %shl7.i1636, !dbg !3112
  store i32 %or8.i1637, i32* %t.i1623, align 4, !dbg !3112
  %102 = load i32, i32* %X.addr.i1622, align 4, !dbg !3113
  %shr9.i1638 = lshr i32 %102, 8, !dbg !3114
  %conv10.i1639 = trunc i32 %shr9.i1638 to i8, !dbg !3115
  %idxprom11.i1640 = zext i8 %conv10.i1639 to i64, !dbg !3116
  %arrayidx12.i1641 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom11.i1640, !dbg !3116
  %103 = load i8, i8* %arrayidx12.i1641, align 1, !dbg !3116
  %conv13.i1642 = zext i8 %103 to i32, !dbg !3117
  %shl14.i1643 = shl i32 %conv13.i1642, 8, !dbg !3118
  %104 = load i32, i32* %t.i1623, align 4, !dbg !3119
  %or15.i1644 = or i32 %104, %shl14.i1643, !dbg !3119
  store i32 %or15.i1644, i32* %t.i1623, align 4, !dbg !3119
  %105 = load i32, i32* %X.addr.i1622, align 4, !dbg !3120
  %conv16.i1645 = trunc i32 %105 to i8, !dbg !3121
  %idxprom17.i1646 = zext i8 %conv16.i1645 to i64, !dbg !3122
  %arrayidx18.i1647 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom17.i1646, !dbg !3122
  %106 = load i8, i8* %arrayidx18.i1647, align 1, !dbg !3122
  %conv19.i1648 = zext i8 %106 to i32, !dbg !3122
  %107 = load i32, i32* %t.i1623, align 4, !dbg !3123
  %or20.i1649 = or i32 %107, %conv19.i1648, !dbg !3123
  store i32 %or20.i1649, i32* %t.i1623, align 4, !dbg !3123
  %108 = load i32, i32* %t.i1623, align 4, !dbg !3124
  %109 = load i32, i32* %t.i1623, align 4, !dbg !3125
  store i32 %109, i32* %a.addr.i.i1620, align 4
  store i8 2, i8* %n.addr.i.i1621, align 1
  %110 = load i32, i32* %a.addr.i.i1620, align 4, !dbg !3126
  %111 = load i8, i8* %n.addr.i.i1621, align 1, !dbg !3127
  %conv.i.i1650 = zext i8 %111 to i32, !dbg !3127
  %shl.i.i1651 = shl i32 %110, %conv.i.i1650, !dbg !3128
  %112 = load i32, i32* %a.addr.i.i1620, align 4, !dbg !3129
  %113 = load i8, i8* %n.addr.i.i1621, align 1, !dbg !3130
  %conv1.i.i1652 = zext i8 %113 to i32, !dbg !3130
  %sub.i.i1653 = sub nsw i32 32, %conv1.i.i1652, !dbg !3131
  %shr.i.i1654 = lshr i32 %112, %sub.i.i1653, !dbg !3132
  %or.i.i1655 = or i32 %shl.i.i1651, %shr.i.i1654, !dbg !3133
  %xor.i1656 = xor i32 %108, %or.i.i1655, !dbg !3134
  %114 = load i32, i32* %t.i1623, align 4, !dbg !3135
  store i32 %114, i32* %a.addr.i43.i1614, align 4
  store i8 10, i8* %n.addr.i44.i1615, align 1
  %115 = load i32, i32* %a.addr.i43.i1614, align 4, !dbg !3136
  %116 = load i8, i8* %n.addr.i44.i1615, align 1, !dbg !3137
  %conv.i45.i1657 = zext i8 %116 to i32, !dbg !3137
  %shl.i46.i1658 = shl i32 %115, %conv.i45.i1657, !dbg !3138
  %117 = load i32, i32* %a.addr.i43.i1614, align 4, !dbg !3139
  %118 = load i8, i8* %n.addr.i44.i1615, align 1, !dbg !3140
  %conv1.i47.i1659 = zext i8 %118 to i32, !dbg !3140
  %sub.i48.i1660 = sub nsw i32 32, %conv1.i47.i1659, !dbg !3141
  %shr.i49.i1661 = lshr i32 %117, %sub.i48.i1660, !dbg !3142
  %or.i50.i1662 = or i32 %shl.i46.i1658, %shr.i49.i1661, !dbg !3143
  %xor22.i1663 = xor i32 %xor.i1656, %or.i50.i1662, !dbg !3144
  %119 = load i32, i32* %t.i1623, align 4, !dbg !3145
  store i32 %119, i32* %a.addr.i35.i1616, align 4
  store i8 18, i8* %n.addr.i36.i1617, align 1
  %120 = load i32, i32* %a.addr.i35.i1616, align 4, !dbg !3146
  %121 = load i8, i8* %n.addr.i36.i1617, align 1, !dbg !3147
  %conv.i37.i1664 = zext i8 %121 to i32, !dbg !3147
  %shl.i38.i1665 = shl i32 %120, %conv.i37.i1664, !dbg !3148
  %122 = load i32, i32* %a.addr.i35.i1616, align 4, !dbg !3149
  %123 = load i8, i8* %n.addr.i36.i1617, align 1, !dbg !3150
  %conv1.i39.i1666 = zext i8 %123 to i32, !dbg !3150
  %sub.i40.i1667 = sub nsw i32 32, %conv1.i39.i1666, !dbg !3151
  %shr.i41.i1668 = lshr i32 %122, %sub.i40.i1667, !dbg !3152
  %or.i42.i1669 = or i32 %shl.i38.i1665, %shr.i41.i1668, !dbg !3153
  %xor24.i1670 = xor i32 %xor22.i1663, %or.i42.i1669, !dbg !3154
  %124 = load i32, i32* %t.i1623, align 4, !dbg !3155
  store i32 %124, i32* %a.addr.i27.i1618, align 4
  store i8 24, i8* %n.addr.i28.i1619, align 1
  %125 = load i32, i32* %a.addr.i27.i1618, align 4, !dbg !3156
  %126 = load i8, i8* %n.addr.i28.i1619, align 1, !dbg !3157
  %conv.i29.i1671 = zext i8 %126 to i32, !dbg !3157
  %shl.i30.i1672 = shl i32 %125, %conv.i29.i1671, !dbg !3158
  %127 = load i32, i32* %a.addr.i27.i1618, align 4, !dbg !3159
  %128 = load i8, i8* %n.addr.i28.i1619, align 1, !dbg !3160
  %conv1.i31.i1673 = zext i8 %128 to i32, !dbg !3160
  %sub.i32.i1674 = sub nsw i32 32, %conv1.i31.i1673, !dbg !3161
  %shr.i33.i1675 = lshr i32 %127, %sub.i32.i1674, !dbg !3162
  %or.i34.i1676 = or i32 %shl.i30.i1672, %shr.i33.i1675, !dbg !3163
  %xor26.i1677 = xor i32 %xor24.i1670, %or.i34.i1676, !dbg !3164
  %129 = load i32, i32* %B1, align 4, !dbg !3032
  %xor14 = xor i32 %129, %xor26.i1677, !dbg !3032
  store i32 %xor14, i32* %B1, align 4, !dbg !3032
  %130 = load i32, i32* %B0, align 4, !dbg !3032
  %131 = load i32, i32* %B1, align 4, !dbg !3032
  %xor15 = xor i32 %130, %131, !dbg !3032
  %132 = load i32, i32* %B3, align 4, !dbg !3032
  %xor16 = xor i32 %xor15, %132, !dbg !3032
  %133 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3032
  %rk17 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %133, i32 0, i32 0, !dbg !3032
  %arrayidx18 = getelementptr inbounds [32 x i32], [32 x i32]* %rk17, i64 0, i64 29, !dbg !3032
  %134 = load i32, i32* %arrayidx18, align 4, !dbg !3032
  %xor19 = xor i32 %xor16, %134, !dbg !3032
  store i32 %xor19, i32* %X.addr.i1558, align 4
  store i32 0, i32* %t.i1559, align 4, !dbg !2551
  %135 = load i32, i32* %X.addr.i1558, align 4, !dbg !3165
  %shr.i1560 = lshr i32 %135, 24, !dbg !3166
  %conv.i1561 = trunc i32 %shr.i1560 to i8, !dbg !3167
  %idxprom.i1562 = zext i8 %conv.i1561 to i64, !dbg !3168
  %arrayidx.i1563 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom.i1562, !dbg !3168
  %136 = load i8, i8* %arrayidx.i1563, align 1, !dbg !3168
  %conv1.i1564 = zext i8 %136 to i32, !dbg !3169
  %shl.i1565 = shl i32 %conv1.i1564, 24, !dbg !3170
  %137 = load i32, i32* %t.i1559, align 4, !dbg !3171
  %or.i1566 = or i32 %137, %shl.i1565, !dbg !3171
  store i32 %or.i1566, i32* %t.i1559, align 4, !dbg !3171
  %138 = load i32, i32* %X.addr.i1558, align 4, !dbg !3172
  %shr2.i1567 = lshr i32 %138, 16, !dbg !3173
  %conv3.i1568 = trunc i32 %shr2.i1567 to i8, !dbg !3174
  %idxprom4.i1569 = zext i8 %conv3.i1568 to i64, !dbg !3175
  %arrayidx5.i1570 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom4.i1569, !dbg !3175
  %139 = load i8, i8* %arrayidx5.i1570, align 1, !dbg !3175
  %conv6.i1571 = zext i8 %139 to i32, !dbg !3176
  %shl7.i1572 = shl i32 %conv6.i1571, 16, !dbg !3177
  %140 = load i32, i32* %t.i1559, align 4, !dbg !3178
  %or8.i1573 = or i32 %140, %shl7.i1572, !dbg !3178
  store i32 %or8.i1573, i32* %t.i1559, align 4, !dbg !3178
  %141 = load i32, i32* %X.addr.i1558, align 4, !dbg !3179
  %shr9.i1574 = lshr i32 %141, 8, !dbg !3180
  %conv10.i1575 = trunc i32 %shr9.i1574 to i8, !dbg !3181
  %idxprom11.i1576 = zext i8 %conv10.i1575 to i64, !dbg !3182
  %arrayidx12.i1577 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom11.i1576, !dbg !3182
  %142 = load i8, i8* %arrayidx12.i1577, align 1, !dbg !3182
  %conv13.i1578 = zext i8 %142 to i32, !dbg !3183
  %shl14.i1579 = shl i32 %conv13.i1578, 8, !dbg !3184
  %143 = load i32, i32* %t.i1559, align 4, !dbg !3185
  %or15.i1580 = or i32 %143, %shl14.i1579, !dbg !3185
  store i32 %or15.i1580, i32* %t.i1559, align 4, !dbg !3185
  %144 = load i32, i32* %X.addr.i1558, align 4, !dbg !3186
  %conv16.i1581 = trunc i32 %144 to i8, !dbg !3187
  %idxprom17.i1582 = zext i8 %conv16.i1581 to i64, !dbg !3188
  %arrayidx18.i1583 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom17.i1582, !dbg !3188
  %145 = load i8, i8* %arrayidx18.i1583, align 1, !dbg !3188
  %conv19.i1584 = zext i8 %145 to i32, !dbg !3188
  %146 = load i32, i32* %t.i1559, align 4, !dbg !3189
  %or20.i1585 = or i32 %146, %conv19.i1584, !dbg !3189
  store i32 %or20.i1585, i32* %t.i1559, align 4, !dbg !3189
  %147 = load i32, i32* %t.i1559, align 4, !dbg !3190
  %148 = load i32, i32* %t.i1559, align 4, !dbg !3191
  store i32 %148, i32* %a.addr.i.i1556, align 4
  store i8 2, i8* %n.addr.i.i1557, align 1
  %149 = load i32, i32* %a.addr.i.i1556, align 4, !dbg !3192
  %150 = load i8, i8* %n.addr.i.i1557, align 1, !dbg !3193
  %conv.i.i1586 = zext i8 %150 to i32, !dbg !3193
  %shl.i.i1587 = shl i32 %149, %conv.i.i1586, !dbg !3194
  %151 = load i32, i32* %a.addr.i.i1556, align 4, !dbg !3195
  %152 = load i8, i8* %n.addr.i.i1557, align 1, !dbg !3196
  %conv1.i.i1588 = zext i8 %152 to i32, !dbg !3196
  %sub.i.i1589 = sub nsw i32 32, %conv1.i.i1588, !dbg !3197
  %shr.i.i1590 = lshr i32 %151, %sub.i.i1589, !dbg !3198
  %or.i.i1591 = or i32 %shl.i.i1587, %shr.i.i1590, !dbg !3199
  %xor.i1592 = xor i32 %147, %or.i.i1591, !dbg !3200
  %153 = load i32, i32* %t.i1559, align 4, !dbg !3201
  store i32 %153, i32* %a.addr.i43.i1550, align 4
  store i8 10, i8* %n.addr.i44.i1551, align 1
  %154 = load i32, i32* %a.addr.i43.i1550, align 4, !dbg !3202
  %155 = load i8, i8* %n.addr.i44.i1551, align 1, !dbg !3203
  %conv.i45.i1593 = zext i8 %155 to i32, !dbg !3203
  %shl.i46.i1594 = shl i32 %154, %conv.i45.i1593, !dbg !3204
  %156 = load i32, i32* %a.addr.i43.i1550, align 4, !dbg !3205
  %157 = load i8, i8* %n.addr.i44.i1551, align 1, !dbg !3206
  %conv1.i47.i1595 = zext i8 %157 to i32, !dbg !3206
  %sub.i48.i1596 = sub nsw i32 32, %conv1.i47.i1595, !dbg !3207
  %shr.i49.i1597 = lshr i32 %156, %sub.i48.i1596, !dbg !3208
  %or.i50.i1598 = or i32 %shl.i46.i1594, %shr.i49.i1597, !dbg !3209
  %xor22.i1599 = xor i32 %xor.i1592, %or.i50.i1598, !dbg !3210
  %158 = load i32, i32* %t.i1559, align 4, !dbg !3211
  store i32 %158, i32* %a.addr.i35.i1552, align 4
  store i8 18, i8* %n.addr.i36.i1553, align 1
  %159 = load i32, i32* %a.addr.i35.i1552, align 4, !dbg !3212
  %160 = load i8, i8* %n.addr.i36.i1553, align 1, !dbg !3213
  %conv.i37.i1600 = zext i8 %160 to i32, !dbg !3213
  %shl.i38.i1601 = shl i32 %159, %conv.i37.i1600, !dbg !3214
  %161 = load i32, i32* %a.addr.i35.i1552, align 4, !dbg !3215
  %162 = load i8, i8* %n.addr.i36.i1553, align 1, !dbg !3216
  %conv1.i39.i1602 = zext i8 %162 to i32, !dbg !3216
  %sub.i40.i1603 = sub nsw i32 32, %conv1.i39.i1602, !dbg !3217
  %shr.i41.i1604 = lshr i32 %161, %sub.i40.i1603, !dbg !3218
  %or.i42.i1605 = or i32 %shl.i38.i1601, %shr.i41.i1604, !dbg !3219
  %xor24.i1606 = xor i32 %xor22.i1599, %or.i42.i1605, !dbg !3220
  %163 = load i32, i32* %t.i1559, align 4, !dbg !3221
  store i32 %163, i32* %a.addr.i27.i1554, align 4
  store i8 24, i8* %n.addr.i28.i1555, align 1
  %164 = load i32, i32* %a.addr.i27.i1554, align 4, !dbg !3222
  %165 = load i8, i8* %n.addr.i28.i1555, align 1, !dbg !3223
  %conv.i29.i1607 = zext i8 %165 to i32, !dbg !3223
  %shl.i30.i1608 = shl i32 %164, %conv.i29.i1607, !dbg !3224
  %166 = load i32, i32* %a.addr.i27.i1554, align 4, !dbg !3225
  %167 = load i8, i8* %n.addr.i28.i1555, align 1, !dbg !3226
  %conv1.i31.i1609 = zext i8 %167 to i32, !dbg !3226
  %sub.i32.i1610 = sub nsw i32 32, %conv1.i31.i1609, !dbg !3227
  %shr.i33.i1611 = lshr i32 %166, %sub.i32.i1610, !dbg !3228
  %or.i34.i1612 = or i32 %shl.i30.i1608, %shr.i33.i1611, !dbg !3229
  %xor26.i1613 = xor i32 %xor24.i1606, %or.i34.i1612, !dbg !3230
  %168 = load i32, i32* %B2, align 4, !dbg !3032
  %xor21 = xor i32 %168, %xor26.i1613, !dbg !3032
  store i32 %xor21, i32* %B2, align 4, !dbg !3032
  %169 = load i32, i32* %B0, align 4, !dbg !3032
  %170 = load i32, i32* %B1, align 4, !dbg !3032
  %xor22 = xor i32 %169, %170, !dbg !3032
  %171 = load i32, i32* %B2, align 4, !dbg !3032
  %xor23 = xor i32 %xor22, %171, !dbg !3032
  %172 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3032
  %rk24 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %172, i32 0, i32 0, !dbg !3032
  %arrayidx25 = getelementptr inbounds [32 x i32], [32 x i32]* %rk24, i64 0, i64 28, !dbg !3032
  %173 = load i32, i32* %arrayidx25, align 4, !dbg !3032
  %xor26 = xor i32 %xor23, %173, !dbg !3032
  store i32 %xor26, i32* %X.addr.i1494, align 4
  store i32 0, i32* %t.i1495, align 4, !dbg !2566
  %174 = load i32, i32* %X.addr.i1494, align 4, !dbg !3231
  %shr.i1496 = lshr i32 %174, 24, !dbg !3232
  %conv.i1497 = trunc i32 %shr.i1496 to i8, !dbg !3233
  %idxprom.i1498 = zext i8 %conv.i1497 to i64, !dbg !3234
  %arrayidx.i1499 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom.i1498, !dbg !3234
  %175 = load i8, i8* %arrayidx.i1499, align 1, !dbg !3234
  %conv1.i1500 = zext i8 %175 to i32, !dbg !3235
  %shl.i1501 = shl i32 %conv1.i1500, 24, !dbg !3236
  %176 = load i32, i32* %t.i1495, align 4, !dbg !3237
  %or.i1502 = or i32 %176, %shl.i1501, !dbg !3237
  store i32 %or.i1502, i32* %t.i1495, align 4, !dbg !3237
  %177 = load i32, i32* %X.addr.i1494, align 4, !dbg !3238
  %shr2.i1503 = lshr i32 %177, 16, !dbg !3239
  %conv3.i1504 = trunc i32 %shr2.i1503 to i8, !dbg !3240
  %idxprom4.i1505 = zext i8 %conv3.i1504 to i64, !dbg !3241
  %arrayidx5.i1506 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom4.i1505, !dbg !3241
  %178 = load i8, i8* %arrayidx5.i1506, align 1, !dbg !3241
  %conv6.i1507 = zext i8 %178 to i32, !dbg !3242
  %shl7.i1508 = shl i32 %conv6.i1507, 16, !dbg !3243
  %179 = load i32, i32* %t.i1495, align 4, !dbg !3244
  %or8.i1509 = or i32 %179, %shl7.i1508, !dbg !3244
  store i32 %or8.i1509, i32* %t.i1495, align 4, !dbg !3244
  %180 = load i32, i32* %X.addr.i1494, align 4, !dbg !3245
  %shr9.i1510 = lshr i32 %180, 8, !dbg !3246
  %conv10.i1511 = trunc i32 %shr9.i1510 to i8, !dbg !3247
  %idxprom11.i1512 = zext i8 %conv10.i1511 to i64, !dbg !3248
  %arrayidx12.i1513 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom11.i1512, !dbg !3248
  %181 = load i8, i8* %arrayidx12.i1513, align 1, !dbg !3248
  %conv13.i1514 = zext i8 %181 to i32, !dbg !3249
  %shl14.i1515 = shl i32 %conv13.i1514, 8, !dbg !3250
  %182 = load i32, i32* %t.i1495, align 4, !dbg !3251
  %or15.i1516 = or i32 %182, %shl14.i1515, !dbg !3251
  store i32 %or15.i1516, i32* %t.i1495, align 4, !dbg !3251
  %183 = load i32, i32* %X.addr.i1494, align 4, !dbg !3252
  %conv16.i1517 = trunc i32 %183 to i8, !dbg !3253
  %idxprom17.i1518 = zext i8 %conv16.i1517 to i64, !dbg !3254
  %arrayidx18.i1519 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom17.i1518, !dbg !3254
  %184 = load i8, i8* %arrayidx18.i1519, align 1, !dbg !3254
  %conv19.i1520 = zext i8 %184 to i32, !dbg !3254
  %185 = load i32, i32* %t.i1495, align 4, !dbg !3255
  %or20.i1521 = or i32 %185, %conv19.i1520, !dbg !3255
  store i32 %or20.i1521, i32* %t.i1495, align 4, !dbg !3255
  %186 = load i32, i32* %t.i1495, align 4, !dbg !3256
  %187 = load i32, i32* %t.i1495, align 4, !dbg !3257
  store i32 %187, i32* %a.addr.i.i1492, align 4
  store i8 2, i8* %n.addr.i.i1493, align 1
  %188 = load i32, i32* %a.addr.i.i1492, align 4, !dbg !3258
  %189 = load i8, i8* %n.addr.i.i1493, align 1, !dbg !3259
  %conv.i.i1522 = zext i8 %189 to i32, !dbg !3259
  %shl.i.i1523 = shl i32 %188, %conv.i.i1522, !dbg !3260
  %190 = load i32, i32* %a.addr.i.i1492, align 4, !dbg !3261
  %191 = load i8, i8* %n.addr.i.i1493, align 1, !dbg !3262
  %conv1.i.i1524 = zext i8 %191 to i32, !dbg !3262
  %sub.i.i1525 = sub nsw i32 32, %conv1.i.i1524, !dbg !3263
  %shr.i.i1526 = lshr i32 %190, %sub.i.i1525, !dbg !3264
  %or.i.i1527 = or i32 %shl.i.i1523, %shr.i.i1526, !dbg !3265
  %xor.i1528 = xor i32 %186, %or.i.i1527, !dbg !3266
  %192 = load i32, i32* %t.i1495, align 4, !dbg !3267
  store i32 %192, i32* %a.addr.i43.i1486, align 4
  store i8 10, i8* %n.addr.i44.i1487, align 1
  %193 = load i32, i32* %a.addr.i43.i1486, align 4, !dbg !3268
  %194 = load i8, i8* %n.addr.i44.i1487, align 1, !dbg !3269
  %conv.i45.i1529 = zext i8 %194 to i32, !dbg !3269
  %shl.i46.i1530 = shl i32 %193, %conv.i45.i1529, !dbg !3270
  %195 = load i32, i32* %a.addr.i43.i1486, align 4, !dbg !3271
  %196 = load i8, i8* %n.addr.i44.i1487, align 1, !dbg !3272
  %conv1.i47.i1531 = zext i8 %196 to i32, !dbg !3272
  %sub.i48.i1532 = sub nsw i32 32, %conv1.i47.i1531, !dbg !3273
  %shr.i49.i1533 = lshr i32 %195, %sub.i48.i1532, !dbg !3274
  %or.i50.i1534 = or i32 %shl.i46.i1530, %shr.i49.i1533, !dbg !3275
  %xor22.i1535 = xor i32 %xor.i1528, %or.i50.i1534, !dbg !3276
  %197 = load i32, i32* %t.i1495, align 4, !dbg !3277
  store i32 %197, i32* %a.addr.i35.i1488, align 4
  store i8 18, i8* %n.addr.i36.i1489, align 1
  %198 = load i32, i32* %a.addr.i35.i1488, align 4, !dbg !3278
  %199 = load i8, i8* %n.addr.i36.i1489, align 1, !dbg !3279
  %conv.i37.i1536 = zext i8 %199 to i32, !dbg !3279
  %shl.i38.i1537 = shl i32 %198, %conv.i37.i1536, !dbg !3280
  %200 = load i32, i32* %a.addr.i35.i1488, align 4, !dbg !3281
  %201 = load i8, i8* %n.addr.i36.i1489, align 1, !dbg !3282
  %conv1.i39.i1538 = zext i8 %201 to i32, !dbg !3282
  %sub.i40.i1539 = sub nsw i32 32, %conv1.i39.i1538, !dbg !3283
  %shr.i41.i1540 = lshr i32 %200, %sub.i40.i1539, !dbg !3284
  %or.i42.i1541 = or i32 %shl.i38.i1537, %shr.i41.i1540, !dbg !3285
  %xor24.i1542 = xor i32 %xor22.i1535, %or.i42.i1541, !dbg !3286
  %202 = load i32, i32* %t.i1495, align 4, !dbg !3287
  store i32 %202, i32* %a.addr.i27.i1490, align 4
  store i8 24, i8* %n.addr.i28.i1491, align 1
  %203 = load i32, i32* %a.addr.i27.i1490, align 4, !dbg !3288
  %204 = load i8, i8* %n.addr.i28.i1491, align 1, !dbg !3289
  %conv.i29.i1543 = zext i8 %204 to i32, !dbg !3289
  %shl.i30.i1544 = shl i32 %203, %conv.i29.i1543, !dbg !3290
  %205 = load i32, i32* %a.addr.i27.i1490, align 4, !dbg !3291
  %206 = load i8, i8* %n.addr.i28.i1491, align 1, !dbg !3292
  %conv1.i31.i1545 = zext i8 %206 to i32, !dbg !3292
  %sub.i32.i1546 = sub nsw i32 32, %conv1.i31.i1545, !dbg !3293
  %shr.i33.i1547 = lshr i32 %205, %sub.i32.i1546, !dbg !3294
  %or.i34.i1548 = or i32 %shl.i30.i1544, %shr.i33.i1547, !dbg !3295
  %xor26.i1549 = xor i32 %xor24.i1542, %or.i34.i1548, !dbg !3296
  %207 = load i32, i32* %B3, align 4, !dbg !3032
  %xor28 = xor i32 %207, %xor26.i1549, !dbg !3032
  store i32 %xor28, i32* %B3, align 4, !dbg !3032
  br label %do.end, !dbg !3032

do.end:                                           ; preds = %do.body
  br label %do.body29, !dbg !3297

do.body29:                                        ; preds = %do.end
  %208 = load i32, i32* %B1, align 4, !dbg !3298
  %209 = load i32, i32* %B2, align 4, !dbg !3298
  %xor30 = xor i32 %208, %209, !dbg !3298
  %210 = load i32, i32* %B3, align 4, !dbg !3298
  %xor31 = xor i32 %xor30, %210, !dbg !3298
  %211 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3298
  %rk32 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %211, i32 0, i32 0, !dbg !3298
  %arrayidx33 = getelementptr inbounds [32 x i32], [32 x i32]* %rk32, i64 0, i64 27, !dbg !3298
  %212 = load i32, i32* %arrayidx33, align 4, !dbg !3298
  %xor34 = xor i32 %xor31, %212, !dbg !3298
  store i32 %xor34, i32* %X.addr.i1449, align 4
  %213 = load i32, i32* %X.addr.i1449, align 4, !dbg !3299
  %shr.i1450 = lshr i32 %213, 24, !dbg !3300
  %conv.i1451 = trunc i32 %shr.i1450 to i8, !dbg !3301
  %idxprom.i1452 = zext i8 %conv.i1451 to i64, !dbg !3302
  %arrayidx.i1453 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1452, !dbg !3302
  %214 = load i32, i32* %arrayidx.i1453, align 4, !dbg !3302
  %215 = load i32, i32* %X.addr.i1449, align 4, !dbg !3303
  %shr1.i1454 = lshr i32 %215, 16, !dbg !3304
  %conv2.i1455 = trunc i32 %shr1.i1454 to i8, !dbg !3305
  %idxprom3.i1456 = zext i8 %conv2.i1455 to i64, !dbg !3306
  %arrayidx4.i1457 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1456, !dbg !3306
  %216 = load i32, i32* %arrayidx4.i1457, align 4, !dbg !3306
  store i32 %216, i32* %a.addr.i.i1447, align 4
  store i8 24, i8* %n.addr.i.i1448, align 1
  %217 = load i32, i32* %a.addr.i.i1447, align 4, !dbg !3307
  %218 = load i8, i8* %n.addr.i.i1448, align 1, !dbg !3308
  %conv.i.i1458 = zext i8 %218 to i32, !dbg !3308
  %shl.i.i1459 = shl i32 %217, %conv.i.i1458, !dbg !3309
  %219 = load i32, i32* %a.addr.i.i1447, align 4, !dbg !3310
  %220 = load i8, i8* %n.addr.i.i1448, align 1, !dbg !3311
  %conv1.i.i1460 = zext i8 %220 to i32, !dbg !3311
  %sub.i.i1461 = sub nsw i32 32, %conv1.i.i1460, !dbg !3312
  %shr.i.i1462 = lshr i32 %219, %sub.i.i1461, !dbg !3313
  %or.i.i1463 = or i32 %shl.i.i1459, %shr.i.i1462, !dbg !3314
  %xor.i1464 = xor i32 %214, %or.i.i1463, !dbg !3315
  %221 = load i32, i32* %X.addr.i1449, align 4, !dbg !3316
  %shr5.i1465 = lshr i32 %221, 8, !dbg !3317
  %conv6.i1466 = trunc i32 %shr5.i1465 to i8, !dbg !3318
  %idxprom7.i1467 = zext i8 %conv6.i1466 to i64, !dbg !3319
  %arrayidx8.i1468 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1467, !dbg !3319
  %222 = load i32, i32* %arrayidx8.i1468, align 4, !dbg !3319
  store i32 %222, i32* %a.addr.i24.i1443, align 4
  store i8 16, i8* %n.addr.i25.i1444, align 1
  %223 = load i32, i32* %a.addr.i24.i1443, align 4, !dbg !3320
  %224 = load i8, i8* %n.addr.i25.i1444, align 1, !dbg !3321
  %conv.i26.i1469 = zext i8 %224 to i32, !dbg !3321
  %shl.i27.i1470 = shl i32 %223, %conv.i26.i1469, !dbg !3322
  %225 = load i32, i32* %a.addr.i24.i1443, align 4, !dbg !3323
  %226 = load i8, i8* %n.addr.i25.i1444, align 1, !dbg !3324
  %conv1.i28.i1471 = zext i8 %226 to i32, !dbg !3324
  %sub.i29.i1472 = sub nsw i32 32, %conv1.i28.i1471, !dbg !3325
  %shr.i30.i1473 = lshr i32 %225, %sub.i29.i1472, !dbg !3326
  %or.i31.i1474 = or i32 %shl.i27.i1470, %shr.i30.i1473, !dbg !3327
  %xor10.i1475 = xor i32 %xor.i1464, %or.i31.i1474, !dbg !3328
  %227 = load i32, i32* %X.addr.i1449, align 4, !dbg !3329
  %conv11.i1476 = trunc i32 %227 to i8, !dbg !3330
  %idxprom12.i1477 = zext i8 %conv11.i1476 to i64, !dbg !3331
  %arrayidx13.i1478 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1477, !dbg !3331
  %228 = load i32, i32* %arrayidx13.i1478, align 4, !dbg !3331
  store i32 %228, i32* %a.addr.i16.i1445, align 4
  store i8 8, i8* %n.addr.i17.i1446, align 1
  %229 = load i32, i32* %a.addr.i16.i1445, align 4, !dbg !3332
  %230 = load i8, i8* %n.addr.i17.i1446, align 1, !dbg !3333
  %conv.i18.i1479 = zext i8 %230 to i32, !dbg !3333
  %shl.i19.i1480 = shl i32 %229, %conv.i18.i1479, !dbg !3334
  %231 = load i32, i32* %a.addr.i16.i1445, align 4, !dbg !3335
  %232 = load i8, i8* %n.addr.i17.i1446, align 1, !dbg !3336
  %conv1.i20.i1481 = zext i8 %232 to i32, !dbg !3336
  %sub.i21.i1482 = sub nsw i32 32, %conv1.i20.i1481, !dbg !3337
  %shr.i22.i1483 = lshr i32 %231, %sub.i21.i1482, !dbg !3338
  %or.i23.i1484 = or i32 %shl.i19.i1480, %shr.i22.i1483, !dbg !3339
  %xor15.i1485 = xor i32 %xor10.i1475, %or.i23.i1484, !dbg !3340
  %233 = load i32, i32* %B0, align 4, !dbg !3298
  %xor36 = xor i32 %233, %xor15.i1485, !dbg !3298
  store i32 %xor36, i32* %B0, align 4, !dbg !3298
  %234 = load i32, i32* %B0, align 4, !dbg !3298
  %235 = load i32, i32* %B2, align 4, !dbg !3298
  %xor37 = xor i32 %234, %235, !dbg !3298
  %236 = load i32, i32* %B3, align 4, !dbg !3298
  %xor38 = xor i32 %xor37, %236, !dbg !3298
  %237 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3298
  %rk39 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %237, i32 0, i32 0, !dbg !3298
  %arrayidx40 = getelementptr inbounds [32 x i32], [32 x i32]* %rk39, i64 0, i64 26, !dbg !3298
  %238 = load i32, i32* %arrayidx40, align 4, !dbg !3298
  %xor41 = xor i32 %xor38, %238, !dbg !3298
  store i32 %xor41, i32* %X.addr.i1406, align 4
  %239 = load i32, i32* %X.addr.i1406, align 4, !dbg !3341
  %shr.i1407 = lshr i32 %239, 24, !dbg !3342
  %conv.i1408 = trunc i32 %shr.i1407 to i8, !dbg !3343
  %idxprom.i1409 = zext i8 %conv.i1408 to i64, !dbg !3344
  %arrayidx.i1410 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1409, !dbg !3344
  %240 = load i32, i32* %arrayidx.i1410, align 4, !dbg !3344
  %241 = load i32, i32* %X.addr.i1406, align 4, !dbg !3345
  %shr1.i1411 = lshr i32 %241, 16, !dbg !3346
  %conv2.i1412 = trunc i32 %shr1.i1411 to i8, !dbg !3347
  %idxprom3.i1413 = zext i8 %conv2.i1412 to i64, !dbg !3348
  %arrayidx4.i1414 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1413, !dbg !3348
  %242 = load i32, i32* %arrayidx4.i1414, align 4, !dbg !3348
  store i32 %242, i32* %a.addr.i.i1404, align 4
  store i8 24, i8* %n.addr.i.i1405, align 1
  %243 = load i32, i32* %a.addr.i.i1404, align 4, !dbg !3349
  %244 = load i8, i8* %n.addr.i.i1405, align 1, !dbg !3350
  %conv.i.i1415 = zext i8 %244 to i32, !dbg !3350
  %shl.i.i1416 = shl i32 %243, %conv.i.i1415, !dbg !3351
  %245 = load i32, i32* %a.addr.i.i1404, align 4, !dbg !3352
  %246 = load i8, i8* %n.addr.i.i1405, align 1, !dbg !3353
  %conv1.i.i1417 = zext i8 %246 to i32, !dbg !3353
  %sub.i.i1418 = sub nsw i32 32, %conv1.i.i1417, !dbg !3354
  %shr.i.i1419 = lshr i32 %245, %sub.i.i1418, !dbg !3355
  %or.i.i1420 = or i32 %shl.i.i1416, %shr.i.i1419, !dbg !3356
  %xor.i1421 = xor i32 %240, %or.i.i1420, !dbg !3357
  %247 = load i32, i32* %X.addr.i1406, align 4, !dbg !3358
  %shr5.i1422 = lshr i32 %247, 8, !dbg !3359
  %conv6.i1423 = trunc i32 %shr5.i1422 to i8, !dbg !3360
  %idxprom7.i1424 = zext i8 %conv6.i1423 to i64, !dbg !3361
  %arrayidx8.i1425 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1424, !dbg !3361
  %248 = load i32, i32* %arrayidx8.i1425, align 4, !dbg !3361
  store i32 %248, i32* %a.addr.i24.i1400, align 4
  store i8 16, i8* %n.addr.i25.i1401, align 1
  %249 = load i32, i32* %a.addr.i24.i1400, align 4, !dbg !3362
  %250 = load i8, i8* %n.addr.i25.i1401, align 1, !dbg !3363
  %conv.i26.i1426 = zext i8 %250 to i32, !dbg !3363
  %shl.i27.i1427 = shl i32 %249, %conv.i26.i1426, !dbg !3364
  %251 = load i32, i32* %a.addr.i24.i1400, align 4, !dbg !3365
  %252 = load i8, i8* %n.addr.i25.i1401, align 1, !dbg !3366
  %conv1.i28.i1428 = zext i8 %252 to i32, !dbg !3366
  %sub.i29.i1429 = sub nsw i32 32, %conv1.i28.i1428, !dbg !3367
  %shr.i30.i1430 = lshr i32 %251, %sub.i29.i1429, !dbg !3368
  %or.i31.i1431 = or i32 %shl.i27.i1427, %shr.i30.i1430, !dbg !3369
  %xor10.i1432 = xor i32 %xor.i1421, %or.i31.i1431, !dbg !3370
  %253 = load i32, i32* %X.addr.i1406, align 4, !dbg !3371
  %conv11.i1433 = trunc i32 %253 to i8, !dbg !3372
  %idxprom12.i1434 = zext i8 %conv11.i1433 to i64, !dbg !3373
  %arrayidx13.i1435 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1434, !dbg !3373
  %254 = load i32, i32* %arrayidx13.i1435, align 4, !dbg !3373
  store i32 %254, i32* %a.addr.i16.i1402, align 4
  store i8 8, i8* %n.addr.i17.i1403, align 1
  %255 = load i32, i32* %a.addr.i16.i1402, align 4, !dbg !3374
  %256 = load i8, i8* %n.addr.i17.i1403, align 1, !dbg !3375
  %conv.i18.i1436 = zext i8 %256 to i32, !dbg !3375
  %shl.i19.i1437 = shl i32 %255, %conv.i18.i1436, !dbg !3376
  %257 = load i32, i32* %a.addr.i16.i1402, align 4, !dbg !3377
  %258 = load i8, i8* %n.addr.i17.i1403, align 1, !dbg !3378
  %conv1.i20.i1438 = zext i8 %258 to i32, !dbg !3378
  %sub.i21.i1439 = sub nsw i32 32, %conv1.i20.i1438, !dbg !3379
  %shr.i22.i1440 = lshr i32 %257, %sub.i21.i1439, !dbg !3380
  %or.i23.i1441 = or i32 %shl.i19.i1437, %shr.i22.i1440, !dbg !3381
  %xor15.i1442 = xor i32 %xor10.i1432, %or.i23.i1441, !dbg !3382
  %259 = load i32, i32* %B1, align 4, !dbg !3298
  %xor43 = xor i32 %259, %xor15.i1442, !dbg !3298
  store i32 %xor43, i32* %B1, align 4, !dbg !3298
  %260 = load i32, i32* %B0, align 4, !dbg !3298
  %261 = load i32, i32* %B1, align 4, !dbg !3298
  %xor44 = xor i32 %260, %261, !dbg !3298
  %262 = load i32, i32* %B3, align 4, !dbg !3298
  %xor45 = xor i32 %xor44, %262, !dbg !3298
  %263 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3298
  %rk46 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %263, i32 0, i32 0, !dbg !3298
  %arrayidx47 = getelementptr inbounds [32 x i32], [32 x i32]* %rk46, i64 0, i64 25, !dbg !3298
  %264 = load i32, i32* %arrayidx47, align 4, !dbg !3298
  %xor48 = xor i32 %xor45, %264, !dbg !3298
  store i32 %xor48, i32* %X.addr.i1363, align 4
  %265 = load i32, i32* %X.addr.i1363, align 4, !dbg !3383
  %shr.i1364 = lshr i32 %265, 24, !dbg !3384
  %conv.i1365 = trunc i32 %shr.i1364 to i8, !dbg !3385
  %idxprom.i1366 = zext i8 %conv.i1365 to i64, !dbg !3386
  %arrayidx.i1367 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1366, !dbg !3386
  %266 = load i32, i32* %arrayidx.i1367, align 4, !dbg !3386
  %267 = load i32, i32* %X.addr.i1363, align 4, !dbg !3387
  %shr1.i1368 = lshr i32 %267, 16, !dbg !3388
  %conv2.i1369 = trunc i32 %shr1.i1368 to i8, !dbg !3389
  %idxprom3.i1370 = zext i8 %conv2.i1369 to i64, !dbg !3390
  %arrayidx4.i1371 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1370, !dbg !3390
  %268 = load i32, i32* %arrayidx4.i1371, align 4, !dbg !3390
  store i32 %268, i32* %a.addr.i.i1361, align 4
  store i8 24, i8* %n.addr.i.i1362, align 1
  %269 = load i32, i32* %a.addr.i.i1361, align 4, !dbg !3391
  %270 = load i8, i8* %n.addr.i.i1362, align 1, !dbg !3392
  %conv.i.i1372 = zext i8 %270 to i32, !dbg !3392
  %shl.i.i1373 = shl i32 %269, %conv.i.i1372, !dbg !3393
  %271 = load i32, i32* %a.addr.i.i1361, align 4, !dbg !3394
  %272 = load i8, i8* %n.addr.i.i1362, align 1, !dbg !3395
  %conv1.i.i1374 = zext i8 %272 to i32, !dbg !3395
  %sub.i.i1375 = sub nsw i32 32, %conv1.i.i1374, !dbg !3396
  %shr.i.i1376 = lshr i32 %271, %sub.i.i1375, !dbg !3397
  %or.i.i1377 = or i32 %shl.i.i1373, %shr.i.i1376, !dbg !3398
  %xor.i1378 = xor i32 %266, %or.i.i1377, !dbg !3399
  %273 = load i32, i32* %X.addr.i1363, align 4, !dbg !3400
  %shr5.i1379 = lshr i32 %273, 8, !dbg !3401
  %conv6.i1380 = trunc i32 %shr5.i1379 to i8, !dbg !3402
  %idxprom7.i1381 = zext i8 %conv6.i1380 to i64, !dbg !3403
  %arrayidx8.i1382 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1381, !dbg !3403
  %274 = load i32, i32* %arrayidx8.i1382, align 4, !dbg !3403
  store i32 %274, i32* %a.addr.i24.i1357, align 4
  store i8 16, i8* %n.addr.i25.i1358, align 1
  %275 = load i32, i32* %a.addr.i24.i1357, align 4, !dbg !3404
  %276 = load i8, i8* %n.addr.i25.i1358, align 1, !dbg !3405
  %conv.i26.i1383 = zext i8 %276 to i32, !dbg !3405
  %shl.i27.i1384 = shl i32 %275, %conv.i26.i1383, !dbg !3406
  %277 = load i32, i32* %a.addr.i24.i1357, align 4, !dbg !3407
  %278 = load i8, i8* %n.addr.i25.i1358, align 1, !dbg !3408
  %conv1.i28.i1385 = zext i8 %278 to i32, !dbg !3408
  %sub.i29.i1386 = sub nsw i32 32, %conv1.i28.i1385, !dbg !3409
  %shr.i30.i1387 = lshr i32 %277, %sub.i29.i1386, !dbg !3410
  %or.i31.i1388 = or i32 %shl.i27.i1384, %shr.i30.i1387, !dbg !3411
  %xor10.i1389 = xor i32 %xor.i1378, %or.i31.i1388, !dbg !3412
  %279 = load i32, i32* %X.addr.i1363, align 4, !dbg !3413
  %conv11.i1390 = trunc i32 %279 to i8, !dbg !3414
  %idxprom12.i1391 = zext i8 %conv11.i1390 to i64, !dbg !3415
  %arrayidx13.i1392 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1391, !dbg !3415
  %280 = load i32, i32* %arrayidx13.i1392, align 4, !dbg !3415
  store i32 %280, i32* %a.addr.i16.i1359, align 4
  store i8 8, i8* %n.addr.i17.i1360, align 1
  %281 = load i32, i32* %a.addr.i16.i1359, align 4, !dbg !3416
  %282 = load i8, i8* %n.addr.i17.i1360, align 1, !dbg !3417
  %conv.i18.i1393 = zext i8 %282 to i32, !dbg !3417
  %shl.i19.i1394 = shl i32 %281, %conv.i18.i1393, !dbg !3418
  %283 = load i32, i32* %a.addr.i16.i1359, align 4, !dbg !3419
  %284 = load i8, i8* %n.addr.i17.i1360, align 1, !dbg !3420
  %conv1.i20.i1395 = zext i8 %284 to i32, !dbg !3420
  %sub.i21.i1396 = sub nsw i32 32, %conv1.i20.i1395, !dbg !3421
  %shr.i22.i1397 = lshr i32 %283, %sub.i21.i1396, !dbg !3422
  %or.i23.i1398 = or i32 %shl.i19.i1394, %shr.i22.i1397, !dbg !3423
  %xor15.i1399 = xor i32 %xor10.i1389, %or.i23.i1398, !dbg !3424
  %285 = load i32, i32* %B2, align 4, !dbg !3298
  %xor50 = xor i32 %285, %xor15.i1399, !dbg !3298
  store i32 %xor50, i32* %B2, align 4, !dbg !3298
  %286 = load i32, i32* %B0, align 4, !dbg !3298
  %287 = load i32, i32* %B1, align 4, !dbg !3298
  %xor51 = xor i32 %286, %287, !dbg !3298
  %288 = load i32, i32* %B2, align 4, !dbg !3298
  %xor52 = xor i32 %xor51, %288, !dbg !3298
  %289 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3298
  %rk53 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %289, i32 0, i32 0, !dbg !3298
  %arrayidx54 = getelementptr inbounds [32 x i32], [32 x i32]* %rk53, i64 0, i64 24, !dbg !3298
  %290 = load i32, i32* %arrayidx54, align 4, !dbg !3298
  %xor55 = xor i32 %xor52, %290, !dbg !3298
  store i32 %xor55, i32* %X.addr.i1320, align 4
  %291 = load i32, i32* %X.addr.i1320, align 4, !dbg !3425
  %shr.i1321 = lshr i32 %291, 24, !dbg !3426
  %conv.i1322 = trunc i32 %shr.i1321 to i8, !dbg !3427
  %idxprom.i1323 = zext i8 %conv.i1322 to i64, !dbg !3428
  %arrayidx.i1324 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1323, !dbg !3428
  %292 = load i32, i32* %arrayidx.i1324, align 4, !dbg !3428
  %293 = load i32, i32* %X.addr.i1320, align 4, !dbg !3429
  %shr1.i1325 = lshr i32 %293, 16, !dbg !3430
  %conv2.i1326 = trunc i32 %shr1.i1325 to i8, !dbg !3431
  %idxprom3.i1327 = zext i8 %conv2.i1326 to i64, !dbg !3432
  %arrayidx4.i1328 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1327, !dbg !3432
  %294 = load i32, i32* %arrayidx4.i1328, align 4, !dbg !3432
  store i32 %294, i32* %a.addr.i.i1318, align 4
  store i8 24, i8* %n.addr.i.i1319, align 1
  %295 = load i32, i32* %a.addr.i.i1318, align 4, !dbg !3433
  %296 = load i8, i8* %n.addr.i.i1319, align 1, !dbg !3434
  %conv.i.i1329 = zext i8 %296 to i32, !dbg !3434
  %shl.i.i1330 = shl i32 %295, %conv.i.i1329, !dbg !3435
  %297 = load i32, i32* %a.addr.i.i1318, align 4, !dbg !3436
  %298 = load i8, i8* %n.addr.i.i1319, align 1, !dbg !3437
  %conv1.i.i1331 = zext i8 %298 to i32, !dbg !3437
  %sub.i.i1332 = sub nsw i32 32, %conv1.i.i1331, !dbg !3438
  %shr.i.i1333 = lshr i32 %297, %sub.i.i1332, !dbg !3439
  %or.i.i1334 = or i32 %shl.i.i1330, %shr.i.i1333, !dbg !3440
  %xor.i1335 = xor i32 %292, %or.i.i1334, !dbg !3441
  %299 = load i32, i32* %X.addr.i1320, align 4, !dbg !3442
  %shr5.i1336 = lshr i32 %299, 8, !dbg !3443
  %conv6.i1337 = trunc i32 %shr5.i1336 to i8, !dbg !3444
  %idxprom7.i1338 = zext i8 %conv6.i1337 to i64, !dbg !3445
  %arrayidx8.i1339 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1338, !dbg !3445
  %300 = load i32, i32* %arrayidx8.i1339, align 4, !dbg !3445
  store i32 %300, i32* %a.addr.i24.i1314, align 4
  store i8 16, i8* %n.addr.i25.i1315, align 1
  %301 = load i32, i32* %a.addr.i24.i1314, align 4, !dbg !3446
  %302 = load i8, i8* %n.addr.i25.i1315, align 1, !dbg !3447
  %conv.i26.i1340 = zext i8 %302 to i32, !dbg !3447
  %shl.i27.i1341 = shl i32 %301, %conv.i26.i1340, !dbg !3448
  %303 = load i32, i32* %a.addr.i24.i1314, align 4, !dbg !3449
  %304 = load i8, i8* %n.addr.i25.i1315, align 1, !dbg !3450
  %conv1.i28.i1342 = zext i8 %304 to i32, !dbg !3450
  %sub.i29.i1343 = sub nsw i32 32, %conv1.i28.i1342, !dbg !3451
  %shr.i30.i1344 = lshr i32 %303, %sub.i29.i1343, !dbg !3452
  %or.i31.i1345 = or i32 %shl.i27.i1341, %shr.i30.i1344, !dbg !3453
  %xor10.i1346 = xor i32 %xor.i1335, %or.i31.i1345, !dbg !3454
  %305 = load i32, i32* %X.addr.i1320, align 4, !dbg !3455
  %conv11.i1347 = trunc i32 %305 to i8, !dbg !3456
  %idxprom12.i1348 = zext i8 %conv11.i1347 to i64, !dbg !3457
  %arrayidx13.i1349 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1348, !dbg !3457
  %306 = load i32, i32* %arrayidx13.i1349, align 4, !dbg !3457
  store i32 %306, i32* %a.addr.i16.i1316, align 4
  store i8 8, i8* %n.addr.i17.i1317, align 1
  %307 = load i32, i32* %a.addr.i16.i1316, align 4, !dbg !3458
  %308 = load i8, i8* %n.addr.i17.i1317, align 1, !dbg !3459
  %conv.i18.i1350 = zext i8 %308 to i32, !dbg !3459
  %shl.i19.i1351 = shl i32 %307, %conv.i18.i1350, !dbg !3460
  %309 = load i32, i32* %a.addr.i16.i1316, align 4, !dbg !3461
  %310 = load i8, i8* %n.addr.i17.i1317, align 1, !dbg !3462
  %conv1.i20.i1352 = zext i8 %310 to i32, !dbg !3462
  %sub.i21.i1353 = sub nsw i32 32, %conv1.i20.i1352, !dbg !3463
  %shr.i22.i1354 = lshr i32 %309, %sub.i21.i1353, !dbg !3464
  %or.i23.i1355 = or i32 %shl.i19.i1351, %shr.i22.i1354, !dbg !3465
  %xor15.i1356 = xor i32 %xor10.i1346, %or.i23.i1355, !dbg !3466
  %311 = load i32, i32* %B3, align 4, !dbg !3298
  %xor57 = xor i32 %311, %xor15.i1356, !dbg !3298
  store i32 %xor57, i32* %B3, align 4, !dbg !3298
  br label %do.end58, !dbg !3298

do.end58:                                         ; preds = %do.body29
  br label %do.body59, !dbg !3467

do.body59:                                        ; preds = %do.end58
  %312 = load i32, i32* %B1, align 4, !dbg !3468
  %313 = load i32, i32* %B2, align 4, !dbg !3468
  %xor60 = xor i32 %312, %313, !dbg !3468
  %314 = load i32, i32* %B3, align 4, !dbg !3468
  %xor61 = xor i32 %xor60, %314, !dbg !3468
  %315 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3468
  %rk62 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %315, i32 0, i32 0, !dbg !3468
  %arrayidx63 = getelementptr inbounds [32 x i32], [32 x i32]* %rk62, i64 0, i64 23, !dbg !3468
  %316 = load i32, i32* %arrayidx63, align 4, !dbg !3468
  %xor64 = xor i32 %xor61, %316, !dbg !3468
  store i32 %xor64, i32* %X.addr.i1277, align 4
  %317 = load i32, i32* %X.addr.i1277, align 4, !dbg !3469
  %shr.i1278 = lshr i32 %317, 24, !dbg !3470
  %conv.i1279 = trunc i32 %shr.i1278 to i8, !dbg !3471
  %idxprom.i1280 = zext i8 %conv.i1279 to i64, !dbg !3472
  %arrayidx.i1281 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1280, !dbg !3472
  %318 = load i32, i32* %arrayidx.i1281, align 4, !dbg !3472
  %319 = load i32, i32* %X.addr.i1277, align 4, !dbg !3473
  %shr1.i1282 = lshr i32 %319, 16, !dbg !3474
  %conv2.i1283 = trunc i32 %shr1.i1282 to i8, !dbg !3475
  %idxprom3.i1284 = zext i8 %conv2.i1283 to i64, !dbg !3476
  %arrayidx4.i1285 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1284, !dbg !3476
  %320 = load i32, i32* %arrayidx4.i1285, align 4, !dbg !3476
  store i32 %320, i32* %a.addr.i.i1275, align 4
  store i8 24, i8* %n.addr.i.i1276, align 1
  %321 = load i32, i32* %a.addr.i.i1275, align 4, !dbg !3477
  %322 = load i8, i8* %n.addr.i.i1276, align 1, !dbg !3478
  %conv.i.i1286 = zext i8 %322 to i32, !dbg !3478
  %shl.i.i1287 = shl i32 %321, %conv.i.i1286, !dbg !3479
  %323 = load i32, i32* %a.addr.i.i1275, align 4, !dbg !3480
  %324 = load i8, i8* %n.addr.i.i1276, align 1, !dbg !3481
  %conv1.i.i1288 = zext i8 %324 to i32, !dbg !3481
  %sub.i.i1289 = sub nsw i32 32, %conv1.i.i1288, !dbg !3482
  %shr.i.i1290 = lshr i32 %323, %sub.i.i1289, !dbg !3483
  %or.i.i1291 = or i32 %shl.i.i1287, %shr.i.i1290, !dbg !3484
  %xor.i1292 = xor i32 %318, %or.i.i1291, !dbg !3485
  %325 = load i32, i32* %X.addr.i1277, align 4, !dbg !3486
  %shr5.i1293 = lshr i32 %325, 8, !dbg !3487
  %conv6.i1294 = trunc i32 %shr5.i1293 to i8, !dbg !3488
  %idxprom7.i1295 = zext i8 %conv6.i1294 to i64, !dbg !3489
  %arrayidx8.i1296 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1295, !dbg !3489
  %326 = load i32, i32* %arrayidx8.i1296, align 4, !dbg !3489
  store i32 %326, i32* %a.addr.i24.i1271, align 4
  store i8 16, i8* %n.addr.i25.i1272, align 1
  %327 = load i32, i32* %a.addr.i24.i1271, align 4, !dbg !3490
  %328 = load i8, i8* %n.addr.i25.i1272, align 1, !dbg !3491
  %conv.i26.i1297 = zext i8 %328 to i32, !dbg !3491
  %shl.i27.i1298 = shl i32 %327, %conv.i26.i1297, !dbg !3492
  %329 = load i32, i32* %a.addr.i24.i1271, align 4, !dbg !3493
  %330 = load i8, i8* %n.addr.i25.i1272, align 1, !dbg !3494
  %conv1.i28.i1299 = zext i8 %330 to i32, !dbg !3494
  %sub.i29.i1300 = sub nsw i32 32, %conv1.i28.i1299, !dbg !3495
  %shr.i30.i1301 = lshr i32 %329, %sub.i29.i1300, !dbg !3496
  %or.i31.i1302 = or i32 %shl.i27.i1298, %shr.i30.i1301, !dbg !3497
  %xor10.i1303 = xor i32 %xor.i1292, %or.i31.i1302, !dbg !3498
  %331 = load i32, i32* %X.addr.i1277, align 4, !dbg !3499
  %conv11.i1304 = trunc i32 %331 to i8, !dbg !3500
  %idxprom12.i1305 = zext i8 %conv11.i1304 to i64, !dbg !3501
  %arrayidx13.i1306 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1305, !dbg !3501
  %332 = load i32, i32* %arrayidx13.i1306, align 4, !dbg !3501
  store i32 %332, i32* %a.addr.i16.i1273, align 4
  store i8 8, i8* %n.addr.i17.i1274, align 1
  %333 = load i32, i32* %a.addr.i16.i1273, align 4, !dbg !3502
  %334 = load i8, i8* %n.addr.i17.i1274, align 1, !dbg !3503
  %conv.i18.i1307 = zext i8 %334 to i32, !dbg !3503
  %shl.i19.i1308 = shl i32 %333, %conv.i18.i1307, !dbg !3504
  %335 = load i32, i32* %a.addr.i16.i1273, align 4, !dbg !3505
  %336 = load i8, i8* %n.addr.i17.i1274, align 1, !dbg !3506
  %conv1.i20.i1309 = zext i8 %336 to i32, !dbg !3506
  %sub.i21.i1310 = sub nsw i32 32, %conv1.i20.i1309, !dbg !3507
  %shr.i22.i1311 = lshr i32 %335, %sub.i21.i1310, !dbg !3508
  %or.i23.i1312 = or i32 %shl.i19.i1308, %shr.i22.i1311, !dbg !3509
  %xor15.i1313 = xor i32 %xor10.i1303, %or.i23.i1312, !dbg !3510
  %337 = load i32, i32* %B0, align 4, !dbg !3468
  %xor66 = xor i32 %337, %xor15.i1313, !dbg !3468
  store i32 %xor66, i32* %B0, align 4, !dbg !3468
  %338 = load i32, i32* %B0, align 4, !dbg !3468
  %339 = load i32, i32* %B2, align 4, !dbg !3468
  %xor67 = xor i32 %338, %339, !dbg !3468
  %340 = load i32, i32* %B3, align 4, !dbg !3468
  %xor68 = xor i32 %xor67, %340, !dbg !3468
  %341 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3468
  %rk69 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %341, i32 0, i32 0, !dbg !3468
  %arrayidx70 = getelementptr inbounds [32 x i32], [32 x i32]* %rk69, i64 0, i64 22, !dbg !3468
  %342 = load i32, i32* %arrayidx70, align 4, !dbg !3468
  %xor71 = xor i32 %xor68, %342, !dbg !3468
  store i32 %xor71, i32* %X.addr.i1234, align 4
  %343 = load i32, i32* %X.addr.i1234, align 4, !dbg !3511
  %shr.i1235 = lshr i32 %343, 24, !dbg !3512
  %conv.i1236 = trunc i32 %shr.i1235 to i8, !dbg !3513
  %idxprom.i1237 = zext i8 %conv.i1236 to i64, !dbg !3514
  %arrayidx.i1238 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1237, !dbg !3514
  %344 = load i32, i32* %arrayidx.i1238, align 4, !dbg !3514
  %345 = load i32, i32* %X.addr.i1234, align 4, !dbg !3515
  %shr1.i1239 = lshr i32 %345, 16, !dbg !3516
  %conv2.i1240 = trunc i32 %shr1.i1239 to i8, !dbg !3517
  %idxprom3.i1241 = zext i8 %conv2.i1240 to i64, !dbg !3518
  %arrayidx4.i1242 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1241, !dbg !3518
  %346 = load i32, i32* %arrayidx4.i1242, align 4, !dbg !3518
  store i32 %346, i32* %a.addr.i.i1232, align 4
  store i8 24, i8* %n.addr.i.i1233, align 1
  %347 = load i32, i32* %a.addr.i.i1232, align 4, !dbg !3519
  %348 = load i8, i8* %n.addr.i.i1233, align 1, !dbg !3520
  %conv.i.i1243 = zext i8 %348 to i32, !dbg !3520
  %shl.i.i1244 = shl i32 %347, %conv.i.i1243, !dbg !3521
  %349 = load i32, i32* %a.addr.i.i1232, align 4, !dbg !3522
  %350 = load i8, i8* %n.addr.i.i1233, align 1, !dbg !3523
  %conv1.i.i1245 = zext i8 %350 to i32, !dbg !3523
  %sub.i.i1246 = sub nsw i32 32, %conv1.i.i1245, !dbg !3524
  %shr.i.i1247 = lshr i32 %349, %sub.i.i1246, !dbg !3525
  %or.i.i1248 = or i32 %shl.i.i1244, %shr.i.i1247, !dbg !3526
  %xor.i1249 = xor i32 %344, %or.i.i1248, !dbg !3527
  %351 = load i32, i32* %X.addr.i1234, align 4, !dbg !3528
  %shr5.i1250 = lshr i32 %351, 8, !dbg !3529
  %conv6.i1251 = trunc i32 %shr5.i1250 to i8, !dbg !3530
  %idxprom7.i1252 = zext i8 %conv6.i1251 to i64, !dbg !3531
  %arrayidx8.i1253 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1252, !dbg !3531
  %352 = load i32, i32* %arrayidx8.i1253, align 4, !dbg !3531
  store i32 %352, i32* %a.addr.i24.i1228, align 4
  store i8 16, i8* %n.addr.i25.i1229, align 1
  %353 = load i32, i32* %a.addr.i24.i1228, align 4, !dbg !3532
  %354 = load i8, i8* %n.addr.i25.i1229, align 1, !dbg !3533
  %conv.i26.i1254 = zext i8 %354 to i32, !dbg !3533
  %shl.i27.i1255 = shl i32 %353, %conv.i26.i1254, !dbg !3534
  %355 = load i32, i32* %a.addr.i24.i1228, align 4, !dbg !3535
  %356 = load i8, i8* %n.addr.i25.i1229, align 1, !dbg !3536
  %conv1.i28.i1256 = zext i8 %356 to i32, !dbg !3536
  %sub.i29.i1257 = sub nsw i32 32, %conv1.i28.i1256, !dbg !3537
  %shr.i30.i1258 = lshr i32 %355, %sub.i29.i1257, !dbg !3538
  %or.i31.i1259 = or i32 %shl.i27.i1255, %shr.i30.i1258, !dbg !3539
  %xor10.i1260 = xor i32 %xor.i1249, %or.i31.i1259, !dbg !3540
  %357 = load i32, i32* %X.addr.i1234, align 4, !dbg !3541
  %conv11.i1261 = trunc i32 %357 to i8, !dbg !3542
  %idxprom12.i1262 = zext i8 %conv11.i1261 to i64, !dbg !3543
  %arrayidx13.i1263 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1262, !dbg !3543
  %358 = load i32, i32* %arrayidx13.i1263, align 4, !dbg !3543
  store i32 %358, i32* %a.addr.i16.i1230, align 4
  store i8 8, i8* %n.addr.i17.i1231, align 1
  %359 = load i32, i32* %a.addr.i16.i1230, align 4, !dbg !3544
  %360 = load i8, i8* %n.addr.i17.i1231, align 1, !dbg !3545
  %conv.i18.i1264 = zext i8 %360 to i32, !dbg !3545
  %shl.i19.i1265 = shl i32 %359, %conv.i18.i1264, !dbg !3546
  %361 = load i32, i32* %a.addr.i16.i1230, align 4, !dbg !3547
  %362 = load i8, i8* %n.addr.i17.i1231, align 1, !dbg !3548
  %conv1.i20.i1266 = zext i8 %362 to i32, !dbg !3548
  %sub.i21.i1267 = sub nsw i32 32, %conv1.i20.i1266, !dbg !3549
  %shr.i22.i1268 = lshr i32 %361, %sub.i21.i1267, !dbg !3550
  %or.i23.i1269 = or i32 %shl.i19.i1265, %shr.i22.i1268, !dbg !3551
  %xor15.i1270 = xor i32 %xor10.i1260, %or.i23.i1269, !dbg !3552
  %363 = load i32, i32* %B1, align 4, !dbg !3468
  %xor73 = xor i32 %363, %xor15.i1270, !dbg !3468
  store i32 %xor73, i32* %B1, align 4, !dbg !3468
  %364 = load i32, i32* %B0, align 4, !dbg !3468
  %365 = load i32, i32* %B1, align 4, !dbg !3468
  %xor74 = xor i32 %364, %365, !dbg !3468
  %366 = load i32, i32* %B3, align 4, !dbg !3468
  %xor75 = xor i32 %xor74, %366, !dbg !3468
  %367 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3468
  %rk76 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %367, i32 0, i32 0, !dbg !3468
  %arrayidx77 = getelementptr inbounds [32 x i32], [32 x i32]* %rk76, i64 0, i64 21, !dbg !3468
  %368 = load i32, i32* %arrayidx77, align 4, !dbg !3468
  %xor78 = xor i32 %xor75, %368, !dbg !3468
  store i32 %xor78, i32* %X.addr.i1191, align 4
  %369 = load i32, i32* %X.addr.i1191, align 4, !dbg !3553
  %shr.i1192 = lshr i32 %369, 24, !dbg !3554
  %conv.i1193 = trunc i32 %shr.i1192 to i8, !dbg !3555
  %idxprom.i1194 = zext i8 %conv.i1193 to i64, !dbg !3556
  %arrayidx.i1195 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1194, !dbg !3556
  %370 = load i32, i32* %arrayidx.i1195, align 4, !dbg !3556
  %371 = load i32, i32* %X.addr.i1191, align 4, !dbg !3557
  %shr1.i1196 = lshr i32 %371, 16, !dbg !3558
  %conv2.i1197 = trunc i32 %shr1.i1196 to i8, !dbg !3559
  %idxprom3.i1198 = zext i8 %conv2.i1197 to i64, !dbg !3560
  %arrayidx4.i1199 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1198, !dbg !3560
  %372 = load i32, i32* %arrayidx4.i1199, align 4, !dbg !3560
  store i32 %372, i32* %a.addr.i.i1189, align 4
  store i8 24, i8* %n.addr.i.i1190, align 1
  %373 = load i32, i32* %a.addr.i.i1189, align 4, !dbg !3561
  %374 = load i8, i8* %n.addr.i.i1190, align 1, !dbg !3562
  %conv.i.i1200 = zext i8 %374 to i32, !dbg !3562
  %shl.i.i1201 = shl i32 %373, %conv.i.i1200, !dbg !3563
  %375 = load i32, i32* %a.addr.i.i1189, align 4, !dbg !3564
  %376 = load i8, i8* %n.addr.i.i1190, align 1, !dbg !3565
  %conv1.i.i1202 = zext i8 %376 to i32, !dbg !3565
  %sub.i.i1203 = sub nsw i32 32, %conv1.i.i1202, !dbg !3566
  %shr.i.i1204 = lshr i32 %375, %sub.i.i1203, !dbg !3567
  %or.i.i1205 = or i32 %shl.i.i1201, %shr.i.i1204, !dbg !3568
  %xor.i1206 = xor i32 %370, %or.i.i1205, !dbg !3569
  %377 = load i32, i32* %X.addr.i1191, align 4, !dbg !3570
  %shr5.i1207 = lshr i32 %377, 8, !dbg !3571
  %conv6.i1208 = trunc i32 %shr5.i1207 to i8, !dbg !3572
  %idxprom7.i1209 = zext i8 %conv6.i1208 to i64, !dbg !3573
  %arrayidx8.i1210 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1209, !dbg !3573
  %378 = load i32, i32* %arrayidx8.i1210, align 4, !dbg !3573
  store i32 %378, i32* %a.addr.i24.i1185, align 4
  store i8 16, i8* %n.addr.i25.i1186, align 1
  %379 = load i32, i32* %a.addr.i24.i1185, align 4, !dbg !3574
  %380 = load i8, i8* %n.addr.i25.i1186, align 1, !dbg !3575
  %conv.i26.i1211 = zext i8 %380 to i32, !dbg !3575
  %shl.i27.i1212 = shl i32 %379, %conv.i26.i1211, !dbg !3576
  %381 = load i32, i32* %a.addr.i24.i1185, align 4, !dbg !3577
  %382 = load i8, i8* %n.addr.i25.i1186, align 1, !dbg !3578
  %conv1.i28.i1213 = zext i8 %382 to i32, !dbg !3578
  %sub.i29.i1214 = sub nsw i32 32, %conv1.i28.i1213, !dbg !3579
  %shr.i30.i1215 = lshr i32 %381, %sub.i29.i1214, !dbg !3580
  %or.i31.i1216 = or i32 %shl.i27.i1212, %shr.i30.i1215, !dbg !3581
  %xor10.i1217 = xor i32 %xor.i1206, %or.i31.i1216, !dbg !3582
  %383 = load i32, i32* %X.addr.i1191, align 4, !dbg !3583
  %conv11.i1218 = trunc i32 %383 to i8, !dbg !3584
  %idxprom12.i1219 = zext i8 %conv11.i1218 to i64, !dbg !3585
  %arrayidx13.i1220 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1219, !dbg !3585
  %384 = load i32, i32* %arrayidx13.i1220, align 4, !dbg !3585
  store i32 %384, i32* %a.addr.i16.i1187, align 4
  store i8 8, i8* %n.addr.i17.i1188, align 1
  %385 = load i32, i32* %a.addr.i16.i1187, align 4, !dbg !3586
  %386 = load i8, i8* %n.addr.i17.i1188, align 1, !dbg !3587
  %conv.i18.i1221 = zext i8 %386 to i32, !dbg !3587
  %shl.i19.i1222 = shl i32 %385, %conv.i18.i1221, !dbg !3588
  %387 = load i32, i32* %a.addr.i16.i1187, align 4, !dbg !3589
  %388 = load i8, i8* %n.addr.i17.i1188, align 1, !dbg !3590
  %conv1.i20.i1223 = zext i8 %388 to i32, !dbg !3590
  %sub.i21.i1224 = sub nsw i32 32, %conv1.i20.i1223, !dbg !3591
  %shr.i22.i1225 = lshr i32 %387, %sub.i21.i1224, !dbg !3592
  %or.i23.i1226 = or i32 %shl.i19.i1222, %shr.i22.i1225, !dbg !3593
  %xor15.i1227 = xor i32 %xor10.i1217, %or.i23.i1226, !dbg !3594
  %389 = load i32, i32* %B2, align 4, !dbg !3468
  %xor80 = xor i32 %389, %xor15.i1227, !dbg !3468
  store i32 %xor80, i32* %B2, align 4, !dbg !3468
  %390 = load i32, i32* %B0, align 4, !dbg !3468
  %391 = load i32, i32* %B1, align 4, !dbg !3468
  %xor81 = xor i32 %390, %391, !dbg !3468
  %392 = load i32, i32* %B2, align 4, !dbg !3468
  %xor82 = xor i32 %xor81, %392, !dbg !3468
  %393 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3468
  %rk83 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %393, i32 0, i32 0, !dbg !3468
  %arrayidx84 = getelementptr inbounds [32 x i32], [32 x i32]* %rk83, i64 0, i64 20, !dbg !3468
  %394 = load i32, i32* %arrayidx84, align 4, !dbg !3468
  %xor85 = xor i32 %xor82, %394, !dbg !3468
  store i32 %xor85, i32* %X.addr.i1148, align 4
  %395 = load i32, i32* %X.addr.i1148, align 4, !dbg !3595
  %shr.i1149 = lshr i32 %395, 24, !dbg !3596
  %conv.i1150 = trunc i32 %shr.i1149 to i8, !dbg !3597
  %idxprom.i1151 = zext i8 %conv.i1150 to i64, !dbg !3598
  %arrayidx.i1152 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1151, !dbg !3598
  %396 = load i32, i32* %arrayidx.i1152, align 4, !dbg !3598
  %397 = load i32, i32* %X.addr.i1148, align 4, !dbg !3599
  %shr1.i1153 = lshr i32 %397, 16, !dbg !3600
  %conv2.i1154 = trunc i32 %shr1.i1153 to i8, !dbg !3601
  %idxprom3.i1155 = zext i8 %conv2.i1154 to i64, !dbg !3602
  %arrayidx4.i1156 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1155, !dbg !3602
  %398 = load i32, i32* %arrayidx4.i1156, align 4, !dbg !3602
  store i32 %398, i32* %a.addr.i.i1146, align 4
  store i8 24, i8* %n.addr.i.i1147, align 1
  %399 = load i32, i32* %a.addr.i.i1146, align 4, !dbg !3603
  %400 = load i8, i8* %n.addr.i.i1147, align 1, !dbg !3604
  %conv.i.i1157 = zext i8 %400 to i32, !dbg !3604
  %shl.i.i1158 = shl i32 %399, %conv.i.i1157, !dbg !3605
  %401 = load i32, i32* %a.addr.i.i1146, align 4, !dbg !3606
  %402 = load i8, i8* %n.addr.i.i1147, align 1, !dbg !3607
  %conv1.i.i1159 = zext i8 %402 to i32, !dbg !3607
  %sub.i.i1160 = sub nsw i32 32, %conv1.i.i1159, !dbg !3608
  %shr.i.i1161 = lshr i32 %401, %sub.i.i1160, !dbg !3609
  %or.i.i1162 = or i32 %shl.i.i1158, %shr.i.i1161, !dbg !3610
  %xor.i1163 = xor i32 %396, %or.i.i1162, !dbg !3611
  %403 = load i32, i32* %X.addr.i1148, align 4, !dbg !3612
  %shr5.i1164 = lshr i32 %403, 8, !dbg !3613
  %conv6.i1165 = trunc i32 %shr5.i1164 to i8, !dbg !3614
  %idxprom7.i1166 = zext i8 %conv6.i1165 to i64, !dbg !3615
  %arrayidx8.i1167 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1166, !dbg !3615
  %404 = load i32, i32* %arrayidx8.i1167, align 4, !dbg !3615
  store i32 %404, i32* %a.addr.i24.i1142, align 4
  store i8 16, i8* %n.addr.i25.i1143, align 1
  %405 = load i32, i32* %a.addr.i24.i1142, align 4, !dbg !3616
  %406 = load i8, i8* %n.addr.i25.i1143, align 1, !dbg !3617
  %conv.i26.i1168 = zext i8 %406 to i32, !dbg !3617
  %shl.i27.i1169 = shl i32 %405, %conv.i26.i1168, !dbg !3618
  %407 = load i32, i32* %a.addr.i24.i1142, align 4, !dbg !3619
  %408 = load i8, i8* %n.addr.i25.i1143, align 1, !dbg !3620
  %conv1.i28.i1170 = zext i8 %408 to i32, !dbg !3620
  %sub.i29.i1171 = sub nsw i32 32, %conv1.i28.i1170, !dbg !3621
  %shr.i30.i1172 = lshr i32 %407, %sub.i29.i1171, !dbg !3622
  %or.i31.i1173 = or i32 %shl.i27.i1169, %shr.i30.i1172, !dbg !3623
  %xor10.i1174 = xor i32 %xor.i1163, %or.i31.i1173, !dbg !3624
  %409 = load i32, i32* %X.addr.i1148, align 4, !dbg !3625
  %conv11.i1175 = trunc i32 %409 to i8, !dbg !3626
  %idxprom12.i1176 = zext i8 %conv11.i1175 to i64, !dbg !3627
  %arrayidx13.i1177 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1176, !dbg !3627
  %410 = load i32, i32* %arrayidx13.i1177, align 4, !dbg !3627
  store i32 %410, i32* %a.addr.i16.i1144, align 4
  store i8 8, i8* %n.addr.i17.i1145, align 1
  %411 = load i32, i32* %a.addr.i16.i1144, align 4, !dbg !3628
  %412 = load i8, i8* %n.addr.i17.i1145, align 1, !dbg !3629
  %conv.i18.i1178 = zext i8 %412 to i32, !dbg !3629
  %shl.i19.i1179 = shl i32 %411, %conv.i18.i1178, !dbg !3630
  %413 = load i32, i32* %a.addr.i16.i1144, align 4, !dbg !3631
  %414 = load i8, i8* %n.addr.i17.i1145, align 1, !dbg !3632
  %conv1.i20.i1180 = zext i8 %414 to i32, !dbg !3632
  %sub.i21.i1181 = sub nsw i32 32, %conv1.i20.i1180, !dbg !3633
  %shr.i22.i1182 = lshr i32 %413, %sub.i21.i1181, !dbg !3634
  %or.i23.i1183 = or i32 %shl.i19.i1179, %shr.i22.i1182, !dbg !3635
  %xor15.i1184 = xor i32 %xor10.i1174, %or.i23.i1183, !dbg !3636
  %415 = load i32, i32* %B3, align 4, !dbg !3468
  %xor87 = xor i32 %415, %xor15.i1184, !dbg !3468
  store i32 %xor87, i32* %B3, align 4, !dbg !3468
  br label %do.end88, !dbg !3468

do.end88:                                         ; preds = %do.body59
  br label %do.body89, !dbg !3637

do.body89:                                        ; preds = %do.end88
  %416 = load i32, i32* %B1, align 4, !dbg !3638
  %417 = load i32, i32* %B2, align 4, !dbg !3638
  %xor90 = xor i32 %416, %417, !dbg !3638
  %418 = load i32, i32* %B3, align 4, !dbg !3638
  %xor91 = xor i32 %xor90, %418, !dbg !3638
  %419 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3638
  %rk92 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %419, i32 0, i32 0, !dbg !3638
  %arrayidx93 = getelementptr inbounds [32 x i32], [32 x i32]* %rk92, i64 0, i64 19, !dbg !3638
  %420 = load i32, i32* %arrayidx93, align 4, !dbg !3638
  %xor94 = xor i32 %xor91, %420, !dbg !3638
  store i32 %xor94, i32* %X.addr.i1105, align 4
  %421 = load i32, i32* %X.addr.i1105, align 4, !dbg !3639
  %shr.i1106 = lshr i32 %421, 24, !dbg !3640
  %conv.i1107 = trunc i32 %shr.i1106 to i8, !dbg !3641
  %idxprom.i1108 = zext i8 %conv.i1107 to i64, !dbg !3642
  %arrayidx.i1109 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1108, !dbg !3642
  %422 = load i32, i32* %arrayidx.i1109, align 4, !dbg !3642
  %423 = load i32, i32* %X.addr.i1105, align 4, !dbg !3643
  %shr1.i1110 = lshr i32 %423, 16, !dbg !3644
  %conv2.i1111 = trunc i32 %shr1.i1110 to i8, !dbg !3645
  %idxprom3.i1112 = zext i8 %conv2.i1111 to i64, !dbg !3646
  %arrayidx4.i1113 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1112, !dbg !3646
  %424 = load i32, i32* %arrayidx4.i1113, align 4, !dbg !3646
  store i32 %424, i32* %a.addr.i.i1103, align 4
  store i8 24, i8* %n.addr.i.i1104, align 1
  %425 = load i32, i32* %a.addr.i.i1103, align 4, !dbg !3647
  %426 = load i8, i8* %n.addr.i.i1104, align 1, !dbg !3648
  %conv.i.i1114 = zext i8 %426 to i32, !dbg !3648
  %shl.i.i1115 = shl i32 %425, %conv.i.i1114, !dbg !3649
  %427 = load i32, i32* %a.addr.i.i1103, align 4, !dbg !3650
  %428 = load i8, i8* %n.addr.i.i1104, align 1, !dbg !3651
  %conv1.i.i1116 = zext i8 %428 to i32, !dbg !3651
  %sub.i.i1117 = sub nsw i32 32, %conv1.i.i1116, !dbg !3652
  %shr.i.i1118 = lshr i32 %427, %sub.i.i1117, !dbg !3653
  %or.i.i1119 = or i32 %shl.i.i1115, %shr.i.i1118, !dbg !3654
  %xor.i1120 = xor i32 %422, %or.i.i1119, !dbg !3655
  %429 = load i32, i32* %X.addr.i1105, align 4, !dbg !3656
  %shr5.i1121 = lshr i32 %429, 8, !dbg !3657
  %conv6.i1122 = trunc i32 %shr5.i1121 to i8, !dbg !3658
  %idxprom7.i1123 = zext i8 %conv6.i1122 to i64, !dbg !3659
  %arrayidx8.i1124 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1123, !dbg !3659
  %430 = load i32, i32* %arrayidx8.i1124, align 4, !dbg !3659
  store i32 %430, i32* %a.addr.i24.i1099, align 4
  store i8 16, i8* %n.addr.i25.i1100, align 1
  %431 = load i32, i32* %a.addr.i24.i1099, align 4, !dbg !3660
  %432 = load i8, i8* %n.addr.i25.i1100, align 1, !dbg !3661
  %conv.i26.i1125 = zext i8 %432 to i32, !dbg !3661
  %shl.i27.i1126 = shl i32 %431, %conv.i26.i1125, !dbg !3662
  %433 = load i32, i32* %a.addr.i24.i1099, align 4, !dbg !3663
  %434 = load i8, i8* %n.addr.i25.i1100, align 1, !dbg !3664
  %conv1.i28.i1127 = zext i8 %434 to i32, !dbg !3664
  %sub.i29.i1128 = sub nsw i32 32, %conv1.i28.i1127, !dbg !3665
  %shr.i30.i1129 = lshr i32 %433, %sub.i29.i1128, !dbg !3666
  %or.i31.i1130 = or i32 %shl.i27.i1126, %shr.i30.i1129, !dbg !3667
  %xor10.i1131 = xor i32 %xor.i1120, %or.i31.i1130, !dbg !3668
  %435 = load i32, i32* %X.addr.i1105, align 4, !dbg !3669
  %conv11.i1132 = trunc i32 %435 to i8, !dbg !3670
  %idxprom12.i1133 = zext i8 %conv11.i1132 to i64, !dbg !3671
  %arrayidx13.i1134 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1133, !dbg !3671
  %436 = load i32, i32* %arrayidx13.i1134, align 4, !dbg !3671
  store i32 %436, i32* %a.addr.i16.i1101, align 4
  store i8 8, i8* %n.addr.i17.i1102, align 1
  %437 = load i32, i32* %a.addr.i16.i1101, align 4, !dbg !3672
  %438 = load i8, i8* %n.addr.i17.i1102, align 1, !dbg !3673
  %conv.i18.i1135 = zext i8 %438 to i32, !dbg !3673
  %shl.i19.i1136 = shl i32 %437, %conv.i18.i1135, !dbg !3674
  %439 = load i32, i32* %a.addr.i16.i1101, align 4, !dbg !3675
  %440 = load i8, i8* %n.addr.i17.i1102, align 1, !dbg !3676
  %conv1.i20.i1137 = zext i8 %440 to i32, !dbg !3676
  %sub.i21.i1138 = sub nsw i32 32, %conv1.i20.i1137, !dbg !3677
  %shr.i22.i1139 = lshr i32 %439, %sub.i21.i1138, !dbg !3678
  %or.i23.i1140 = or i32 %shl.i19.i1136, %shr.i22.i1139, !dbg !3679
  %xor15.i1141 = xor i32 %xor10.i1131, %or.i23.i1140, !dbg !3680
  %441 = load i32, i32* %B0, align 4, !dbg !3638
  %xor96 = xor i32 %441, %xor15.i1141, !dbg !3638
  store i32 %xor96, i32* %B0, align 4, !dbg !3638
  %442 = load i32, i32* %B0, align 4, !dbg !3638
  %443 = load i32, i32* %B2, align 4, !dbg !3638
  %xor97 = xor i32 %442, %443, !dbg !3638
  %444 = load i32, i32* %B3, align 4, !dbg !3638
  %xor98 = xor i32 %xor97, %444, !dbg !3638
  %445 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3638
  %rk99 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %445, i32 0, i32 0, !dbg !3638
  %arrayidx100 = getelementptr inbounds [32 x i32], [32 x i32]* %rk99, i64 0, i64 18, !dbg !3638
  %446 = load i32, i32* %arrayidx100, align 4, !dbg !3638
  %xor101 = xor i32 %xor98, %446, !dbg !3638
  store i32 %xor101, i32* %X.addr.i1062, align 4
  %447 = load i32, i32* %X.addr.i1062, align 4, !dbg !3681
  %shr.i1063 = lshr i32 %447, 24, !dbg !3682
  %conv.i1064 = trunc i32 %shr.i1063 to i8, !dbg !3683
  %idxprom.i1065 = zext i8 %conv.i1064 to i64, !dbg !3684
  %arrayidx.i1066 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1065, !dbg !3684
  %448 = load i32, i32* %arrayidx.i1066, align 4, !dbg !3684
  %449 = load i32, i32* %X.addr.i1062, align 4, !dbg !3685
  %shr1.i1067 = lshr i32 %449, 16, !dbg !3686
  %conv2.i1068 = trunc i32 %shr1.i1067 to i8, !dbg !3687
  %idxprom3.i1069 = zext i8 %conv2.i1068 to i64, !dbg !3688
  %arrayidx4.i1070 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1069, !dbg !3688
  %450 = load i32, i32* %arrayidx4.i1070, align 4, !dbg !3688
  store i32 %450, i32* %a.addr.i.i1060, align 4
  store i8 24, i8* %n.addr.i.i1061, align 1
  %451 = load i32, i32* %a.addr.i.i1060, align 4, !dbg !3689
  %452 = load i8, i8* %n.addr.i.i1061, align 1, !dbg !3690
  %conv.i.i1071 = zext i8 %452 to i32, !dbg !3690
  %shl.i.i1072 = shl i32 %451, %conv.i.i1071, !dbg !3691
  %453 = load i32, i32* %a.addr.i.i1060, align 4, !dbg !3692
  %454 = load i8, i8* %n.addr.i.i1061, align 1, !dbg !3693
  %conv1.i.i1073 = zext i8 %454 to i32, !dbg !3693
  %sub.i.i1074 = sub nsw i32 32, %conv1.i.i1073, !dbg !3694
  %shr.i.i1075 = lshr i32 %453, %sub.i.i1074, !dbg !3695
  %or.i.i1076 = or i32 %shl.i.i1072, %shr.i.i1075, !dbg !3696
  %xor.i1077 = xor i32 %448, %or.i.i1076, !dbg !3697
  %455 = load i32, i32* %X.addr.i1062, align 4, !dbg !3698
  %shr5.i1078 = lshr i32 %455, 8, !dbg !3699
  %conv6.i1079 = trunc i32 %shr5.i1078 to i8, !dbg !3700
  %idxprom7.i1080 = zext i8 %conv6.i1079 to i64, !dbg !3701
  %arrayidx8.i1081 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1080, !dbg !3701
  %456 = load i32, i32* %arrayidx8.i1081, align 4, !dbg !3701
  store i32 %456, i32* %a.addr.i24.i1056, align 4
  store i8 16, i8* %n.addr.i25.i1057, align 1
  %457 = load i32, i32* %a.addr.i24.i1056, align 4, !dbg !3702
  %458 = load i8, i8* %n.addr.i25.i1057, align 1, !dbg !3703
  %conv.i26.i1082 = zext i8 %458 to i32, !dbg !3703
  %shl.i27.i1083 = shl i32 %457, %conv.i26.i1082, !dbg !3704
  %459 = load i32, i32* %a.addr.i24.i1056, align 4, !dbg !3705
  %460 = load i8, i8* %n.addr.i25.i1057, align 1, !dbg !3706
  %conv1.i28.i1084 = zext i8 %460 to i32, !dbg !3706
  %sub.i29.i1085 = sub nsw i32 32, %conv1.i28.i1084, !dbg !3707
  %shr.i30.i1086 = lshr i32 %459, %sub.i29.i1085, !dbg !3708
  %or.i31.i1087 = or i32 %shl.i27.i1083, %shr.i30.i1086, !dbg !3709
  %xor10.i1088 = xor i32 %xor.i1077, %or.i31.i1087, !dbg !3710
  %461 = load i32, i32* %X.addr.i1062, align 4, !dbg !3711
  %conv11.i1089 = trunc i32 %461 to i8, !dbg !3712
  %idxprom12.i1090 = zext i8 %conv11.i1089 to i64, !dbg !3713
  %arrayidx13.i1091 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1090, !dbg !3713
  %462 = load i32, i32* %arrayidx13.i1091, align 4, !dbg !3713
  store i32 %462, i32* %a.addr.i16.i1058, align 4
  store i8 8, i8* %n.addr.i17.i1059, align 1
  %463 = load i32, i32* %a.addr.i16.i1058, align 4, !dbg !3714
  %464 = load i8, i8* %n.addr.i17.i1059, align 1, !dbg !3715
  %conv.i18.i1092 = zext i8 %464 to i32, !dbg !3715
  %shl.i19.i1093 = shl i32 %463, %conv.i18.i1092, !dbg !3716
  %465 = load i32, i32* %a.addr.i16.i1058, align 4, !dbg !3717
  %466 = load i8, i8* %n.addr.i17.i1059, align 1, !dbg !3718
  %conv1.i20.i1094 = zext i8 %466 to i32, !dbg !3718
  %sub.i21.i1095 = sub nsw i32 32, %conv1.i20.i1094, !dbg !3719
  %shr.i22.i1096 = lshr i32 %465, %sub.i21.i1095, !dbg !3720
  %or.i23.i1097 = or i32 %shl.i19.i1093, %shr.i22.i1096, !dbg !3721
  %xor15.i1098 = xor i32 %xor10.i1088, %or.i23.i1097, !dbg !3722
  %467 = load i32, i32* %B1, align 4, !dbg !3638
  %xor103 = xor i32 %467, %xor15.i1098, !dbg !3638
  store i32 %xor103, i32* %B1, align 4, !dbg !3638
  %468 = load i32, i32* %B0, align 4, !dbg !3638
  %469 = load i32, i32* %B1, align 4, !dbg !3638
  %xor104 = xor i32 %468, %469, !dbg !3638
  %470 = load i32, i32* %B3, align 4, !dbg !3638
  %xor105 = xor i32 %xor104, %470, !dbg !3638
  %471 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3638
  %rk106 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %471, i32 0, i32 0, !dbg !3638
  %arrayidx107 = getelementptr inbounds [32 x i32], [32 x i32]* %rk106, i64 0, i64 17, !dbg !3638
  %472 = load i32, i32* %arrayidx107, align 4, !dbg !3638
  %xor108 = xor i32 %xor105, %472, !dbg !3638
  store i32 %xor108, i32* %X.addr.i1019, align 4
  %473 = load i32, i32* %X.addr.i1019, align 4, !dbg !3723
  %shr.i1020 = lshr i32 %473, 24, !dbg !3724
  %conv.i1021 = trunc i32 %shr.i1020 to i8, !dbg !3725
  %idxprom.i1022 = zext i8 %conv.i1021 to i64, !dbg !3726
  %arrayidx.i1023 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1022, !dbg !3726
  %474 = load i32, i32* %arrayidx.i1023, align 4, !dbg !3726
  %475 = load i32, i32* %X.addr.i1019, align 4, !dbg !3727
  %shr1.i1024 = lshr i32 %475, 16, !dbg !3728
  %conv2.i1025 = trunc i32 %shr1.i1024 to i8, !dbg !3729
  %idxprom3.i1026 = zext i8 %conv2.i1025 to i64, !dbg !3730
  %arrayidx4.i1027 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1026, !dbg !3730
  %476 = load i32, i32* %arrayidx4.i1027, align 4, !dbg !3730
  store i32 %476, i32* %a.addr.i.i1017, align 4
  store i8 24, i8* %n.addr.i.i1018, align 1
  %477 = load i32, i32* %a.addr.i.i1017, align 4, !dbg !3731
  %478 = load i8, i8* %n.addr.i.i1018, align 1, !dbg !3732
  %conv.i.i1028 = zext i8 %478 to i32, !dbg !3732
  %shl.i.i1029 = shl i32 %477, %conv.i.i1028, !dbg !3733
  %479 = load i32, i32* %a.addr.i.i1017, align 4, !dbg !3734
  %480 = load i8, i8* %n.addr.i.i1018, align 1, !dbg !3735
  %conv1.i.i1030 = zext i8 %480 to i32, !dbg !3735
  %sub.i.i1031 = sub nsw i32 32, %conv1.i.i1030, !dbg !3736
  %shr.i.i1032 = lshr i32 %479, %sub.i.i1031, !dbg !3737
  %or.i.i1033 = or i32 %shl.i.i1029, %shr.i.i1032, !dbg !3738
  %xor.i1034 = xor i32 %474, %or.i.i1033, !dbg !3739
  %481 = load i32, i32* %X.addr.i1019, align 4, !dbg !3740
  %shr5.i1035 = lshr i32 %481, 8, !dbg !3741
  %conv6.i1036 = trunc i32 %shr5.i1035 to i8, !dbg !3742
  %idxprom7.i1037 = zext i8 %conv6.i1036 to i64, !dbg !3743
  %arrayidx8.i1038 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1037, !dbg !3743
  %482 = load i32, i32* %arrayidx8.i1038, align 4, !dbg !3743
  store i32 %482, i32* %a.addr.i24.i1013, align 4
  store i8 16, i8* %n.addr.i25.i1014, align 1
  %483 = load i32, i32* %a.addr.i24.i1013, align 4, !dbg !3744
  %484 = load i8, i8* %n.addr.i25.i1014, align 1, !dbg !3745
  %conv.i26.i1039 = zext i8 %484 to i32, !dbg !3745
  %shl.i27.i1040 = shl i32 %483, %conv.i26.i1039, !dbg !3746
  %485 = load i32, i32* %a.addr.i24.i1013, align 4, !dbg !3747
  %486 = load i8, i8* %n.addr.i25.i1014, align 1, !dbg !3748
  %conv1.i28.i1041 = zext i8 %486 to i32, !dbg !3748
  %sub.i29.i1042 = sub nsw i32 32, %conv1.i28.i1041, !dbg !3749
  %shr.i30.i1043 = lshr i32 %485, %sub.i29.i1042, !dbg !3750
  %or.i31.i1044 = or i32 %shl.i27.i1040, %shr.i30.i1043, !dbg !3751
  %xor10.i1045 = xor i32 %xor.i1034, %or.i31.i1044, !dbg !3752
  %487 = load i32, i32* %X.addr.i1019, align 4, !dbg !3753
  %conv11.i1046 = trunc i32 %487 to i8, !dbg !3754
  %idxprom12.i1047 = zext i8 %conv11.i1046 to i64, !dbg !3755
  %arrayidx13.i1048 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1047, !dbg !3755
  %488 = load i32, i32* %arrayidx13.i1048, align 4, !dbg !3755
  store i32 %488, i32* %a.addr.i16.i1015, align 4
  store i8 8, i8* %n.addr.i17.i1016, align 1
  %489 = load i32, i32* %a.addr.i16.i1015, align 4, !dbg !3756
  %490 = load i8, i8* %n.addr.i17.i1016, align 1, !dbg !3757
  %conv.i18.i1049 = zext i8 %490 to i32, !dbg !3757
  %shl.i19.i1050 = shl i32 %489, %conv.i18.i1049, !dbg !3758
  %491 = load i32, i32* %a.addr.i16.i1015, align 4, !dbg !3759
  %492 = load i8, i8* %n.addr.i17.i1016, align 1, !dbg !3760
  %conv1.i20.i1051 = zext i8 %492 to i32, !dbg !3760
  %sub.i21.i1052 = sub nsw i32 32, %conv1.i20.i1051, !dbg !3761
  %shr.i22.i1053 = lshr i32 %491, %sub.i21.i1052, !dbg !3762
  %or.i23.i1054 = or i32 %shl.i19.i1050, %shr.i22.i1053, !dbg !3763
  %xor15.i1055 = xor i32 %xor10.i1045, %or.i23.i1054, !dbg !3764
  %493 = load i32, i32* %B2, align 4, !dbg !3638
  %xor110 = xor i32 %493, %xor15.i1055, !dbg !3638
  store i32 %xor110, i32* %B2, align 4, !dbg !3638
  %494 = load i32, i32* %B0, align 4, !dbg !3638
  %495 = load i32, i32* %B1, align 4, !dbg !3638
  %xor111 = xor i32 %494, %495, !dbg !3638
  %496 = load i32, i32* %B2, align 4, !dbg !3638
  %xor112 = xor i32 %xor111, %496, !dbg !3638
  %497 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3638
  %rk113 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %497, i32 0, i32 0, !dbg !3638
  %arrayidx114 = getelementptr inbounds [32 x i32], [32 x i32]* %rk113, i64 0, i64 16, !dbg !3638
  %498 = load i32, i32* %arrayidx114, align 4, !dbg !3638
  %xor115 = xor i32 %xor112, %498, !dbg !3638
  store i32 %xor115, i32* %X.addr.i976, align 4
  %499 = load i32, i32* %X.addr.i976, align 4, !dbg !3765
  %shr.i977 = lshr i32 %499, 24, !dbg !3766
  %conv.i978 = trunc i32 %shr.i977 to i8, !dbg !3767
  %idxprom.i979 = zext i8 %conv.i978 to i64, !dbg !3768
  %arrayidx.i980 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i979, !dbg !3768
  %500 = load i32, i32* %arrayidx.i980, align 4, !dbg !3768
  %501 = load i32, i32* %X.addr.i976, align 4, !dbg !3769
  %shr1.i981 = lshr i32 %501, 16, !dbg !3770
  %conv2.i982 = trunc i32 %shr1.i981 to i8, !dbg !3771
  %idxprom3.i983 = zext i8 %conv2.i982 to i64, !dbg !3772
  %arrayidx4.i984 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i983, !dbg !3772
  %502 = load i32, i32* %arrayidx4.i984, align 4, !dbg !3772
  store i32 %502, i32* %a.addr.i.i974, align 4
  store i8 24, i8* %n.addr.i.i975, align 1
  %503 = load i32, i32* %a.addr.i.i974, align 4, !dbg !3773
  %504 = load i8, i8* %n.addr.i.i975, align 1, !dbg !3774
  %conv.i.i985 = zext i8 %504 to i32, !dbg !3774
  %shl.i.i986 = shl i32 %503, %conv.i.i985, !dbg !3775
  %505 = load i32, i32* %a.addr.i.i974, align 4, !dbg !3776
  %506 = load i8, i8* %n.addr.i.i975, align 1, !dbg !3777
  %conv1.i.i987 = zext i8 %506 to i32, !dbg !3777
  %sub.i.i988 = sub nsw i32 32, %conv1.i.i987, !dbg !3778
  %shr.i.i989 = lshr i32 %505, %sub.i.i988, !dbg !3779
  %or.i.i990 = or i32 %shl.i.i986, %shr.i.i989, !dbg !3780
  %xor.i991 = xor i32 %500, %or.i.i990, !dbg !3781
  %507 = load i32, i32* %X.addr.i976, align 4, !dbg !3782
  %shr5.i992 = lshr i32 %507, 8, !dbg !3783
  %conv6.i993 = trunc i32 %shr5.i992 to i8, !dbg !3784
  %idxprom7.i994 = zext i8 %conv6.i993 to i64, !dbg !3785
  %arrayidx8.i995 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i994, !dbg !3785
  %508 = load i32, i32* %arrayidx8.i995, align 4, !dbg !3785
  store i32 %508, i32* %a.addr.i24.i970, align 4
  store i8 16, i8* %n.addr.i25.i971, align 1
  %509 = load i32, i32* %a.addr.i24.i970, align 4, !dbg !3786
  %510 = load i8, i8* %n.addr.i25.i971, align 1, !dbg !3787
  %conv.i26.i996 = zext i8 %510 to i32, !dbg !3787
  %shl.i27.i997 = shl i32 %509, %conv.i26.i996, !dbg !3788
  %511 = load i32, i32* %a.addr.i24.i970, align 4, !dbg !3789
  %512 = load i8, i8* %n.addr.i25.i971, align 1, !dbg !3790
  %conv1.i28.i998 = zext i8 %512 to i32, !dbg !3790
  %sub.i29.i999 = sub nsw i32 32, %conv1.i28.i998, !dbg !3791
  %shr.i30.i1000 = lshr i32 %511, %sub.i29.i999, !dbg !3792
  %or.i31.i1001 = or i32 %shl.i27.i997, %shr.i30.i1000, !dbg !3793
  %xor10.i1002 = xor i32 %xor.i991, %or.i31.i1001, !dbg !3794
  %513 = load i32, i32* %X.addr.i976, align 4, !dbg !3795
  %conv11.i1003 = trunc i32 %513 to i8, !dbg !3796
  %idxprom12.i1004 = zext i8 %conv11.i1003 to i64, !dbg !3797
  %arrayidx13.i1005 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1004, !dbg !3797
  %514 = load i32, i32* %arrayidx13.i1005, align 4, !dbg !3797
  store i32 %514, i32* %a.addr.i16.i972, align 4
  store i8 8, i8* %n.addr.i17.i973, align 1
  %515 = load i32, i32* %a.addr.i16.i972, align 4, !dbg !3798
  %516 = load i8, i8* %n.addr.i17.i973, align 1, !dbg !3799
  %conv.i18.i1006 = zext i8 %516 to i32, !dbg !3799
  %shl.i19.i1007 = shl i32 %515, %conv.i18.i1006, !dbg !3800
  %517 = load i32, i32* %a.addr.i16.i972, align 4, !dbg !3801
  %518 = load i8, i8* %n.addr.i17.i973, align 1, !dbg !3802
  %conv1.i20.i1008 = zext i8 %518 to i32, !dbg !3802
  %sub.i21.i1009 = sub nsw i32 32, %conv1.i20.i1008, !dbg !3803
  %shr.i22.i1010 = lshr i32 %517, %sub.i21.i1009, !dbg !3804
  %or.i23.i1011 = or i32 %shl.i19.i1007, %shr.i22.i1010, !dbg !3805
  %xor15.i1012 = xor i32 %xor10.i1002, %or.i23.i1011, !dbg !3806
  %519 = load i32, i32* %B3, align 4, !dbg !3638
  %xor117 = xor i32 %519, %xor15.i1012, !dbg !3638
  store i32 %xor117, i32* %B3, align 4, !dbg !3638
  br label %do.end118, !dbg !3638

do.end118:                                        ; preds = %do.body89
  br label %do.body119, !dbg !3807

do.body119:                                       ; preds = %do.end118
  %520 = load i32, i32* %B1, align 4, !dbg !3808
  %521 = load i32, i32* %B2, align 4, !dbg !3808
  %xor120 = xor i32 %520, %521, !dbg !3808
  %522 = load i32, i32* %B3, align 4, !dbg !3808
  %xor121 = xor i32 %xor120, %522, !dbg !3808
  %523 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3808
  %rk122 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %523, i32 0, i32 0, !dbg !3808
  %arrayidx123 = getelementptr inbounds [32 x i32], [32 x i32]* %rk122, i64 0, i64 15, !dbg !3808
  %524 = load i32, i32* %arrayidx123, align 4, !dbg !3808
  %xor124 = xor i32 %xor121, %524, !dbg !3808
  store i32 %xor124, i32* %X.addr.i933, align 4
  %525 = load i32, i32* %X.addr.i933, align 4, !dbg !3809
  %shr.i934 = lshr i32 %525, 24, !dbg !3810
  %conv.i935 = trunc i32 %shr.i934 to i8, !dbg !3811
  %idxprom.i936 = zext i8 %conv.i935 to i64, !dbg !3812
  %arrayidx.i937 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i936, !dbg !3812
  %526 = load i32, i32* %arrayidx.i937, align 4, !dbg !3812
  %527 = load i32, i32* %X.addr.i933, align 4, !dbg !3813
  %shr1.i938 = lshr i32 %527, 16, !dbg !3814
  %conv2.i939 = trunc i32 %shr1.i938 to i8, !dbg !3815
  %idxprom3.i940 = zext i8 %conv2.i939 to i64, !dbg !3816
  %arrayidx4.i941 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i940, !dbg !3816
  %528 = load i32, i32* %arrayidx4.i941, align 4, !dbg !3816
  store i32 %528, i32* %a.addr.i.i931, align 4
  store i8 24, i8* %n.addr.i.i932, align 1
  %529 = load i32, i32* %a.addr.i.i931, align 4, !dbg !3817
  %530 = load i8, i8* %n.addr.i.i932, align 1, !dbg !3818
  %conv.i.i942 = zext i8 %530 to i32, !dbg !3818
  %shl.i.i943 = shl i32 %529, %conv.i.i942, !dbg !3819
  %531 = load i32, i32* %a.addr.i.i931, align 4, !dbg !3820
  %532 = load i8, i8* %n.addr.i.i932, align 1, !dbg !3821
  %conv1.i.i944 = zext i8 %532 to i32, !dbg !3821
  %sub.i.i945 = sub nsw i32 32, %conv1.i.i944, !dbg !3822
  %shr.i.i946 = lshr i32 %531, %sub.i.i945, !dbg !3823
  %or.i.i947 = or i32 %shl.i.i943, %shr.i.i946, !dbg !3824
  %xor.i948 = xor i32 %526, %or.i.i947, !dbg !3825
  %533 = load i32, i32* %X.addr.i933, align 4, !dbg !3826
  %shr5.i949 = lshr i32 %533, 8, !dbg !3827
  %conv6.i950 = trunc i32 %shr5.i949 to i8, !dbg !3828
  %idxprom7.i951 = zext i8 %conv6.i950 to i64, !dbg !3829
  %arrayidx8.i952 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i951, !dbg !3829
  %534 = load i32, i32* %arrayidx8.i952, align 4, !dbg !3829
  store i32 %534, i32* %a.addr.i24.i927, align 4
  store i8 16, i8* %n.addr.i25.i928, align 1
  %535 = load i32, i32* %a.addr.i24.i927, align 4, !dbg !3830
  %536 = load i8, i8* %n.addr.i25.i928, align 1, !dbg !3831
  %conv.i26.i953 = zext i8 %536 to i32, !dbg !3831
  %shl.i27.i954 = shl i32 %535, %conv.i26.i953, !dbg !3832
  %537 = load i32, i32* %a.addr.i24.i927, align 4, !dbg !3833
  %538 = load i8, i8* %n.addr.i25.i928, align 1, !dbg !3834
  %conv1.i28.i955 = zext i8 %538 to i32, !dbg !3834
  %sub.i29.i956 = sub nsw i32 32, %conv1.i28.i955, !dbg !3835
  %shr.i30.i957 = lshr i32 %537, %sub.i29.i956, !dbg !3836
  %or.i31.i958 = or i32 %shl.i27.i954, %shr.i30.i957, !dbg !3837
  %xor10.i959 = xor i32 %xor.i948, %or.i31.i958, !dbg !3838
  %539 = load i32, i32* %X.addr.i933, align 4, !dbg !3839
  %conv11.i960 = trunc i32 %539 to i8, !dbg !3840
  %idxprom12.i961 = zext i8 %conv11.i960 to i64, !dbg !3841
  %arrayidx13.i962 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i961, !dbg !3841
  %540 = load i32, i32* %arrayidx13.i962, align 4, !dbg !3841
  store i32 %540, i32* %a.addr.i16.i929, align 4
  store i8 8, i8* %n.addr.i17.i930, align 1
  %541 = load i32, i32* %a.addr.i16.i929, align 4, !dbg !3842
  %542 = load i8, i8* %n.addr.i17.i930, align 1, !dbg !3843
  %conv.i18.i963 = zext i8 %542 to i32, !dbg !3843
  %shl.i19.i964 = shl i32 %541, %conv.i18.i963, !dbg !3844
  %543 = load i32, i32* %a.addr.i16.i929, align 4, !dbg !3845
  %544 = load i8, i8* %n.addr.i17.i930, align 1, !dbg !3846
  %conv1.i20.i965 = zext i8 %544 to i32, !dbg !3846
  %sub.i21.i966 = sub nsw i32 32, %conv1.i20.i965, !dbg !3847
  %shr.i22.i967 = lshr i32 %543, %sub.i21.i966, !dbg !3848
  %or.i23.i968 = or i32 %shl.i19.i964, %shr.i22.i967, !dbg !3849
  %xor15.i969 = xor i32 %xor10.i959, %or.i23.i968, !dbg !3850
  %545 = load i32, i32* %B0, align 4, !dbg !3808
  %xor126 = xor i32 %545, %xor15.i969, !dbg !3808
  store i32 %xor126, i32* %B0, align 4, !dbg !3808
  %546 = load i32, i32* %B0, align 4, !dbg !3808
  %547 = load i32, i32* %B2, align 4, !dbg !3808
  %xor127 = xor i32 %546, %547, !dbg !3808
  %548 = load i32, i32* %B3, align 4, !dbg !3808
  %xor128 = xor i32 %xor127, %548, !dbg !3808
  %549 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3808
  %rk129 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %549, i32 0, i32 0, !dbg !3808
  %arrayidx130 = getelementptr inbounds [32 x i32], [32 x i32]* %rk129, i64 0, i64 14, !dbg !3808
  %550 = load i32, i32* %arrayidx130, align 4, !dbg !3808
  %xor131 = xor i32 %xor128, %550, !dbg !3808
  store i32 %xor131, i32* %X.addr.i890, align 4
  %551 = load i32, i32* %X.addr.i890, align 4, !dbg !3851
  %shr.i891 = lshr i32 %551, 24, !dbg !3852
  %conv.i892 = trunc i32 %shr.i891 to i8, !dbg !3853
  %idxprom.i893 = zext i8 %conv.i892 to i64, !dbg !3854
  %arrayidx.i894 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i893, !dbg !3854
  %552 = load i32, i32* %arrayidx.i894, align 4, !dbg !3854
  %553 = load i32, i32* %X.addr.i890, align 4, !dbg !3855
  %shr1.i895 = lshr i32 %553, 16, !dbg !3856
  %conv2.i896 = trunc i32 %shr1.i895 to i8, !dbg !3857
  %idxprom3.i897 = zext i8 %conv2.i896 to i64, !dbg !3858
  %arrayidx4.i898 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i897, !dbg !3858
  %554 = load i32, i32* %arrayidx4.i898, align 4, !dbg !3858
  store i32 %554, i32* %a.addr.i.i888, align 4
  store i8 24, i8* %n.addr.i.i889, align 1
  %555 = load i32, i32* %a.addr.i.i888, align 4, !dbg !3859
  %556 = load i8, i8* %n.addr.i.i889, align 1, !dbg !3860
  %conv.i.i899 = zext i8 %556 to i32, !dbg !3860
  %shl.i.i900 = shl i32 %555, %conv.i.i899, !dbg !3861
  %557 = load i32, i32* %a.addr.i.i888, align 4, !dbg !3862
  %558 = load i8, i8* %n.addr.i.i889, align 1, !dbg !3863
  %conv1.i.i901 = zext i8 %558 to i32, !dbg !3863
  %sub.i.i902 = sub nsw i32 32, %conv1.i.i901, !dbg !3864
  %shr.i.i903 = lshr i32 %557, %sub.i.i902, !dbg !3865
  %or.i.i904 = or i32 %shl.i.i900, %shr.i.i903, !dbg !3866
  %xor.i905 = xor i32 %552, %or.i.i904, !dbg !3867
  %559 = load i32, i32* %X.addr.i890, align 4, !dbg !3868
  %shr5.i906 = lshr i32 %559, 8, !dbg !3869
  %conv6.i907 = trunc i32 %shr5.i906 to i8, !dbg !3870
  %idxprom7.i908 = zext i8 %conv6.i907 to i64, !dbg !3871
  %arrayidx8.i909 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i908, !dbg !3871
  %560 = load i32, i32* %arrayidx8.i909, align 4, !dbg !3871
  store i32 %560, i32* %a.addr.i24.i884, align 4
  store i8 16, i8* %n.addr.i25.i885, align 1
  %561 = load i32, i32* %a.addr.i24.i884, align 4, !dbg !3872
  %562 = load i8, i8* %n.addr.i25.i885, align 1, !dbg !3873
  %conv.i26.i910 = zext i8 %562 to i32, !dbg !3873
  %shl.i27.i911 = shl i32 %561, %conv.i26.i910, !dbg !3874
  %563 = load i32, i32* %a.addr.i24.i884, align 4, !dbg !3875
  %564 = load i8, i8* %n.addr.i25.i885, align 1, !dbg !3876
  %conv1.i28.i912 = zext i8 %564 to i32, !dbg !3876
  %sub.i29.i913 = sub nsw i32 32, %conv1.i28.i912, !dbg !3877
  %shr.i30.i914 = lshr i32 %563, %sub.i29.i913, !dbg !3878
  %or.i31.i915 = or i32 %shl.i27.i911, %shr.i30.i914, !dbg !3879
  %xor10.i916 = xor i32 %xor.i905, %or.i31.i915, !dbg !3880
  %565 = load i32, i32* %X.addr.i890, align 4, !dbg !3881
  %conv11.i917 = trunc i32 %565 to i8, !dbg !3882
  %idxprom12.i918 = zext i8 %conv11.i917 to i64, !dbg !3883
  %arrayidx13.i919 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i918, !dbg !3883
  %566 = load i32, i32* %arrayidx13.i919, align 4, !dbg !3883
  store i32 %566, i32* %a.addr.i16.i886, align 4
  store i8 8, i8* %n.addr.i17.i887, align 1
  %567 = load i32, i32* %a.addr.i16.i886, align 4, !dbg !3884
  %568 = load i8, i8* %n.addr.i17.i887, align 1, !dbg !3885
  %conv.i18.i920 = zext i8 %568 to i32, !dbg !3885
  %shl.i19.i921 = shl i32 %567, %conv.i18.i920, !dbg !3886
  %569 = load i32, i32* %a.addr.i16.i886, align 4, !dbg !3887
  %570 = load i8, i8* %n.addr.i17.i887, align 1, !dbg !3888
  %conv1.i20.i922 = zext i8 %570 to i32, !dbg !3888
  %sub.i21.i923 = sub nsw i32 32, %conv1.i20.i922, !dbg !3889
  %shr.i22.i924 = lshr i32 %569, %sub.i21.i923, !dbg !3890
  %or.i23.i925 = or i32 %shl.i19.i921, %shr.i22.i924, !dbg !3891
  %xor15.i926 = xor i32 %xor10.i916, %or.i23.i925, !dbg !3892
  %571 = load i32, i32* %B1, align 4, !dbg !3808
  %xor133 = xor i32 %571, %xor15.i926, !dbg !3808
  store i32 %xor133, i32* %B1, align 4, !dbg !3808
  %572 = load i32, i32* %B0, align 4, !dbg !3808
  %573 = load i32, i32* %B1, align 4, !dbg !3808
  %xor134 = xor i32 %572, %573, !dbg !3808
  %574 = load i32, i32* %B3, align 4, !dbg !3808
  %xor135 = xor i32 %xor134, %574, !dbg !3808
  %575 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3808
  %rk136 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %575, i32 0, i32 0, !dbg !3808
  %arrayidx137 = getelementptr inbounds [32 x i32], [32 x i32]* %rk136, i64 0, i64 13, !dbg !3808
  %576 = load i32, i32* %arrayidx137, align 4, !dbg !3808
  %xor138 = xor i32 %xor135, %576, !dbg !3808
  store i32 %xor138, i32* %X.addr.i847, align 4
  %577 = load i32, i32* %X.addr.i847, align 4, !dbg !3893
  %shr.i848 = lshr i32 %577, 24, !dbg !3894
  %conv.i849 = trunc i32 %shr.i848 to i8, !dbg !3895
  %idxprom.i850 = zext i8 %conv.i849 to i64, !dbg !3896
  %arrayidx.i851 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i850, !dbg !3896
  %578 = load i32, i32* %arrayidx.i851, align 4, !dbg !3896
  %579 = load i32, i32* %X.addr.i847, align 4, !dbg !3897
  %shr1.i852 = lshr i32 %579, 16, !dbg !3898
  %conv2.i853 = trunc i32 %shr1.i852 to i8, !dbg !3899
  %idxprom3.i854 = zext i8 %conv2.i853 to i64, !dbg !3900
  %arrayidx4.i855 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i854, !dbg !3900
  %580 = load i32, i32* %arrayidx4.i855, align 4, !dbg !3900
  store i32 %580, i32* %a.addr.i.i845, align 4
  store i8 24, i8* %n.addr.i.i846, align 1
  %581 = load i32, i32* %a.addr.i.i845, align 4, !dbg !3901
  %582 = load i8, i8* %n.addr.i.i846, align 1, !dbg !3902
  %conv.i.i856 = zext i8 %582 to i32, !dbg !3902
  %shl.i.i857 = shl i32 %581, %conv.i.i856, !dbg !3903
  %583 = load i32, i32* %a.addr.i.i845, align 4, !dbg !3904
  %584 = load i8, i8* %n.addr.i.i846, align 1, !dbg !3905
  %conv1.i.i858 = zext i8 %584 to i32, !dbg !3905
  %sub.i.i859 = sub nsw i32 32, %conv1.i.i858, !dbg !3906
  %shr.i.i860 = lshr i32 %583, %sub.i.i859, !dbg !3907
  %or.i.i861 = or i32 %shl.i.i857, %shr.i.i860, !dbg !3908
  %xor.i862 = xor i32 %578, %or.i.i861, !dbg !3909
  %585 = load i32, i32* %X.addr.i847, align 4, !dbg !3910
  %shr5.i863 = lshr i32 %585, 8, !dbg !3911
  %conv6.i864 = trunc i32 %shr5.i863 to i8, !dbg !3912
  %idxprom7.i865 = zext i8 %conv6.i864 to i64, !dbg !3913
  %arrayidx8.i866 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i865, !dbg !3913
  %586 = load i32, i32* %arrayidx8.i866, align 4, !dbg !3913
  store i32 %586, i32* %a.addr.i24.i841, align 4
  store i8 16, i8* %n.addr.i25.i842, align 1
  %587 = load i32, i32* %a.addr.i24.i841, align 4, !dbg !3914
  %588 = load i8, i8* %n.addr.i25.i842, align 1, !dbg !3915
  %conv.i26.i867 = zext i8 %588 to i32, !dbg !3915
  %shl.i27.i868 = shl i32 %587, %conv.i26.i867, !dbg !3916
  %589 = load i32, i32* %a.addr.i24.i841, align 4, !dbg !3917
  %590 = load i8, i8* %n.addr.i25.i842, align 1, !dbg !3918
  %conv1.i28.i869 = zext i8 %590 to i32, !dbg !3918
  %sub.i29.i870 = sub nsw i32 32, %conv1.i28.i869, !dbg !3919
  %shr.i30.i871 = lshr i32 %589, %sub.i29.i870, !dbg !3920
  %or.i31.i872 = or i32 %shl.i27.i868, %shr.i30.i871, !dbg !3921
  %xor10.i873 = xor i32 %xor.i862, %or.i31.i872, !dbg !3922
  %591 = load i32, i32* %X.addr.i847, align 4, !dbg !3923
  %conv11.i874 = trunc i32 %591 to i8, !dbg !3924
  %idxprom12.i875 = zext i8 %conv11.i874 to i64, !dbg !3925
  %arrayidx13.i876 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i875, !dbg !3925
  %592 = load i32, i32* %arrayidx13.i876, align 4, !dbg !3925
  store i32 %592, i32* %a.addr.i16.i843, align 4
  store i8 8, i8* %n.addr.i17.i844, align 1
  %593 = load i32, i32* %a.addr.i16.i843, align 4, !dbg !3926
  %594 = load i8, i8* %n.addr.i17.i844, align 1, !dbg !3927
  %conv.i18.i877 = zext i8 %594 to i32, !dbg !3927
  %shl.i19.i878 = shl i32 %593, %conv.i18.i877, !dbg !3928
  %595 = load i32, i32* %a.addr.i16.i843, align 4, !dbg !3929
  %596 = load i8, i8* %n.addr.i17.i844, align 1, !dbg !3930
  %conv1.i20.i879 = zext i8 %596 to i32, !dbg !3930
  %sub.i21.i880 = sub nsw i32 32, %conv1.i20.i879, !dbg !3931
  %shr.i22.i881 = lshr i32 %595, %sub.i21.i880, !dbg !3932
  %or.i23.i882 = or i32 %shl.i19.i878, %shr.i22.i881, !dbg !3933
  %xor15.i883 = xor i32 %xor10.i873, %or.i23.i882, !dbg !3934
  %597 = load i32, i32* %B2, align 4, !dbg !3808
  %xor140 = xor i32 %597, %xor15.i883, !dbg !3808
  store i32 %xor140, i32* %B2, align 4, !dbg !3808
  %598 = load i32, i32* %B0, align 4, !dbg !3808
  %599 = load i32, i32* %B1, align 4, !dbg !3808
  %xor141 = xor i32 %598, %599, !dbg !3808
  %600 = load i32, i32* %B2, align 4, !dbg !3808
  %xor142 = xor i32 %xor141, %600, !dbg !3808
  %601 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3808
  %rk143 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %601, i32 0, i32 0, !dbg !3808
  %arrayidx144 = getelementptr inbounds [32 x i32], [32 x i32]* %rk143, i64 0, i64 12, !dbg !3808
  %602 = load i32, i32* %arrayidx144, align 4, !dbg !3808
  %xor145 = xor i32 %xor142, %602, !dbg !3808
  store i32 %xor145, i32* %X.addr.i804, align 4
  %603 = load i32, i32* %X.addr.i804, align 4, !dbg !3935
  %shr.i805 = lshr i32 %603, 24, !dbg !3936
  %conv.i806 = trunc i32 %shr.i805 to i8, !dbg !3937
  %idxprom.i807 = zext i8 %conv.i806 to i64, !dbg !3938
  %arrayidx.i808 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i807, !dbg !3938
  %604 = load i32, i32* %arrayidx.i808, align 4, !dbg !3938
  %605 = load i32, i32* %X.addr.i804, align 4, !dbg !3939
  %shr1.i809 = lshr i32 %605, 16, !dbg !3940
  %conv2.i810 = trunc i32 %shr1.i809 to i8, !dbg !3941
  %idxprom3.i811 = zext i8 %conv2.i810 to i64, !dbg !3942
  %arrayidx4.i812 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i811, !dbg !3942
  %606 = load i32, i32* %arrayidx4.i812, align 4, !dbg !3942
  store i32 %606, i32* %a.addr.i.i802, align 4
  store i8 24, i8* %n.addr.i.i803, align 1
  %607 = load i32, i32* %a.addr.i.i802, align 4, !dbg !3943
  %608 = load i8, i8* %n.addr.i.i803, align 1, !dbg !3944
  %conv.i.i813 = zext i8 %608 to i32, !dbg !3944
  %shl.i.i814 = shl i32 %607, %conv.i.i813, !dbg !3945
  %609 = load i32, i32* %a.addr.i.i802, align 4, !dbg !3946
  %610 = load i8, i8* %n.addr.i.i803, align 1, !dbg !3947
  %conv1.i.i815 = zext i8 %610 to i32, !dbg !3947
  %sub.i.i816 = sub nsw i32 32, %conv1.i.i815, !dbg !3948
  %shr.i.i817 = lshr i32 %609, %sub.i.i816, !dbg !3949
  %or.i.i818 = or i32 %shl.i.i814, %shr.i.i817, !dbg !3950
  %xor.i819 = xor i32 %604, %or.i.i818, !dbg !3951
  %611 = load i32, i32* %X.addr.i804, align 4, !dbg !3952
  %shr5.i820 = lshr i32 %611, 8, !dbg !3953
  %conv6.i821 = trunc i32 %shr5.i820 to i8, !dbg !3954
  %idxprom7.i822 = zext i8 %conv6.i821 to i64, !dbg !3955
  %arrayidx8.i823 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i822, !dbg !3955
  %612 = load i32, i32* %arrayidx8.i823, align 4, !dbg !3955
  store i32 %612, i32* %a.addr.i24.i798, align 4
  store i8 16, i8* %n.addr.i25.i799, align 1
  %613 = load i32, i32* %a.addr.i24.i798, align 4, !dbg !3956
  %614 = load i8, i8* %n.addr.i25.i799, align 1, !dbg !3957
  %conv.i26.i824 = zext i8 %614 to i32, !dbg !3957
  %shl.i27.i825 = shl i32 %613, %conv.i26.i824, !dbg !3958
  %615 = load i32, i32* %a.addr.i24.i798, align 4, !dbg !3959
  %616 = load i8, i8* %n.addr.i25.i799, align 1, !dbg !3960
  %conv1.i28.i826 = zext i8 %616 to i32, !dbg !3960
  %sub.i29.i827 = sub nsw i32 32, %conv1.i28.i826, !dbg !3961
  %shr.i30.i828 = lshr i32 %615, %sub.i29.i827, !dbg !3962
  %or.i31.i829 = or i32 %shl.i27.i825, %shr.i30.i828, !dbg !3963
  %xor10.i830 = xor i32 %xor.i819, %or.i31.i829, !dbg !3964
  %617 = load i32, i32* %X.addr.i804, align 4, !dbg !3965
  %conv11.i831 = trunc i32 %617 to i8, !dbg !3966
  %idxprom12.i832 = zext i8 %conv11.i831 to i64, !dbg !3967
  %arrayidx13.i833 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i832, !dbg !3967
  %618 = load i32, i32* %arrayidx13.i833, align 4, !dbg !3967
  store i32 %618, i32* %a.addr.i16.i800, align 4
  store i8 8, i8* %n.addr.i17.i801, align 1
  %619 = load i32, i32* %a.addr.i16.i800, align 4, !dbg !3968
  %620 = load i8, i8* %n.addr.i17.i801, align 1, !dbg !3969
  %conv.i18.i834 = zext i8 %620 to i32, !dbg !3969
  %shl.i19.i835 = shl i32 %619, %conv.i18.i834, !dbg !3970
  %621 = load i32, i32* %a.addr.i16.i800, align 4, !dbg !3971
  %622 = load i8, i8* %n.addr.i17.i801, align 1, !dbg !3972
  %conv1.i20.i836 = zext i8 %622 to i32, !dbg !3972
  %sub.i21.i837 = sub nsw i32 32, %conv1.i20.i836, !dbg !3973
  %shr.i22.i838 = lshr i32 %621, %sub.i21.i837, !dbg !3974
  %or.i23.i839 = or i32 %shl.i19.i835, %shr.i22.i838, !dbg !3975
  %xor15.i840 = xor i32 %xor10.i830, %or.i23.i839, !dbg !3976
  %623 = load i32, i32* %B3, align 4, !dbg !3808
  %xor147 = xor i32 %623, %xor15.i840, !dbg !3808
  store i32 %xor147, i32* %B3, align 4, !dbg !3808
  br label %do.end148, !dbg !3808

do.end148:                                        ; preds = %do.body119
  br label %do.body149, !dbg !3977

do.body149:                                       ; preds = %do.end148
  %624 = load i32, i32* %B1, align 4, !dbg !3978
  %625 = load i32, i32* %B2, align 4, !dbg !3978
  %xor150 = xor i32 %624, %625, !dbg !3978
  %626 = load i32, i32* %B3, align 4, !dbg !3978
  %xor151 = xor i32 %xor150, %626, !dbg !3978
  %627 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3978
  %rk152 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %627, i32 0, i32 0, !dbg !3978
  %arrayidx153 = getelementptr inbounds [32 x i32], [32 x i32]* %rk152, i64 0, i64 11, !dbg !3978
  %628 = load i32, i32* %arrayidx153, align 4, !dbg !3978
  %xor154 = xor i32 %xor151, %628, !dbg !3978
  store i32 %xor154, i32* %X.addr.i761, align 4
  %629 = load i32, i32* %X.addr.i761, align 4, !dbg !3979
  %shr.i762 = lshr i32 %629, 24, !dbg !3980
  %conv.i763 = trunc i32 %shr.i762 to i8, !dbg !3981
  %idxprom.i764 = zext i8 %conv.i763 to i64, !dbg !3982
  %arrayidx.i765 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i764, !dbg !3982
  %630 = load i32, i32* %arrayidx.i765, align 4, !dbg !3982
  %631 = load i32, i32* %X.addr.i761, align 4, !dbg !3983
  %shr1.i766 = lshr i32 %631, 16, !dbg !3984
  %conv2.i767 = trunc i32 %shr1.i766 to i8, !dbg !3985
  %idxprom3.i768 = zext i8 %conv2.i767 to i64, !dbg !3986
  %arrayidx4.i769 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i768, !dbg !3986
  %632 = load i32, i32* %arrayidx4.i769, align 4, !dbg !3986
  store i32 %632, i32* %a.addr.i.i759, align 4
  store i8 24, i8* %n.addr.i.i760, align 1
  %633 = load i32, i32* %a.addr.i.i759, align 4, !dbg !3987
  %634 = load i8, i8* %n.addr.i.i760, align 1, !dbg !3988
  %conv.i.i770 = zext i8 %634 to i32, !dbg !3988
  %shl.i.i771 = shl i32 %633, %conv.i.i770, !dbg !3989
  %635 = load i32, i32* %a.addr.i.i759, align 4, !dbg !3990
  %636 = load i8, i8* %n.addr.i.i760, align 1, !dbg !3991
  %conv1.i.i772 = zext i8 %636 to i32, !dbg !3991
  %sub.i.i773 = sub nsw i32 32, %conv1.i.i772, !dbg !3992
  %shr.i.i774 = lshr i32 %635, %sub.i.i773, !dbg !3993
  %or.i.i775 = or i32 %shl.i.i771, %shr.i.i774, !dbg !3994
  %xor.i776 = xor i32 %630, %or.i.i775, !dbg !3995
  %637 = load i32, i32* %X.addr.i761, align 4, !dbg !3996
  %shr5.i777 = lshr i32 %637, 8, !dbg !3997
  %conv6.i778 = trunc i32 %shr5.i777 to i8, !dbg !3998
  %idxprom7.i779 = zext i8 %conv6.i778 to i64, !dbg !3999
  %arrayidx8.i780 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i779, !dbg !3999
  %638 = load i32, i32* %arrayidx8.i780, align 4, !dbg !3999
  store i32 %638, i32* %a.addr.i24.i755, align 4
  store i8 16, i8* %n.addr.i25.i756, align 1
  %639 = load i32, i32* %a.addr.i24.i755, align 4, !dbg !4000
  %640 = load i8, i8* %n.addr.i25.i756, align 1, !dbg !4001
  %conv.i26.i781 = zext i8 %640 to i32, !dbg !4001
  %shl.i27.i782 = shl i32 %639, %conv.i26.i781, !dbg !4002
  %641 = load i32, i32* %a.addr.i24.i755, align 4, !dbg !4003
  %642 = load i8, i8* %n.addr.i25.i756, align 1, !dbg !4004
  %conv1.i28.i783 = zext i8 %642 to i32, !dbg !4004
  %sub.i29.i784 = sub nsw i32 32, %conv1.i28.i783, !dbg !4005
  %shr.i30.i785 = lshr i32 %641, %sub.i29.i784, !dbg !4006
  %or.i31.i786 = or i32 %shl.i27.i782, %shr.i30.i785, !dbg !4007
  %xor10.i787 = xor i32 %xor.i776, %or.i31.i786, !dbg !4008
  %643 = load i32, i32* %X.addr.i761, align 4, !dbg !4009
  %conv11.i788 = trunc i32 %643 to i8, !dbg !4010
  %idxprom12.i789 = zext i8 %conv11.i788 to i64, !dbg !4011
  %arrayidx13.i790 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i789, !dbg !4011
  %644 = load i32, i32* %arrayidx13.i790, align 4, !dbg !4011
  store i32 %644, i32* %a.addr.i16.i757, align 4
  store i8 8, i8* %n.addr.i17.i758, align 1
  %645 = load i32, i32* %a.addr.i16.i757, align 4, !dbg !4012
  %646 = load i8, i8* %n.addr.i17.i758, align 1, !dbg !4013
  %conv.i18.i791 = zext i8 %646 to i32, !dbg !4013
  %shl.i19.i792 = shl i32 %645, %conv.i18.i791, !dbg !4014
  %647 = load i32, i32* %a.addr.i16.i757, align 4, !dbg !4015
  %648 = load i8, i8* %n.addr.i17.i758, align 1, !dbg !4016
  %conv1.i20.i793 = zext i8 %648 to i32, !dbg !4016
  %sub.i21.i794 = sub nsw i32 32, %conv1.i20.i793, !dbg !4017
  %shr.i22.i795 = lshr i32 %647, %sub.i21.i794, !dbg !4018
  %or.i23.i796 = or i32 %shl.i19.i792, %shr.i22.i795, !dbg !4019
  %xor15.i797 = xor i32 %xor10.i787, %or.i23.i796, !dbg !4020
  %649 = load i32, i32* %B0, align 4, !dbg !3978
  %xor156 = xor i32 %649, %xor15.i797, !dbg !3978
  store i32 %xor156, i32* %B0, align 4, !dbg !3978
  %650 = load i32, i32* %B0, align 4, !dbg !3978
  %651 = load i32, i32* %B2, align 4, !dbg !3978
  %xor157 = xor i32 %650, %651, !dbg !3978
  %652 = load i32, i32* %B3, align 4, !dbg !3978
  %xor158 = xor i32 %xor157, %652, !dbg !3978
  %653 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3978
  %rk159 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %653, i32 0, i32 0, !dbg !3978
  %arrayidx160 = getelementptr inbounds [32 x i32], [32 x i32]* %rk159, i64 0, i64 10, !dbg !3978
  %654 = load i32, i32* %arrayidx160, align 4, !dbg !3978
  %xor161 = xor i32 %xor158, %654, !dbg !3978
  store i32 %xor161, i32* %X.addr.i718, align 4
  %655 = load i32, i32* %X.addr.i718, align 4, !dbg !4021
  %shr.i719 = lshr i32 %655, 24, !dbg !4022
  %conv.i720 = trunc i32 %shr.i719 to i8, !dbg !4023
  %idxprom.i721 = zext i8 %conv.i720 to i64, !dbg !4024
  %arrayidx.i722 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i721, !dbg !4024
  %656 = load i32, i32* %arrayidx.i722, align 4, !dbg !4024
  %657 = load i32, i32* %X.addr.i718, align 4, !dbg !4025
  %shr1.i723 = lshr i32 %657, 16, !dbg !4026
  %conv2.i724 = trunc i32 %shr1.i723 to i8, !dbg !4027
  %idxprom3.i725 = zext i8 %conv2.i724 to i64, !dbg !4028
  %arrayidx4.i726 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i725, !dbg !4028
  %658 = load i32, i32* %arrayidx4.i726, align 4, !dbg !4028
  store i32 %658, i32* %a.addr.i.i716, align 4
  store i8 24, i8* %n.addr.i.i717, align 1
  %659 = load i32, i32* %a.addr.i.i716, align 4, !dbg !4029
  %660 = load i8, i8* %n.addr.i.i717, align 1, !dbg !4030
  %conv.i.i727 = zext i8 %660 to i32, !dbg !4030
  %shl.i.i728 = shl i32 %659, %conv.i.i727, !dbg !4031
  %661 = load i32, i32* %a.addr.i.i716, align 4, !dbg !4032
  %662 = load i8, i8* %n.addr.i.i717, align 1, !dbg !4033
  %conv1.i.i729 = zext i8 %662 to i32, !dbg !4033
  %sub.i.i730 = sub nsw i32 32, %conv1.i.i729, !dbg !4034
  %shr.i.i731 = lshr i32 %661, %sub.i.i730, !dbg !4035
  %or.i.i732 = or i32 %shl.i.i728, %shr.i.i731, !dbg !4036
  %xor.i733 = xor i32 %656, %or.i.i732, !dbg !4037
  %663 = load i32, i32* %X.addr.i718, align 4, !dbg !4038
  %shr5.i734 = lshr i32 %663, 8, !dbg !4039
  %conv6.i735 = trunc i32 %shr5.i734 to i8, !dbg !4040
  %idxprom7.i736 = zext i8 %conv6.i735 to i64, !dbg !4041
  %arrayidx8.i737 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i736, !dbg !4041
  %664 = load i32, i32* %arrayidx8.i737, align 4, !dbg !4041
  store i32 %664, i32* %a.addr.i24.i712, align 4
  store i8 16, i8* %n.addr.i25.i713, align 1
  %665 = load i32, i32* %a.addr.i24.i712, align 4, !dbg !4042
  %666 = load i8, i8* %n.addr.i25.i713, align 1, !dbg !4043
  %conv.i26.i738 = zext i8 %666 to i32, !dbg !4043
  %shl.i27.i739 = shl i32 %665, %conv.i26.i738, !dbg !4044
  %667 = load i32, i32* %a.addr.i24.i712, align 4, !dbg !4045
  %668 = load i8, i8* %n.addr.i25.i713, align 1, !dbg !4046
  %conv1.i28.i740 = zext i8 %668 to i32, !dbg !4046
  %sub.i29.i741 = sub nsw i32 32, %conv1.i28.i740, !dbg !4047
  %shr.i30.i742 = lshr i32 %667, %sub.i29.i741, !dbg !4048
  %or.i31.i743 = or i32 %shl.i27.i739, %shr.i30.i742, !dbg !4049
  %xor10.i744 = xor i32 %xor.i733, %or.i31.i743, !dbg !4050
  %669 = load i32, i32* %X.addr.i718, align 4, !dbg !4051
  %conv11.i745 = trunc i32 %669 to i8, !dbg !4052
  %idxprom12.i746 = zext i8 %conv11.i745 to i64, !dbg !4053
  %arrayidx13.i747 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i746, !dbg !4053
  %670 = load i32, i32* %arrayidx13.i747, align 4, !dbg !4053
  store i32 %670, i32* %a.addr.i16.i714, align 4
  store i8 8, i8* %n.addr.i17.i715, align 1
  %671 = load i32, i32* %a.addr.i16.i714, align 4, !dbg !4054
  %672 = load i8, i8* %n.addr.i17.i715, align 1, !dbg !4055
  %conv.i18.i748 = zext i8 %672 to i32, !dbg !4055
  %shl.i19.i749 = shl i32 %671, %conv.i18.i748, !dbg !4056
  %673 = load i32, i32* %a.addr.i16.i714, align 4, !dbg !4057
  %674 = load i8, i8* %n.addr.i17.i715, align 1, !dbg !4058
  %conv1.i20.i750 = zext i8 %674 to i32, !dbg !4058
  %sub.i21.i751 = sub nsw i32 32, %conv1.i20.i750, !dbg !4059
  %shr.i22.i752 = lshr i32 %673, %sub.i21.i751, !dbg !4060
  %or.i23.i753 = or i32 %shl.i19.i749, %shr.i22.i752, !dbg !4061
  %xor15.i754 = xor i32 %xor10.i744, %or.i23.i753, !dbg !4062
  %675 = load i32, i32* %B1, align 4, !dbg !3978
  %xor163 = xor i32 %675, %xor15.i754, !dbg !3978
  store i32 %xor163, i32* %B1, align 4, !dbg !3978
  %676 = load i32, i32* %B0, align 4, !dbg !3978
  %677 = load i32, i32* %B1, align 4, !dbg !3978
  %xor164 = xor i32 %676, %677, !dbg !3978
  %678 = load i32, i32* %B3, align 4, !dbg !3978
  %xor165 = xor i32 %xor164, %678, !dbg !3978
  %679 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3978
  %rk166 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %679, i32 0, i32 0, !dbg !3978
  %arrayidx167 = getelementptr inbounds [32 x i32], [32 x i32]* %rk166, i64 0, i64 9, !dbg !3978
  %680 = load i32, i32* %arrayidx167, align 4, !dbg !3978
  %xor168 = xor i32 %xor165, %680, !dbg !3978
  store i32 %xor168, i32* %X.addr.i675, align 4
  %681 = load i32, i32* %X.addr.i675, align 4, !dbg !4063
  %shr.i676 = lshr i32 %681, 24, !dbg !4064
  %conv.i677 = trunc i32 %shr.i676 to i8, !dbg !4065
  %idxprom.i678 = zext i8 %conv.i677 to i64, !dbg !4066
  %arrayidx.i679 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i678, !dbg !4066
  %682 = load i32, i32* %arrayidx.i679, align 4, !dbg !4066
  %683 = load i32, i32* %X.addr.i675, align 4, !dbg !4067
  %shr1.i680 = lshr i32 %683, 16, !dbg !4068
  %conv2.i681 = trunc i32 %shr1.i680 to i8, !dbg !4069
  %idxprom3.i682 = zext i8 %conv2.i681 to i64, !dbg !4070
  %arrayidx4.i683 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i682, !dbg !4070
  %684 = load i32, i32* %arrayidx4.i683, align 4, !dbg !4070
  store i32 %684, i32* %a.addr.i.i673, align 4
  store i8 24, i8* %n.addr.i.i674, align 1
  %685 = load i32, i32* %a.addr.i.i673, align 4, !dbg !4071
  %686 = load i8, i8* %n.addr.i.i674, align 1, !dbg !4072
  %conv.i.i684 = zext i8 %686 to i32, !dbg !4072
  %shl.i.i685 = shl i32 %685, %conv.i.i684, !dbg !4073
  %687 = load i32, i32* %a.addr.i.i673, align 4, !dbg !4074
  %688 = load i8, i8* %n.addr.i.i674, align 1, !dbg !4075
  %conv1.i.i686 = zext i8 %688 to i32, !dbg !4075
  %sub.i.i687 = sub nsw i32 32, %conv1.i.i686, !dbg !4076
  %shr.i.i688 = lshr i32 %687, %sub.i.i687, !dbg !4077
  %or.i.i689 = or i32 %shl.i.i685, %shr.i.i688, !dbg !4078
  %xor.i690 = xor i32 %682, %or.i.i689, !dbg !4079
  %689 = load i32, i32* %X.addr.i675, align 4, !dbg !4080
  %shr5.i691 = lshr i32 %689, 8, !dbg !4081
  %conv6.i692 = trunc i32 %shr5.i691 to i8, !dbg !4082
  %idxprom7.i693 = zext i8 %conv6.i692 to i64, !dbg !4083
  %arrayidx8.i694 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i693, !dbg !4083
  %690 = load i32, i32* %arrayidx8.i694, align 4, !dbg !4083
  store i32 %690, i32* %a.addr.i24.i669, align 4
  store i8 16, i8* %n.addr.i25.i670, align 1
  %691 = load i32, i32* %a.addr.i24.i669, align 4, !dbg !4084
  %692 = load i8, i8* %n.addr.i25.i670, align 1, !dbg !4085
  %conv.i26.i695 = zext i8 %692 to i32, !dbg !4085
  %shl.i27.i696 = shl i32 %691, %conv.i26.i695, !dbg !4086
  %693 = load i32, i32* %a.addr.i24.i669, align 4, !dbg !4087
  %694 = load i8, i8* %n.addr.i25.i670, align 1, !dbg !4088
  %conv1.i28.i697 = zext i8 %694 to i32, !dbg !4088
  %sub.i29.i698 = sub nsw i32 32, %conv1.i28.i697, !dbg !4089
  %shr.i30.i699 = lshr i32 %693, %sub.i29.i698, !dbg !4090
  %or.i31.i700 = or i32 %shl.i27.i696, %shr.i30.i699, !dbg !4091
  %xor10.i701 = xor i32 %xor.i690, %or.i31.i700, !dbg !4092
  %695 = load i32, i32* %X.addr.i675, align 4, !dbg !4093
  %conv11.i702 = trunc i32 %695 to i8, !dbg !4094
  %idxprom12.i703 = zext i8 %conv11.i702 to i64, !dbg !4095
  %arrayidx13.i704 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i703, !dbg !4095
  %696 = load i32, i32* %arrayidx13.i704, align 4, !dbg !4095
  store i32 %696, i32* %a.addr.i16.i671, align 4
  store i8 8, i8* %n.addr.i17.i672, align 1
  %697 = load i32, i32* %a.addr.i16.i671, align 4, !dbg !4096
  %698 = load i8, i8* %n.addr.i17.i672, align 1, !dbg !4097
  %conv.i18.i705 = zext i8 %698 to i32, !dbg !4097
  %shl.i19.i706 = shl i32 %697, %conv.i18.i705, !dbg !4098
  %699 = load i32, i32* %a.addr.i16.i671, align 4, !dbg !4099
  %700 = load i8, i8* %n.addr.i17.i672, align 1, !dbg !4100
  %conv1.i20.i707 = zext i8 %700 to i32, !dbg !4100
  %sub.i21.i708 = sub nsw i32 32, %conv1.i20.i707, !dbg !4101
  %shr.i22.i709 = lshr i32 %699, %sub.i21.i708, !dbg !4102
  %or.i23.i710 = or i32 %shl.i19.i706, %shr.i22.i709, !dbg !4103
  %xor15.i711 = xor i32 %xor10.i701, %or.i23.i710, !dbg !4104
  %701 = load i32, i32* %B2, align 4, !dbg !3978
  %xor170 = xor i32 %701, %xor15.i711, !dbg !3978
  store i32 %xor170, i32* %B2, align 4, !dbg !3978
  %702 = load i32, i32* %B0, align 4, !dbg !3978
  %703 = load i32, i32* %B1, align 4, !dbg !3978
  %xor171 = xor i32 %702, %703, !dbg !3978
  %704 = load i32, i32* %B2, align 4, !dbg !3978
  %xor172 = xor i32 %xor171, %704, !dbg !3978
  %705 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !3978
  %rk173 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %705, i32 0, i32 0, !dbg !3978
  %arrayidx174 = getelementptr inbounds [32 x i32], [32 x i32]* %rk173, i64 0, i64 8, !dbg !3978
  %706 = load i32, i32* %arrayidx174, align 4, !dbg !3978
  %xor175 = xor i32 %xor172, %706, !dbg !3978
  store i32 %xor175, i32* %X.addr.i632, align 4
  %707 = load i32, i32* %X.addr.i632, align 4, !dbg !4105
  %shr.i633 = lshr i32 %707, 24, !dbg !4106
  %conv.i634 = trunc i32 %shr.i633 to i8, !dbg !4107
  %idxprom.i635 = zext i8 %conv.i634 to i64, !dbg !4108
  %arrayidx.i636 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i635, !dbg !4108
  %708 = load i32, i32* %arrayidx.i636, align 4, !dbg !4108
  %709 = load i32, i32* %X.addr.i632, align 4, !dbg !4109
  %shr1.i637 = lshr i32 %709, 16, !dbg !4110
  %conv2.i638 = trunc i32 %shr1.i637 to i8, !dbg !4111
  %idxprom3.i639 = zext i8 %conv2.i638 to i64, !dbg !4112
  %arrayidx4.i640 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i639, !dbg !4112
  %710 = load i32, i32* %arrayidx4.i640, align 4, !dbg !4112
  store i32 %710, i32* %a.addr.i.i630, align 4
  store i8 24, i8* %n.addr.i.i631, align 1
  %711 = load i32, i32* %a.addr.i.i630, align 4, !dbg !4113
  %712 = load i8, i8* %n.addr.i.i631, align 1, !dbg !4114
  %conv.i.i641 = zext i8 %712 to i32, !dbg !4114
  %shl.i.i642 = shl i32 %711, %conv.i.i641, !dbg !4115
  %713 = load i32, i32* %a.addr.i.i630, align 4, !dbg !4116
  %714 = load i8, i8* %n.addr.i.i631, align 1, !dbg !4117
  %conv1.i.i643 = zext i8 %714 to i32, !dbg !4117
  %sub.i.i644 = sub nsw i32 32, %conv1.i.i643, !dbg !4118
  %shr.i.i645 = lshr i32 %713, %sub.i.i644, !dbg !4119
  %or.i.i646 = or i32 %shl.i.i642, %shr.i.i645, !dbg !4120
  %xor.i647 = xor i32 %708, %or.i.i646, !dbg !4121
  %715 = load i32, i32* %X.addr.i632, align 4, !dbg !4122
  %shr5.i648 = lshr i32 %715, 8, !dbg !4123
  %conv6.i649 = trunc i32 %shr5.i648 to i8, !dbg !4124
  %idxprom7.i650 = zext i8 %conv6.i649 to i64, !dbg !4125
  %arrayidx8.i651 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i650, !dbg !4125
  %716 = load i32, i32* %arrayidx8.i651, align 4, !dbg !4125
  store i32 %716, i32* %a.addr.i24.i626, align 4
  store i8 16, i8* %n.addr.i25.i627, align 1
  %717 = load i32, i32* %a.addr.i24.i626, align 4, !dbg !4126
  %718 = load i8, i8* %n.addr.i25.i627, align 1, !dbg !4127
  %conv.i26.i652 = zext i8 %718 to i32, !dbg !4127
  %shl.i27.i653 = shl i32 %717, %conv.i26.i652, !dbg !4128
  %719 = load i32, i32* %a.addr.i24.i626, align 4, !dbg !4129
  %720 = load i8, i8* %n.addr.i25.i627, align 1, !dbg !4130
  %conv1.i28.i654 = zext i8 %720 to i32, !dbg !4130
  %sub.i29.i655 = sub nsw i32 32, %conv1.i28.i654, !dbg !4131
  %shr.i30.i656 = lshr i32 %719, %sub.i29.i655, !dbg !4132
  %or.i31.i657 = or i32 %shl.i27.i653, %shr.i30.i656, !dbg !4133
  %xor10.i658 = xor i32 %xor.i647, %or.i31.i657, !dbg !4134
  %721 = load i32, i32* %X.addr.i632, align 4, !dbg !4135
  %conv11.i659 = trunc i32 %721 to i8, !dbg !4136
  %idxprom12.i660 = zext i8 %conv11.i659 to i64, !dbg !4137
  %arrayidx13.i661 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i660, !dbg !4137
  %722 = load i32, i32* %arrayidx13.i661, align 4, !dbg !4137
  store i32 %722, i32* %a.addr.i16.i628, align 4
  store i8 8, i8* %n.addr.i17.i629, align 1
  %723 = load i32, i32* %a.addr.i16.i628, align 4, !dbg !4138
  %724 = load i8, i8* %n.addr.i17.i629, align 1, !dbg !4139
  %conv.i18.i662 = zext i8 %724 to i32, !dbg !4139
  %shl.i19.i663 = shl i32 %723, %conv.i18.i662, !dbg !4140
  %725 = load i32, i32* %a.addr.i16.i628, align 4, !dbg !4141
  %726 = load i8, i8* %n.addr.i17.i629, align 1, !dbg !4142
  %conv1.i20.i664 = zext i8 %726 to i32, !dbg !4142
  %sub.i21.i665 = sub nsw i32 32, %conv1.i20.i664, !dbg !4143
  %shr.i22.i666 = lshr i32 %725, %sub.i21.i665, !dbg !4144
  %or.i23.i667 = or i32 %shl.i19.i663, %shr.i22.i666, !dbg !4145
  %xor15.i668 = xor i32 %xor10.i658, %or.i23.i667, !dbg !4146
  %727 = load i32, i32* %B3, align 4, !dbg !3978
  %xor177 = xor i32 %727, %xor15.i668, !dbg !3978
  store i32 %xor177, i32* %B3, align 4, !dbg !3978
  br label %do.end178, !dbg !3978

do.end178:                                        ; preds = %do.body149
  br label %do.body179, !dbg !4147

do.body179:                                       ; preds = %do.end178
  %728 = load i32, i32* %B1, align 4, !dbg !4148
  %729 = load i32, i32* %B2, align 4, !dbg !4148
  %xor180 = xor i32 %728, %729, !dbg !4148
  %730 = load i32, i32* %B3, align 4, !dbg !4148
  %xor181 = xor i32 %xor180, %730, !dbg !4148
  %731 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !4148
  %rk182 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %731, i32 0, i32 0, !dbg !4148
  %arrayidx183 = getelementptr inbounds [32 x i32], [32 x i32]* %rk182, i64 0, i64 7, !dbg !4148
  %732 = load i32, i32* %arrayidx183, align 4, !dbg !4148
  %xor184 = xor i32 %xor181, %732, !dbg !4148
  store i32 %xor184, i32* %X.addr.i589, align 4
  %733 = load i32, i32* %X.addr.i589, align 4, !dbg !4149
  %shr.i590 = lshr i32 %733, 24, !dbg !4150
  %conv.i591 = trunc i32 %shr.i590 to i8, !dbg !4151
  %idxprom.i592 = zext i8 %conv.i591 to i64, !dbg !4152
  %arrayidx.i593 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i592, !dbg !4152
  %734 = load i32, i32* %arrayidx.i593, align 4, !dbg !4152
  %735 = load i32, i32* %X.addr.i589, align 4, !dbg !4153
  %shr1.i594 = lshr i32 %735, 16, !dbg !4154
  %conv2.i595 = trunc i32 %shr1.i594 to i8, !dbg !4155
  %idxprom3.i596 = zext i8 %conv2.i595 to i64, !dbg !4156
  %arrayidx4.i597 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i596, !dbg !4156
  %736 = load i32, i32* %arrayidx4.i597, align 4, !dbg !4156
  store i32 %736, i32* %a.addr.i.i587, align 4
  store i8 24, i8* %n.addr.i.i588, align 1
  %737 = load i32, i32* %a.addr.i.i587, align 4, !dbg !4157
  %738 = load i8, i8* %n.addr.i.i588, align 1, !dbg !4158
  %conv.i.i598 = zext i8 %738 to i32, !dbg !4158
  %shl.i.i599 = shl i32 %737, %conv.i.i598, !dbg !4159
  %739 = load i32, i32* %a.addr.i.i587, align 4, !dbg !4160
  %740 = load i8, i8* %n.addr.i.i588, align 1, !dbg !4161
  %conv1.i.i600 = zext i8 %740 to i32, !dbg !4161
  %sub.i.i601 = sub nsw i32 32, %conv1.i.i600, !dbg !4162
  %shr.i.i602 = lshr i32 %739, %sub.i.i601, !dbg !4163
  %or.i.i603 = or i32 %shl.i.i599, %shr.i.i602, !dbg !4164
  %xor.i604 = xor i32 %734, %or.i.i603, !dbg !4165
  %741 = load i32, i32* %X.addr.i589, align 4, !dbg !4166
  %shr5.i605 = lshr i32 %741, 8, !dbg !4167
  %conv6.i606 = trunc i32 %shr5.i605 to i8, !dbg !4168
  %idxprom7.i607 = zext i8 %conv6.i606 to i64, !dbg !4169
  %arrayidx8.i608 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i607, !dbg !4169
  %742 = load i32, i32* %arrayidx8.i608, align 4, !dbg !4169
  store i32 %742, i32* %a.addr.i24.i583, align 4
  store i8 16, i8* %n.addr.i25.i584, align 1
  %743 = load i32, i32* %a.addr.i24.i583, align 4, !dbg !4170
  %744 = load i8, i8* %n.addr.i25.i584, align 1, !dbg !4171
  %conv.i26.i609 = zext i8 %744 to i32, !dbg !4171
  %shl.i27.i610 = shl i32 %743, %conv.i26.i609, !dbg !4172
  %745 = load i32, i32* %a.addr.i24.i583, align 4, !dbg !4173
  %746 = load i8, i8* %n.addr.i25.i584, align 1, !dbg !4174
  %conv1.i28.i611 = zext i8 %746 to i32, !dbg !4174
  %sub.i29.i612 = sub nsw i32 32, %conv1.i28.i611, !dbg !4175
  %shr.i30.i613 = lshr i32 %745, %sub.i29.i612, !dbg !4176
  %or.i31.i614 = or i32 %shl.i27.i610, %shr.i30.i613, !dbg !4177
  %xor10.i615 = xor i32 %xor.i604, %or.i31.i614, !dbg !4178
  %747 = load i32, i32* %X.addr.i589, align 4, !dbg !4179
  %conv11.i616 = trunc i32 %747 to i8, !dbg !4180
  %idxprom12.i617 = zext i8 %conv11.i616 to i64, !dbg !4181
  %arrayidx13.i618 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i617, !dbg !4181
  %748 = load i32, i32* %arrayidx13.i618, align 4, !dbg !4181
  store i32 %748, i32* %a.addr.i16.i585, align 4
  store i8 8, i8* %n.addr.i17.i586, align 1
  %749 = load i32, i32* %a.addr.i16.i585, align 4, !dbg !4182
  %750 = load i8, i8* %n.addr.i17.i586, align 1, !dbg !4183
  %conv.i18.i619 = zext i8 %750 to i32, !dbg !4183
  %shl.i19.i620 = shl i32 %749, %conv.i18.i619, !dbg !4184
  %751 = load i32, i32* %a.addr.i16.i585, align 4, !dbg !4185
  %752 = load i8, i8* %n.addr.i17.i586, align 1, !dbg !4186
  %conv1.i20.i621 = zext i8 %752 to i32, !dbg !4186
  %sub.i21.i622 = sub nsw i32 32, %conv1.i20.i621, !dbg !4187
  %shr.i22.i623 = lshr i32 %751, %sub.i21.i622, !dbg !4188
  %or.i23.i624 = or i32 %shl.i19.i620, %shr.i22.i623, !dbg !4189
  %xor15.i625 = xor i32 %xor10.i615, %or.i23.i624, !dbg !4190
  %753 = load i32, i32* %B0, align 4, !dbg !4148
  %xor186 = xor i32 %753, %xor15.i625, !dbg !4148
  store i32 %xor186, i32* %B0, align 4, !dbg !4148
  %754 = load i32, i32* %B0, align 4, !dbg !4148
  %755 = load i32, i32* %B2, align 4, !dbg !4148
  %xor187 = xor i32 %754, %755, !dbg !4148
  %756 = load i32, i32* %B3, align 4, !dbg !4148
  %xor188 = xor i32 %xor187, %756, !dbg !4148
  %757 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !4148
  %rk189 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %757, i32 0, i32 0, !dbg !4148
  %arrayidx190 = getelementptr inbounds [32 x i32], [32 x i32]* %rk189, i64 0, i64 6, !dbg !4148
  %758 = load i32, i32* %arrayidx190, align 4, !dbg !4148
  %xor191 = xor i32 %xor188, %758, !dbg !4148
  store i32 %xor191, i32* %X.addr.i546, align 4
  %759 = load i32, i32* %X.addr.i546, align 4, !dbg !4191
  %shr.i547 = lshr i32 %759, 24, !dbg !4192
  %conv.i548 = trunc i32 %shr.i547 to i8, !dbg !4193
  %idxprom.i549 = zext i8 %conv.i548 to i64, !dbg !4194
  %arrayidx.i550 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i549, !dbg !4194
  %760 = load i32, i32* %arrayidx.i550, align 4, !dbg !4194
  %761 = load i32, i32* %X.addr.i546, align 4, !dbg !4195
  %shr1.i551 = lshr i32 %761, 16, !dbg !4196
  %conv2.i552 = trunc i32 %shr1.i551 to i8, !dbg !4197
  %idxprom3.i553 = zext i8 %conv2.i552 to i64, !dbg !4198
  %arrayidx4.i554 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i553, !dbg !4198
  %762 = load i32, i32* %arrayidx4.i554, align 4, !dbg !4198
  store i32 %762, i32* %a.addr.i.i544, align 4
  store i8 24, i8* %n.addr.i.i545, align 1
  %763 = load i32, i32* %a.addr.i.i544, align 4, !dbg !4199
  %764 = load i8, i8* %n.addr.i.i545, align 1, !dbg !4200
  %conv.i.i555 = zext i8 %764 to i32, !dbg !4200
  %shl.i.i556 = shl i32 %763, %conv.i.i555, !dbg !4201
  %765 = load i32, i32* %a.addr.i.i544, align 4, !dbg !4202
  %766 = load i8, i8* %n.addr.i.i545, align 1, !dbg !4203
  %conv1.i.i557 = zext i8 %766 to i32, !dbg !4203
  %sub.i.i558 = sub nsw i32 32, %conv1.i.i557, !dbg !4204
  %shr.i.i559 = lshr i32 %765, %sub.i.i558, !dbg !4205
  %or.i.i560 = or i32 %shl.i.i556, %shr.i.i559, !dbg !4206
  %xor.i561 = xor i32 %760, %or.i.i560, !dbg !4207
  %767 = load i32, i32* %X.addr.i546, align 4, !dbg !4208
  %shr5.i562 = lshr i32 %767, 8, !dbg !4209
  %conv6.i563 = trunc i32 %shr5.i562 to i8, !dbg !4210
  %idxprom7.i564 = zext i8 %conv6.i563 to i64, !dbg !4211
  %arrayidx8.i565 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i564, !dbg !4211
  %768 = load i32, i32* %arrayidx8.i565, align 4, !dbg !4211
  store i32 %768, i32* %a.addr.i24.i540, align 4
  store i8 16, i8* %n.addr.i25.i541, align 1
  %769 = load i32, i32* %a.addr.i24.i540, align 4, !dbg !4212
  %770 = load i8, i8* %n.addr.i25.i541, align 1, !dbg !4213
  %conv.i26.i566 = zext i8 %770 to i32, !dbg !4213
  %shl.i27.i567 = shl i32 %769, %conv.i26.i566, !dbg !4214
  %771 = load i32, i32* %a.addr.i24.i540, align 4, !dbg !4215
  %772 = load i8, i8* %n.addr.i25.i541, align 1, !dbg !4216
  %conv1.i28.i568 = zext i8 %772 to i32, !dbg !4216
  %sub.i29.i569 = sub nsw i32 32, %conv1.i28.i568, !dbg !4217
  %shr.i30.i570 = lshr i32 %771, %sub.i29.i569, !dbg !4218
  %or.i31.i571 = or i32 %shl.i27.i567, %shr.i30.i570, !dbg !4219
  %xor10.i572 = xor i32 %xor.i561, %or.i31.i571, !dbg !4220
  %773 = load i32, i32* %X.addr.i546, align 4, !dbg !4221
  %conv11.i573 = trunc i32 %773 to i8, !dbg !4222
  %idxprom12.i574 = zext i8 %conv11.i573 to i64, !dbg !4223
  %arrayidx13.i575 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i574, !dbg !4223
  %774 = load i32, i32* %arrayidx13.i575, align 4, !dbg !4223
  store i32 %774, i32* %a.addr.i16.i542, align 4
  store i8 8, i8* %n.addr.i17.i543, align 1
  %775 = load i32, i32* %a.addr.i16.i542, align 4, !dbg !4224
  %776 = load i8, i8* %n.addr.i17.i543, align 1, !dbg !4225
  %conv.i18.i576 = zext i8 %776 to i32, !dbg !4225
  %shl.i19.i577 = shl i32 %775, %conv.i18.i576, !dbg !4226
  %777 = load i32, i32* %a.addr.i16.i542, align 4, !dbg !4227
  %778 = load i8, i8* %n.addr.i17.i543, align 1, !dbg !4228
  %conv1.i20.i578 = zext i8 %778 to i32, !dbg !4228
  %sub.i21.i579 = sub nsw i32 32, %conv1.i20.i578, !dbg !4229
  %shr.i22.i580 = lshr i32 %777, %sub.i21.i579, !dbg !4230
  %or.i23.i581 = or i32 %shl.i19.i577, %shr.i22.i580, !dbg !4231
  %xor15.i582 = xor i32 %xor10.i572, %or.i23.i581, !dbg !4232
  %779 = load i32, i32* %B1, align 4, !dbg !4148
  %xor193 = xor i32 %779, %xor15.i582, !dbg !4148
  store i32 %xor193, i32* %B1, align 4, !dbg !4148
  %780 = load i32, i32* %B0, align 4, !dbg !4148
  %781 = load i32, i32* %B1, align 4, !dbg !4148
  %xor194 = xor i32 %780, %781, !dbg !4148
  %782 = load i32, i32* %B3, align 4, !dbg !4148
  %xor195 = xor i32 %xor194, %782, !dbg !4148
  %783 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !4148
  %rk196 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %783, i32 0, i32 0, !dbg !4148
  %arrayidx197 = getelementptr inbounds [32 x i32], [32 x i32]* %rk196, i64 0, i64 5, !dbg !4148
  %784 = load i32, i32* %arrayidx197, align 4, !dbg !4148
  %xor198 = xor i32 %xor195, %784, !dbg !4148
  store i32 %xor198, i32* %X.addr.i503, align 4
  %785 = load i32, i32* %X.addr.i503, align 4, !dbg !4233
  %shr.i504 = lshr i32 %785, 24, !dbg !4234
  %conv.i505 = trunc i32 %shr.i504 to i8, !dbg !4235
  %idxprom.i506 = zext i8 %conv.i505 to i64, !dbg !4236
  %arrayidx.i507 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i506, !dbg !4236
  %786 = load i32, i32* %arrayidx.i507, align 4, !dbg !4236
  %787 = load i32, i32* %X.addr.i503, align 4, !dbg !4237
  %shr1.i508 = lshr i32 %787, 16, !dbg !4238
  %conv2.i509 = trunc i32 %shr1.i508 to i8, !dbg !4239
  %idxprom3.i510 = zext i8 %conv2.i509 to i64, !dbg !4240
  %arrayidx4.i511 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i510, !dbg !4240
  %788 = load i32, i32* %arrayidx4.i511, align 4, !dbg !4240
  store i32 %788, i32* %a.addr.i.i501, align 4
  store i8 24, i8* %n.addr.i.i502, align 1
  %789 = load i32, i32* %a.addr.i.i501, align 4, !dbg !4241
  %790 = load i8, i8* %n.addr.i.i502, align 1, !dbg !4242
  %conv.i.i512 = zext i8 %790 to i32, !dbg !4242
  %shl.i.i513 = shl i32 %789, %conv.i.i512, !dbg !4243
  %791 = load i32, i32* %a.addr.i.i501, align 4, !dbg !4244
  %792 = load i8, i8* %n.addr.i.i502, align 1, !dbg !4245
  %conv1.i.i514 = zext i8 %792 to i32, !dbg !4245
  %sub.i.i515 = sub nsw i32 32, %conv1.i.i514, !dbg !4246
  %shr.i.i516 = lshr i32 %791, %sub.i.i515, !dbg !4247
  %or.i.i517 = or i32 %shl.i.i513, %shr.i.i516, !dbg !4248
  %xor.i518 = xor i32 %786, %or.i.i517, !dbg !4249
  %793 = load i32, i32* %X.addr.i503, align 4, !dbg !4250
  %shr5.i519 = lshr i32 %793, 8, !dbg !4251
  %conv6.i520 = trunc i32 %shr5.i519 to i8, !dbg !4252
  %idxprom7.i521 = zext i8 %conv6.i520 to i64, !dbg !4253
  %arrayidx8.i522 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i521, !dbg !4253
  %794 = load i32, i32* %arrayidx8.i522, align 4, !dbg !4253
  store i32 %794, i32* %a.addr.i24.i497, align 4
  store i8 16, i8* %n.addr.i25.i498, align 1
  %795 = load i32, i32* %a.addr.i24.i497, align 4, !dbg !4254
  %796 = load i8, i8* %n.addr.i25.i498, align 1, !dbg !4255
  %conv.i26.i523 = zext i8 %796 to i32, !dbg !4255
  %shl.i27.i524 = shl i32 %795, %conv.i26.i523, !dbg !4256
  %797 = load i32, i32* %a.addr.i24.i497, align 4, !dbg !4257
  %798 = load i8, i8* %n.addr.i25.i498, align 1, !dbg !4258
  %conv1.i28.i525 = zext i8 %798 to i32, !dbg !4258
  %sub.i29.i526 = sub nsw i32 32, %conv1.i28.i525, !dbg !4259
  %shr.i30.i527 = lshr i32 %797, %sub.i29.i526, !dbg !4260
  %or.i31.i528 = or i32 %shl.i27.i524, %shr.i30.i527, !dbg !4261
  %xor10.i529 = xor i32 %xor.i518, %or.i31.i528, !dbg !4262
  %799 = load i32, i32* %X.addr.i503, align 4, !dbg !4263
  %conv11.i530 = trunc i32 %799 to i8, !dbg !4264
  %idxprom12.i531 = zext i8 %conv11.i530 to i64, !dbg !4265
  %arrayidx13.i532 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i531, !dbg !4265
  %800 = load i32, i32* %arrayidx13.i532, align 4, !dbg !4265
  store i32 %800, i32* %a.addr.i16.i499, align 4
  store i8 8, i8* %n.addr.i17.i500, align 1
  %801 = load i32, i32* %a.addr.i16.i499, align 4, !dbg !4266
  %802 = load i8, i8* %n.addr.i17.i500, align 1, !dbg !4267
  %conv.i18.i533 = zext i8 %802 to i32, !dbg !4267
  %shl.i19.i534 = shl i32 %801, %conv.i18.i533, !dbg !4268
  %803 = load i32, i32* %a.addr.i16.i499, align 4, !dbg !4269
  %804 = load i8, i8* %n.addr.i17.i500, align 1, !dbg !4270
  %conv1.i20.i535 = zext i8 %804 to i32, !dbg !4270
  %sub.i21.i536 = sub nsw i32 32, %conv1.i20.i535, !dbg !4271
  %shr.i22.i537 = lshr i32 %803, %sub.i21.i536, !dbg !4272
  %or.i23.i538 = or i32 %shl.i19.i534, %shr.i22.i537, !dbg !4273
  %xor15.i539 = xor i32 %xor10.i529, %or.i23.i538, !dbg !4274
  %805 = load i32, i32* %B2, align 4, !dbg !4148
  %xor200 = xor i32 %805, %xor15.i539, !dbg !4148
  store i32 %xor200, i32* %B2, align 4, !dbg !4148
  %806 = load i32, i32* %B0, align 4, !dbg !4148
  %807 = load i32, i32* %B1, align 4, !dbg !4148
  %xor201 = xor i32 %806, %807, !dbg !4148
  %808 = load i32, i32* %B2, align 4, !dbg !4148
  %xor202 = xor i32 %xor201, %808, !dbg !4148
  %809 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !4148
  %rk203 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %809, i32 0, i32 0, !dbg !4148
  %arrayidx204 = getelementptr inbounds [32 x i32], [32 x i32]* %rk203, i64 0, i64 4, !dbg !4148
  %810 = load i32, i32* %arrayidx204, align 4, !dbg !4148
  %xor205 = xor i32 %xor202, %810, !dbg !4148
  store i32 %xor205, i32* %X.addr.i481, align 4
  %811 = load i32, i32* %X.addr.i481, align 4, !dbg !4275
  %shr.i482 = lshr i32 %811, 24, !dbg !4276
  %conv.i483 = trunc i32 %shr.i482 to i8, !dbg !4277
  %idxprom.i484 = zext i8 %conv.i483 to i64, !dbg !4278
  %arrayidx.i485 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i484, !dbg !4278
  %812 = load i32, i32* %arrayidx.i485, align 4, !dbg !4278
  %813 = load i32, i32* %X.addr.i481, align 4, !dbg !4279
  %shr1.i486 = lshr i32 %813, 16, !dbg !4280
  %conv2.i487 = trunc i32 %shr1.i486 to i8, !dbg !4281
  %idxprom3.i = zext i8 %conv2.i487 to i64, !dbg !4282
  %arrayidx4.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i, !dbg !4282
  %814 = load i32, i32* %arrayidx4.i, align 4, !dbg !4282
  store i32 %814, i32* %a.addr.i.i479, align 4
  store i8 24, i8* %n.addr.i.i480, align 1
  %815 = load i32, i32* %a.addr.i.i479, align 4, !dbg !4283
  %816 = load i8, i8* %n.addr.i.i480, align 1, !dbg !4284
  %conv.i.i488 = zext i8 %816 to i32, !dbg !4284
  %shl.i.i489 = shl i32 %815, %conv.i.i488, !dbg !4285
  %817 = load i32, i32* %a.addr.i.i479, align 4, !dbg !4286
  %818 = load i8, i8* %n.addr.i.i480, align 1, !dbg !4287
  %conv1.i.i490 = zext i8 %818 to i32, !dbg !4287
  %sub.i.i491 = sub nsw i32 32, %conv1.i.i490, !dbg !4288
  %shr.i.i492 = lshr i32 %817, %sub.i.i491, !dbg !4289
  %or.i.i493 = or i32 %shl.i.i489, %shr.i.i492, !dbg !4290
  %xor.i494 = xor i32 %812, %or.i.i493, !dbg !4291
  %819 = load i32, i32* %X.addr.i481, align 4, !dbg !4292
  %shr5.i = lshr i32 %819, 8, !dbg !4293
  %conv6.i495 = trunc i32 %shr5.i to i8, !dbg !4294
  %idxprom7.i = zext i8 %conv6.i495 to i64, !dbg !4295
  %arrayidx8.i496 = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i, !dbg !4295
  %820 = load i32, i32* %arrayidx8.i496, align 4, !dbg !4295
  store i32 %820, i32* %a.addr.i24.i, align 4
  store i8 16, i8* %n.addr.i25.i, align 1
  %821 = load i32, i32* %a.addr.i24.i, align 4, !dbg !4296
  %822 = load i8, i8* %n.addr.i25.i, align 1, !dbg !4297
  %conv.i26.i = zext i8 %822 to i32, !dbg !4297
  %shl.i27.i = shl i32 %821, %conv.i26.i, !dbg !4298
  %823 = load i32, i32* %a.addr.i24.i, align 4, !dbg !4299
  %824 = load i8, i8* %n.addr.i25.i, align 1, !dbg !4300
  %conv1.i28.i = zext i8 %824 to i32, !dbg !4300
  %sub.i29.i = sub nsw i32 32, %conv1.i28.i, !dbg !4301
  %shr.i30.i = lshr i32 %823, %sub.i29.i, !dbg !4302
  %or.i31.i = or i32 %shl.i27.i, %shr.i30.i, !dbg !4303
  %xor10.i = xor i32 %xor.i494, %or.i31.i, !dbg !4304
  %825 = load i32, i32* %X.addr.i481, align 4, !dbg !4305
  %conv11.i = trunc i32 %825 to i8, !dbg !4306
  %idxprom12.i = zext i8 %conv11.i to i64, !dbg !4307
  %arrayidx13.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i, !dbg !4307
  %826 = load i32, i32* %arrayidx13.i, align 4, !dbg !4307
  store i32 %826, i32* %a.addr.i16.i, align 4
  store i8 8, i8* %n.addr.i17.i, align 1
  %827 = load i32, i32* %a.addr.i16.i, align 4, !dbg !4308
  %828 = load i8, i8* %n.addr.i17.i, align 1, !dbg !4309
  %conv.i18.i = zext i8 %828 to i32, !dbg !4309
  %shl.i19.i = shl i32 %827, %conv.i18.i, !dbg !4310
  %829 = load i32, i32* %a.addr.i16.i, align 4, !dbg !4311
  %830 = load i8, i8* %n.addr.i17.i, align 1, !dbg !4312
  %conv1.i20.i = zext i8 %830 to i32, !dbg !4312
  %sub.i21.i = sub nsw i32 32, %conv1.i20.i, !dbg !4313
  %shr.i22.i = lshr i32 %829, %sub.i21.i, !dbg !4314
  %or.i23.i = or i32 %shl.i19.i, %shr.i22.i, !dbg !4315
  %xor15.i = xor i32 %xor10.i, %or.i23.i, !dbg !4316
  %831 = load i32, i32* %B3, align 4, !dbg !4148
  %xor207 = xor i32 %831, %xor15.i, !dbg !4148
  store i32 %xor207, i32* %B3, align 4, !dbg !4148
  br label %do.end208, !dbg !4148

do.end208:                                        ; preds = %do.body179
  br label %do.body209, !dbg !4317

do.body209:                                       ; preds = %do.end208
  %832 = load i32, i32* %B1, align 4, !dbg !4318
  %833 = load i32, i32* %B2, align 4, !dbg !4318
  %xor210 = xor i32 %832, %833, !dbg !4318
  %834 = load i32, i32* %B3, align 4, !dbg !4318
  %xor211 = xor i32 %xor210, %834, !dbg !4318
  %835 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !4318
  %rk212 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %835, i32 0, i32 0, !dbg !4318
  %arrayidx213 = getelementptr inbounds [32 x i32], [32 x i32]* %rk212, i64 0, i64 3, !dbg !4318
  %836 = load i32, i32* %arrayidx213, align 4, !dbg !4318
  %xor214 = xor i32 %xor211, %836, !dbg !4318
  store i32 %xor214, i32* %X.addr.i423, align 4
  store i32 0, i32* %t.i424, align 4, !dbg !2852
  %837 = load i32, i32* %X.addr.i423, align 4, !dbg !4319
  %shr.i425 = lshr i32 %837, 24, !dbg !4320
  %conv.i426 = trunc i32 %shr.i425 to i8, !dbg !4321
  %idxprom.i427 = zext i8 %conv.i426 to i64, !dbg !4322
  %arrayidx.i428 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom.i427, !dbg !4322
  %838 = load i8, i8* %arrayidx.i428, align 1, !dbg !4322
  %conv1.i429 = zext i8 %838 to i32, !dbg !4323
  %shl.i430 = shl i32 %conv1.i429, 24, !dbg !4324
  %839 = load i32, i32* %t.i424, align 4, !dbg !4325
  %or.i431 = or i32 %839, %shl.i430, !dbg !4325
  store i32 %or.i431, i32* %t.i424, align 4, !dbg !4325
  %840 = load i32, i32* %X.addr.i423, align 4, !dbg !4326
  %shr2.i432 = lshr i32 %840, 16, !dbg !4327
  %conv3.i433 = trunc i32 %shr2.i432 to i8, !dbg !4328
  %idxprom4.i434 = zext i8 %conv3.i433 to i64, !dbg !4329
  %arrayidx5.i435 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom4.i434, !dbg !4329
  %841 = load i8, i8* %arrayidx5.i435, align 1, !dbg !4329
  %conv6.i436 = zext i8 %841 to i32, !dbg !4330
  %shl7.i437 = shl i32 %conv6.i436, 16, !dbg !4331
  %842 = load i32, i32* %t.i424, align 4, !dbg !4332
  %or8.i438 = or i32 %842, %shl7.i437, !dbg !4332
  store i32 %or8.i438, i32* %t.i424, align 4, !dbg !4332
  %843 = load i32, i32* %X.addr.i423, align 4, !dbg !4333
  %shr9.i439 = lshr i32 %843, 8, !dbg !4334
  %conv10.i440 = trunc i32 %shr9.i439 to i8, !dbg !4335
  %idxprom11.i441 = zext i8 %conv10.i440 to i64, !dbg !4336
  %arrayidx12.i442 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom11.i441, !dbg !4336
  %844 = load i8, i8* %arrayidx12.i442, align 1, !dbg !4336
  %conv13.i443 = zext i8 %844 to i32, !dbg !4337
  %shl14.i444 = shl i32 %conv13.i443, 8, !dbg !4338
  %845 = load i32, i32* %t.i424, align 4, !dbg !4339
  %or15.i445 = or i32 %845, %shl14.i444, !dbg !4339
  store i32 %or15.i445, i32* %t.i424, align 4, !dbg !4339
  %846 = load i32, i32* %X.addr.i423, align 4, !dbg !4340
  %conv16.i446 = trunc i32 %846 to i8, !dbg !4341
  %idxprom17.i447 = zext i8 %conv16.i446 to i64, !dbg !4342
  %arrayidx18.i448 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom17.i447, !dbg !4342
  %847 = load i8, i8* %arrayidx18.i448, align 1, !dbg !4342
  %conv19.i449 = zext i8 %847 to i32, !dbg !4342
  %848 = load i32, i32* %t.i424, align 4, !dbg !4343
  %or20.i450 = or i32 %848, %conv19.i449, !dbg !4343
  store i32 %or20.i450, i32* %t.i424, align 4, !dbg !4343
  %849 = load i32, i32* %t.i424, align 4, !dbg !4344
  %850 = load i32, i32* %t.i424, align 4, !dbg !4345
  store i32 %850, i32* %a.addr.i.i421, align 4
  store i8 2, i8* %n.addr.i.i422, align 1
  %851 = load i32, i32* %a.addr.i.i421, align 4, !dbg !4346
  %852 = load i8, i8* %n.addr.i.i422, align 1, !dbg !4347
  %conv.i.i451 = zext i8 %852 to i32, !dbg !4347
  %shl.i.i452 = shl i32 %851, %conv.i.i451, !dbg !4348
  %853 = load i32, i32* %a.addr.i.i421, align 4, !dbg !4349
  %854 = load i8, i8* %n.addr.i.i422, align 1, !dbg !4350
  %conv1.i.i453 = zext i8 %854 to i32, !dbg !4350
  %sub.i.i454 = sub nsw i32 32, %conv1.i.i453, !dbg !4351
  %shr.i.i455 = lshr i32 %853, %sub.i.i454, !dbg !4352
  %or.i.i456 = or i32 %shl.i.i452, %shr.i.i455, !dbg !4353
  %xor.i457 = xor i32 %849, %or.i.i456, !dbg !4354
  %855 = load i32, i32* %t.i424, align 4, !dbg !4355
  store i32 %855, i32* %a.addr.i43.i415, align 4
  store i8 10, i8* %n.addr.i44.i416, align 1
  %856 = load i32, i32* %a.addr.i43.i415, align 4, !dbg !4356
  %857 = load i8, i8* %n.addr.i44.i416, align 1, !dbg !4357
  %conv.i45.i458 = zext i8 %857 to i32, !dbg !4357
  %shl.i46.i459 = shl i32 %856, %conv.i45.i458, !dbg !4358
  %858 = load i32, i32* %a.addr.i43.i415, align 4, !dbg !4359
  %859 = load i8, i8* %n.addr.i44.i416, align 1, !dbg !4360
  %conv1.i47.i460 = zext i8 %859 to i32, !dbg !4360
  %sub.i48.i461 = sub nsw i32 32, %conv1.i47.i460, !dbg !4361
  %shr.i49.i462 = lshr i32 %858, %sub.i48.i461, !dbg !4362
  %or.i50.i463 = or i32 %shl.i46.i459, %shr.i49.i462, !dbg !4363
  %xor22.i464 = xor i32 %xor.i457, %or.i50.i463, !dbg !4364
  %860 = load i32, i32* %t.i424, align 4, !dbg !4365
  store i32 %860, i32* %a.addr.i35.i417, align 4
  store i8 18, i8* %n.addr.i36.i418, align 1
  %861 = load i32, i32* %a.addr.i35.i417, align 4, !dbg !4366
  %862 = load i8, i8* %n.addr.i36.i418, align 1, !dbg !4367
  %conv.i37.i465 = zext i8 %862 to i32, !dbg !4367
  %shl.i38.i466 = shl i32 %861, %conv.i37.i465, !dbg !4368
  %863 = load i32, i32* %a.addr.i35.i417, align 4, !dbg !4369
  %864 = load i8, i8* %n.addr.i36.i418, align 1, !dbg !4370
  %conv1.i39.i467 = zext i8 %864 to i32, !dbg !4370
  %sub.i40.i468 = sub nsw i32 32, %conv1.i39.i467, !dbg !4371
  %shr.i41.i469 = lshr i32 %863, %sub.i40.i468, !dbg !4372
  %or.i42.i470 = or i32 %shl.i38.i466, %shr.i41.i469, !dbg !4373
  %xor24.i471 = xor i32 %xor22.i464, %or.i42.i470, !dbg !4374
  %865 = load i32, i32* %t.i424, align 4, !dbg !4375
  store i32 %865, i32* %a.addr.i27.i419, align 4
  store i8 24, i8* %n.addr.i28.i420, align 1
  %866 = load i32, i32* %a.addr.i27.i419, align 4, !dbg !4376
  %867 = load i8, i8* %n.addr.i28.i420, align 1, !dbg !4377
  %conv.i29.i472 = zext i8 %867 to i32, !dbg !4377
  %shl.i30.i473 = shl i32 %866, %conv.i29.i472, !dbg !4378
  %868 = load i32, i32* %a.addr.i27.i419, align 4, !dbg !4379
  %869 = load i8, i8* %n.addr.i28.i420, align 1, !dbg !4380
  %conv1.i31.i474 = zext i8 %869 to i32, !dbg !4380
  %sub.i32.i475 = sub nsw i32 32, %conv1.i31.i474, !dbg !4381
  %shr.i33.i476 = lshr i32 %868, %sub.i32.i475, !dbg !4382
  %or.i34.i477 = or i32 %shl.i30.i473, %shr.i33.i476, !dbg !4383
  %xor26.i478 = xor i32 %xor24.i471, %or.i34.i477, !dbg !4384
  %870 = load i32, i32* %B0, align 4, !dbg !4318
  %xor216 = xor i32 %870, %xor26.i478, !dbg !4318
  store i32 %xor216, i32* %B0, align 4, !dbg !4318
  %871 = load i32, i32* %B0, align 4, !dbg !4318
  %872 = load i32, i32* %B2, align 4, !dbg !4318
  %xor217 = xor i32 %871, %872, !dbg !4318
  %873 = load i32, i32* %B3, align 4, !dbg !4318
  %xor218 = xor i32 %xor217, %873, !dbg !4318
  %874 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !4318
  %rk219 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %874, i32 0, i32 0, !dbg !4318
  %arrayidx220 = getelementptr inbounds [32 x i32], [32 x i32]* %rk219, i64 0, i64 2, !dbg !4318
  %875 = load i32, i32* %arrayidx220, align 4, !dbg !4318
  %xor221 = xor i32 %xor218, %875, !dbg !4318
  store i32 %xor221, i32* %X.addr.i359, align 4
  store i32 0, i32* %t.i360, align 4, !dbg !2867
  %876 = load i32, i32* %X.addr.i359, align 4, !dbg !4385
  %shr.i361 = lshr i32 %876, 24, !dbg !4386
  %conv.i362 = trunc i32 %shr.i361 to i8, !dbg !4387
  %idxprom.i363 = zext i8 %conv.i362 to i64, !dbg !4388
  %arrayidx.i364 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom.i363, !dbg !4388
  %877 = load i8, i8* %arrayidx.i364, align 1, !dbg !4388
  %conv1.i365 = zext i8 %877 to i32, !dbg !4389
  %shl.i366 = shl i32 %conv1.i365, 24, !dbg !4390
  %878 = load i32, i32* %t.i360, align 4, !dbg !4391
  %or.i367 = or i32 %878, %shl.i366, !dbg !4391
  store i32 %or.i367, i32* %t.i360, align 4, !dbg !4391
  %879 = load i32, i32* %X.addr.i359, align 4, !dbg !4392
  %shr2.i368 = lshr i32 %879, 16, !dbg !4393
  %conv3.i369 = trunc i32 %shr2.i368 to i8, !dbg !4394
  %idxprom4.i370 = zext i8 %conv3.i369 to i64, !dbg !4395
  %arrayidx5.i371 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom4.i370, !dbg !4395
  %880 = load i8, i8* %arrayidx5.i371, align 1, !dbg !4395
  %conv6.i372 = zext i8 %880 to i32, !dbg !4396
  %shl7.i373 = shl i32 %conv6.i372, 16, !dbg !4397
  %881 = load i32, i32* %t.i360, align 4, !dbg !4398
  %or8.i374 = or i32 %881, %shl7.i373, !dbg !4398
  store i32 %or8.i374, i32* %t.i360, align 4, !dbg !4398
  %882 = load i32, i32* %X.addr.i359, align 4, !dbg !4399
  %shr9.i375 = lshr i32 %882, 8, !dbg !4400
  %conv10.i376 = trunc i32 %shr9.i375 to i8, !dbg !4401
  %idxprom11.i377 = zext i8 %conv10.i376 to i64, !dbg !4402
  %arrayidx12.i378 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom11.i377, !dbg !4402
  %883 = load i8, i8* %arrayidx12.i378, align 1, !dbg !4402
  %conv13.i379 = zext i8 %883 to i32, !dbg !4403
  %shl14.i380 = shl i32 %conv13.i379, 8, !dbg !4404
  %884 = load i32, i32* %t.i360, align 4, !dbg !4405
  %or15.i381 = or i32 %884, %shl14.i380, !dbg !4405
  store i32 %or15.i381, i32* %t.i360, align 4, !dbg !4405
  %885 = load i32, i32* %X.addr.i359, align 4, !dbg !4406
  %conv16.i382 = trunc i32 %885 to i8, !dbg !4407
  %idxprom17.i383 = zext i8 %conv16.i382 to i64, !dbg !4408
  %arrayidx18.i384 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom17.i383, !dbg !4408
  %886 = load i8, i8* %arrayidx18.i384, align 1, !dbg !4408
  %conv19.i385 = zext i8 %886 to i32, !dbg !4408
  %887 = load i32, i32* %t.i360, align 4, !dbg !4409
  %or20.i386 = or i32 %887, %conv19.i385, !dbg !4409
  store i32 %or20.i386, i32* %t.i360, align 4, !dbg !4409
  %888 = load i32, i32* %t.i360, align 4, !dbg !4410
  %889 = load i32, i32* %t.i360, align 4, !dbg !4411
  store i32 %889, i32* %a.addr.i.i357, align 4
  store i8 2, i8* %n.addr.i.i358, align 1
  %890 = load i32, i32* %a.addr.i.i357, align 4, !dbg !4412
  %891 = load i8, i8* %n.addr.i.i358, align 1, !dbg !4413
  %conv.i.i387 = zext i8 %891 to i32, !dbg !4413
  %shl.i.i388 = shl i32 %890, %conv.i.i387, !dbg !4414
  %892 = load i32, i32* %a.addr.i.i357, align 4, !dbg !4415
  %893 = load i8, i8* %n.addr.i.i358, align 1, !dbg !4416
  %conv1.i.i389 = zext i8 %893 to i32, !dbg !4416
  %sub.i.i390 = sub nsw i32 32, %conv1.i.i389, !dbg !4417
  %shr.i.i391 = lshr i32 %892, %sub.i.i390, !dbg !4418
  %or.i.i392 = or i32 %shl.i.i388, %shr.i.i391, !dbg !4419
  %xor.i393 = xor i32 %888, %or.i.i392, !dbg !4420
  %894 = load i32, i32* %t.i360, align 4, !dbg !4421
  store i32 %894, i32* %a.addr.i43.i351, align 4
  store i8 10, i8* %n.addr.i44.i352, align 1
  %895 = load i32, i32* %a.addr.i43.i351, align 4, !dbg !4422
  %896 = load i8, i8* %n.addr.i44.i352, align 1, !dbg !4423
  %conv.i45.i394 = zext i8 %896 to i32, !dbg !4423
  %shl.i46.i395 = shl i32 %895, %conv.i45.i394, !dbg !4424
  %897 = load i32, i32* %a.addr.i43.i351, align 4, !dbg !4425
  %898 = load i8, i8* %n.addr.i44.i352, align 1, !dbg !4426
  %conv1.i47.i396 = zext i8 %898 to i32, !dbg !4426
  %sub.i48.i397 = sub nsw i32 32, %conv1.i47.i396, !dbg !4427
  %shr.i49.i398 = lshr i32 %897, %sub.i48.i397, !dbg !4428
  %or.i50.i399 = or i32 %shl.i46.i395, %shr.i49.i398, !dbg !4429
  %xor22.i400 = xor i32 %xor.i393, %or.i50.i399, !dbg !4430
  %899 = load i32, i32* %t.i360, align 4, !dbg !4431
  store i32 %899, i32* %a.addr.i35.i353, align 4
  store i8 18, i8* %n.addr.i36.i354, align 1
  %900 = load i32, i32* %a.addr.i35.i353, align 4, !dbg !4432
  %901 = load i8, i8* %n.addr.i36.i354, align 1, !dbg !4433
  %conv.i37.i401 = zext i8 %901 to i32, !dbg !4433
  %shl.i38.i402 = shl i32 %900, %conv.i37.i401, !dbg !4434
  %902 = load i32, i32* %a.addr.i35.i353, align 4, !dbg !4435
  %903 = load i8, i8* %n.addr.i36.i354, align 1, !dbg !4436
  %conv1.i39.i403 = zext i8 %903 to i32, !dbg !4436
  %sub.i40.i404 = sub nsw i32 32, %conv1.i39.i403, !dbg !4437
  %shr.i41.i405 = lshr i32 %902, %sub.i40.i404, !dbg !4438
  %or.i42.i406 = or i32 %shl.i38.i402, %shr.i41.i405, !dbg !4439
  %xor24.i407 = xor i32 %xor22.i400, %or.i42.i406, !dbg !4440
  %904 = load i32, i32* %t.i360, align 4, !dbg !4441
  store i32 %904, i32* %a.addr.i27.i355, align 4
  store i8 24, i8* %n.addr.i28.i356, align 1
  %905 = load i32, i32* %a.addr.i27.i355, align 4, !dbg !4442
  %906 = load i8, i8* %n.addr.i28.i356, align 1, !dbg !4443
  %conv.i29.i408 = zext i8 %906 to i32, !dbg !4443
  %shl.i30.i409 = shl i32 %905, %conv.i29.i408, !dbg !4444
  %907 = load i32, i32* %a.addr.i27.i355, align 4, !dbg !4445
  %908 = load i8, i8* %n.addr.i28.i356, align 1, !dbg !4446
  %conv1.i31.i410 = zext i8 %908 to i32, !dbg !4446
  %sub.i32.i411 = sub nsw i32 32, %conv1.i31.i410, !dbg !4447
  %shr.i33.i412 = lshr i32 %907, %sub.i32.i411, !dbg !4448
  %or.i34.i413 = or i32 %shl.i30.i409, %shr.i33.i412, !dbg !4449
  %xor26.i414 = xor i32 %xor24.i407, %or.i34.i413, !dbg !4450
  %909 = load i32, i32* %B1, align 4, !dbg !4318
  %xor223 = xor i32 %909, %xor26.i414, !dbg !4318
  store i32 %xor223, i32* %B1, align 4, !dbg !4318
  %910 = load i32, i32* %B0, align 4, !dbg !4318
  %911 = load i32, i32* %B1, align 4, !dbg !4318
  %xor224 = xor i32 %910, %911, !dbg !4318
  %912 = load i32, i32* %B3, align 4, !dbg !4318
  %xor225 = xor i32 %xor224, %912, !dbg !4318
  %913 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !4318
  %rk226 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %913, i32 0, i32 0, !dbg !4318
  %arrayidx227 = getelementptr inbounds [32 x i32], [32 x i32]* %rk226, i64 0, i64 1, !dbg !4318
  %914 = load i32, i32* %arrayidx227, align 4, !dbg !4318
  %xor228 = xor i32 %xor225, %914, !dbg !4318
  store i32 %xor228, i32* %X.addr.i295, align 4
  store i32 0, i32* %t.i296, align 4, !dbg !2882
  %915 = load i32, i32* %X.addr.i295, align 4, !dbg !4451
  %shr.i297 = lshr i32 %915, 24, !dbg !4452
  %conv.i298 = trunc i32 %shr.i297 to i8, !dbg !4453
  %idxprom.i299 = zext i8 %conv.i298 to i64, !dbg !4454
  %arrayidx.i300 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom.i299, !dbg !4454
  %916 = load i8, i8* %arrayidx.i300, align 1, !dbg !4454
  %conv1.i301 = zext i8 %916 to i32, !dbg !4455
  %shl.i302 = shl i32 %conv1.i301, 24, !dbg !4456
  %917 = load i32, i32* %t.i296, align 4, !dbg !4457
  %or.i303 = or i32 %917, %shl.i302, !dbg !4457
  store i32 %or.i303, i32* %t.i296, align 4, !dbg !4457
  %918 = load i32, i32* %X.addr.i295, align 4, !dbg !4458
  %shr2.i304 = lshr i32 %918, 16, !dbg !4459
  %conv3.i305 = trunc i32 %shr2.i304 to i8, !dbg !4460
  %idxprom4.i306 = zext i8 %conv3.i305 to i64, !dbg !4461
  %arrayidx5.i307 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom4.i306, !dbg !4461
  %919 = load i8, i8* %arrayidx5.i307, align 1, !dbg !4461
  %conv6.i308 = zext i8 %919 to i32, !dbg !4462
  %shl7.i309 = shl i32 %conv6.i308, 16, !dbg !4463
  %920 = load i32, i32* %t.i296, align 4, !dbg !4464
  %or8.i310 = or i32 %920, %shl7.i309, !dbg !4464
  store i32 %or8.i310, i32* %t.i296, align 4, !dbg !4464
  %921 = load i32, i32* %X.addr.i295, align 4, !dbg !4465
  %shr9.i311 = lshr i32 %921, 8, !dbg !4466
  %conv10.i312 = trunc i32 %shr9.i311 to i8, !dbg !4467
  %idxprom11.i313 = zext i8 %conv10.i312 to i64, !dbg !4468
  %arrayidx12.i314 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom11.i313, !dbg !4468
  %922 = load i8, i8* %arrayidx12.i314, align 1, !dbg !4468
  %conv13.i315 = zext i8 %922 to i32, !dbg !4469
  %shl14.i316 = shl i32 %conv13.i315, 8, !dbg !4470
  %923 = load i32, i32* %t.i296, align 4, !dbg !4471
  %or15.i317 = or i32 %923, %shl14.i316, !dbg !4471
  store i32 %or15.i317, i32* %t.i296, align 4, !dbg !4471
  %924 = load i32, i32* %X.addr.i295, align 4, !dbg !4472
  %conv16.i318 = trunc i32 %924 to i8, !dbg !4473
  %idxprom17.i319 = zext i8 %conv16.i318 to i64, !dbg !4474
  %arrayidx18.i320 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom17.i319, !dbg !4474
  %925 = load i8, i8* %arrayidx18.i320, align 1, !dbg !4474
  %conv19.i321 = zext i8 %925 to i32, !dbg !4474
  %926 = load i32, i32* %t.i296, align 4, !dbg !4475
  %or20.i322 = or i32 %926, %conv19.i321, !dbg !4475
  store i32 %or20.i322, i32* %t.i296, align 4, !dbg !4475
  %927 = load i32, i32* %t.i296, align 4, !dbg !4476
  %928 = load i32, i32* %t.i296, align 4, !dbg !4477
  store i32 %928, i32* %a.addr.i.i293, align 4
  store i8 2, i8* %n.addr.i.i294, align 1
  %929 = load i32, i32* %a.addr.i.i293, align 4, !dbg !4478
  %930 = load i8, i8* %n.addr.i.i294, align 1, !dbg !4479
  %conv.i.i323 = zext i8 %930 to i32, !dbg !4479
  %shl.i.i324 = shl i32 %929, %conv.i.i323, !dbg !4480
  %931 = load i32, i32* %a.addr.i.i293, align 4, !dbg !4481
  %932 = load i8, i8* %n.addr.i.i294, align 1, !dbg !4482
  %conv1.i.i325 = zext i8 %932 to i32, !dbg !4482
  %sub.i.i326 = sub nsw i32 32, %conv1.i.i325, !dbg !4483
  %shr.i.i327 = lshr i32 %931, %sub.i.i326, !dbg !4484
  %or.i.i328 = or i32 %shl.i.i324, %shr.i.i327, !dbg !4485
  %xor.i329 = xor i32 %927, %or.i.i328, !dbg !4486
  %933 = load i32, i32* %t.i296, align 4, !dbg !4487
  store i32 %933, i32* %a.addr.i43.i287, align 4
  store i8 10, i8* %n.addr.i44.i288, align 1
  %934 = load i32, i32* %a.addr.i43.i287, align 4, !dbg !4488
  %935 = load i8, i8* %n.addr.i44.i288, align 1, !dbg !4489
  %conv.i45.i330 = zext i8 %935 to i32, !dbg !4489
  %shl.i46.i331 = shl i32 %934, %conv.i45.i330, !dbg !4490
  %936 = load i32, i32* %a.addr.i43.i287, align 4, !dbg !4491
  %937 = load i8, i8* %n.addr.i44.i288, align 1, !dbg !4492
  %conv1.i47.i332 = zext i8 %937 to i32, !dbg !4492
  %sub.i48.i333 = sub nsw i32 32, %conv1.i47.i332, !dbg !4493
  %shr.i49.i334 = lshr i32 %936, %sub.i48.i333, !dbg !4494
  %or.i50.i335 = or i32 %shl.i46.i331, %shr.i49.i334, !dbg !4495
  %xor22.i336 = xor i32 %xor.i329, %or.i50.i335, !dbg !4496
  %938 = load i32, i32* %t.i296, align 4, !dbg !4497
  store i32 %938, i32* %a.addr.i35.i289, align 4
  store i8 18, i8* %n.addr.i36.i290, align 1
  %939 = load i32, i32* %a.addr.i35.i289, align 4, !dbg !4498
  %940 = load i8, i8* %n.addr.i36.i290, align 1, !dbg !4499
  %conv.i37.i337 = zext i8 %940 to i32, !dbg !4499
  %shl.i38.i338 = shl i32 %939, %conv.i37.i337, !dbg !4500
  %941 = load i32, i32* %a.addr.i35.i289, align 4, !dbg !4501
  %942 = load i8, i8* %n.addr.i36.i290, align 1, !dbg !4502
  %conv1.i39.i339 = zext i8 %942 to i32, !dbg !4502
  %sub.i40.i340 = sub nsw i32 32, %conv1.i39.i339, !dbg !4503
  %shr.i41.i341 = lshr i32 %941, %sub.i40.i340, !dbg !4504
  %or.i42.i342 = or i32 %shl.i38.i338, %shr.i41.i341, !dbg !4505
  %xor24.i343 = xor i32 %xor22.i336, %or.i42.i342, !dbg !4506
  %943 = load i32, i32* %t.i296, align 4, !dbg !4507
  store i32 %943, i32* %a.addr.i27.i291, align 4
  store i8 24, i8* %n.addr.i28.i292, align 1
  %944 = load i32, i32* %a.addr.i27.i291, align 4, !dbg !4508
  %945 = load i8, i8* %n.addr.i28.i292, align 1, !dbg !4509
  %conv.i29.i344 = zext i8 %945 to i32, !dbg !4509
  %shl.i30.i345 = shl i32 %944, %conv.i29.i344, !dbg !4510
  %946 = load i32, i32* %a.addr.i27.i291, align 4, !dbg !4511
  %947 = load i8, i8* %n.addr.i28.i292, align 1, !dbg !4512
  %conv1.i31.i346 = zext i8 %947 to i32, !dbg !4512
  %sub.i32.i347 = sub nsw i32 32, %conv1.i31.i346, !dbg !4513
  %shr.i33.i348 = lshr i32 %946, %sub.i32.i347, !dbg !4514
  %or.i34.i349 = or i32 %shl.i30.i345, %shr.i33.i348, !dbg !4515
  %xor26.i350 = xor i32 %xor24.i343, %or.i34.i349, !dbg !4516
  %948 = load i32, i32* %B2, align 4, !dbg !4318
  %xor230 = xor i32 %948, %xor26.i350, !dbg !4318
  store i32 %xor230, i32* %B2, align 4, !dbg !4318
  %949 = load i32, i32* %B0, align 4, !dbg !4318
  %950 = load i32, i32* %B1, align 4, !dbg !4318
  %xor231 = xor i32 %949, %950, !dbg !4318
  %951 = load i32, i32* %B2, align 4, !dbg !4318
  %xor232 = xor i32 %xor231, %951, !dbg !4318
  %952 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr, align 8, !dbg !4318
  %rk233 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %952, i32 0, i32 0, !dbg !4318
  %arrayidx234 = getelementptr inbounds [32 x i32], [32 x i32]* %rk233, i64 0, i64 0, !dbg !4318
  %953 = load i32, i32* %arrayidx234, align 4, !dbg !4318
  %xor235 = xor i32 %xor232, %953, !dbg !4318
  store i32 %xor235, i32* %X.addr.i, align 4
  store i32 0, i32* %t.i, align 4, !dbg !2897
  %954 = load i32, i32* %X.addr.i, align 4, !dbg !4517
  %shr.i280 = lshr i32 %954, 24, !dbg !4518
  %conv.i281 = trunc i32 %shr.i280 to i8, !dbg !4519
  %idxprom.i282 = zext i8 %conv.i281 to i64, !dbg !4520
  %arrayidx.i283 = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom.i282, !dbg !4520
  %955 = load i8, i8* %arrayidx.i283, align 1, !dbg !4520
  %conv1.i = zext i8 %955 to i32, !dbg !4521
  %shl.i284 = shl i32 %conv1.i, 24, !dbg !4522
  %956 = load i32, i32* %t.i, align 4, !dbg !4523
  %or.i285 = or i32 %956, %shl.i284, !dbg !4523
  store i32 %or.i285, i32* %t.i, align 4, !dbg !4523
  %957 = load i32, i32* %X.addr.i, align 4, !dbg !4524
  %shr2.i = lshr i32 %957, 16, !dbg !4525
  %conv3.i = trunc i32 %shr2.i to i8, !dbg !4526
  %idxprom4.i = zext i8 %conv3.i to i64, !dbg !4527
  %arrayidx5.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom4.i, !dbg !4527
  %958 = load i8, i8* %arrayidx5.i, align 1, !dbg !4527
  %conv6.i = zext i8 %958 to i32, !dbg !4528
  %shl7.i = shl i32 %conv6.i, 16, !dbg !4529
  %959 = load i32, i32* %t.i, align 4, !dbg !4530
  %or8.i = or i32 %959, %shl7.i, !dbg !4530
  store i32 %or8.i, i32* %t.i, align 4, !dbg !4530
  %960 = load i32, i32* %X.addr.i, align 4, !dbg !4531
  %shr9.i = lshr i32 %960, 8, !dbg !4532
  %conv10.i286 = trunc i32 %shr9.i to i8, !dbg !4533
  %idxprom11.i = zext i8 %conv10.i286 to i64, !dbg !4534
  %arrayidx12.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom11.i, !dbg !4534
  %961 = load i8, i8* %arrayidx12.i, align 1, !dbg !4534
  %conv13.i = zext i8 %961 to i32, !dbg !4535
  %shl14.i = shl i32 %conv13.i, 8, !dbg !4536
  %962 = load i32, i32* %t.i, align 4, !dbg !4537
  %or15.i = or i32 %962, %shl14.i, !dbg !4537
  store i32 %or15.i, i32* %t.i, align 4, !dbg !4537
  %963 = load i32, i32* %X.addr.i, align 4, !dbg !4538
  %conv16.i = trunc i32 %963 to i8, !dbg !4539
  %idxprom17.i = zext i8 %conv16.i to i64, !dbg !4540
  %arrayidx18.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom17.i, !dbg !4540
  %964 = load i8, i8* %arrayidx18.i, align 1, !dbg !4540
  %conv19.i = zext i8 %964 to i32, !dbg !4540
  %965 = load i32, i32* %t.i, align 4, !dbg !4541
  %or20.i = or i32 %965, %conv19.i, !dbg !4541
  store i32 %or20.i, i32* %t.i, align 4, !dbg !4541
  %966 = load i32, i32* %t.i, align 4, !dbg !4542
  %967 = load i32, i32* %t.i, align 4, !dbg !4543
  store i32 %967, i32* %a.addr.i.i, align 4
  store i8 2, i8* %n.addr.i.i, align 1
  %968 = load i32, i32* %a.addr.i.i, align 4, !dbg !4544
  %969 = load i8, i8* %n.addr.i.i, align 1, !dbg !4545
  %conv.i.i = zext i8 %969 to i32, !dbg !4545
  %shl.i.i = shl i32 %968, %conv.i.i, !dbg !4546
  %970 = load i32, i32* %a.addr.i.i, align 4, !dbg !4547
  %971 = load i8, i8* %n.addr.i.i, align 1, !dbg !4548
  %conv1.i.i = zext i8 %971 to i32, !dbg !4548
  %sub.i.i = sub nsw i32 32, %conv1.i.i, !dbg !4549
  %shr.i.i = lshr i32 %970, %sub.i.i, !dbg !4550
  %or.i.i = or i32 %shl.i.i, %shr.i.i, !dbg !4551
  %xor.i = xor i32 %966, %or.i.i, !dbg !4552
  %972 = load i32, i32* %t.i, align 4, !dbg !4553
  store i32 %972, i32* %a.addr.i43.i, align 4
  store i8 10, i8* %n.addr.i44.i, align 1
  %973 = load i32, i32* %a.addr.i43.i, align 4, !dbg !4554
  %974 = load i8, i8* %n.addr.i44.i, align 1, !dbg !4555
  %conv.i45.i = zext i8 %974 to i32, !dbg !4555
  %shl.i46.i = shl i32 %973, %conv.i45.i, !dbg !4556
  %975 = load i32, i32* %a.addr.i43.i, align 4, !dbg !4557
  %976 = load i8, i8* %n.addr.i44.i, align 1, !dbg !4558
  %conv1.i47.i = zext i8 %976 to i32, !dbg !4558
  %sub.i48.i = sub nsw i32 32, %conv1.i47.i, !dbg !4559
  %shr.i49.i = lshr i32 %975, %sub.i48.i, !dbg !4560
  %or.i50.i = or i32 %shl.i46.i, %shr.i49.i, !dbg !4561
  %xor22.i = xor i32 %xor.i, %or.i50.i, !dbg !4562
  %977 = load i32, i32* %t.i, align 4, !dbg !4563
  store i32 %977, i32* %a.addr.i35.i, align 4
  store i8 18, i8* %n.addr.i36.i, align 1
  %978 = load i32, i32* %a.addr.i35.i, align 4, !dbg !4564
  %979 = load i8, i8* %n.addr.i36.i, align 1, !dbg !4565
  %conv.i37.i = zext i8 %979 to i32, !dbg !4565
  %shl.i38.i = shl i32 %978, %conv.i37.i, !dbg !4566
  %980 = load i32, i32* %a.addr.i35.i, align 4, !dbg !4567
  %981 = load i8, i8* %n.addr.i36.i, align 1, !dbg !4568
  %conv1.i39.i = zext i8 %981 to i32, !dbg !4568
  %sub.i40.i = sub nsw i32 32, %conv1.i39.i, !dbg !4569
  %shr.i41.i = lshr i32 %980, %sub.i40.i, !dbg !4570
  %or.i42.i = or i32 %shl.i38.i, %shr.i41.i, !dbg !4571
  %xor24.i = xor i32 %xor22.i, %or.i42.i, !dbg !4572
  %982 = load i32, i32* %t.i, align 4, !dbg !4573
  store i32 %982, i32* %a.addr.i27.i, align 4
  store i8 24, i8* %n.addr.i28.i, align 1
  %983 = load i32, i32* %a.addr.i27.i, align 4, !dbg !4574
  %984 = load i8, i8* %n.addr.i28.i, align 1, !dbg !4575
  %conv.i29.i = zext i8 %984 to i32, !dbg !4575
  %shl.i30.i = shl i32 %983, %conv.i29.i, !dbg !4576
  %985 = load i32, i32* %a.addr.i27.i, align 4, !dbg !4577
  %986 = load i8, i8* %n.addr.i28.i, align 1, !dbg !4578
  %conv1.i31.i = zext i8 %986 to i32, !dbg !4578
  %sub.i32.i = sub nsw i32 32, %conv1.i31.i, !dbg !4579
  %shr.i33.i = lshr i32 %985, %sub.i32.i, !dbg !4580
  %or.i34.i = or i32 %shl.i30.i, %shr.i33.i, !dbg !4581
  %xor26.i = xor i32 %xor24.i, %or.i34.i, !dbg !4582
  %987 = load i32, i32* %B3, align 4, !dbg !4318
  %xor237 = xor i32 %987, %xor26.i, !dbg !4318
  store i32 %xor237, i32* %B3, align 4, !dbg !4318
  br label %do.end238, !dbg !4318

do.end238:                                        ; preds = %do.body209
  %988 = load i32, i32* %B3, align 4, !dbg !4583
  %989 = load i8*, i8** %out.addr, align 8, !dbg !4584
  store i32 %988, i32* %v.addr.i268, align 4
  store i8* %989, i8** %b.addr.i269, align 8
  %990 = load i32, i32* %v.addr.i268, align 4, !dbg !4585
  %shr.i270 = lshr i32 %990, 24, !dbg !4586
  %conv.i271 = trunc i32 %shr.i270 to i8, !dbg !4587
  %991 = load i8*, i8** %b.addr.i269, align 8, !dbg !4588
  store i8 %conv.i271, i8* %991, align 1, !dbg !4589
  %992 = load i32, i32* %v.addr.i268, align 4, !dbg !4590
  %shr1.i272 = lshr i32 %992, 16, !dbg !4591
  %conv2.i273 = trunc i32 %shr1.i272 to i8, !dbg !4592
  %993 = load i8*, i8** %b.addr.i269, align 8, !dbg !4593
  %arrayidx3.i274 = getelementptr inbounds i8, i8* %993, i64 1, !dbg !4593
  store i8 %conv2.i273, i8* %arrayidx3.i274, align 1, !dbg !4594
  %994 = load i32, i32* %v.addr.i268, align 4, !dbg !4595
  %shr4.i275 = lshr i32 %994, 8, !dbg !4596
  %conv5.i276 = trunc i32 %shr4.i275 to i8, !dbg !4597
  %995 = load i8*, i8** %b.addr.i269, align 8, !dbg !4598
  %arrayidx6.i277 = getelementptr inbounds i8, i8* %995, i64 2, !dbg !4598
  store i8 %conv5.i276, i8* %arrayidx6.i277, align 1, !dbg !4599
  %996 = load i32, i32* %v.addr.i268, align 4, !dbg !4600
  %conv7.i278 = trunc i32 %996 to i8, !dbg !4601
  %997 = load i8*, i8** %b.addr.i269, align 8, !dbg !4602
  %arrayidx8.i279 = getelementptr inbounds i8, i8* %997, i64 3, !dbg !4602
  store i8 %conv7.i278, i8* %arrayidx8.i279, align 1, !dbg !4603
  %998 = load i32, i32* %B2, align 4, !dbg !4604
  %999 = load i8*, i8** %out.addr, align 8, !dbg !4605
  %add.ptr = getelementptr inbounds i8, i8* %999, i64 4, !dbg !4606
  store i32 %998, i32* %v.addr.i256, align 4
  store i8* %add.ptr, i8** %b.addr.i257, align 8
  %1000 = load i32, i32* %v.addr.i256, align 4, !dbg !4607
  %shr.i258 = lshr i32 %1000, 24, !dbg !4608
  %conv.i259 = trunc i32 %shr.i258 to i8, !dbg !4609
  %1001 = load i8*, i8** %b.addr.i257, align 8, !dbg !4610
  store i8 %conv.i259, i8* %1001, align 1, !dbg !4611
  %1002 = load i32, i32* %v.addr.i256, align 4, !dbg !4612
  %shr1.i260 = lshr i32 %1002, 16, !dbg !4613
  %conv2.i261 = trunc i32 %shr1.i260 to i8, !dbg !4614
  %1003 = load i8*, i8** %b.addr.i257, align 8, !dbg !4615
  %arrayidx3.i262 = getelementptr inbounds i8, i8* %1003, i64 1, !dbg !4615
  store i8 %conv2.i261, i8* %arrayidx3.i262, align 1, !dbg !4616
  %1004 = load i32, i32* %v.addr.i256, align 4, !dbg !4617
  %shr4.i263 = lshr i32 %1004, 8, !dbg !4618
  %conv5.i264 = trunc i32 %shr4.i263 to i8, !dbg !4619
  %1005 = load i8*, i8** %b.addr.i257, align 8, !dbg !4620
  %arrayidx6.i265 = getelementptr inbounds i8, i8* %1005, i64 2, !dbg !4620
  store i8 %conv5.i264, i8* %arrayidx6.i265, align 1, !dbg !4621
  %1006 = load i32, i32* %v.addr.i256, align 4, !dbg !4622
  %conv7.i266 = trunc i32 %1006 to i8, !dbg !4623
  %1007 = load i8*, i8** %b.addr.i257, align 8, !dbg !4624
  %arrayidx8.i267 = getelementptr inbounds i8, i8* %1007, i64 3, !dbg !4624
  store i8 %conv7.i266, i8* %arrayidx8.i267, align 1, !dbg !4625
  %1008 = load i32, i32* %B1, align 4, !dbg !4626
  %1009 = load i8*, i8** %out.addr, align 8, !dbg !4627
  %add.ptr239 = getelementptr inbounds i8, i8* %1009, i64 8, !dbg !4628
  store i32 %1008, i32* %v.addr.i244, align 4
  store i8* %add.ptr239, i8** %b.addr.i245, align 8
  %1010 = load i32, i32* %v.addr.i244, align 4, !dbg !4629
  %shr.i246 = lshr i32 %1010, 24, !dbg !4630
  %conv.i247 = trunc i32 %shr.i246 to i8, !dbg !4631
  %1011 = load i8*, i8** %b.addr.i245, align 8, !dbg !4632
  store i8 %conv.i247, i8* %1011, align 1, !dbg !4633
  %1012 = load i32, i32* %v.addr.i244, align 4, !dbg !4634
  %shr1.i248 = lshr i32 %1012, 16, !dbg !4635
  %conv2.i249 = trunc i32 %shr1.i248 to i8, !dbg !4636
  %1013 = load i8*, i8** %b.addr.i245, align 8, !dbg !4637
  %arrayidx3.i250 = getelementptr inbounds i8, i8* %1013, i64 1, !dbg !4637
  store i8 %conv2.i249, i8* %arrayidx3.i250, align 1, !dbg !4638
  %1014 = load i32, i32* %v.addr.i244, align 4, !dbg !4639
  %shr4.i251 = lshr i32 %1014, 8, !dbg !4640
  %conv5.i252 = trunc i32 %shr4.i251 to i8, !dbg !4641
  %1015 = load i8*, i8** %b.addr.i245, align 8, !dbg !4642
  %arrayidx6.i253 = getelementptr inbounds i8, i8* %1015, i64 2, !dbg !4642
  store i8 %conv5.i252, i8* %arrayidx6.i253, align 1, !dbg !4643
  %1016 = load i32, i32* %v.addr.i244, align 4, !dbg !4644
  %conv7.i254 = trunc i32 %1016 to i8, !dbg !4645
  %1017 = load i8*, i8** %b.addr.i245, align 8, !dbg !4646
  %arrayidx8.i255 = getelementptr inbounds i8, i8* %1017, i64 3, !dbg !4646
  store i8 %conv7.i254, i8* %arrayidx8.i255, align 1, !dbg !4647
  %1018 = load i32, i32* %B0, align 4, !dbg !4648
  %1019 = load i8*, i8** %out.addr, align 8, !dbg !4649
  %add.ptr240 = getelementptr inbounds i8, i8* %1019, i64 12, !dbg !4650
  store i32 %1018, i32* %v.addr.i, align 4
  store i8* %add.ptr240, i8** %b.addr.i241, align 8
  %1020 = load i32, i32* %v.addr.i, align 4, !dbg !4651
  %shr.i = lshr i32 %1020, 24, !dbg !4652
  %conv.i242 = trunc i32 %shr.i to i8, !dbg !4653
  %1021 = load i8*, i8** %b.addr.i241, align 8, !dbg !4654
  store i8 %conv.i242, i8* %1021, align 1, !dbg !4655
  %1022 = load i32, i32* %v.addr.i, align 4, !dbg !4656
  %shr1.i = lshr i32 %1022, 16, !dbg !4657
  %conv2.i = trunc i32 %shr1.i to i8, !dbg !4658
  %1023 = load i8*, i8** %b.addr.i241, align 8, !dbg !4659
  %arrayidx3.i243 = getelementptr inbounds i8, i8* %1023, i64 1, !dbg !4659
  store i8 %conv2.i, i8* %arrayidx3.i243, align 1, !dbg !4660
  %1024 = load i32, i32* %v.addr.i, align 4, !dbg !4661
  %shr4.i = lshr i32 %1024, 8, !dbg !4662
  %conv5.i = trunc i32 %shr4.i to i8, !dbg !4663
  %1025 = load i8*, i8** %b.addr.i241, align 8, !dbg !4664
  %arrayidx6.i = getelementptr inbounds i8, i8* %1025, i64 2, !dbg !4664
  store i8 %conv5.i, i8* %arrayidx6.i, align 1, !dbg !4665
  %1026 = load i32, i32* %v.addr.i, align 4, !dbg !4666
  %conv7.i = trunc i32 %1026 to i8, !dbg !4667
  %1027 = load i8*, i8** %b.addr.i241, align 8, !dbg !4668
  %arrayidx8.i = getelementptr inbounds i8, i8* %1027, i64 3, !dbg !4668
  store i8 %conv7.i, i8* %arrayidx8.i, align 1, !dbg !4669
  ret void, !dbg !4670
}

; Function Attrs: noinline nounwind optnone uwtable
define dso_local i32 @main() #3 !dbg !4671 {
entry:
  %b.addr.i1797.i = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i1797.i, metadata !53, metadata !DIExpression()), !dbg !4674
  %n.addr.i1798.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %n.addr.i1798.i, metadata !59, metadata !DIExpression()), !dbg !4678
  %b.addr.i1770.i = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i1770.i, metadata !53, metadata !DIExpression()), !dbg !4679
  %n.addr.i1771.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %n.addr.i1771.i, metadata !59, metadata !DIExpression()), !dbg !4681
  %b.addr.i1743.i = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i1743.i, metadata !53, metadata !DIExpression()), !dbg !4682
  %n.addr.i1744.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %n.addr.i1744.i, metadata !59, metadata !DIExpression()), !dbg !4684
  %a.addr.i43.i1679.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i1679.i, metadata !67, metadata !DIExpression()), !dbg !4685
  %n.addr.i44.i1680.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i1680.i, metadata !76, metadata !DIExpression()), !dbg !4688
  %a.addr.i35.i1681.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i1681.i, metadata !67, metadata !DIExpression()), !dbg !4689
  %n.addr.i36.i1682.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i1682.i, metadata !76, metadata !DIExpression()), !dbg !4691
  %a.addr.i27.i1683.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i1683.i, metadata !67, metadata !DIExpression()), !dbg !4692
  %n.addr.i28.i1684.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i1684.i, metadata !76, metadata !DIExpression()), !dbg !4694
  %a.addr.i.i1685.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1685.i, metadata !67, metadata !DIExpression()), !dbg !4695
  %n.addr.i.i1686.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1686.i, metadata !76, metadata !DIExpression()), !dbg !4697
  %X.addr.i1687.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1687.i, metadata !336, metadata !DIExpression()), !dbg !4698
  %t.i1688.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i1688.i, metadata !338, metadata !DIExpression()), !dbg !4699
  %a.addr.i43.i1615.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i1615.i, metadata !67, metadata !DIExpression()), !dbg !4700
  %n.addr.i44.i1616.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i1616.i, metadata !76, metadata !DIExpression()), !dbg !4703
  %a.addr.i35.i1617.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i1617.i, metadata !67, metadata !DIExpression()), !dbg !4704
  %n.addr.i36.i1618.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i1618.i, metadata !76, metadata !DIExpression()), !dbg !4706
  %a.addr.i27.i1619.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i1619.i, metadata !67, metadata !DIExpression()), !dbg !4707
  %n.addr.i28.i1620.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i1620.i, metadata !76, metadata !DIExpression()), !dbg !4709
  %a.addr.i.i1621.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1621.i, metadata !67, metadata !DIExpression()), !dbg !4710
  %n.addr.i.i1622.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1622.i, metadata !76, metadata !DIExpression()), !dbg !4712
  %X.addr.i1623.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1623.i, metadata !336, metadata !DIExpression()), !dbg !4713
  %t.i1624.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i1624.i, metadata !338, metadata !DIExpression()), !dbg !4714
  %a.addr.i43.i1551.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i1551.i, metadata !67, metadata !DIExpression()), !dbg !4715
  %n.addr.i44.i1552.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i1552.i, metadata !76, metadata !DIExpression()), !dbg !4718
  %a.addr.i35.i1553.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i1553.i, metadata !67, metadata !DIExpression()), !dbg !4719
  %n.addr.i36.i1554.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i1554.i, metadata !76, metadata !DIExpression()), !dbg !4721
  %a.addr.i27.i1555.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i1555.i, metadata !67, metadata !DIExpression()), !dbg !4722
  %n.addr.i28.i1556.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i1556.i, metadata !76, metadata !DIExpression()), !dbg !4724
  %a.addr.i.i1557.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1557.i, metadata !67, metadata !DIExpression()), !dbg !4725
  %n.addr.i.i1558.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1558.i, metadata !76, metadata !DIExpression()), !dbg !4727
  %X.addr.i1559.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1559.i, metadata !336, metadata !DIExpression()), !dbg !4728
  %t.i1560.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i1560.i, metadata !338, metadata !DIExpression()), !dbg !4729
  %a.addr.i43.i1487.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i1487.i, metadata !67, metadata !DIExpression()), !dbg !4730
  %n.addr.i44.i1488.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i1488.i, metadata !76, metadata !DIExpression()), !dbg !4733
  %a.addr.i35.i1489.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i1489.i, metadata !67, metadata !DIExpression()), !dbg !4734
  %n.addr.i36.i1490.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i1490.i, metadata !76, metadata !DIExpression()), !dbg !4736
  %a.addr.i27.i1491.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i1491.i, metadata !67, metadata !DIExpression()), !dbg !4737
  %n.addr.i28.i1492.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i1492.i, metadata !76, metadata !DIExpression()), !dbg !4739
  %a.addr.i.i1493.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1493.i, metadata !67, metadata !DIExpression()), !dbg !4740
  %n.addr.i.i1494.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1494.i, metadata !76, metadata !DIExpression()), !dbg !4742
  %X.addr.i1495.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1495.i, metadata !336, metadata !DIExpression()), !dbg !4743
  %t.i1496.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i1496.i, metadata !338, metadata !DIExpression()), !dbg !4744
  %a.addr.i24.i1444.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1444.i, metadata !67, metadata !DIExpression()), !dbg !4745
  %n.addr.i25.i1445.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1445.i, metadata !76, metadata !DIExpression()), !dbg !4748
  %a.addr.i16.i1446.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1446.i, metadata !67, metadata !DIExpression()), !dbg !4749
  %n.addr.i17.i1447.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1447.i, metadata !76, metadata !DIExpression()), !dbg !4751
  %a.addr.i.i1448.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1448.i, metadata !67, metadata !DIExpression()), !dbg !4752
  %n.addr.i.i1449.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1449.i, metadata !76, metadata !DIExpression()), !dbg !4754
  %X.addr.i1450.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1450.i, metadata !397, metadata !DIExpression()), !dbg !4755
  %a.addr.i24.i1401.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1401.i, metadata !67, metadata !DIExpression()), !dbg !4756
  %n.addr.i25.i1402.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1402.i, metadata !76, metadata !DIExpression()), !dbg !4759
  %a.addr.i16.i1403.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1403.i, metadata !67, metadata !DIExpression()), !dbg !4760
  %n.addr.i17.i1404.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1404.i, metadata !76, metadata !DIExpression()), !dbg !4762
  %a.addr.i.i1405.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1405.i, metadata !67, metadata !DIExpression()), !dbg !4763
  %n.addr.i.i1406.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1406.i, metadata !76, metadata !DIExpression()), !dbg !4765
  %X.addr.i1407.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1407.i, metadata !397, metadata !DIExpression()), !dbg !4766
  %a.addr.i24.i1358.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1358.i, metadata !67, metadata !DIExpression()), !dbg !4767
  %n.addr.i25.i1359.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1359.i, metadata !76, metadata !DIExpression()), !dbg !4770
  %a.addr.i16.i1360.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1360.i, metadata !67, metadata !DIExpression()), !dbg !4771
  %n.addr.i17.i1361.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1361.i, metadata !76, metadata !DIExpression()), !dbg !4773
  %a.addr.i.i1362.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1362.i, metadata !67, metadata !DIExpression()), !dbg !4774
  %n.addr.i.i1363.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1363.i, metadata !76, metadata !DIExpression()), !dbg !4776
  %X.addr.i1364.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1364.i, metadata !397, metadata !DIExpression()), !dbg !4777
  %a.addr.i24.i1315.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1315.i, metadata !67, metadata !DIExpression()), !dbg !4778
  %n.addr.i25.i1316.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1316.i, metadata !76, metadata !DIExpression()), !dbg !4781
  %a.addr.i16.i1317.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1317.i, metadata !67, metadata !DIExpression()), !dbg !4782
  %n.addr.i17.i1318.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1318.i, metadata !76, metadata !DIExpression()), !dbg !4784
  %a.addr.i.i1319.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1319.i, metadata !67, metadata !DIExpression()), !dbg !4785
  %n.addr.i.i1320.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1320.i, metadata !76, metadata !DIExpression()), !dbg !4787
  %X.addr.i1321.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1321.i, metadata !397, metadata !DIExpression()), !dbg !4788
  %a.addr.i24.i1272.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1272.i, metadata !67, metadata !DIExpression()), !dbg !4789
  %n.addr.i25.i1273.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1273.i, metadata !76, metadata !DIExpression()), !dbg !4792
  %a.addr.i16.i1274.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1274.i, metadata !67, metadata !DIExpression()), !dbg !4793
  %n.addr.i17.i1275.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1275.i, metadata !76, metadata !DIExpression()), !dbg !4795
  %a.addr.i.i1276.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1276.i, metadata !67, metadata !DIExpression()), !dbg !4796
  %n.addr.i.i1277.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1277.i, metadata !76, metadata !DIExpression()), !dbg !4798
  %X.addr.i1278.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1278.i, metadata !397, metadata !DIExpression()), !dbg !4799
  %a.addr.i24.i1229.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1229.i, metadata !67, metadata !DIExpression()), !dbg !4800
  %n.addr.i25.i1230.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1230.i, metadata !76, metadata !DIExpression()), !dbg !4803
  %a.addr.i16.i1231.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1231.i, metadata !67, metadata !DIExpression()), !dbg !4804
  %n.addr.i17.i1232.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1232.i, metadata !76, metadata !DIExpression()), !dbg !4806
  %a.addr.i.i1233.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1233.i, metadata !67, metadata !DIExpression()), !dbg !4807
  %n.addr.i.i1234.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1234.i, metadata !76, metadata !DIExpression()), !dbg !4809
  %X.addr.i1235.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1235.i, metadata !397, metadata !DIExpression()), !dbg !4810
  %a.addr.i24.i1186.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1186.i, metadata !67, metadata !DIExpression()), !dbg !4811
  %n.addr.i25.i1187.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1187.i, metadata !76, metadata !DIExpression()), !dbg !4814
  %a.addr.i16.i1188.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1188.i, metadata !67, metadata !DIExpression()), !dbg !4815
  %n.addr.i17.i1189.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1189.i, metadata !76, metadata !DIExpression()), !dbg !4817
  %a.addr.i.i1190.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1190.i, metadata !67, metadata !DIExpression()), !dbg !4818
  %n.addr.i.i1191.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1191.i, metadata !76, metadata !DIExpression()), !dbg !4820
  %X.addr.i1192.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1192.i, metadata !397, metadata !DIExpression()), !dbg !4821
  %a.addr.i24.i1143.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1143.i, metadata !67, metadata !DIExpression()), !dbg !4822
  %n.addr.i25.i1144.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1144.i, metadata !76, metadata !DIExpression()), !dbg !4825
  %a.addr.i16.i1145.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1145.i, metadata !67, metadata !DIExpression()), !dbg !4826
  %n.addr.i17.i1146.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1146.i, metadata !76, metadata !DIExpression()), !dbg !4828
  %a.addr.i.i1147.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1147.i, metadata !67, metadata !DIExpression()), !dbg !4829
  %n.addr.i.i1148.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1148.i, metadata !76, metadata !DIExpression()), !dbg !4831
  %X.addr.i1149.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1149.i, metadata !397, metadata !DIExpression()), !dbg !4832
  %a.addr.i24.i1100.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1100.i, metadata !67, metadata !DIExpression()), !dbg !4833
  %n.addr.i25.i1101.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1101.i, metadata !76, metadata !DIExpression()), !dbg !4836
  %a.addr.i16.i1102.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1102.i, metadata !67, metadata !DIExpression()), !dbg !4837
  %n.addr.i17.i1103.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1103.i, metadata !76, metadata !DIExpression()), !dbg !4839
  %a.addr.i.i1104.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1104.i, metadata !67, metadata !DIExpression()), !dbg !4840
  %n.addr.i.i1105.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1105.i, metadata !76, metadata !DIExpression()), !dbg !4842
  %X.addr.i1106.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1106.i, metadata !397, metadata !DIExpression()), !dbg !4843
  %a.addr.i24.i1057.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1057.i, metadata !67, metadata !DIExpression()), !dbg !4844
  %n.addr.i25.i1058.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1058.i, metadata !76, metadata !DIExpression()), !dbg !4847
  %a.addr.i16.i1059.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1059.i, metadata !67, metadata !DIExpression()), !dbg !4848
  %n.addr.i17.i1060.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1060.i, metadata !76, metadata !DIExpression()), !dbg !4850
  %a.addr.i.i1061.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1061.i, metadata !67, metadata !DIExpression()), !dbg !4851
  %n.addr.i.i1062.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1062.i, metadata !76, metadata !DIExpression()), !dbg !4853
  %X.addr.i1063.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1063.i, metadata !397, metadata !DIExpression()), !dbg !4854
  %a.addr.i24.i1014.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i1014.i, metadata !67, metadata !DIExpression()), !dbg !4855
  %n.addr.i25.i1015.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i1015.i, metadata !76, metadata !DIExpression()), !dbg !4858
  %a.addr.i16.i1016.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i1016.i, metadata !67, metadata !DIExpression()), !dbg !4859
  %n.addr.i17.i1017.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i1017.i, metadata !76, metadata !DIExpression()), !dbg !4861
  %a.addr.i.i1018.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i1018.i, metadata !67, metadata !DIExpression()), !dbg !4862
  %n.addr.i.i1019.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i1019.i, metadata !76, metadata !DIExpression()), !dbg !4864
  %X.addr.i1020.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i1020.i, metadata !397, metadata !DIExpression()), !dbg !4865
  %a.addr.i24.i971.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i971.i, metadata !67, metadata !DIExpression()), !dbg !4866
  %n.addr.i25.i972.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i972.i, metadata !76, metadata !DIExpression()), !dbg !4869
  %a.addr.i16.i973.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i973.i, metadata !67, metadata !DIExpression()), !dbg !4870
  %n.addr.i17.i974.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i974.i, metadata !76, metadata !DIExpression()), !dbg !4872
  %a.addr.i.i975.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i975.i, metadata !67, metadata !DIExpression()), !dbg !4873
  %n.addr.i.i976.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i976.i, metadata !76, metadata !DIExpression()), !dbg !4875
  %X.addr.i977.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i977.i, metadata !397, metadata !DIExpression()), !dbg !4876
  %a.addr.i24.i928.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i928.i, metadata !67, metadata !DIExpression()), !dbg !4877
  %n.addr.i25.i929.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i929.i, metadata !76, metadata !DIExpression()), !dbg !4880
  %a.addr.i16.i930.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i930.i, metadata !67, metadata !DIExpression()), !dbg !4881
  %n.addr.i17.i931.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i931.i, metadata !76, metadata !DIExpression()), !dbg !4883
  %a.addr.i.i932.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i932.i, metadata !67, metadata !DIExpression()), !dbg !4884
  %n.addr.i.i933.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i933.i, metadata !76, metadata !DIExpression()), !dbg !4886
  %X.addr.i934.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i934.i, metadata !397, metadata !DIExpression()), !dbg !4887
  %a.addr.i24.i885.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i885.i, metadata !67, metadata !DIExpression()), !dbg !4888
  %n.addr.i25.i886.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i886.i, metadata !76, metadata !DIExpression()), !dbg !4891
  %a.addr.i16.i887.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i887.i, metadata !67, metadata !DIExpression()), !dbg !4892
  %n.addr.i17.i888.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i888.i, metadata !76, metadata !DIExpression()), !dbg !4894
  %a.addr.i.i889.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i889.i, metadata !67, metadata !DIExpression()), !dbg !4895
  %n.addr.i.i890.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i890.i, metadata !76, metadata !DIExpression()), !dbg !4897
  %X.addr.i891.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i891.i, metadata !397, metadata !DIExpression()), !dbg !4898
  %a.addr.i24.i842.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i842.i, metadata !67, metadata !DIExpression()), !dbg !4899
  %n.addr.i25.i843.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i843.i, metadata !76, metadata !DIExpression()), !dbg !4902
  %a.addr.i16.i844.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i844.i, metadata !67, metadata !DIExpression()), !dbg !4903
  %n.addr.i17.i845.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i845.i, metadata !76, metadata !DIExpression()), !dbg !4905
  %a.addr.i.i846.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i846.i, metadata !67, metadata !DIExpression()), !dbg !4906
  %n.addr.i.i847.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i847.i, metadata !76, metadata !DIExpression()), !dbg !4908
  %X.addr.i848.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i848.i, metadata !397, metadata !DIExpression()), !dbg !4909
  %a.addr.i24.i799.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i799.i, metadata !67, metadata !DIExpression()), !dbg !4910
  %n.addr.i25.i800.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i800.i, metadata !76, metadata !DIExpression()), !dbg !4913
  %a.addr.i16.i801.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i801.i, metadata !67, metadata !DIExpression()), !dbg !4914
  %n.addr.i17.i802.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i802.i, metadata !76, metadata !DIExpression()), !dbg !4916
  %a.addr.i.i803.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i803.i, metadata !67, metadata !DIExpression()), !dbg !4917
  %n.addr.i.i804.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i804.i, metadata !76, metadata !DIExpression()), !dbg !4919
  %X.addr.i805.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i805.i, metadata !397, metadata !DIExpression()), !dbg !4920
  %a.addr.i24.i756.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i756.i, metadata !67, metadata !DIExpression()), !dbg !4921
  %n.addr.i25.i757.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i757.i, metadata !76, metadata !DIExpression()), !dbg !4924
  %a.addr.i16.i758.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i758.i, metadata !67, metadata !DIExpression()), !dbg !4925
  %n.addr.i17.i759.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i759.i, metadata !76, metadata !DIExpression()), !dbg !4927
  %a.addr.i.i760.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i760.i, metadata !67, metadata !DIExpression()), !dbg !4928
  %n.addr.i.i761.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i761.i, metadata !76, metadata !DIExpression()), !dbg !4930
  %X.addr.i762.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i762.i, metadata !397, metadata !DIExpression()), !dbg !4931
  %a.addr.i24.i713.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i713.i, metadata !67, metadata !DIExpression()), !dbg !4932
  %n.addr.i25.i714.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i714.i, metadata !76, metadata !DIExpression()), !dbg !4935
  %a.addr.i16.i715.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i715.i, metadata !67, metadata !DIExpression()), !dbg !4936
  %n.addr.i17.i716.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i716.i, metadata !76, metadata !DIExpression()), !dbg !4938
  %a.addr.i.i717.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i717.i, metadata !67, metadata !DIExpression()), !dbg !4939
  %n.addr.i.i718.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i718.i, metadata !76, metadata !DIExpression()), !dbg !4941
  %X.addr.i719.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i719.i, metadata !397, metadata !DIExpression()), !dbg !4942
  %a.addr.i24.i670.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i670.i, metadata !67, metadata !DIExpression()), !dbg !4943
  %n.addr.i25.i671.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i671.i, metadata !76, metadata !DIExpression()), !dbg !4946
  %a.addr.i16.i672.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i672.i, metadata !67, metadata !DIExpression()), !dbg !4947
  %n.addr.i17.i673.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i673.i, metadata !76, metadata !DIExpression()), !dbg !4949
  %a.addr.i.i674.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i674.i, metadata !67, metadata !DIExpression()), !dbg !4950
  %n.addr.i.i675.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i675.i, metadata !76, metadata !DIExpression()), !dbg !4952
  %X.addr.i676.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i676.i, metadata !397, metadata !DIExpression()), !dbg !4953
  %a.addr.i24.i627.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i627.i, metadata !67, metadata !DIExpression()), !dbg !4954
  %n.addr.i25.i628.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i628.i, metadata !76, metadata !DIExpression()), !dbg !4957
  %a.addr.i16.i629.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i629.i, metadata !67, metadata !DIExpression()), !dbg !4958
  %n.addr.i17.i630.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i630.i, metadata !76, metadata !DIExpression()), !dbg !4960
  %a.addr.i.i631.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i631.i, metadata !67, metadata !DIExpression()), !dbg !4961
  %n.addr.i.i632.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i632.i, metadata !76, metadata !DIExpression()), !dbg !4963
  %X.addr.i633.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i633.i, metadata !397, metadata !DIExpression()), !dbg !4964
  %a.addr.i24.i584.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i584.i, metadata !67, metadata !DIExpression()), !dbg !4965
  %n.addr.i25.i585.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i585.i, metadata !76, metadata !DIExpression()), !dbg !4968
  %a.addr.i16.i586.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i586.i, metadata !67, metadata !DIExpression()), !dbg !4969
  %n.addr.i17.i587.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i587.i, metadata !76, metadata !DIExpression()), !dbg !4971
  %a.addr.i.i588.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i588.i, metadata !67, metadata !DIExpression()), !dbg !4972
  %n.addr.i.i589.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i589.i, metadata !76, metadata !DIExpression()), !dbg !4974
  %X.addr.i590.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i590.i, metadata !397, metadata !DIExpression()), !dbg !4975
  %a.addr.i24.i541.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i541.i, metadata !67, metadata !DIExpression()), !dbg !4976
  %n.addr.i25.i542.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i542.i, metadata !76, metadata !DIExpression()), !dbg !4979
  %a.addr.i16.i543.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i543.i, metadata !67, metadata !DIExpression()), !dbg !4980
  %n.addr.i17.i544.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i544.i, metadata !76, metadata !DIExpression()), !dbg !4982
  %a.addr.i.i545.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i545.i, metadata !67, metadata !DIExpression()), !dbg !4983
  %n.addr.i.i546.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i546.i, metadata !76, metadata !DIExpression()), !dbg !4985
  %X.addr.i547.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i547.i, metadata !397, metadata !DIExpression()), !dbg !4986
  %a.addr.i24.i498.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i498.i, metadata !67, metadata !DIExpression()), !dbg !4987
  %n.addr.i25.i499.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i499.i, metadata !76, metadata !DIExpression()), !dbg !4990
  %a.addr.i16.i500.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i500.i, metadata !67, metadata !DIExpression()), !dbg !4991
  %n.addr.i17.i501.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i501.i, metadata !76, metadata !DIExpression()), !dbg !4993
  %a.addr.i.i502.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i502.i, metadata !67, metadata !DIExpression()), !dbg !4994
  %n.addr.i.i503.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i503.i, metadata !76, metadata !DIExpression()), !dbg !4996
  %X.addr.i504.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i504.i, metadata !397, metadata !DIExpression()), !dbg !4997
  %a.addr.i24.i.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i24.i.i, metadata !67, metadata !DIExpression()), !dbg !4998
  %n.addr.i25.i.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i25.i.i, metadata !76, metadata !DIExpression()), !dbg !5001
  %a.addr.i16.i.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i16.i.i, metadata !67, metadata !DIExpression()), !dbg !5002
  %n.addr.i17.i.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i17.i.i, metadata !76, metadata !DIExpression()), !dbg !5004
  %a.addr.i.i480.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i480.i, metadata !67, metadata !DIExpression()), !dbg !5005
  %n.addr.i.i481.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i481.i, metadata !76, metadata !DIExpression()), !dbg !5007
  %X.addr.i482.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i482.i, metadata !397, metadata !DIExpression()), !dbg !5008
  %a.addr.i43.i416.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i416.i, metadata !67, metadata !DIExpression()), !dbg !5009
  %n.addr.i44.i417.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i417.i, metadata !76, metadata !DIExpression()), !dbg !5012
  %a.addr.i35.i418.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i418.i, metadata !67, metadata !DIExpression()), !dbg !5013
  %n.addr.i36.i419.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i419.i, metadata !76, metadata !DIExpression()), !dbg !5015
  %a.addr.i27.i420.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i420.i, metadata !67, metadata !DIExpression()), !dbg !5016
  %n.addr.i28.i421.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i421.i, metadata !76, metadata !DIExpression()), !dbg !5018
  %a.addr.i.i422.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i422.i, metadata !67, metadata !DIExpression()), !dbg !5019
  %n.addr.i.i423.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i423.i, metadata !76, metadata !DIExpression()), !dbg !5021
  %X.addr.i424.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i424.i, metadata !336, metadata !DIExpression()), !dbg !5022
  %t.i425.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i425.i, metadata !338, metadata !DIExpression()), !dbg !5023
  %a.addr.i43.i352.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i352.i, metadata !67, metadata !DIExpression()), !dbg !5024
  %n.addr.i44.i353.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i353.i, metadata !76, metadata !DIExpression()), !dbg !5027
  %a.addr.i35.i354.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i354.i, metadata !67, metadata !DIExpression()), !dbg !5028
  %n.addr.i36.i355.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i355.i, metadata !76, metadata !DIExpression()), !dbg !5030
  %a.addr.i27.i356.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i356.i, metadata !67, metadata !DIExpression()), !dbg !5031
  %n.addr.i28.i357.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i357.i, metadata !76, metadata !DIExpression()), !dbg !5033
  %a.addr.i.i358.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i358.i, metadata !67, metadata !DIExpression()), !dbg !5034
  %n.addr.i.i359.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i359.i, metadata !76, metadata !DIExpression()), !dbg !5036
  %X.addr.i360.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i360.i, metadata !336, metadata !DIExpression()), !dbg !5037
  %t.i361.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i361.i, metadata !338, metadata !DIExpression()), !dbg !5038
  %a.addr.i43.i288.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i288.i, metadata !67, metadata !DIExpression()), !dbg !5039
  %n.addr.i44.i289.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i289.i, metadata !76, metadata !DIExpression()), !dbg !5042
  %a.addr.i35.i290.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i290.i, metadata !67, metadata !DIExpression()), !dbg !5043
  %n.addr.i36.i291.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i291.i, metadata !76, metadata !DIExpression()), !dbg !5045
  %a.addr.i27.i292.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i292.i, metadata !67, metadata !DIExpression()), !dbg !5046
  %n.addr.i28.i293.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i293.i, metadata !76, metadata !DIExpression()), !dbg !5048
  %a.addr.i.i294.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i294.i, metadata !67, metadata !DIExpression()), !dbg !5049
  %n.addr.i.i295.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i295.i, metadata !76, metadata !DIExpression()), !dbg !5051
  %X.addr.i296.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i296.i, metadata !336, metadata !DIExpression()), !dbg !5052
  %t.i297.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i297.i, metadata !338, metadata !DIExpression()), !dbg !5053
  %a.addr.i43.i.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i43.i.i, metadata !67, metadata !DIExpression()), !dbg !5054
  %n.addr.i44.i.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i44.i.i, metadata !76, metadata !DIExpression()), !dbg !5057
  %a.addr.i35.i.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i35.i.i, metadata !67, metadata !DIExpression()), !dbg !5058
  %n.addr.i36.i.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i36.i.i, metadata !76, metadata !DIExpression()), !dbg !5060
  %a.addr.i27.i.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i27.i.i, metadata !67, metadata !DIExpression()), !dbg !5061
  %n.addr.i28.i.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i28.i.i, metadata !76, metadata !DIExpression()), !dbg !5063
  %a.addr.i.i.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i.i, metadata !67, metadata !DIExpression()), !dbg !5064
  %n.addr.i.i.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i.i.i, metadata !76, metadata !DIExpression()), !dbg !5066
  %X.addr.i.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.addr.i.i, metadata !336, metadata !DIExpression()), !dbg !5067
  %t.i.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i.i, metadata !338, metadata !DIExpression()), !dbg !5068
  %v.addr.i269.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %v.addr.i269.i, metadata !718, metadata !DIExpression()), !dbg !5069
  %b.addr.i270.i = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i270.i, metadata !724, metadata !DIExpression()), !dbg !5071
  %v.addr.i257.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %v.addr.i257.i, metadata !718, metadata !DIExpression()), !dbg !5072
  %b.addr.i258.i = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i258.i, metadata !724, metadata !DIExpression()), !dbg !5074
  %v.addr.i245.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %v.addr.i245.i, metadata !718, metadata !DIExpression()), !dbg !5075
  %b.addr.i246.i = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i246.i, metadata !724, metadata !DIExpression()), !dbg !5077
  %v.addr.i.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %v.addr.i.i, metadata !718, metadata !DIExpression()), !dbg !5078
  %b.addr.i242.i = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i242.i, metadata !724, metadata !DIExpression()), !dbg !5080
  %b.addr.i.i22 = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i.i22, metadata !53, metadata !DIExpression()), !dbg !5081
  %n.addr.i.i23 = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %n.addr.i.i23, metadata !59, metadata !DIExpression()), !dbg !5083
  %in.addr.i = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %in.addr.i, metadata !738, metadata !DIExpression()), !dbg !5084
  %out.addr.i = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %out.addr.i, metadata !740, metadata !DIExpression()), !dbg !5085
  %ks.addr.i24 = alloca %struct.SM4_KEY_st*, align 8
  call void @llvm.dbg.declare(metadata %struct.SM4_KEY_st** %ks.addr.i24, metadata !742, metadata !DIExpression()), !dbg !5086
  %B0.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %B0.i, metadata !744, metadata !DIExpression()), !dbg !5087
  %B1.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %B1.i, metadata !772, metadata !DIExpression()), !dbg !5088
  %B2.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %B2.i, metadata !800, metadata !DIExpression()), !dbg !5089
  %B3.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %B3.i, metadata !828, metadata !DIExpression()), !dbg !5090
  %b.addr.i125.i = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i125.i, metadata !53, metadata !DIExpression()), !dbg !5091
  %n.addr.i126.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %n.addr.i126.i, metadata !59, metadata !DIExpression()), !dbg !5094
  %b.addr.i98.i = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i98.i, metadata !53, metadata !DIExpression()), !dbg !5095
  %n.addr.i99.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %n.addr.i99.i, metadata !59, metadata !DIExpression()), !dbg !5097
  %b.addr.i71.i = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i71.i, metadata !53, metadata !DIExpression()), !dbg !5098
  %n.addr.i72.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %n.addr.i72.i, metadata !59, metadata !DIExpression()), !dbg !5100
  %a.addr.i63.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i63.i, metadata !67, metadata !DIExpression()), !dbg !5101
  %n.addr.i64.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i64.i, metadata !76, metadata !DIExpression()), !dbg !5103
  %a.addr.i.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %a.addr.i.i, metadata !67, metadata !DIExpression()), !dbg !5104
  %n.addr.i59.i = alloca i8, align 1
  call void @llvm.dbg.declare(metadata i8* %n.addr.i59.i, metadata !76, metadata !DIExpression()), !dbg !5106
  %b.addr.i.i = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %b.addr.i.i, metadata !53, metadata !DIExpression()), !dbg !5107
  %n.addr.i.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %n.addr.i.i, metadata !59, metadata !DIExpression()), !dbg !5109
  %key.addr.i = alloca i8*, align 8
  call void @llvm.dbg.declare(metadata i8** %key.addr.i, metadata !84, metadata !DIExpression()), !dbg !5110
  %ks.addr.i = alloca %struct.SM4_KEY_st*, align 8
  call void @llvm.dbg.declare(metadata %struct.SM4_KEY_st** %ks.addr.i, metadata !86, metadata !DIExpression()), !dbg !5111
  %K.i = alloca [4 x i32], align 16
  call void @llvm.dbg.declare(metadata [4 x i32]* %K.i, metadata !88, metadata !DIExpression()), !dbg !5112
  %i.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %i.i, metadata !91, metadata !DIExpression()), !dbg !5113
  %X.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %X.i, metadata !218, metadata !DIExpression()), !dbg !5114
  %t.i = alloca i32, align 4
  call void @llvm.dbg.declare(metadata i32* %t.i, metadata !237, metadata !DIExpression()), !dbg !5115
  %retval = alloca i32, align 4
  %enc_key = alloca %struct.SM4_KEY_st, align 4
  %enc_out = alloca [256 x i8], align 16
  %charset = alloca [94 x i8], align 16
  %length = alloca i64, align 8
  %size = alloca i32, align 4
  %round = alloca i64, align 8
  %i = alloca i32, align 4
  %buff = alloca i8*, align 8
  %input = alloca i8*, align 8
  %n = alloca i64, align 8
  %key = alloca i32, align 4
  %in = alloca i8*, align 8
  %0 = load i32, i32* @Inst_Counter
  %1 = add i32 592, %0
  store i32 %1, i32* @Inst_Counter
  %2 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2)
  %3 = ptrtoint i32* %retval to i64
  call void @printStoreAddr(i64 %3, i32 591, i32 0, i32 0)
  store i32 0, i32* %retval, align 4
  call void @printDDep(i32 591, i32 591)
  call void @llvm.dbg.declare(metadata %struct.SM4_KEY_st* %enc_key, metadata !5116, metadata !DIExpression()), !dbg !5117
  call void @llvm.dbg.declare(metadata [256 x i8]* %enc_out, metadata !5118, metadata !DIExpression()), !dbg !5120
  %4 = load i32, i32* @Inst_Counter
  %5 = add i32 3, %4
  store i32 %5, i32* @Inst_Counter
  %6 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %6)
  %7 = ptrtoint i8** %key.addr.i to i64
  call void @printStoreAddr(i64 %7, i32 594, i32 0, i32 0)
  store i8* getelementptr inbounds ([32 x i8], [32 x i8]* @key, i64 0, i64 0), i8** %key.addr.i, align 8
  call void @printDDep(i32 594, i32 594)
  call void @printDDep(i32 591, i32 594)
  %8 = load i32, i32* @Inst_Counter
  %9 = add i32 1, %8
  store i32 %9, i32* @Inst_Counter
  %10 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %10)
  %11 = ptrtoint %struct.SM4_KEY_st** %ks.addr.i to i64
  call void @printStoreAddr(i64 %11, i32 595, i32 0, i32 0)
  store %struct.SM4_KEY_st* %enc_key, %struct.SM4_KEY_st** %ks.addr.i, align 8
  call void @printDDep(i32 595, i32 595)
  call void @printDDep(i32 594, i32 595)
  %12 = load i32, i32* @Inst_Counter, !dbg !5121
  %13 = add i32 1, %12, !dbg !5121
  store i32 %13, i32* @Inst_Counter, !dbg !5121
  %14 = load i32, i32* @Inst_Counter, !dbg !5121
  call void @printCounter(i32 %14), !dbg !5121
  %15 = ptrtoint i8** %key.addr.i to i64, !dbg !5121
  call void @printLoadAddr(i64 %15, i32 596, i32 159, i32 24), !dbg !5121
  %16 = load i8*, i8** %key.addr.i, align 8, !dbg !5121
  call void @printDDep(i32 594, i32 596), !dbg !5121
  call void @printDDep(i32 594, i32 596), !dbg !5121
  call void @printDDep(i32 594, i32 596), !dbg !5121
  %17 = load i32, i32* @Inst_Counter
  %18 = add i32 1, %17
  store i32 %18, i32* @Inst_Counter
  %19 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %19)
  %20 = ptrtoint i8** %b.addr.i.i to i64
  call void @printStoreAddr(i64 %20, i32 597, i32 0, i32 0)
  store i8* %16, i8** %b.addr.i.i, align 8
  call void @printDDep(i32 596, i32 597)
  call void @printDDep(i32 597, i32 597)
  call void @printDDep(i32 595, i32 597)
  %21 = load i32, i32* @Inst_Counter
  %22 = add i32 1, %21
  store i32 %22, i32* @Inst_Counter
  %23 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %23)
  %24 = ptrtoint i32* %n.addr.i.i to i64
  call void @printStoreAddr(i64 %24, i32 598, i32 0, i32 0)
  store i32 0, i32* %n.addr.i.i, align 4
  call void @printDDep(i32 598, i32 598)
  call void @printDDep(i32 597, i32 598)
  %25 = load i32, i32* @Inst_Counter, !dbg !5122
  %26 = add i32 1, %25, !dbg !5122
  store i32 %26, i32* @Inst_Counter, !dbg !5122
  %27 = load i32, i32* @Inst_Counter, !dbg !5122
  call void @printCounter(i32 %27), !dbg !5122
  %28 = ptrtoint i8** %b.addr.i.i to i64, !dbg !5122
  call void @printLoadAddr(i64 %28, i32 599, i32 97, i32 23), !dbg !5122
  %29 = load i8*, i8** %b.addr.i.i, align 8, !dbg !5122
  call void @printDDep(i32 597, i32 599), !dbg !5122
  call void @printDDep(i32 597, i32 599), !dbg !5122
  call void @printDDep(i32 597, i32 599), !dbg !5122
  %30 = load i32, i32* @Inst_Counter, !dbg !5123
  %31 = add i32 1, %30, !dbg !5123
  store i32 %31, i32* @Inst_Counter, !dbg !5123
  %32 = load i32, i32* @Inst_Counter, !dbg !5123
  call void @printCounter(i32 %32), !dbg !5123
  %33 = ptrtoint i32* %n.addr.i.i to i64, !dbg !5123
  call void @printLoadAddr(i64 %33, i32 600, i32 97, i32 29), !dbg !5123
  %34 = load i32, i32* %n.addr.i.i, align 4, !dbg !5123
  call void @printDDep(i32 598, i32 600), !dbg !5123
  call void @printDDep(i32 598, i32 600), !dbg !5123
  call void @printDDep(i32 598, i32 600), !dbg !5123
  %mul.i.i = mul i32 4, %34, !dbg !5124
  %idxprom.i.i = zext i32 %mul.i.i to i64, !dbg !5122
  %arrayidx.i.i = getelementptr inbounds i8, i8* %29, i64 %idxprom.i.i, !dbg !5122
  %35 = load i32, i32* @Inst_Counter, !dbg !5122
  %36 = add i32 4, %35, !dbg !5122
  store i32 %36, i32* @Inst_Counter, !dbg !5122
  %37 = load i32, i32* @Inst_Counter, !dbg !5122
  call void @printCounter(i32 %37), !dbg !5122
  %38 = ptrtoint i8* %arrayidx.i.i to i64, !dbg !5122
  call void @printLoadAddr(i64 %38, i32 604, i32 97, i32 23), !dbg !5122
  %39 = load i8, i8* %arrayidx.i.i, align 1, !dbg !5122
  call void @printDDep(i32 599, i32 604), !dbg !5122
  call void @printDDep(i32 600, i32 604), !dbg !5122
  %conv.i.i = zext i8 %39 to i32, !dbg !5125
  %shl.i.i = shl i32 %conv.i.i, 24, !dbg !5126
  %40 = load i32, i32* @Inst_Counter, !dbg !5127
  %41 = add i32 3, %40, !dbg !5127
  store i32 %41, i32* @Inst_Counter, !dbg !5127
  %42 = load i32, i32* @Inst_Counter, !dbg !5127
  call void @printCounter(i32 %42), !dbg !5127
  %43 = ptrtoint i8** %b.addr.i.i to i64, !dbg !5127
  call void @printLoadAddr(i64 %43, i32 607, i32 98, i32 23), !dbg !5127
  %44 = load i8*, i8** %b.addr.i.i, align 8, !dbg !5127
  call void @printDDep(i32 597, i32 607), !dbg !5127
  call void @printDDep(i32 597, i32 607), !dbg !5127
  call void @printDDep(i32 599, i32 607), !dbg !5127
  %45 = load i32, i32* @Inst_Counter, !dbg !5128
  %46 = add i32 1, %45, !dbg !5128
  store i32 %46, i32* @Inst_Counter, !dbg !5128
  %47 = load i32, i32* @Inst_Counter, !dbg !5128
  call void @printCounter(i32 %47), !dbg !5128
  %48 = ptrtoint i32* %n.addr.i.i to i64, !dbg !5128
  call void @printLoadAddr(i64 %48, i32 608, i32 98, i32 29), !dbg !5128
  %49 = load i32, i32* %n.addr.i.i, align 4, !dbg !5128
  call void @printDDep(i32 598, i32 608), !dbg !5128
  call void @printDDep(i32 598, i32 608), !dbg !5128
  call void @printDDep(i32 600, i32 608), !dbg !5128
  %mul1.i.i = mul i32 4, %49, !dbg !5129
  %add.i.i = add i32 %mul1.i.i, 1, !dbg !5130
  %idxprom2.i.i = zext i32 %add.i.i to i64, !dbg !5127
  %arrayidx3.i.i = getelementptr inbounds i8, i8* %44, i64 %idxprom2.i.i, !dbg !5127
  %50 = load i32, i32* @Inst_Counter, !dbg !5127
  %51 = add i32 5, %50, !dbg !5127
  store i32 %51, i32* @Inst_Counter, !dbg !5127
  %52 = load i32, i32* @Inst_Counter, !dbg !5127
  call void @printCounter(i32 %52), !dbg !5127
  %53 = ptrtoint i8* %arrayidx3.i.i to i64, !dbg !5127
  call void @printLoadAddr(i64 %53, i32 613, i32 98, i32 23), !dbg !5127
  %54 = load i8, i8* %arrayidx3.i.i, align 1, !dbg !5127
  call void @printDDep(i32 607, i32 613), !dbg !5127
  call void @printDDep(i32 608, i32 613), !dbg !5127
  call void @printDDep(i32 604, i32 613), !dbg !5127
  %conv4.i.i = zext i8 %54 to i32, !dbg !5131
  %shl5.i.i = shl i32 %conv4.i.i, 16, !dbg !5132
  %or.i.i = or i32 %shl.i.i, %shl5.i.i, !dbg !5133
  %55 = load i32, i32* @Inst_Counter, !dbg !5134
  %56 = add i32 4, %55, !dbg !5134
  store i32 %56, i32* @Inst_Counter, !dbg !5134
  %57 = load i32, i32* @Inst_Counter, !dbg !5134
  call void @printCounter(i32 %57), !dbg !5134
  %58 = ptrtoint i8** %b.addr.i.i to i64, !dbg !5134
  call void @printLoadAddr(i64 %58, i32 617, i32 99, i32 23), !dbg !5134
  %59 = load i8*, i8** %b.addr.i.i, align 8, !dbg !5134
  call void @printDDep(i32 597, i32 617), !dbg !5134
  call void @printDDep(i32 597, i32 617), !dbg !5134
  call void @printDDep(i32 607, i32 617), !dbg !5134
  %60 = load i32, i32* @Inst_Counter, !dbg !5135
  %61 = add i32 1, %60, !dbg !5135
  store i32 %61, i32* @Inst_Counter, !dbg !5135
  %62 = load i32, i32* @Inst_Counter, !dbg !5135
  call void @printCounter(i32 %62), !dbg !5135
  %63 = ptrtoint i32* %n.addr.i.i to i64, !dbg !5135
  call void @printLoadAddr(i64 %63, i32 618, i32 99, i32 29), !dbg !5135
  %64 = load i32, i32* %n.addr.i.i, align 4, !dbg !5135
  call void @printDDep(i32 598, i32 618), !dbg !5135
  call void @printDDep(i32 598, i32 618), !dbg !5135
  call void @printDDep(i32 608, i32 618), !dbg !5135
  %mul6.i.i = mul i32 4, %64, !dbg !5136
  %add7.i.i = add i32 %mul6.i.i, 2, !dbg !5137
  %idxprom8.i.i = zext i32 %add7.i.i to i64, !dbg !5134
  %arrayidx9.i.i = getelementptr inbounds i8, i8* %59, i64 %idxprom8.i.i, !dbg !5134
  %65 = load i32, i32* @Inst_Counter, !dbg !5134
  %66 = add i32 5, %65, !dbg !5134
  store i32 %66, i32* @Inst_Counter, !dbg !5134
  %67 = load i32, i32* @Inst_Counter, !dbg !5134
  call void @printCounter(i32 %67), !dbg !5134
  %68 = ptrtoint i8* %arrayidx9.i.i to i64, !dbg !5134
  call void @printLoadAddr(i64 %68, i32 623, i32 99, i32 23), !dbg !5134
  %69 = load i8, i8* %arrayidx9.i.i, align 1, !dbg !5134
  call void @printDDep(i32 617, i32 623), !dbg !5134
  call void @printDDep(i32 618, i32 623), !dbg !5134
  call void @printDDep(i32 613, i32 623), !dbg !5134
  %conv10.i.i = zext i8 %69 to i32, !dbg !5138
  %shl11.i.i = shl i32 %conv10.i.i, 8, !dbg !5139
  %or12.i.i = or i32 %or.i.i, %shl11.i.i, !dbg !5140
  %70 = load i32, i32* @Inst_Counter, !dbg !5141
  %71 = add i32 4, %70, !dbg !5141
  store i32 %71, i32* @Inst_Counter, !dbg !5141
  %72 = load i32, i32* @Inst_Counter, !dbg !5141
  call void @printCounter(i32 %72), !dbg !5141
  %73 = ptrtoint i8** %b.addr.i.i to i64, !dbg !5141
  call void @printLoadAddr(i64 %73, i32 627, i32 100, i32 23), !dbg !5141
  %74 = load i8*, i8** %b.addr.i.i, align 8, !dbg !5141
  call void @printDDep(i32 597, i32 627), !dbg !5141
  call void @printDDep(i32 597, i32 627), !dbg !5141
  call void @printDDep(i32 617, i32 627), !dbg !5141
  %75 = load i32, i32* @Inst_Counter, !dbg !5142
  %76 = add i32 1, %75, !dbg !5142
  store i32 %76, i32* @Inst_Counter, !dbg !5142
  %77 = load i32, i32* @Inst_Counter, !dbg !5142
  call void @printCounter(i32 %77), !dbg !5142
  %78 = ptrtoint i32* %n.addr.i.i to i64, !dbg !5142
  call void @printLoadAddr(i64 %78, i32 628, i32 100, i32 29), !dbg !5142
  %79 = load i32, i32* %n.addr.i.i, align 4, !dbg !5142
  call void @printDDep(i32 598, i32 628), !dbg !5142
  call void @printDDep(i32 598, i32 628), !dbg !5142
  call void @printDDep(i32 618, i32 628), !dbg !5142
  %mul13.i.i = mul i32 4, %79, !dbg !5143
  %add14.i.i = add i32 %mul13.i.i, 3, !dbg !5144
  %idxprom15.i.i = zext i32 %add14.i.i to i64, !dbg !5141
  %arrayidx16.i.i = getelementptr inbounds i8, i8* %74, i64 %idxprom15.i.i, !dbg !5141
  %80 = load i32, i32* @Inst_Counter, !dbg !5141
  %81 = add i32 5, %80, !dbg !5141
  store i32 %81, i32* @Inst_Counter, !dbg !5141
  %82 = load i32, i32* @Inst_Counter, !dbg !5141
  call void @printCounter(i32 %82), !dbg !5141
  %83 = ptrtoint i8* %arrayidx16.i.i to i64, !dbg !5141
  call void @printLoadAddr(i64 %83, i32 633, i32 100, i32 23), !dbg !5141
  %84 = load i8, i8* %arrayidx16.i.i, align 1, !dbg !5141
  call void @printDDep(i32 627, i32 633), !dbg !5141
  call void @printDDep(i32 628, i32 633), !dbg !5141
  call void @printDDep(i32 623, i32 633), !dbg !5141
  %conv17.i.i = zext i8 %84 to i32, !dbg !5145
  %or18.i.i = or i32 %or12.i.i, %conv17.i.i, !dbg !5146
  %xor.i = xor i32 %or18.i.i, -1548633402, !dbg !5147
  %arrayidx.i = getelementptr inbounds [4 x i32], [4 x i32]* %K.i, i64 0, i64 0, !dbg !5148
  %85 = load i32, i32* @Inst_Counter, !dbg !5149
  %86 = add i32 5, %85, !dbg !5149
  store i32 %86, i32* @Inst_Counter, !dbg !5149
  %87 = load i32, i32* @Inst_Counter, !dbg !5149
  call void @printCounter(i32 %87), !dbg !5149
  %88 = ptrtoint i32* %arrayidx.i to i64, !dbg !5149
  call void @printStoreAddr(i64 %88, i32 638, i32 159, i32 10), !dbg !5149
  store i32 %xor.i, i32* %arrayidx.i, align 16, !dbg !5149
  call void @printDDep(i32 604, i32 638), !dbg !5149
  call void @printDDep(i32 613, i32 638), !dbg !5149
  call void @printDDep(i32 623, i32 638), !dbg !5149
  call void @printDDep(i32 633, i32 638), !dbg !5149
  call void @printDDep(i32 638, i32 638), !dbg !5149
  call void @printDDep(i32 598, i32 638), !dbg !5149
  %89 = load i32, i32* @Inst_Counter, !dbg !5150
  %90 = add i32 1, %89, !dbg !5150
  store i32 %90, i32* @Inst_Counter, !dbg !5150
  %91 = load i32, i32* @Inst_Counter, !dbg !5150
  call void @printCounter(i32 %91), !dbg !5150
  %92 = ptrtoint i8** %key.addr.i to i64, !dbg !5150
  call void @printLoadAddr(i64 %92, i32 639, i32 160, i32 24), !dbg !5150
  %93 = load i8*, i8** %key.addr.i, align 8, !dbg !5150
  call void @printDDep(i32 594, i32 639), !dbg !5150
  call void @printDDep(i32 594, i32 639), !dbg !5150
  call void @printDDep(i32 596, i32 639), !dbg !5150
  %94 = load i32, i32* @Inst_Counter
  %95 = add i32 1, %94
  store i32 %95, i32* @Inst_Counter
  %96 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %96)
  %97 = ptrtoint i8** %b.addr.i125.i to i64
  call void @printStoreAddr(i64 %97, i32 640, i32 0, i32 0)
  store i8* %93, i8** %b.addr.i125.i, align 8
  call void @printDDep(i32 639, i32 640)
  call void @printDDep(i32 640, i32 640)
  call void @printDDep(i32 638, i32 640)
  %98 = load i32, i32* @Inst_Counter
  %99 = add i32 1, %98
  store i32 %99, i32* @Inst_Counter
  %100 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %100)
  %101 = ptrtoint i32* %n.addr.i126.i to i64
  call void @printStoreAddr(i64 %101, i32 641, i32 0, i32 0)
  store i32 1, i32* %n.addr.i126.i, align 4
  call void @printDDep(i32 641, i32 641)
  call void @printDDep(i32 640, i32 641)
  %102 = load i32, i32* @Inst_Counter, !dbg !5151
  %103 = add i32 1, %102, !dbg !5151
  store i32 %103, i32* @Inst_Counter, !dbg !5151
  %104 = load i32, i32* @Inst_Counter, !dbg !5151
  call void @printCounter(i32 %104), !dbg !5151
  %105 = ptrtoint i8** %b.addr.i125.i to i64, !dbg !5151
  call void @printLoadAddr(i64 %105, i32 642, i32 97, i32 23), !dbg !5151
  %106 = load i8*, i8** %b.addr.i125.i, align 8, !dbg !5151
  call void @printDDep(i32 640, i32 642), !dbg !5151
  call void @printDDep(i32 640, i32 642), !dbg !5151
  call void @printDDep(i32 640, i32 642), !dbg !5151
  %107 = load i32, i32* @Inst_Counter, !dbg !5152
  %108 = add i32 1, %107, !dbg !5152
  store i32 %108, i32* @Inst_Counter, !dbg !5152
  %109 = load i32, i32* @Inst_Counter, !dbg !5152
  call void @printCounter(i32 %109), !dbg !5152
  %110 = ptrtoint i32* %n.addr.i126.i to i64, !dbg !5152
  call void @printLoadAddr(i64 %110, i32 643, i32 97, i32 29), !dbg !5152
  %111 = load i32, i32* %n.addr.i126.i, align 4, !dbg !5152
  call void @printDDep(i32 641, i32 643), !dbg !5152
  call void @printDDep(i32 641, i32 643), !dbg !5152
  call void @printDDep(i32 641, i32 643), !dbg !5152
  %mul.i127.i = mul i32 4, %111, !dbg !5153
  %idxprom.i128.i = zext i32 %mul.i127.i to i64, !dbg !5151
  %arrayidx.i129.i = getelementptr inbounds i8, i8* %106, i64 %idxprom.i128.i, !dbg !5151
  %112 = load i32, i32* @Inst_Counter, !dbg !5151
  %113 = add i32 4, %112, !dbg !5151
  store i32 %113, i32* @Inst_Counter, !dbg !5151
  %114 = load i32, i32* @Inst_Counter, !dbg !5151
  call void @printCounter(i32 %114), !dbg !5151
  %115 = ptrtoint i8* %arrayidx.i129.i to i64, !dbg !5151
  call void @printLoadAddr(i64 %115, i32 647, i32 97, i32 23), !dbg !5151
  %116 = load i8, i8* %arrayidx.i129.i, align 1, !dbg !5151
  call void @printDDep(i32 642, i32 647), !dbg !5151
  call void @printDDep(i32 643, i32 647), !dbg !5151
  call void @printDDep(i32 633, i32 647), !dbg !5151
  %conv.i130.i = zext i8 %116 to i32, !dbg !5154
  %shl.i131.i = shl i32 %conv.i130.i, 24, !dbg !5155
  %117 = load i32, i32* @Inst_Counter, !dbg !5156
  %118 = add i32 3, %117, !dbg !5156
  store i32 %118, i32* @Inst_Counter, !dbg !5156
  %119 = load i32, i32* @Inst_Counter, !dbg !5156
  call void @printCounter(i32 %119), !dbg !5156
  %120 = ptrtoint i8** %b.addr.i125.i to i64, !dbg !5156
  call void @printLoadAddr(i64 %120, i32 650, i32 98, i32 23), !dbg !5156
  %121 = load i8*, i8** %b.addr.i125.i, align 8, !dbg !5156
  call void @printDDep(i32 640, i32 650), !dbg !5156
  call void @printDDep(i32 640, i32 650), !dbg !5156
  call void @printDDep(i32 642, i32 650), !dbg !5156
  %122 = load i32, i32* @Inst_Counter, !dbg !5157
  %123 = add i32 1, %122, !dbg !5157
  store i32 %123, i32* @Inst_Counter, !dbg !5157
  %124 = load i32, i32* @Inst_Counter, !dbg !5157
  call void @printCounter(i32 %124), !dbg !5157
  %125 = ptrtoint i32* %n.addr.i126.i to i64, !dbg !5157
  call void @printLoadAddr(i64 %125, i32 651, i32 98, i32 29), !dbg !5157
  %126 = load i32, i32* %n.addr.i126.i, align 4, !dbg !5157
  call void @printDDep(i32 641, i32 651), !dbg !5157
  call void @printDDep(i32 641, i32 651), !dbg !5157
  call void @printDDep(i32 643, i32 651), !dbg !5157
  %mul1.i132.i = mul i32 4, %126, !dbg !5158
  %add.i133.i = add i32 %mul1.i132.i, 1, !dbg !5159
  %idxprom2.i134.i = zext i32 %add.i133.i to i64, !dbg !5156
  %arrayidx3.i135.i = getelementptr inbounds i8, i8* %121, i64 %idxprom2.i134.i, !dbg !5156
  %127 = load i32, i32* @Inst_Counter, !dbg !5156
  %128 = add i32 5, %127, !dbg !5156
  store i32 %128, i32* @Inst_Counter, !dbg !5156
  %129 = load i32, i32* @Inst_Counter, !dbg !5156
  call void @printCounter(i32 %129), !dbg !5156
  %130 = ptrtoint i8* %arrayidx3.i135.i to i64, !dbg !5156
  call void @printLoadAddr(i64 %130, i32 656, i32 98, i32 23), !dbg !5156
  %131 = load i8, i8* %arrayidx3.i135.i, align 1, !dbg !5156
  call void @printDDep(i32 650, i32 656), !dbg !5156
  call void @printDDep(i32 651, i32 656), !dbg !5156
  call void @printDDep(i32 647, i32 656), !dbg !5156
  %conv4.i136.i = zext i8 %131 to i32, !dbg !5160
  %shl5.i137.i = shl i32 %conv4.i136.i, 16, !dbg !5161
  %or.i138.i = or i32 %shl.i131.i, %shl5.i137.i, !dbg !5162
  %132 = load i32, i32* @Inst_Counter, !dbg !5163
  %133 = add i32 4, %132, !dbg !5163
  store i32 %133, i32* @Inst_Counter, !dbg !5163
  %134 = load i32, i32* @Inst_Counter, !dbg !5163
  call void @printCounter(i32 %134), !dbg !5163
  %135 = ptrtoint i8** %b.addr.i125.i to i64, !dbg !5163
  call void @printLoadAddr(i64 %135, i32 660, i32 99, i32 23), !dbg !5163
  %136 = load i8*, i8** %b.addr.i125.i, align 8, !dbg !5163
  call void @printDDep(i32 640, i32 660), !dbg !5163
  call void @printDDep(i32 640, i32 660), !dbg !5163
  call void @printDDep(i32 650, i32 660), !dbg !5163
  %137 = load i32, i32* @Inst_Counter, !dbg !5164
  %138 = add i32 1, %137, !dbg !5164
  store i32 %138, i32* @Inst_Counter, !dbg !5164
  %139 = load i32, i32* @Inst_Counter, !dbg !5164
  call void @printCounter(i32 %139), !dbg !5164
  %140 = ptrtoint i32* %n.addr.i126.i to i64, !dbg !5164
  call void @printLoadAddr(i64 %140, i32 661, i32 99, i32 29), !dbg !5164
  %141 = load i32, i32* %n.addr.i126.i, align 4, !dbg !5164
  call void @printDDep(i32 641, i32 661), !dbg !5164
  call void @printDDep(i32 641, i32 661), !dbg !5164
  call void @printDDep(i32 651, i32 661), !dbg !5164
  %mul6.i139.i = mul i32 4, %141, !dbg !5165
  %add7.i140.i = add i32 %mul6.i139.i, 2, !dbg !5166
  %idxprom8.i141.i = zext i32 %add7.i140.i to i64, !dbg !5163
  %arrayidx9.i142.i = getelementptr inbounds i8, i8* %136, i64 %idxprom8.i141.i, !dbg !5163
  %142 = load i32, i32* @Inst_Counter, !dbg !5163
  %143 = add i32 5, %142, !dbg !5163
  store i32 %143, i32* @Inst_Counter, !dbg !5163
  %144 = load i32, i32* @Inst_Counter, !dbg !5163
  call void @printCounter(i32 %144), !dbg !5163
  %145 = ptrtoint i8* %arrayidx9.i142.i to i64, !dbg !5163
  call void @printLoadAddr(i64 %145, i32 666, i32 99, i32 23), !dbg !5163
  %146 = load i8, i8* %arrayidx9.i142.i, align 1, !dbg !5163
  call void @printDDep(i32 660, i32 666), !dbg !5163
  call void @printDDep(i32 661, i32 666), !dbg !5163
  call void @printDDep(i32 656, i32 666), !dbg !5163
  %conv10.i143.i = zext i8 %146 to i32, !dbg !5167
  %shl11.i144.i = shl i32 %conv10.i143.i, 8, !dbg !5168
  %or12.i145.i = or i32 %or.i138.i, %shl11.i144.i, !dbg !5169
  %147 = load i32, i32* @Inst_Counter, !dbg !5170
  %148 = add i32 4, %147, !dbg !5170
  store i32 %148, i32* @Inst_Counter, !dbg !5170
  %149 = load i32, i32* @Inst_Counter, !dbg !5170
  call void @printCounter(i32 %149), !dbg !5170
  %150 = ptrtoint i8** %b.addr.i125.i to i64, !dbg !5170
  call void @printLoadAddr(i64 %150, i32 670, i32 100, i32 23), !dbg !5170
  %151 = load i8*, i8** %b.addr.i125.i, align 8, !dbg !5170
  call void @printDDep(i32 640, i32 670), !dbg !5170
  call void @printDDep(i32 640, i32 670), !dbg !5170
  call void @printDDep(i32 660, i32 670), !dbg !5170
  %152 = load i32, i32* @Inst_Counter, !dbg !5171
  %153 = add i32 1, %152, !dbg !5171
  store i32 %153, i32* @Inst_Counter, !dbg !5171
  %154 = load i32, i32* @Inst_Counter, !dbg !5171
  call void @printCounter(i32 %154), !dbg !5171
  %155 = ptrtoint i32* %n.addr.i126.i to i64, !dbg !5171
  call void @printLoadAddr(i64 %155, i32 671, i32 100, i32 29), !dbg !5171
  %156 = load i32, i32* %n.addr.i126.i, align 4, !dbg !5171
  call void @printDDep(i32 641, i32 671), !dbg !5171
  call void @printDDep(i32 641, i32 671), !dbg !5171
  call void @printDDep(i32 661, i32 671), !dbg !5171
  %mul13.i146.i = mul i32 4, %156, !dbg !5172
  %add14.i147.i = add i32 %mul13.i146.i, 3, !dbg !5173
  %idxprom15.i148.i = zext i32 %add14.i147.i to i64, !dbg !5170
  %arrayidx16.i149.i = getelementptr inbounds i8, i8* %151, i64 %idxprom15.i148.i, !dbg !5170
  %157 = load i32, i32* @Inst_Counter, !dbg !5170
  %158 = add i32 5, %157, !dbg !5170
  store i32 %158, i32* @Inst_Counter, !dbg !5170
  %159 = load i32, i32* @Inst_Counter, !dbg !5170
  call void @printCounter(i32 %159), !dbg !5170
  %160 = ptrtoint i8* %arrayidx16.i149.i to i64, !dbg !5170
  call void @printLoadAddr(i64 %160, i32 676, i32 100, i32 23), !dbg !5170
  %161 = load i8, i8* %arrayidx16.i149.i, align 1, !dbg !5170
  call void @printDDep(i32 670, i32 676), !dbg !5170
  call void @printDDep(i32 671, i32 676), !dbg !5170
  call void @printDDep(i32 666, i32 676), !dbg !5170
  %conv17.i150.i = zext i8 %161 to i32, !dbg !5174
  %or18.i151.i = or i32 %or12.i145.i, %conv17.i150.i, !dbg !5175
  %xor2.i = xor i32 %or18.i151.i, 1453994832, !dbg !5176
  %arrayidx3.i = getelementptr inbounds [4 x i32], [4 x i32]* %K.i, i64 0, i64 1, !dbg !5177
  %162 = load i32, i32* @Inst_Counter, !dbg !5178
  %163 = add i32 5, %162, !dbg !5178
  store i32 %163, i32* @Inst_Counter, !dbg !5178
  %164 = load i32, i32* @Inst_Counter, !dbg !5178
  call void @printCounter(i32 %164), !dbg !5178
  %165 = ptrtoint i32* %arrayidx3.i to i64, !dbg !5178
  call void @printStoreAddr(i64 %165, i32 681, i32 160, i32 10), !dbg !5178
  store i32 %xor2.i, i32* %arrayidx3.i, align 4, !dbg !5178
  call void @printDDep(i32 647, i32 681), !dbg !5178
  call void @printDDep(i32 656, i32 681), !dbg !5178
  call void @printDDep(i32 666, i32 681), !dbg !5178
  call void @printDDep(i32 676, i32 681), !dbg !5178
  call void @printDDep(i32 681, i32 681), !dbg !5178
  call void @printDDep(i32 641, i32 681), !dbg !5178
  %166 = load i32, i32* @Inst_Counter, !dbg !5179
  %167 = add i32 1, %166, !dbg !5179
  store i32 %167, i32* @Inst_Counter, !dbg !5179
  %168 = load i32, i32* @Inst_Counter, !dbg !5179
  call void @printCounter(i32 %168), !dbg !5179
  %169 = ptrtoint i8** %key.addr.i to i64, !dbg !5179
  call void @printLoadAddr(i64 %169, i32 682, i32 161, i32 24), !dbg !5179
  %170 = load i8*, i8** %key.addr.i, align 8, !dbg !5179
  call void @printDDep(i32 594, i32 682), !dbg !5179
  call void @printDDep(i32 594, i32 682), !dbg !5179
  call void @printDDep(i32 639, i32 682), !dbg !5179
  %171 = load i32, i32* @Inst_Counter
  %172 = add i32 1, %171
  store i32 %172, i32* @Inst_Counter
  %173 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %173)
  %174 = ptrtoint i8** %b.addr.i98.i to i64
  call void @printStoreAddr(i64 %174, i32 683, i32 0, i32 0)
  store i8* %170, i8** %b.addr.i98.i, align 8
  call void @printDDep(i32 682, i32 683)
  call void @printDDep(i32 683, i32 683)
  call void @printDDep(i32 681, i32 683)
  %175 = load i32, i32* @Inst_Counter
  %176 = add i32 1, %175
  store i32 %176, i32* @Inst_Counter
  %177 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %177)
  %178 = ptrtoint i32* %n.addr.i99.i to i64
  call void @printStoreAddr(i64 %178, i32 684, i32 0, i32 0)
  store i32 2, i32* %n.addr.i99.i, align 4
  call void @printDDep(i32 684, i32 684)
  call void @printDDep(i32 683, i32 684)
  %179 = load i32, i32* @Inst_Counter, !dbg !5180
  %180 = add i32 1, %179, !dbg !5180
  store i32 %180, i32* @Inst_Counter, !dbg !5180
  %181 = load i32, i32* @Inst_Counter, !dbg !5180
  call void @printCounter(i32 %181), !dbg !5180
  %182 = ptrtoint i8** %b.addr.i98.i to i64, !dbg !5180
  call void @printLoadAddr(i64 %182, i32 685, i32 97, i32 23), !dbg !5180
  %183 = load i8*, i8** %b.addr.i98.i, align 8, !dbg !5180
  call void @printDDep(i32 683, i32 685), !dbg !5180
  call void @printDDep(i32 683, i32 685), !dbg !5180
  call void @printDDep(i32 683, i32 685), !dbg !5180
  %184 = load i32, i32* @Inst_Counter, !dbg !5181
  %185 = add i32 1, %184, !dbg !5181
  store i32 %185, i32* @Inst_Counter, !dbg !5181
  %186 = load i32, i32* @Inst_Counter, !dbg !5181
  call void @printCounter(i32 %186), !dbg !5181
  %187 = ptrtoint i32* %n.addr.i99.i to i64, !dbg !5181
  call void @printLoadAddr(i64 %187, i32 686, i32 97, i32 29), !dbg !5181
  %188 = load i32, i32* %n.addr.i99.i, align 4, !dbg !5181
  call void @printDDep(i32 684, i32 686), !dbg !5181
  call void @printDDep(i32 684, i32 686), !dbg !5181
  call void @printDDep(i32 684, i32 686), !dbg !5181
  %mul.i100.i = mul i32 4, %188, !dbg !5182
  %idxprom.i101.i = zext i32 %mul.i100.i to i64, !dbg !5180
  %arrayidx.i102.i = getelementptr inbounds i8, i8* %183, i64 %idxprom.i101.i, !dbg !5180
  %189 = load i32, i32* @Inst_Counter, !dbg !5180
  %190 = add i32 4, %189, !dbg !5180
  store i32 %190, i32* @Inst_Counter, !dbg !5180
  %191 = load i32, i32* @Inst_Counter, !dbg !5180
  call void @printCounter(i32 %191), !dbg !5180
  %192 = ptrtoint i8* %arrayidx.i102.i to i64, !dbg !5180
  call void @printLoadAddr(i64 %192, i32 690, i32 97, i32 23), !dbg !5180
  %193 = load i8, i8* %arrayidx.i102.i, align 1, !dbg !5180
  call void @printDDep(i32 685, i32 690), !dbg !5180
  call void @printDDep(i32 686, i32 690), !dbg !5180
  call void @printDDep(i32 676, i32 690), !dbg !5180
  %conv.i103.i = zext i8 %193 to i32, !dbg !5183
  %shl.i104.i = shl i32 %conv.i103.i, 24, !dbg !5184
  %194 = load i32, i32* @Inst_Counter, !dbg !5185
  %195 = add i32 3, %194, !dbg !5185
  store i32 %195, i32* @Inst_Counter, !dbg !5185
  %196 = load i32, i32* @Inst_Counter, !dbg !5185
  call void @printCounter(i32 %196), !dbg !5185
  %197 = ptrtoint i8** %b.addr.i98.i to i64, !dbg !5185
  call void @printLoadAddr(i64 %197, i32 693, i32 98, i32 23), !dbg !5185
  %198 = load i8*, i8** %b.addr.i98.i, align 8, !dbg !5185
  call void @printDDep(i32 683, i32 693), !dbg !5185
  call void @printDDep(i32 683, i32 693), !dbg !5185
  call void @printDDep(i32 685, i32 693), !dbg !5185
  %199 = load i32, i32* @Inst_Counter, !dbg !5186
  %200 = add i32 1, %199, !dbg !5186
  store i32 %200, i32* @Inst_Counter, !dbg !5186
  %201 = load i32, i32* @Inst_Counter, !dbg !5186
  call void @printCounter(i32 %201), !dbg !5186
  %202 = ptrtoint i32* %n.addr.i99.i to i64, !dbg !5186
  call void @printLoadAddr(i64 %202, i32 694, i32 98, i32 29), !dbg !5186
  %203 = load i32, i32* %n.addr.i99.i, align 4, !dbg !5186
  call void @printDDep(i32 684, i32 694), !dbg !5186
  call void @printDDep(i32 684, i32 694), !dbg !5186
  call void @printDDep(i32 686, i32 694), !dbg !5186
  %mul1.i105.i = mul i32 4, %203, !dbg !5187
  %add.i106.i = add i32 %mul1.i105.i, 1, !dbg !5188
  %idxprom2.i107.i = zext i32 %add.i106.i to i64, !dbg !5185
  %arrayidx3.i108.i = getelementptr inbounds i8, i8* %198, i64 %idxprom2.i107.i, !dbg !5185
  %204 = load i32, i32* @Inst_Counter, !dbg !5185
  %205 = add i32 5, %204, !dbg !5185
  store i32 %205, i32* @Inst_Counter, !dbg !5185
  %206 = load i32, i32* @Inst_Counter, !dbg !5185
  call void @printCounter(i32 %206), !dbg !5185
  %207 = ptrtoint i8* %arrayidx3.i108.i to i64, !dbg !5185
  call void @printLoadAddr(i64 %207, i32 699, i32 98, i32 23), !dbg !5185
  %208 = load i8, i8* %arrayidx3.i108.i, align 1, !dbg !5185
  call void @printDDep(i32 693, i32 699), !dbg !5185
  call void @printDDep(i32 694, i32 699), !dbg !5185
  call void @printDDep(i32 690, i32 699), !dbg !5185
  %conv4.i109.i = zext i8 %208 to i32, !dbg !5189
  %shl5.i110.i = shl i32 %conv4.i109.i, 16, !dbg !5190
  %or.i111.i = or i32 %shl.i104.i, %shl5.i110.i, !dbg !5191
  %209 = load i32, i32* @Inst_Counter, !dbg !5192
  %210 = add i32 4, %209, !dbg !5192
  store i32 %210, i32* @Inst_Counter, !dbg !5192
  %211 = load i32, i32* @Inst_Counter, !dbg !5192
  call void @printCounter(i32 %211), !dbg !5192
  %212 = ptrtoint i8** %b.addr.i98.i to i64, !dbg !5192
  call void @printLoadAddr(i64 %212, i32 703, i32 99, i32 23), !dbg !5192
  %213 = load i8*, i8** %b.addr.i98.i, align 8, !dbg !5192
  call void @printDDep(i32 683, i32 703), !dbg !5192
  call void @printDDep(i32 683, i32 703), !dbg !5192
  call void @printDDep(i32 693, i32 703), !dbg !5192
  %214 = load i32, i32* @Inst_Counter, !dbg !5193
  %215 = add i32 1, %214, !dbg !5193
  store i32 %215, i32* @Inst_Counter, !dbg !5193
  %216 = load i32, i32* @Inst_Counter, !dbg !5193
  call void @printCounter(i32 %216), !dbg !5193
  %217 = ptrtoint i32* %n.addr.i99.i to i64, !dbg !5193
  call void @printLoadAddr(i64 %217, i32 704, i32 99, i32 29), !dbg !5193
  %218 = load i32, i32* %n.addr.i99.i, align 4, !dbg !5193
  call void @printDDep(i32 684, i32 704), !dbg !5193
  call void @printDDep(i32 684, i32 704), !dbg !5193
  call void @printDDep(i32 694, i32 704), !dbg !5193
  %mul6.i112.i = mul i32 4, %218, !dbg !5194
  %add7.i113.i = add i32 %mul6.i112.i, 2, !dbg !5195
  %idxprom8.i114.i = zext i32 %add7.i113.i to i64, !dbg !5192
  %arrayidx9.i115.i = getelementptr inbounds i8, i8* %213, i64 %idxprom8.i114.i, !dbg !5192
  %219 = load i32, i32* @Inst_Counter, !dbg !5192
  %220 = add i32 5, %219, !dbg !5192
  store i32 %220, i32* @Inst_Counter, !dbg !5192
  %221 = load i32, i32* @Inst_Counter, !dbg !5192
  call void @printCounter(i32 %221), !dbg !5192
  %222 = ptrtoint i8* %arrayidx9.i115.i to i64, !dbg !5192
  call void @printLoadAddr(i64 %222, i32 709, i32 99, i32 23), !dbg !5192
  %223 = load i8, i8* %arrayidx9.i115.i, align 1, !dbg !5192
  call void @printDDep(i32 703, i32 709), !dbg !5192
  call void @printDDep(i32 704, i32 709), !dbg !5192
  call void @printDDep(i32 699, i32 709), !dbg !5192
  %conv10.i116.i = zext i8 %223 to i32, !dbg !5196
  %shl11.i117.i = shl i32 %conv10.i116.i, 8, !dbg !5197
  %or12.i118.i = or i32 %or.i111.i, %shl11.i117.i, !dbg !5198
  %224 = load i32, i32* @Inst_Counter, !dbg !5199
  %225 = add i32 4, %224, !dbg !5199
  store i32 %225, i32* @Inst_Counter, !dbg !5199
  %226 = load i32, i32* @Inst_Counter, !dbg !5199
  call void @printCounter(i32 %226), !dbg !5199
  %227 = ptrtoint i8** %b.addr.i98.i to i64, !dbg !5199
  call void @printLoadAddr(i64 %227, i32 713, i32 100, i32 23), !dbg !5199
  %228 = load i8*, i8** %b.addr.i98.i, align 8, !dbg !5199
  call void @printDDep(i32 683, i32 713), !dbg !5199
  call void @printDDep(i32 683, i32 713), !dbg !5199
  call void @printDDep(i32 703, i32 713), !dbg !5199
  %229 = load i32, i32* @Inst_Counter, !dbg !5200
  %230 = add i32 1, %229, !dbg !5200
  store i32 %230, i32* @Inst_Counter, !dbg !5200
  %231 = load i32, i32* @Inst_Counter, !dbg !5200
  call void @printCounter(i32 %231), !dbg !5200
  %232 = ptrtoint i32* %n.addr.i99.i to i64, !dbg !5200
  call void @printLoadAddr(i64 %232, i32 714, i32 100, i32 29), !dbg !5200
  %233 = load i32, i32* %n.addr.i99.i, align 4, !dbg !5200
  call void @printDDep(i32 684, i32 714), !dbg !5200
  call void @printDDep(i32 684, i32 714), !dbg !5200
  call void @printDDep(i32 704, i32 714), !dbg !5200
  %mul13.i119.i = mul i32 4, %233, !dbg !5201
  %add14.i120.i = add i32 %mul13.i119.i, 3, !dbg !5202
  %idxprom15.i121.i = zext i32 %add14.i120.i to i64, !dbg !5199
  %arrayidx16.i122.i = getelementptr inbounds i8, i8* %228, i64 %idxprom15.i121.i, !dbg !5199
  %234 = load i32, i32* @Inst_Counter, !dbg !5199
  %235 = add i32 5, %234, !dbg !5199
  store i32 %235, i32* @Inst_Counter, !dbg !5199
  %236 = load i32, i32* @Inst_Counter, !dbg !5199
  call void @printCounter(i32 %236), !dbg !5199
  %237 = ptrtoint i8* %arrayidx16.i122.i to i64, !dbg !5199
  call void @printLoadAddr(i64 %237, i32 719, i32 100, i32 23), !dbg !5199
  %238 = load i8, i8* %arrayidx16.i122.i, align 1, !dbg !5199
  call void @printDDep(i32 713, i32 719), !dbg !5199
  call void @printDDep(i32 714, i32 719), !dbg !5199
  call void @printDDep(i32 709, i32 719), !dbg !5199
  %conv17.i123.i = zext i8 %238 to i32, !dbg !5203
  %or18.i124.i = or i32 %or12.i118.i, %conv17.i123.i, !dbg !5204
  %xor5.i = xor i32 %or18.i124.i, 1736282519, !dbg !5205
  %arrayidx6.i = getelementptr inbounds [4 x i32], [4 x i32]* %K.i, i64 0, i64 2, !dbg !5206
  %239 = load i32, i32* @Inst_Counter, !dbg !5207
  %240 = add i32 5, %239, !dbg !5207
  store i32 %240, i32* @Inst_Counter, !dbg !5207
  %241 = load i32, i32* @Inst_Counter, !dbg !5207
  call void @printCounter(i32 %241), !dbg !5207
  %242 = ptrtoint i32* %arrayidx6.i to i64, !dbg !5207
  call void @printStoreAddr(i64 %242, i32 724, i32 161, i32 10), !dbg !5207
  store i32 %xor5.i, i32* %arrayidx6.i, align 8, !dbg !5207
  call void @printDDep(i32 690, i32 724), !dbg !5207
  call void @printDDep(i32 699, i32 724), !dbg !5207
  call void @printDDep(i32 709, i32 724), !dbg !5207
  call void @printDDep(i32 719, i32 724), !dbg !5207
  call void @printDDep(i32 724, i32 724), !dbg !5207
  call void @printDDep(i32 684, i32 724), !dbg !5207
  %243 = load i32, i32* @Inst_Counter, !dbg !5208
  %244 = add i32 1, %243, !dbg !5208
  store i32 %244, i32* @Inst_Counter, !dbg !5208
  %245 = load i32, i32* @Inst_Counter, !dbg !5208
  call void @printCounter(i32 %245), !dbg !5208
  %246 = ptrtoint i8** %key.addr.i to i64, !dbg !5208
  call void @printLoadAddr(i64 %246, i32 725, i32 162, i32 24), !dbg !5208
  %247 = load i8*, i8** %key.addr.i, align 8, !dbg !5208
  call void @printDDep(i32 594, i32 725), !dbg !5208
  call void @printDDep(i32 594, i32 725), !dbg !5208
  call void @printDDep(i32 682, i32 725), !dbg !5208
  %248 = load i32, i32* @Inst_Counter
  %249 = add i32 1, %248
  store i32 %249, i32* @Inst_Counter
  %250 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %250)
  %251 = ptrtoint i8** %b.addr.i71.i to i64
  call void @printStoreAddr(i64 %251, i32 726, i32 0, i32 0)
  store i8* %247, i8** %b.addr.i71.i, align 8
  call void @printDDep(i32 725, i32 726)
  call void @printDDep(i32 726, i32 726)
  call void @printDDep(i32 724, i32 726)
  %252 = load i32, i32* @Inst_Counter
  %253 = add i32 1, %252
  store i32 %253, i32* @Inst_Counter
  %254 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %254)
  %255 = ptrtoint i32* %n.addr.i72.i to i64
  call void @printStoreAddr(i64 %255, i32 727, i32 0, i32 0)
  store i32 3, i32* %n.addr.i72.i, align 4
  call void @printDDep(i32 727, i32 727)
  call void @printDDep(i32 726, i32 727)
  %256 = load i32, i32* @Inst_Counter, !dbg !5209
  %257 = add i32 1, %256, !dbg !5209
  store i32 %257, i32* @Inst_Counter, !dbg !5209
  %258 = load i32, i32* @Inst_Counter, !dbg !5209
  call void @printCounter(i32 %258), !dbg !5209
  %259 = ptrtoint i8** %b.addr.i71.i to i64, !dbg !5209
  call void @printLoadAddr(i64 %259, i32 728, i32 97, i32 23), !dbg !5209
  %260 = load i8*, i8** %b.addr.i71.i, align 8, !dbg !5209
  call void @printDDep(i32 726, i32 728), !dbg !5209
  call void @printDDep(i32 726, i32 728), !dbg !5209
  call void @printDDep(i32 726, i32 728), !dbg !5209
  %261 = load i32, i32* @Inst_Counter, !dbg !5210
  %262 = add i32 1, %261, !dbg !5210
  store i32 %262, i32* @Inst_Counter, !dbg !5210
  %263 = load i32, i32* @Inst_Counter, !dbg !5210
  call void @printCounter(i32 %263), !dbg !5210
  %264 = ptrtoint i32* %n.addr.i72.i to i64, !dbg !5210
  call void @printLoadAddr(i64 %264, i32 729, i32 97, i32 29), !dbg !5210
  %265 = load i32, i32* %n.addr.i72.i, align 4, !dbg !5210
  call void @printDDep(i32 727, i32 729), !dbg !5210
  call void @printDDep(i32 727, i32 729), !dbg !5210
  call void @printDDep(i32 727, i32 729), !dbg !5210
  %mul.i73.i = mul i32 4, %265, !dbg !5211
  %idxprom.i74.i = zext i32 %mul.i73.i to i64, !dbg !5209
  %arrayidx.i75.i = getelementptr inbounds i8, i8* %260, i64 %idxprom.i74.i, !dbg !5209
  %266 = load i32, i32* @Inst_Counter, !dbg !5209
  %267 = add i32 4, %266, !dbg !5209
  store i32 %267, i32* @Inst_Counter, !dbg !5209
  %268 = load i32, i32* @Inst_Counter, !dbg !5209
  call void @printCounter(i32 %268), !dbg !5209
  %269 = ptrtoint i8* %arrayidx.i75.i to i64, !dbg !5209
  call void @printLoadAddr(i64 %269, i32 733, i32 97, i32 23), !dbg !5209
  %270 = load i8, i8* %arrayidx.i75.i, align 1, !dbg !5209
  call void @printDDep(i32 728, i32 733), !dbg !5209
  call void @printDDep(i32 729, i32 733), !dbg !5209
  call void @printDDep(i32 719, i32 733), !dbg !5209
  %conv.i76.i = zext i8 %270 to i32, !dbg !5212
  %shl.i77.i = shl i32 %conv.i76.i, 24, !dbg !5213
  %271 = load i32, i32* @Inst_Counter, !dbg !5214
  %272 = add i32 3, %271, !dbg !5214
  store i32 %272, i32* @Inst_Counter, !dbg !5214
  %273 = load i32, i32* @Inst_Counter, !dbg !5214
  call void @printCounter(i32 %273), !dbg !5214
  %274 = ptrtoint i8** %b.addr.i71.i to i64, !dbg !5214
  call void @printLoadAddr(i64 %274, i32 736, i32 98, i32 23), !dbg !5214
  %275 = load i8*, i8** %b.addr.i71.i, align 8, !dbg !5214
  call void @printDDep(i32 726, i32 736), !dbg !5214
  call void @printDDep(i32 726, i32 736), !dbg !5214
  call void @printDDep(i32 728, i32 736), !dbg !5214
  %276 = load i32, i32* @Inst_Counter, !dbg !5215
  %277 = add i32 1, %276, !dbg !5215
  store i32 %277, i32* @Inst_Counter, !dbg !5215
  %278 = load i32, i32* @Inst_Counter, !dbg !5215
  call void @printCounter(i32 %278), !dbg !5215
  %279 = ptrtoint i32* %n.addr.i72.i to i64, !dbg !5215
  call void @printLoadAddr(i64 %279, i32 737, i32 98, i32 29), !dbg !5215
  %280 = load i32, i32* %n.addr.i72.i, align 4, !dbg !5215
  call void @printDDep(i32 727, i32 737), !dbg !5215
  call void @printDDep(i32 727, i32 737), !dbg !5215
  call void @printDDep(i32 729, i32 737), !dbg !5215
  %mul1.i78.i = mul i32 4, %280, !dbg !5216
  %add.i79.i = add i32 %mul1.i78.i, 1, !dbg !5217
  %idxprom2.i80.i = zext i32 %add.i79.i to i64, !dbg !5214
  %arrayidx3.i81.i = getelementptr inbounds i8, i8* %275, i64 %idxprom2.i80.i, !dbg !5214
  %281 = load i32, i32* @Inst_Counter, !dbg !5214
  %282 = add i32 5, %281, !dbg !5214
  store i32 %282, i32* @Inst_Counter, !dbg !5214
  %283 = load i32, i32* @Inst_Counter, !dbg !5214
  call void @printCounter(i32 %283), !dbg !5214
  %284 = ptrtoint i8* %arrayidx3.i81.i to i64, !dbg !5214
  call void @printLoadAddr(i64 %284, i32 742, i32 98, i32 23), !dbg !5214
  %285 = load i8, i8* %arrayidx3.i81.i, align 1, !dbg !5214
  call void @printDDep(i32 736, i32 742), !dbg !5214
  call void @printDDep(i32 737, i32 742), !dbg !5214
  call void @printDDep(i32 733, i32 742), !dbg !5214
  %conv4.i82.i = zext i8 %285 to i32, !dbg !5218
  %shl5.i83.i = shl i32 %conv4.i82.i, 16, !dbg !5219
  %or.i84.i = or i32 %shl.i77.i, %shl5.i83.i, !dbg !5220
  %286 = load i32, i32* @Inst_Counter, !dbg !5221
  %287 = add i32 4, %286, !dbg !5221
  store i32 %287, i32* @Inst_Counter, !dbg !5221
  %288 = load i32, i32* @Inst_Counter, !dbg !5221
  call void @printCounter(i32 %288), !dbg !5221
  %289 = ptrtoint i8** %b.addr.i71.i to i64, !dbg !5221
  call void @printLoadAddr(i64 %289, i32 746, i32 99, i32 23), !dbg !5221
  %290 = load i8*, i8** %b.addr.i71.i, align 8, !dbg !5221
  call void @printDDep(i32 726, i32 746), !dbg !5221
  call void @printDDep(i32 726, i32 746), !dbg !5221
  call void @printDDep(i32 736, i32 746), !dbg !5221
  %291 = load i32, i32* @Inst_Counter, !dbg !5222
  %292 = add i32 1, %291, !dbg !5222
  store i32 %292, i32* @Inst_Counter, !dbg !5222
  %293 = load i32, i32* @Inst_Counter, !dbg !5222
  call void @printCounter(i32 %293), !dbg !5222
  %294 = ptrtoint i32* %n.addr.i72.i to i64, !dbg !5222
  call void @printLoadAddr(i64 %294, i32 747, i32 99, i32 29), !dbg !5222
  %295 = load i32, i32* %n.addr.i72.i, align 4, !dbg !5222
  call void @printDDep(i32 727, i32 747), !dbg !5222
  call void @printDDep(i32 727, i32 747), !dbg !5222
  call void @printDDep(i32 737, i32 747), !dbg !5222
  %mul6.i85.i = mul i32 4, %295, !dbg !5223
  %add7.i86.i = add i32 %mul6.i85.i, 2, !dbg !5224
  %idxprom8.i87.i = zext i32 %add7.i86.i to i64, !dbg !5221
  %arrayidx9.i88.i = getelementptr inbounds i8, i8* %290, i64 %idxprom8.i87.i, !dbg !5221
  %296 = load i32, i32* @Inst_Counter, !dbg !5221
  %297 = add i32 5, %296, !dbg !5221
  store i32 %297, i32* @Inst_Counter, !dbg !5221
  %298 = load i32, i32* @Inst_Counter, !dbg !5221
  call void @printCounter(i32 %298), !dbg !5221
  %299 = ptrtoint i8* %arrayidx9.i88.i to i64, !dbg !5221
  call void @printLoadAddr(i64 %299, i32 752, i32 99, i32 23), !dbg !5221
  %300 = load i8, i8* %arrayidx9.i88.i, align 1, !dbg !5221
  call void @printDDep(i32 746, i32 752), !dbg !5221
  call void @printDDep(i32 747, i32 752), !dbg !5221
  call void @printDDep(i32 742, i32 752), !dbg !5221
  %conv10.i89.i = zext i8 %300 to i32, !dbg !5225
  %shl11.i90.i = shl i32 %conv10.i89.i, 8, !dbg !5226
  %or12.i91.i = or i32 %or.i84.i, %shl11.i90.i, !dbg !5227
  %301 = load i32, i32* @Inst_Counter, !dbg !5228
  %302 = add i32 4, %301, !dbg !5228
  store i32 %302, i32* @Inst_Counter, !dbg !5228
  %303 = load i32, i32* @Inst_Counter, !dbg !5228
  call void @printCounter(i32 %303), !dbg !5228
  %304 = ptrtoint i8** %b.addr.i71.i to i64, !dbg !5228
  call void @printLoadAddr(i64 %304, i32 756, i32 100, i32 23), !dbg !5228
  %305 = load i8*, i8** %b.addr.i71.i, align 8, !dbg !5228
  call void @printDDep(i32 726, i32 756), !dbg !5228
  call void @printDDep(i32 726, i32 756), !dbg !5228
  call void @printDDep(i32 746, i32 756), !dbg !5228
  %306 = load i32, i32* @Inst_Counter, !dbg !5229
  %307 = add i32 1, %306, !dbg !5229
  store i32 %307, i32* @Inst_Counter, !dbg !5229
  %308 = load i32, i32* @Inst_Counter, !dbg !5229
  call void @printCounter(i32 %308), !dbg !5229
  %309 = ptrtoint i32* %n.addr.i72.i to i64, !dbg !5229
  call void @printLoadAddr(i64 %309, i32 757, i32 100, i32 29), !dbg !5229
  %310 = load i32, i32* %n.addr.i72.i, align 4, !dbg !5229
  call void @printDDep(i32 727, i32 757), !dbg !5229
  call void @printDDep(i32 727, i32 757), !dbg !5229
  call void @printDDep(i32 747, i32 757), !dbg !5229
  %mul13.i92.i = mul i32 4, %310, !dbg !5230
  %add14.i93.i = add i32 %mul13.i92.i, 3, !dbg !5231
  %idxprom15.i94.i = zext i32 %add14.i93.i to i64, !dbg !5228
  %arrayidx16.i95.i = getelementptr inbounds i8, i8* %305, i64 %idxprom15.i94.i, !dbg !5228
  %311 = load i32, i32* @Inst_Counter, !dbg !5228
  %312 = add i32 5, %311, !dbg !5228
  store i32 %312, i32* @Inst_Counter, !dbg !5228
  %313 = load i32, i32* @Inst_Counter, !dbg !5228
  call void @printCounter(i32 %313), !dbg !5228
  %314 = ptrtoint i8* %arrayidx16.i95.i to i64, !dbg !5228
  call void @printLoadAddr(i64 %314, i32 762, i32 100, i32 23), !dbg !5228
  %315 = load i8, i8* %arrayidx16.i95.i, align 1, !dbg !5228
  call void @printDDep(i32 756, i32 762), !dbg !5228
  call void @printDDep(i32 757, i32 762), !dbg !5228
  call void @printDDep(i32 752, i32 762), !dbg !5228
  %conv17.i96.i = zext i8 %315 to i32, !dbg !5232
  %or18.i97.i = or i32 %or12.i91.i, %conv17.i96.i, !dbg !5233
  %xor8.i = xor i32 %or18.i97.i, -1301273892, !dbg !5234
  %arrayidx9.i = getelementptr inbounds [4 x i32], [4 x i32]* %K.i, i64 0, i64 3, !dbg !5235
  %316 = load i32, i32* @Inst_Counter, !dbg !5236
  %317 = add i32 5, %316, !dbg !5236
  store i32 %317, i32* @Inst_Counter, !dbg !5236
  %318 = load i32, i32* @Inst_Counter, !dbg !5236
  call void @printCounter(i32 %318), !dbg !5236
  %319 = ptrtoint i32* %arrayidx9.i to i64, !dbg !5236
  call void @printStoreAddr(i64 %319, i32 767, i32 162, i32 10), !dbg !5236
  store i32 %xor8.i, i32* %arrayidx9.i, align 4, !dbg !5236
  call void @printDDep(i32 733, i32 767), !dbg !5236
  call void @printDDep(i32 742, i32 767), !dbg !5236
  call void @printDDep(i32 752, i32 767), !dbg !5236
  call void @printDDep(i32 762, i32 767), !dbg !5236
  call void @printDDep(i32 767, i32 767), !dbg !5236
  call void @printDDep(i32 727, i32 767), !dbg !5236
  %320 = load i32, i32* @Inst_Counter, !dbg !5237
  %321 = add i32 1, %320, !dbg !5237
  store i32 %321, i32* @Inst_Counter, !dbg !5237
  %322 = load i32, i32* @Inst_Counter, !dbg !5237
  call void @printCounter(i32 %322), !dbg !5237
  %323 = ptrtoint i32* %i.i to i64, !dbg !5237
  call void @printStoreAddr(i64 %323, i32 768, i32 164, i32 12), !dbg !5237
  store i32 0, i32* %i.i, align 4, !dbg !5237
  call void @printDDep(i32 768, i32 768), !dbg !5237
  call void @printDDep(i32 893, i32 768), !dbg !5237
  call void @printDDep(i32 767, i32 768), !dbg !5237
  %324 = load i32, i32* @Inst_Counter, !dbg !5238
  %325 = add i32 1, %324, !dbg !5238
  store i32 %325, i32* @Inst_Counter, !dbg !5238
  br label %for.cond.i, !dbg !5238

for.cond.i:                                       ; preds = %for.body.i, %entry
  %326 = load i32, i32* @Inst_Counter, !dbg !5239
  %327 = add i32 1, %326, !dbg !5239
  store i32 %327, i32* @Inst_Counter, !dbg !5239
  %328 = load i32, i32* @Inst_Counter, !dbg !5239
  call void @printCounter(i32 %328), !dbg !5239
  %329 = ptrtoint i32* %i.i to i64, !dbg !5239
  call void @printLoadAddr(i64 %329, i32 770, i32 164, i32 17), !dbg !5239
  %330 = load i32, i32* %i.i, align 4, !dbg !5239
  call void @printDDep(i32 768, i32 770), !dbg !5239
  call void @printDDep(i32 893, i32 770), !dbg !5239
  call void @printDDep(i32 768, i32 770), !dbg !5239
  call void @printDDep(i32 893, i32 770), !dbg !5239
  call void @printDDep(i32 770, i32 770), !dbg !5239
  %cmp.i = icmp ne i32 %330, 32, !dbg !5240
  %331 = load i32, i32* @Inst_Counter, !dbg !5241
  %332 = add i32 2, %331, !dbg !5241
  store i32 %332, i32* @Inst_Counter, !dbg !5241
  br i1 %cmp.i, label %for.body.i, label %SM4_set_key.exit, !dbg !5241

for.body.i:                                       ; preds = %for.cond.i
  %333 = load i32, i32* @Inst_Counter, !dbg !5242
  %334 = add i32 1, %333, !dbg !5242
  store i32 %334, i32* @Inst_Counter, !dbg !5242
  %335 = load i32, i32* @Inst_Counter, !dbg !5242
  call void @printCounter(i32 %335), !dbg !5242
  %336 = ptrtoint i32* %i.i to i64, !dbg !5242
  call void @printLoadAddr(i64 %336, i32 773, i32 165, i32 25), !dbg !5242
  %337 = load i32, i32* %i.i, align 4, !dbg !5242
  call void @printDDep(i32 768, i32 773), !dbg !5242
  call void @printDDep(i32 893, i32 773), !dbg !5242
  call void @printDDep(i32 768, i32 773), !dbg !5242
  call void @printDDep(i32 893, i32 773), !dbg !5242
  call void @printDDep(i32 773, i32 773), !dbg !5242
  %add.i = add nsw i32 %337, 1, !dbg !5243
  %rem.i = srem i32 %add.i, 4, !dbg !5244
  %idxprom.i = sext i32 %rem.i to i64, !dbg !5245
  %arrayidx10.i = getelementptr inbounds [4 x i32], [4 x i32]* %K.i, i64 0, i64 %idxprom.i, !dbg !5245
  %338 = load i32, i32* @Inst_Counter, !dbg !5245
  %339 = add i32 5, %338, !dbg !5245
  store i32 %339, i32* @Inst_Counter, !dbg !5245
  %340 = load i32, i32* @Inst_Counter, !dbg !5245
  call void @printCounter(i32 %340), !dbg !5245
  %341 = ptrtoint i32* %arrayidx10.i to i64, !dbg !5245
  call void @printLoadAddr(i64 %341, i32 778, i32 165, i32 22), !dbg !5245
  %342 = load i32, i32* %arrayidx10.i, align 4, !dbg !5245
  call void @printDDep(i32 773, i32 778), !dbg !5245
  call void @printDDep(i32 768, i32 778), !dbg !5245
  call void @printDDep(i32 893, i32 778), !dbg !5245
  call void @printDDep(i32 778, i32 778), !dbg !5245
  %343 = load i32, i32* @Inst_Counter, !dbg !5246
  %344 = add i32 1, %343, !dbg !5246
  store i32 %344, i32* @Inst_Counter, !dbg !5246
  %345 = load i32, i32* @Inst_Counter, !dbg !5246
  call void @printCounter(i32 %345), !dbg !5246
  %346 = ptrtoint i32* %i.i to i64, !dbg !5246
  call void @printLoadAddr(i64 %346, i32 779, i32 165, i32 42), !dbg !5246
  %347 = load i32, i32* %i.i, align 4, !dbg !5246
  call void @printDDep(i32 768, i32 779), !dbg !5246
  call void @printDDep(i32 893, i32 779), !dbg !5246
  call void @printDDep(i32 768, i32 779), !dbg !5246
  call void @printDDep(i32 893, i32 779), !dbg !5246
  call void @printDDep(i32 779, i32 779), !dbg !5246
  %add11.i = add nsw i32 %347, 2, !dbg !5247
  %rem12.i = srem i32 %add11.i, 4, !dbg !5248
  %idxprom13.i = sext i32 %rem12.i to i64, !dbg !5249
  %arrayidx14.i = getelementptr inbounds [4 x i32], [4 x i32]* %K.i, i64 0, i64 %idxprom13.i, !dbg !5249
  %348 = load i32, i32* @Inst_Counter, !dbg !5249
  %349 = add i32 5, %348, !dbg !5249
  store i32 %349, i32* @Inst_Counter, !dbg !5249
  %350 = load i32, i32* @Inst_Counter, !dbg !5249
  call void @printCounter(i32 %350), !dbg !5249
  %351 = ptrtoint i32* %arrayidx14.i to i64, !dbg !5249
  call void @printLoadAddr(i64 %351, i32 784, i32 165, i32 39), !dbg !5249
  %352 = load i32, i32* %arrayidx14.i, align 4, !dbg !5249
  call void @printDDep(i32 779, i32 784), !dbg !5249
  call void @printDDep(i32 768, i32 784), !dbg !5249
  call void @printDDep(i32 893, i32 784), !dbg !5249
  call void @printDDep(i32 784, i32 784), !dbg !5249
  %xor15.i = xor i32 %342, %352, !dbg !5250
  %353 = load i32, i32* @Inst_Counter, !dbg !5251
  %354 = add i32 2, %353, !dbg !5251
  store i32 %354, i32* @Inst_Counter, !dbg !5251
  %355 = load i32, i32* @Inst_Counter, !dbg !5251
  call void @printCounter(i32 %355), !dbg !5251
  %356 = ptrtoint i32* %i.i to i64, !dbg !5251
  call void @printLoadAddr(i64 %356, i32 786, i32 165, i32 59), !dbg !5251
  %357 = load i32, i32* %i.i, align 4, !dbg !5251
  call void @printDDep(i32 768, i32 786), !dbg !5251
  call void @printDDep(i32 893, i32 786), !dbg !5251
  call void @printDDep(i32 768, i32 786), !dbg !5251
  call void @printDDep(i32 893, i32 786), !dbg !5251
  call void @printDDep(i32 786, i32 786), !dbg !5251
  %add16.i = add nsw i32 %357, 3, !dbg !5252
  %rem17.i = srem i32 %add16.i, 4, !dbg !5253
  %idxprom18.i = sext i32 %rem17.i to i64, !dbg !5254
  %arrayidx19.i = getelementptr inbounds [4 x i32], [4 x i32]* %K.i, i64 0, i64 %idxprom18.i, !dbg !5254
  %358 = load i32, i32* @Inst_Counter, !dbg !5254
  %359 = add i32 5, %358, !dbg !5254
  store i32 %359, i32* @Inst_Counter, !dbg !5254
  %360 = load i32, i32* @Inst_Counter, !dbg !5254
  call void @printCounter(i32 %360), !dbg !5254
  %361 = ptrtoint i32* %arrayidx19.i to i64, !dbg !5254
  call void @printLoadAddr(i64 %361, i32 791, i32 165, i32 56), !dbg !5254
  %362 = load i32, i32* %arrayidx19.i, align 4, !dbg !5254
  call void @printDDep(i32 786, i32 791), !dbg !5254
  call void @printDDep(i32 768, i32 791), !dbg !5254
  call void @printDDep(i32 893, i32 791), !dbg !5254
  call void @printDDep(i32 791, i32 791), !dbg !5254
  %xor20.i = xor i32 %xor15.i, %362, !dbg !5255
  %363 = load i32, i32* @Inst_Counter, !dbg !5256
  %364 = add i32 2, %363, !dbg !5256
  store i32 %364, i32* @Inst_Counter, !dbg !5256
  %365 = load i32, i32* @Inst_Counter, !dbg !5256
  call void @printCounter(i32 %365), !dbg !5256
  %366 = ptrtoint i32* %i.i to i64, !dbg !5256
  call void @printLoadAddr(i64 %366, i32 793, i32 165, i32 76), !dbg !5256
  %367 = load i32, i32* %i.i, align 4, !dbg !5256
  call void @printDDep(i32 768, i32 793), !dbg !5256
  call void @printDDep(i32 893, i32 793), !dbg !5256
  call void @printDDep(i32 768, i32 793), !dbg !5256
  call void @printDDep(i32 893, i32 793), !dbg !5256
  call void @printDDep(i32 793, i32 793), !dbg !5256
  %idxprom21.i = sext i32 %367 to i64, !dbg !5257
  %arrayidx22.i = getelementptr inbounds [32 x i32], [32 x i32]* @SM4_set_key.CK, i64 0, i64 %idxprom21.i, !dbg !5257
  %368 = load i32, i32* @Inst_Counter, !dbg !5257
  %369 = add i32 3, %368, !dbg !5257
  store i32 %369, i32* @Inst_Counter, !dbg !5257
  %370 = load i32, i32* @Inst_Counter, !dbg !5257
  call void @printCounter(i32 %370), !dbg !5257
  %371 = ptrtoint i32* %arrayidx22.i to i64, !dbg !5257
  call void @printLoadAddr(i64 %371, i32 796, i32 165, i32 73), !dbg !5257
  %372 = load i32, i32* %arrayidx22.i, align 4, !dbg !5257
  call void @printDDep(i32 793, i32 796), !dbg !5257
  call void @printDDep(i32 796, i32 796), !dbg !5257
  %xor23.i = xor i32 %xor20.i, %372, !dbg !5258
  %373 = load i32, i32* @Inst_Counter, !dbg !5114
  %374 = add i32 2, %373, !dbg !5114
  store i32 %374, i32* @Inst_Counter, !dbg !5114
  %375 = load i32, i32* @Inst_Counter, !dbg !5114
  call void @printCounter(i32 %375), !dbg !5114
  %376 = ptrtoint i32* %X.i to i64, !dbg !5114
  call void @printStoreAddr(i64 %376, i32 798, i32 165, i32 18), !dbg !5114
  store i32 %xor23.i, i32* %X.i, align 4, !dbg !5114
  call void @printDDep(i32 778, i32 798), !dbg !5114
  call void @printDDep(i32 784, i32 798), !dbg !5114
  call void @printDDep(i32 791, i32 798), !dbg !5114
  call void @printDDep(i32 796, i32 798), !dbg !5114
  call void @printDDep(i32 798, i32 798), !dbg !5114
  call void @printDDep(i32 768, i32 798), !dbg !5114
  call void @printDDep(i32 893, i32 798), !dbg !5114
  call void @printDDep(i32 798, i32 798), !dbg !5114
  %377 = load i32, i32* @Inst_Counter, !dbg !5115
  %378 = add i32 1, %377, !dbg !5115
  store i32 %378, i32* @Inst_Counter, !dbg !5115
  %379 = load i32, i32* @Inst_Counter, !dbg !5115
  call void @printCounter(i32 %379), !dbg !5115
  %380 = ptrtoint i32* %t.i to i64, !dbg !5115
  call void @printStoreAddr(i64 %380, i32 799, i32 166, i32 18), !dbg !5115
  store i32 0, i32* %t.i, align 4, !dbg !5115
  call void @printDDep(i32 799, i32 799), !dbg !5115
  call void @printDDep(i32 810, i32 799), !dbg !5115
  call void @printDDep(i32 821, i32 799), !dbg !5115
  call void @printDDep(i32 832, i32 799), !dbg !5115
  call void @printDDep(i32 841, i32 799), !dbg !5115
  call void @printDDep(i32 871, i32 799), !dbg !5115
  call void @printDDep(i32 798, i32 799), !dbg !5115
  call void @printDDep(i32 799, i32 799), !dbg !5115
  %381 = load i32, i32* @Inst_Counter, !dbg !5259
  %382 = add i32 1, %381, !dbg !5259
  store i32 %382, i32* @Inst_Counter, !dbg !5259
  %383 = load i32, i32* @Inst_Counter, !dbg !5259
  call void @printCounter(i32 %383), !dbg !5259
  %384 = ptrtoint i32* %X.i to i64, !dbg !5259
  call void @printLoadAddr(i64 %384, i32 800, i32 168, i32 41), !dbg !5259
  %385 = load i32, i32* %X.i, align 4, !dbg !5259
  call void @printDDep(i32 798, i32 800), !dbg !5259
  call void @printDDep(i32 798, i32 800), !dbg !5259
  call void @printDDep(i32 800, i32 800), !dbg !5259
  %shr.i = lshr i32 %385, 24, !dbg !5260
  %conv.i = trunc i32 %shr.i to i8, !dbg !5261
  %idxprom24.i = zext i8 %conv.i to i64, !dbg !5262
  %arrayidx25.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom24.i, !dbg !5262
  %386 = load i32, i32* @Inst_Counter, !dbg !5262
  %387 = add i32 5, %386, !dbg !5262
  store i32 %387, i32* @Inst_Counter, !dbg !5262
  %388 = load i32, i32* @Inst_Counter, !dbg !5262
  call void @printCounter(i32 %388), !dbg !5262
  %389 = ptrtoint i8* %arrayidx25.i to i64, !dbg !5262
  call void @printLoadAddr(i64 %389, i32 805, i32 168, i32 25), !dbg !5262
  %390 = load i8, i8* %arrayidx25.i, align 1, !dbg !5262
  call void @printDDep(i32 800, i32 805), !dbg !5262
  call void @printDDep(i32 805, i32 805), !dbg !5262
  %conv26.i = zext i8 %390 to i32, !dbg !5263
  %shl.i = shl i32 %conv26.i, 24, !dbg !5264
  %391 = load i32, i32* @Inst_Counter, !dbg !5265
  %392 = add i32 3, %391, !dbg !5265
  store i32 %392, i32* @Inst_Counter, !dbg !5265
  %393 = load i32, i32* @Inst_Counter, !dbg !5265
  call void @printCounter(i32 %393), !dbg !5265
  %394 = ptrtoint i32* %t.i to i64, !dbg !5265
  call void @printLoadAddr(i64 %394, i32 808, i32 168, i32 11), !dbg !5265
  %395 = load i32, i32* %t.i, align 4, !dbg !5265
  call void @printDDep(i32 799, i32 808), !dbg !5265
  call void @printDDep(i32 810, i32 808), !dbg !5265
  call void @printDDep(i32 821, i32 808), !dbg !5265
  call void @printDDep(i32 832, i32 808), !dbg !5265
  call void @printDDep(i32 841, i32 808), !dbg !5265
  call void @printDDep(i32 871, i32 808), !dbg !5265
  call void @printDDep(i32 799, i32 808), !dbg !5265
  call void @printDDep(i32 808, i32 808), !dbg !5265
  %or.i = or i32 %395, %shl.i, !dbg !5265
  %396 = load i32, i32* @Inst_Counter, !dbg !5265
  %397 = add i32 2, %396, !dbg !5265
  store i32 %397, i32* @Inst_Counter, !dbg !5265
  %398 = load i32, i32* @Inst_Counter, !dbg !5265
  call void @printCounter(i32 %398), !dbg !5265
  %399 = ptrtoint i32* %t.i to i64, !dbg !5265
  call void @printStoreAddr(i64 %399, i32 810, i32 168, i32 11), !dbg !5265
  store i32 %or.i, i32* %t.i, align 4, !dbg !5265
  call void @printDDep(i32 799, i32 810), !dbg !5265
  call void @printDDep(i32 805, i32 810), !dbg !5265
  call void @printDDep(i32 808, i32 810), !dbg !5265
  call void @printDDep(i32 810, i32 810), !dbg !5265
  call void @printDDep(i32 821, i32 810), !dbg !5265
  call void @printDDep(i32 832, i32 810), !dbg !5265
  call void @printDDep(i32 841, i32 810), !dbg !5265
  call void @printDDep(i32 871, i32 810), !dbg !5265
  call void @printDDep(i32 799, i32 810), !dbg !5265
  call void @printDDep(i32 810, i32 810), !dbg !5265
  %400 = load i32, i32* @Inst_Counter, !dbg !5266
  %401 = add i32 1, %400, !dbg !5266
  store i32 %401, i32* @Inst_Counter, !dbg !5266
  %402 = load i32, i32* @Inst_Counter, !dbg !5266
  call void @printCounter(i32 %402), !dbg !5266
  %403 = ptrtoint i32* %X.i to i64, !dbg !5266
  call void @printLoadAddr(i64 %403, i32 811, i32 169, i32 41), !dbg !5266
  %404 = load i32, i32* %X.i, align 4, !dbg !5266
  call void @printDDep(i32 798, i32 811), !dbg !5266
  call void @printDDep(i32 798, i32 811), !dbg !5266
  call void @printDDep(i32 811, i32 811), !dbg !5266
  %shr27.i = lshr i32 %404, 16, !dbg !5267
  %conv28.i = trunc i32 %shr27.i to i8, !dbg !5268
  %idxprom29.i = zext i8 %conv28.i to i64, !dbg !5269
  %arrayidx30.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom29.i, !dbg !5269
  %405 = load i32, i32* @Inst_Counter, !dbg !5269
  %406 = add i32 5, %405, !dbg !5269
  store i32 %406, i32* @Inst_Counter, !dbg !5269
  %407 = load i32, i32* @Inst_Counter, !dbg !5269
  call void @printCounter(i32 %407), !dbg !5269
  %408 = ptrtoint i8* %arrayidx30.i to i64, !dbg !5269
  call void @printLoadAddr(i64 %408, i32 816, i32 169, i32 25), !dbg !5269
  %409 = load i8, i8* %arrayidx30.i, align 1, !dbg !5269
  call void @printDDep(i32 811, i32 816), !dbg !5269
  call void @printDDep(i32 816, i32 816), !dbg !5269
  %conv31.i = zext i8 %409 to i32, !dbg !5270
  %shl32.i = shl i32 %conv31.i, 16, !dbg !5271
  %410 = load i32, i32* @Inst_Counter, !dbg !5272
  %411 = add i32 3, %410, !dbg !5272
  store i32 %411, i32* @Inst_Counter, !dbg !5272
  %412 = load i32, i32* @Inst_Counter, !dbg !5272
  call void @printCounter(i32 %412), !dbg !5272
  %413 = ptrtoint i32* %t.i to i64, !dbg !5272
  call void @printLoadAddr(i64 %413, i32 819, i32 169, i32 11), !dbg !5272
  %414 = load i32, i32* %t.i, align 4, !dbg !5272
  call void @printDDep(i32 799, i32 819), !dbg !5272
  call void @printDDep(i32 810, i32 819), !dbg !5272
  call void @printDDep(i32 821, i32 819), !dbg !5272
  call void @printDDep(i32 832, i32 819), !dbg !5272
  call void @printDDep(i32 841, i32 819), !dbg !5272
  call void @printDDep(i32 871, i32 819), !dbg !5272
  call void @printDDep(i32 810, i32 819), !dbg !5272
  call void @printDDep(i32 819, i32 819), !dbg !5272
  %or33.i = or i32 %414, %shl32.i, !dbg !5272
  %415 = load i32, i32* @Inst_Counter, !dbg !5272
  %416 = add i32 2, %415, !dbg !5272
  store i32 %416, i32* @Inst_Counter, !dbg !5272
  %417 = load i32, i32* @Inst_Counter, !dbg !5272
  call void @printCounter(i32 %417), !dbg !5272
  %418 = ptrtoint i32* %t.i to i64, !dbg !5272
  call void @printStoreAddr(i64 %418, i32 821, i32 169, i32 11), !dbg !5272
  store i32 %or33.i, i32* %t.i, align 4, !dbg !5272
  call void @printDDep(i32 799, i32 821), !dbg !5272
  call void @printDDep(i32 810, i32 821), !dbg !5272
  call void @printDDep(i32 816, i32 821), !dbg !5272
  call void @printDDep(i32 819, i32 821), !dbg !5272
  call void @printDDep(i32 821, i32 821), !dbg !5272
  call void @printDDep(i32 832, i32 821), !dbg !5272
  call void @printDDep(i32 841, i32 821), !dbg !5272
  call void @printDDep(i32 871, i32 821), !dbg !5272
  call void @printDDep(i32 810, i32 821), !dbg !5272
  call void @printDDep(i32 821, i32 821), !dbg !5272
  %419 = load i32, i32* @Inst_Counter, !dbg !5273
  %420 = add i32 1, %419, !dbg !5273
  store i32 %420, i32* @Inst_Counter, !dbg !5273
  %421 = load i32, i32* @Inst_Counter, !dbg !5273
  call void @printCounter(i32 %421), !dbg !5273
  %422 = ptrtoint i32* %X.i to i64, !dbg !5273
  call void @printLoadAddr(i64 %422, i32 822, i32 170, i32 41), !dbg !5273
  %423 = load i32, i32* %X.i, align 4, !dbg !5273
  call void @printDDep(i32 798, i32 822), !dbg !5273
  call void @printDDep(i32 798, i32 822), !dbg !5273
  call void @printDDep(i32 822, i32 822), !dbg !5273
  %shr34.i = lshr i32 %423, 8, !dbg !5274
  %conv35.i = trunc i32 %shr34.i to i8, !dbg !5275
  %idxprom36.i = zext i8 %conv35.i to i64, !dbg !5276
  %arrayidx37.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom36.i, !dbg !5276
  %424 = load i32, i32* @Inst_Counter, !dbg !5276
  %425 = add i32 5, %424, !dbg !5276
  store i32 %425, i32* @Inst_Counter, !dbg !5276
  %426 = load i32, i32* @Inst_Counter, !dbg !5276
  call void @printCounter(i32 %426), !dbg !5276
  %427 = ptrtoint i8* %arrayidx37.i to i64, !dbg !5276
  call void @printLoadAddr(i64 %427, i32 827, i32 170, i32 25), !dbg !5276
  %428 = load i8, i8* %arrayidx37.i, align 1, !dbg !5276
  call void @printDDep(i32 822, i32 827), !dbg !5276
  call void @printDDep(i32 827, i32 827), !dbg !5276
  %conv38.i = zext i8 %428 to i32, !dbg !5277
  %shl39.i = shl i32 %conv38.i, 8, !dbg !5278
  %429 = load i32, i32* @Inst_Counter, !dbg !5279
  %430 = add i32 3, %429, !dbg !5279
  store i32 %430, i32* @Inst_Counter, !dbg !5279
  %431 = load i32, i32* @Inst_Counter, !dbg !5279
  call void @printCounter(i32 %431), !dbg !5279
  %432 = ptrtoint i32* %t.i to i64, !dbg !5279
  call void @printLoadAddr(i64 %432, i32 830, i32 170, i32 11), !dbg !5279
  %433 = load i32, i32* %t.i, align 4, !dbg !5279
  call void @printDDep(i32 799, i32 830), !dbg !5279
  call void @printDDep(i32 810, i32 830), !dbg !5279
  call void @printDDep(i32 821, i32 830), !dbg !5279
  call void @printDDep(i32 832, i32 830), !dbg !5279
  call void @printDDep(i32 841, i32 830), !dbg !5279
  call void @printDDep(i32 871, i32 830), !dbg !5279
  call void @printDDep(i32 821, i32 830), !dbg !5279
  call void @printDDep(i32 830, i32 830), !dbg !5279
  %or40.i = or i32 %433, %shl39.i, !dbg !5279
  %434 = load i32, i32* @Inst_Counter, !dbg !5279
  %435 = add i32 2, %434, !dbg !5279
  store i32 %435, i32* @Inst_Counter, !dbg !5279
  %436 = load i32, i32* @Inst_Counter, !dbg !5279
  call void @printCounter(i32 %436), !dbg !5279
  %437 = ptrtoint i32* %t.i to i64, !dbg !5279
  call void @printStoreAddr(i64 %437, i32 832, i32 170, i32 11), !dbg !5279
  store i32 %or40.i, i32* %t.i, align 4, !dbg !5279
  call void @printDDep(i32 799, i32 832), !dbg !5279
  call void @printDDep(i32 810, i32 832), !dbg !5279
  call void @printDDep(i32 821, i32 832), !dbg !5279
  call void @printDDep(i32 827, i32 832), !dbg !5279
  call void @printDDep(i32 830, i32 832), !dbg !5279
  call void @printDDep(i32 832, i32 832), !dbg !5279
  call void @printDDep(i32 841, i32 832), !dbg !5279
  call void @printDDep(i32 871, i32 832), !dbg !5279
  call void @printDDep(i32 821, i32 832), !dbg !5279
  call void @printDDep(i32 832, i32 832), !dbg !5279
  %438 = load i32, i32* @Inst_Counter, !dbg !5280
  %439 = add i32 1, %438, !dbg !5280
  store i32 %439, i32* @Inst_Counter, !dbg !5280
  %440 = load i32, i32* @Inst_Counter, !dbg !5280
  call void @printCounter(i32 %440), !dbg !5280
  %441 = ptrtoint i32* %X.i to i64, !dbg !5280
  call void @printLoadAddr(i64 %441, i32 833, i32 171, i32 29), !dbg !5280
  %442 = load i32, i32* %X.i, align 4, !dbg !5280
  call void @printDDep(i32 798, i32 833), !dbg !5280
  call void @printDDep(i32 798, i32 833), !dbg !5280
  call void @printDDep(i32 833, i32 833), !dbg !5280
  %conv41.i = trunc i32 %442 to i8, !dbg !5281
  %idxprom42.i = zext i8 %conv41.i to i64, !dbg !5282
  %arrayidx43.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom42.i, !dbg !5282
  %443 = load i32, i32* @Inst_Counter, !dbg !5282
  %444 = add i32 4, %443, !dbg !5282
  store i32 %444, i32* @Inst_Counter, !dbg !5282
  %445 = load i32, i32* @Inst_Counter, !dbg !5282
  call void @printCounter(i32 %445), !dbg !5282
  %446 = ptrtoint i8* %arrayidx43.i to i64, !dbg !5282
  call void @printLoadAddr(i64 %446, i32 837, i32 171, i32 14), !dbg !5282
  %447 = load i8, i8* %arrayidx43.i, align 1, !dbg !5282
  call void @printDDep(i32 833, i32 837), !dbg !5282
  call void @printDDep(i32 837, i32 837), !dbg !5282
  %conv44.i = zext i8 %447 to i32, !dbg !5282
  %448 = load i32, i32* @Inst_Counter, !dbg !5283
  %449 = add i32 2, %448, !dbg !5283
  store i32 %449, i32* @Inst_Counter, !dbg !5283
  %450 = load i32, i32* @Inst_Counter, !dbg !5283
  call void @printCounter(i32 %450), !dbg !5283
  %451 = ptrtoint i32* %t.i to i64, !dbg !5283
  call void @printLoadAddr(i64 %451, i32 839, i32 171, i32 11), !dbg !5283
  %452 = load i32, i32* %t.i, align 4, !dbg !5283
  call void @printDDep(i32 799, i32 839), !dbg !5283
  call void @printDDep(i32 810, i32 839), !dbg !5283
  call void @printDDep(i32 821, i32 839), !dbg !5283
  call void @printDDep(i32 832, i32 839), !dbg !5283
  call void @printDDep(i32 841, i32 839), !dbg !5283
  call void @printDDep(i32 871, i32 839), !dbg !5283
  call void @printDDep(i32 832, i32 839), !dbg !5283
  call void @printDDep(i32 839, i32 839), !dbg !5283
  %or45.i = or i32 %452, %conv44.i, !dbg !5283
  %453 = load i32, i32* @Inst_Counter, !dbg !5283
  %454 = add i32 2, %453, !dbg !5283
  store i32 %454, i32* @Inst_Counter, !dbg !5283
  %455 = load i32, i32* @Inst_Counter, !dbg !5283
  call void @printCounter(i32 %455), !dbg !5283
  %456 = ptrtoint i32* %t.i to i64, !dbg !5283
  call void @printStoreAddr(i64 %456, i32 841, i32 171, i32 11), !dbg !5283
  store i32 %or45.i, i32* %t.i, align 4, !dbg !5283
  call void @printDDep(i32 799, i32 841), !dbg !5283
  call void @printDDep(i32 810, i32 841), !dbg !5283
  call void @printDDep(i32 821, i32 841), !dbg !5283
  call void @printDDep(i32 832, i32 841), !dbg !5283
  call void @printDDep(i32 837, i32 841), !dbg !5283
  call void @printDDep(i32 839, i32 841), !dbg !5283
  call void @printDDep(i32 841, i32 841), !dbg !5283
  call void @printDDep(i32 871, i32 841), !dbg !5283
  call void @printDDep(i32 832, i32 841), !dbg !5283
  call void @printDDep(i32 841, i32 841), !dbg !5283
  %457 = load i32, i32* @Inst_Counter, !dbg !5284
  %458 = add i32 1, %457, !dbg !5284
  store i32 %458, i32* @Inst_Counter, !dbg !5284
  %459 = load i32, i32* @Inst_Counter, !dbg !5284
  call void @printCounter(i32 %459), !dbg !5284
  %460 = ptrtoint i32* %t.i to i64, !dbg !5284
  call void @printLoadAddr(i64 %460, i32 842, i32 173, i32 13), !dbg !5284
  %461 = load i32, i32* %t.i, align 4, !dbg !5284
  call void @printDDep(i32 799, i32 842), !dbg !5284
  call void @printDDep(i32 810, i32 842), !dbg !5284
  call void @printDDep(i32 821, i32 842), !dbg !5284
  call void @printDDep(i32 832, i32 842), !dbg !5284
  call void @printDDep(i32 841, i32 842), !dbg !5284
  call void @printDDep(i32 871, i32 842), !dbg !5284
  call void @printDDep(i32 841, i32 842), !dbg !5284
  call void @printDDep(i32 842, i32 842), !dbg !5284
  %462 = load i32, i32* @Inst_Counter, !dbg !5285
  %463 = add i32 1, %462, !dbg !5285
  store i32 %463, i32* @Inst_Counter, !dbg !5285
  %464 = load i32, i32* @Inst_Counter, !dbg !5285
  call void @printCounter(i32 %464), !dbg !5285
  %465 = ptrtoint i32* %t.i to i64, !dbg !5285
  call void @printLoadAddr(i64 %465, i32 843, i32 173, i32 22), !dbg !5285
  %466 = load i32, i32* %t.i, align 4, !dbg !5285
  call void @printDDep(i32 799, i32 843), !dbg !5285
  call void @printDDep(i32 810, i32 843), !dbg !5285
  call void @printDDep(i32 821, i32 843), !dbg !5285
  call void @printDDep(i32 832, i32 843), !dbg !5285
  call void @printDDep(i32 841, i32 843), !dbg !5285
  call void @printDDep(i32 871, i32 843), !dbg !5285
  call void @printDDep(i32 841, i32 843), !dbg !5285
  call void @printDDep(i32 843, i32 843), !dbg !5285
  %467 = load i32, i32* @Inst_Counter
  %468 = add i32 1, %467
  store i32 %468, i32* @Inst_Counter
  %469 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %469)
  %470 = ptrtoint i32* %a.addr.i63.i to i64
  call void @printStoreAddr(i64 %470, i32 844, i32 0, i32 0)
  store i32 %466, i32* %a.addr.i63.i, align 4
  call void @printDDep(i32 843, i32 844)
  call void @printDDep(i32 844, i32 844)
  call void @printDDep(i32 841, i32 844)
  call void @printDDep(i32 844, i32 844)
  %471 = load i32, i32* @Inst_Counter
  %472 = add i32 1, %471
  store i32 %472, i32* @Inst_Counter
  %473 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %473)
  %474 = ptrtoint i8* %n.addr.i64.i to i64
  call void @printStoreAddr(i64 %474, i32 845, i32 0, i32 0)
  store i8 13, i8* %n.addr.i64.i, align 1
  call void @printDDep(i32 845, i32 845)
  call void @printDDep(i32 844, i32 845)
  call void @printDDep(i32 845, i32 845)
  %475 = load i32, i32* @Inst_Counter, !dbg !5286
  %476 = add i32 1, %475, !dbg !5286
  store i32 %476, i32* @Inst_Counter, !dbg !5286
  %477 = load i32, i32* @Inst_Counter, !dbg !5286
  call void @printCounter(i32 %477), !dbg !5286
  %478 = ptrtoint i32* %a.addr.i63.i to i64, !dbg !5286
  call void @printLoadAddr(i64 %478, i32 846, i32 92, i32 13), !dbg !5286
  %479 = load i32, i32* %a.addr.i63.i, align 4, !dbg !5286
  call void @printDDep(i32 844, i32 846), !dbg !5286
  call void @printDDep(i32 844, i32 846), !dbg !5286
  call void @printDDep(i32 846, i32 846), !dbg !5286
  %480 = load i32, i32* @Inst_Counter, !dbg !5287
  %481 = add i32 1, %480, !dbg !5287
  store i32 %481, i32* @Inst_Counter, !dbg !5287
  %482 = load i32, i32* @Inst_Counter, !dbg !5287
  call void @printCounter(i32 %482), !dbg !5287
  %483 = ptrtoint i8* %n.addr.i64.i to i64, !dbg !5287
  call void @printLoadAddr(i64 %483, i32 847, i32 92, i32 18), !dbg !5287
  %484 = load i8, i8* %n.addr.i64.i, align 1, !dbg !5287
  call void @printDDep(i32 845, i32 847), !dbg !5287
  call void @printDDep(i32 845, i32 847), !dbg !5287
  call void @printDDep(i32 847, i32 847), !dbg !5287
  %conv.i65.i = zext i8 %484 to i32, !dbg !5287
  %shl.i66.i = shl i32 %479, %conv.i65.i, !dbg !5288
  %485 = load i32, i32* @Inst_Counter, !dbg !5289
  %486 = add i32 3, %485, !dbg !5289
  store i32 %486, i32* @Inst_Counter, !dbg !5289
  %487 = load i32, i32* @Inst_Counter, !dbg !5289
  call void @printCounter(i32 %487), !dbg !5289
  %488 = ptrtoint i32* %a.addr.i63.i to i64, !dbg !5289
  call void @printLoadAddr(i64 %488, i32 850, i32 92, i32 24), !dbg !5289
  %489 = load i32, i32* %a.addr.i63.i, align 4, !dbg !5289
  call void @printDDep(i32 844, i32 850), !dbg !5289
  call void @printDDep(i32 844, i32 850), !dbg !5289
  call void @printDDep(i32 850, i32 850), !dbg !5289
  %490 = load i32, i32* @Inst_Counter, !dbg !5290
  %491 = add i32 1, %490, !dbg !5290
  store i32 %491, i32* @Inst_Counter, !dbg !5290
  %492 = load i32, i32* @Inst_Counter, !dbg !5290
  call void @printCounter(i32 %492), !dbg !5290
  %493 = ptrtoint i8* %n.addr.i64.i to i64, !dbg !5290
  call void @printLoadAddr(i64 %493, i32 851, i32 92, i32 35), !dbg !5290
  %494 = load i8, i8* %n.addr.i64.i, align 1, !dbg !5290
  call void @printDDep(i32 845, i32 851), !dbg !5290
  call void @printDDep(i32 845, i32 851), !dbg !5290
  call void @printDDep(i32 851, i32 851), !dbg !5290
  %conv1.i67.i = zext i8 %494 to i32, !dbg !5290
  %sub.i68.i = sub nsw i32 32, %conv1.i67.i, !dbg !5291
  %shr.i69.i = lshr i32 %489, %sub.i68.i, !dbg !5292
  %or.i70.i = or i32 %shl.i66.i, %shr.i69.i, !dbg !5293
  %xor47.i = xor i32 %461, %or.i70.i, !dbg !5294
  %495 = load i32, i32* @Inst_Counter, !dbg !5295
  %496 = add i32 6, %495, !dbg !5295
  store i32 %496, i32* @Inst_Counter, !dbg !5295
  %497 = load i32, i32* @Inst_Counter, !dbg !5295
  call void @printCounter(i32 %497), !dbg !5295
  %498 = ptrtoint i32* %t.i to i64, !dbg !5295
  call void @printLoadAddr(i64 %498, i32 857, i32 173, i32 36), !dbg !5295
  %499 = load i32, i32* %t.i, align 4, !dbg !5295
  call void @printDDep(i32 799, i32 857), !dbg !5295
  call void @printDDep(i32 810, i32 857), !dbg !5295
  call void @printDDep(i32 821, i32 857), !dbg !5295
  call void @printDDep(i32 832, i32 857), !dbg !5295
  call void @printDDep(i32 841, i32 857), !dbg !5295
  call void @printDDep(i32 871, i32 857), !dbg !5295
  call void @printDDep(i32 841, i32 857), !dbg !5295
  call void @printDDep(i32 857, i32 857), !dbg !5295
  %500 = load i32, i32* @Inst_Counter
  %501 = add i32 1, %500
  store i32 %501, i32* @Inst_Counter
  %502 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %502)
  %503 = ptrtoint i32* %a.addr.i.i to i64
  call void @printStoreAddr(i64 %503, i32 858, i32 0, i32 0)
  store i32 %499, i32* %a.addr.i.i, align 4
  call void @printDDep(i32 857, i32 858)
  call void @printDDep(i32 858, i32 858)
  call void @printDDep(i32 845, i32 858)
  call void @printDDep(i32 858, i32 858)
  %504 = load i32, i32* @Inst_Counter
  %505 = add i32 1, %504
  store i32 %505, i32* @Inst_Counter
  %506 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %506)
  %507 = ptrtoint i8* %n.addr.i59.i to i64
  call void @printStoreAddr(i64 %507, i32 859, i32 0, i32 0)
  store i8 23, i8* %n.addr.i59.i, align 1
  call void @printDDep(i32 859, i32 859)
  call void @printDDep(i32 858, i32 859)
  call void @printDDep(i32 859, i32 859)
  %508 = load i32, i32* @Inst_Counter, !dbg !5296
  %509 = add i32 1, %508, !dbg !5296
  store i32 %509, i32* @Inst_Counter, !dbg !5296
  %510 = load i32, i32* @Inst_Counter, !dbg !5296
  call void @printCounter(i32 %510), !dbg !5296
  %511 = ptrtoint i32* %a.addr.i.i to i64, !dbg !5296
  call void @printLoadAddr(i64 %511, i32 860, i32 92, i32 13), !dbg !5296
  %512 = load i32, i32* %a.addr.i.i, align 4, !dbg !5296
  call void @printDDep(i32 858, i32 860), !dbg !5296
  call void @printDDep(i32 858, i32 860), !dbg !5296
  call void @printDDep(i32 860, i32 860), !dbg !5296
  %513 = load i32, i32* @Inst_Counter, !dbg !5297
  %514 = add i32 1, %513, !dbg !5297
  store i32 %514, i32* @Inst_Counter, !dbg !5297
  %515 = load i32, i32* @Inst_Counter, !dbg !5297
  call void @printCounter(i32 %515), !dbg !5297
  %516 = ptrtoint i8* %n.addr.i59.i to i64, !dbg !5297
  call void @printLoadAddr(i64 %516, i32 861, i32 92, i32 18), !dbg !5297
  %517 = load i8, i8* %n.addr.i59.i, align 1, !dbg !5297
  call void @printDDep(i32 859, i32 861), !dbg !5297
  call void @printDDep(i32 859, i32 861), !dbg !5297
  call void @printDDep(i32 861, i32 861), !dbg !5297
  %conv.i60.i = zext i8 %517 to i32, !dbg !5297
  %shl.i61.i = shl i32 %512, %conv.i60.i, !dbg !5298
  %518 = load i32, i32* @Inst_Counter, !dbg !5299
  %519 = add i32 3, %518, !dbg !5299
  store i32 %519, i32* @Inst_Counter, !dbg !5299
  %520 = load i32, i32* @Inst_Counter, !dbg !5299
  call void @printCounter(i32 %520), !dbg !5299
  %521 = ptrtoint i32* %a.addr.i.i to i64, !dbg !5299
  call void @printLoadAddr(i64 %521, i32 864, i32 92, i32 24), !dbg !5299
  %522 = load i32, i32* %a.addr.i.i, align 4, !dbg !5299
  call void @printDDep(i32 858, i32 864), !dbg !5299
  call void @printDDep(i32 858, i32 864), !dbg !5299
  call void @printDDep(i32 864, i32 864), !dbg !5299
  %523 = load i32, i32* @Inst_Counter, !dbg !5300
  %524 = add i32 1, %523, !dbg !5300
  store i32 %524, i32* @Inst_Counter, !dbg !5300
  %525 = load i32, i32* @Inst_Counter, !dbg !5300
  call void @printCounter(i32 %525), !dbg !5300
  %526 = ptrtoint i8* %n.addr.i59.i to i64, !dbg !5300
  call void @printLoadAddr(i64 %526, i32 865, i32 92, i32 35), !dbg !5300
  %527 = load i8, i8* %n.addr.i59.i, align 1, !dbg !5300
  call void @printDDep(i32 859, i32 865), !dbg !5300
  call void @printDDep(i32 859, i32 865), !dbg !5300
  call void @printDDep(i32 865, i32 865), !dbg !5300
  %conv1.i.i = zext i8 %527 to i32, !dbg !5300
  %sub.i.i = sub nsw i32 32, %conv1.i.i, !dbg !5301
  %shr.i.i = lshr i32 %522, %sub.i.i, !dbg !5302
  %or.i62.i = or i32 %shl.i61.i, %shr.i.i, !dbg !5303
  %xor49.i = xor i32 %xor47.i, %or.i62.i, !dbg !5304
  %528 = load i32, i32* @Inst_Counter, !dbg !5305
  %529 = add i32 6, %528, !dbg !5305
  store i32 %529, i32* @Inst_Counter, !dbg !5305
  %530 = load i32, i32* @Inst_Counter, !dbg !5305
  call void @printCounter(i32 %530), !dbg !5305
  %531 = ptrtoint i32* %t.i to i64, !dbg !5305
  call void @printStoreAddr(i64 %531, i32 871, i32 173, i32 11), !dbg !5305
  store i32 %xor49.i, i32* %t.i, align 4, !dbg !5305
  call void @printDDep(i32 799, i32 871), !dbg !5305
  call void @printDDep(i32 810, i32 871), !dbg !5305
  call void @printDDep(i32 821, i32 871), !dbg !5305
  call void @printDDep(i32 832, i32 871), !dbg !5305
  call void @printDDep(i32 841, i32 871), !dbg !5305
  call void @printDDep(i32 842, i32 871), !dbg !5305
  call void @printDDep(i32 846, i32 871), !dbg !5305
  call void @printDDep(i32 847, i32 871), !dbg !5305
  call void @printDDep(i32 850, i32 871), !dbg !5305
  call void @printDDep(i32 851, i32 871), !dbg !5305
  call void @printDDep(i32 860, i32 871), !dbg !5305
  call void @printDDep(i32 861, i32 871), !dbg !5305
  call void @printDDep(i32 864, i32 871), !dbg !5305
  call void @printDDep(i32 865, i32 871), !dbg !5305
  call void @printDDep(i32 871, i32 871), !dbg !5305
  call void @printDDep(i32 859, i32 871), !dbg !5305
  call void @printDDep(i32 871, i32 871), !dbg !5305
  %532 = load i32, i32* @Inst_Counter, !dbg !5306
  %533 = add i32 1, %532, !dbg !5306
  store i32 %533, i32* @Inst_Counter, !dbg !5306
  %534 = load i32, i32* @Inst_Counter, !dbg !5306
  call void @printCounter(i32 %534), !dbg !5306
  %535 = ptrtoint i32* %t.i to i64, !dbg !5306
  call void @printLoadAddr(i64 %535, i32 872, i32 174, i32 21), !dbg !5306
  %536 = load i32, i32* %t.i, align 4, !dbg !5306
  call void @printDDep(i32 799, i32 872), !dbg !5306
  call void @printDDep(i32 810, i32 872), !dbg !5306
  call void @printDDep(i32 821, i32 872), !dbg !5306
  call void @printDDep(i32 832, i32 872), !dbg !5306
  call void @printDDep(i32 841, i32 872), !dbg !5306
  call void @printDDep(i32 871, i32 872), !dbg !5306
  call void @printDDep(i32 871, i32 872), !dbg !5306
  call void @printDDep(i32 872, i32 872), !dbg !5306
  %537 = load i32, i32* @Inst_Counter, !dbg !5307
  %538 = add i32 1, %537, !dbg !5307
  store i32 %538, i32* @Inst_Counter, !dbg !5307
  %539 = load i32, i32* @Inst_Counter, !dbg !5307
  call void @printCounter(i32 %539), !dbg !5307
  %540 = ptrtoint i32* %i.i to i64, !dbg !5307
  call void @printLoadAddr(i64 %540, i32 873, i32 174, i32 11), !dbg !5307
  %541 = load i32, i32* %i.i, align 4, !dbg !5307
  call void @printDDep(i32 768, i32 873), !dbg !5307
  call void @printDDep(i32 893, i32 873), !dbg !5307
  call void @printDDep(i32 768, i32 873), !dbg !5307
  call void @printDDep(i32 893, i32 873), !dbg !5307
  call void @printDDep(i32 873, i32 873), !dbg !5307
  %rem50.i = srem i32 %541, 4, !dbg !5308
  %idxprom51.i = sext i32 %rem50.i to i64, !dbg !5309
  %arrayidx52.i = getelementptr inbounds [4 x i32], [4 x i32]* %K.i, i64 0, i64 %idxprom51.i, !dbg !5309
  %542 = load i32, i32* @Inst_Counter, !dbg !5310
  %543 = add i32 4, %542, !dbg !5310
  store i32 %543, i32* @Inst_Counter, !dbg !5310
  %544 = load i32, i32* @Inst_Counter, !dbg !5310
  call void @printCounter(i32 %544), !dbg !5310
  %545 = ptrtoint i32* %arrayidx52.i to i64, !dbg !5310
  call void @printLoadAddr(i64 %545, i32 877, i32 174, i32 18), !dbg !5310
  %546 = load i32, i32* %arrayidx52.i, align 4, !dbg !5310
  call void @printDDep(i32 873, i32 877), !dbg !5310
  call void @printDDep(i32 879, i32 877), !dbg !5310
  call void @printDDep(i32 768, i32 877), !dbg !5310
  call void @printDDep(i32 893, i32 877), !dbg !5310
  call void @printDDep(i32 877, i32 877), !dbg !5310
  %xor53.i = xor i32 %546, %536, !dbg !5310
  %547 = load i32, i32* @Inst_Counter, !dbg !5310
  %548 = add i32 2, %547, !dbg !5310
  store i32 %548, i32* @Inst_Counter, !dbg !5310
  %549 = load i32, i32* @Inst_Counter, !dbg !5310
  call void @printCounter(i32 %549), !dbg !5310
  %550 = ptrtoint i32* %arrayidx52.i to i64, !dbg !5310
  call void @printStoreAddr(i64 %550, i32 879, i32 174, i32 18), !dbg !5310
  store i32 %xor53.i, i32* %arrayidx52.i, align 4, !dbg !5310
  call void @printDDep(i32 872, i32 879), !dbg !5310
  call void @printDDep(i32 873, i32 879), !dbg !5310
  call void @printDDep(i32 877, i32 879), !dbg !5310
  call void @printDDep(i32 879, i32 879), !dbg !5310
  call void @printDDep(i32 871, i32 879), !dbg !5310
  call void @printDDep(i32 879, i32 879), !dbg !5310
  %551 = load i32, i32* @Inst_Counter, !dbg !5311
  %552 = add i32 1, %551, !dbg !5311
  store i32 %552, i32* @Inst_Counter, !dbg !5311
  %553 = load i32, i32* @Inst_Counter, !dbg !5311
  call void @printCounter(i32 %553), !dbg !5311
  %554 = ptrtoint i32* %i.i to i64, !dbg !5311
  call void @printLoadAddr(i64 %554, i32 880, i32 175, i32 23), !dbg !5311
  %555 = load i32, i32* %i.i, align 4, !dbg !5311
  call void @printDDep(i32 768, i32 880), !dbg !5311
  call void @printDDep(i32 893, i32 880), !dbg !5311
  call void @printDDep(i32 768, i32 880), !dbg !5311
  call void @printDDep(i32 893, i32 880), !dbg !5311
  call void @printDDep(i32 880, i32 880), !dbg !5311
  %rem54.i = srem i32 %555, 4, !dbg !5312
  %idxprom55.i = sext i32 %rem54.i to i64, !dbg !5313
  %arrayidx56.i = getelementptr inbounds [4 x i32], [4 x i32]* %K.i, i64 0, i64 %idxprom55.i, !dbg !5313
  %556 = load i32, i32* @Inst_Counter, !dbg !5313
  %557 = add i32 4, %556, !dbg !5313
  store i32 %557, i32* @Inst_Counter, !dbg !5313
  %558 = load i32, i32* @Inst_Counter, !dbg !5313
  call void @printCounter(i32 %558), !dbg !5313
  %559 = ptrtoint i32* %arrayidx56.i to i64, !dbg !5313
  call void @printLoadAddr(i64 %559, i32 884, i32 175, i32 21), !dbg !5313
  %560 = load i32, i32* %arrayidx56.i, align 4, !dbg !5313
  call void @printDDep(i32 880, i32 884), !dbg !5313
  call void @printDDep(i32 879, i32 884), !dbg !5313
  call void @printDDep(i32 884, i32 884), !dbg !5313
  %561 = load i32, i32* @Inst_Counter, !dbg !5314
  %562 = add i32 1, %561, !dbg !5314
  store i32 %562, i32* @Inst_Counter, !dbg !5314
  %563 = load i32, i32* @Inst_Counter, !dbg !5314
  call void @printCounter(i32 %563), !dbg !5314
  %564 = ptrtoint %struct.SM4_KEY_st** %ks.addr.i to i64, !dbg !5314
  call void @printLoadAddr(i64 %564, i32 885, i32 175, i32 9), !dbg !5314
  %565 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr.i, align 8, !dbg !5314
  call void @printDDep(i32 595, i32 885), !dbg !5314
  call void @printDDep(i32 595, i32 885), !dbg !5314
  call void @printDDep(i32 885, i32 885), !dbg !5314
  %rk.i = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %565, i32 0, i32 0, !dbg !5315
  %566 = load i32, i32* @Inst_Counter, !dbg !5316
  %567 = add i32 2, %566, !dbg !5316
  store i32 %567, i32* @Inst_Counter, !dbg !5316
  %568 = load i32, i32* @Inst_Counter, !dbg !5316
  call void @printCounter(i32 %568), !dbg !5316
  %569 = ptrtoint i32* %i.i to i64, !dbg !5316
  call void @printLoadAddr(i64 %569, i32 887, i32 175, i32 16), !dbg !5316
  %570 = load i32, i32* %i.i, align 4, !dbg !5316
  call void @printDDep(i32 768, i32 887), !dbg !5316
  call void @printDDep(i32 893, i32 887), !dbg !5316
  call void @printDDep(i32 768, i32 887), !dbg !5316
  call void @printDDep(i32 893, i32 887), !dbg !5316
  call void @printDDep(i32 887, i32 887), !dbg !5316
  %idxprom57.i = sext i32 %570 to i64, !dbg !5314
  %arrayidx58.i = getelementptr inbounds [32 x i32], [32 x i32]* %rk.i, i64 0, i64 %idxprom57.i, !dbg !5314
  %571 = load i32, i32* @Inst_Counter, !dbg !5317
  %572 = add i32 3, %571, !dbg !5317
  store i32 %572, i32* @Inst_Counter, !dbg !5317
  %573 = load i32, i32* @Inst_Counter, !dbg !5317
  call void @printCounter(i32 %573), !dbg !5317
  %574 = ptrtoint i32* %arrayidx58.i to i64, !dbg !5317
  call void @printStoreAddr(i64 %574, i32 890, i32 175, i32 19), !dbg !5317
  store i32 %560, i32* %arrayidx58.i, align 4, !dbg !5317
  call void @printDDep(i32 884, i32 890), !dbg !5317
  call void @printDDep(i32 885, i32 890), !dbg !5317
  call void @printDDep(i32 887, i32 890), !dbg !5317
  call void @printDDep(i32 890, i32 890), !dbg !5317
  call void @printDDep(i32 879, i32 890), !dbg !5317
  call void @printDDep(i32 890, i32 890), !dbg !5317
  %575 = load i32, i32* @Inst_Counter, !dbg !5318
  %576 = add i32 1, %575, !dbg !5318
  store i32 %576, i32* @Inst_Counter, !dbg !5318
  %577 = load i32, i32* @Inst_Counter, !dbg !5318
  call void @printCounter(i32 %577), !dbg !5318
  %578 = ptrtoint i32* %i.i to i64, !dbg !5318
  call void @printLoadAddr(i64 %578, i32 891, i32 164, i32 40), !dbg !5318
  %579 = load i32, i32* %i.i, align 4, !dbg !5318
  call void @printDDep(i32 768, i32 891), !dbg !5318
  call void @printDDep(i32 893, i32 891), !dbg !5318
  call void @printDDep(i32 768, i32 891), !dbg !5318
  call void @printDDep(i32 893, i32 891), !dbg !5318
  call void @printDDep(i32 891, i32 891), !dbg !5318
  %inc.i = add nsw i32 %579, 1, !dbg !5318
  %580 = load i32, i32* @Inst_Counter, !dbg !5318
  %581 = add i32 2, %580, !dbg !5318
  store i32 %581, i32* @Inst_Counter, !dbg !5318
  %582 = load i32, i32* @Inst_Counter, !dbg !5318
  call void @printCounter(i32 %582), !dbg !5318
  %583 = ptrtoint i32* %i.i to i64, !dbg !5318
  call void @printStoreAddr(i64 %583, i32 893, i32 164, i32 40), !dbg !5318
  store i32 %inc.i, i32* %i.i, align 4, !dbg !5318
  call void @printDDep(i32 768, i32 893), !dbg !5318
  call void @printDDep(i32 891, i32 893), !dbg !5318
  call void @printDDep(i32 893, i32 893), !dbg !5318
  call void @printDDep(i32 890, i32 893), !dbg !5318
  call void @printDDep(i32 893, i32 893), !dbg !5318
  %584 = load i32, i32* @Inst_Counter, !dbg !5319
  %585 = add i32 1, %584, !dbg !5319
  store i32 %585, i32* @Inst_Counter, !dbg !5319
  br label %for.cond.i, !dbg !5319, !llvm.loop !5320

SM4_set_key.exit:                                 ; preds = %for.cond.i
  call void @llvm.dbg.declare(metadata [94 x i8]* %charset, metadata !5322, metadata !DIExpression()), !dbg !5328
  %586 = bitcast [94 x i8]* %charset to i8*, !dbg !5328
  call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 16 %586, i8* align 16 getelementptr inbounds ([94 x i8], [94 x i8]* @__const.main.charset, i32 0, i32 0), i64 94, i1 false), !dbg !5328
  call void @printDDep(i32 768, i32 897), !dbg !5328
  call void @printDDep(i32 893, i32 897), !dbg !5328
  call void @printDDep(i32 897, i32 897), !dbg !5328
  call void @llvm.dbg.declare(metadata i64* %length, metadata !5329, metadata !DIExpression()), !dbg !5333
  %587 = load i32, i32* @Inst_Counter, !dbg !5333
  %588 = add i32 5, %587, !dbg !5333
  store i32 %588, i32* @Inst_Counter, !dbg !5333
  %589 = load i32, i32* @Inst_Counter, !dbg !5333
  call void @printCounter(i32 %589), !dbg !5333
  %590 = ptrtoint i64* %length to i64, !dbg !5333
  call void @printStoreAddr(i64 %590, i32 899, i32 251, i32 12), !dbg !5333
  store i64 94, i64* %length, align 8, !dbg !5333
  call void @printDDep(i32 899, i32 899), !dbg !5333
  call void @printDDep(i32 897, i32 899), !dbg !5333
  call void @printDDep(i32 897, i32 899), !dbg !5333
  call void @llvm.dbg.declare(metadata i32* %size, metadata !5334, metadata !DIExpression()), !dbg !5335
  %591 = load i32, i32* @Inst_Counter, !dbg !5335
  %592 = add i32 2, %591, !dbg !5335
  store i32 %592, i32* @Inst_Counter, !dbg !5335
  %593 = load i32, i32* @Inst_Counter, !dbg !5335
  call void @printCounter(i32 %593), !dbg !5335
  %594 = ptrtoint i32* %size to i64, !dbg !5335
  call void @printStoreAddr(i64 %594, i32 901, i32 252, i32 9), !dbg !5335
  store i32 16, i32* %size, align 4, !dbg !5335
  call void @printDDep(i32 901, i32 901), !dbg !5335
  call void @printDDep(i32 899, i32 901), !dbg !5335
  call void @printDDep(i32 897, i32 901), !dbg !5335
  call void @llvm.dbg.declare(metadata i64* %round, metadata !5336, metadata !DIExpression()), !dbg !5337
  %595 = load i32, i32* @Inst_Counter, !dbg !5337
  %596 = add i32 2, %595, !dbg !5337
  store i32 %596, i32* @Inst_Counter, !dbg !5337
  %597 = load i32, i32* @Inst_Counter, !dbg !5337
  call void @printCounter(i32 %597), !dbg !5337
  %598 = ptrtoint i64* %round to i64, !dbg !5337
  call void @printStoreAddr(i64 %598, i32 903, i32 253, i32 12), !dbg !5337
  store i64 3, i64* %round, align 8, !dbg !5337
  call void @printDDep(i32 903, i32 903), !dbg !5337
  call void @printDDep(i32 3997, i32 903), !dbg !5337
  call void @printDDep(i32 901, i32 903), !dbg !5337
  call void @printDDep(i32 897, i32 903), !dbg !5337
  call void @llvm.dbg.declare(metadata i32* %i, metadata !5338, metadata !DIExpression()), !dbg !5339
  call void @llvm.dbg.declare(metadata i8** %buff, metadata !5340, metadata !DIExpression()), !dbg !5342
  %call1 = call noalias i8* @malloc(i64 5200) #7, !dbg !5343
  call void @printDDep(i32 903, i32 906), !dbg !5343
  call void @printDDep(i32 906, i32 906), !dbg !5343
  %599 = load i32, i32* @Inst_Counter, !dbg !5342
  %600 = add i32 4, %599, !dbg !5342
  store i32 %600, i32* @Inst_Counter, !dbg !5342
  %601 = load i32, i32* @Inst_Counter, !dbg !5342
  call void @printCounter(i32 %601), !dbg !5342
  %602 = ptrtoint i8** %buff to i64, !dbg !5342
  call void @printStoreAddr(i64 %602, i32 907, i32 256, i32 11), !dbg !5342
  store i8* %call1, i8** %buff, align 8, !dbg !5342
  call void @printDDep(i32 907, i32 907), !dbg !5342
  call void @printDDep(i32 906, i32 907), !dbg !5342
  call void @printDDep(i32 906, i32 907), !dbg !5342
  %603 = load i32, i32* @Inst_Counter, !dbg !5344
  %604 = add i32 1, %603, !dbg !5344
  store i32 %604, i32* @Inst_Counter, !dbg !5344
  %605 = load i32, i32* @Inst_Counter, !dbg !5344
  call void @printCounter(i32 %605), !dbg !5344
  %606 = ptrtoint i32* %i to i64, !dbg !5344
  call void @printStoreAddr(i64 %606, i32 908, i32 257, i32 12), !dbg !5344
  store i32 0, i32* %i, align 4, !dbg !5344
  call void @printDDep(i32 908, i32 908), !dbg !5344
  call void @printDDep(i32 923, i32 908), !dbg !5344
  call void @printDDep(i32 907, i32 908), !dbg !5344
  call void @printDDep(i32 906, i32 908), !dbg !5344
  %607 = load i32, i32* @Inst_Counter, !dbg !5346
  %608 = add i32 1, %607, !dbg !5346
  store i32 %608, i32* @Inst_Counter, !dbg !5346
  br label %for.cond, !dbg !5346

for.cond:                                         ; preds = %for.inc, %SM4_set_key.exit
  %609 = load i32, i32* @Inst_Counter, !dbg !5347
  %610 = add i32 1, %609, !dbg !5347
  store i32 %610, i32* @Inst_Counter, !dbg !5347
  %611 = load i32, i32* @Inst_Counter, !dbg !5347
  call void @printCounter(i32 %611), !dbg !5347
  %612 = ptrtoint i32* %i to i64, !dbg !5347
  call void @printLoadAddr(i64 %612, i32 910, i32 257, i32 17), !dbg !5347
  %613 = load i32, i32* %i, align 4, !dbg !5347
  call void @printDDep(i32 908, i32 910), !dbg !5347
  call void @printDDep(i32 923, i32 910), !dbg !5347
  call void @printDDep(i32 908, i32 910), !dbg !5347
  call void @printDDep(i32 923, i32 910), !dbg !5347
  call void @printDDep(i32 910, i32 910), !dbg !5347
  %cmp = icmp slt i32 %613, 5200, !dbg !5349
  %614 = load i32, i32* @Inst_Counter, !dbg !5350
  %615 = add i32 2, %614, !dbg !5350
  store i32 %615, i32* @Inst_Counter, !dbg !5350
  br i1 %cmp, label %for.body, label %for.end, !dbg !5350

for.body:                                         ; preds = %for.cond
  %616 = load i32, i32* @Inst_Counter, !dbg !5351
  %617 = add i32 1, %616, !dbg !5351
  store i32 %617, i32* @Inst_Counter, !dbg !5351
  %618 = load i32, i32* @Inst_Counter, !dbg !5351
  call void @printCounter(i32 %618), !dbg !5351
  %619 = ptrtoint i32* %i to i64, !dbg !5351
  call void @printLoadAddr(i64 %619, i32 913, i32 258, i32 17), !dbg !5351
  %620 = load i32, i32* %i, align 4, !dbg !5351
  call void @printDDep(i32 908, i32 913), !dbg !5351
  call void @printDDep(i32 923, i32 913), !dbg !5351
  call void @printDDep(i32 908, i32 913), !dbg !5351
  call void @printDDep(i32 923, i32 913), !dbg !5351
  call void @printDDep(i32 913, i32 913), !dbg !5351
  %conv = trunc i32 %620 to i8, !dbg !5351
  %621 = load i32, i32* @Inst_Counter, !dbg !5353
  %622 = add i32 2, %621, !dbg !5353
  store i32 %622, i32* @Inst_Counter, !dbg !5353
  %623 = load i32, i32* @Inst_Counter, !dbg !5353
  call void @printCounter(i32 %623), !dbg !5353
  %624 = ptrtoint i8** %buff to i64, !dbg !5353
  call void @printLoadAddr(i64 %624, i32 915, i32 258, i32 7), !dbg !5353
  %625 = load i8*, i8** %buff, align 8, !dbg !5353
  call void @printDDep(i32 907, i32 915), !dbg !5353
  call void @printDDep(i32 907, i32 915), !dbg !5353
  call void @printDDep(i32 915, i32 915), !dbg !5353
  %626 = load i32, i32* @Inst_Counter, !dbg !5354
  %627 = add i32 1, %626, !dbg !5354
  store i32 %627, i32* @Inst_Counter, !dbg !5354
  %628 = load i32, i32* @Inst_Counter, !dbg !5354
  call void @printCounter(i32 %628), !dbg !5354
  %629 = ptrtoint i32* %i to i64, !dbg !5354
  call void @printLoadAddr(i64 %629, i32 916, i32 258, i32 12), !dbg !5354
  %630 = load i32, i32* %i, align 4, !dbg !5354
  call void @printDDep(i32 908, i32 916), !dbg !5354
  call void @printDDep(i32 923, i32 916), !dbg !5354
  call void @printDDep(i32 908, i32 916), !dbg !5354
  call void @printDDep(i32 923, i32 916), !dbg !5354
  call void @printDDep(i32 916, i32 916), !dbg !5354
  %idxprom = sext i32 %630 to i64, !dbg !5353
  %arrayidx = getelementptr inbounds i8, i8* %625, i64 %idxprom, !dbg !5353
  %631 = load i32, i32* @Inst_Counter, !dbg !5355
  %632 = add i32 3, %631, !dbg !5355
  store i32 %632, i32* @Inst_Counter, !dbg !5355
  %633 = load i32, i32* @Inst_Counter, !dbg !5355
  call void @printCounter(i32 %633), !dbg !5355
  %634 = ptrtoint i8* %arrayidx to i64, !dbg !5355
  call void @printStoreAddr(i64 %634, i32 919, i32 258, i32 15), !dbg !5355
  store i8 %conv, i8* %arrayidx, align 1, !dbg !5355
  call void @printDDep(i32 913, i32 919), !dbg !5355
  call void @printDDep(i32 915, i32 919), !dbg !5355
  call void @printDDep(i32 916, i32 919), !dbg !5355
  call void @printDDep(i32 919, i32 919), !dbg !5355
  call void @printDDep(i32 908, i32 919), !dbg !5355
  call void @printDDep(i32 923, i32 919), !dbg !5355
  call void @printDDep(i32 919, i32 919), !dbg !5355
  %635 = load i32, i32* @Inst_Counter, !dbg !5356
  %636 = add i32 1, %635, !dbg !5356
  store i32 %636, i32* @Inst_Counter, !dbg !5356
  br label %for.inc, !dbg !5356

for.inc:                                          ; preds = %for.body
  %637 = load i32, i32* @Inst_Counter, !dbg !5357
  %638 = add i32 1, %637, !dbg !5357
  store i32 %638, i32* @Inst_Counter, !dbg !5357
  %639 = load i32, i32* @Inst_Counter, !dbg !5357
  call void @printCounter(i32 %639), !dbg !5357
  %640 = ptrtoint i32* %i to i64, !dbg !5357
  call void @printLoadAddr(i64 %640, i32 921, i32 257, i32 28), !dbg !5357
  %641 = load i32, i32* %i, align 4, !dbg !5357
  call void @printDDep(i32 908, i32 921), !dbg !5357
  call void @printDDep(i32 923, i32 921), !dbg !5357
  call void @printDDep(i32 908, i32 921), !dbg !5357
  call void @printDDep(i32 923, i32 921), !dbg !5357
  call void @printDDep(i32 921, i32 921), !dbg !5357
  %add = add nsw i32 %641, 16, !dbg !5357
  %642 = load i32, i32* @Inst_Counter, !dbg !5357
  %643 = add i32 2, %642, !dbg !5357
  store i32 %643, i32* @Inst_Counter, !dbg !5357
  %644 = load i32, i32* @Inst_Counter, !dbg !5357
  call void @printCounter(i32 %644), !dbg !5357
  %645 = ptrtoint i32* %i to i64, !dbg !5357
  call void @printStoreAddr(i64 %645, i32 923, i32 257, i32 28), !dbg !5357
  store i32 %add, i32* %i, align 4, !dbg !5357
  call void @printDDep(i32 908, i32 923), !dbg !5357
  call void @printDDep(i32 921, i32 923), !dbg !5357
  call void @printDDep(i32 923, i32 923), !dbg !5357
  call void @printDDep(i32 919, i32 923), !dbg !5357
  call void @printDDep(i32 923, i32 923), !dbg !5357
  %646 = load i32, i32* @Inst_Counter, !dbg !5358
  %647 = add i32 1, %646, !dbg !5358
  store i32 %647, i32* @Inst_Counter, !dbg !5358
  br label %for.cond, !dbg !5358, !llvm.loop !5359

for.end:                                          ; preds = %for.cond
  call void @llvm.dbg.declare(metadata i8** %input, metadata !5361, metadata !DIExpression()), !dbg !5362
  %648 = load i32, i32* @Inst_Counter, !dbg !5363
  %649 = add i32 2, %648, !dbg !5363
  store i32 %649, i32* @Inst_Counter, !dbg !5363
  %650 = load i32, i32* @Inst_Counter, !dbg !5363
  call void @printCounter(i32 %650), !dbg !5363
  %651 = ptrtoint i32* %size to i64, !dbg !5363
  call void @printLoadAddr(i64 %651, i32 926, i32 261, i32 41), !dbg !5363
  %652 = load i32, i32* %size, align 4, !dbg !5363
  call void @printDDep(i32 901, i32 926), !dbg !5363
  call void @printDDep(i32 901, i32 926), !dbg !5363
  call void @printDDep(i32 906, i32 926), !dbg !5363
  %conv2 = sext i32 %652 to i64, !dbg !5363
  %mul = mul i64 1, %conv2, !dbg !5364
  %653 = load i32, i32* @Inst_Counter, !dbg !5365
  %654 = add i32 3, %653, !dbg !5365
  store i32 %654, i32* @Inst_Counter, !dbg !5365
  %655 = load i32, i32* @Inst_Counter, !dbg !5365
  call void @printCounter(i32 %655), !dbg !5365
  %656 = ptrtoint i64* %round to i64, !dbg !5365
  call void @printLoadAddr(i64 %656, i32 929, i32 261, i32 48), !dbg !5365
  %657 = load i64, i64* %round, align 8, !dbg !5365
  call void @printDDep(i32 903, i32 929), !dbg !5365
  call void @printDDep(i32 3997, i32 929), !dbg !5365
  call void @printDDep(i32 903, i32 929), !dbg !5365
  call void @printDDep(i32 906, i32 929), !dbg !5365
  %mul3 = mul i64 %mul, %657, !dbg !5366
  %call4 = call noalias i8* @malloc(i64 %mul3) #7, !dbg !5367
  call void @printDDep(i32 908, i32 931), !dbg !5367
  call void @printDDep(i32 923, i32 931), !dbg !5367
  call void @printDDep(i32 931, i32 931), !dbg !5367
  %658 = load i32, i32* @Inst_Counter, !dbg !5362
  %659 = add i32 3, %658, !dbg !5362
  store i32 %659, i32* @Inst_Counter, !dbg !5362
  %660 = load i32, i32* @Inst_Counter, !dbg !5362
  call void @printCounter(i32 %660), !dbg !5362
  %661 = ptrtoint i8** %input to i64, !dbg !5362
  call void @printStoreAddr(i64 %661, i32 932, i32 261, i32 11), !dbg !5362
  store i8* %call4, i8** %input, align 8, !dbg !5362
  call void @printDDep(i32 926, i32 932), !dbg !5362
  call void @printDDep(i32 929, i32 932), !dbg !5362
  call void @printDDep(i32 932, i32 932), !dbg !5362
  call void @printDDep(i32 931, i32 932), !dbg !5362
  call void @printDDep(i32 931, i32 932), !dbg !5362
  call void @llvm.dbg.declare(metadata i64* %n, metadata !5368, metadata !DIExpression()), !dbg !5370
  %662 = load i32, i32* @Inst_Counter, !dbg !5370
  %663 = add i32 2, %662, !dbg !5370
  store i32 %663, i32* @Inst_Counter, !dbg !5370
  %664 = load i32, i32* @Inst_Counter, !dbg !5370
  call void @printCounter(i32 %664), !dbg !5370
  %665 = ptrtoint i64* %n to i64, !dbg !5370
  call void @printStoreAddr(i64 %665, i32 934, i32 262, i32 17), !dbg !5370
  store i64 0, i64* %n, align 8, !dbg !5370
  call void @printDDep(i32 934, i32 934), !dbg !5370
  call void @printDDep(i32 957, i32 934), !dbg !5370
  call void @printDDep(i32 932, i32 934), !dbg !5370
  call void @printDDep(i32 931, i32 934), !dbg !5370
  %666 = load i32, i32* @Inst_Counter, !dbg !5371
  %667 = add i32 1, %666, !dbg !5371
  store i32 %667, i32* @Inst_Counter, !dbg !5371
  br label %for.cond5, !dbg !5371

for.cond5:                                        ; preds = %for.inc14, %for.end
  %668 = load i32, i32* @Inst_Counter, !dbg !5372
  %669 = add i32 1, %668, !dbg !5372
  store i32 %669, i32* @Inst_Counter, !dbg !5372
  %670 = load i32, i32* @Inst_Counter, !dbg !5372
  call void @printCounter(i32 %670), !dbg !5372
  %671 = ptrtoint i64* %n to i64, !dbg !5372
  call void @printLoadAddr(i64 %671, i32 936, i32 262, i32 24), !dbg !5372
  %672 = load i64, i64* %n, align 8, !dbg !5372
  call void @printDDep(i32 934, i32 936), !dbg !5372
  call void @printDDep(i32 957, i32 936), !dbg !5372
  call void @printDDep(i32 934, i32 936), !dbg !5372
  call void @printDDep(i32 957, i32 936), !dbg !5372
  call void @printDDep(i32 936, i32 936), !dbg !5372
  %673 = load i32, i32* @Inst_Counter, !dbg !5374
  %674 = add i32 1, %673, !dbg !5374
  store i32 %674, i32* @Inst_Counter, !dbg !5374
  %675 = load i32, i32* @Inst_Counter, !dbg !5374
  call void @printCounter(i32 %675), !dbg !5374
  %676 = ptrtoint i64* %length to i64, !dbg !5374
  call void @printLoadAddr(i64 %676, i32 937, i32 262, i32 28), !dbg !5374
  %677 = load i64, i64* %length, align 8, !dbg !5374
  call void @printDDep(i32 899, i32 937), !dbg !5374
  call void @printDDep(i32 899, i32 937), !dbg !5374
  call void @printDDep(i32 937, i32 937), !dbg !5374
  %678 = load i32, i32* @Inst_Counter, !dbg !5375
  %679 = add i32 1, %678, !dbg !5375
  store i32 %679, i32* @Inst_Counter, !dbg !5375
  %680 = load i32, i32* @Inst_Counter, !dbg !5375
  call void @printCounter(i32 %680), !dbg !5375
  %681 = ptrtoint i64* %round to i64, !dbg !5375
  call void @printLoadAddr(i64 %681, i32 938, i32 262, i32 37), !dbg !5375
  %682 = load i64, i64* %round, align 8, !dbg !5375
  call void @printDDep(i32 903, i32 938), !dbg !5375
  call void @printDDep(i32 3997, i32 938), !dbg !5375
  call void @printDDep(i32 903, i32 938), !dbg !5375
  call void @printDDep(i32 938, i32 938), !dbg !5375
  %mul6 = mul i64 %677, %682, !dbg !5376
  %cmp7 = icmp ult i64 %672, %mul6, !dbg !5377
  %683 = load i32, i32* @Inst_Counter, !dbg !5378
  %684 = add i32 3, %683, !dbg !5378
  store i32 %684, i32* @Inst_Counter, !dbg !5378
  br i1 %cmp7, label %for.body9, label %for.end15, !dbg !5378

for.body9:                                        ; preds = %for.cond5
  call void @llvm.dbg.declare(metadata i32* %key, metadata !5379, metadata !DIExpression()), !dbg !5381
  %call10 = call i32 @rand() #7, !dbg !5382
  call void @printDDep(i32 934, i32 943), !dbg !5382
  call void @printDDep(i32 957, i32 943), !dbg !5382
  call void @printDDep(i32 943, i32 943), !dbg !5382
  %rem = srem i32 %call10, 94, !dbg !5383
  %685 = load i32, i32* @Inst_Counter, !dbg !5381
  %686 = add i32 4, %685, !dbg !5381
  store i32 %686, i32* @Inst_Counter, !dbg !5381
  %687 = load i32, i32* @Inst_Counter, !dbg !5381
  call void @printCounter(i32 %687), !dbg !5381
  %688 = ptrtoint i32* %key to i64, !dbg !5381
  call void @printStoreAddr(i64 %688, i32 945, i32 263, i32 13), !dbg !5381
  store i32 %rem, i32* %key, align 4, !dbg !5381
  call void @printDDep(i32 945, i32 945), !dbg !5381
  call void @printDDep(i32 943, i32 945), !dbg !5381
  call void @printDDep(i32 945, i32 945), !dbg !5381
  %689 = load i32, i32* @Inst_Counter, !dbg !5384
  %690 = add i32 1, %689, !dbg !5384
  store i32 %690, i32* @Inst_Counter, !dbg !5384
  %691 = load i32, i32* @Inst_Counter, !dbg !5384
  call void @printCounter(i32 %691), !dbg !5384
  %692 = ptrtoint i32* %key to i64, !dbg !5384
  call void @printLoadAddr(i64 %692, i32 946, i32 264, i32 28), !dbg !5384
  %693 = load i32, i32* %key, align 4, !dbg !5384
  call void @printDDep(i32 945, i32 946), !dbg !5384
  call void @printDDep(i32 945, i32 946), !dbg !5384
  call void @printDDep(i32 946, i32 946), !dbg !5384
  %idxprom11 = sext i32 %693 to i64, !dbg !5385
  %arrayidx12 = getelementptr inbounds [94 x i8], [94 x i8]* %charset, i64 0, i64 %idxprom11, !dbg !5385
  %694 = load i32, i32* @Inst_Counter, !dbg !5385
  %695 = add i32 3, %694, !dbg !5385
  store i32 %695, i32* @Inst_Counter, !dbg !5385
  %696 = load i32, i32* @Inst_Counter, !dbg !5385
  call void @printCounter(i32 %696), !dbg !5385
  %697 = ptrtoint i8* %arrayidx12 to i64, !dbg !5385
  call void @printLoadAddr(i64 %697, i32 949, i32 264, i32 20), !dbg !5385
  %698 = load i8, i8* %arrayidx12, align 1, !dbg !5385
  call void @printDDep(i32 946, i32 949), !dbg !5385
  call void @printDDep(i32 897, i32 949), !dbg !5385
  call void @printDDep(i32 949, i32 949), !dbg !5385
  %699 = load i32, i32* @Inst_Counter, !dbg !5386
  %700 = add i32 1, %699, !dbg !5386
  store i32 %700, i32* @Inst_Counter, !dbg !5386
  %701 = load i32, i32* @Inst_Counter, !dbg !5386
  call void @printCounter(i32 %701), !dbg !5386
  %702 = ptrtoint i8** %input to i64, !dbg !5386
  call void @printLoadAddr(i64 %702, i32 950, i32 264, i32 9), !dbg !5386
  %703 = load i8*, i8** %input, align 8, !dbg !5386
  call void @printDDep(i32 932, i32 950), !dbg !5386
  call void @printDDep(i32 932, i32 950), !dbg !5386
  call void @printDDep(i32 950, i32 950), !dbg !5386
  %704 = load i32, i32* @Inst_Counter, !dbg !5387
  %705 = add i32 1, %704, !dbg !5387
  store i32 %705, i32* @Inst_Counter, !dbg !5387
  %706 = load i32, i32* @Inst_Counter, !dbg !5387
  call void @printCounter(i32 %706), !dbg !5387
  %707 = ptrtoint i64* %n to i64, !dbg !5387
  call void @printLoadAddr(i64 %707, i32 951, i32 264, i32 15), !dbg !5387
  %708 = load i64, i64* %n, align 8, !dbg !5387
  call void @printDDep(i32 934, i32 951), !dbg !5387
  call void @printDDep(i32 957, i32 951), !dbg !5387
  call void @printDDep(i32 934, i32 951), !dbg !5387
  call void @printDDep(i32 957, i32 951), !dbg !5387
  call void @printDDep(i32 951, i32 951), !dbg !5387
  %arrayidx13 = getelementptr inbounds i8, i8* %703, i64 %708, !dbg !5386
  %709 = load i32, i32* @Inst_Counter, !dbg !5388
  %710 = add i32 2, %709, !dbg !5388
  store i32 %710, i32* @Inst_Counter, !dbg !5388
  %711 = load i32, i32* @Inst_Counter, !dbg !5388
  call void @printCounter(i32 %711), !dbg !5388
  %712 = ptrtoint i8* %arrayidx13 to i64, !dbg !5388
  call void @printStoreAddr(i64 %712, i32 953, i32 264, i32 18), !dbg !5388
  store i8 %698, i8* %arrayidx13, align 1, !dbg !5388
  call void @printDDep(i32 949, i32 953), !dbg !5388
  call void @printDDep(i32 950, i32 953), !dbg !5388
  call void @printDDep(i32 951, i32 953), !dbg !5388
  call void @printDDep(i32 953, i32 953), !dbg !5388
  call void @printDDep(i32 945, i32 953), !dbg !5388
  call void @printDDep(i32 953, i32 953), !dbg !5388
  %713 = load i32, i32* @Inst_Counter, !dbg !5389
  %714 = add i32 1, %713, !dbg !5389
  store i32 %714, i32* @Inst_Counter, !dbg !5389
  br label %for.inc14, !dbg !5389

for.inc14:                                        ; preds = %for.body9
  %715 = load i32, i32* @Inst_Counter, !dbg !5390
  %716 = add i32 1, %715, !dbg !5390
  store i32 %716, i32* @Inst_Counter, !dbg !5390
  %717 = load i32, i32* @Inst_Counter, !dbg !5390
  call void @printCounter(i32 %717), !dbg !5390
  %718 = ptrtoint i64* %n to i64, !dbg !5390
  call void @printLoadAddr(i64 %718, i32 955, i32 262, i32 45), !dbg !5390
  %719 = load i64, i64* %n, align 8, !dbg !5390
  call void @printDDep(i32 934, i32 955), !dbg !5390
  call void @printDDep(i32 957, i32 955), !dbg !5390
  call void @printDDep(i32 934, i32 955), !dbg !5390
  call void @printDDep(i32 957, i32 955), !dbg !5390
  call void @printDDep(i32 955, i32 955), !dbg !5390
  %inc = add i64 %719, 1, !dbg !5390
  %720 = load i32, i32* @Inst_Counter, !dbg !5390
  %721 = add i32 2, %720, !dbg !5390
  store i32 %721, i32* @Inst_Counter, !dbg !5390
  %722 = load i32, i32* @Inst_Counter, !dbg !5390
  call void @printCounter(i32 %722), !dbg !5390
  %723 = ptrtoint i64* %n to i64, !dbg !5390
  call void @printStoreAddr(i64 %723, i32 957, i32 262, i32 45), !dbg !5390
  store i64 %inc, i64* %n, align 8, !dbg !5390
  call void @printDDep(i32 934, i32 957), !dbg !5390
  call void @printDDep(i32 955, i32 957), !dbg !5390
  call void @printDDep(i32 957, i32 957), !dbg !5390
  call void @printDDep(i32 953, i32 957), !dbg !5390
  call void @printDDep(i32 957, i32 957), !dbg !5390
  %724 = load i32, i32* @Inst_Counter, !dbg !5391
  %725 = add i32 1, %724, !dbg !5391
  store i32 %725, i32* @Inst_Counter, !dbg !5391
  br label %for.cond5, !dbg !5391, !llvm.loop !5392

for.end15:                                        ; preds = %for.cond5
  %726 = load i32, i32* @Inst_Counter, !dbg !5394
  %727 = add i32 1, %726, !dbg !5394
  store i32 %727, i32* @Inst_Counter, !dbg !5394
  br label %while.cond, !dbg !5394

while.cond:                                       ; preds = %while.body, %for.end15
  %728 = load i32, i32* @Inst_Counter, !dbg !5395
  %729 = add i32 1, %728, !dbg !5395
  store i32 %729, i32* @Inst_Counter, !dbg !5395
  %730 = load i32, i32* @Inst_Counter, !dbg !5395
  call void @printCounter(i32 %730), !dbg !5395
  %731 = ptrtoint i64* %round to i64, !dbg !5395
  call void @printLoadAddr(i64 %731, i32 960, i32 267, i32 11), !dbg !5395
  %732 = load i64, i64* %round, align 8, !dbg !5395
  call void @printDDep(i32 903, i32 960), !dbg !5395
  call void @printDDep(i32 3997, i32 960), !dbg !5395
  call void @printDDep(i32 3997, i32 960), !dbg !5395
  call void @printDDep(i32 960, i32 960), !dbg !5395
  %tobool = icmp ne i64 %732, 0, !dbg !5394
  %733 = load i32, i32* @Inst_Counter, !dbg !5394
  %734 = add i32 2, %733, !dbg !5394
  store i32 %734, i32* @Inst_Counter, !dbg !5394
  br i1 %tobool, label %while.body, label %while.end, !dbg !5394

while.body:                                       ; preds = %while.cond
  call void @llvm.dbg.declare(metadata i8** %in, metadata !5396, metadata !DIExpression()), !dbg !5397
  %735 = load i32, i32* @Inst_Counter, !dbg !5398
  %736 = add i32 2, %735, !dbg !5398
  store i32 %736, i32* @Inst_Counter, !dbg !5398
  %737 = load i32, i32* @Inst_Counter, !dbg !5398
  call void @printCounter(i32 %737), !dbg !5398
  %738 = ptrtoint i32* %size to i64, !dbg !5398
  call void @printLoadAddr(i64 %738, i32 964, i32 275, i32 25), !dbg !5398
  %739 = load i32, i32* %size, align 4, !dbg !5398
  call void @printDDep(i32 901, i32 964), !dbg !5398
  call void @printDDep(i32 3997, i32 964), !dbg !5398
  call void @printDDep(i32 964, i32 964), !dbg !5398
  %conv16 = sext i32 %739 to i64, !dbg !5398
  %call17 = call noalias i8* @malloc(i64 %conv16) #7, !dbg !5399
  call void @printDDep(i32 3997, i32 966), !dbg !5399
  call void @printDDep(i32 966, i32 966), !dbg !5399
  %740 = load i32, i32* @Inst_Counter, !dbg !5397
  %741 = add i32 3, %740, !dbg !5397
  store i32 %741, i32* @Inst_Counter, !dbg !5397
  %742 = load i32, i32* @Inst_Counter, !dbg !5397
  call void @printCounter(i32 %742), !dbg !5397
  %743 = ptrtoint i8** %in to i64, !dbg !5397
  call void @printStoreAddr(i64 %743, i32 967, i32 275, i32 13), !dbg !5397
  store i8* %call17, i8** %in, align 8, !dbg !5397
  call void @printDDep(i32 964, i32 967), !dbg !5397
  call void @printDDep(i32 967, i32 967), !dbg !5397
  call void @printDDep(i32 966, i32 967), !dbg !5397
  call void @printDDep(i32 967, i32 967), !dbg !5397
  %744 = load i32, i32* @Inst_Counter, !dbg !5400
  %745 = add i32 1, %744, !dbg !5400
  store i32 %745, i32* @Inst_Counter, !dbg !5400
  %746 = load i32, i32* @Inst_Counter, !dbg !5400
  call void @printCounter(i32 %746), !dbg !5400
  %747 = ptrtoint i8** %in to i64, !dbg !5400
  call void @printLoadAddr(i64 %747, i32 968, i32 276, i32 15), !dbg !5400
  %748 = load i8*, i8** %in, align 8, !dbg !5400
  call void @printDDep(i32 967, i32 968), !dbg !5400
  call void @printDDep(i32 967, i32 968), !dbg !5400
  call void @printDDep(i32 968, i32 968), !dbg !5400
  %749 = load i32, i32* @Inst_Counter, !dbg !5401
  %750 = add i32 1, %749, !dbg !5401
  store i32 %750, i32* @Inst_Counter, !dbg !5401
  %751 = load i32, i32* @Inst_Counter, !dbg !5401
  call void @printCounter(i32 %751), !dbg !5401
  %752 = ptrtoint i8** %input to i64, !dbg !5401
  call void @printLoadAddr(i64 %752, i32 969, i32 276, i32 19), !dbg !5401
  %753 = load i8*, i8** %input, align 8, !dbg !5401
  call void @printDDep(i32 932, i32 969), !dbg !5401
  call void @printDDep(i32 3997, i32 969), !dbg !5401
  call void @printDDep(i32 969, i32 969), !dbg !5401
  %754 = load i32, i32* @Inst_Counter, !dbg !5402
  %755 = add i32 1, %754, !dbg !5402
  store i32 %755, i32* @Inst_Counter, !dbg !5402
  %756 = load i32, i32* @Inst_Counter, !dbg !5402
  call void @printCounter(i32 %756), !dbg !5402
  %757 = ptrtoint i64* %round to i64, !dbg !5402
  call void @printLoadAddr(i64 %757, i32 970, i32 276, i32 26), !dbg !5402
  %758 = load i64, i64* %round, align 8, !dbg !5402
  call void @printDDep(i32 903, i32 970), !dbg !5402
  call void @printDDep(i32 3997, i32 970), !dbg !5402
  call void @printDDep(i32 3997, i32 970), !dbg !5402
  call void @printDDep(i32 970, i32 970), !dbg !5402
  %sub = sub i64 %758, 1, !dbg !5403
  %759 = load i32, i32* @Inst_Counter, !dbg !5404
  %760 = add i32 2, %759, !dbg !5404
  store i32 %760, i32* @Inst_Counter, !dbg !5404
  %761 = load i32, i32* @Inst_Counter, !dbg !5404
  call void @printCounter(i32 %761), !dbg !5404
  %762 = ptrtoint i32* %size to i64, !dbg !5404
  call void @printLoadAddr(i64 %762, i32 972, i32 276, i32 35), !dbg !5404
  %763 = load i32, i32* %size, align 4, !dbg !5404
  call void @printDDep(i32 901, i32 972), !dbg !5404
  call void @printDDep(i32 3997, i32 972), !dbg !5404
  call void @printDDep(i32 972, i32 972), !dbg !5404
  %conv18 = sext i32 %763 to i64, !dbg !5404
  %mul19 = mul i64 %sub, %conv18, !dbg !5405
  %add.ptr = getelementptr inbounds i8, i8* %753, i64 %mul19, !dbg !5406
  %764 = load i32, i32* @Inst_Counter, !dbg !5407
  %765 = add i32 4, %764, !dbg !5407
  store i32 %765, i32* @Inst_Counter, !dbg !5407
  %766 = load i32, i32* @Inst_Counter, !dbg !5407
  call void @printCounter(i32 %766), !dbg !5407
  %767 = ptrtoint i32* %size to i64, !dbg !5407
  call void @printLoadAddr(i64 %767, i32 976, i32 276, i32 41), !dbg !5407
  %768 = load i32, i32* %size, align 4, !dbg !5407
  call void @printDDep(i32 901, i32 976), !dbg !5407
  call void @printDDep(i32 3997, i32 976), !dbg !5407
  call void @printDDep(i32 976, i32 976), !dbg !5407
  %conv20 = sext i32 %768 to i64, !dbg !5407
  %call21 = call i8* @strncpy(i8* %748, i8* %add.ptr, i64 %conv20), !dbg !5408
  call void @printDDep(i32 967, i32 978), !dbg !5408
  call void @printDDep(i32 978, i32 978), !dbg !5408
  %769 = load i32, i32* @Inst_Counter, !dbg !5409
  %770 = add i32 3, %769, !dbg !5409
  store i32 %770, i32* @Inst_Counter, !dbg !5409
  %771 = load i32, i32* @Inst_Counter, !dbg !5409
  call void @printCounter(i32 %771), !dbg !5409
  %772 = ptrtoint i8** %in to i64, !dbg !5409
  call void @printLoadAddr(i64 %772, i32 979, i32 277, i32 19), !dbg !5409
  %773 = load i8*, i8** %in, align 8, !dbg !5409
  call void @printDDep(i32 967, i32 979), !dbg !5409
  call void @printDDep(i32 967, i32 979), !dbg !5409
  call void @printDDep(i32 979, i32 979), !dbg !5409
  %arraydecay = getelementptr inbounds [256 x i8], [256 x i8]* %enc_out, i64 0, i64 0, !dbg !5410
  %774 = load i32, i32* @Inst_Counter
  %775 = add i32 2, %774
  store i32 %775, i32* @Inst_Counter
  %776 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %776)
  %777 = ptrtoint i8** %in.addr.i to i64
  call void @printStoreAddr(i64 %777, i32 981, i32 0, i32 0)
  store i8* %773, i8** %in.addr.i, align 8
  call void @printDDep(i32 979, i32 981)
  call void @printDDep(i32 981, i32 981)
  call void @printDDep(i32 978, i32 981)
  call void @printDDep(i32 981, i32 981)
  %778 = load i32, i32* @Inst_Counter
  %779 = add i32 1, %778
  store i32 %779, i32* @Inst_Counter
  %780 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %780)
  %781 = ptrtoint i8** %out.addr.i to i64
  call void @printStoreAddr(i64 %781, i32 982, i32 0, i32 0)
  store i8* %arraydecay, i8** %out.addr.i, align 8
  call void @printDDep(i32 982, i32 982)
  call void @printDDep(i32 981, i32 982)
  call void @printDDep(i32 982, i32 982)
  %782 = load i32, i32* @Inst_Counter
  %783 = add i32 1, %782
  store i32 %783, i32* @Inst_Counter
  %784 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %784)
  %785 = ptrtoint %struct.SM4_KEY_st** %ks.addr.i24 to i64
  call void @printStoreAddr(i64 %785, i32 983, i32 0, i32 0)
  store %struct.SM4_KEY_st* %enc_key, %struct.SM4_KEY_st** %ks.addr.i24, align 8
  call void @printDDep(i32 983, i32 983)
  call void @printDDep(i32 982, i32 983)
  call void @printDDep(i32 983, i32 983)
  %ks.addr1.i = bitcast %struct.SM4_KEY_st** %ks.addr.i24 to i8*
  call void @llvm.var.annotation(i8* %ks.addr1.i, i8* getelementptr inbounds ([5 x i8], [5 x i8]* @.str, i32 0, i32 0), i8* getelementptr inbounds ([13 x i8], [13 x i8]* @.str.1, i32 0, i32 0), i32 189) #7
  call void @printDDep(i32 983, i32 985)
  call void @printDDep(i32 985, i32 985)
  %786 = load i32, i32* @Inst_Counter, !dbg !5411
  %787 = add i32 3, %786, !dbg !5411
  store i32 %787, i32* @Inst_Counter, !dbg !5411
  %788 = load i32, i32* @Inst_Counter, !dbg !5411
  call void @printCounter(i32 %788), !dbg !5411
  %789 = ptrtoint i8** %in.addr.i to i64, !dbg !5411
  call void @printLoadAddr(i64 %789, i32 986, i32 191, i32 31), !dbg !5411
  %790 = load i8*, i8** %in.addr.i, align 8, !dbg !5411
  call void @printDDep(i32 981, i32 986), !dbg !5411
  call void @printDDep(i32 981, i32 986), !dbg !5411
  call void @printDDep(i32 986, i32 986), !dbg !5411
  %791 = load i32, i32* @Inst_Counter
  %792 = add i32 1, %791
  store i32 %792, i32* @Inst_Counter
  %793 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %793)
  %794 = ptrtoint i8** %b.addr.i.i22 to i64
  call void @printStoreAddr(i64 %794, i32 987, i32 0, i32 0)
  store i8* %790, i8** %b.addr.i.i22, align 8
  call void @printDDep(i32 986, i32 987)
  call void @printDDep(i32 987, i32 987)
  call void @printDDep(i32 985, i32 987)
  call void @printDDep(i32 987, i32 987)
  %795 = load i32, i32* @Inst_Counter
  %796 = add i32 1, %795
  store i32 %796, i32* @Inst_Counter
  %797 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %797)
  %798 = ptrtoint i32* %n.addr.i.i23 to i64
  call void @printStoreAddr(i64 %798, i32 988, i32 0, i32 0)
  store i32 0, i32* %n.addr.i.i23, align 4
  call void @printDDep(i32 988, i32 988)
  call void @printDDep(i32 987, i32 988)
  call void @printDDep(i32 988, i32 988)
  %799 = load i32, i32* @Inst_Counter, !dbg !5412
  %800 = add i32 1, %799, !dbg !5412
  store i32 %800, i32* @Inst_Counter, !dbg !5412
  %801 = load i32, i32* @Inst_Counter, !dbg !5412
  call void @printCounter(i32 %801), !dbg !5412
  %802 = ptrtoint i8** %b.addr.i.i22 to i64, !dbg !5412
  call void @printLoadAddr(i64 %802, i32 989, i32 97, i32 23), !dbg !5412
  %803 = load i8*, i8** %b.addr.i.i22, align 8, !dbg !5412
  call void @printDDep(i32 987, i32 989), !dbg !5412
  call void @printDDep(i32 987, i32 989), !dbg !5412
  call void @printDDep(i32 989, i32 989), !dbg !5412
  %804 = load i32, i32* @Inst_Counter, !dbg !5413
  %805 = add i32 1, %804, !dbg !5413
  store i32 %805, i32* @Inst_Counter, !dbg !5413
  %806 = load i32, i32* @Inst_Counter, !dbg !5413
  call void @printCounter(i32 %806), !dbg !5413
  %807 = ptrtoint i32* %n.addr.i.i23 to i64, !dbg !5413
  call void @printLoadAddr(i64 %807, i32 990, i32 97, i32 29), !dbg !5413
  %808 = load i32, i32* %n.addr.i.i23, align 4, !dbg !5413
  call void @printDDep(i32 988, i32 990), !dbg !5413
  call void @printDDep(i32 988, i32 990), !dbg !5413
  call void @printDDep(i32 990, i32 990), !dbg !5413
  %mul.i.i25 = mul i32 4, %808, !dbg !5414
  %idxprom.i.i26 = zext i32 %mul.i.i25 to i64, !dbg !5412
  %arrayidx.i.i27 = getelementptr inbounds i8, i8* %803, i64 %idxprom.i.i26, !dbg !5412
  %809 = load i32, i32* @Inst_Counter, !dbg !5412
  %810 = add i32 4, %809, !dbg !5412
  store i32 %810, i32* @Inst_Counter, !dbg !5412
  %811 = load i32, i32* @Inst_Counter, !dbg !5412
  call void @printCounter(i32 %811), !dbg !5412
  %812 = ptrtoint i8* %arrayidx.i.i27 to i64, !dbg !5412
  call void @printLoadAddr(i64 %812, i32 994, i32 97, i32 23), !dbg !5412
  %813 = load i8, i8* %arrayidx.i.i27, align 1, !dbg !5412
  call void @printDDep(i32 989, i32 994), !dbg !5412
  call void @printDDep(i32 990, i32 994), !dbg !5412
  call void @printDDep(i32 985, i32 994), !dbg !5412
  call void @printDDep(i32 994, i32 994), !dbg !5412
  %conv.i.i28 = zext i8 %813 to i32, !dbg !5415
  %shl.i.i29 = shl i32 %conv.i.i28, 24, !dbg !5416
  %814 = load i32, i32* @Inst_Counter, !dbg !5417
  %815 = add i32 3, %814, !dbg !5417
  store i32 %815, i32* @Inst_Counter, !dbg !5417
  %816 = load i32, i32* @Inst_Counter, !dbg !5417
  call void @printCounter(i32 %816), !dbg !5417
  %817 = ptrtoint i8** %b.addr.i.i22 to i64, !dbg !5417
  call void @printLoadAddr(i64 %817, i32 997, i32 98, i32 23), !dbg !5417
  %818 = load i8*, i8** %b.addr.i.i22, align 8, !dbg !5417
  call void @printDDep(i32 987, i32 997), !dbg !5417
  call void @printDDep(i32 987, i32 997), !dbg !5417
  call void @printDDep(i32 997, i32 997), !dbg !5417
  %819 = load i32, i32* @Inst_Counter, !dbg !5418
  %820 = add i32 1, %819, !dbg !5418
  store i32 %820, i32* @Inst_Counter, !dbg !5418
  %821 = load i32, i32* @Inst_Counter, !dbg !5418
  call void @printCounter(i32 %821), !dbg !5418
  %822 = ptrtoint i32* %n.addr.i.i23 to i64, !dbg !5418
  call void @printLoadAddr(i64 %822, i32 998, i32 98, i32 29), !dbg !5418
  %823 = load i32, i32* %n.addr.i.i23, align 4, !dbg !5418
  call void @printDDep(i32 988, i32 998), !dbg !5418
  call void @printDDep(i32 988, i32 998), !dbg !5418
  call void @printDDep(i32 998, i32 998), !dbg !5418
  %mul1.i.i30 = mul i32 4, %823, !dbg !5419
  %add.i.i31 = add i32 %mul1.i.i30, 1, !dbg !5420
  %idxprom2.i.i32 = zext i32 %add.i.i31 to i64, !dbg !5417
  %arrayidx3.i.i33 = getelementptr inbounds i8, i8* %818, i64 %idxprom2.i.i32, !dbg !5417
  %824 = load i32, i32* @Inst_Counter, !dbg !5417
  %825 = add i32 5, %824, !dbg !5417
  store i32 %825, i32* @Inst_Counter, !dbg !5417
  %826 = load i32, i32* @Inst_Counter, !dbg !5417
  call void @printCounter(i32 %826), !dbg !5417
  %827 = ptrtoint i8* %arrayidx3.i.i33 to i64, !dbg !5417
  call void @printLoadAddr(i64 %827, i32 1003, i32 98, i32 23), !dbg !5417
  %828 = load i8, i8* %arrayidx3.i.i33, align 1, !dbg !5417
  call void @printDDep(i32 997, i32 1003), !dbg !5417
  call void @printDDep(i32 998, i32 1003), !dbg !5417
  call void @printDDep(i32 985, i32 1003), !dbg !5417
  call void @printDDep(i32 1003, i32 1003), !dbg !5417
  %conv4.i.i34 = zext i8 %828 to i32, !dbg !5421
  %shl5.i.i35 = shl i32 %conv4.i.i34, 16, !dbg !5422
  %or.i.i36 = or i32 %shl.i.i29, %shl5.i.i35, !dbg !5423
  %829 = load i32, i32* @Inst_Counter, !dbg !5424
  %830 = add i32 4, %829, !dbg !5424
  store i32 %830, i32* @Inst_Counter, !dbg !5424
  %831 = load i32, i32* @Inst_Counter, !dbg !5424
  call void @printCounter(i32 %831), !dbg !5424
  %832 = ptrtoint i8** %b.addr.i.i22 to i64, !dbg !5424
  call void @printLoadAddr(i64 %832, i32 1007, i32 99, i32 23), !dbg !5424
  %833 = load i8*, i8** %b.addr.i.i22, align 8, !dbg !5424
  call void @printDDep(i32 987, i32 1007), !dbg !5424
  call void @printDDep(i32 987, i32 1007), !dbg !5424
  call void @printDDep(i32 1007, i32 1007), !dbg !5424
  %834 = load i32, i32* @Inst_Counter, !dbg !5425
  %835 = add i32 1, %834, !dbg !5425
  store i32 %835, i32* @Inst_Counter, !dbg !5425
  %836 = load i32, i32* @Inst_Counter, !dbg !5425
  call void @printCounter(i32 %836), !dbg !5425
  %837 = ptrtoint i32* %n.addr.i.i23 to i64, !dbg !5425
  call void @printLoadAddr(i64 %837, i32 1008, i32 99, i32 29), !dbg !5425
  %838 = load i32, i32* %n.addr.i.i23, align 4, !dbg !5425
  call void @printDDep(i32 988, i32 1008), !dbg !5425
  call void @printDDep(i32 988, i32 1008), !dbg !5425
  call void @printDDep(i32 1008, i32 1008), !dbg !5425
  %mul6.i.i37 = mul i32 4, %838, !dbg !5426
  %add7.i.i38 = add i32 %mul6.i.i37, 2, !dbg !5427
  %idxprom8.i.i39 = zext i32 %add7.i.i38 to i64, !dbg !5424
  %arrayidx9.i.i40 = getelementptr inbounds i8, i8* %833, i64 %idxprom8.i.i39, !dbg !5424
  %839 = load i32, i32* @Inst_Counter, !dbg !5424
  %840 = add i32 5, %839, !dbg !5424
  store i32 %840, i32* @Inst_Counter, !dbg !5424
  %841 = load i32, i32* @Inst_Counter, !dbg !5424
  call void @printCounter(i32 %841), !dbg !5424
  %842 = ptrtoint i8* %arrayidx9.i.i40 to i64, !dbg !5424
  call void @printLoadAddr(i64 %842, i32 1013, i32 99, i32 23), !dbg !5424
  %843 = load i8, i8* %arrayidx9.i.i40, align 1, !dbg !5424
  call void @printDDep(i32 1007, i32 1013), !dbg !5424
  call void @printDDep(i32 1008, i32 1013), !dbg !5424
  call void @printDDep(i32 985, i32 1013), !dbg !5424
  call void @printDDep(i32 1013, i32 1013), !dbg !5424
  %conv10.i.i41 = zext i8 %843 to i32, !dbg !5428
  %shl11.i.i42 = shl i32 %conv10.i.i41, 8, !dbg !5429
  %or12.i.i43 = or i32 %or.i.i36, %shl11.i.i42, !dbg !5430
  %844 = load i32, i32* @Inst_Counter, !dbg !5431
  %845 = add i32 4, %844, !dbg !5431
  store i32 %845, i32* @Inst_Counter, !dbg !5431
  %846 = load i32, i32* @Inst_Counter, !dbg !5431
  call void @printCounter(i32 %846), !dbg !5431
  %847 = ptrtoint i8** %b.addr.i.i22 to i64, !dbg !5431
  call void @printLoadAddr(i64 %847, i32 1017, i32 100, i32 23), !dbg !5431
  %848 = load i8*, i8** %b.addr.i.i22, align 8, !dbg !5431
  call void @printDDep(i32 987, i32 1017), !dbg !5431
  call void @printDDep(i32 987, i32 1017), !dbg !5431
  call void @printDDep(i32 1017, i32 1017), !dbg !5431
  %849 = load i32, i32* @Inst_Counter, !dbg !5432
  %850 = add i32 1, %849, !dbg !5432
  store i32 %850, i32* @Inst_Counter, !dbg !5432
  %851 = load i32, i32* @Inst_Counter, !dbg !5432
  call void @printCounter(i32 %851), !dbg !5432
  %852 = ptrtoint i32* %n.addr.i.i23 to i64, !dbg !5432
  call void @printLoadAddr(i64 %852, i32 1018, i32 100, i32 29), !dbg !5432
  %853 = load i32, i32* %n.addr.i.i23, align 4, !dbg !5432
  call void @printDDep(i32 988, i32 1018), !dbg !5432
  call void @printDDep(i32 988, i32 1018), !dbg !5432
  call void @printDDep(i32 1018, i32 1018), !dbg !5432
  %mul13.i.i44 = mul i32 4, %853, !dbg !5433
  %add14.i.i45 = add i32 %mul13.i.i44, 3, !dbg !5434
  %idxprom15.i.i46 = zext i32 %add14.i.i45 to i64, !dbg !5431
  %arrayidx16.i.i47 = getelementptr inbounds i8, i8* %848, i64 %idxprom15.i.i46, !dbg !5431
  %854 = load i32, i32* @Inst_Counter, !dbg !5431
  %855 = add i32 5, %854, !dbg !5431
  store i32 %855, i32* @Inst_Counter, !dbg !5431
  %856 = load i32, i32* @Inst_Counter, !dbg !5431
  call void @printCounter(i32 %856), !dbg !5431
  %857 = ptrtoint i8* %arrayidx16.i.i47 to i64, !dbg !5431
  call void @printLoadAddr(i64 %857, i32 1023, i32 100, i32 23), !dbg !5431
  %858 = load i8, i8* %arrayidx16.i.i47, align 1, !dbg !5431
  call void @printDDep(i32 1017, i32 1023), !dbg !5431
  call void @printDDep(i32 1018, i32 1023), !dbg !5431
  call void @printDDep(i32 985, i32 1023), !dbg !5431
  call void @printDDep(i32 1023, i32 1023), !dbg !5431
  %conv17.i.i48 = zext i8 %858 to i32, !dbg !5435
  %or18.i.i49 = or i32 %or12.i.i43, %conv17.i.i48, !dbg !5436
  %859 = load i32, i32* @Inst_Counter, !dbg !5087
  %860 = add i32 3, %859, !dbg !5087
  store i32 %860, i32* @Inst_Counter, !dbg !5087
  %861 = load i32, i32* @Inst_Counter, !dbg !5087
  call void @printCounter(i32 %861), !dbg !5087
  %862 = ptrtoint i32* %B0.i to i64, !dbg !5087
  call void @printStoreAddr(i64 %862, i32 1026, i32 191, i32 14), !dbg !5087
  store i32 %or18.i.i49, i32* %B0.i, align 4, !dbg !5087
  call void @printDDep(i32 994, i32 1026), !dbg !5087
  call void @printDDep(i32 1003, i32 1026), !dbg !5087
  call void @printDDep(i32 1013, i32 1026), !dbg !5087
  call void @printDDep(i32 1023, i32 1026), !dbg !5087
  call void @printDDep(i32 1026, i32 1026), !dbg !5087
  call void @printDDep(i32 1263, i32 1026), !dbg !5087
  call void @printDDep(i32 1681, i32 1026), !dbg !5087
  call void @printDDep(i32 1985, i32 1026), !dbg !5087
  call void @printDDep(i32 2289, i32 1026), !dbg !5087
  call void @printDDep(i32 2593, i32 1026), !dbg !5087
  call void @printDDep(i32 2897, i32 1026), !dbg !5087
  call void @printDDep(i32 3201, i32 1026), !dbg !5087
  call void @printDDep(i32 3543, i32 1026), !dbg !5087
  call void @printDDep(i32 988, i32 1026), !dbg !5087
  call void @printDDep(i32 1026, i32 1026), !dbg !5087
  %863 = load i32, i32* @Inst_Counter, !dbg !5437
  %864 = add i32 1, %863, !dbg !5437
  store i32 %864, i32* @Inst_Counter, !dbg !5437
  %865 = load i32, i32* @Inst_Counter, !dbg !5437
  call void @printCounter(i32 %865), !dbg !5437
  %866 = ptrtoint i8** %in.addr.i to i64, !dbg !5437
  call void @printLoadAddr(i64 %866, i32 1027, i32 192, i32 31), !dbg !5437
  %867 = load i8*, i8** %in.addr.i, align 8, !dbg !5437
  call void @printDDep(i32 981, i32 1027), !dbg !5437
  call void @printDDep(i32 981, i32 1027), !dbg !5437
  call void @printDDep(i32 1027, i32 1027), !dbg !5437
  %868 = load i32, i32* @Inst_Counter
  %869 = add i32 1, %868
  store i32 %869, i32* @Inst_Counter
  %870 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %870)
  %871 = ptrtoint i8** %b.addr.i1797.i to i64
  call void @printStoreAddr(i64 %871, i32 1028, i32 0, i32 0)
  store i8* %867, i8** %b.addr.i1797.i, align 8
  call void @printDDep(i32 1027, i32 1028)
  call void @printDDep(i32 1028, i32 1028)
  call void @printDDep(i32 1026, i32 1028)
  call void @printDDep(i32 1028, i32 1028)
  %872 = load i32, i32* @Inst_Counter
  %873 = add i32 1, %872
  store i32 %873, i32* @Inst_Counter
  %874 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %874)
  %875 = ptrtoint i32* %n.addr.i1798.i to i64
  call void @printStoreAddr(i64 %875, i32 1029, i32 0, i32 0)
  store i32 1, i32* %n.addr.i1798.i, align 4
  call void @printDDep(i32 1029, i32 1029)
  call void @printDDep(i32 1028, i32 1029)
  call void @printDDep(i32 1029, i32 1029)
  %876 = load i32, i32* @Inst_Counter, !dbg !5438
  %877 = add i32 1, %876, !dbg !5438
  store i32 %877, i32* @Inst_Counter, !dbg !5438
  %878 = load i32, i32* @Inst_Counter, !dbg !5438
  call void @printCounter(i32 %878), !dbg !5438
  %879 = ptrtoint i8** %b.addr.i1797.i to i64, !dbg !5438
  call void @printLoadAddr(i64 %879, i32 1030, i32 97, i32 23), !dbg !5438
  %880 = load i8*, i8** %b.addr.i1797.i, align 8, !dbg !5438
  call void @printDDep(i32 1028, i32 1030), !dbg !5438
  call void @printDDep(i32 1028, i32 1030), !dbg !5438
  call void @printDDep(i32 1030, i32 1030), !dbg !5438
  %881 = load i32, i32* @Inst_Counter, !dbg !5439
  %882 = add i32 1, %881, !dbg !5439
  store i32 %882, i32* @Inst_Counter, !dbg !5439
  %883 = load i32, i32* @Inst_Counter, !dbg !5439
  call void @printCounter(i32 %883), !dbg !5439
  %884 = ptrtoint i32* %n.addr.i1798.i to i64, !dbg !5439
  call void @printLoadAddr(i64 %884, i32 1031, i32 97, i32 29), !dbg !5439
  %885 = load i32, i32* %n.addr.i1798.i, align 4, !dbg !5439
  call void @printDDep(i32 1029, i32 1031), !dbg !5439
  call void @printDDep(i32 1029, i32 1031), !dbg !5439
  call void @printDDep(i32 1031, i32 1031), !dbg !5439
  %mul.i1799.i = mul i32 4, %885, !dbg !5440
  %idxprom.i1800.i = zext i32 %mul.i1799.i to i64, !dbg !5438
  %arrayidx.i1801.i = getelementptr inbounds i8, i8* %880, i64 %idxprom.i1800.i, !dbg !5438
  %886 = load i32, i32* @Inst_Counter, !dbg !5438
  %887 = add i32 4, %886, !dbg !5438
  store i32 %887, i32* @Inst_Counter, !dbg !5438
  %888 = load i32, i32* @Inst_Counter, !dbg !5438
  call void @printCounter(i32 %888), !dbg !5438
  %889 = ptrtoint i8* %arrayidx.i1801.i to i64, !dbg !5438
  call void @printLoadAddr(i64 %889, i32 1035, i32 97, i32 23), !dbg !5438
  %890 = load i8, i8* %arrayidx.i1801.i, align 1, !dbg !5438
  call void @printDDep(i32 1030, i32 1035), !dbg !5438
  call void @printDDep(i32 1031, i32 1035), !dbg !5438
  call void @printDDep(i32 1026, i32 1035), !dbg !5438
  call void @printDDep(i32 1035, i32 1035), !dbg !5438
  %conv.i1802.i = zext i8 %890 to i32, !dbg !5441
  %shl.i1803.i = shl i32 %conv.i1802.i, 24, !dbg !5442
  %891 = load i32, i32* @Inst_Counter, !dbg !5443
  %892 = add i32 3, %891, !dbg !5443
  store i32 %892, i32* @Inst_Counter, !dbg !5443
  %893 = load i32, i32* @Inst_Counter, !dbg !5443
  call void @printCounter(i32 %893), !dbg !5443
  %894 = ptrtoint i8** %b.addr.i1797.i to i64, !dbg !5443
  call void @printLoadAddr(i64 %894, i32 1038, i32 98, i32 23), !dbg !5443
  %895 = load i8*, i8** %b.addr.i1797.i, align 8, !dbg !5443
  call void @printDDep(i32 1028, i32 1038), !dbg !5443
  call void @printDDep(i32 1028, i32 1038), !dbg !5443
  call void @printDDep(i32 1038, i32 1038), !dbg !5443
  %896 = load i32, i32* @Inst_Counter, !dbg !5444
  %897 = add i32 1, %896, !dbg !5444
  store i32 %897, i32* @Inst_Counter, !dbg !5444
  %898 = load i32, i32* @Inst_Counter, !dbg !5444
  call void @printCounter(i32 %898), !dbg !5444
  %899 = ptrtoint i32* %n.addr.i1798.i to i64, !dbg !5444
  call void @printLoadAddr(i64 %899, i32 1039, i32 98, i32 29), !dbg !5444
  %900 = load i32, i32* %n.addr.i1798.i, align 4, !dbg !5444
  call void @printDDep(i32 1029, i32 1039), !dbg !5444
  call void @printDDep(i32 1029, i32 1039), !dbg !5444
  call void @printDDep(i32 1039, i32 1039), !dbg !5444
  %mul1.i1804.i = mul i32 4, %900, !dbg !5445
  %add.i1805.i = add i32 %mul1.i1804.i, 1, !dbg !5446
  %idxprom2.i1806.i = zext i32 %add.i1805.i to i64, !dbg !5443
  %arrayidx3.i1807.i = getelementptr inbounds i8, i8* %895, i64 %idxprom2.i1806.i, !dbg !5443
  %901 = load i32, i32* @Inst_Counter, !dbg !5443
  %902 = add i32 5, %901, !dbg !5443
  store i32 %902, i32* @Inst_Counter, !dbg !5443
  %903 = load i32, i32* @Inst_Counter, !dbg !5443
  call void @printCounter(i32 %903), !dbg !5443
  %904 = ptrtoint i8* %arrayidx3.i1807.i to i64, !dbg !5443
  call void @printLoadAddr(i64 %904, i32 1044, i32 98, i32 23), !dbg !5443
  %905 = load i8, i8* %arrayidx3.i1807.i, align 1, !dbg !5443
  call void @printDDep(i32 1038, i32 1044), !dbg !5443
  call void @printDDep(i32 1039, i32 1044), !dbg !5443
  call void @printDDep(i32 1026, i32 1044), !dbg !5443
  call void @printDDep(i32 1044, i32 1044), !dbg !5443
  %conv4.i1808.i = zext i8 %905 to i32, !dbg !5447
  %shl5.i1809.i = shl i32 %conv4.i1808.i, 16, !dbg !5448
  %or.i1810.i = or i32 %shl.i1803.i, %shl5.i1809.i, !dbg !5449
  %906 = load i32, i32* @Inst_Counter, !dbg !5450
  %907 = add i32 4, %906, !dbg !5450
  store i32 %907, i32* @Inst_Counter, !dbg !5450
  %908 = load i32, i32* @Inst_Counter, !dbg !5450
  call void @printCounter(i32 %908), !dbg !5450
  %909 = ptrtoint i8** %b.addr.i1797.i to i64, !dbg !5450
  call void @printLoadAddr(i64 %909, i32 1048, i32 99, i32 23), !dbg !5450
  %910 = load i8*, i8** %b.addr.i1797.i, align 8, !dbg !5450
  call void @printDDep(i32 1028, i32 1048), !dbg !5450
  call void @printDDep(i32 1028, i32 1048), !dbg !5450
  call void @printDDep(i32 1048, i32 1048), !dbg !5450
  %911 = load i32, i32* @Inst_Counter, !dbg !5451
  %912 = add i32 1, %911, !dbg !5451
  store i32 %912, i32* @Inst_Counter, !dbg !5451
  %913 = load i32, i32* @Inst_Counter, !dbg !5451
  call void @printCounter(i32 %913), !dbg !5451
  %914 = ptrtoint i32* %n.addr.i1798.i to i64, !dbg !5451
  call void @printLoadAddr(i64 %914, i32 1049, i32 99, i32 29), !dbg !5451
  %915 = load i32, i32* %n.addr.i1798.i, align 4, !dbg !5451
  call void @printDDep(i32 1029, i32 1049), !dbg !5451
  call void @printDDep(i32 1029, i32 1049), !dbg !5451
  call void @printDDep(i32 1049, i32 1049), !dbg !5451
  %mul6.i1811.i = mul i32 4, %915, !dbg !5452
  %add7.i1812.i = add i32 %mul6.i1811.i, 2, !dbg !5453
  %idxprom8.i1813.i = zext i32 %add7.i1812.i to i64, !dbg !5450
  %arrayidx9.i1814.i = getelementptr inbounds i8, i8* %910, i64 %idxprom8.i1813.i, !dbg !5450
  %916 = load i32, i32* @Inst_Counter, !dbg !5450
  %917 = add i32 5, %916, !dbg !5450
  store i32 %917, i32* @Inst_Counter, !dbg !5450
  %918 = load i32, i32* @Inst_Counter, !dbg !5450
  call void @printCounter(i32 %918), !dbg !5450
  %919 = ptrtoint i8* %arrayidx9.i1814.i to i64, !dbg !5450
  call void @printLoadAddr(i64 %919, i32 1054, i32 99, i32 23), !dbg !5450
  %920 = load i8, i8* %arrayidx9.i1814.i, align 1, !dbg !5450
  call void @printDDep(i32 1048, i32 1054), !dbg !5450
  call void @printDDep(i32 1049, i32 1054), !dbg !5450
  call void @printDDep(i32 1026, i32 1054), !dbg !5450
  call void @printDDep(i32 1054, i32 1054), !dbg !5450
  %conv10.i1815.i = zext i8 %920 to i32, !dbg !5454
  %shl11.i1816.i = shl i32 %conv10.i1815.i, 8, !dbg !5455
  %or12.i1817.i = or i32 %or.i1810.i, %shl11.i1816.i, !dbg !5456
  %921 = load i32, i32* @Inst_Counter, !dbg !5457
  %922 = add i32 4, %921, !dbg !5457
  store i32 %922, i32* @Inst_Counter, !dbg !5457
  %923 = load i32, i32* @Inst_Counter, !dbg !5457
  call void @printCounter(i32 %923), !dbg !5457
  %924 = ptrtoint i8** %b.addr.i1797.i to i64, !dbg !5457
  call void @printLoadAddr(i64 %924, i32 1058, i32 100, i32 23), !dbg !5457
  %925 = load i8*, i8** %b.addr.i1797.i, align 8, !dbg !5457
  call void @printDDep(i32 1028, i32 1058), !dbg !5457
  call void @printDDep(i32 1028, i32 1058), !dbg !5457
  call void @printDDep(i32 1058, i32 1058), !dbg !5457
  %926 = load i32, i32* @Inst_Counter, !dbg !5458
  %927 = add i32 1, %926, !dbg !5458
  store i32 %927, i32* @Inst_Counter, !dbg !5458
  %928 = load i32, i32* @Inst_Counter, !dbg !5458
  call void @printCounter(i32 %928), !dbg !5458
  %929 = ptrtoint i32* %n.addr.i1798.i to i64, !dbg !5458
  call void @printLoadAddr(i64 %929, i32 1059, i32 100, i32 29), !dbg !5458
  %930 = load i32, i32* %n.addr.i1798.i, align 4, !dbg !5458
  call void @printDDep(i32 1029, i32 1059), !dbg !5458
  call void @printDDep(i32 1029, i32 1059), !dbg !5458
  call void @printDDep(i32 1059, i32 1059), !dbg !5458
  %mul13.i1818.i = mul i32 4, %930, !dbg !5459
  %add14.i1819.i = add i32 %mul13.i1818.i, 3, !dbg !5460
  %idxprom15.i1820.i = zext i32 %add14.i1819.i to i64, !dbg !5457
  %arrayidx16.i1821.i = getelementptr inbounds i8, i8* %925, i64 %idxprom15.i1820.i, !dbg !5457
  %931 = load i32, i32* @Inst_Counter, !dbg !5457
  %932 = add i32 5, %931, !dbg !5457
  store i32 %932, i32* @Inst_Counter, !dbg !5457
  %933 = load i32, i32* @Inst_Counter, !dbg !5457
  call void @printCounter(i32 %933), !dbg !5457
  %934 = ptrtoint i8* %arrayidx16.i1821.i to i64, !dbg !5457
  call void @printLoadAddr(i64 %934, i32 1064, i32 100, i32 23), !dbg !5457
  %935 = load i8, i8* %arrayidx16.i1821.i, align 1, !dbg !5457
  call void @printDDep(i32 1058, i32 1064), !dbg !5457
  call void @printDDep(i32 1059, i32 1064), !dbg !5457
  call void @printDDep(i32 1026, i32 1064), !dbg !5457
  call void @printDDep(i32 1064, i32 1064), !dbg !5457
  %conv17.i1822.i = zext i8 %935 to i32, !dbg !5461
  %or18.i1823.i = or i32 %or12.i1817.i, %conv17.i1822.i, !dbg !5462
  %936 = load i32, i32* @Inst_Counter, !dbg !5088
  %937 = add i32 3, %936, !dbg !5088
  store i32 %937, i32* @Inst_Counter, !dbg !5088
  %938 = load i32, i32* @Inst_Counter, !dbg !5088
  call void @printCounter(i32 %938), !dbg !5088
  %939 = ptrtoint i32* %B1.i to i64, !dbg !5088
  call void @printStoreAddr(i64 %939, i32 1067, i32 192, i32 14), !dbg !5088
  store i32 %or18.i1823.i, i32* %B1.i, align 4, !dbg !5088
  call void @printDDep(i32 1035, i32 1067), !dbg !5088
  call void @printDDep(i32 1044, i32 1067), !dbg !5088
  call void @printDDep(i32 1054, i32 1067), !dbg !5088
  call void @printDDep(i32 1064, i32 1067), !dbg !5088
  call void @printDDep(i32 1067, i32 1067), !dbg !5088
  call void @printDDep(i32 1377, i32 1067), !dbg !5088
  call void @printDDep(i32 1757, i32 1067), !dbg !5088
  call void @printDDep(i32 2061, i32 1067), !dbg !5088
  call void @printDDep(i32 2365, i32 1067), !dbg !5088
  call void @printDDep(i32 2669, i32 1067), !dbg !5088
  call void @printDDep(i32 2973, i32 1067), !dbg !5088
  call void @printDDep(i32 3277, i32 1067), !dbg !5088
  call void @printDDep(i32 3657, i32 1067), !dbg !5088
  call void @printDDep(i32 1029, i32 1067), !dbg !5088
  call void @printDDep(i32 1067, i32 1067), !dbg !5088
  %940 = load i32, i32* @Inst_Counter, !dbg !5463
  %941 = add i32 1, %940, !dbg !5463
  store i32 %941, i32* @Inst_Counter, !dbg !5463
  %942 = load i32, i32* @Inst_Counter, !dbg !5463
  call void @printCounter(i32 %942), !dbg !5463
  %943 = ptrtoint i8** %in.addr.i to i64, !dbg !5463
  call void @printLoadAddr(i64 %943, i32 1068, i32 193, i32 31), !dbg !5463
  %944 = load i8*, i8** %in.addr.i, align 8, !dbg !5463
  call void @printDDep(i32 981, i32 1068), !dbg !5463
  call void @printDDep(i32 981, i32 1068), !dbg !5463
  call void @printDDep(i32 1068, i32 1068), !dbg !5463
  %945 = load i32, i32* @Inst_Counter
  %946 = add i32 1, %945
  store i32 %946, i32* @Inst_Counter
  %947 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %947)
  %948 = ptrtoint i8** %b.addr.i1770.i to i64
  call void @printStoreAddr(i64 %948, i32 1069, i32 0, i32 0)
  store i8* %944, i8** %b.addr.i1770.i, align 8
  call void @printDDep(i32 1068, i32 1069)
  call void @printDDep(i32 1069, i32 1069)
  call void @printDDep(i32 1067, i32 1069)
  call void @printDDep(i32 1069, i32 1069)
  %949 = load i32, i32* @Inst_Counter
  %950 = add i32 1, %949
  store i32 %950, i32* @Inst_Counter
  %951 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %951)
  %952 = ptrtoint i32* %n.addr.i1771.i to i64
  call void @printStoreAddr(i64 %952, i32 1070, i32 0, i32 0)
  store i32 2, i32* %n.addr.i1771.i, align 4
  call void @printDDep(i32 1070, i32 1070)
  call void @printDDep(i32 1069, i32 1070)
  call void @printDDep(i32 1070, i32 1070)
  %953 = load i32, i32* @Inst_Counter, !dbg !5464
  %954 = add i32 1, %953, !dbg !5464
  store i32 %954, i32* @Inst_Counter, !dbg !5464
  %955 = load i32, i32* @Inst_Counter, !dbg !5464
  call void @printCounter(i32 %955), !dbg !5464
  %956 = ptrtoint i8** %b.addr.i1770.i to i64, !dbg !5464
  call void @printLoadAddr(i64 %956, i32 1071, i32 97, i32 23), !dbg !5464
  %957 = load i8*, i8** %b.addr.i1770.i, align 8, !dbg !5464
  call void @printDDep(i32 1069, i32 1071), !dbg !5464
  call void @printDDep(i32 1069, i32 1071), !dbg !5464
  call void @printDDep(i32 1071, i32 1071), !dbg !5464
  %958 = load i32, i32* @Inst_Counter, !dbg !5465
  %959 = add i32 1, %958, !dbg !5465
  store i32 %959, i32* @Inst_Counter, !dbg !5465
  %960 = load i32, i32* @Inst_Counter, !dbg !5465
  call void @printCounter(i32 %960), !dbg !5465
  %961 = ptrtoint i32* %n.addr.i1771.i to i64, !dbg !5465
  call void @printLoadAddr(i64 %961, i32 1072, i32 97, i32 29), !dbg !5465
  %962 = load i32, i32* %n.addr.i1771.i, align 4, !dbg !5465
  call void @printDDep(i32 1070, i32 1072), !dbg !5465
  call void @printDDep(i32 1070, i32 1072), !dbg !5465
  call void @printDDep(i32 1072, i32 1072), !dbg !5465
  %mul.i1772.i = mul i32 4, %962, !dbg !5466
  %idxprom.i1773.i = zext i32 %mul.i1772.i to i64, !dbg !5464
  %arrayidx.i1774.i = getelementptr inbounds i8, i8* %957, i64 %idxprom.i1773.i, !dbg !5464
  %963 = load i32, i32* @Inst_Counter, !dbg !5464
  %964 = add i32 4, %963, !dbg !5464
  store i32 %964, i32* @Inst_Counter, !dbg !5464
  %965 = load i32, i32* @Inst_Counter, !dbg !5464
  call void @printCounter(i32 %965), !dbg !5464
  %966 = ptrtoint i8* %arrayidx.i1774.i to i64, !dbg !5464
  call void @printLoadAddr(i64 %966, i32 1076, i32 97, i32 23), !dbg !5464
  %967 = load i8, i8* %arrayidx.i1774.i, align 1, !dbg !5464
  call void @printDDep(i32 1071, i32 1076), !dbg !5464
  call void @printDDep(i32 1072, i32 1076), !dbg !5464
  call void @printDDep(i32 1067, i32 1076), !dbg !5464
  call void @printDDep(i32 1076, i32 1076), !dbg !5464
  %conv.i1775.i = zext i8 %967 to i32, !dbg !5467
  %shl.i1776.i = shl i32 %conv.i1775.i, 24, !dbg !5468
  %968 = load i32, i32* @Inst_Counter, !dbg !5469
  %969 = add i32 3, %968, !dbg !5469
  store i32 %969, i32* @Inst_Counter, !dbg !5469
  %970 = load i32, i32* @Inst_Counter, !dbg !5469
  call void @printCounter(i32 %970), !dbg !5469
  %971 = ptrtoint i8** %b.addr.i1770.i to i64, !dbg !5469
  call void @printLoadAddr(i64 %971, i32 1079, i32 98, i32 23), !dbg !5469
  %972 = load i8*, i8** %b.addr.i1770.i, align 8, !dbg !5469
  call void @printDDep(i32 1069, i32 1079), !dbg !5469
  call void @printDDep(i32 1069, i32 1079), !dbg !5469
  call void @printDDep(i32 1079, i32 1079), !dbg !5469
  %973 = load i32, i32* @Inst_Counter, !dbg !5470
  %974 = add i32 1, %973, !dbg !5470
  store i32 %974, i32* @Inst_Counter, !dbg !5470
  %975 = load i32, i32* @Inst_Counter, !dbg !5470
  call void @printCounter(i32 %975), !dbg !5470
  %976 = ptrtoint i32* %n.addr.i1771.i to i64, !dbg !5470
  call void @printLoadAddr(i64 %976, i32 1080, i32 98, i32 29), !dbg !5470
  %977 = load i32, i32* %n.addr.i1771.i, align 4, !dbg !5470
  call void @printDDep(i32 1070, i32 1080), !dbg !5470
  call void @printDDep(i32 1070, i32 1080), !dbg !5470
  call void @printDDep(i32 1080, i32 1080), !dbg !5470
  %mul1.i1777.i = mul i32 4, %977, !dbg !5471
  %add.i1778.i = add i32 %mul1.i1777.i, 1, !dbg !5472
  %idxprom2.i1779.i = zext i32 %add.i1778.i to i64, !dbg !5469
  %arrayidx3.i1780.i = getelementptr inbounds i8, i8* %972, i64 %idxprom2.i1779.i, !dbg !5469
  %978 = load i32, i32* @Inst_Counter, !dbg !5469
  %979 = add i32 5, %978, !dbg !5469
  store i32 %979, i32* @Inst_Counter, !dbg !5469
  %980 = load i32, i32* @Inst_Counter, !dbg !5469
  call void @printCounter(i32 %980), !dbg !5469
  %981 = ptrtoint i8* %arrayidx3.i1780.i to i64, !dbg !5469
  call void @printLoadAddr(i64 %981, i32 1085, i32 98, i32 23), !dbg !5469
  %982 = load i8, i8* %arrayidx3.i1780.i, align 1, !dbg !5469
  call void @printDDep(i32 1079, i32 1085), !dbg !5469
  call void @printDDep(i32 1080, i32 1085), !dbg !5469
  call void @printDDep(i32 1067, i32 1085), !dbg !5469
  call void @printDDep(i32 1085, i32 1085), !dbg !5469
  %conv4.i1781.i = zext i8 %982 to i32, !dbg !5473
  %shl5.i1782.i = shl i32 %conv4.i1781.i, 16, !dbg !5474
  %or.i1783.i = or i32 %shl.i1776.i, %shl5.i1782.i, !dbg !5475
  %983 = load i32, i32* @Inst_Counter, !dbg !5476
  %984 = add i32 4, %983, !dbg !5476
  store i32 %984, i32* @Inst_Counter, !dbg !5476
  %985 = load i32, i32* @Inst_Counter, !dbg !5476
  call void @printCounter(i32 %985), !dbg !5476
  %986 = ptrtoint i8** %b.addr.i1770.i to i64, !dbg !5476
  call void @printLoadAddr(i64 %986, i32 1089, i32 99, i32 23), !dbg !5476
  %987 = load i8*, i8** %b.addr.i1770.i, align 8, !dbg !5476
  call void @printDDep(i32 1069, i32 1089), !dbg !5476
  call void @printDDep(i32 1069, i32 1089), !dbg !5476
  call void @printDDep(i32 1089, i32 1089), !dbg !5476
  %988 = load i32, i32* @Inst_Counter, !dbg !5477
  %989 = add i32 1, %988, !dbg !5477
  store i32 %989, i32* @Inst_Counter, !dbg !5477
  %990 = load i32, i32* @Inst_Counter, !dbg !5477
  call void @printCounter(i32 %990), !dbg !5477
  %991 = ptrtoint i32* %n.addr.i1771.i to i64, !dbg !5477
  call void @printLoadAddr(i64 %991, i32 1090, i32 99, i32 29), !dbg !5477
  %992 = load i32, i32* %n.addr.i1771.i, align 4, !dbg !5477
  call void @printDDep(i32 1070, i32 1090), !dbg !5477
  call void @printDDep(i32 1070, i32 1090), !dbg !5477
  call void @printDDep(i32 1090, i32 1090), !dbg !5477
  %mul6.i1784.i = mul i32 4, %992, !dbg !5478
  %add7.i1785.i = add i32 %mul6.i1784.i, 2, !dbg !5479
  %idxprom8.i1786.i = zext i32 %add7.i1785.i to i64, !dbg !5476
  %arrayidx9.i1787.i = getelementptr inbounds i8, i8* %987, i64 %idxprom8.i1786.i, !dbg !5476
  %993 = load i32, i32* @Inst_Counter, !dbg !5476
  %994 = add i32 5, %993, !dbg !5476
  store i32 %994, i32* @Inst_Counter, !dbg !5476
  %995 = load i32, i32* @Inst_Counter, !dbg !5476
  call void @printCounter(i32 %995), !dbg !5476
  %996 = ptrtoint i8* %arrayidx9.i1787.i to i64, !dbg !5476
  call void @printLoadAddr(i64 %996, i32 1095, i32 99, i32 23), !dbg !5476
  %997 = load i8, i8* %arrayidx9.i1787.i, align 1, !dbg !5476
  call void @printDDep(i32 1089, i32 1095), !dbg !5476
  call void @printDDep(i32 1090, i32 1095), !dbg !5476
  call void @printDDep(i32 1067, i32 1095), !dbg !5476
  call void @printDDep(i32 1095, i32 1095), !dbg !5476
  %conv10.i1788.i = zext i8 %997 to i32, !dbg !5480
  %shl11.i1789.i = shl i32 %conv10.i1788.i, 8, !dbg !5481
  %or12.i1790.i = or i32 %or.i1783.i, %shl11.i1789.i, !dbg !5482
  %998 = load i32, i32* @Inst_Counter, !dbg !5483
  %999 = add i32 4, %998, !dbg !5483
  store i32 %999, i32* @Inst_Counter, !dbg !5483
  %1000 = load i32, i32* @Inst_Counter, !dbg !5483
  call void @printCounter(i32 %1000), !dbg !5483
  %1001 = ptrtoint i8** %b.addr.i1770.i to i64, !dbg !5483
  call void @printLoadAddr(i64 %1001, i32 1099, i32 100, i32 23), !dbg !5483
  %1002 = load i8*, i8** %b.addr.i1770.i, align 8, !dbg !5483
  call void @printDDep(i32 1069, i32 1099), !dbg !5483
  call void @printDDep(i32 1069, i32 1099), !dbg !5483
  call void @printDDep(i32 1099, i32 1099), !dbg !5483
  %1003 = load i32, i32* @Inst_Counter, !dbg !5484
  %1004 = add i32 1, %1003, !dbg !5484
  store i32 %1004, i32* @Inst_Counter, !dbg !5484
  %1005 = load i32, i32* @Inst_Counter, !dbg !5484
  call void @printCounter(i32 %1005), !dbg !5484
  %1006 = ptrtoint i32* %n.addr.i1771.i to i64, !dbg !5484
  call void @printLoadAddr(i64 %1006, i32 1100, i32 100, i32 29), !dbg !5484
  %1007 = load i32, i32* %n.addr.i1771.i, align 4, !dbg !5484
  call void @printDDep(i32 1070, i32 1100), !dbg !5484
  call void @printDDep(i32 1070, i32 1100), !dbg !5484
  call void @printDDep(i32 1100, i32 1100), !dbg !5484
  %mul13.i1791.i = mul i32 4, %1007, !dbg !5485
  %add14.i1792.i = add i32 %mul13.i1791.i, 3, !dbg !5486
  %idxprom15.i1793.i = zext i32 %add14.i1792.i to i64, !dbg !5483
  %arrayidx16.i1794.i = getelementptr inbounds i8, i8* %1002, i64 %idxprom15.i1793.i, !dbg !5483
  %1008 = load i32, i32* @Inst_Counter, !dbg !5483
  %1009 = add i32 5, %1008, !dbg !5483
  store i32 %1009, i32* @Inst_Counter, !dbg !5483
  %1010 = load i32, i32* @Inst_Counter, !dbg !5483
  call void @printCounter(i32 %1010), !dbg !5483
  %1011 = ptrtoint i8* %arrayidx16.i1794.i to i64, !dbg !5483
  call void @printLoadAddr(i64 %1011, i32 1105, i32 100, i32 23), !dbg !5483
  %1012 = load i8, i8* %arrayidx16.i1794.i, align 1, !dbg !5483
  call void @printDDep(i32 1099, i32 1105), !dbg !5483
  call void @printDDep(i32 1100, i32 1105), !dbg !5483
  call void @printDDep(i32 1067, i32 1105), !dbg !5483
  call void @printDDep(i32 1105, i32 1105), !dbg !5483
  %conv17.i1795.i = zext i8 %1012 to i32, !dbg !5487
  %or18.i1796.i = or i32 %or12.i1790.i, %conv17.i1795.i, !dbg !5488
  %1013 = load i32, i32* @Inst_Counter, !dbg !5089
  %1014 = add i32 3, %1013, !dbg !5089
  store i32 %1014, i32* @Inst_Counter, !dbg !5089
  %1015 = load i32, i32* @Inst_Counter, !dbg !5089
  call void @printCounter(i32 %1015), !dbg !5089
  %1016 = ptrtoint i32* %B2.i to i64, !dbg !5089
  call void @printStoreAddr(i64 %1016, i32 1108, i32 193, i32 14), !dbg !5089
  store i32 %or18.i1796.i, i32* %B2.i, align 4, !dbg !5089
  call void @printDDep(i32 1076, i32 1108), !dbg !5089
  call void @printDDep(i32 1085, i32 1108), !dbg !5089
  call void @printDDep(i32 1095, i32 1108), !dbg !5089
  call void @printDDep(i32 1105, i32 1108), !dbg !5089
  call void @printDDep(i32 1108, i32 1108), !dbg !5089
  call void @printDDep(i32 1491, i32 1108), !dbg !5089
  call void @printDDep(i32 1833, i32 1108), !dbg !5089
  call void @printDDep(i32 2137, i32 1108), !dbg !5089
  call void @printDDep(i32 2441, i32 1108), !dbg !5089
  call void @printDDep(i32 2745, i32 1108), !dbg !5089
  call void @printDDep(i32 3049, i32 1108), !dbg !5089
  call void @printDDep(i32 3353, i32 1108), !dbg !5089
  call void @printDDep(i32 3771, i32 1108), !dbg !5089
  call void @printDDep(i32 1070, i32 1108), !dbg !5089
  call void @printDDep(i32 1108, i32 1108), !dbg !5089
  %1017 = load i32, i32* @Inst_Counter, !dbg !5489
  %1018 = add i32 1, %1017, !dbg !5489
  store i32 %1018, i32* @Inst_Counter, !dbg !5489
  %1019 = load i32, i32* @Inst_Counter, !dbg !5489
  call void @printCounter(i32 %1019), !dbg !5489
  %1020 = ptrtoint i8** %in.addr.i to i64, !dbg !5489
  call void @printLoadAddr(i64 %1020, i32 1109, i32 194, i32 31), !dbg !5489
  %1021 = load i8*, i8** %in.addr.i, align 8, !dbg !5489
  call void @printDDep(i32 981, i32 1109), !dbg !5489
  call void @printDDep(i32 981, i32 1109), !dbg !5489
  call void @printDDep(i32 1109, i32 1109), !dbg !5489
  %1022 = load i32, i32* @Inst_Counter
  %1023 = add i32 1, %1022
  store i32 %1023, i32* @Inst_Counter
  %1024 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1024)
  %1025 = ptrtoint i8** %b.addr.i1743.i to i64
  call void @printStoreAddr(i64 %1025, i32 1110, i32 0, i32 0)
  store i8* %1021, i8** %b.addr.i1743.i, align 8
  call void @printDDep(i32 1109, i32 1110)
  call void @printDDep(i32 1110, i32 1110)
  call void @printDDep(i32 1108, i32 1110)
  call void @printDDep(i32 1110, i32 1110)
  %1026 = load i32, i32* @Inst_Counter
  %1027 = add i32 1, %1026
  store i32 %1027, i32* @Inst_Counter
  %1028 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1028)
  %1029 = ptrtoint i32* %n.addr.i1744.i to i64
  call void @printStoreAddr(i64 %1029, i32 1111, i32 0, i32 0)
  store i32 3, i32* %n.addr.i1744.i, align 4
  call void @printDDep(i32 1111, i32 1111)
  call void @printDDep(i32 1110, i32 1111)
  call void @printDDep(i32 1111, i32 1111)
  %1030 = load i32, i32* @Inst_Counter, !dbg !5490
  %1031 = add i32 1, %1030, !dbg !5490
  store i32 %1031, i32* @Inst_Counter, !dbg !5490
  %1032 = load i32, i32* @Inst_Counter, !dbg !5490
  call void @printCounter(i32 %1032), !dbg !5490
  %1033 = ptrtoint i8** %b.addr.i1743.i to i64, !dbg !5490
  call void @printLoadAddr(i64 %1033, i32 1112, i32 97, i32 23), !dbg !5490
  %1034 = load i8*, i8** %b.addr.i1743.i, align 8, !dbg !5490
  call void @printDDep(i32 1110, i32 1112), !dbg !5490
  call void @printDDep(i32 1110, i32 1112), !dbg !5490
  call void @printDDep(i32 1112, i32 1112), !dbg !5490
  %1035 = load i32, i32* @Inst_Counter, !dbg !5491
  %1036 = add i32 1, %1035, !dbg !5491
  store i32 %1036, i32* @Inst_Counter, !dbg !5491
  %1037 = load i32, i32* @Inst_Counter, !dbg !5491
  call void @printCounter(i32 %1037), !dbg !5491
  %1038 = ptrtoint i32* %n.addr.i1744.i to i64, !dbg !5491
  call void @printLoadAddr(i64 %1038, i32 1113, i32 97, i32 29), !dbg !5491
  %1039 = load i32, i32* %n.addr.i1744.i, align 4, !dbg !5491
  call void @printDDep(i32 1111, i32 1113), !dbg !5491
  call void @printDDep(i32 1111, i32 1113), !dbg !5491
  call void @printDDep(i32 1113, i32 1113), !dbg !5491
  %mul.i1745.i = mul i32 4, %1039, !dbg !5492
  %idxprom.i1746.i = zext i32 %mul.i1745.i to i64, !dbg !5490
  %arrayidx.i1747.i = getelementptr inbounds i8, i8* %1034, i64 %idxprom.i1746.i, !dbg !5490
  %1040 = load i32, i32* @Inst_Counter, !dbg !5490
  %1041 = add i32 4, %1040, !dbg !5490
  store i32 %1041, i32* @Inst_Counter, !dbg !5490
  %1042 = load i32, i32* @Inst_Counter, !dbg !5490
  call void @printCounter(i32 %1042), !dbg !5490
  %1043 = ptrtoint i8* %arrayidx.i1747.i to i64, !dbg !5490
  call void @printLoadAddr(i64 %1043, i32 1117, i32 97, i32 23), !dbg !5490
  %1044 = load i8, i8* %arrayidx.i1747.i, align 1, !dbg !5490
  call void @printDDep(i32 1112, i32 1117), !dbg !5490
  call void @printDDep(i32 1113, i32 1117), !dbg !5490
  call void @printDDep(i32 1108, i32 1117), !dbg !5490
  call void @printDDep(i32 1117, i32 1117), !dbg !5490
  %conv.i1748.i = zext i8 %1044 to i32, !dbg !5493
  %shl.i1749.i = shl i32 %conv.i1748.i, 24, !dbg !5494
  %1045 = load i32, i32* @Inst_Counter, !dbg !5495
  %1046 = add i32 3, %1045, !dbg !5495
  store i32 %1046, i32* @Inst_Counter, !dbg !5495
  %1047 = load i32, i32* @Inst_Counter, !dbg !5495
  call void @printCounter(i32 %1047), !dbg !5495
  %1048 = ptrtoint i8** %b.addr.i1743.i to i64, !dbg !5495
  call void @printLoadAddr(i64 %1048, i32 1120, i32 98, i32 23), !dbg !5495
  %1049 = load i8*, i8** %b.addr.i1743.i, align 8, !dbg !5495
  call void @printDDep(i32 1110, i32 1120), !dbg !5495
  call void @printDDep(i32 1110, i32 1120), !dbg !5495
  call void @printDDep(i32 1120, i32 1120), !dbg !5495
  %1050 = load i32, i32* @Inst_Counter, !dbg !5496
  %1051 = add i32 1, %1050, !dbg !5496
  store i32 %1051, i32* @Inst_Counter, !dbg !5496
  %1052 = load i32, i32* @Inst_Counter, !dbg !5496
  call void @printCounter(i32 %1052), !dbg !5496
  %1053 = ptrtoint i32* %n.addr.i1744.i to i64, !dbg !5496
  call void @printLoadAddr(i64 %1053, i32 1121, i32 98, i32 29), !dbg !5496
  %1054 = load i32, i32* %n.addr.i1744.i, align 4, !dbg !5496
  call void @printDDep(i32 1111, i32 1121), !dbg !5496
  call void @printDDep(i32 1111, i32 1121), !dbg !5496
  call void @printDDep(i32 1121, i32 1121), !dbg !5496
  %mul1.i1750.i = mul i32 4, %1054, !dbg !5497
  %add.i1751.i = add i32 %mul1.i1750.i, 1, !dbg !5498
  %idxprom2.i1752.i = zext i32 %add.i1751.i to i64, !dbg !5495
  %arrayidx3.i1753.i = getelementptr inbounds i8, i8* %1049, i64 %idxprom2.i1752.i, !dbg !5495
  %1055 = load i32, i32* @Inst_Counter, !dbg !5495
  %1056 = add i32 5, %1055, !dbg !5495
  store i32 %1056, i32* @Inst_Counter, !dbg !5495
  %1057 = load i32, i32* @Inst_Counter, !dbg !5495
  call void @printCounter(i32 %1057), !dbg !5495
  %1058 = ptrtoint i8* %arrayidx3.i1753.i to i64, !dbg !5495
  call void @printLoadAddr(i64 %1058, i32 1126, i32 98, i32 23), !dbg !5495
  %1059 = load i8, i8* %arrayidx3.i1753.i, align 1, !dbg !5495
  call void @printDDep(i32 1120, i32 1126), !dbg !5495
  call void @printDDep(i32 1121, i32 1126), !dbg !5495
  call void @printDDep(i32 1108, i32 1126), !dbg !5495
  call void @printDDep(i32 1126, i32 1126), !dbg !5495
  %conv4.i1754.i = zext i8 %1059 to i32, !dbg !5499
  %shl5.i1755.i = shl i32 %conv4.i1754.i, 16, !dbg !5500
  %or.i1756.i = or i32 %shl.i1749.i, %shl5.i1755.i, !dbg !5501
  %1060 = load i32, i32* @Inst_Counter, !dbg !5502
  %1061 = add i32 4, %1060, !dbg !5502
  store i32 %1061, i32* @Inst_Counter, !dbg !5502
  %1062 = load i32, i32* @Inst_Counter, !dbg !5502
  call void @printCounter(i32 %1062), !dbg !5502
  %1063 = ptrtoint i8** %b.addr.i1743.i to i64, !dbg !5502
  call void @printLoadAddr(i64 %1063, i32 1130, i32 99, i32 23), !dbg !5502
  %1064 = load i8*, i8** %b.addr.i1743.i, align 8, !dbg !5502
  call void @printDDep(i32 1110, i32 1130), !dbg !5502
  call void @printDDep(i32 1110, i32 1130), !dbg !5502
  call void @printDDep(i32 1130, i32 1130), !dbg !5502
  %1065 = load i32, i32* @Inst_Counter, !dbg !5503
  %1066 = add i32 1, %1065, !dbg !5503
  store i32 %1066, i32* @Inst_Counter, !dbg !5503
  %1067 = load i32, i32* @Inst_Counter, !dbg !5503
  call void @printCounter(i32 %1067), !dbg !5503
  %1068 = ptrtoint i32* %n.addr.i1744.i to i64, !dbg !5503
  call void @printLoadAddr(i64 %1068, i32 1131, i32 99, i32 29), !dbg !5503
  %1069 = load i32, i32* %n.addr.i1744.i, align 4, !dbg !5503
  call void @printDDep(i32 1111, i32 1131), !dbg !5503
  call void @printDDep(i32 1111, i32 1131), !dbg !5503
  call void @printDDep(i32 1131, i32 1131), !dbg !5503
  %mul6.i1757.i = mul i32 4, %1069, !dbg !5504
  %add7.i1758.i = add i32 %mul6.i1757.i, 2, !dbg !5505
  %idxprom8.i1759.i = zext i32 %add7.i1758.i to i64, !dbg !5502
  %arrayidx9.i1760.i = getelementptr inbounds i8, i8* %1064, i64 %idxprom8.i1759.i, !dbg !5502
  %1070 = load i32, i32* @Inst_Counter, !dbg !5502
  %1071 = add i32 5, %1070, !dbg !5502
  store i32 %1071, i32* @Inst_Counter, !dbg !5502
  %1072 = load i32, i32* @Inst_Counter, !dbg !5502
  call void @printCounter(i32 %1072), !dbg !5502
  %1073 = ptrtoint i8* %arrayidx9.i1760.i to i64, !dbg !5502
  call void @printLoadAddr(i64 %1073, i32 1136, i32 99, i32 23), !dbg !5502
  %1074 = load i8, i8* %arrayidx9.i1760.i, align 1, !dbg !5502
  call void @printDDep(i32 1130, i32 1136), !dbg !5502
  call void @printDDep(i32 1131, i32 1136), !dbg !5502
  call void @printDDep(i32 1108, i32 1136), !dbg !5502
  call void @printDDep(i32 1136, i32 1136), !dbg !5502
  %conv10.i1761.i = zext i8 %1074 to i32, !dbg !5506
  %shl11.i1762.i = shl i32 %conv10.i1761.i, 8, !dbg !5507
  %or12.i1763.i = or i32 %or.i1756.i, %shl11.i1762.i, !dbg !5508
  %1075 = load i32, i32* @Inst_Counter, !dbg !5509
  %1076 = add i32 4, %1075, !dbg !5509
  store i32 %1076, i32* @Inst_Counter, !dbg !5509
  %1077 = load i32, i32* @Inst_Counter, !dbg !5509
  call void @printCounter(i32 %1077), !dbg !5509
  %1078 = ptrtoint i8** %b.addr.i1743.i to i64, !dbg !5509
  call void @printLoadAddr(i64 %1078, i32 1140, i32 100, i32 23), !dbg !5509
  %1079 = load i8*, i8** %b.addr.i1743.i, align 8, !dbg !5509
  call void @printDDep(i32 1110, i32 1140), !dbg !5509
  call void @printDDep(i32 1110, i32 1140), !dbg !5509
  call void @printDDep(i32 1140, i32 1140), !dbg !5509
  %1080 = load i32, i32* @Inst_Counter, !dbg !5510
  %1081 = add i32 1, %1080, !dbg !5510
  store i32 %1081, i32* @Inst_Counter, !dbg !5510
  %1082 = load i32, i32* @Inst_Counter, !dbg !5510
  call void @printCounter(i32 %1082), !dbg !5510
  %1083 = ptrtoint i32* %n.addr.i1744.i to i64, !dbg !5510
  call void @printLoadAddr(i64 %1083, i32 1141, i32 100, i32 29), !dbg !5510
  %1084 = load i32, i32* %n.addr.i1744.i, align 4, !dbg !5510
  call void @printDDep(i32 1111, i32 1141), !dbg !5510
  call void @printDDep(i32 1111, i32 1141), !dbg !5510
  call void @printDDep(i32 1141, i32 1141), !dbg !5510
  %mul13.i1764.i = mul i32 4, %1084, !dbg !5511
  %add14.i1765.i = add i32 %mul13.i1764.i, 3, !dbg !5512
  %idxprom15.i1766.i = zext i32 %add14.i1765.i to i64, !dbg !5509
  %arrayidx16.i1767.i = getelementptr inbounds i8, i8* %1079, i64 %idxprom15.i1766.i, !dbg !5509
  %1085 = load i32, i32* @Inst_Counter, !dbg !5509
  %1086 = add i32 5, %1085, !dbg !5509
  store i32 %1086, i32* @Inst_Counter, !dbg !5509
  %1087 = load i32, i32* @Inst_Counter, !dbg !5509
  call void @printCounter(i32 %1087), !dbg !5509
  %1088 = ptrtoint i8* %arrayidx16.i1767.i to i64, !dbg !5509
  call void @printLoadAddr(i64 %1088, i32 1146, i32 100, i32 23), !dbg !5509
  %1089 = load i8, i8* %arrayidx16.i1767.i, align 1, !dbg !5509
  call void @printDDep(i32 1140, i32 1146), !dbg !5509
  call void @printDDep(i32 1141, i32 1146), !dbg !5509
  call void @printDDep(i32 1108, i32 1146), !dbg !5509
  call void @printDDep(i32 1146, i32 1146), !dbg !5509
  %conv17.i1768.i = zext i8 %1089 to i32, !dbg !5513
  %or18.i1769.i = or i32 %or12.i1763.i, %conv17.i1768.i, !dbg !5514
  %1090 = load i32, i32* @Inst_Counter, !dbg !5090
  %1091 = add i32 3, %1090, !dbg !5090
  store i32 %1091, i32* @Inst_Counter, !dbg !5090
  %1092 = load i32, i32* @Inst_Counter, !dbg !5090
  call void @printCounter(i32 %1092), !dbg !5090
  %1093 = ptrtoint i32* %B3.i to i64, !dbg !5090
  call void @printStoreAddr(i64 %1093, i32 1149, i32 194, i32 14), !dbg !5090
  store i32 %or18.i1769.i, i32* %B3.i, align 4, !dbg !5090
  call void @printDDep(i32 1117, i32 1149), !dbg !5090
  call void @printDDep(i32 1126, i32 1149), !dbg !5090
  call void @printDDep(i32 1136, i32 1149), !dbg !5090
  call void @printDDep(i32 1146, i32 1149), !dbg !5090
  call void @printDDep(i32 1149, i32 1149), !dbg !5090
  call void @printDDep(i32 1605, i32 1149), !dbg !5090
  call void @printDDep(i32 1909, i32 1149), !dbg !5090
  call void @printDDep(i32 2213, i32 1149), !dbg !5090
  call void @printDDep(i32 2517, i32 1149), !dbg !5090
  call void @printDDep(i32 2821, i32 1149), !dbg !5090
  call void @printDDep(i32 3125, i32 1149), !dbg !5090
  call void @printDDep(i32 3429, i32 1149), !dbg !5090
  call void @printDDep(i32 3885, i32 1149), !dbg !5090
  call void @printDDep(i32 1111, i32 1149), !dbg !5090
  call void @printDDep(i32 1149, i32 1149), !dbg !5090
  %1094 = load i32, i32* @Inst_Counter, !dbg !5515
  %1095 = add i32 1, %1094, !dbg !5515
  store i32 %1095, i32* @Inst_Counter, !dbg !5515
  %1096 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1096), !dbg !5515
  %1097 = ptrtoint i32* %B1.i to i64, !dbg !5515
  call void @printLoadAddr(i64 %1097, i32 1150, i32 200, i32 5), !dbg !5515
  %1098 = load i32, i32* %B1.i, align 4, !dbg !5515
  call void @printDDep(i32 1067, i32 1150), !dbg !5515
  call void @printDDep(i32 1377, i32 1150), !dbg !5515
  call void @printDDep(i32 1757, i32 1150), !dbg !5515
  call void @printDDep(i32 2061, i32 1150), !dbg !5515
  call void @printDDep(i32 2365, i32 1150), !dbg !5515
  call void @printDDep(i32 2669, i32 1150), !dbg !5515
  call void @printDDep(i32 2973, i32 1150), !dbg !5515
  call void @printDDep(i32 3277, i32 1150), !dbg !5515
  call void @printDDep(i32 3657, i32 1150), !dbg !5515
  call void @printDDep(i32 1067, i32 1150), !dbg !5515
  call void @printDDep(i32 1150, i32 1150), !dbg !5515
  %1099 = load i32, i32* @Inst_Counter, !dbg !5515
  %1100 = add i32 1, %1099, !dbg !5515
  store i32 %1100, i32* @Inst_Counter, !dbg !5515
  %1101 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1101), !dbg !5515
  %1102 = ptrtoint i32* %B2.i to i64, !dbg !5515
  call void @printLoadAddr(i64 %1102, i32 1151, i32 200, i32 5), !dbg !5515
  %1103 = load i32, i32* %B2.i, align 4, !dbg !5515
  call void @printDDep(i32 1108, i32 1151), !dbg !5515
  call void @printDDep(i32 1491, i32 1151), !dbg !5515
  call void @printDDep(i32 1833, i32 1151), !dbg !5515
  call void @printDDep(i32 2137, i32 1151), !dbg !5515
  call void @printDDep(i32 2441, i32 1151), !dbg !5515
  call void @printDDep(i32 2745, i32 1151), !dbg !5515
  call void @printDDep(i32 3049, i32 1151), !dbg !5515
  call void @printDDep(i32 3353, i32 1151), !dbg !5515
  call void @printDDep(i32 3771, i32 1151), !dbg !5515
  call void @printDDep(i32 1108, i32 1151), !dbg !5515
  call void @printDDep(i32 1151, i32 1151), !dbg !5515
  %xor.i50 = xor i32 %1098, %1103, !dbg !5515
  %1104 = load i32, i32* @Inst_Counter, !dbg !5515
  %1105 = add i32 2, %1104, !dbg !5515
  store i32 %1105, i32* @Inst_Counter, !dbg !5515
  %1106 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1106), !dbg !5515
  %1107 = ptrtoint i32* %B3.i to i64, !dbg !5515
  call void @printLoadAddr(i64 %1107, i32 1153, i32 200, i32 5), !dbg !5515
  %1108 = load i32, i32* %B3.i, align 4, !dbg !5515
  call void @printDDep(i32 1149, i32 1153), !dbg !5515
  call void @printDDep(i32 1605, i32 1153), !dbg !5515
  call void @printDDep(i32 1909, i32 1153), !dbg !5515
  call void @printDDep(i32 2213, i32 1153), !dbg !5515
  call void @printDDep(i32 2517, i32 1153), !dbg !5515
  call void @printDDep(i32 2821, i32 1153), !dbg !5515
  call void @printDDep(i32 3125, i32 1153), !dbg !5515
  call void @printDDep(i32 3429, i32 1153), !dbg !5515
  call void @printDDep(i32 3885, i32 1153), !dbg !5515
  call void @printDDep(i32 1149, i32 1153), !dbg !5515
  call void @printDDep(i32 1153, i32 1153), !dbg !5515
  %xor5.i51 = xor i32 %xor.i50, %1108, !dbg !5515
  %1109 = load i32, i32* @Inst_Counter, !dbg !5515
  %1110 = add i32 2, %1109, !dbg !5515
  store i32 %1110, i32* @Inst_Counter, !dbg !5515
  %1111 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1111), !dbg !5515
  %1112 = ptrtoint %struct.SM4_KEY_st** %ks.addr.i24 to i64, !dbg !5515
  call void @printLoadAddr(i64 %1112, i32 1155, i32 200, i32 5), !dbg !5515
  %1113 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr.i24, align 8, !dbg !5515
  call void @printDDep(i32 983, i32 1155), !dbg !5515
  call void @printDDep(i32 985, i32 1155), !dbg !5515
  call void @printDDep(i32 1155, i32 1155), !dbg !5515
  %rk.i52 = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %1113, i32 0, i32 0, !dbg !5515
  %arrayidx.i53 = getelementptr inbounds [32 x i32], [32 x i32]* %rk.i52, i64 0, i64 0, !dbg !5515
  %1114 = load i32, i32* @Inst_Counter, !dbg !5515
  %1115 = add i32 3, %1114, !dbg !5515
  store i32 %1115, i32* @Inst_Counter, !dbg !5515
  %1116 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1116), !dbg !5515
  %1117 = ptrtoint i32* %arrayidx.i53 to i64, !dbg !5515
  call void @printLoadAddr(i64 %1117, i32 1158, i32 200, i32 5), !dbg !5515
  %1118 = load i32, i32* %arrayidx.i53, align 4, !dbg !5515
  call void @printDDep(i32 1155, i32 1158), !dbg !5515
  call void @printDDep(i32 1149, i32 1158), !dbg !5515
  call void @printDDep(i32 1158, i32 1158), !dbg !5515
  %xor6.i = xor i32 %xor5.i51, %1118, !dbg !5515
  %1119 = load i32, i32* @Inst_Counter
  %1120 = add i32 2, %1119
  store i32 %1120, i32* @Inst_Counter
  %1121 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1121)
  %1122 = ptrtoint i32* %X.addr.i1687.i to i64
  call void @printStoreAddr(i64 %1122, i32 1160, i32 0, i32 0)
  store i32 %xor6.i, i32* %X.addr.i1687.i, align 4
  call void @printDDep(i32 1150, i32 1160)
  call void @printDDep(i32 1151, i32 1160)
  call void @printDDep(i32 1153, i32 1160)
  call void @printDDep(i32 1158, i32 1160)
  call void @printDDep(i32 1160, i32 1160)
  call void @printDDep(i32 1149, i32 1160)
  call void @printDDep(i32 1160, i32 1160)
  %1123 = load i32, i32* @Inst_Counter, !dbg !4699
  %1124 = add i32 1, %1123, !dbg !4699
  store i32 %1124, i32* @Inst_Counter, !dbg !4699
  %1125 = load i32, i32* @Inst_Counter, !dbg !4699
  call void @printCounter(i32 %1125), !dbg !4699
  %1126 = ptrtoint i32* %t.i1688.i to i64, !dbg !4699
  call void @printStoreAddr(i64 %1126, i32 1161, i32 113, i32 14), !dbg !4699
  store i32 0, i32* %t.i1688.i, align 4, !dbg !4699
  call void @printDDep(i32 1161, i32 1161), !dbg !4699
  call void @printDDep(i32 1172, i32 1161), !dbg !4699
  call void @printDDep(i32 1183, i32 1161), !dbg !4699
  call void @printDDep(i32 1194, i32 1161), !dbg !4699
  call void @printDDep(i32 1203, i32 1161), !dbg !4699
  call void @printDDep(i32 1160, i32 1161), !dbg !4699
  call void @printDDep(i32 1161, i32 1161), !dbg !4699
  %1127 = load i32, i32* @Inst_Counter, !dbg !5516
  %1128 = add i32 1, %1127, !dbg !5516
  store i32 %1128, i32* @Inst_Counter, !dbg !5516
  %1129 = load i32, i32* @Inst_Counter, !dbg !5516
  call void @printCounter(i32 %1129), !dbg !5516
  %1130 = ptrtoint i32* %X.addr.i1687.i to i64, !dbg !5516
  call void @printLoadAddr(i64 %1130, i32 1162, i32 115, i32 37), !dbg !5516
  %1131 = load i32, i32* %X.addr.i1687.i, align 4, !dbg !5516
  call void @printDDep(i32 1160, i32 1162), !dbg !5516
  call void @printDDep(i32 1160, i32 1162), !dbg !5516
  call void @printDDep(i32 1162, i32 1162), !dbg !5516
  %shr.i1689.i = lshr i32 %1131, 24, !dbg !5517
  %conv.i1690.i = trunc i32 %shr.i1689.i to i8, !dbg !5518
  %idxprom.i1691.i = zext i8 %conv.i1690.i to i64, !dbg !5519
  %arrayidx.i1692.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom.i1691.i, !dbg !5519
  %1132 = load i32, i32* @Inst_Counter, !dbg !5519
  %1133 = add i32 5, %1132, !dbg !5519
  store i32 %1133, i32* @Inst_Counter, !dbg !5519
  %1134 = load i32, i32* @Inst_Counter, !dbg !5519
  call void @printCounter(i32 %1134), !dbg !5519
  %1135 = ptrtoint i8* %arrayidx.i1692.i to i64, !dbg !5519
  %1136 = load [256 x i8], [256 x i8]* @SM4_S, !dbg !5519
  call void @printSymLoadAddr(i64 %1135, i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 add (i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 255), i32 1, i32 1167, i32 115, i32 21), !dbg !5519
  %1137 = load i8, i8* %arrayidx.i1692.i, align 1, !dbg !5519
  call void @printDDep(i32 1162, i32 1167), !dbg !5519
  call void @printDDep(i32 1167, i32 1167), !dbg !5519
  %conv1.i1693.i = zext i8 %1137 to i32, !dbg !5520
  %shl.i1694.i = shl i32 %conv1.i1693.i, 24, !dbg !5521
  %1138 = load i32, i32* @Inst_Counter, !dbg !5522
  %1139 = add i32 3, %1138, !dbg !5522
  store i32 %1139, i32* @Inst_Counter, !dbg !5522
  %1140 = load i32, i32* @Inst_Counter, !dbg !5522
  call void @printCounter(i32 %1140), !dbg !5522
  %1141 = ptrtoint i32* %t.i1688.i to i64, !dbg !5522
  call void @printLoadAddr(i64 %1141, i32 1170, i32 115, i32 7), !dbg !5522
  %1142 = load i32, i32* %t.i1688.i, align 4, !dbg !5522
  call void @printDDep(i32 1161, i32 1170), !dbg !5522
  call void @printDDep(i32 1172, i32 1170), !dbg !5522
  call void @printDDep(i32 1183, i32 1170), !dbg !5522
  call void @printDDep(i32 1194, i32 1170), !dbg !5522
  call void @printDDep(i32 1203, i32 1170), !dbg !5522
  call void @printDDep(i32 1161, i32 1170), !dbg !5522
  call void @printDDep(i32 1170, i32 1170), !dbg !5522
  %or.i1695.i = or i32 %1142, %shl.i1694.i, !dbg !5522
  %1143 = load i32, i32* @Inst_Counter, !dbg !5522
  %1144 = add i32 2, %1143, !dbg !5522
  store i32 %1144, i32* @Inst_Counter, !dbg !5522
  %1145 = load i32, i32* @Inst_Counter, !dbg !5522
  call void @printCounter(i32 %1145), !dbg !5522
  %1146 = ptrtoint i32* %t.i1688.i to i64, !dbg !5522
  call void @printStoreAddr(i64 %1146, i32 1172, i32 115, i32 7), !dbg !5522
  store i32 %or.i1695.i, i32* %t.i1688.i, align 4, !dbg !5522
  call void @printDDep(i32 1161, i32 1172), !dbg !5522
  call void @printDDep(i32 1167, i32 1172), !dbg !5522
  call void @printDDep(i32 1170, i32 1172), !dbg !5522
  call void @printDDep(i32 1172, i32 1172), !dbg !5522
  call void @printDDep(i32 1183, i32 1172), !dbg !5522
  call void @printDDep(i32 1194, i32 1172), !dbg !5522
  call void @printDDep(i32 1203, i32 1172), !dbg !5522
  call void @printDDep(i32 1161, i32 1172), !dbg !5522
  call void @printDDep(i32 1172, i32 1172), !dbg !5522
  %1147 = load i32, i32* @Inst_Counter, !dbg !5523
  %1148 = add i32 1, %1147, !dbg !5523
  store i32 %1148, i32* @Inst_Counter, !dbg !5523
  %1149 = load i32, i32* @Inst_Counter, !dbg !5523
  call void @printCounter(i32 %1149), !dbg !5523
  %1150 = ptrtoint i32* %X.addr.i1687.i to i64, !dbg !5523
  call void @printLoadAddr(i64 %1150, i32 1173, i32 116, i32 37), !dbg !5523
  %1151 = load i32, i32* %X.addr.i1687.i, align 4, !dbg !5523
  call void @printDDep(i32 1160, i32 1173), !dbg !5523
  call void @printDDep(i32 1160, i32 1173), !dbg !5523
  call void @printDDep(i32 1173, i32 1173), !dbg !5523
  %shr2.i1696.i = lshr i32 %1151, 16, !dbg !5524
  %conv3.i1697.i = trunc i32 %shr2.i1696.i to i8, !dbg !5525
  %idxprom4.i1698.i = zext i8 %conv3.i1697.i to i64, !dbg !5526
  %arrayidx5.i1699.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom4.i1698.i, !dbg !5526
  %1152 = load i32, i32* @Inst_Counter, !dbg !5526
  %1153 = add i32 5, %1152, !dbg !5526
  store i32 %1153, i32* @Inst_Counter, !dbg !5526
  %1154 = load i32, i32* @Inst_Counter, !dbg !5526
  call void @printCounter(i32 %1154), !dbg !5526
  %1155 = ptrtoint i8* %arrayidx5.i1699.i to i64, !dbg !5526
  %1156 = load [256 x i8], [256 x i8]* @SM4_S, !dbg !5526
  call void @printSymLoadAddr(i64 %1155, i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 add (i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 255), i32 1, i32 1178, i32 116, i32 21), !dbg !5526
  %1157 = load i8, i8* %arrayidx5.i1699.i, align 1, !dbg !5526
  call void @printDDep(i32 1173, i32 1178), !dbg !5526
  call void @printDDep(i32 1178, i32 1178), !dbg !5526
  %conv6.i1700.i = zext i8 %1157 to i32, !dbg !5527
  %shl7.i1701.i = shl i32 %conv6.i1700.i, 16, !dbg !5528
  %1158 = load i32, i32* @Inst_Counter, !dbg !5529
  %1159 = add i32 3, %1158, !dbg !5529
  store i32 %1159, i32* @Inst_Counter, !dbg !5529
  %1160 = load i32, i32* @Inst_Counter, !dbg !5529
  call void @printCounter(i32 %1160), !dbg !5529
  %1161 = ptrtoint i32* %t.i1688.i to i64, !dbg !5529
  call void @printLoadAddr(i64 %1161, i32 1181, i32 116, i32 7), !dbg !5529
  %1162 = load i32, i32* %t.i1688.i, align 4, !dbg !5529
  call void @printDDep(i32 1161, i32 1181), !dbg !5529
  call void @printDDep(i32 1172, i32 1181), !dbg !5529
  call void @printDDep(i32 1183, i32 1181), !dbg !5529
  call void @printDDep(i32 1194, i32 1181), !dbg !5529
  call void @printDDep(i32 1203, i32 1181), !dbg !5529
  call void @printDDep(i32 1172, i32 1181), !dbg !5529
  call void @printDDep(i32 1181, i32 1181), !dbg !5529
  %or8.i1702.i = or i32 %1162, %shl7.i1701.i, !dbg !5529
  %1163 = load i32, i32* @Inst_Counter, !dbg !5529
  %1164 = add i32 2, %1163, !dbg !5529
  store i32 %1164, i32* @Inst_Counter, !dbg !5529
  %1165 = load i32, i32* @Inst_Counter, !dbg !5529
  call void @printCounter(i32 %1165), !dbg !5529
  %1166 = ptrtoint i32* %t.i1688.i to i64, !dbg !5529
  call void @printStoreAddr(i64 %1166, i32 1183, i32 116, i32 7), !dbg !5529
  store i32 %or8.i1702.i, i32* %t.i1688.i, align 4, !dbg !5529
  call void @printDDep(i32 1161, i32 1183), !dbg !5529
  call void @printDDep(i32 1172, i32 1183), !dbg !5529
  call void @printDDep(i32 1178, i32 1183), !dbg !5529
  call void @printDDep(i32 1181, i32 1183), !dbg !5529
  call void @printDDep(i32 1183, i32 1183), !dbg !5529
  call void @printDDep(i32 1194, i32 1183), !dbg !5529
  call void @printDDep(i32 1203, i32 1183), !dbg !5529
  call void @printDDep(i32 1172, i32 1183), !dbg !5529
  call void @printDDep(i32 1183, i32 1183), !dbg !5529
  %1167 = load i32, i32* @Inst_Counter, !dbg !5530
  %1168 = add i32 1, %1167, !dbg !5530
  store i32 %1168, i32* @Inst_Counter, !dbg !5530
  %1169 = load i32, i32* @Inst_Counter, !dbg !5530
  call void @printCounter(i32 %1169), !dbg !5530
  %1170 = ptrtoint i32* %X.addr.i1687.i to i64, !dbg !5530
  call void @printLoadAddr(i64 %1170, i32 1184, i32 117, i32 37), !dbg !5530
  %1171 = load i32, i32* %X.addr.i1687.i, align 4, !dbg !5530
  call void @printDDep(i32 1160, i32 1184), !dbg !5530
  call void @printDDep(i32 1160, i32 1184), !dbg !5530
  call void @printDDep(i32 1184, i32 1184), !dbg !5530
  %shr9.i1703.i = lshr i32 %1171, 8, !dbg !5531
  %conv10.i1704.i = trunc i32 %shr9.i1703.i to i8, !dbg !5532
  %idxprom11.i1705.i = zext i8 %conv10.i1704.i to i64, !dbg !5533
  %arrayidx12.i1706.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom11.i1705.i, !dbg !5533
  %1172 = load i32, i32* @Inst_Counter, !dbg !5533
  %1173 = add i32 5, %1172, !dbg !5533
  store i32 %1173, i32* @Inst_Counter, !dbg !5533
  %1174 = load i32, i32* @Inst_Counter, !dbg !5533
  call void @printCounter(i32 %1174), !dbg !5533
  %1175 = ptrtoint i8* %arrayidx12.i1706.i to i64, !dbg !5533
  %1176 = load [256 x i8], [256 x i8]* @SM4_S, !dbg !5533
  call void @printSymLoadAddr(i64 %1175, i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 add (i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 255), i32 1, i32 1189, i32 117, i32 21), !dbg !5533
  %1177 = load i8, i8* %arrayidx12.i1706.i, align 1, !dbg !5533
  call void @printDDep(i32 1184, i32 1189), !dbg !5533
  call void @printDDep(i32 1189, i32 1189), !dbg !5533
  %conv13.i1707.i = zext i8 %1177 to i32, !dbg !5534
  %shl14.i1708.i = shl i32 %conv13.i1707.i, 8, !dbg !5535
  %1178 = load i32, i32* @Inst_Counter, !dbg !5536
  %1179 = add i32 3, %1178, !dbg !5536
  store i32 %1179, i32* @Inst_Counter, !dbg !5536
  %1180 = load i32, i32* @Inst_Counter, !dbg !5536
  call void @printCounter(i32 %1180), !dbg !5536
  %1181 = ptrtoint i32* %t.i1688.i to i64, !dbg !5536
  call void @printLoadAddr(i64 %1181, i32 1192, i32 117, i32 7), !dbg !5536
  %1182 = load i32, i32* %t.i1688.i, align 4, !dbg !5536
  call void @printDDep(i32 1161, i32 1192), !dbg !5536
  call void @printDDep(i32 1172, i32 1192), !dbg !5536
  call void @printDDep(i32 1183, i32 1192), !dbg !5536
  call void @printDDep(i32 1194, i32 1192), !dbg !5536
  call void @printDDep(i32 1203, i32 1192), !dbg !5536
  call void @printDDep(i32 1183, i32 1192), !dbg !5536
  call void @printDDep(i32 1192, i32 1192), !dbg !5536
  %or15.i1709.i = or i32 %1182, %shl14.i1708.i, !dbg !5536
  %1183 = load i32, i32* @Inst_Counter, !dbg !5536
  %1184 = add i32 2, %1183, !dbg !5536
  store i32 %1184, i32* @Inst_Counter, !dbg !5536
  %1185 = load i32, i32* @Inst_Counter, !dbg !5536
  call void @printCounter(i32 %1185), !dbg !5536
  %1186 = ptrtoint i32* %t.i1688.i to i64, !dbg !5536
  call void @printStoreAddr(i64 %1186, i32 1194, i32 117, i32 7), !dbg !5536
  store i32 %or15.i1709.i, i32* %t.i1688.i, align 4, !dbg !5536
  call void @printDDep(i32 1161, i32 1194), !dbg !5536
  call void @printDDep(i32 1172, i32 1194), !dbg !5536
  call void @printDDep(i32 1183, i32 1194), !dbg !5536
  call void @printDDep(i32 1189, i32 1194), !dbg !5536
  call void @printDDep(i32 1192, i32 1194), !dbg !5536
  call void @printDDep(i32 1194, i32 1194), !dbg !5536
  call void @printDDep(i32 1203, i32 1194), !dbg !5536
  call void @printDDep(i32 1183, i32 1194), !dbg !5536
  call void @printDDep(i32 1194, i32 1194), !dbg !5536
  %1187 = load i32, i32* @Inst_Counter, !dbg !5537
  %1188 = add i32 1, %1187, !dbg !5537
  store i32 %1188, i32* @Inst_Counter, !dbg !5537
  %1189 = load i32, i32* @Inst_Counter, !dbg !5537
  call void @printCounter(i32 %1189), !dbg !5537
  %1190 = ptrtoint i32* %X.addr.i1687.i to i64, !dbg !5537
  call void @printLoadAddr(i64 %1190, i32 1195, i32 118, i32 25), !dbg !5537
  %1191 = load i32, i32* %X.addr.i1687.i, align 4, !dbg !5537
  call void @printDDep(i32 1160, i32 1195), !dbg !5537
  call void @printDDep(i32 1160, i32 1195), !dbg !5537
  call void @printDDep(i32 1195, i32 1195), !dbg !5537
  %conv16.i1710.i = trunc i32 %1191 to i8, !dbg !5538
  %idxprom17.i1711.i = zext i8 %conv16.i1710.i to i64, !dbg !5539
  %arrayidx18.i1712.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom17.i1711.i, !dbg !5539
  %1192 = load i32, i32* @Inst_Counter, !dbg !5539
  %1193 = add i32 4, %1192, !dbg !5539
  store i32 %1193, i32* @Inst_Counter, !dbg !5539
  %1194 = load i32, i32* @Inst_Counter, !dbg !5539
  call void @printCounter(i32 %1194), !dbg !5539
  %1195 = ptrtoint i8* %arrayidx18.i1712.i to i64, !dbg !5539
  %1196 = load [256 x i8], [256 x i8]* @SM4_S, !dbg !5539
  call void @printSymLoadAddr(i64 %1195, i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 add (i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 255), i32 1, i32 1199, i32 118, i32 10), !dbg !5539
  %1197 = load i8, i8* %arrayidx18.i1712.i, align 1, !dbg !5539
  call void @printDDep(i32 1195, i32 1199), !dbg !5539
  call void @printDDep(i32 1199, i32 1199), !dbg !5539
  %conv19.i1713.i = zext i8 %1197 to i32, !dbg !5539
  %1198 = load i32, i32* @Inst_Counter, !dbg !5540
  %1199 = add i32 2, %1198, !dbg !5540
  store i32 %1199, i32* @Inst_Counter, !dbg !5540
  %1200 = load i32, i32* @Inst_Counter, !dbg !5540
  call void @printCounter(i32 %1200), !dbg !5540
  %1201 = ptrtoint i32* %t.i1688.i to i64, !dbg !5540
  call void @printLoadAddr(i64 %1201, i32 1201, i32 118, i32 7), !dbg !5540
  %1202 = load i32, i32* %t.i1688.i, align 4, !dbg !5540
  call void @printDDep(i32 1161, i32 1201), !dbg !5540
  call void @printDDep(i32 1172, i32 1201), !dbg !5540
  call void @printDDep(i32 1183, i32 1201), !dbg !5540
  call void @printDDep(i32 1194, i32 1201), !dbg !5540
  call void @printDDep(i32 1203, i32 1201), !dbg !5540
  call void @printDDep(i32 1194, i32 1201), !dbg !5540
  call void @printDDep(i32 1201, i32 1201), !dbg !5540
  %or20.i1714.i = or i32 %1202, %conv19.i1713.i, !dbg !5540
  %1203 = load i32, i32* @Inst_Counter, !dbg !5540
  %1204 = add i32 2, %1203, !dbg !5540
  store i32 %1204, i32* @Inst_Counter, !dbg !5540
  %1205 = load i32, i32* @Inst_Counter, !dbg !5540
  call void @printCounter(i32 %1205), !dbg !5540
  %1206 = ptrtoint i32* %t.i1688.i to i64, !dbg !5540
  call void @printStoreAddr(i64 %1206, i32 1203, i32 118, i32 7), !dbg !5540
  store i32 %or20.i1714.i, i32* %t.i1688.i, align 4, !dbg !5540
  call void @printDDep(i32 1161, i32 1203), !dbg !5540
  call void @printDDep(i32 1172, i32 1203), !dbg !5540
  call void @printDDep(i32 1183, i32 1203), !dbg !5540
  call void @printDDep(i32 1194, i32 1203), !dbg !5540
  call void @printDDep(i32 1199, i32 1203), !dbg !5540
  call void @printDDep(i32 1201, i32 1203), !dbg !5540
  call void @printDDep(i32 1203, i32 1203), !dbg !5540
  call void @printDDep(i32 1194, i32 1203), !dbg !5540
  call void @printDDep(i32 1203, i32 1203), !dbg !5540
  %1207 = load i32, i32* @Inst_Counter, !dbg !5541
  %1208 = add i32 1, %1207, !dbg !5541
  store i32 %1208, i32* @Inst_Counter, !dbg !5541
  %1209 = load i32, i32* @Inst_Counter, !dbg !5541
  call void @printCounter(i32 %1209), !dbg !5541
  %1210 = ptrtoint i32* %t.i1688.i to i64, !dbg !5541
  call void @printLoadAddr(i64 %1210, i32 1204, i32 123, i32 12), !dbg !5541
  %1211 = load i32, i32* %t.i1688.i, align 4, !dbg !5541
  call void @printDDep(i32 1161, i32 1204), !dbg !5541
  call void @printDDep(i32 1172, i32 1204), !dbg !5541
  call void @printDDep(i32 1183, i32 1204), !dbg !5541
  call void @printDDep(i32 1194, i32 1204), !dbg !5541
  call void @printDDep(i32 1203, i32 1204), !dbg !5541
  call void @printDDep(i32 1203, i32 1204), !dbg !5541
  call void @printDDep(i32 1204, i32 1204), !dbg !5541
  %1212 = load i32, i32* @Inst_Counter, !dbg !5542
  %1213 = add i32 1, %1212, !dbg !5542
  store i32 %1213, i32* @Inst_Counter, !dbg !5542
  %1214 = load i32, i32* @Inst_Counter, !dbg !5542
  call void @printCounter(i32 %1214), !dbg !5542
  %1215 = ptrtoint i32* %t.i1688.i to i64, !dbg !5542
  call void @printLoadAddr(i64 %1215, i32 1205, i32 123, i32 21), !dbg !5542
  %1216 = load i32, i32* %t.i1688.i, align 4, !dbg !5542
  call void @printDDep(i32 1161, i32 1205), !dbg !5542
  call void @printDDep(i32 1172, i32 1205), !dbg !5542
  call void @printDDep(i32 1183, i32 1205), !dbg !5542
  call void @printDDep(i32 1194, i32 1205), !dbg !5542
  call void @printDDep(i32 1203, i32 1205), !dbg !5542
  call void @printDDep(i32 1203, i32 1205), !dbg !5542
  call void @printDDep(i32 1205, i32 1205), !dbg !5542
  %1217 = load i32, i32* @Inst_Counter
  %1218 = add i32 1, %1217
  store i32 %1218, i32* @Inst_Counter
  %1219 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1219)
  %1220 = ptrtoint i32* %a.addr.i.i1685.i to i64
  call void @printStoreAddr(i64 %1220, i32 1206, i32 0, i32 0)
  store i32 %1216, i32* %a.addr.i.i1685.i, align 4
  call void @printDDep(i32 1205, i32 1206)
  call void @printDDep(i32 1206, i32 1206)
  call void @printDDep(i32 1203, i32 1206)
  call void @printDDep(i32 1206, i32 1206)
  %1221 = load i32, i32* @Inst_Counter
  %1222 = add i32 1, %1221
  store i32 %1222, i32* @Inst_Counter
  %1223 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1223)
  %1224 = ptrtoint i8* %n.addr.i.i1686.i to i64
  call void @printStoreAddr(i64 %1224, i32 1207, i32 0, i32 0)
  store i8 2, i8* %n.addr.i.i1686.i, align 1
  call void @printDDep(i32 1207, i32 1207)
  call void @printDDep(i32 1206, i32 1207)
  call void @printDDep(i32 1207, i32 1207)
  %1225 = load i32, i32* @Inst_Counter, !dbg !5543
  %1226 = add i32 1, %1225, !dbg !5543
  store i32 %1226, i32* @Inst_Counter, !dbg !5543
  %1227 = load i32, i32* @Inst_Counter, !dbg !5543
  call void @printCounter(i32 %1227), !dbg !5543
  %1228 = ptrtoint i32* %a.addr.i.i1685.i to i64, !dbg !5543
  call void @printLoadAddr(i64 %1228, i32 1208, i32 92, i32 13), !dbg !5543
  %1229 = load i32, i32* %a.addr.i.i1685.i, align 4, !dbg !5543
  call void @printDDep(i32 1206, i32 1208), !dbg !5543
  call void @printDDep(i32 1206, i32 1208), !dbg !5543
  call void @printDDep(i32 1208, i32 1208), !dbg !5543
  %1230 = load i32, i32* @Inst_Counter, !dbg !5544
  %1231 = add i32 1, %1230, !dbg !5544
  store i32 %1231, i32* @Inst_Counter, !dbg !5544
  %1232 = load i32, i32* @Inst_Counter, !dbg !5544
  call void @printCounter(i32 %1232), !dbg !5544
  %1233 = ptrtoint i8* %n.addr.i.i1686.i to i64, !dbg !5544
  call void @printLoadAddr(i64 %1233, i32 1209, i32 92, i32 18), !dbg !5544
  %1234 = load i8, i8* %n.addr.i.i1686.i, align 1, !dbg !5544
  call void @printDDep(i32 1207, i32 1209), !dbg !5544
  call void @printDDep(i32 1207, i32 1209), !dbg !5544
  call void @printDDep(i32 1209, i32 1209), !dbg !5544
  %conv.i.i1715.i = zext i8 %1234 to i32, !dbg !5544
  %shl.i.i1716.i = shl i32 %1229, %conv.i.i1715.i, !dbg !5545
  %1235 = load i32, i32* @Inst_Counter, !dbg !5546
  %1236 = add i32 3, %1235, !dbg !5546
  store i32 %1236, i32* @Inst_Counter, !dbg !5546
  %1237 = load i32, i32* @Inst_Counter, !dbg !5546
  call void @printCounter(i32 %1237), !dbg !5546
  %1238 = ptrtoint i32* %a.addr.i.i1685.i to i64, !dbg !5546
  call void @printLoadAddr(i64 %1238, i32 1212, i32 92, i32 24), !dbg !5546
  %1239 = load i32, i32* %a.addr.i.i1685.i, align 4, !dbg !5546
  call void @printDDep(i32 1206, i32 1212), !dbg !5546
  call void @printDDep(i32 1206, i32 1212), !dbg !5546
  call void @printDDep(i32 1212, i32 1212), !dbg !5546
  %1240 = load i32, i32* @Inst_Counter, !dbg !5547
  %1241 = add i32 1, %1240, !dbg !5547
  store i32 %1241, i32* @Inst_Counter, !dbg !5547
  %1242 = load i32, i32* @Inst_Counter, !dbg !5547
  call void @printCounter(i32 %1242), !dbg !5547
  %1243 = ptrtoint i8* %n.addr.i.i1686.i to i64, !dbg !5547
  call void @printLoadAddr(i64 %1243, i32 1213, i32 92, i32 35), !dbg !5547
  %1244 = load i8, i8* %n.addr.i.i1686.i, align 1, !dbg !5547
  call void @printDDep(i32 1207, i32 1213), !dbg !5547
  call void @printDDep(i32 1207, i32 1213), !dbg !5547
  call void @printDDep(i32 1213, i32 1213), !dbg !5547
  %conv1.i.i1717.i = zext i8 %1244 to i32, !dbg !5547
  %sub.i.i1718.i = sub nsw i32 32, %conv1.i.i1717.i, !dbg !5548
  %shr.i.i1719.i = lshr i32 %1239, %sub.i.i1718.i, !dbg !5549
  %or.i.i1720.i = or i32 %shl.i.i1716.i, %shr.i.i1719.i, !dbg !5550
  %xor.i1721.i = xor i32 %1211, %or.i.i1720.i, !dbg !5551
  %1245 = load i32, i32* @Inst_Counter, !dbg !5552
  %1246 = add i32 6, %1245, !dbg !5552
  store i32 %1246, i32* @Inst_Counter, !dbg !5552
  %1247 = load i32, i32* @Inst_Counter, !dbg !5552
  call void @printCounter(i32 %1247), !dbg !5552
  %1248 = ptrtoint i32* %t.i1688.i to i64, !dbg !5552
  call void @printLoadAddr(i64 %1248, i32 1219, i32 123, i32 34), !dbg !5552
  %1249 = load i32, i32* %t.i1688.i, align 4, !dbg !5552
  call void @printDDep(i32 1161, i32 1219), !dbg !5552
  call void @printDDep(i32 1172, i32 1219), !dbg !5552
  call void @printDDep(i32 1183, i32 1219), !dbg !5552
  call void @printDDep(i32 1194, i32 1219), !dbg !5552
  call void @printDDep(i32 1203, i32 1219), !dbg !5552
  call void @printDDep(i32 1203, i32 1219), !dbg !5552
  call void @printDDep(i32 1219, i32 1219), !dbg !5552
  %1250 = load i32, i32* @Inst_Counter
  %1251 = add i32 1, %1250
  store i32 %1251, i32* @Inst_Counter
  %1252 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1252)
  %1253 = ptrtoint i32* %a.addr.i43.i1679.i to i64
  call void @printStoreAddr(i64 %1253, i32 1220, i32 0, i32 0)
  store i32 %1249, i32* %a.addr.i43.i1679.i, align 4
  call void @printDDep(i32 1219, i32 1220)
  call void @printDDep(i32 1220, i32 1220)
  call void @printDDep(i32 1207, i32 1220)
  call void @printDDep(i32 1220, i32 1220)
  %1254 = load i32, i32* @Inst_Counter
  %1255 = add i32 1, %1254
  store i32 %1255, i32* @Inst_Counter
  %1256 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1256)
  %1257 = ptrtoint i8* %n.addr.i44.i1680.i to i64
  call void @printStoreAddr(i64 %1257, i32 1221, i32 0, i32 0)
  store i8 10, i8* %n.addr.i44.i1680.i, align 1
  call void @printDDep(i32 1221, i32 1221)
  call void @printDDep(i32 1220, i32 1221)
  call void @printDDep(i32 1221, i32 1221)
  %1258 = load i32, i32* @Inst_Counter, !dbg !5553
  %1259 = add i32 1, %1258, !dbg !5553
  store i32 %1259, i32* @Inst_Counter, !dbg !5553
  %1260 = load i32, i32* @Inst_Counter, !dbg !5553
  call void @printCounter(i32 %1260), !dbg !5553
  %1261 = ptrtoint i32* %a.addr.i43.i1679.i to i64, !dbg !5553
  call void @printLoadAddr(i64 %1261, i32 1222, i32 92, i32 13), !dbg !5553
  %1262 = load i32, i32* %a.addr.i43.i1679.i, align 4, !dbg !5553
  call void @printDDep(i32 1220, i32 1222), !dbg !5553
  call void @printDDep(i32 1220, i32 1222), !dbg !5553
  call void @printDDep(i32 1222, i32 1222), !dbg !5553
  %1263 = load i32, i32* @Inst_Counter, !dbg !5554
  %1264 = add i32 1, %1263, !dbg !5554
  store i32 %1264, i32* @Inst_Counter, !dbg !5554
  %1265 = load i32, i32* @Inst_Counter, !dbg !5554
  call void @printCounter(i32 %1265), !dbg !5554
  %1266 = ptrtoint i8* %n.addr.i44.i1680.i to i64, !dbg !5554
  call void @printLoadAddr(i64 %1266, i32 1223, i32 92, i32 18), !dbg !5554
  %1267 = load i8, i8* %n.addr.i44.i1680.i, align 1, !dbg !5554
  call void @printDDep(i32 1221, i32 1223), !dbg !5554
  call void @printDDep(i32 1221, i32 1223), !dbg !5554
  call void @printDDep(i32 1223, i32 1223), !dbg !5554
  %conv.i45.i1722.i = zext i8 %1267 to i32, !dbg !5554
  %shl.i46.i1723.i = shl i32 %1262, %conv.i45.i1722.i, !dbg !5555
  %1268 = load i32, i32* @Inst_Counter, !dbg !5556
  %1269 = add i32 3, %1268, !dbg !5556
  store i32 %1269, i32* @Inst_Counter, !dbg !5556
  %1270 = load i32, i32* @Inst_Counter, !dbg !5556
  call void @printCounter(i32 %1270), !dbg !5556
  %1271 = ptrtoint i32* %a.addr.i43.i1679.i to i64, !dbg !5556
  call void @printLoadAddr(i64 %1271, i32 1226, i32 92, i32 24), !dbg !5556
  %1272 = load i32, i32* %a.addr.i43.i1679.i, align 4, !dbg !5556
  call void @printDDep(i32 1220, i32 1226), !dbg !5556
  call void @printDDep(i32 1220, i32 1226), !dbg !5556
  call void @printDDep(i32 1226, i32 1226), !dbg !5556
  %1273 = load i32, i32* @Inst_Counter, !dbg !5557
  %1274 = add i32 1, %1273, !dbg !5557
  store i32 %1274, i32* @Inst_Counter, !dbg !5557
  %1275 = load i32, i32* @Inst_Counter, !dbg !5557
  call void @printCounter(i32 %1275), !dbg !5557
  %1276 = ptrtoint i8* %n.addr.i44.i1680.i to i64, !dbg !5557
  call void @printLoadAddr(i64 %1276, i32 1227, i32 92, i32 35), !dbg !5557
  %1277 = load i8, i8* %n.addr.i44.i1680.i, align 1, !dbg !5557
  call void @printDDep(i32 1221, i32 1227), !dbg !5557
  call void @printDDep(i32 1221, i32 1227), !dbg !5557
  call void @printDDep(i32 1227, i32 1227), !dbg !5557
  %conv1.i47.i1724.i = zext i8 %1277 to i32, !dbg !5557
  %sub.i48.i1725.i = sub nsw i32 32, %conv1.i47.i1724.i, !dbg !5558
  %shr.i49.i1726.i = lshr i32 %1272, %sub.i48.i1725.i, !dbg !5559
  %or.i50.i1727.i = or i32 %shl.i46.i1723.i, %shr.i49.i1726.i, !dbg !5560
  %xor22.i1728.i = xor i32 %xor.i1721.i, %or.i50.i1727.i, !dbg !5561
  %1278 = load i32, i32* @Inst_Counter, !dbg !5562
  %1279 = add i32 6, %1278, !dbg !5562
  store i32 %1279, i32* @Inst_Counter, !dbg !5562
  %1280 = load i32, i32* @Inst_Counter, !dbg !5562
  call void @printCounter(i32 %1280), !dbg !5562
  %1281 = ptrtoint i32* %t.i1688.i to i64, !dbg !5562
  call void @printLoadAddr(i64 %1281, i32 1233, i32 123, i32 48), !dbg !5562
  %1282 = load i32, i32* %t.i1688.i, align 4, !dbg !5562
  call void @printDDep(i32 1161, i32 1233), !dbg !5562
  call void @printDDep(i32 1172, i32 1233), !dbg !5562
  call void @printDDep(i32 1183, i32 1233), !dbg !5562
  call void @printDDep(i32 1194, i32 1233), !dbg !5562
  call void @printDDep(i32 1203, i32 1233), !dbg !5562
  call void @printDDep(i32 1203, i32 1233), !dbg !5562
  call void @printDDep(i32 1233, i32 1233), !dbg !5562
  %1283 = load i32, i32* @Inst_Counter
  %1284 = add i32 1, %1283
  store i32 %1284, i32* @Inst_Counter
  %1285 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1285)
  %1286 = ptrtoint i32* %a.addr.i35.i1681.i to i64
  call void @printStoreAddr(i64 %1286, i32 1234, i32 0, i32 0)
  store i32 %1282, i32* %a.addr.i35.i1681.i, align 4
  call void @printDDep(i32 1233, i32 1234)
  call void @printDDep(i32 1234, i32 1234)
  call void @printDDep(i32 1221, i32 1234)
  call void @printDDep(i32 1234, i32 1234)
  %1287 = load i32, i32* @Inst_Counter
  %1288 = add i32 1, %1287
  store i32 %1288, i32* @Inst_Counter
  %1289 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1289)
  %1290 = ptrtoint i8* %n.addr.i36.i1682.i to i64
  call void @printStoreAddr(i64 %1290, i32 1235, i32 0, i32 0)
  store i8 18, i8* %n.addr.i36.i1682.i, align 1
  call void @printDDep(i32 1235, i32 1235)
  call void @printDDep(i32 1234, i32 1235)
  call void @printDDep(i32 1235, i32 1235)
  %1291 = load i32, i32* @Inst_Counter, !dbg !5563
  %1292 = add i32 1, %1291, !dbg !5563
  store i32 %1292, i32* @Inst_Counter, !dbg !5563
  %1293 = load i32, i32* @Inst_Counter, !dbg !5563
  call void @printCounter(i32 %1293), !dbg !5563
  %1294 = ptrtoint i32* %a.addr.i35.i1681.i to i64, !dbg !5563
  call void @printLoadAddr(i64 %1294, i32 1236, i32 92, i32 13), !dbg !5563
  %1295 = load i32, i32* %a.addr.i35.i1681.i, align 4, !dbg !5563
  call void @printDDep(i32 1234, i32 1236), !dbg !5563
  call void @printDDep(i32 1234, i32 1236), !dbg !5563
  call void @printDDep(i32 1236, i32 1236), !dbg !5563
  %1296 = load i32, i32* @Inst_Counter, !dbg !5564
  %1297 = add i32 1, %1296, !dbg !5564
  store i32 %1297, i32* @Inst_Counter, !dbg !5564
  %1298 = load i32, i32* @Inst_Counter, !dbg !5564
  call void @printCounter(i32 %1298), !dbg !5564
  %1299 = ptrtoint i8* %n.addr.i36.i1682.i to i64, !dbg !5564
  call void @printLoadAddr(i64 %1299, i32 1237, i32 92, i32 18), !dbg !5564
  %1300 = load i8, i8* %n.addr.i36.i1682.i, align 1, !dbg !5564
  call void @printDDep(i32 1235, i32 1237), !dbg !5564
  call void @printDDep(i32 1235, i32 1237), !dbg !5564
  call void @printDDep(i32 1237, i32 1237), !dbg !5564
  %conv.i37.i1729.i = zext i8 %1300 to i32, !dbg !5564
  %shl.i38.i1730.i = shl i32 %1295, %conv.i37.i1729.i, !dbg !5565
  %1301 = load i32, i32* @Inst_Counter, !dbg !5566
  %1302 = add i32 3, %1301, !dbg !5566
  store i32 %1302, i32* @Inst_Counter, !dbg !5566
  %1303 = load i32, i32* @Inst_Counter, !dbg !5566
  call void @printCounter(i32 %1303), !dbg !5566
  %1304 = ptrtoint i32* %a.addr.i35.i1681.i to i64, !dbg !5566
  call void @printLoadAddr(i64 %1304, i32 1240, i32 92, i32 24), !dbg !5566
  %1305 = load i32, i32* %a.addr.i35.i1681.i, align 4, !dbg !5566
  call void @printDDep(i32 1234, i32 1240), !dbg !5566
  call void @printDDep(i32 1234, i32 1240), !dbg !5566
  call void @printDDep(i32 1240, i32 1240), !dbg !5566
  %1306 = load i32, i32* @Inst_Counter, !dbg !5567
  %1307 = add i32 1, %1306, !dbg !5567
  store i32 %1307, i32* @Inst_Counter, !dbg !5567
  %1308 = load i32, i32* @Inst_Counter, !dbg !5567
  call void @printCounter(i32 %1308), !dbg !5567
  %1309 = ptrtoint i8* %n.addr.i36.i1682.i to i64, !dbg !5567
  call void @printLoadAddr(i64 %1309, i32 1241, i32 92, i32 35), !dbg !5567
  %1310 = load i8, i8* %n.addr.i36.i1682.i, align 1, !dbg !5567
  call void @printDDep(i32 1235, i32 1241), !dbg !5567
  call void @printDDep(i32 1235, i32 1241), !dbg !5567
  call void @printDDep(i32 1241, i32 1241), !dbg !5567
  %conv1.i39.i1731.i = zext i8 %1310 to i32, !dbg !5567
  %sub.i40.i1732.i = sub nsw i32 32, %conv1.i39.i1731.i, !dbg !5568
  %shr.i41.i1733.i = lshr i32 %1305, %sub.i40.i1732.i, !dbg !5569
  %or.i42.i1734.i = or i32 %shl.i38.i1730.i, %shr.i41.i1733.i, !dbg !5570
  %xor24.i1735.i = xor i32 %xor22.i1728.i, %or.i42.i1734.i, !dbg !5571
  %1311 = load i32, i32* @Inst_Counter, !dbg !5572
  %1312 = add i32 6, %1311, !dbg !5572
  store i32 %1312, i32* @Inst_Counter, !dbg !5572
  %1313 = load i32, i32* @Inst_Counter, !dbg !5572
  call void @printCounter(i32 %1313), !dbg !5572
  %1314 = ptrtoint i32* %t.i1688.i to i64, !dbg !5572
  call void @printLoadAddr(i64 %1314, i32 1247, i32 123, i32 62), !dbg !5572
  %1315 = load i32, i32* %t.i1688.i, align 4, !dbg !5572
  call void @printDDep(i32 1161, i32 1247), !dbg !5572
  call void @printDDep(i32 1172, i32 1247), !dbg !5572
  call void @printDDep(i32 1183, i32 1247), !dbg !5572
  call void @printDDep(i32 1194, i32 1247), !dbg !5572
  call void @printDDep(i32 1203, i32 1247), !dbg !5572
  call void @printDDep(i32 1203, i32 1247), !dbg !5572
  call void @printDDep(i32 1247, i32 1247), !dbg !5572
  %1316 = load i32, i32* @Inst_Counter
  %1317 = add i32 1, %1316
  store i32 %1317, i32* @Inst_Counter
  %1318 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1318)
  %1319 = ptrtoint i32* %a.addr.i27.i1683.i to i64
  call void @printStoreAddr(i64 %1319, i32 1248, i32 0, i32 0)
  store i32 %1315, i32* %a.addr.i27.i1683.i, align 4
  call void @printDDep(i32 1247, i32 1248)
  call void @printDDep(i32 1248, i32 1248)
  call void @printDDep(i32 1235, i32 1248)
  call void @printDDep(i32 1248, i32 1248)
  %1320 = load i32, i32* @Inst_Counter
  %1321 = add i32 1, %1320
  store i32 %1321, i32* @Inst_Counter
  %1322 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1322)
  %1323 = ptrtoint i8* %n.addr.i28.i1684.i to i64
  call void @printStoreAddr(i64 %1323, i32 1249, i32 0, i32 0)
  store i8 24, i8* %n.addr.i28.i1684.i, align 1
  call void @printDDep(i32 1249, i32 1249)
  call void @printDDep(i32 1248, i32 1249)
  call void @printDDep(i32 1249, i32 1249)
  %1324 = load i32, i32* @Inst_Counter, !dbg !5573
  %1325 = add i32 1, %1324, !dbg !5573
  store i32 %1325, i32* @Inst_Counter, !dbg !5573
  %1326 = load i32, i32* @Inst_Counter, !dbg !5573
  call void @printCounter(i32 %1326), !dbg !5573
  %1327 = ptrtoint i32* %a.addr.i27.i1683.i to i64, !dbg !5573
  call void @printLoadAddr(i64 %1327, i32 1250, i32 92, i32 13), !dbg !5573
  %1328 = load i32, i32* %a.addr.i27.i1683.i, align 4, !dbg !5573
  call void @printDDep(i32 1248, i32 1250), !dbg !5573
  call void @printDDep(i32 1248, i32 1250), !dbg !5573
  call void @printDDep(i32 1250, i32 1250), !dbg !5573
  %1329 = load i32, i32* @Inst_Counter, !dbg !5574
  %1330 = add i32 1, %1329, !dbg !5574
  store i32 %1330, i32* @Inst_Counter, !dbg !5574
  %1331 = load i32, i32* @Inst_Counter, !dbg !5574
  call void @printCounter(i32 %1331), !dbg !5574
  %1332 = ptrtoint i8* %n.addr.i28.i1684.i to i64, !dbg !5574
  call void @printLoadAddr(i64 %1332, i32 1251, i32 92, i32 18), !dbg !5574
  %1333 = load i8, i8* %n.addr.i28.i1684.i, align 1, !dbg !5574
  call void @printDDep(i32 1249, i32 1251), !dbg !5574
  call void @printDDep(i32 1249, i32 1251), !dbg !5574
  call void @printDDep(i32 1251, i32 1251), !dbg !5574
  %conv.i29.i1736.i = zext i8 %1333 to i32, !dbg !5574
  %shl.i30.i1737.i = shl i32 %1328, %conv.i29.i1736.i, !dbg !5575
  %1334 = load i32, i32* @Inst_Counter, !dbg !5576
  %1335 = add i32 3, %1334, !dbg !5576
  store i32 %1335, i32* @Inst_Counter, !dbg !5576
  %1336 = load i32, i32* @Inst_Counter, !dbg !5576
  call void @printCounter(i32 %1336), !dbg !5576
  %1337 = ptrtoint i32* %a.addr.i27.i1683.i to i64, !dbg !5576
  call void @printLoadAddr(i64 %1337, i32 1254, i32 92, i32 24), !dbg !5576
  %1338 = load i32, i32* %a.addr.i27.i1683.i, align 4, !dbg !5576
  call void @printDDep(i32 1248, i32 1254), !dbg !5576
  call void @printDDep(i32 1248, i32 1254), !dbg !5576
  call void @printDDep(i32 1254, i32 1254), !dbg !5576
  %1339 = load i32, i32* @Inst_Counter, !dbg !5577
  %1340 = add i32 1, %1339, !dbg !5577
  store i32 %1340, i32* @Inst_Counter, !dbg !5577
  %1341 = load i32, i32* @Inst_Counter, !dbg !5577
  call void @printCounter(i32 %1341), !dbg !5577
  %1342 = ptrtoint i8* %n.addr.i28.i1684.i to i64, !dbg !5577
  call void @printLoadAddr(i64 %1342, i32 1255, i32 92, i32 35), !dbg !5577
  %1343 = load i8, i8* %n.addr.i28.i1684.i, align 1, !dbg !5577
  call void @printDDep(i32 1249, i32 1255), !dbg !5577
  call void @printDDep(i32 1249, i32 1255), !dbg !5577
  call void @printDDep(i32 1255, i32 1255), !dbg !5577
  %conv1.i31.i1738.i = zext i8 %1343 to i32, !dbg !5577
  %sub.i32.i1739.i = sub nsw i32 32, %conv1.i31.i1738.i, !dbg !5578
  %shr.i33.i1740.i = lshr i32 %1338, %sub.i32.i1739.i, !dbg !5579
  %or.i34.i1741.i = or i32 %shl.i30.i1737.i, %shr.i33.i1740.i, !dbg !5580
  %xor26.i1742.i = xor i32 %xor24.i1735.i, %or.i34.i1741.i, !dbg !5581
  %1344 = load i32, i32* @Inst_Counter, !dbg !5515
  %1345 = add i32 6, %1344, !dbg !5515
  store i32 %1345, i32* @Inst_Counter, !dbg !5515
  %1346 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1346), !dbg !5515
  %1347 = ptrtoint i32* %B0.i to i64, !dbg !5515
  call void @printLoadAddr(i64 %1347, i32 1261, i32 200, i32 5), !dbg !5515
  %1348 = load i32, i32* %B0.i, align 4, !dbg !5515
  call void @printDDep(i32 1026, i32 1261), !dbg !5515
  call void @printDDep(i32 1263, i32 1261), !dbg !5515
  call void @printDDep(i32 1681, i32 1261), !dbg !5515
  call void @printDDep(i32 1985, i32 1261), !dbg !5515
  call void @printDDep(i32 2289, i32 1261), !dbg !5515
  call void @printDDep(i32 2593, i32 1261), !dbg !5515
  call void @printDDep(i32 2897, i32 1261), !dbg !5515
  call void @printDDep(i32 3201, i32 1261), !dbg !5515
  call void @printDDep(i32 3543, i32 1261), !dbg !5515
  call void @printDDep(i32 1026, i32 1261), !dbg !5515
  call void @printDDep(i32 1261, i32 1261), !dbg !5515
  %xor8.i54 = xor i32 %1348, %xor26.i1742.i, !dbg !5515
  %1349 = load i32, i32* @Inst_Counter, !dbg !5515
  %1350 = add i32 2, %1349, !dbg !5515
  store i32 %1350, i32* @Inst_Counter, !dbg !5515
  %1351 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1351), !dbg !5515
  %1352 = ptrtoint i32* %B0.i to i64, !dbg !5515
  call void @printStoreAddr(i64 %1352, i32 1263, i32 200, i32 5), !dbg !5515
  store i32 %xor8.i54, i32* %B0.i, align 4, !dbg !5515
  call void @printDDep(i32 1026, i32 1263), !dbg !5515
  call void @printDDep(i32 1204, i32 1263), !dbg !5515
  call void @printDDep(i32 1208, i32 1263), !dbg !5515
  call void @printDDep(i32 1209, i32 1263), !dbg !5515
  call void @printDDep(i32 1212, i32 1263), !dbg !5515
  call void @printDDep(i32 1213, i32 1263), !dbg !5515
  call void @printDDep(i32 1222, i32 1263), !dbg !5515
  call void @printDDep(i32 1223, i32 1263), !dbg !5515
  call void @printDDep(i32 1226, i32 1263), !dbg !5515
  call void @printDDep(i32 1227, i32 1263), !dbg !5515
  call void @printDDep(i32 1236, i32 1263), !dbg !5515
  call void @printDDep(i32 1237, i32 1263), !dbg !5515
  call void @printDDep(i32 1240, i32 1263), !dbg !5515
  call void @printDDep(i32 1241, i32 1263), !dbg !5515
  call void @printDDep(i32 1250, i32 1263), !dbg !5515
  call void @printDDep(i32 1251, i32 1263), !dbg !5515
  call void @printDDep(i32 1254, i32 1263), !dbg !5515
  call void @printDDep(i32 1255, i32 1263), !dbg !5515
  call void @printDDep(i32 1261, i32 1263), !dbg !5515
  call void @printDDep(i32 1263, i32 1263), !dbg !5515
  call void @printDDep(i32 1681, i32 1263), !dbg !5515
  call void @printDDep(i32 1985, i32 1263), !dbg !5515
  call void @printDDep(i32 2289, i32 1263), !dbg !5515
  call void @printDDep(i32 2593, i32 1263), !dbg !5515
  call void @printDDep(i32 2897, i32 1263), !dbg !5515
  call void @printDDep(i32 3201, i32 1263), !dbg !5515
  call void @printDDep(i32 3543, i32 1263), !dbg !5515
  call void @printDDep(i32 1249, i32 1263), !dbg !5515
  call void @printDDep(i32 1263, i32 1263), !dbg !5515
  %1353 = load i32, i32* @Inst_Counter, !dbg !5515
  %1354 = add i32 1, %1353, !dbg !5515
  store i32 %1354, i32* @Inst_Counter, !dbg !5515
  %1355 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1355), !dbg !5515
  %1356 = ptrtoint i32* %B0.i to i64, !dbg !5515
  call void @printLoadAddr(i64 %1356, i32 1264, i32 200, i32 5), !dbg !5515
  %1357 = load i32, i32* %B0.i, align 4, !dbg !5515
  call void @printDDep(i32 1026, i32 1264), !dbg !5515
  call void @printDDep(i32 1263, i32 1264), !dbg !5515
  call void @printDDep(i32 1681, i32 1264), !dbg !5515
  call void @printDDep(i32 1985, i32 1264), !dbg !5515
  call void @printDDep(i32 2289, i32 1264), !dbg !5515
  call void @printDDep(i32 2593, i32 1264), !dbg !5515
  call void @printDDep(i32 2897, i32 1264), !dbg !5515
  call void @printDDep(i32 3201, i32 1264), !dbg !5515
  call void @printDDep(i32 3543, i32 1264), !dbg !5515
  call void @printDDep(i32 1263, i32 1264), !dbg !5515
  call void @printDDep(i32 1264, i32 1264), !dbg !5515
  %1358 = load i32, i32* @Inst_Counter, !dbg !5515
  %1359 = add i32 1, %1358, !dbg !5515
  store i32 %1359, i32* @Inst_Counter, !dbg !5515
  %1360 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1360), !dbg !5515
  %1361 = ptrtoint i32* %B2.i to i64, !dbg !5515
  call void @printLoadAddr(i64 %1361, i32 1265, i32 200, i32 5), !dbg !5515
  %1362 = load i32, i32* %B2.i, align 4, !dbg !5515
  call void @printDDep(i32 1108, i32 1265), !dbg !5515
  call void @printDDep(i32 1491, i32 1265), !dbg !5515
  call void @printDDep(i32 1833, i32 1265), !dbg !5515
  call void @printDDep(i32 2137, i32 1265), !dbg !5515
  call void @printDDep(i32 2441, i32 1265), !dbg !5515
  call void @printDDep(i32 2745, i32 1265), !dbg !5515
  call void @printDDep(i32 3049, i32 1265), !dbg !5515
  call void @printDDep(i32 3353, i32 1265), !dbg !5515
  call void @printDDep(i32 3771, i32 1265), !dbg !5515
  call void @printDDep(i32 1108, i32 1265), !dbg !5515
  call void @printDDep(i32 1265, i32 1265), !dbg !5515
  %xor9.i = xor i32 %1357, %1362, !dbg !5515
  %1363 = load i32, i32* @Inst_Counter, !dbg !5515
  %1364 = add i32 2, %1363, !dbg !5515
  store i32 %1364, i32* @Inst_Counter, !dbg !5515
  %1365 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1365), !dbg !5515
  %1366 = ptrtoint i32* %B3.i to i64, !dbg !5515
  call void @printLoadAddr(i64 %1366, i32 1267, i32 200, i32 5), !dbg !5515
  %1367 = load i32, i32* %B3.i, align 4, !dbg !5515
  call void @printDDep(i32 1149, i32 1267), !dbg !5515
  call void @printDDep(i32 1605, i32 1267), !dbg !5515
  call void @printDDep(i32 1909, i32 1267), !dbg !5515
  call void @printDDep(i32 2213, i32 1267), !dbg !5515
  call void @printDDep(i32 2517, i32 1267), !dbg !5515
  call void @printDDep(i32 2821, i32 1267), !dbg !5515
  call void @printDDep(i32 3125, i32 1267), !dbg !5515
  call void @printDDep(i32 3429, i32 1267), !dbg !5515
  call void @printDDep(i32 3885, i32 1267), !dbg !5515
  call void @printDDep(i32 1149, i32 1267), !dbg !5515
  call void @printDDep(i32 1267, i32 1267), !dbg !5515
  %xor10.i = xor i32 %xor9.i, %1367, !dbg !5515
  %1368 = load i32, i32* @Inst_Counter, !dbg !5515
  %1369 = add i32 2, %1368, !dbg !5515
  store i32 %1369, i32* @Inst_Counter, !dbg !5515
  %1370 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1370), !dbg !5515
  %1371 = ptrtoint %struct.SM4_KEY_st** %ks.addr.i24 to i64, !dbg !5515
  call void @printLoadAddr(i64 %1371, i32 1269, i32 200, i32 5), !dbg !5515
  %1372 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr.i24, align 8, !dbg !5515
  call void @printDDep(i32 983, i32 1269), !dbg !5515
  call void @printDDep(i32 985, i32 1269), !dbg !5515
  call void @printDDep(i32 1269, i32 1269), !dbg !5515
  %rk11.i = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %1372, i32 0, i32 0, !dbg !5515
  %arrayidx12.i = getelementptr inbounds [32 x i32], [32 x i32]* %rk11.i, i64 0, i64 1, !dbg !5515
  %1373 = load i32, i32* @Inst_Counter, !dbg !5515
  %1374 = add i32 3, %1373, !dbg !5515
  store i32 %1374, i32* @Inst_Counter, !dbg !5515
  %1375 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1375), !dbg !5515
  %1376 = ptrtoint i32* %arrayidx12.i to i64, !dbg !5515
  call void @printLoadAddr(i64 %1376, i32 1272, i32 200, i32 5), !dbg !5515
  %1377 = load i32, i32* %arrayidx12.i, align 4, !dbg !5515
  call void @printDDep(i32 1269, i32 1272), !dbg !5515
  call void @printDDep(i32 985, i32 1272), !dbg !5515
  call void @printDDep(i32 1272, i32 1272), !dbg !5515
  %xor13.i = xor i32 %xor10.i, %1377, !dbg !5515
  %1378 = load i32, i32* @Inst_Counter
  %1379 = add i32 2, %1378
  store i32 %1379, i32* @Inst_Counter
  %1380 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1380)
  %1381 = ptrtoint i32* %X.addr.i1623.i to i64
  call void @printStoreAddr(i64 %1381, i32 1274, i32 0, i32 0)
  store i32 %xor13.i, i32* %X.addr.i1623.i, align 4
  call void @printDDep(i32 1264, i32 1274)
  call void @printDDep(i32 1265, i32 1274)
  call void @printDDep(i32 1267, i32 1274)
  call void @printDDep(i32 1272, i32 1274)
  call void @printDDep(i32 1274, i32 1274)
  call void @printDDep(i32 1263, i32 1274)
  call void @printDDep(i32 1274, i32 1274)
  %1382 = load i32, i32* @Inst_Counter, !dbg !4714
  %1383 = add i32 1, %1382, !dbg !4714
  store i32 %1383, i32* @Inst_Counter, !dbg !4714
  %1384 = load i32, i32* @Inst_Counter, !dbg !4714
  call void @printCounter(i32 %1384), !dbg !4714
  %1385 = ptrtoint i32* %t.i1624.i to i64, !dbg !4714
  call void @printStoreAddr(i64 %1385, i32 1275, i32 113, i32 14), !dbg !4714
  store i32 0, i32* %t.i1624.i, align 4, !dbg !4714
  call void @printDDep(i32 1275, i32 1275), !dbg !4714
  call void @printDDep(i32 1286, i32 1275), !dbg !4714
  call void @printDDep(i32 1297, i32 1275), !dbg !4714
  call void @printDDep(i32 1308, i32 1275), !dbg !4714
  call void @printDDep(i32 1317, i32 1275), !dbg !4714
  call void @printDDep(i32 1274, i32 1275), !dbg !4714
  call void @printDDep(i32 1275, i32 1275), !dbg !4714
  %1386 = load i32, i32* @Inst_Counter, !dbg !5582
  %1387 = add i32 1, %1386, !dbg !5582
  store i32 %1387, i32* @Inst_Counter, !dbg !5582
  %1388 = load i32, i32* @Inst_Counter, !dbg !5582
  call void @printCounter(i32 %1388), !dbg !5582
  %1389 = ptrtoint i32* %X.addr.i1623.i to i64, !dbg !5582
  call void @printLoadAddr(i64 %1389, i32 1276, i32 115, i32 37), !dbg !5582
  %1390 = load i32, i32* %X.addr.i1623.i, align 4, !dbg !5582
  call void @printDDep(i32 1274, i32 1276), !dbg !5582
  call void @printDDep(i32 1274, i32 1276), !dbg !5582
  call void @printDDep(i32 1276, i32 1276), !dbg !5582
  %shr.i1625.i = lshr i32 %1390, 24, !dbg !5583
  %conv.i1626.i = trunc i32 %shr.i1625.i to i8, !dbg !5584
  %idxprom.i1627.i = zext i8 %conv.i1626.i to i64, !dbg !5585
  %arrayidx.i1628.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom.i1627.i, !dbg !5585
  %1391 = load i32, i32* @Inst_Counter, !dbg !5585
  %1392 = add i32 5, %1391, !dbg !5585
  store i32 %1392, i32* @Inst_Counter, !dbg !5585
  %1393 = load i32, i32* @Inst_Counter, !dbg !5585
  call void @printCounter(i32 %1393), !dbg !5585
  %1394 = ptrtoint i8* %arrayidx.i1628.i to i64, !dbg !5585
  %1395 = load [256 x i8], [256 x i8]* @SM4_S, !dbg !5585
  call void @printSymLoadAddr(i64 %1394, i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 add (i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 255), i32 1, i32 1281, i32 115, i32 21), !dbg !5585
  %1396 = load i8, i8* %arrayidx.i1628.i, align 1, !dbg !5585
  call void @printDDep(i32 1276, i32 1281), !dbg !5585
  call void @printDDep(i32 1281, i32 1281), !dbg !5585
  %conv1.i1629.i = zext i8 %1396 to i32, !dbg !5586
  %shl.i1630.i = shl i32 %conv1.i1629.i, 24, !dbg !5587
  %1397 = load i32, i32* @Inst_Counter, !dbg !5588
  %1398 = add i32 3, %1397, !dbg !5588
  store i32 %1398, i32* @Inst_Counter, !dbg !5588
  %1399 = load i32, i32* @Inst_Counter, !dbg !5588
  call void @printCounter(i32 %1399), !dbg !5588
  %1400 = ptrtoint i32* %t.i1624.i to i64, !dbg !5588
  call void @printLoadAddr(i64 %1400, i32 1284, i32 115, i32 7), !dbg !5588
  %1401 = load i32, i32* %t.i1624.i, align 4, !dbg !5588
  call void @printDDep(i32 1275, i32 1284), !dbg !5588
  call void @printDDep(i32 1286, i32 1284), !dbg !5588
  call void @printDDep(i32 1297, i32 1284), !dbg !5588
  call void @printDDep(i32 1308, i32 1284), !dbg !5588
  call void @printDDep(i32 1317, i32 1284), !dbg !5588
  call void @printDDep(i32 1275, i32 1284), !dbg !5588
  call void @printDDep(i32 1284, i32 1284), !dbg !5588
  %or.i1631.i = or i32 %1401, %shl.i1630.i, !dbg !5588
  %1402 = load i32, i32* @Inst_Counter, !dbg !5588
  %1403 = add i32 2, %1402, !dbg !5588
  store i32 %1403, i32* @Inst_Counter, !dbg !5588
  %1404 = load i32, i32* @Inst_Counter, !dbg !5588
  call void @printCounter(i32 %1404), !dbg !5588
  %1405 = ptrtoint i32* %t.i1624.i to i64, !dbg !5588
  call void @printStoreAddr(i64 %1405, i32 1286, i32 115, i32 7), !dbg !5588
  store i32 %or.i1631.i, i32* %t.i1624.i, align 4, !dbg !5588
  call void @printDDep(i32 1275, i32 1286), !dbg !5588
  call void @printDDep(i32 1281, i32 1286), !dbg !5588
  call void @printDDep(i32 1284, i32 1286), !dbg !5588
  call void @printDDep(i32 1286, i32 1286), !dbg !5588
  call void @printDDep(i32 1297, i32 1286), !dbg !5588
  call void @printDDep(i32 1308, i32 1286), !dbg !5588
  call void @printDDep(i32 1317, i32 1286), !dbg !5588
  call void @printDDep(i32 1275, i32 1286), !dbg !5588
  call void @printDDep(i32 1286, i32 1286), !dbg !5588
  %1406 = load i32, i32* @Inst_Counter, !dbg !5589
  %1407 = add i32 1, %1406, !dbg !5589
  store i32 %1407, i32* @Inst_Counter, !dbg !5589
  %1408 = load i32, i32* @Inst_Counter, !dbg !5589
  call void @printCounter(i32 %1408), !dbg !5589
  %1409 = ptrtoint i32* %X.addr.i1623.i to i64, !dbg !5589
  call void @printLoadAddr(i64 %1409, i32 1287, i32 116, i32 37), !dbg !5589
  %1410 = load i32, i32* %X.addr.i1623.i, align 4, !dbg !5589
  call void @printDDep(i32 1274, i32 1287), !dbg !5589
  call void @printDDep(i32 1274, i32 1287), !dbg !5589
  call void @printDDep(i32 1287, i32 1287), !dbg !5589
  %shr2.i1632.i = lshr i32 %1410, 16, !dbg !5590
  %conv3.i1633.i = trunc i32 %shr2.i1632.i to i8, !dbg !5591
  %idxprom4.i1634.i = zext i8 %conv3.i1633.i to i64, !dbg !5592
  %arrayidx5.i1635.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom4.i1634.i, !dbg !5592
  %1411 = load i32, i32* @Inst_Counter, !dbg !5592
  %1412 = add i32 5, %1411, !dbg !5592
  store i32 %1412, i32* @Inst_Counter, !dbg !5592
  %1413 = load i32, i32* @Inst_Counter, !dbg !5592
  call void @printCounter(i32 %1413), !dbg !5592
  %1414 = ptrtoint i8* %arrayidx5.i1635.i to i64, !dbg !5592
  %1415 = load [256 x i8], [256 x i8]* @SM4_S, !dbg !5592
  call void @printSymLoadAddr(i64 %1414, i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 add (i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 255), i32 1, i32 1292, i32 116, i32 21), !dbg !5592
  %1416 = load i8, i8* %arrayidx5.i1635.i, align 1, !dbg !5592
  call void @printDDep(i32 1287, i32 1292), !dbg !5592
  call void @printDDep(i32 1292, i32 1292), !dbg !5592
  %conv6.i1636.i = zext i8 %1416 to i32, !dbg !5593
  %shl7.i1637.i = shl i32 %conv6.i1636.i, 16, !dbg !5594
  %1417 = load i32, i32* @Inst_Counter, !dbg !5595
  %1418 = add i32 3, %1417, !dbg !5595
  store i32 %1418, i32* @Inst_Counter, !dbg !5595
  %1419 = load i32, i32* @Inst_Counter, !dbg !5595
  call void @printCounter(i32 %1419), !dbg !5595
  %1420 = ptrtoint i32* %t.i1624.i to i64, !dbg !5595
  call void @printLoadAddr(i64 %1420, i32 1295, i32 116, i32 7), !dbg !5595
  %1421 = load i32, i32* %t.i1624.i, align 4, !dbg !5595
  call void @printDDep(i32 1275, i32 1295), !dbg !5595
  call void @printDDep(i32 1286, i32 1295), !dbg !5595
  call void @printDDep(i32 1297, i32 1295), !dbg !5595
  call void @printDDep(i32 1308, i32 1295), !dbg !5595
  call void @printDDep(i32 1317, i32 1295), !dbg !5595
  call void @printDDep(i32 1286, i32 1295), !dbg !5595
  call void @printDDep(i32 1295, i32 1295), !dbg !5595
  %or8.i1638.i = or i32 %1421, %shl7.i1637.i, !dbg !5595
  %1422 = load i32, i32* @Inst_Counter, !dbg !5595
  %1423 = add i32 2, %1422, !dbg !5595
  store i32 %1423, i32* @Inst_Counter, !dbg !5595
  %1424 = load i32, i32* @Inst_Counter, !dbg !5595
  call void @printCounter(i32 %1424), !dbg !5595
  %1425 = ptrtoint i32* %t.i1624.i to i64, !dbg !5595
  call void @printStoreAddr(i64 %1425, i32 1297, i32 116, i32 7), !dbg !5595
  store i32 %or8.i1638.i, i32* %t.i1624.i, align 4, !dbg !5595
  call void @printDDep(i32 1275, i32 1297), !dbg !5595
  call void @printDDep(i32 1286, i32 1297), !dbg !5595
  call void @printDDep(i32 1292, i32 1297), !dbg !5595
  call void @printDDep(i32 1295, i32 1297), !dbg !5595
  call void @printDDep(i32 1297, i32 1297), !dbg !5595
  call void @printDDep(i32 1308, i32 1297), !dbg !5595
  call void @printDDep(i32 1317, i32 1297), !dbg !5595
  call void @printDDep(i32 1286, i32 1297), !dbg !5595
  call void @printDDep(i32 1297, i32 1297), !dbg !5595
  %1426 = load i32, i32* @Inst_Counter, !dbg !5596
  %1427 = add i32 1, %1426, !dbg !5596
  store i32 %1427, i32* @Inst_Counter, !dbg !5596
  %1428 = load i32, i32* @Inst_Counter, !dbg !5596
  call void @printCounter(i32 %1428), !dbg !5596
  %1429 = ptrtoint i32* %X.addr.i1623.i to i64, !dbg !5596
  call void @printLoadAddr(i64 %1429, i32 1298, i32 117, i32 37), !dbg !5596
  %1430 = load i32, i32* %X.addr.i1623.i, align 4, !dbg !5596
  call void @printDDep(i32 1274, i32 1298), !dbg !5596
  call void @printDDep(i32 1274, i32 1298), !dbg !5596
  call void @printDDep(i32 1298, i32 1298), !dbg !5596
  %shr9.i1639.i = lshr i32 %1430, 8, !dbg !5597
  %conv10.i1640.i = trunc i32 %shr9.i1639.i to i8, !dbg !5598
  %idxprom11.i1641.i = zext i8 %conv10.i1640.i to i64, !dbg !5599
  %arrayidx12.i1642.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom11.i1641.i, !dbg !5599
  %1431 = load i32, i32* @Inst_Counter, !dbg !5599
  %1432 = add i32 5, %1431, !dbg !5599
  store i32 %1432, i32* @Inst_Counter, !dbg !5599
  %1433 = load i32, i32* @Inst_Counter, !dbg !5599
  call void @printCounter(i32 %1433), !dbg !5599
  %1434 = ptrtoint i8* %arrayidx12.i1642.i to i64, !dbg !5599
  %1435 = load [256 x i8], [256 x i8]* @SM4_S, !dbg !5599
  call void @printSymLoadAddr(i64 %1434, i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 add (i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 255), i32 1, i32 1303, i32 117, i32 21), !dbg !5599
  %1436 = load i8, i8* %arrayidx12.i1642.i, align 1, !dbg !5599
  call void @printDDep(i32 1298, i32 1303), !dbg !5599
  call void @printDDep(i32 1303, i32 1303), !dbg !5599
  %conv13.i1643.i = zext i8 %1436 to i32, !dbg !5600
  %shl14.i1644.i = shl i32 %conv13.i1643.i, 8, !dbg !5601
  %1437 = load i32, i32* @Inst_Counter, !dbg !5602
  %1438 = add i32 3, %1437, !dbg !5602
  store i32 %1438, i32* @Inst_Counter, !dbg !5602
  %1439 = load i32, i32* @Inst_Counter, !dbg !5602
  call void @printCounter(i32 %1439), !dbg !5602
  %1440 = ptrtoint i32* %t.i1624.i to i64, !dbg !5602
  call void @printLoadAddr(i64 %1440, i32 1306, i32 117, i32 7), !dbg !5602
  %1441 = load i32, i32* %t.i1624.i, align 4, !dbg !5602
  call void @printDDep(i32 1275, i32 1306), !dbg !5602
  call void @printDDep(i32 1286, i32 1306), !dbg !5602
  call void @printDDep(i32 1297, i32 1306), !dbg !5602
  call void @printDDep(i32 1308, i32 1306), !dbg !5602
  call void @printDDep(i32 1317, i32 1306), !dbg !5602
  call void @printDDep(i32 1297, i32 1306), !dbg !5602
  call void @printDDep(i32 1306, i32 1306), !dbg !5602
  %or15.i1645.i = or i32 %1441, %shl14.i1644.i, !dbg !5602
  %1442 = load i32, i32* @Inst_Counter, !dbg !5602
  %1443 = add i32 2, %1442, !dbg !5602
  store i32 %1443, i32* @Inst_Counter, !dbg !5602
  %1444 = load i32, i32* @Inst_Counter, !dbg !5602
  call void @printCounter(i32 %1444), !dbg !5602
  %1445 = ptrtoint i32* %t.i1624.i to i64, !dbg !5602
  call void @printStoreAddr(i64 %1445, i32 1308, i32 117, i32 7), !dbg !5602
  store i32 %or15.i1645.i, i32* %t.i1624.i, align 4, !dbg !5602
  call void @printDDep(i32 1275, i32 1308), !dbg !5602
  call void @printDDep(i32 1286, i32 1308), !dbg !5602
  call void @printDDep(i32 1297, i32 1308), !dbg !5602
  call void @printDDep(i32 1303, i32 1308), !dbg !5602
  call void @printDDep(i32 1306, i32 1308), !dbg !5602
  call void @printDDep(i32 1308, i32 1308), !dbg !5602
  call void @printDDep(i32 1317, i32 1308), !dbg !5602
  call void @printDDep(i32 1297, i32 1308), !dbg !5602
  call void @printDDep(i32 1308, i32 1308), !dbg !5602
  %1446 = load i32, i32* @Inst_Counter, !dbg !5603
  %1447 = add i32 1, %1446, !dbg !5603
  store i32 %1447, i32* @Inst_Counter, !dbg !5603
  %1448 = load i32, i32* @Inst_Counter, !dbg !5603
  call void @printCounter(i32 %1448), !dbg !5603
  %1449 = ptrtoint i32* %X.addr.i1623.i to i64, !dbg !5603
  call void @printLoadAddr(i64 %1449, i32 1309, i32 118, i32 25), !dbg !5603
  %1450 = load i32, i32* %X.addr.i1623.i, align 4, !dbg !5603
  call void @printDDep(i32 1274, i32 1309), !dbg !5603
  call void @printDDep(i32 1274, i32 1309), !dbg !5603
  call void @printDDep(i32 1309, i32 1309), !dbg !5603
  %conv16.i1646.i = trunc i32 %1450 to i8, !dbg !5604
  %idxprom17.i1647.i = zext i8 %conv16.i1646.i to i64, !dbg !5605
  %arrayidx18.i1648.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom17.i1647.i, !dbg !5605
  %1451 = load i32, i32* @Inst_Counter, !dbg !5605
  %1452 = add i32 4, %1451, !dbg !5605
  store i32 %1452, i32* @Inst_Counter, !dbg !5605
  %1453 = load i32, i32* @Inst_Counter, !dbg !5605
  call void @printCounter(i32 %1453), !dbg !5605
  %1454 = ptrtoint i8* %arrayidx18.i1648.i to i64, !dbg !5605
  %1455 = load [256 x i8], [256 x i8]* @SM4_S, !dbg !5605
  call void @printSymLoadAddr(i64 %1454, i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 add (i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 255), i32 1, i32 1313, i32 118, i32 10), !dbg !5605
  %1456 = load i8, i8* %arrayidx18.i1648.i, align 1, !dbg !5605
  call void @printDDep(i32 1309, i32 1313), !dbg !5605
  call void @printDDep(i32 1313, i32 1313), !dbg !5605
  %conv19.i1649.i = zext i8 %1456 to i32, !dbg !5605
  %1457 = load i32, i32* @Inst_Counter, !dbg !5606
  %1458 = add i32 2, %1457, !dbg !5606
  store i32 %1458, i32* @Inst_Counter, !dbg !5606
  %1459 = load i32, i32* @Inst_Counter, !dbg !5606
  call void @printCounter(i32 %1459), !dbg !5606
  %1460 = ptrtoint i32* %t.i1624.i to i64, !dbg !5606
  call void @printLoadAddr(i64 %1460, i32 1315, i32 118, i32 7), !dbg !5606
  %1461 = load i32, i32* %t.i1624.i, align 4, !dbg !5606
  call void @printDDep(i32 1275, i32 1315), !dbg !5606
  call void @printDDep(i32 1286, i32 1315), !dbg !5606
  call void @printDDep(i32 1297, i32 1315), !dbg !5606
  call void @printDDep(i32 1308, i32 1315), !dbg !5606
  call void @printDDep(i32 1317, i32 1315), !dbg !5606
  call void @printDDep(i32 1308, i32 1315), !dbg !5606
  call void @printDDep(i32 1315, i32 1315), !dbg !5606
  %or20.i1650.i = or i32 %1461, %conv19.i1649.i, !dbg !5606
  %1462 = load i32, i32* @Inst_Counter, !dbg !5606
  %1463 = add i32 2, %1462, !dbg !5606
  store i32 %1463, i32* @Inst_Counter, !dbg !5606
  %1464 = load i32, i32* @Inst_Counter, !dbg !5606
  call void @printCounter(i32 %1464), !dbg !5606
  %1465 = ptrtoint i32* %t.i1624.i to i64, !dbg !5606
  call void @printStoreAddr(i64 %1465, i32 1317, i32 118, i32 7), !dbg !5606
  store i32 %or20.i1650.i, i32* %t.i1624.i, align 4, !dbg !5606
  call void @printDDep(i32 1275, i32 1317), !dbg !5606
  call void @printDDep(i32 1286, i32 1317), !dbg !5606
  call void @printDDep(i32 1297, i32 1317), !dbg !5606
  call void @printDDep(i32 1308, i32 1317), !dbg !5606
  call void @printDDep(i32 1313, i32 1317), !dbg !5606
  call void @printDDep(i32 1315, i32 1317), !dbg !5606
  call void @printDDep(i32 1317, i32 1317), !dbg !5606
  call void @printDDep(i32 1308, i32 1317), !dbg !5606
  call void @printDDep(i32 1317, i32 1317), !dbg !5606
  %1466 = load i32, i32* @Inst_Counter, !dbg !5607
  %1467 = add i32 1, %1466, !dbg !5607
  store i32 %1467, i32* @Inst_Counter, !dbg !5607
  %1468 = load i32, i32* @Inst_Counter, !dbg !5607
  call void @printCounter(i32 %1468), !dbg !5607
  %1469 = ptrtoint i32* %t.i1624.i to i64, !dbg !5607
  call void @printLoadAddr(i64 %1469, i32 1318, i32 123, i32 12), !dbg !5607
  %1470 = load i32, i32* %t.i1624.i, align 4, !dbg !5607
  call void @printDDep(i32 1275, i32 1318), !dbg !5607
  call void @printDDep(i32 1286, i32 1318), !dbg !5607
  call void @printDDep(i32 1297, i32 1318), !dbg !5607
  call void @printDDep(i32 1308, i32 1318), !dbg !5607
  call void @printDDep(i32 1317, i32 1318), !dbg !5607
  call void @printDDep(i32 1317, i32 1318), !dbg !5607
  call void @printDDep(i32 1318, i32 1318), !dbg !5607
  %1471 = load i32, i32* @Inst_Counter, !dbg !5608
  %1472 = add i32 1, %1471, !dbg !5608
  store i32 %1472, i32* @Inst_Counter, !dbg !5608
  %1473 = load i32, i32* @Inst_Counter, !dbg !5608
  call void @printCounter(i32 %1473), !dbg !5608
  %1474 = ptrtoint i32* %t.i1624.i to i64, !dbg !5608
  call void @printLoadAddr(i64 %1474, i32 1319, i32 123, i32 21), !dbg !5608
  %1475 = load i32, i32* %t.i1624.i, align 4, !dbg !5608
  call void @printDDep(i32 1275, i32 1319), !dbg !5608
  call void @printDDep(i32 1286, i32 1319), !dbg !5608
  call void @printDDep(i32 1297, i32 1319), !dbg !5608
  call void @printDDep(i32 1308, i32 1319), !dbg !5608
  call void @printDDep(i32 1317, i32 1319), !dbg !5608
  call void @printDDep(i32 1317, i32 1319), !dbg !5608
  call void @printDDep(i32 1319, i32 1319), !dbg !5608
  %1476 = load i32, i32* @Inst_Counter
  %1477 = add i32 1, %1476
  store i32 %1477, i32* @Inst_Counter
  %1478 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1478)
  %1479 = ptrtoint i32* %a.addr.i.i1621.i to i64
  call void @printStoreAddr(i64 %1479, i32 1320, i32 0, i32 0)
  store i32 %1475, i32* %a.addr.i.i1621.i, align 4
  call void @printDDep(i32 1319, i32 1320)
  call void @printDDep(i32 1320, i32 1320)
  call void @printDDep(i32 1317, i32 1320)
  call void @printDDep(i32 1320, i32 1320)
  %1480 = load i32, i32* @Inst_Counter
  %1481 = add i32 1, %1480
  store i32 %1481, i32* @Inst_Counter
  %1482 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1482)
  %1483 = ptrtoint i8* %n.addr.i.i1622.i to i64
  call void @printStoreAddr(i64 %1483, i32 1321, i32 0, i32 0)
  store i8 2, i8* %n.addr.i.i1622.i, align 1
  call void @printDDep(i32 1321, i32 1321)
  call void @printDDep(i32 1320, i32 1321)
  call void @printDDep(i32 1321, i32 1321)
  %1484 = load i32, i32* @Inst_Counter, !dbg !5609
  %1485 = add i32 1, %1484, !dbg !5609
  store i32 %1485, i32* @Inst_Counter, !dbg !5609
  %1486 = load i32, i32* @Inst_Counter, !dbg !5609
  call void @printCounter(i32 %1486), !dbg !5609
  %1487 = ptrtoint i32* %a.addr.i.i1621.i to i64, !dbg !5609
  call void @printLoadAddr(i64 %1487, i32 1322, i32 92, i32 13), !dbg !5609
  %1488 = load i32, i32* %a.addr.i.i1621.i, align 4, !dbg !5609
  call void @printDDep(i32 1320, i32 1322), !dbg !5609
  call void @printDDep(i32 1320, i32 1322), !dbg !5609
  call void @printDDep(i32 1322, i32 1322), !dbg !5609
  %1489 = load i32, i32* @Inst_Counter, !dbg !5610
  %1490 = add i32 1, %1489, !dbg !5610
  store i32 %1490, i32* @Inst_Counter, !dbg !5610
  %1491 = load i32, i32* @Inst_Counter, !dbg !5610
  call void @printCounter(i32 %1491), !dbg !5610
  %1492 = ptrtoint i8* %n.addr.i.i1622.i to i64, !dbg !5610
  call void @printLoadAddr(i64 %1492, i32 1323, i32 92, i32 18), !dbg !5610
  %1493 = load i8, i8* %n.addr.i.i1622.i, align 1, !dbg !5610
  call void @printDDep(i32 1321, i32 1323), !dbg !5610
  call void @printDDep(i32 1321, i32 1323), !dbg !5610
  call void @printDDep(i32 1323, i32 1323), !dbg !5610
  %conv.i.i1651.i = zext i8 %1493 to i32, !dbg !5610
  %shl.i.i1652.i = shl i32 %1488, %conv.i.i1651.i, !dbg !5611
  %1494 = load i32, i32* @Inst_Counter, !dbg !5612
  %1495 = add i32 3, %1494, !dbg !5612
  store i32 %1495, i32* @Inst_Counter, !dbg !5612
  %1496 = load i32, i32* @Inst_Counter, !dbg !5612
  call void @printCounter(i32 %1496), !dbg !5612
  %1497 = ptrtoint i32* %a.addr.i.i1621.i to i64, !dbg !5612
  call void @printLoadAddr(i64 %1497, i32 1326, i32 92, i32 24), !dbg !5612
  %1498 = load i32, i32* %a.addr.i.i1621.i, align 4, !dbg !5612
  call void @printDDep(i32 1320, i32 1326), !dbg !5612
  call void @printDDep(i32 1320, i32 1326), !dbg !5612
  call void @printDDep(i32 1326, i32 1326), !dbg !5612
  %1499 = load i32, i32* @Inst_Counter, !dbg !5613
  %1500 = add i32 1, %1499, !dbg !5613
  store i32 %1500, i32* @Inst_Counter, !dbg !5613
  %1501 = load i32, i32* @Inst_Counter, !dbg !5613
  call void @printCounter(i32 %1501), !dbg !5613
  %1502 = ptrtoint i8* %n.addr.i.i1622.i to i64, !dbg !5613
  call void @printLoadAddr(i64 %1502, i32 1327, i32 92, i32 35), !dbg !5613
  %1503 = load i8, i8* %n.addr.i.i1622.i, align 1, !dbg !5613
  call void @printDDep(i32 1321, i32 1327), !dbg !5613
  call void @printDDep(i32 1321, i32 1327), !dbg !5613
  call void @printDDep(i32 1327, i32 1327), !dbg !5613
  %conv1.i.i1653.i = zext i8 %1503 to i32, !dbg !5613
  %sub.i.i1654.i = sub nsw i32 32, %conv1.i.i1653.i, !dbg !5614
  %shr.i.i1655.i = lshr i32 %1498, %sub.i.i1654.i, !dbg !5615
  %or.i.i1656.i = or i32 %shl.i.i1652.i, %shr.i.i1655.i, !dbg !5616
  %xor.i1657.i = xor i32 %1470, %or.i.i1656.i, !dbg !5617
  %1504 = load i32, i32* @Inst_Counter, !dbg !5618
  %1505 = add i32 6, %1504, !dbg !5618
  store i32 %1505, i32* @Inst_Counter, !dbg !5618
  %1506 = load i32, i32* @Inst_Counter, !dbg !5618
  call void @printCounter(i32 %1506), !dbg !5618
  %1507 = ptrtoint i32* %t.i1624.i to i64, !dbg !5618
  call void @printLoadAddr(i64 %1507, i32 1333, i32 123, i32 34), !dbg !5618
  %1508 = load i32, i32* %t.i1624.i, align 4, !dbg !5618
  call void @printDDep(i32 1275, i32 1333), !dbg !5618
  call void @printDDep(i32 1286, i32 1333), !dbg !5618
  call void @printDDep(i32 1297, i32 1333), !dbg !5618
  call void @printDDep(i32 1308, i32 1333), !dbg !5618
  call void @printDDep(i32 1317, i32 1333), !dbg !5618
  call void @printDDep(i32 1317, i32 1333), !dbg !5618
  call void @printDDep(i32 1333, i32 1333), !dbg !5618
  %1509 = load i32, i32* @Inst_Counter
  %1510 = add i32 1, %1509
  store i32 %1510, i32* @Inst_Counter
  %1511 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1511)
  %1512 = ptrtoint i32* %a.addr.i43.i1615.i to i64
  call void @printStoreAddr(i64 %1512, i32 1334, i32 0, i32 0)
  store i32 %1508, i32* %a.addr.i43.i1615.i, align 4
  call void @printDDep(i32 1333, i32 1334)
  call void @printDDep(i32 1334, i32 1334)
  call void @printDDep(i32 1321, i32 1334)
  call void @printDDep(i32 1334, i32 1334)
  %1513 = load i32, i32* @Inst_Counter
  %1514 = add i32 1, %1513
  store i32 %1514, i32* @Inst_Counter
  %1515 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1515)
  %1516 = ptrtoint i8* %n.addr.i44.i1616.i to i64
  call void @printStoreAddr(i64 %1516, i32 1335, i32 0, i32 0)
  store i8 10, i8* %n.addr.i44.i1616.i, align 1
  call void @printDDep(i32 1335, i32 1335)
  call void @printDDep(i32 1334, i32 1335)
  call void @printDDep(i32 1335, i32 1335)
  %1517 = load i32, i32* @Inst_Counter, !dbg !5619
  %1518 = add i32 1, %1517, !dbg !5619
  store i32 %1518, i32* @Inst_Counter, !dbg !5619
  %1519 = load i32, i32* @Inst_Counter, !dbg !5619
  call void @printCounter(i32 %1519), !dbg !5619
  %1520 = ptrtoint i32* %a.addr.i43.i1615.i to i64, !dbg !5619
  call void @printLoadAddr(i64 %1520, i32 1336, i32 92, i32 13), !dbg !5619
  %1521 = load i32, i32* %a.addr.i43.i1615.i, align 4, !dbg !5619
  call void @printDDep(i32 1334, i32 1336), !dbg !5619
  call void @printDDep(i32 1334, i32 1336), !dbg !5619
  call void @printDDep(i32 1336, i32 1336), !dbg !5619
  %1522 = load i32, i32* @Inst_Counter, !dbg !5620
  %1523 = add i32 1, %1522, !dbg !5620
  store i32 %1523, i32* @Inst_Counter, !dbg !5620
  %1524 = load i32, i32* @Inst_Counter, !dbg !5620
  call void @printCounter(i32 %1524), !dbg !5620
  %1525 = ptrtoint i8* %n.addr.i44.i1616.i to i64, !dbg !5620
  call void @printLoadAddr(i64 %1525, i32 1337, i32 92, i32 18), !dbg !5620
  %1526 = load i8, i8* %n.addr.i44.i1616.i, align 1, !dbg !5620
  call void @printDDep(i32 1335, i32 1337), !dbg !5620
  call void @printDDep(i32 1335, i32 1337), !dbg !5620
  call void @printDDep(i32 1337, i32 1337), !dbg !5620
  %conv.i45.i1658.i = zext i8 %1526 to i32, !dbg !5620
  %shl.i46.i1659.i = shl i32 %1521, %conv.i45.i1658.i, !dbg !5621
  %1527 = load i32, i32* @Inst_Counter, !dbg !5622
  %1528 = add i32 3, %1527, !dbg !5622
  store i32 %1528, i32* @Inst_Counter, !dbg !5622
  %1529 = load i32, i32* @Inst_Counter, !dbg !5622
  call void @printCounter(i32 %1529), !dbg !5622
  %1530 = ptrtoint i32* %a.addr.i43.i1615.i to i64, !dbg !5622
  call void @printLoadAddr(i64 %1530, i32 1340, i32 92, i32 24), !dbg !5622
  %1531 = load i32, i32* %a.addr.i43.i1615.i, align 4, !dbg !5622
  call void @printDDep(i32 1334, i32 1340), !dbg !5622
  call void @printDDep(i32 1334, i32 1340), !dbg !5622
  call void @printDDep(i32 1340, i32 1340), !dbg !5622
  %1532 = load i32, i32* @Inst_Counter, !dbg !5623
  %1533 = add i32 1, %1532, !dbg !5623
  store i32 %1533, i32* @Inst_Counter, !dbg !5623
  %1534 = load i32, i32* @Inst_Counter, !dbg !5623
  call void @printCounter(i32 %1534), !dbg !5623
  %1535 = ptrtoint i8* %n.addr.i44.i1616.i to i64, !dbg !5623
  call void @printLoadAddr(i64 %1535, i32 1341, i32 92, i32 35), !dbg !5623
  %1536 = load i8, i8* %n.addr.i44.i1616.i, align 1, !dbg !5623
  call void @printDDep(i32 1335, i32 1341), !dbg !5623
  call void @printDDep(i32 1335, i32 1341), !dbg !5623
  call void @printDDep(i32 1341, i32 1341), !dbg !5623
  %conv1.i47.i1660.i = zext i8 %1536 to i32, !dbg !5623
  %sub.i48.i1661.i = sub nsw i32 32, %conv1.i47.i1660.i, !dbg !5624
  %shr.i49.i1662.i = lshr i32 %1531, %sub.i48.i1661.i, !dbg !5625
  %or.i50.i1663.i = or i32 %shl.i46.i1659.i, %shr.i49.i1662.i, !dbg !5626
  %xor22.i1664.i = xor i32 %xor.i1657.i, %or.i50.i1663.i, !dbg !5627
  %1537 = load i32, i32* @Inst_Counter, !dbg !5628
  %1538 = add i32 6, %1537, !dbg !5628
  store i32 %1538, i32* @Inst_Counter, !dbg !5628
  %1539 = load i32, i32* @Inst_Counter, !dbg !5628
  call void @printCounter(i32 %1539), !dbg !5628
  %1540 = ptrtoint i32* %t.i1624.i to i64, !dbg !5628
  call void @printLoadAddr(i64 %1540, i32 1347, i32 123, i32 48), !dbg !5628
  %1541 = load i32, i32* %t.i1624.i, align 4, !dbg !5628
  call void @printDDep(i32 1275, i32 1347), !dbg !5628
  call void @printDDep(i32 1286, i32 1347), !dbg !5628
  call void @printDDep(i32 1297, i32 1347), !dbg !5628
  call void @printDDep(i32 1308, i32 1347), !dbg !5628
  call void @printDDep(i32 1317, i32 1347), !dbg !5628
  call void @printDDep(i32 1317, i32 1347), !dbg !5628
  call void @printDDep(i32 1347, i32 1347), !dbg !5628
  %1542 = load i32, i32* @Inst_Counter
  %1543 = add i32 1, %1542
  store i32 %1543, i32* @Inst_Counter
  %1544 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1544)
  %1545 = ptrtoint i32* %a.addr.i35.i1617.i to i64
  call void @printStoreAddr(i64 %1545, i32 1348, i32 0, i32 0)
  store i32 %1541, i32* %a.addr.i35.i1617.i, align 4
  call void @printDDep(i32 1347, i32 1348)
  call void @printDDep(i32 1348, i32 1348)
  call void @printDDep(i32 1335, i32 1348)
  call void @printDDep(i32 1348, i32 1348)
  %1546 = load i32, i32* @Inst_Counter
  %1547 = add i32 1, %1546
  store i32 %1547, i32* @Inst_Counter
  %1548 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1548)
  %1549 = ptrtoint i8* %n.addr.i36.i1618.i to i64
  call void @printStoreAddr(i64 %1549, i32 1349, i32 0, i32 0)
  store i8 18, i8* %n.addr.i36.i1618.i, align 1
  call void @printDDep(i32 1349, i32 1349)
  call void @printDDep(i32 1348, i32 1349)
  call void @printDDep(i32 1349, i32 1349)
  %1550 = load i32, i32* @Inst_Counter, !dbg !5629
  %1551 = add i32 1, %1550, !dbg !5629
  store i32 %1551, i32* @Inst_Counter, !dbg !5629
  %1552 = load i32, i32* @Inst_Counter, !dbg !5629
  call void @printCounter(i32 %1552), !dbg !5629
  %1553 = ptrtoint i32* %a.addr.i35.i1617.i to i64, !dbg !5629
  call void @printLoadAddr(i64 %1553, i32 1350, i32 92, i32 13), !dbg !5629
  %1554 = load i32, i32* %a.addr.i35.i1617.i, align 4, !dbg !5629
  call void @printDDep(i32 1348, i32 1350), !dbg !5629
  call void @printDDep(i32 1348, i32 1350), !dbg !5629
  call void @printDDep(i32 1350, i32 1350), !dbg !5629
  %1555 = load i32, i32* @Inst_Counter, !dbg !5630
  %1556 = add i32 1, %1555, !dbg !5630
  store i32 %1556, i32* @Inst_Counter, !dbg !5630
  %1557 = load i32, i32* @Inst_Counter, !dbg !5630
  call void @printCounter(i32 %1557), !dbg !5630
  %1558 = ptrtoint i8* %n.addr.i36.i1618.i to i64, !dbg !5630
  call void @printLoadAddr(i64 %1558, i32 1351, i32 92, i32 18), !dbg !5630
  %1559 = load i8, i8* %n.addr.i36.i1618.i, align 1, !dbg !5630
  call void @printDDep(i32 1349, i32 1351), !dbg !5630
  call void @printDDep(i32 1349, i32 1351), !dbg !5630
  call void @printDDep(i32 1351, i32 1351), !dbg !5630
  %conv.i37.i1665.i = zext i8 %1559 to i32, !dbg !5630
  %shl.i38.i1666.i = shl i32 %1554, %conv.i37.i1665.i, !dbg !5631
  %1560 = load i32, i32* @Inst_Counter, !dbg !5632
  %1561 = add i32 3, %1560, !dbg !5632
  store i32 %1561, i32* @Inst_Counter, !dbg !5632
  %1562 = load i32, i32* @Inst_Counter, !dbg !5632
  call void @printCounter(i32 %1562), !dbg !5632
  %1563 = ptrtoint i32* %a.addr.i35.i1617.i to i64, !dbg !5632
  call void @printLoadAddr(i64 %1563, i32 1354, i32 92, i32 24), !dbg !5632
  %1564 = load i32, i32* %a.addr.i35.i1617.i, align 4, !dbg !5632
  call void @printDDep(i32 1348, i32 1354), !dbg !5632
  call void @printDDep(i32 1348, i32 1354), !dbg !5632
  call void @printDDep(i32 1354, i32 1354), !dbg !5632
  %1565 = load i32, i32* @Inst_Counter, !dbg !5633
  %1566 = add i32 1, %1565, !dbg !5633
  store i32 %1566, i32* @Inst_Counter, !dbg !5633
  %1567 = load i32, i32* @Inst_Counter, !dbg !5633
  call void @printCounter(i32 %1567), !dbg !5633
  %1568 = ptrtoint i8* %n.addr.i36.i1618.i to i64, !dbg !5633
  call void @printLoadAddr(i64 %1568, i32 1355, i32 92, i32 35), !dbg !5633
  %1569 = load i8, i8* %n.addr.i36.i1618.i, align 1, !dbg !5633
  call void @printDDep(i32 1349, i32 1355), !dbg !5633
  call void @printDDep(i32 1349, i32 1355), !dbg !5633
  call void @printDDep(i32 1355, i32 1355), !dbg !5633
  %conv1.i39.i1667.i = zext i8 %1569 to i32, !dbg !5633
  %sub.i40.i1668.i = sub nsw i32 32, %conv1.i39.i1667.i, !dbg !5634
  %shr.i41.i1669.i = lshr i32 %1564, %sub.i40.i1668.i, !dbg !5635
  %or.i42.i1670.i = or i32 %shl.i38.i1666.i, %shr.i41.i1669.i, !dbg !5636
  %xor24.i1671.i = xor i32 %xor22.i1664.i, %or.i42.i1670.i, !dbg !5637
  %1570 = load i32, i32* @Inst_Counter, !dbg !5638
  %1571 = add i32 6, %1570, !dbg !5638
  store i32 %1571, i32* @Inst_Counter, !dbg !5638
  %1572 = load i32, i32* @Inst_Counter, !dbg !5638
  call void @printCounter(i32 %1572), !dbg !5638
  %1573 = ptrtoint i32* %t.i1624.i to i64, !dbg !5638
  call void @printLoadAddr(i64 %1573, i32 1361, i32 123, i32 62), !dbg !5638
  %1574 = load i32, i32* %t.i1624.i, align 4, !dbg !5638
  call void @printDDep(i32 1275, i32 1361), !dbg !5638
  call void @printDDep(i32 1286, i32 1361), !dbg !5638
  call void @printDDep(i32 1297, i32 1361), !dbg !5638
  call void @printDDep(i32 1308, i32 1361), !dbg !5638
  call void @printDDep(i32 1317, i32 1361), !dbg !5638
  call void @printDDep(i32 1317, i32 1361), !dbg !5638
  call void @printDDep(i32 1361, i32 1361), !dbg !5638
  %1575 = load i32, i32* @Inst_Counter
  %1576 = add i32 1, %1575
  store i32 %1576, i32* @Inst_Counter
  %1577 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1577)
  %1578 = ptrtoint i32* %a.addr.i27.i1619.i to i64
  call void @printStoreAddr(i64 %1578, i32 1362, i32 0, i32 0)
  store i32 %1574, i32* %a.addr.i27.i1619.i, align 4
  call void @printDDep(i32 1361, i32 1362)
  call void @printDDep(i32 1362, i32 1362)
  call void @printDDep(i32 1349, i32 1362)
  call void @printDDep(i32 1362, i32 1362)
  %1579 = load i32, i32* @Inst_Counter
  %1580 = add i32 1, %1579
  store i32 %1580, i32* @Inst_Counter
  %1581 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1581)
  %1582 = ptrtoint i8* %n.addr.i28.i1620.i to i64
  call void @printStoreAddr(i64 %1582, i32 1363, i32 0, i32 0)
  store i8 24, i8* %n.addr.i28.i1620.i, align 1
  call void @printDDep(i32 1363, i32 1363)
  call void @printDDep(i32 1362, i32 1363)
  call void @printDDep(i32 1363, i32 1363)
  %1583 = load i32, i32* @Inst_Counter, !dbg !5639
  %1584 = add i32 1, %1583, !dbg !5639
  store i32 %1584, i32* @Inst_Counter, !dbg !5639
  %1585 = load i32, i32* @Inst_Counter, !dbg !5639
  call void @printCounter(i32 %1585), !dbg !5639
  %1586 = ptrtoint i32* %a.addr.i27.i1619.i to i64, !dbg !5639
  call void @printLoadAddr(i64 %1586, i32 1364, i32 92, i32 13), !dbg !5639
  %1587 = load i32, i32* %a.addr.i27.i1619.i, align 4, !dbg !5639
  call void @printDDep(i32 1362, i32 1364), !dbg !5639
  call void @printDDep(i32 1362, i32 1364), !dbg !5639
  call void @printDDep(i32 1364, i32 1364), !dbg !5639
  %1588 = load i32, i32* @Inst_Counter, !dbg !5640
  %1589 = add i32 1, %1588, !dbg !5640
  store i32 %1589, i32* @Inst_Counter, !dbg !5640
  %1590 = load i32, i32* @Inst_Counter, !dbg !5640
  call void @printCounter(i32 %1590), !dbg !5640
  %1591 = ptrtoint i8* %n.addr.i28.i1620.i to i64, !dbg !5640
  call void @printLoadAddr(i64 %1591, i32 1365, i32 92, i32 18), !dbg !5640
  %1592 = load i8, i8* %n.addr.i28.i1620.i, align 1, !dbg !5640
  call void @printDDep(i32 1363, i32 1365), !dbg !5640
  call void @printDDep(i32 1363, i32 1365), !dbg !5640
  call void @printDDep(i32 1365, i32 1365), !dbg !5640
  %conv.i29.i1672.i = zext i8 %1592 to i32, !dbg !5640
  %shl.i30.i1673.i = shl i32 %1587, %conv.i29.i1672.i, !dbg !5641
  %1593 = load i32, i32* @Inst_Counter, !dbg !5642
  %1594 = add i32 3, %1593, !dbg !5642
  store i32 %1594, i32* @Inst_Counter, !dbg !5642
  %1595 = load i32, i32* @Inst_Counter, !dbg !5642
  call void @printCounter(i32 %1595), !dbg !5642
  %1596 = ptrtoint i32* %a.addr.i27.i1619.i to i64, !dbg !5642
  call void @printLoadAddr(i64 %1596, i32 1368, i32 92, i32 24), !dbg !5642
  %1597 = load i32, i32* %a.addr.i27.i1619.i, align 4, !dbg !5642
  call void @printDDep(i32 1362, i32 1368), !dbg !5642
  call void @printDDep(i32 1362, i32 1368), !dbg !5642
  call void @printDDep(i32 1368, i32 1368), !dbg !5642
  %1598 = load i32, i32* @Inst_Counter, !dbg !5643
  %1599 = add i32 1, %1598, !dbg !5643
  store i32 %1599, i32* @Inst_Counter, !dbg !5643
  %1600 = load i32, i32* @Inst_Counter, !dbg !5643
  call void @printCounter(i32 %1600), !dbg !5643
  %1601 = ptrtoint i8* %n.addr.i28.i1620.i to i64, !dbg !5643
  call void @printLoadAddr(i64 %1601, i32 1369, i32 92, i32 35), !dbg !5643
  %1602 = load i8, i8* %n.addr.i28.i1620.i, align 1, !dbg !5643
  call void @printDDep(i32 1363, i32 1369), !dbg !5643
  call void @printDDep(i32 1363, i32 1369), !dbg !5643
  call void @printDDep(i32 1369, i32 1369), !dbg !5643
  %conv1.i31.i1674.i = zext i8 %1602 to i32, !dbg !5643
  %sub.i32.i1675.i = sub nsw i32 32, %conv1.i31.i1674.i, !dbg !5644
  %shr.i33.i1676.i = lshr i32 %1597, %sub.i32.i1675.i, !dbg !5645
  %or.i34.i1677.i = or i32 %shl.i30.i1673.i, %shr.i33.i1676.i, !dbg !5646
  %xor26.i1678.i = xor i32 %xor24.i1671.i, %or.i34.i1677.i, !dbg !5647
  %1603 = load i32, i32* @Inst_Counter, !dbg !5515
  %1604 = add i32 6, %1603, !dbg !5515
  store i32 %1604, i32* @Inst_Counter, !dbg !5515
  %1605 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1605), !dbg !5515
  %1606 = ptrtoint i32* %B1.i to i64, !dbg !5515
  call void @printLoadAddr(i64 %1606, i32 1375, i32 200, i32 5), !dbg !5515
  %1607 = load i32, i32* %B1.i, align 4, !dbg !5515
  call void @printDDep(i32 1067, i32 1375), !dbg !5515
  call void @printDDep(i32 1377, i32 1375), !dbg !5515
  call void @printDDep(i32 1757, i32 1375), !dbg !5515
  call void @printDDep(i32 2061, i32 1375), !dbg !5515
  call void @printDDep(i32 2365, i32 1375), !dbg !5515
  call void @printDDep(i32 2669, i32 1375), !dbg !5515
  call void @printDDep(i32 2973, i32 1375), !dbg !5515
  call void @printDDep(i32 3277, i32 1375), !dbg !5515
  call void @printDDep(i32 3657, i32 1375), !dbg !5515
  call void @printDDep(i32 1067, i32 1375), !dbg !5515
  call void @printDDep(i32 1375, i32 1375), !dbg !5515
  %xor15.i55 = xor i32 %1607, %xor26.i1678.i, !dbg !5515
  %1608 = load i32, i32* @Inst_Counter, !dbg !5515
  %1609 = add i32 2, %1608, !dbg !5515
  store i32 %1609, i32* @Inst_Counter, !dbg !5515
  %1610 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1610), !dbg !5515
  %1611 = ptrtoint i32* %B1.i to i64, !dbg !5515
  call void @printStoreAddr(i64 %1611, i32 1377, i32 200, i32 5), !dbg !5515
  store i32 %xor15.i55, i32* %B1.i, align 4, !dbg !5515
  call void @printDDep(i32 1067, i32 1377), !dbg !5515
  call void @printDDep(i32 1318, i32 1377), !dbg !5515
  call void @printDDep(i32 1322, i32 1377), !dbg !5515
  call void @printDDep(i32 1323, i32 1377), !dbg !5515
  call void @printDDep(i32 1326, i32 1377), !dbg !5515
  call void @printDDep(i32 1327, i32 1377), !dbg !5515
  call void @printDDep(i32 1336, i32 1377), !dbg !5515
  call void @printDDep(i32 1337, i32 1377), !dbg !5515
  call void @printDDep(i32 1340, i32 1377), !dbg !5515
  call void @printDDep(i32 1341, i32 1377), !dbg !5515
  call void @printDDep(i32 1350, i32 1377), !dbg !5515
  call void @printDDep(i32 1351, i32 1377), !dbg !5515
  call void @printDDep(i32 1354, i32 1377), !dbg !5515
  call void @printDDep(i32 1355, i32 1377), !dbg !5515
  call void @printDDep(i32 1364, i32 1377), !dbg !5515
  call void @printDDep(i32 1365, i32 1377), !dbg !5515
  call void @printDDep(i32 1368, i32 1377), !dbg !5515
  call void @printDDep(i32 1369, i32 1377), !dbg !5515
  call void @printDDep(i32 1375, i32 1377), !dbg !5515
  call void @printDDep(i32 1377, i32 1377), !dbg !5515
  call void @printDDep(i32 1757, i32 1377), !dbg !5515
  call void @printDDep(i32 2061, i32 1377), !dbg !5515
  call void @printDDep(i32 2365, i32 1377), !dbg !5515
  call void @printDDep(i32 2669, i32 1377), !dbg !5515
  call void @printDDep(i32 2973, i32 1377), !dbg !5515
  call void @printDDep(i32 3277, i32 1377), !dbg !5515
  call void @printDDep(i32 3657, i32 1377), !dbg !5515
  call void @printDDep(i32 1363, i32 1377), !dbg !5515
  call void @printDDep(i32 1377, i32 1377), !dbg !5515
  %1612 = load i32, i32* @Inst_Counter, !dbg !5515
  %1613 = add i32 1, %1612, !dbg !5515
  store i32 %1613, i32* @Inst_Counter, !dbg !5515
  %1614 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1614), !dbg !5515
  %1615 = ptrtoint i32* %B0.i to i64, !dbg !5515
  call void @printLoadAddr(i64 %1615, i32 1378, i32 200, i32 5), !dbg !5515
  %1616 = load i32, i32* %B0.i, align 4, !dbg !5515
  call void @printDDep(i32 1026, i32 1378), !dbg !5515
  call void @printDDep(i32 1263, i32 1378), !dbg !5515
  call void @printDDep(i32 1681, i32 1378), !dbg !5515
  call void @printDDep(i32 1985, i32 1378), !dbg !5515
  call void @printDDep(i32 2289, i32 1378), !dbg !5515
  call void @printDDep(i32 2593, i32 1378), !dbg !5515
  call void @printDDep(i32 2897, i32 1378), !dbg !5515
  call void @printDDep(i32 3201, i32 1378), !dbg !5515
  call void @printDDep(i32 3543, i32 1378), !dbg !5515
  call void @printDDep(i32 1263, i32 1378), !dbg !5515
  call void @printDDep(i32 1378, i32 1378), !dbg !5515
  %1617 = load i32, i32* @Inst_Counter, !dbg !5515
  %1618 = add i32 1, %1617, !dbg !5515
  store i32 %1618, i32* @Inst_Counter, !dbg !5515
  %1619 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1619), !dbg !5515
  %1620 = ptrtoint i32* %B1.i to i64, !dbg !5515
  call void @printLoadAddr(i64 %1620, i32 1379, i32 200, i32 5), !dbg !5515
  %1621 = load i32, i32* %B1.i, align 4, !dbg !5515
  call void @printDDep(i32 1067, i32 1379), !dbg !5515
  call void @printDDep(i32 1377, i32 1379), !dbg !5515
  call void @printDDep(i32 1757, i32 1379), !dbg !5515
  call void @printDDep(i32 2061, i32 1379), !dbg !5515
  call void @printDDep(i32 2365, i32 1379), !dbg !5515
  call void @printDDep(i32 2669, i32 1379), !dbg !5515
  call void @printDDep(i32 2973, i32 1379), !dbg !5515
  call void @printDDep(i32 3277, i32 1379), !dbg !5515
  call void @printDDep(i32 3657, i32 1379), !dbg !5515
  call void @printDDep(i32 1377, i32 1379), !dbg !5515
  call void @printDDep(i32 1379, i32 1379), !dbg !5515
  %xor16.i = xor i32 %1616, %1621, !dbg !5515
  %1622 = load i32, i32* @Inst_Counter, !dbg !5515
  %1623 = add i32 2, %1622, !dbg !5515
  store i32 %1623, i32* @Inst_Counter, !dbg !5515
  %1624 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1624), !dbg !5515
  %1625 = ptrtoint i32* %B3.i to i64, !dbg !5515
  call void @printLoadAddr(i64 %1625, i32 1381, i32 200, i32 5), !dbg !5515
  %1626 = load i32, i32* %B3.i, align 4, !dbg !5515
  call void @printDDep(i32 1149, i32 1381), !dbg !5515
  call void @printDDep(i32 1605, i32 1381), !dbg !5515
  call void @printDDep(i32 1909, i32 1381), !dbg !5515
  call void @printDDep(i32 2213, i32 1381), !dbg !5515
  call void @printDDep(i32 2517, i32 1381), !dbg !5515
  call void @printDDep(i32 2821, i32 1381), !dbg !5515
  call void @printDDep(i32 3125, i32 1381), !dbg !5515
  call void @printDDep(i32 3429, i32 1381), !dbg !5515
  call void @printDDep(i32 3885, i32 1381), !dbg !5515
  call void @printDDep(i32 1149, i32 1381), !dbg !5515
  call void @printDDep(i32 1381, i32 1381), !dbg !5515
  %xor17.i = xor i32 %xor16.i, %1626, !dbg !5515
  %1627 = load i32, i32* @Inst_Counter, !dbg !5515
  %1628 = add i32 2, %1627, !dbg !5515
  store i32 %1628, i32* @Inst_Counter, !dbg !5515
  %1629 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1629), !dbg !5515
  %1630 = ptrtoint %struct.SM4_KEY_st** %ks.addr.i24 to i64, !dbg !5515
  call void @printLoadAddr(i64 %1630, i32 1383, i32 200, i32 5), !dbg !5515
  %1631 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr.i24, align 8, !dbg !5515
  call void @printDDep(i32 983, i32 1383), !dbg !5515
  call void @printDDep(i32 985, i32 1383), !dbg !5515
  call void @printDDep(i32 1383, i32 1383), !dbg !5515
  %rk18.i = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %1631, i32 0, i32 0, !dbg !5515
  %arrayidx19.i56 = getelementptr inbounds [32 x i32], [32 x i32]* %rk18.i, i64 0, i64 2, !dbg !5515
  %1632 = load i32, i32* @Inst_Counter, !dbg !5515
  %1633 = add i32 3, %1632, !dbg !5515
  store i32 %1633, i32* @Inst_Counter, !dbg !5515
  %1634 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1634), !dbg !5515
  %1635 = ptrtoint i32* %arrayidx19.i56 to i64, !dbg !5515
  call void @printLoadAddr(i64 %1635, i32 1386, i32 200, i32 5), !dbg !5515
  %1636 = load i32, i32* %arrayidx19.i56, align 4, !dbg !5515
  call void @printDDep(i32 1383, i32 1386), !dbg !5515
  call void @printDDep(i32 985, i32 1386), !dbg !5515
  call void @printDDep(i32 1386, i32 1386), !dbg !5515
  %xor20.i57 = xor i32 %xor17.i, %1636, !dbg !5515
  %1637 = load i32, i32* @Inst_Counter
  %1638 = add i32 2, %1637
  store i32 %1638, i32* @Inst_Counter
  %1639 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1639)
  %1640 = ptrtoint i32* %X.addr.i1559.i to i64
  call void @printStoreAddr(i64 %1640, i32 1388, i32 0, i32 0)
  store i32 %xor20.i57, i32* %X.addr.i1559.i, align 4
  call void @printDDep(i32 1378, i32 1388)
  call void @printDDep(i32 1379, i32 1388)
  call void @printDDep(i32 1381, i32 1388)
  call void @printDDep(i32 1386, i32 1388)
  call void @printDDep(i32 1388, i32 1388)
  call void @printDDep(i32 1377, i32 1388)
  call void @printDDep(i32 1388, i32 1388)
  %1641 = load i32, i32* @Inst_Counter, !dbg !4729
  %1642 = add i32 1, %1641, !dbg !4729
  store i32 %1642, i32* @Inst_Counter, !dbg !4729
  %1643 = load i32, i32* @Inst_Counter, !dbg !4729
  call void @printCounter(i32 %1643), !dbg !4729
  %1644 = ptrtoint i32* %t.i1560.i to i64, !dbg !4729
  call void @printStoreAddr(i64 %1644, i32 1389, i32 113, i32 14), !dbg !4729
  store i32 0, i32* %t.i1560.i, align 4, !dbg !4729
  call void @printDDep(i32 1389, i32 1389), !dbg !4729
  call void @printDDep(i32 1400, i32 1389), !dbg !4729
  call void @printDDep(i32 1411, i32 1389), !dbg !4729
  call void @printDDep(i32 1422, i32 1389), !dbg !4729
  call void @printDDep(i32 1431, i32 1389), !dbg !4729
  call void @printDDep(i32 1388, i32 1389), !dbg !4729
  call void @printDDep(i32 1389, i32 1389), !dbg !4729
  %1645 = load i32, i32* @Inst_Counter, !dbg !5648
  %1646 = add i32 1, %1645, !dbg !5648
  store i32 %1646, i32* @Inst_Counter, !dbg !5648
  %1647 = load i32, i32* @Inst_Counter, !dbg !5648
  call void @printCounter(i32 %1647), !dbg !5648
  %1648 = ptrtoint i32* %X.addr.i1559.i to i64, !dbg !5648
  call void @printLoadAddr(i64 %1648, i32 1390, i32 115, i32 37), !dbg !5648
  %1649 = load i32, i32* %X.addr.i1559.i, align 4, !dbg !5648
  call void @printDDep(i32 1388, i32 1390), !dbg !5648
  call void @printDDep(i32 1388, i32 1390), !dbg !5648
  call void @printDDep(i32 1390, i32 1390), !dbg !5648
  %shr.i1561.i = lshr i32 %1649, 24, !dbg !5649
  %conv.i1562.i = trunc i32 %shr.i1561.i to i8, !dbg !5650
  %idxprom.i1563.i = zext i8 %conv.i1562.i to i64, !dbg !5651
  %arrayidx.i1564.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom.i1563.i, !dbg !5651
  %1650 = load i32, i32* @Inst_Counter, !dbg !5651
  %1651 = add i32 5, %1650, !dbg !5651
  store i32 %1651, i32* @Inst_Counter, !dbg !5651
  %1652 = load i32, i32* @Inst_Counter, !dbg !5651
  call void @printCounter(i32 %1652), !dbg !5651
  %1653 = ptrtoint i8* %arrayidx.i1564.i to i64, !dbg !5651
  %1654 = load [256 x i8], [256 x i8]* @SM4_S, !dbg !5651
  call void @printSymLoadAddr(i64 %1653, i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 add (i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 255), i32 1, i32 1395, i32 115, i32 21), !dbg !5651
  %1655 = load i8, i8* %arrayidx.i1564.i, align 1, !dbg !5651
  call void @printDDep(i32 1390, i32 1395), !dbg !5651
  call void @printDDep(i32 1395, i32 1395), !dbg !5651
  %conv1.i1565.i = zext i8 %1655 to i32, !dbg !5652
  %shl.i1566.i = shl i32 %conv1.i1565.i, 24, !dbg !5653
  %1656 = load i32, i32* @Inst_Counter, !dbg !5654
  %1657 = add i32 3, %1656, !dbg !5654
  store i32 %1657, i32* @Inst_Counter, !dbg !5654
  %1658 = load i32, i32* @Inst_Counter, !dbg !5654
  call void @printCounter(i32 %1658), !dbg !5654
  %1659 = ptrtoint i32* %t.i1560.i to i64, !dbg !5654
  call void @printLoadAddr(i64 %1659, i32 1398, i32 115, i32 7), !dbg !5654
  %1660 = load i32, i32* %t.i1560.i, align 4, !dbg !5654
  call void @printDDep(i32 1389, i32 1398), !dbg !5654
  call void @printDDep(i32 1400, i32 1398), !dbg !5654
  call void @printDDep(i32 1411, i32 1398), !dbg !5654
  call void @printDDep(i32 1422, i32 1398), !dbg !5654
  call void @printDDep(i32 1431, i32 1398), !dbg !5654
  call void @printDDep(i32 1389, i32 1398), !dbg !5654
  call void @printDDep(i32 1398, i32 1398), !dbg !5654
  %or.i1567.i = or i32 %1660, %shl.i1566.i, !dbg !5654
  %1661 = load i32, i32* @Inst_Counter, !dbg !5654
  %1662 = add i32 2, %1661, !dbg !5654
  store i32 %1662, i32* @Inst_Counter, !dbg !5654
  %1663 = load i32, i32* @Inst_Counter, !dbg !5654
  call void @printCounter(i32 %1663), !dbg !5654
  %1664 = ptrtoint i32* %t.i1560.i to i64, !dbg !5654
  call void @printStoreAddr(i64 %1664, i32 1400, i32 115, i32 7), !dbg !5654
  store i32 %or.i1567.i, i32* %t.i1560.i, align 4, !dbg !5654
  call void @printDDep(i32 1389, i32 1400), !dbg !5654
  call void @printDDep(i32 1395, i32 1400), !dbg !5654
  call void @printDDep(i32 1398, i32 1400), !dbg !5654
  call void @printDDep(i32 1400, i32 1400), !dbg !5654
  call void @printDDep(i32 1411, i32 1400), !dbg !5654
  call void @printDDep(i32 1422, i32 1400), !dbg !5654
  call void @printDDep(i32 1431, i32 1400), !dbg !5654
  call void @printDDep(i32 1389, i32 1400), !dbg !5654
  call void @printDDep(i32 1400, i32 1400), !dbg !5654
  %1665 = load i32, i32* @Inst_Counter, !dbg !5655
  %1666 = add i32 1, %1665, !dbg !5655
  store i32 %1666, i32* @Inst_Counter, !dbg !5655
  %1667 = load i32, i32* @Inst_Counter, !dbg !5655
  call void @printCounter(i32 %1667), !dbg !5655
  %1668 = ptrtoint i32* %X.addr.i1559.i to i64, !dbg !5655
  call void @printLoadAddr(i64 %1668, i32 1401, i32 116, i32 37), !dbg !5655
  %1669 = load i32, i32* %X.addr.i1559.i, align 4, !dbg !5655
  call void @printDDep(i32 1388, i32 1401), !dbg !5655
  call void @printDDep(i32 1388, i32 1401), !dbg !5655
  call void @printDDep(i32 1401, i32 1401), !dbg !5655
  %shr2.i1568.i = lshr i32 %1669, 16, !dbg !5656
  %conv3.i1569.i = trunc i32 %shr2.i1568.i to i8, !dbg !5657
  %idxprom4.i1570.i = zext i8 %conv3.i1569.i to i64, !dbg !5658
  %arrayidx5.i1571.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom4.i1570.i, !dbg !5658
  %1670 = load i32, i32* @Inst_Counter, !dbg !5658
  %1671 = add i32 5, %1670, !dbg !5658
  store i32 %1671, i32* @Inst_Counter, !dbg !5658
  %1672 = load i32, i32* @Inst_Counter, !dbg !5658
  call void @printCounter(i32 %1672), !dbg !5658
  %1673 = ptrtoint i8* %arrayidx5.i1571.i to i64, !dbg !5658
  %1674 = load [256 x i8], [256 x i8]* @SM4_S, !dbg !5658
  call void @printSymLoadAddr(i64 %1673, i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 add (i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 255), i32 1, i32 1406, i32 116, i32 21), !dbg !5658
  %1675 = load i8, i8* %arrayidx5.i1571.i, align 1, !dbg !5658
  call void @printDDep(i32 1401, i32 1406), !dbg !5658
  call void @printDDep(i32 1406, i32 1406), !dbg !5658
  %conv6.i1572.i = zext i8 %1675 to i32, !dbg !5659
  %shl7.i1573.i = shl i32 %conv6.i1572.i, 16, !dbg !5660
  %1676 = load i32, i32* @Inst_Counter, !dbg !5661
  %1677 = add i32 3, %1676, !dbg !5661
  store i32 %1677, i32* @Inst_Counter, !dbg !5661
  %1678 = load i32, i32* @Inst_Counter, !dbg !5661
  call void @printCounter(i32 %1678), !dbg !5661
  %1679 = ptrtoint i32* %t.i1560.i to i64, !dbg !5661
  call void @printLoadAddr(i64 %1679, i32 1409, i32 116, i32 7), !dbg !5661
  %1680 = load i32, i32* %t.i1560.i, align 4, !dbg !5661
  call void @printDDep(i32 1389, i32 1409), !dbg !5661
  call void @printDDep(i32 1400, i32 1409), !dbg !5661
  call void @printDDep(i32 1411, i32 1409), !dbg !5661
  call void @printDDep(i32 1422, i32 1409), !dbg !5661
  call void @printDDep(i32 1431, i32 1409), !dbg !5661
  call void @printDDep(i32 1400, i32 1409), !dbg !5661
  call void @printDDep(i32 1409, i32 1409), !dbg !5661
  %or8.i1574.i = or i32 %1680, %shl7.i1573.i, !dbg !5661
  %1681 = load i32, i32* @Inst_Counter, !dbg !5661
  %1682 = add i32 2, %1681, !dbg !5661
  store i32 %1682, i32* @Inst_Counter, !dbg !5661
  %1683 = load i32, i32* @Inst_Counter, !dbg !5661
  call void @printCounter(i32 %1683), !dbg !5661
  %1684 = ptrtoint i32* %t.i1560.i to i64, !dbg !5661
  call void @printStoreAddr(i64 %1684, i32 1411, i32 116, i32 7), !dbg !5661
  store i32 %or8.i1574.i, i32* %t.i1560.i, align 4, !dbg !5661
  call void @printDDep(i32 1389, i32 1411), !dbg !5661
  call void @printDDep(i32 1400, i32 1411), !dbg !5661
  call void @printDDep(i32 1406, i32 1411), !dbg !5661
  call void @printDDep(i32 1409, i32 1411), !dbg !5661
  call void @printDDep(i32 1411, i32 1411), !dbg !5661
  call void @printDDep(i32 1422, i32 1411), !dbg !5661
  call void @printDDep(i32 1431, i32 1411), !dbg !5661
  call void @printDDep(i32 1400, i32 1411), !dbg !5661
  call void @printDDep(i32 1411, i32 1411), !dbg !5661
  %1685 = load i32, i32* @Inst_Counter, !dbg !5662
  %1686 = add i32 1, %1685, !dbg !5662
  store i32 %1686, i32* @Inst_Counter, !dbg !5662
  %1687 = load i32, i32* @Inst_Counter, !dbg !5662
  call void @printCounter(i32 %1687), !dbg !5662
  %1688 = ptrtoint i32* %X.addr.i1559.i to i64, !dbg !5662
  call void @printLoadAddr(i64 %1688, i32 1412, i32 117, i32 37), !dbg !5662
  %1689 = load i32, i32* %X.addr.i1559.i, align 4, !dbg !5662
  call void @printDDep(i32 1388, i32 1412), !dbg !5662
  call void @printDDep(i32 1388, i32 1412), !dbg !5662
  call void @printDDep(i32 1412, i32 1412), !dbg !5662
  %shr9.i1575.i = lshr i32 %1689, 8, !dbg !5663
  %conv10.i1576.i = trunc i32 %shr9.i1575.i to i8, !dbg !5664
  %idxprom11.i1577.i = zext i8 %conv10.i1576.i to i64, !dbg !5665
  %arrayidx12.i1578.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom11.i1577.i, !dbg !5665
  %1690 = load i32, i32* @Inst_Counter, !dbg !5665
  %1691 = add i32 5, %1690, !dbg !5665
  store i32 %1691, i32* @Inst_Counter, !dbg !5665
  %1692 = load i32, i32* @Inst_Counter, !dbg !5665
  call void @printCounter(i32 %1692), !dbg !5665
  %1693 = ptrtoint i8* %arrayidx12.i1578.i to i64, !dbg !5665
  %1694 = load [256 x i8], [256 x i8]* @SM4_S, !dbg !5665
  call void @printSymLoadAddr(i64 %1693, i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 add (i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 255), i32 1, i32 1417, i32 117, i32 21), !dbg !5665
  %1695 = load i8, i8* %arrayidx12.i1578.i, align 1, !dbg !5665
  call void @printDDep(i32 1412, i32 1417), !dbg !5665
  call void @printDDep(i32 1417, i32 1417), !dbg !5665
  %conv13.i1579.i = zext i8 %1695 to i32, !dbg !5666
  %shl14.i1580.i = shl i32 %conv13.i1579.i, 8, !dbg !5667
  %1696 = load i32, i32* @Inst_Counter, !dbg !5668
  %1697 = add i32 3, %1696, !dbg !5668
  store i32 %1697, i32* @Inst_Counter, !dbg !5668
  %1698 = load i32, i32* @Inst_Counter, !dbg !5668
  call void @printCounter(i32 %1698), !dbg !5668
  %1699 = ptrtoint i32* %t.i1560.i to i64, !dbg !5668
  call void @printLoadAddr(i64 %1699, i32 1420, i32 117, i32 7), !dbg !5668
  %1700 = load i32, i32* %t.i1560.i, align 4, !dbg !5668
  call void @printDDep(i32 1389, i32 1420), !dbg !5668
  call void @printDDep(i32 1400, i32 1420), !dbg !5668
  call void @printDDep(i32 1411, i32 1420), !dbg !5668
  call void @printDDep(i32 1422, i32 1420), !dbg !5668
  call void @printDDep(i32 1431, i32 1420), !dbg !5668
  call void @printDDep(i32 1411, i32 1420), !dbg !5668
  call void @printDDep(i32 1420, i32 1420), !dbg !5668
  %or15.i1581.i = or i32 %1700, %shl14.i1580.i, !dbg !5668
  %1701 = load i32, i32* @Inst_Counter, !dbg !5668
  %1702 = add i32 2, %1701, !dbg !5668
  store i32 %1702, i32* @Inst_Counter, !dbg !5668
  %1703 = load i32, i32* @Inst_Counter, !dbg !5668
  call void @printCounter(i32 %1703), !dbg !5668
  %1704 = ptrtoint i32* %t.i1560.i to i64, !dbg !5668
  call void @printStoreAddr(i64 %1704, i32 1422, i32 117, i32 7), !dbg !5668
  store i32 %or15.i1581.i, i32* %t.i1560.i, align 4, !dbg !5668
  call void @printDDep(i32 1389, i32 1422), !dbg !5668
  call void @printDDep(i32 1400, i32 1422), !dbg !5668
  call void @printDDep(i32 1411, i32 1422), !dbg !5668
  call void @printDDep(i32 1417, i32 1422), !dbg !5668
  call void @printDDep(i32 1420, i32 1422), !dbg !5668
  call void @printDDep(i32 1422, i32 1422), !dbg !5668
  call void @printDDep(i32 1431, i32 1422), !dbg !5668
  call void @printDDep(i32 1411, i32 1422), !dbg !5668
  call void @printDDep(i32 1422, i32 1422), !dbg !5668
  %1705 = load i32, i32* @Inst_Counter, !dbg !5669
  %1706 = add i32 1, %1705, !dbg !5669
  store i32 %1706, i32* @Inst_Counter, !dbg !5669
  %1707 = load i32, i32* @Inst_Counter, !dbg !5669
  call void @printCounter(i32 %1707), !dbg !5669
  %1708 = ptrtoint i32* %X.addr.i1559.i to i64, !dbg !5669
  call void @printLoadAddr(i64 %1708, i32 1423, i32 118, i32 25), !dbg !5669
  %1709 = load i32, i32* %X.addr.i1559.i, align 4, !dbg !5669
  call void @printDDep(i32 1388, i32 1423), !dbg !5669
  call void @printDDep(i32 1388, i32 1423), !dbg !5669
  call void @printDDep(i32 1423, i32 1423), !dbg !5669
  %conv16.i1582.i = trunc i32 %1709 to i8, !dbg !5670
  %idxprom17.i1583.i = zext i8 %conv16.i1582.i to i64, !dbg !5671
  %arrayidx18.i1584.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom17.i1583.i, !dbg !5671
  %1710 = load i32, i32* @Inst_Counter, !dbg !5671
  %1711 = add i32 4, %1710, !dbg !5671
  store i32 %1711, i32* @Inst_Counter, !dbg !5671
  %1712 = load i32, i32* @Inst_Counter, !dbg !5671
  call void @printCounter(i32 %1712), !dbg !5671
  %1713 = ptrtoint i8* %arrayidx18.i1584.i to i64, !dbg !5671
  %1714 = load [256 x i8], [256 x i8]* @SM4_S, !dbg !5671
  call void @printSymLoadAddr(i64 %1713, i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 add (i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 255), i32 1, i32 1427, i32 118, i32 10), !dbg !5671
  %1715 = load i8, i8* %arrayidx18.i1584.i, align 1, !dbg !5671
  call void @printDDep(i32 1423, i32 1427), !dbg !5671
  call void @printDDep(i32 1427, i32 1427), !dbg !5671
  %conv19.i1585.i = zext i8 %1715 to i32, !dbg !5671
  %1716 = load i32, i32* @Inst_Counter, !dbg !5672
  %1717 = add i32 2, %1716, !dbg !5672
  store i32 %1717, i32* @Inst_Counter, !dbg !5672
  %1718 = load i32, i32* @Inst_Counter, !dbg !5672
  call void @printCounter(i32 %1718), !dbg !5672
  %1719 = ptrtoint i32* %t.i1560.i to i64, !dbg !5672
  call void @printLoadAddr(i64 %1719, i32 1429, i32 118, i32 7), !dbg !5672
  %1720 = load i32, i32* %t.i1560.i, align 4, !dbg !5672
  call void @printDDep(i32 1389, i32 1429), !dbg !5672
  call void @printDDep(i32 1400, i32 1429), !dbg !5672
  call void @printDDep(i32 1411, i32 1429), !dbg !5672
  call void @printDDep(i32 1422, i32 1429), !dbg !5672
  call void @printDDep(i32 1431, i32 1429), !dbg !5672
  call void @printDDep(i32 1422, i32 1429), !dbg !5672
  call void @printDDep(i32 1429, i32 1429), !dbg !5672
  %or20.i1586.i = or i32 %1720, %conv19.i1585.i, !dbg !5672
  %1721 = load i32, i32* @Inst_Counter, !dbg !5672
  %1722 = add i32 2, %1721, !dbg !5672
  store i32 %1722, i32* @Inst_Counter, !dbg !5672
  %1723 = load i32, i32* @Inst_Counter, !dbg !5672
  call void @printCounter(i32 %1723), !dbg !5672
  %1724 = ptrtoint i32* %t.i1560.i to i64, !dbg !5672
  call void @printStoreAddr(i64 %1724, i32 1431, i32 118, i32 7), !dbg !5672
  store i32 %or20.i1586.i, i32* %t.i1560.i, align 4, !dbg !5672
  call void @printDDep(i32 1389, i32 1431), !dbg !5672
  call void @printDDep(i32 1400, i32 1431), !dbg !5672
  call void @printDDep(i32 1411, i32 1431), !dbg !5672
  call void @printDDep(i32 1422, i32 1431), !dbg !5672
  call void @printDDep(i32 1427, i32 1431), !dbg !5672
  call void @printDDep(i32 1429, i32 1431), !dbg !5672
  call void @printDDep(i32 1431, i32 1431), !dbg !5672
  call void @printDDep(i32 1422, i32 1431), !dbg !5672
  call void @printDDep(i32 1431, i32 1431), !dbg !5672
  %1725 = load i32, i32* @Inst_Counter, !dbg !5673
  %1726 = add i32 1, %1725, !dbg !5673
  store i32 %1726, i32* @Inst_Counter, !dbg !5673
  %1727 = load i32, i32* @Inst_Counter, !dbg !5673
  call void @printCounter(i32 %1727), !dbg !5673
  %1728 = ptrtoint i32* %t.i1560.i to i64, !dbg !5673
  call void @printLoadAddr(i64 %1728, i32 1432, i32 123, i32 12), !dbg !5673
  %1729 = load i32, i32* %t.i1560.i, align 4, !dbg !5673
  call void @printDDep(i32 1389, i32 1432), !dbg !5673
  call void @printDDep(i32 1400, i32 1432), !dbg !5673
  call void @printDDep(i32 1411, i32 1432), !dbg !5673
  call void @printDDep(i32 1422, i32 1432), !dbg !5673
  call void @printDDep(i32 1431, i32 1432), !dbg !5673
  call void @printDDep(i32 1431, i32 1432), !dbg !5673
  call void @printDDep(i32 1432, i32 1432), !dbg !5673
  %1730 = load i32, i32* @Inst_Counter, !dbg !5674
  %1731 = add i32 1, %1730, !dbg !5674
  store i32 %1731, i32* @Inst_Counter, !dbg !5674
  %1732 = load i32, i32* @Inst_Counter, !dbg !5674
  call void @printCounter(i32 %1732), !dbg !5674
  %1733 = ptrtoint i32* %t.i1560.i to i64, !dbg !5674
  call void @printLoadAddr(i64 %1733, i32 1433, i32 123, i32 21), !dbg !5674
  %1734 = load i32, i32* %t.i1560.i, align 4, !dbg !5674
  call void @printDDep(i32 1389, i32 1433), !dbg !5674
  call void @printDDep(i32 1400, i32 1433), !dbg !5674
  call void @printDDep(i32 1411, i32 1433), !dbg !5674
  call void @printDDep(i32 1422, i32 1433), !dbg !5674
  call void @printDDep(i32 1431, i32 1433), !dbg !5674
  call void @printDDep(i32 1431, i32 1433), !dbg !5674
  call void @printDDep(i32 1433, i32 1433), !dbg !5674
  %1735 = load i32, i32* @Inst_Counter
  %1736 = add i32 1, %1735
  store i32 %1736, i32* @Inst_Counter
  %1737 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1737)
  %1738 = ptrtoint i32* %a.addr.i.i1557.i to i64
  call void @printStoreAddr(i64 %1738, i32 1434, i32 0, i32 0)
  store i32 %1734, i32* %a.addr.i.i1557.i, align 4
  call void @printDDep(i32 1433, i32 1434)
  call void @printDDep(i32 1434, i32 1434)
  call void @printDDep(i32 1431, i32 1434)
  call void @printDDep(i32 1434, i32 1434)
  %1739 = load i32, i32* @Inst_Counter
  %1740 = add i32 1, %1739
  store i32 %1740, i32* @Inst_Counter
  %1741 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1741)
  %1742 = ptrtoint i8* %n.addr.i.i1558.i to i64
  call void @printStoreAddr(i64 %1742, i32 1435, i32 0, i32 0)
  store i8 2, i8* %n.addr.i.i1558.i, align 1
  call void @printDDep(i32 1435, i32 1435)
  call void @printDDep(i32 1434, i32 1435)
  call void @printDDep(i32 1435, i32 1435)
  %1743 = load i32, i32* @Inst_Counter, !dbg !5675
  %1744 = add i32 1, %1743, !dbg !5675
  store i32 %1744, i32* @Inst_Counter, !dbg !5675
  %1745 = load i32, i32* @Inst_Counter, !dbg !5675
  call void @printCounter(i32 %1745), !dbg !5675
  %1746 = ptrtoint i32* %a.addr.i.i1557.i to i64, !dbg !5675
  call void @printLoadAddr(i64 %1746, i32 1436, i32 92, i32 13), !dbg !5675
  %1747 = load i32, i32* %a.addr.i.i1557.i, align 4, !dbg !5675
  call void @printDDep(i32 1434, i32 1436), !dbg !5675
  call void @printDDep(i32 1434, i32 1436), !dbg !5675
  call void @printDDep(i32 1436, i32 1436), !dbg !5675
  %1748 = load i32, i32* @Inst_Counter, !dbg !5676
  %1749 = add i32 1, %1748, !dbg !5676
  store i32 %1749, i32* @Inst_Counter, !dbg !5676
  %1750 = load i32, i32* @Inst_Counter, !dbg !5676
  call void @printCounter(i32 %1750), !dbg !5676
  %1751 = ptrtoint i8* %n.addr.i.i1558.i to i64, !dbg !5676
  call void @printLoadAddr(i64 %1751, i32 1437, i32 92, i32 18), !dbg !5676
  %1752 = load i8, i8* %n.addr.i.i1558.i, align 1, !dbg !5676
  call void @printDDep(i32 1435, i32 1437), !dbg !5676
  call void @printDDep(i32 1435, i32 1437), !dbg !5676
  call void @printDDep(i32 1437, i32 1437), !dbg !5676
  %conv.i.i1587.i = zext i8 %1752 to i32, !dbg !5676
  %shl.i.i1588.i = shl i32 %1747, %conv.i.i1587.i, !dbg !5677
  %1753 = load i32, i32* @Inst_Counter, !dbg !5678
  %1754 = add i32 3, %1753, !dbg !5678
  store i32 %1754, i32* @Inst_Counter, !dbg !5678
  %1755 = load i32, i32* @Inst_Counter, !dbg !5678
  call void @printCounter(i32 %1755), !dbg !5678
  %1756 = ptrtoint i32* %a.addr.i.i1557.i to i64, !dbg !5678
  call void @printLoadAddr(i64 %1756, i32 1440, i32 92, i32 24), !dbg !5678
  %1757 = load i32, i32* %a.addr.i.i1557.i, align 4, !dbg !5678
  call void @printDDep(i32 1434, i32 1440), !dbg !5678
  call void @printDDep(i32 1434, i32 1440), !dbg !5678
  call void @printDDep(i32 1440, i32 1440), !dbg !5678
  %1758 = load i32, i32* @Inst_Counter, !dbg !5679
  %1759 = add i32 1, %1758, !dbg !5679
  store i32 %1759, i32* @Inst_Counter, !dbg !5679
  %1760 = load i32, i32* @Inst_Counter, !dbg !5679
  call void @printCounter(i32 %1760), !dbg !5679
  %1761 = ptrtoint i8* %n.addr.i.i1558.i to i64, !dbg !5679
  call void @printLoadAddr(i64 %1761, i32 1441, i32 92, i32 35), !dbg !5679
  %1762 = load i8, i8* %n.addr.i.i1558.i, align 1, !dbg !5679
  call void @printDDep(i32 1435, i32 1441), !dbg !5679
  call void @printDDep(i32 1435, i32 1441), !dbg !5679
  call void @printDDep(i32 1441, i32 1441), !dbg !5679
  %conv1.i.i1589.i = zext i8 %1762 to i32, !dbg !5679
  %sub.i.i1590.i = sub nsw i32 32, %conv1.i.i1589.i, !dbg !5680
  %shr.i.i1591.i = lshr i32 %1757, %sub.i.i1590.i, !dbg !5681
  %or.i.i1592.i = or i32 %shl.i.i1588.i, %shr.i.i1591.i, !dbg !5682
  %xor.i1593.i = xor i32 %1729, %or.i.i1592.i, !dbg !5683
  %1763 = load i32, i32* @Inst_Counter, !dbg !5684
  %1764 = add i32 6, %1763, !dbg !5684
  store i32 %1764, i32* @Inst_Counter, !dbg !5684
  %1765 = load i32, i32* @Inst_Counter, !dbg !5684
  call void @printCounter(i32 %1765), !dbg !5684
  %1766 = ptrtoint i32* %t.i1560.i to i64, !dbg !5684
  call void @printLoadAddr(i64 %1766, i32 1447, i32 123, i32 34), !dbg !5684
  %1767 = load i32, i32* %t.i1560.i, align 4, !dbg !5684
  call void @printDDep(i32 1389, i32 1447), !dbg !5684
  call void @printDDep(i32 1400, i32 1447), !dbg !5684
  call void @printDDep(i32 1411, i32 1447), !dbg !5684
  call void @printDDep(i32 1422, i32 1447), !dbg !5684
  call void @printDDep(i32 1431, i32 1447), !dbg !5684
  call void @printDDep(i32 1431, i32 1447), !dbg !5684
  call void @printDDep(i32 1447, i32 1447), !dbg !5684
  %1768 = load i32, i32* @Inst_Counter
  %1769 = add i32 1, %1768
  store i32 %1769, i32* @Inst_Counter
  %1770 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1770)
  %1771 = ptrtoint i32* %a.addr.i43.i1551.i to i64
  call void @printStoreAddr(i64 %1771, i32 1448, i32 0, i32 0)
  store i32 %1767, i32* %a.addr.i43.i1551.i, align 4
  call void @printDDep(i32 1447, i32 1448)
  call void @printDDep(i32 1448, i32 1448)
  call void @printDDep(i32 1435, i32 1448)
  call void @printDDep(i32 1448, i32 1448)
  %1772 = load i32, i32* @Inst_Counter
  %1773 = add i32 1, %1772
  store i32 %1773, i32* @Inst_Counter
  %1774 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1774)
  %1775 = ptrtoint i8* %n.addr.i44.i1552.i to i64
  call void @printStoreAddr(i64 %1775, i32 1449, i32 0, i32 0)
  store i8 10, i8* %n.addr.i44.i1552.i, align 1
  call void @printDDep(i32 1449, i32 1449)
  call void @printDDep(i32 1448, i32 1449)
  call void @printDDep(i32 1449, i32 1449)
  %1776 = load i32, i32* @Inst_Counter, !dbg !5685
  %1777 = add i32 1, %1776, !dbg !5685
  store i32 %1777, i32* @Inst_Counter, !dbg !5685
  %1778 = load i32, i32* @Inst_Counter, !dbg !5685
  call void @printCounter(i32 %1778), !dbg !5685
  %1779 = ptrtoint i32* %a.addr.i43.i1551.i to i64, !dbg !5685
  call void @printLoadAddr(i64 %1779, i32 1450, i32 92, i32 13), !dbg !5685
  %1780 = load i32, i32* %a.addr.i43.i1551.i, align 4, !dbg !5685
  call void @printDDep(i32 1448, i32 1450), !dbg !5685
  call void @printDDep(i32 1448, i32 1450), !dbg !5685
  call void @printDDep(i32 1450, i32 1450), !dbg !5685
  %1781 = load i32, i32* @Inst_Counter, !dbg !5686
  %1782 = add i32 1, %1781, !dbg !5686
  store i32 %1782, i32* @Inst_Counter, !dbg !5686
  %1783 = load i32, i32* @Inst_Counter, !dbg !5686
  call void @printCounter(i32 %1783), !dbg !5686
  %1784 = ptrtoint i8* %n.addr.i44.i1552.i to i64, !dbg !5686
  call void @printLoadAddr(i64 %1784, i32 1451, i32 92, i32 18), !dbg !5686
  %1785 = load i8, i8* %n.addr.i44.i1552.i, align 1, !dbg !5686
  call void @printDDep(i32 1449, i32 1451), !dbg !5686
  call void @printDDep(i32 1449, i32 1451), !dbg !5686
  call void @printDDep(i32 1451, i32 1451), !dbg !5686
  %conv.i45.i1594.i = zext i8 %1785 to i32, !dbg !5686
  %shl.i46.i1595.i = shl i32 %1780, %conv.i45.i1594.i, !dbg !5687
  %1786 = load i32, i32* @Inst_Counter, !dbg !5688
  %1787 = add i32 3, %1786, !dbg !5688
  store i32 %1787, i32* @Inst_Counter, !dbg !5688
  %1788 = load i32, i32* @Inst_Counter, !dbg !5688
  call void @printCounter(i32 %1788), !dbg !5688
  %1789 = ptrtoint i32* %a.addr.i43.i1551.i to i64, !dbg !5688
  call void @printLoadAddr(i64 %1789, i32 1454, i32 92, i32 24), !dbg !5688
  %1790 = load i32, i32* %a.addr.i43.i1551.i, align 4, !dbg !5688
  call void @printDDep(i32 1448, i32 1454), !dbg !5688
  call void @printDDep(i32 1448, i32 1454), !dbg !5688
  call void @printDDep(i32 1454, i32 1454), !dbg !5688
  %1791 = load i32, i32* @Inst_Counter, !dbg !5689
  %1792 = add i32 1, %1791, !dbg !5689
  store i32 %1792, i32* @Inst_Counter, !dbg !5689
  %1793 = load i32, i32* @Inst_Counter, !dbg !5689
  call void @printCounter(i32 %1793), !dbg !5689
  %1794 = ptrtoint i8* %n.addr.i44.i1552.i to i64, !dbg !5689
  call void @printLoadAddr(i64 %1794, i32 1455, i32 92, i32 35), !dbg !5689
  %1795 = load i8, i8* %n.addr.i44.i1552.i, align 1, !dbg !5689
  call void @printDDep(i32 1449, i32 1455), !dbg !5689
  call void @printDDep(i32 1449, i32 1455), !dbg !5689
  call void @printDDep(i32 1455, i32 1455), !dbg !5689
  %conv1.i47.i1596.i = zext i8 %1795 to i32, !dbg !5689
  %sub.i48.i1597.i = sub nsw i32 32, %conv1.i47.i1596.i, !dbg !5690
  %shr.i49.i1598.i = lshr i32 %1790, %sub.i48.i1597.i, !dbg !5691
  %or.i50.i1599.i = or i32 %shl.i46.i1595.i, %shr.i49.i1598.i, !dbg !5692
  %xor22.i1600.i = xor i32 %xor.i1593.i, %or.i50.i1599.i, !dbg !5693
  %1796 = load i32, i32* @Inst_Counter, !dbg !5694
  %1797 = add i32 6, %1796, !dbg !5694
  store i32 %1797, i32* @Inst_Counter, !dbg !5694
  %1798 = load i32, i32* @Inst_Counter, !dbg !5694
  call void @printCounter(i32 %1798), !dbg !5694
  %1799 = ptrtoint i32* %t.i1560.i to i64, !dbg !5694
  call void @printLoadAddr(i64 %1799, i32 1461, i32 123, i32 48), !dbg !5694
  %1800 = load i32, i32* %t.i1560.i, align 4, !dbg !5694
  call void @printDDep(i32 1389, i32 1461), !dbg !5694
  call void @printDDep(i32 1400, i32 1461), !dbg !5694
  call void @printDDep(i32 1411, i32 1461), !dbg !5694
  call void @printDDep(i32 1422, i32 1461), !dbg !5694
  call void @printDDep(i32 1431, i32 1461), !dbg !5694
  call void @printDDep(i32 1431, i32 1461), !dbg !5694
  call void @printDDep(i32 1461, i32 1461), !dbg !5694
  %1801 = load i32, i32* @Inst_Counter
  %1802 = add i32 1, %1801
  store i32 %1802, i32* @Inst_Counter
  %1803 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1803)
  %1804 = ptrtoint i32* %a.addr.i35.i1553.i to i64
  call void @printStoreAddr(i64 %1804, i32 1462, i32 0, i32 0)
  store i32 %1800, i32* %a.addr.i35.i1553.i, align 4
  call void @printDDep(i32 1461, i32 1462)
  call void @printDDep(i32 1462, i32 1462)
  call void @printDDep(i32 1449, i32 1462)
  call void @printDDep(i32 1462, i32 1462)
  %1805 = load i32, i32* @Inst_Counter
  %1806 = add i32 1, %1805
  store i32 %1806, i32* @Inst_Counter
  %1807 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1807)
  %1808 = ptrtoint i8* %n.addr.i36.i1554.i to i64
  call void @printStoreAddr(i64 %1808, i32 1463, i32 0, i32 0)
  store i8 18, i8* %n.addr.i36.i1554.i, align 1
  call void @printDDep(i32 1463, i32 1463)
  call void @printDDep(i32 1462, i32 1463)
  call void @printDDep(i32 1463, i32 1463)
  %1809 = load i32, i32* @Inst_Counter, !dbg !5695
  %1810 = add i32 1, %1809, !dbg !5695
  store i32 %1810, i32* @Inst_Counter, !dbg !5695
  %1811 = load i32, i32* @Inst_Counter, !dbg !5695
  call void @printCounter(i32 %1811), !dbg !5695
  %1812 = ptrtoint i32* %a.addr.i35.i1553.i to i64, !dbg !5695
  call void @printLoadAddr(i64 %1812, i32 1464, i32 92, i32 13), !dbg !5695
  %1813 = load i32, i32* %a.addr.i35.i1553.i, align 4, !dbg !5695
  call void @printDDep(i32 1462, i32 1464), !dbg !5695
  call void @printDDep(i32 1462, i32 1464), !dbg !5695
  call void @printDDep(i32 1464, i32 1464), !dbg !5695
  %1814 = load i32, i32* @Inst_Counter, !dbg !5696
  %1815 = add i32 1, %1814, !dbg !5696
  store i32 %1815, i32* @Inst_Counter, !dbg !5696
  %1816 = load i32, i32* @Inst_Counter, !dbg !5696
  call void @printCounter(i32 %1816), !dbg !5696
  %1817 = ptrtoint i8* %n.addr.i36.i1554.i to i64, !dbg !5696
  call void @printLoadAddr(i64 %1817, i32 1465, i32 92, i32 18), !dbg !5696
  %1818 = load i8, i8* %n.addr.i36.i1554.i, align 1, !dbg !5696
  call void @printDDep(i32 1463, i32 1465), !dbg !5696
  call void @printDDep(i32 1463, i32 1465), !dbg !5696
  call void @printDDep(i32 1465, i32 1465), !dbg !5696
  %conv.i37.i1601.i = zext i8 %1818 to i32, !dbg !5696
  %shl.i38.i1602.i = shl i32 %1813, %conv.i37.i1601.i, !dbg !5697
  %1819 = load i32, i32* @Inst_Counter, !dbg !5698
  %1820 = add i32 3, %1819, !dbg !5698
  store i32 %1820, i32* @Inst_Counter, !dbg !5698
  %1821 = load i32, i32* @Inst_Counter, !dbg !5698
  call void @printCounter(i32 %1821), !dbg !5698
  %1822 = ptrtoint i32* %a.addr.i35.i1553.i to i64, !dbg !5698
  call void @printLoadAddr(i64 %1822, i32 1468, i32 92, i32 24), !dbg !5698
  %1823 = load i32, i32* %a.addr.i35.i1553.i, align 4, !dbg !5698
  call void @printDDep(i32 1462, i32 1468), !dbg !5698
  call void @printDDep(i32 1462, i32 1468), !dbg !5698
  call void @printDDep(i32 1468, i32 1468), !dbg !5698
  %1824 = load i32, i32* @Inst_Counter, !dbg !5699
  %1825 = add i32 1, %1824, !dbg !5699
  store i32 %1825, i32* @Inst_Counter, !dbg !5699
  %1826 = load i32, i32* @Inst_Counter, !dbg !5699
  call void @printCounter(i32 %1826), !dbg !5699
  %1827 = ptrtoint i8* %n.addr.i36.i1554.i to i64, !dbg !5699
  call void @printLoadAddr(i64 %1827, i32 1469, i32 92, i32 35), !dbg !5699
  %1828 = load i8, i8* %n.addr.i36.i1554.i, align 1, !dbg !5699
  call void @printDDep(i32 1463, i32 1469), !dbg !5699
  call void @printDDep(i32 1463, i32 1469), !dbg !5699
  call void @printDDep(i32 1469, i32 1469), !dbg !5699
  %conv1.i39.i1603.i = zext i8 %1828 to i32, !dbg !5699
  %sub.i40.i1604.i = sub nsw i32 32, %conv1.i39.i1603.i, !dbg !5700
  %shr.i41.i1605.i = lshr i32 %1823, %sub.i40.i1604.i, !dbg !5701
  %or.i42.i1606.i = or i32 %shl.i38.i1602.i, %shr.i41.i1605.i, !dbg !5702
  %xor24.i1607.i = xor i32 %xor22.i1600.i, %or.i42.i1606.i, !dbg !5703
  %1829 = load i32, i32* @Inst_Counter, !dbg !5704
  %1830 = add i32 6, %1829, !dbg !5704
  store i32 %1830, i32* @Inst_Counter, !dbg !5704
  %1831 = load i32, i32* @Inst_Counter, !dbg !5704
  call void @printCounter(i32 %1831), !dbg !5704
  %1832 = ptrtoint i32* %t.i1560.i to i64, !dbg !5704
  call void @printLoadAddr(i64 %1832, i32 1475, i32 123, i32 62), !dbg !5704
  %1833 = load i32, i32* %t.i1560.i, align 4, !dbg !5704
  call void @printDDep(i32 1389, i32 1475), !dbg !5704
  call void @printDDep(i32 1400, i32 1475), !dbg !5704
  call void @printDDep(i32 1411, i32 1475), !dbg !5704
  call void @printDDep(i32 1422, i32 1475), !dbg !5704
  call void @printDDep(i32 1431, i32 1475), !dbg !5704
  call void @printDDep(i32 1431, i32 1475), !dbg !5704
  call void @printDDep(i32 1475, i32 1475), !dbg !5704
  %1834 = load i32, i32* @Inst_Counter
  %1835 = add i32 1, %1834
  store i32 %1835, i32* @Inst_Counter
  %1836 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1836)
  %1837 = ptrtoint i32* %a.addr.i27.i1555.i to i64
  call void @printStoreAddr(i64 %1837, i32 1476, i32 0, i32 0)
  store i32 %1833, i32* %a.addr.i27.i1555.i, align 4
  call void @printDDep(i32 1475, i32 1476)
  call void @printDDep(i32 1476, i32 1476)
  call void @printDDep(i32 1463, i32 1476)
  call void @printDDep(i32 1476, i32 1476)
  %1838 = load i32, i32* @Inst_Counter
  %1839 = add i32 1, %1838
  store i32 %1839, i32* @Inst_Counter
  %1840 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1840)
  %1841 = ptrtoint i8* %n.addr.i28.i1556.i to i64
  call void @printStoreAddr(i64 %1841, i32 1477, i32 0, i32 0)
  store i8 24, i8* %n.addr.i28.i1556.i, align 1
  call void @printDDep(i32 1477, i32 1477)
  call void @printDDep(i32 1476, i32 1477)
  call void @printDDep(i32 1477, i32 1477)
  %1842 = load i32, i32* @Inst_Counter, !dbg !5705
  %1843 = add i32 1, %1842, !dbg !5705
  store i32 %1843, i32* @Inst_Counter, !dbg !5705
  %1844 = load i32, i32* @Inst_Counter, !dbg !5705
  call void @printCounter(i32 %1844), !dbg !5705
  %1845 = ptrtoint i32* %a.addr.i27.i1555.i to i64, !dbg !5705
  call void @printLoadAddr(i64 %1845, i32 1478, i32 92, i32 13), !dbg !5705
  %1846 = load i32, i32* %a.addr.i27.i1555.i, align 4, !dbg !5705
  call void @printDDep(i32 1476, i32 1478), !dbg !5705
  call void @printDDep(i32 1476, i32 1478), !dbg !5705
  call void @printDDep(i32 1478, i32 1478), !dbg !5705
  %1847 = load i32, i32* @Inst_Counter, !dbg !5706
  %1848 = add i32 1, %1847, !dbg !5706
  store i32 %1848, i32* @Inst_Counter, !dbg !5706
  %1849 = load i32, i32* @Inst_Counter, !dbg !5706
  call void @printCounter(i32 %1849), !dbg !5706
  %1850 = ptrtoint i8* %n.addr.i28.i1556.i to i64, !dbg !5706
  call void @printLoadAddr(i64 %1850, i32 1479, i32 92, i32 18), !dbg !5706
  %1851 = load i8, i8* %n.addr.i28.i1556.i, align 1, !dbg !5706
  call void @printDDep(i32 1477, i32 1479), !dbg !5706
  call void @printDDep(i32 1477, i32 1479), !dbg !5706
  call void @printDDep(i32 1479, i32 1479), !dbg !5706
  %conv.i29.i1608.i = zext i8 %1851 to i32, !dbg !5706
  %shl.i30.i1609.i = shl i32 %1846, %conv.i29.i1608.i, !dbg !5707
  %1852 = load i32, i32* @Inst_Counter, !dbg !5708
  %1853 = add i32 3, %1852, !dbg !5708
  store i32 %1853, i32* @Inst_Counter, !dbg !5708
  %1854 = load i32, i32* @Inst_Counter, !dbg !5708
  call void @printCounter(i32 %1854), !dbg !5708
  %1855 = ptrtoint i32* %a.addr.i27.i1555.i to i64, !dbg !5708
  call void @printLoadAddr(i64 %1855, i32 1482, i32 92, i32 24), !dbg !5708
  %1856 = load i32, i32* %a.addr.i27.i1555.i, align 4, !dbg !5708
  call void @printDDep(i32 1476, i32 1482), !dbg !5708
  call void @printDDep(i32 1476, i32 1482), !dbg !5708
  call void @printDDep(i32 1482, i32 1482), !dbg !5708
  %1857 = load i32, i32* @Inst_Counter, !dbg !5709
  %1858 = add i32 1, %1857, !dbg !5709
  store i32 %1858, i32* @Inst_Counter, !dbg !5709
  %1859 = load i32, i32* @Inst_Counter, !dbg !5709
  call void @printCounter(i32 %1859), !dbg !5709
  %1860 = ptrtoint i8* %n.addr.i28.i1556.i to i64, !dbg !5709
  call void @printLoadAddr(i64 %1860, i32 1483, i32 92, i32 35), !dbg !5709
  %1861 = load i8, i8* %n.addr.i28.i1556.i, align 1, !dbg !5709
  call void @printDDep(i32 1477, i32 1483), !dbg !5709
  call void @printDDep(i32 1477, i32 1483), !dbg !5709
  call void @printDDep(i32 1483, i32 1483), !dbg !5709
  %conv1.i31.i1610.i = zext i8 %1861 to i32, !dbg !5709
  %sub.i32.i1611.i = sub nsw i32 32, %conv1.i31.i1610.i, !dbg !5710
  %shr.i33.i1612.i = lshr i32 %1856, %sub.i32.i1611.i, !dbg !5711
  %or.i34.i1613.i = or i32 %shl.i30.i1609.i, %shr.i33.i1612.i, !dbg !5712
  %xor26.i1614.i = xor i32 %xor24.i1607.i, %or.i34.i1613.i, !dbg !5713
  %1862 = load i32, i32* @Inst_Counter, !dbg !5515
  %1863 = add i32 6, %1862, !dbg !5515
  store i32 %1863, i32* @Inst_Counter, !dbg !5515
  %1864 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1864), !dbg !5515
  %1865 = ptrtoint i32* %B2.i to i64, !dbg !5515
  call void @printLoadAddr(i64 %1865, i32 1489, i32 200, i32 5), !dbg !5515
  %1866 = load i32, i32* %B2.i, align 4, !dbg !5515
  call void @printDDep(i32 1108, i32 1489), !dbg !5515
  call void @printDDep(i32 1491, i32 1489), !dbg !5515
  call void @printDDep(i32 1833, i32 1489), !dbg !5515
  call void @printDDep(i32 2137, i32 1489), !dbg !5515
  call void @printDDep(i32 2441, i32 1489), !dbg !5515
  call void @printDDep(i32 2745, i32 1489), !dbg !5515
  call void @printDDep(i32 3049, i32 1489), !dbg !5515
  call void @printDDep(i32 3353, i32 1489), !dbg !5515
  call void @printDDep(i32 3771, i32 1489), !dbg !5515
  call void @printDDep(i32 1108, i32 1489), !dbg !5515
  call void @printDDep(i32 1489, i32 1489), !dbg !5515
  %xor22.i = xor i32 %1866, %xor26.i1614.i, !dbg !5515
  %1867 = load i32, i32* @Inst_Counter, !dbg !5515
  %1868 = add i32 2, %1867, !dbg !5515
  store i32 %1868, i32* @Inst_Counter, !dbg !5515
  %1869 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1869), !dbg !5515
  %1870 = ptrtoint i32* %B2.i to i64, !dbg !5515
  call void @printStoreAddr(i64 %1870, i32 1491, i32 200, i32 5), !dbg !5515
  store i32 %xor22.i, i32* %B2.i, align 4, !dbg !5515
  call void @printDDep(i32 1108, i32 1491), !dbg !5515
  call void @printDDep(i32 1432, i32 1491), !dbg !5515
  call void @printDDep(i32 1436, i32 1491), !dbg !5515
  call void @printDDep(i32 1437, i32 1491), !dbg !5515
  call void @printDDep(i32 1440, i32 1491), !dbg !5515
  call void @printDDep(i32 1441, i32 1491), !dbg !5515
  call void @printDDep(i32 1450, i32 1491), !dbg !5515
  call void @printDDep(i32 1451, i32 1491), !dbg !5515
  call void @printDDep(i32 1454, i32 1491), !dbg !5515
  call void @printDDep(i32 1455, i32 1491), !dbg !5515
  call void @printDDep(i32 1464, i32 1491), !dbg !5515
  call void @printDDep(i32 1465, i32 1491), !dbg !5515
  call void @printDDep(i32 1468, i32 1491), !dbg !5515
  call void @printDDep(i32 1469, i32 1491), !dbg !5515
  call void @printDDep(i32 1478, i32 1491), !dbg !5515
  call void @printDDep(i32 1479, i32 1491), !dbg !5515
  call void @printDDep(i32 1482, i32 1491), !dbg !5515
  call void @printDDep(i32 1483, i32 1491), !dbg !5515
  call void @printDDep(i32 1489, i32 1491), !dbg !5515
  call void @printDDep(i32 1491, i32 1491), !dbg !5515
  call void @printDDep(i32 1833, i32 1491), !dbg !5515
  call void @printDDep(i32 2137, i32 1491), !dbg !5515
  call void @printDDep(i32 2441, i32 1491), !dbg !5515
  call void @printDDep(i32 2745, i32 1491), !dbg !5515
  call void @printDDep(i32 3049, i32 1491), !dbg !5515
  call void @printDDep(i32 3353, i32 1491), !dbg !5515
  call void @printDDep(i32 3771, i32 1491), !dbg !5515
  call void @printDDep(i32 1477, i32 1491), !dbg !5515
  call void @printDDep(i32 1491, i32 1491), !dbg !5515
  %1871 = load i32, i32* @Inst_Counter, !dbg !5515
  %1872 = add i32 1, %1871, !dbg !5515
  store i32 %1872, i32* @Inst_Counter, !dbg !5515
  %1873 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1873), !dbg !5515
  %1874 = ptrtoint i32* %B0.i to i64, !dbg !5515
  call void @printLoadAddr(i64 %1874, i32 1492, i32 200, i32 5), !dbg !5515
  %1875 = load i32, i32* %B0.i, align 4, !dbg !5515
  call void @printDDep(i32 1026, i32 1492), !dbg !5515
  call void @printDDep(i32 1263, i32 1492), !dbg !5515
  call void @printDDep(i32 1681, i32 1492), !dbg !5515
  call void @printDDep(i32 1985, i32 1492), !dbg !5515
  call void @printDDep(i32 2289, i32 1492), !dbg !5515
  call void @printDDep(i32 2593, i32 1492), !dbg !5515
  call void @printDDep(i32 2897, i32 1492), !dbg !5515
  call void @printDDep(i32 3201, i32 1492), !dbg !5515
  call void @printDDep(i32 3543, i32 1492), !dbg !5515
  call void @printDDep(i32 1263, i32 1492), !dbg !5515
  call void @printDDep(i32 1492, i32 1492), !dbg !5515
  %1876 = load i32, i32* @Inst_Counter, !dbg !5515
  %1877 = add i32 1, %1876, !dbg !5515
  store i32 %1877, i32* @Inst_Counter, !dbg !5515
  %1878 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1878), !dbg !5515
  %1879 = ptrtoint i32* %B1.i to i64, !dbg !5515
  call void @printLoadAddr(i64 %1879, i32 1493, i32 200, i32 5), !dbg !5515
  %1880 = load i32, i32* %B1.i, align 4, !dbg !5515
  call void @printDDep(i32 1067, i32 1493), !dbg !5515
  call void @printDDep(i32 1377, i32 1493), !dbg !5515
  call void @printDDep(i32 1757, i32 1493), !dbg !5515
  call void @printDDep(i32 2061, i32 1493), !dbg !5515
  call void @printDDep(i32 2365, i32 1493), !dbg !5515
  call void @printDDep(i32 2669, i32 1493), !dbg !5515
  call void @printDDep(i32 2973, i32 1493), !dbg !5515
  call void @printDDep(i32 3277, i32 1493), !dbg !5515
  call void @printDDep(i32 3657, i32 1493), !dbg !5515
  call void @printDDep(i32 1377, i32 1493), !dbg !5515
  call void @printDDep(i32 1493, i32 1493), !dbg !5515
  %xor23.i58 = xor i32 %1875, %1880, !dbg !5515
  %1881 = load i32, i32* @Inst_Counter, !dbg !5515
  %1882 = add i32 2, %1881, !dbg !5515
  store i32 %1882, i32* @Inst_Counter, !dbg !5515
  %1883 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1883), !dbg !5515
  %1884 = ptrtoint i32* %B2.i to i64, !dbg !5515
  call void @printLoadAddr(i64 %1884, i32 1495, i32 200, i32 5), !dbg !5515
  %1885 = load i32, i32* %B2.i, align 4, !dbg !5515
  call void @printDDep(i32 1108, i32 1495), !dbg !5515
  call void @printDDep(i32 1491, i32 1495), !dbg !5515
  call void @printDDep(i32 1833, i32 1495), !dbg !5515
  call void @printDDep(i32 2137, i32 1495), !dbg !5515
  call void @printDDep(i32 2441, i32 1495), !dbg !5515
  call void @printDDep(i32 2745, i32 1495), !dbg !5515
  call void @printDDep(i32 3049, i32 1495), !dbg !5515
  call void @printDDep(i32 3353, i32 1495), !dbg !5515
  call void @printDDep(i32 3771, i32 1495), !dbg !5515
  call void @printDDep(i32 1491, i32 1495), !dbg !5515
  call void @printDDep(i32 1495, i32 1495), !dbg !5515
  %xor24.i = xor i32 %xor23.i58, %1885, !dbg !5515
  %1886 = load i32, i32* @Inst_Counter, !dbg !5515
  %1887 = add i32 2, %1886, !dbg !5515
  store i32 %1887, i32* @Inst_Counter, !dbg !5515
  %1888 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1888), !dbg !5515
  %1889 = ptrtoint %struct.SM4_KEY_st** %ks.addr.i24 to i64, !dbg !5515
  call void @printLoadAddr(i64 %1889, i32 1497, i32 200, i32 5), !dbg !5515
  %1890 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr.i24, align 8, !dbg !5515
  call void @printDDep(i32 983, i32 1497), !dbg !5515
  call void @printDDep(i32 985, i32 1497), !dbg !5515
  call void @printDDep(i32 1497, i32 1497), !dbg !5515
  %rk25.i = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %1890, i32 0, i32 0, !dbg !5515
  %arrayidx26.i = getelementptr inbounds [32 x i32], [32 x i32]* %rk25.i, i64 0, i64 3, !dbg !5515
  %1891 = load i32, i32* @Inst_Counter, !dbg !5515
  %1892 = add i32 3, %1891, !dbg !5515
  store i32 %1892, i32* @Inst_Counter, !dbg !5515
  %1893 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %1893), !dbg !5515
  %1894 = ptrtoint i32* %arrayidx26.i to i64, !dbg !5515
  call void @printLoadAddr(i64 %1894, i32 1500, i32 200, i32 5), !dbg !5515
  %1895 = load i32, i32* %arrayidx26.i, align 4, !dbg !5515
  call void @printDDep(i32 1497, i32 1500), !dbg !5515
  call void @printDDep(i32 985, i32 1500), !dbg !5515
  call void @printDDep(i32 1500, i32 1500), !dbg !5515
  %xor27.i = xor i32 %xor24.i, %1895, !dbg !5515
  %1896 = load i32, i32* @Inst_Counter
  %1897 = add i32 2, %1896
  store i32 %1897, i32* @Inst_Counter
  %1898 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1898)
  %1899 = ptrtoint i32* %X.addr.i1495.i to i64
  call void @printStoreAddr(i64 %1899, i32 1502, i32 0, i32 0)
  store i32 %xor27.i, i32* %X.addr.i1495.i, align 4
  call void @printDDep(i32 1492, i32 1502)
  call void @printDDep(i32 1493, i32 1502)
  call void @printDDep(i32 1495, i32 1502)
  call void @printDDep(i32 1500, i32 1502)
  call void @printDDep(i32 1502, i32 1502)
  call void @printDDep(i32 1491, i32 1502)
  call void @printDDep(i32 1502, i32 1502)
  %1900 = load i32, i32* @Inst_Counter, !dbg !4744
  %1901 = add i32 1, %1900, !dbg !4744
  store i32 %1901, i32* @Inst_Counter, !dbg !4744
  %1902 = load i32, i32* @Inst_Counter, !dbg !4744
  call void @printCounter(i32 %1902), !dbg !4744
  %1903 = ptrtoint i32* %t.i1496.i to i64, !dbg !4744
  call void @printStoreAddr(i64 %1903, i32 1503, i32 113, i32 14), !dbg !4744
  store i32 0, i32* %t.i1496.i, align 4, !dbg !4744
  call void @printDDep(i32 1503, i32 1503), !dbg !4744
  call void @printDDep(i32 1514, i32 1503), !dbg !4744
  call void @printDDep(i32 1525, i32 1503), !dbg !4744
  call void @printDDep(i32 1536, i32 1503), !dbg !4744
  call void @printDDep(i32 1545, i32 1503), !dbg !4744
  call void @printDDep(i32 1502, i32 1503), !dbg !4744
  call void @printDDep(i32 1503, i32 1503), !dbg !4744
  %1904 = load i32, i32* @Inst_Counter, !dbg !5714
  %1905 = add i32 1, %1904, !dbg !5714
  store i32 %1905, i32* @Inst_Counter, !dbg !5714
  %1906 = load i32, i32* @Inst_Counter, !dbg !5714
  call void @printCounter(i32 %1906), !dbg !5714
  %1907 = ptrtoint i32* %X.addr.i1495.i to i64, !dbg !5714
  call void @printLoadAddr(i64 %1907, i32 1504, i32 115, i32 37), !dbg !5714
  %1908 = load i32, i32* %X.addr.i1495.i, align 4, !dbg !5714
  call void @printDDep(i32 1502, i32 1504), !dbg !5714
  call void @printDDep(i32 1502, i32 1504), !dbg !5714
  call void @printDDep(i32 1504, i32 1504), !dbg !5714
  %shr.i1497.i = lshr i32 %1908, 24, !dbg !5715
  %conv.i1498.i = trunc i32 %shr.i1497.i to i8, !dbg !5716
  %idxprom.i1499.i = zext i8 %conv.i1498.i to i64, !dbg !5717
  %arrayidx.i1500.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom.i1499.i, !dbg !5717
  %1909 = load i32, i32* @Inst_Counter, !dbg !5717
  %1910 = add i32 5, %1909, !dbg !5717
  store i32 %1910, i32* @Inst_Counter, !dbg !5717
  %1911 = load i32, i32* @Inst_Counter, !dbg !5717
  call void @printCounter(i32 %1911), !dbg !5717
  %1912 = ptrtoint i8* %arrayidx.i1500.i to i64, !dbg !5717
  %1913 = load [256 x i8], [256 x i8]* @SM4_S, !dbg !5717
  call void @printSymLoadAddr(i64 %1912, i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 add (i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 255), i32 1, i32 1509, i32 115, i32 21), !dbg !5717
  %1914 = load i8, i8* %arrayidx.i1500.i, align 1, !dbg !5717
  call void @printDDep(i32 1504, i32 1509), !dbg !5717
  call void @printDDep(i32 1509, i32 1509), !dbg !5717
  %conv1.i1501.i = zext i8 %1914 to i32, !dbg !5718
  %shl.i1502.i = shl i32 %conv1.i1501.i, 24, !dbg !5719
  %1915 = load i32, i32* @Inst_Counter, !dbg !5720
  %1916 = add i32 3, %1915, !dbg !5720
  store i32 %1916, i32* @Inst_Counter, !dbg !5720
  %1917 = load i32, i32* @Inst_Counter, !dbg !5720
  call void @printCounter(i32 %1917), !dbg !5720
  %1918 = ptrtoint i32* %t.i1496.i to i64, !dbg !5720
  call void @printLoadAddr(i64 %1918, i32 1512, i32 115, i32 7), !dbg !5720
  %1919 = load i32, i32* %t.i1496.i, align 4, !dbg !5720
  call void @printDDep(i32 1503, i32 1512), !dbg !5720
  call void @printDDep(i32 1514, i32 1512), !dbg !5720
  call void @printDDep(i32 1525, i32 1512), !dbg !5720
  call void @printDDep(i32 1536, i32 1512), !dbg !5720
  call void @printDDep(i32 1545, i32 1512), !dbg !5720
  call void @printDDep(i32 1503, i32 1512), !dbg !5720
  call void @printDDep(i32 1512, i32 1512), !dbg !5720
  %or.i1503.i = or i32 %1919, %shl.i1502.i, !dbg !5720
  %1920 = load i32, i32* @Inst_Counter, !dbg !5720
  %1921 = add i32 2, %1920, !dbg !5720
  store i32 %1921, i32* @Inst_Counter, !dbg !5720
  %1922 = load i32, i32* @Inst_Counter, !dbg !5720
  call void @printCounter(i32 %1922), !dbg !5720
  %1923 = ptrtoint i32* %t.i1496.i to i64, !dbg !5720
  call void @printStoreAddr(i64 %1923, i32 1514, i32 115, i32 7), !dbg !5720
  store i32 %or.i1503.i, i32* %t.i1496.i, align 4, !dbg !5720
  call void @printDDep(i32 1503, i32 1514), !dbg !5720
  call void @printDDep(i32 1509, i32 1514), !dbg !5720
  call void @printDDep(i32 1512, i32 1514), !dbg !5720
  call void @printDDep(i32 1514, i32 1514), !dbg !5720
  call void @printDDep(i32 1525, i32 1514), !dbg !5720
  call void @printDDep(i32 1536, i32 1514), !dbg !5720
  call void @printDDep(i32 1545, i32 1514), !dbg !5720
  call void @printDDep(i32 1503, i32 1514), !dbg !5720
  call void @printDDep(i32 1514, i32 1514), !dbg !5720
  %1924 = load i32, i32* @Inst_Counter, !dbg !5721
  %1925 = add i32 1, %1924, !dbg !5721
  store i32 %1925, i32* @Inst_Counter, !dbg !5721
  %1926 = load i32, i32* @Inst_Counter, !dbg !5721
  call void @printCounter(i32 %1926), !dbg !5721
  %1927 = ptrtoint i32* %X.addr.i1495.i to i64, !dbg !5721
  call void @printLoadAddr(i64 %1927, i32 1515, i32 116, i32 37), !dbg !5721
  %1928 = load i32, i32* %X.addr.i1495.i, align 4, !dbg !5721
  call void @printDDep(i32 1502, i32 1515), !dbg !5721
  call void @printDDep(i32 1502, i32 1515), !dbg !5721
  call void @printDDep(i32 1515, i32 1515), !dbg !5721
  %shr2.i1504.i = lshr i32 %1928, 16, !dbg !5722
  %conv3.i1505.i = trunc i32 %shr2.i1504.i to i8, !dbg !5723
  %idxprom4.i1506.i = zext i8 %conv3.i1505.i to i64, !dbg !5724
  %arrayidx5.i1507.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom4.i1506.i, !dbg !5724
  %1929 = load i32, i32* @Inst_Counter, !dbg !5724
  %1930 = add i32 5, %1929, !dbg !5724
  store i32 %1930, i32* @Inst_Counter, !dbg !5724
  %1931 = load i32, i32* @Inst_Counter, !dbg !5724
  call void @printCounter(i32 %1931), !dbg !5724
  %1932 = ptrtoint i8* %arrayidx5.i1507.i to i64, !dbg !5724
  %1933 = load [256 x i8], [256 x i8]* @SM4_S, !dbg !5724
  call void @printSymLoadAddr(i64 %1932, i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 add (i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 255), i32 1, i32 1520, i32 116, i32 21), !dbg !5724
  %1934 = load i8, i8* %arrayidx5.i1507.i, align 1, !dbg !5724
  call void @printDDep(i32 1515, i32 1520), !dbg !5724
  call void @printDDep(i32 1520, i32 1520), !dbg !5724
  %conv6.i1508.i = zext i8 %1934 to i32, !dbg !5725
  %shl7.i1509.i = shl i32 %conv6.i1508.i, 16, !dbg !5726
  %1935 = load i32, i32* @Inst_Counter, !dbg !5727
  %1936 = add i32 3, %1935, !dbg !5727
  store i32 %1936, i32* @Inst_Counter, !dbg !5727
  %1937 = load i32, i32* @Inst_Counter, !dbg !5727
  call void @printCounter(i32 %1937), !dbg !5727
  %1938 = ptrtoint i32* %t.i1496.i to i64, !dbg !5727
  call void @printLoadAddr(i64 %1938, i32 1523, i32 116, i32 7), !dbg !5727
  %1939 = load i32, i32* %t.i1496.i, align 4, !dbg !5727
  call void @printDDep(i32 1503, i32 1523), !dbg !5727
  call void @printDDep(i32 1514, i32 1523), !dbg !5727
  call void @printDDep(i32 1525, i32 1523), !dbg !5727
  call void @printDDep(i32 1536, i32 1523), !dbg !5727
  call void @printDDep(i32 1545, i32 1523), !dbg !5727
  call void @printDDep(i32 1514, i32 1523), !dbg !5727
  call void @printDDep(i32 1523, i32 1523), !dbg !5727
  %or8.i1510.i = or i32 %1939, %shl7.i1509.i, !dbg !5727
  %1940 = load i32, i32* @Inst_Counter, !dbg !5727
  %1941 = add i32 2, %1940, !dbg !5727
  store i32 %1941, i32* @Inst_Counter, !dbg !5727
  %1942 = load i32, i32* @Inst_Counter, !dbg !5727
  call void @printCounter(i32 %1942), !dbg !5727
  %1943 = ptrtoint i32* %t.i1496.i to i64, !dbg !5727
  call void @printStoreAddr(i64 %1943, i32 1525, i32 116, i32 7), !dbg !5727
  store i32 %or8.i1510.i, i32* %t.i1496.i, align 4, !dbg !5727
  call void @printDDep(i32 1503, i32 1525), !dbg !5727
  call void @printDDep(i32 1514, i32 1525), !dbg !5727
  call void @printDDep(i32 1520, i32 1525), !dbg !5727
  call void @printDDep(i32 1523, i32 1525), !dbg !5727
  call void @printDDep(i32 1525, i32 1525), !dbg !5727
  call void @printDDep(i32 1536, i32 1525), !dbg !5727
  call void @printDDep(i32 1545, i32 1525), !dbg !5727
  call void @printDDep(i32 1514, i32 1525), !dbg !5727
  call void @printDDep(i32 1525, i32 1525), !dbg !5727
  %1944 = load i32, i32* @Inst_Counter, !dbg !5728
  %1945 = add i32 1, %1944, !dbg !5728
  store i32 %1945, i32* @Inst_Counter, !dbg !5728
  %1946 = load i32, i32* @Inst_Counter, !dbg !5728
  call void @printCounter(i32 %1946), !dbg !5728
  %1947 = ptrtoint i32* %X.addr.i1495.i to i64, !dbg !5728
  call void @printLoadAddr(i64 %1947, i32 1526, i32 117, i32 37), !dbg !5728
  %1948 = load i32, i32* %X.addr.i1495.i, align 4, !dbg !5728
  call void @printDDep(i32 1502, i32 1526), !dbg !5728
  call void @printDDep(i32 1502, i32 1526), !dbg !5728
  call void @printDDep(i32 1526, i32 1526), !dbg !5728
  %shr9.i1511.i = lshr i32 %1948, 8, !dbg !5729
  %conv10.i1512.i = trunc i32 %shr9.i1511.i to i8, !dbg !5730
  %idxprom11.i1513.i = zext i8 %conv10.i1512.i to i64, !dbg !5731
  %arrayidx12.i1514.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom11.i1513.i, !dbg !5731
  %1949 = load i32, i32* @Inst_Counter, !dbg !5731
  %1950 = add i32 5, %1949, !dbg !5731
  store i32 %1950, i32* @Inst_Counter, !dbg !5731
  %1951 = load i32, i32* @Inst_Counter, !dbg !5731
  call void @printCounter(i32 %1951), !dbg !5731
  %1952 = ptrtoint i8* %arrayidx12.i1514.i to i64, !dbg !5731
  %1953 = load [256 x i8], [256 x i8]* @SM4_S, !dbg !5731
  call void @printSymLoadAddr(i64 %1952, i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 add (i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 255), i32 1, i32 1531, i32 117, i32 21), !dbg !5731
  %1954 = load i8, i8* %arrayidx12.i1514.i, align 1, !dbg !5731
  call void @printDDep(i32 1526, i32 1531), !dbg !5731
  call void @printDDep(i32 1531, i32 1531), !dbg !5731
  %conv13.i1515.i = zext i8 %1954 to i32, !dbg !5732
  %shl14.i1516.i = shl i32 %conv13.i1515.i, 8, !dbg !5733
  %1955 = load i32, i32* @Inst_Counter, !dbg !5734
  %1956 = add i32 3, %1955, !dbg !5734
  store i32 %1956, i32* @Inst_Counter, !dbg !5734
  %1957 = load i32, i32* @Inst_Counter, !dbg !5734
  call void @printCounter(i32 %1957), !dbg !5734
  %1958 = ptrtoint i32* %t.i1496.i to i64, !dbg !5734
  call void @printLoadAddr(i64 %1958, i32 1534, i32 117, i32 7), !dbg !5734
  %1959 = load i32, i32* %t.i1496.i, align 4, !dbg !5734
  call void @printDDep(i32 1503, i32 1534), !dbg !5734
  call void @printDDep(i32 1514, i32 1534), !dbg !5734
  call void @printDDep(i32 1525, i32 1534), !dbg !5734
  call void @printDDep(i32 1536, i32 1534), !dbg !5734
  call void @printDDep(i32 1545, i32 1534), !dbg !5734
  call void @printDDep(i32 1525, i32 1534), !dbg !5734
  call void @printDDep(i32 1534, i32 1534), !dbg !5734
  %or15.i1517.i = or i32 %1959, %shl14.i1516.i, !dbg !5734
  %1960 = load i32, i32* @Inst_Counter, !dbg !5734
  %1961 = add i32 2, %1960, !dbg !5734
  store i32 %1961, i32* @Inst_Counter, !dbg !5734
  %1962 = load i32, i32* @Inst_Counter, !dbg !5734
  call void @printCounter(i32 %1962), !dbg !5734
  %1963 = ptrtoint i32* %t.i1496.i to i64, !dbg !5734
  call void @printStoreAddr(i64 %1963, i32 1536, i32 117, i32 7), !dbg !5734
  store i32 %or15.i1517.i, i32* %t.i1496.i, align 4, !dbg !5734
  call void @printDDep(i32 1503, i32 1536), !dbg !5734
  call void @printDDep(i32 1514, i32 1536), !dbg !5734
  call void @printDDep(i32 1525, i32 1536), !dbg !5734
  call void @printDDep(i32 1531, i32 1536), !dbg !5734
  call void @printDDep(i32 1534, i32 1536), !dbg !5734
  call void @printDDep(i32 1536, i32 1536), !dbg !5734
  call void @printDDep(i32 1545, i32 1536), !dbg !5734
  call void @printDDep(i32 1525, i32 1536), !dbg !5734
  call void @printDDep(i32 1536, i32 1536), !dbg !5734
  %1964 = load i32, i32* @Inst_Counter, !dbg !5735
  %1965 = add i32 1, %1964, !dbg !5735
  store i32 %1965, i32* @Inst_Counter, !dbg !5735
  %1966 = load i32, i32* @Inst_Counter, !dbg !5735
  call void @printCounter(i32 %1966), !dbg !5735
  %1967 = ptrtoint i32* %X.addr.i1495.i to i64, !dbg !5735
  call void @printLoadAddr(i64 %1967, i32 1537, i32 118, i32 25), !dbg !5735
  %1968 = load i32, i32* %X.addr.i1495.i, align 4, !dbg !5735
  call void @printDDep(i32 1502, i32 1537), !dbg !5735
  call void @printDDep(i32 1502, i32 1537), !dbg !5735
  call void @printDDep(i32 1537, i32 1537), !dbg !5735
  %conv16.i1518.i = trunc i32 %1968 to i8, !dbg !5736
  %idxprom17.i1519.i = zext i8 %conv16.i1518.i to i64, !dbg !5737
  %arrayidx18.i1520.i = getelementptr inbounds [256 x i8], [256 x i8]* @SM4_S, i64 0, i64 %idxprom17.i1519.i, !dbg !5737
  %1969 = load i32, i32* @Inst_Counter, !dbg !5737
  %1970 = add i32 4, %1969, !dbg !5737
  store i32 %1970, i32* @Inst_Counter, !dbg !5737
  %1971 = load i32, i32* @Inst_Counter, !dbg !5737
  call void @printCounter(i32 %1971), !dbg !5737
  %1972 = ptrtoint i8* %arrayidx18.i1520.i to i64, !dbg !5737
  %1973 = load [256 x i8], [256 x i8]* @SM4_S, !dbg !5737
  call void @printSymLoadAddr(i64 %1972, i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 add (i64 ptrtoint ([256 x i8]* @SM4_S to i64), i64 255), i32 1, i32 1541, i32 118, i32 10), !dbg !5737
  %1974 = load i8, i8* %arrayidx18.i1520.i, align 1, !dbg !5737
  call void @printDDep(i32 1537, i32 1541), !dbg !5737
  call void @printDDep(i32 1541, i32 1541), !dbg !5737
  %conv19.i1521.i = zext i8 %1974 to i32, !dbg !5737
  %1975 = load i32, i32* @Inst_Counter, !dbg !5738
  %1976 = add i32 2, %1975, !dbg !5738
  store i32 %1976, i32* @Inst_Counter, !dbg !5738
  %1977 = load i32, i32* @Inst_Counter, !dbg !5738
  call void @printCounter(i32 %1977), !dbg !5738
  %1978 = ptrtoint i32* %t.i1496.i to i64, !dbg !5738
  call void @printLoadAddr(i64 %1978, i32 1543, i32 118, i32 7), !dbg !5738
  %1979 = load i32, i32* %t.i1496.i, align 4, !dbg !5738
  call void @printDDep(i32 1503, i32 1543), !dbg !5738
  call void @printDDep(i32 1514, i32 1543), !dbg !5738
  call void @printDDep(i32 1525, i32 1543), !dbg !5738
  call void @printDDep(i32 1536, i32 1543), !dbg !5738
  call void @printDDep(i32 1545, i32 1543), !dbg !5738
  call void @printDDep(i32 1536, i32 1543), !dbg !5738
  call void @printDDep(i32 1543, i32 1543), !dbg !5738
  %or20.i1522.i = or i32 %1979, %conv19.i1521.i, !dbg !5738
  %1980 = load i32, i32* @Inst_Counter, !dbg !5738
  %1981 = add i32 2, %1980, !dbg !5738
  store i32 %1981, i32* @Inst_Counter, !dbg !5738
  %1982 = load i32, i32* @Inst_Counter, !dbg !5738
  call void @printCounter(i32 %1982), !dbg !5738
  %1983 = ptrtoint i32* %t.i1496.i to i64, !dbg !5738
  call void @printStoreAddr(i64 %1983, i32 1545, i32 118, i32 7), !dbg !5738
  store i32 %or20.i1522.i, i32* %t.i1496.i, align 4, !dbg !5738
  call void @printDDep(i32 1503, i32 1545), !dbg !5738
  call void @printDDep(i32 1514, i32 1545), !dbg !5738
  call void @printDDep(i32 1525, i32 1545), !dbg !5738
  call void @printDDep(i32 1536, i32 1545), !dbg !5738
  call void @printDDep(i32 1541, i32 1545), !dbg !5738
  call void @printDDep(i32 1543, i32 1545), !dbg !5738
  call void @printDDep(i32 1545, i32 1545), !dbg !5738
  call void @printDDep(i32 1536, i32 1545), !dbg !5738
  call void @printDDep(i32 1545, i32 1545), !dbg !5738
  %1984 = load i32, i32* @Inst_Counter, !dbg !5739
  %1985 = add i32 1, %1984, !dbg !5739
  store i32 %1985, i32* @Inst_Counter, !dbg !5739
  %1986 = load i32, i32* @Inst_Counter, !dbg !5739
  call void @printCounter(i32 %1986), !dbg !5739
  %1987 = ptrtoint i32* %t.i1496.i to i64, !dbg !5739
  call void @printLoadAddr(i64 %1987, i32 1546, i32 123, i32 12), !dbg !5739
  %1988 = load i32, i32* %t.i1496.i, align 4, !dbg !5739
  call void @printDDep(i32 1503, i32 1546), !dbg !5739
  call void @printDDep(i32 1514, i32 1546), !dbg !5739
  call void @printDDep(i32 1525, i32 1546), !dbg !5739
  call void @printDDep(i32 1536, i32 1546), !dbg !5739
  call void @printDDep(i32 1545, i32 1546), !dbg !5739
  call void @printDDep(i32 1545, i32 1546), !dbg !5739
  call void @printDDep(i32 1546, i32 1546), !dbg !5739
  %1989 = load i32, i32* @Inst_Counter, !dbg !5740
  %1990 = add i32 1, %1989, !dbg !5740
  store i32 %1990, i32* @Inst_Counter, !dbg !5740
  %1991 = load i32, i32* @Inst_Counter, !dbg !5740
  call void @printCounter(i32 %1991), !dbg !5740
  %1992 = ptrtoint i32* %t.i1496.i to i64, !dbg !5740
  call void @printLoadAddr(i64 %1992, i32 1547, i32 123, i32 21), !dbg !5740
  %1993 = load i32, i32* %t.i1496.i, align 4, !dbg !5740
  call void @printDDep(i32 1503, i32 1547), !dbg !5740
  call void @printDDep(i32 1514, i32 1547), !dbg !5740
  call void @printDDep(i32 1525, i32 1547), !dbg !5740
  call void @printDDep(i32 1536, i32 1547), !dbg !5740
  call void @printDDep(i32 1545, i32 1547), !dbg !5740
  call void @printDDep(i32 1545, i32 1547), !dbg !5740
  call void @printDDep(i32 1547, i32 1547), !dbg !5740
  %1994 = load i32, i32* @Inst_Counter
  %1995 = add i32 1, %1994
  store i32 %1995, i32* @Inst_Counter
  %1996 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %1996)
  %1997 = ptrtoint i32* %a.addr.i.i1493.i to i64
  call void @printStoreAddr(i64 %1997, i32 1548, i32 0, i32 0)
  store i32 %1993, i32* %a.addr.i.i1493.i, align 4
  call void @printDDep(i32 1547, i32 1548)
  call void @printDDep(i32 1548, i32 1548)
  call void @printDDep(i32 1545, i32 1548)
  call void @printDDep(i32 1548, i32 1548)
  %1998 = load i32, i32* @Inst_Counter
  %1999 = add i32 1, %1998
  store i32 %1999, i32* @Inst_Counter
  %2000 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2000)
  %2001 = ptrtoint i8* %n.addr.i.i1494.i to i64
  call void @printStoreAddr(i64 %2001, i32 1549, i32 0, i32 0)
  store i8 2, i8* %n.addr.i.i1494.i, align 1
  call void @printDDep(i32 1549, i32 1549)
  call void @printDDep(i32 1548, i32 1549)
  call void @printDDep(i32 1549, i32 1549)
  %2002 = load i32, i32* @Inst_Counter, !dbg !5741
  %2003 = add i32 1, %2002, !dbg !5741
  store i32 %2003, i32* @Inst_Counter, !dbg !5741
  %2004 = load i32, i32* @Inst_Counter, !dbg !5741
  call void @printCounter(i32 %2004), !dbg !5741
  %2005 = ptrtoint i32* %a.addr.i.i1493.i to i64, !dbg !5741
  call void @printLoadAddr(i64 %2005, i32 1550, i32 92, i32 13), !dbg !5741
  %2006 = load i32, i32* %a.addr.i.i1493.i, align 4, !dbg !5741
  call void @printDDep(i32 1548, i32 1550), !dbg !5741
  call void @printDDep(i32 1549, i32 1550), !dbg !5741
  call void @printDDep(i32 1550, i32 1550), !dbg !5741
  %2007 = load i32, i32* @Inst_Counter, !dbg !5742
  %2008 = add i32 1, %2007, !dbg !5742
  store i32 %2008, i32* @Inst_Counter, !dbg !5742
  %2009 = load i32, i32* @Inst_Counter, !dbg !5742
  call void @printCounter(i32 %2009), !dbg !5742
  %2010 = ptrtoint i8* %n.addr.i.i1494.i to i64, !dbg !5742
  call void @printLoadAddr(i64 %2010, i32 1551, i32 92, i32 18), !dbg !5742
  %2011 = load i8, i8* %n.addr.i.i1494.i, align 1, !dbg !5742
  call void @printDDep(i32 1549, i32 1551), !dbg !5742
  call void @printDDep(i32 1549, i32 1551), !dbg !5742
  call void @printDDep(i32 1551, i32 1551), !dbg !5742
  %conv.i.i1523.i = zext i8 %2011 to i32, !dbg !5742
  %shl.i.i1524.i = shl i32 %2006, %conv.i.i1523.i, !dbg !5743
  %2012 = load i32, i32* @Inst_Counter, !dbg !5744
  %2013 = add i32 3, %2012, !dbg !5744
  store i32 %2013, i32* @Inst_Counter, !dbg !5744
  %2014 = load i32, i32* @Inst_Counter, !dbg !5744
  call void @printCounter(i32 %2014), !dbg !5744
  %2015 = ptrtoint i32* %a.addr.i.i1493.i to i64, !dbg !5744
  call void @printLoadAddr(i64 %2015, i32 1554, i32 92, i32 24), !dbg !5744
  %2016 = load i32, i32* %a.addr.i.i1493.i, align 4, !dbg !5744
  call void @printDDep(i32 1548, i32 1554), !dbg !5744
  call void @printDDep(i32 1549, i32 1554), !dbg !5744
  call void @printDDep(i32 1554, i32 1554), !dbg !5744
  %2017 = load i32, i32* @Inst_Counter, !dbg !5745
  %2018 = add i32 1, %2017, !dbg !5745
  store i32 %2018, i32* @Inst_Counter, !dbg !5745
  %2019 = load i32, i32* @Inst_Counter, !dbg !5745
  call void @printCounter(i32 %2019), !dbg !5745
  %2020 = ptrtoint i8* %n.addr.i.i1494.i to i64, !dbg !5745
  call void @printLoadAddr(i64 %2020, i32 1555, i32 92, i32 35), !dbg !5745
  %2021 = load i8, i8* %n.addr.i.i1494.i, align 1, !dbg !5745
  call void @printDDep(i32 1549, i32 1555), !dbg !5745
  call void @printDDep(i32 1549, i32 1555), !dbg !5745
  call void @printDDep(i32 1555, i32 1555), !dbg !5745
  %conv1.i.i1525.i = zext i8 %2021 to i32, !dbg !5745
  %sub.i.i1526.i = sub nsw i32 32, %conv1.i.i1525.i, !dbg !5746
  %shr.i.i1527.i = lshr i32 %2016, %sub.i.i1526.i, !dbg !5747
  %or.i.i1528.i = or i32 %shl.i.i1524.i, %shr.i.i1527.i, !dbg !5748
  %xor.i1529.i = xor i32 %1988, %or.i.i1528.i, !dbg !5749
  %2022 = load i32, i32* @Inst_Counter, !dbg !5750
  %2023 = add i32 6, %2022, !dbg !5750
  store i32 %2023, i32* @Inst_Counter, !dbg !5750
  %2024 = load i32, i32* @Inst_Counter, !dbg !5750
  call void @printCounter(i32 %2024), !dbg !5750
  %2025 = ptrtoint i32* %t.i1496.i to i64, !dbg !5750
  call void @printLoadAddr(i64 %2025, i32 1561, i32 123, i32 34), !dbg !5750
  %2026 = load i32, i32* %t.i1496.i, align 4, !dbg !5750
  call void @printDDep(i32 1503, i32 1561), !dbg !5750
  call void @printDDep(i32 1514, i32 1561), !dbg !5750
  call void @printDDep(i32 1525, i32 1561), !dbg !5750
  call void @printDDep(i32 1536, i32 1561), !dbg !5750
  call void @printDDep(i32 1545, i32 1561), !dbg !5750
  call void @printDDep(i32 1545, i32 1561), !dbg !5750
  call void @printDDep(i32 1561, i32 1561), !dbg !5750
  %2027 = load i32, i32* @Inst_Counter
  %2028 = add i32 1, %2027
  store i32 %2028, i32* @Inst_Counter
  %2029 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2029)
  %2030 = ptrtoint i32* %a.addr.i43.i1487.i to i64
  call void @printStoreAddr(i64 %2030, i32 1562, i32 0, i32 0)
  store i32 %2026, i32* %a.addr.i43.i1487.i, align 4
  call void @printDDep(i32 1561, i32 1562)
  call void @printDDep(i32 1562, i32 1562)
  call void @printDDep(i32 1549, i32 1562)
  call void @printDDep(i32 1562, i32 1562)
  %2031 = load i32, i32* @Inst_Counter
  %2032 = add i32 1, %2031
  store i32 %2032, i32* @Inst_Counter
  %2033 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2033)
  %2034 = ptrtoint i8* %n.addr.i44.i1488.i to i64
  call void @printStoreAddr(i64 %2034, i32 1563, i32 0, i32 0)
  store i8 10, i8* %n.addr.i44.i1488.i, align 1
  call void @printDDep(i32 1563, i32 1563)
  call void @printDDep(i32 1562, i32 1563)
  call void @printDDep(i32 1563, i32 1563)
  %2035 = load i32, i32* @Inst_Counter, !dbg !5751
  %2036 = add i32 1, %2035, !dbg !5751
  store i32 %2036, i32* @Inst_Counter, !dbg !5751
  %2037 = load i32, i32* @Inst_Counter, !dbg !5751
  call void @printCounter(i32 %2037), !dbg !5751
  %2038 = ptrtoint i32* %a.addr.i43.i1487.i to i64, !dbg !5751
  call void @printLoadAddr(i64 %2038, i32 1564, i32 92, i32 13), !dbg !5751
  %2039 = load i32, i32* %a.addr.i43.i1487.i, align 4, !dbg !5751
  call void @printDDep(i32 1562, i32 1564), !dbg !5751
  call void @printDDep(i32 1563, i32 1564), !dbg !5751
  call void @printDDep(i32 1564, i32 1564), !dbg !5751
  %2040 = load i32, i32* @Inst_Counter, !dbg !5752
  %2041 = add i32 1, %2040, !dbg !5752
  store i32 %2041, i32* @Inst_Counter, !dbg !5752
  %2042 = load i32, i32* @Inst_Counter, !dbg !5752
  call void @printCounter(i32 %2042), !dbg !5752
  %2043 = ptrtoint i8* %n.addr.i44.i1488.i to i64, !dbg !5752
  call void @printLoadAddr(i64 %2043, i32 1565, i32 92, i32 18), !dbg !5752
  %2044 = load i8, i8* %n.addr.i44.i1488.i, align 1, !dbg !5752
  call void @printDDep(i32 1563, i32 1565), !dbg !5752
  call void @printDDep(i32 1563, i32 1565), !dbg !5752
  call void @printDDep(i32 1565, i32 1565), !dbg !5752
  %conv.i45.i1530.i = zext i8 %2044 to i32, !dbg !5752
  %shl.i46.i1531.i = shl i32 %2039, %conv.i45.i1530.i, !dbg !5753
  %2045 = load i32, i32* @Inst_Counter, !dbg !5754
  %2046 = add i32 3, %2045, !dbg !5754
  store i32 %2046, i32* @Inst_Counter, !dbg !5754
  %2047 = load i32, i32* @Inst_Counter, !dbg !5754
  call void @printCounter(i32 %2047), !dbg !5754
  %2048 = ptrtoint i32* %a.addr.i43.i1487.i to i64, !dbg !5754
  call void @printLoadAddr(i64 %2048, i32 1568, i32 92, i32 24), !dbg !5754
  %2049 = load i32, i32* %a.addr.i43.i1487.i, align 4, !dbg !5754
  call void @printDDep(i32 1562, i32 1568), !dbg !5754
  call void @printDDep(i32 1563, i32 1568), !dbg !5754
  call void @printDDep(i32 1568, i32 1568), !dbg !5754
  %2050 = load i32, i32* @Inst_Counter, !dbg !5755
  %2051 = add i32 1, %2050, !dbg !5755
  store i32 %2051, i32* @Inst_Counter, !dbg !5755
  %2052 = load i32, i32* @Inst_Counter, !dbg !5755
  call void @printCounter(i32 %2052), !dbg !5755
  %2053 = ptrtoint i8* %n.addr.i44.i1488.i to i64, !dbg !5755
  call void @printLoadAddr(i64 %2053, i32 1569, i32 92, i32 35), !dbg !5755
  %2054 = load i8, i8* %n.addr.i44.i1488.i, align 1, !dbg !5755
  call void @printDDep(i32 1563, i32 1569), !dbg !5755
  call void @printDDep(i32 1563, i32 1569), !dbg !5755
  call void @printDDep(i32 1569, i32 1569), !dbg !5755
  %conv1.i47.i1532.i = zext i8 %2054 to i32, !dbg !5755
  %sub.i48.i1533.i = sub nsw i32 32, %conv1.i47.i1532.i, !dbg !5756
  %shr.i49.i1534.i = lshr i32 %2049, %sub.i48.i1533.i, !dbg !5757
  %or.i50.i1535.i = or i32 %shl.i46.i1531.i, %shr.i49.i1534.i, !dbg !5758
  %xor22.i1536.i = xor i32 %xor.i1529.i, %or.i50.i1535.i, !dbg !5759
  %2055 = load i32, i32* @Inst_Counter, !dbg !5760
  %2056 = add i32 6, %2055, !dbg !5760
  store i32 %2056, i32* @Inst_Counter, !dbg !5760
  %2057 = load i32, i32* @Inst_Counter, !dbg !5760
  call void @printCounter(i32 %2057), !dbg !5760
  %2058 = ptrtoint i32* %t.i1496.i to i64, !dbg !5760
  call void @printLoadAddr(i64 %2058, i32 1575, i32 123, i32 48), !dbg !5760
  %2059 = load i32, i32* %t.i1496.i, align 4, !dbg !5760
  call void @printDDep(i32 1503, i32 1575), !dbg !5760
  call void @printDDep(i32 1514, i32 1575), !dbg !5760
  call void @printDDep(i32 1525, i32 1575), !dbg !5760
  call void @printDDep(i32 1536, i32 1575), !dbg !5760
  call void @printDDep(i32 1545, i32 1575), !dbg !5760
  call void @printDDep(i32 1545, i32 1575), !dbg !5760
  call void @printDDep(i32 1575, i32 1575), !dbg !5760
  %2060 = load i32, i32* @Inst_Counter
  %2061 = add i32 1, %2060
  store i32 %2061, i32* @Inst_Counter
  %2062 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2062)
  %2063 = ptrtoint i32* %a.addr.i35.i1489.i to i64
  call void @printStoreAddr(i64 %2063, i32 1576, i32 0, i32 0)
  store i32 %2059, i32* %a.addr.i35.i1489.i, align 4
  call void @printDDep(i32 1575, i32 1576)
  call void @printDDep(i32 1576, i32 1576)
  call void @printDDep(i32 1563, i32 1576)
  call void @printDDep(i32 1576, i32 1576)
  %2064 = load i32, i32* @Inst_Counter
  %2065 = add i32 1, %2064
  store i32 %2065, i32* @Inst_Counter
  %2066 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2066)
  %2067 = ptrtoint i8* %n.addr.i36.i1490.i to i64
  call void @printStoreAddr(i64 %2067, i32 1577, i32 0, i32 0)
  store i8 18, i8* %n.addr.i36.i1490.i, align 1
  call void @printDDep(i32 1577, i32 1577)
  call void @printDDep(i32 1576, i32 1577)
  call void @printDDep(i32 1577, i32 1577)
  %2068 = load i32, i32* @Inst_Counter, !dbg !5761
  %2069 = add i32 1, %2068, !dbg !5761
  store i32 %2069, i32* @Inst_Counter, !dbg !5761
  %2070 = load i32, i32* @Inst_Counter, !dbg !5761
  call void @printCounter(i32 %2070), !dbg !5761
  %2071 = ptrtoint i32* %a.addr.i35.i1489.i to i64, !dbg !5761
  call void @printLoadAddr(i64 %2071, i32 1578, i32 92, i32 13), !dbg !5761
  %2072 = load i32, i32* %a.addr.i35.i1489.i, align 4, !dbg !5761
  call void @printDDep(i32 1576, i32 1578), !dbg !5761
  call void @printDDep(i32 1577, i32 1578), !dbg !5761
  call void @printDDep(i32 1578, i32 1578), !dbg !5761
  %2073 = load i32, i32* @Inst_Counter, !dbg !5762
  %2074 = add i32 1, %2073, !dbg !5762
  store i32 %2074, i32* @Inst_Counter, !dbg !5762
  %2075 = load i32, i32* @Inst_Counter, !dbg !5762
  call void @printCounter(i32 %2075), !dbg !5762
  %2076 = ptrtoint i8* %n.addr.i36.i1490.i to i64, !dbg !5762
  call void @printLoadAddr(i64 %2076, i32 1579, i32 92, i32 18), !dbg !5762
  %2077 = load i8, i8* %n.addr.i36.i1490.i, align 1, !dbg !5762
  call void @printDDep(i32 1577, i32 1579), !dbg !5762
  call void @printDDep(i32 1577, i32 1579), !dbg !5762
  call void @printDDep(i32 1579, i32 1579), !dbg !5762
  %conv.i37.i1537.i = zext i8 %2077 to i32, !dbg !5762
  %shl.i38.i1538.i = shl i32 %2072, %conv.i37.i1537.i, !dbg !5763
  %2078 = load i32, i32* @Inst_Counter, !dbg !5764
  %2079 = add i32 3, %2078, !dbg !5764
  store i32 %2079, i32* @Inst_Counter, !dbg !5764
  %2080 = load i32, i32* @Inst_Counter, !dbg !5764
  call void @printCounter(i32 %2080), !dbg !5764
  %2081 = ptrtoint i32* %a.addr.i35.i1489.i to i64, !dbg !5764
  call void @printLoadAddr(i64 %2081, i32 1582, i32 92, i32 24), !dbg !5764
  %2082 = load i32, i32* %a.addr.i35.i1489.i, align 4, !dbg !5764
  call void @printDDep(i32 1576, i32 1582), !dbg !5764
  call void @printDDep(i32 1577, i32 1582), !dbg !5764
  call void @printDDep(i32 1582, i32 1582), !dbg !5764
  %2083 = load i32, i32* @Inst_Counter, !dbg !5765
  %2084 = add i32 1, %2083, !dbg !5765
  store i32 %2084, i32* @Inst_Counter, !dbg !5765
  %2085 = load i32, i32* @Inst_Counter, !dbg !5765
  call void @printCounter(i32 %2085), !dbg !5765
  %2086 = ptrtoint i8* %n.addr.i36.i1490.i to i64, !dbg !5765
  call void @printLoadAddr(i64 %2086, i32 1583, i32 92, i32 35), !dbg !5765
  %2087 = load i8, i8* %n.addr.i36.i1490.i, align 1, !dbg !5765
  call void @printDDep(i32 1577, i32 1583), !dbg !5765
  call void @printDDep(i32 1577, i32 1583), !dbg !5765
  call void @printDDep(i32 1583, i32 1583), !dbg !5765
  %conv1.i39.i1539.i = zext i8 %2087 to i32, !dbg !5765
  %sub.i40.i1540.i = sub nsw i32 32, %conv1.i39.i1539.i, !dbg !5766
  %shr.i41.i1541.i = lshr i32 %2082, %sub.i40.i1540.i, !dbg !5767
  %or.i42.i1542.i = or i32 %shl.i38.i1538.i, %shr.i41.i1541.i, !dbg !5768
  %xor24.i1543.i = xor i32 %xor22.i1536.i, %or.i42.i1542.i, !dbg !5769
  %2088 = load i32, i32* @Inst_Counter, !dbg !5770
  %2089 = add i32 6, %2088, !dbg !5770
  store i32 %2089, i32* @Inst_Counter, !dbg !5770
  %2090 = load i32, i32* @Inst_Counter, !dbg !5770
  call void @printCounter(i32 %2090), !dbg !5770
  %2091 = ptrtoint i32* %t.i1496.i to i64, !dbg !5770
  call void @printLoadAddr(i64 %2091, i32 1589, i32 123, i32 62), !dbg !5770
  %2092 = load i32, i32* %t.i1496.i, align 4, !dbg !5770
  call void @printDDep(i32 1503, i32 1589), !dbg !5770
  call void @printDDep(i32 1514, i32 1589), !dbg !5770
  call void @printDDep(i32 1525, i32 1589), !dbg !5770
  call void @printDDep(i32 1536, i32 1589), !dbg !5770
  call void @printDDep(i32 1545, i32 1589), !dbg !5770
  call void @printDDep(i32 1545, i32 1589), !dbg !5770
  call void @printDDep(i32 1589, i32 1589), !dbg !5770
  %2093 = load i32, i32* @Inst_Counter
  %2094 = add i32 1, %2093
  store i32 %2094, i32* @Inst_Counter
  %2095 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2095)
  %2096 = ptrtoint i32* %a.addr.i27.i1491.i to i64
  call void @printStoreAddr(i64 %2096, i32 1590, i32 0, i32 0)
  store i32 %2092, i32* %a.addr.i27.i1491.i, align 4
  call void @printDDep(i32 1589, i32 1590)
  call void @printDDep(i32 1590, i32 1590)
  call void @printDDep(i32 1577, i32 1590)
  call void @printDDep(i32 1590, i32 1590)
  %2097 = load i32, i32* @Inst_Counter
  %2098 = add i32 1, %2097
  store i32 %2098, i32* @Inst_Counter
  %2099 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2099)
  %2100 = ptrtoint i8* %n.addr.i28.i1492.i to i64
  call void @printStoreAddr(i64 %2100, i32 1591, i32 0, i32 0)
  store i8 24, i8* %n.addr.i28.i1492.i, align 1
  call void @printDDep(i32 1591, i32 1591)
  call void @printDDep(i32 1590, i32 1591)
  call void @printDDep(i32 1591, i32 1591)
  %2101 = load i32, i32* @Inst_Counter, !dbg !5771
  %2102 = add i32 1, %2101, !dbg !5771
  store i32 %2102, i32* @Inst_Counter, !dbg !5771
  %2103 = load i32, i32* @Inst_Counter, !dbg !5771
  call void @printCounter(i32 %2103), !dbg !5771
  %2104 = ptrtoint i32* %a.addr.i27.i1491.i to i64, !dbg !5771
  call void @printLoadAddr(i64 %2104, i32 1592, i32 92, i32 13), !dbg !5771
  %2105 = load i32, i32* %a.addr.i27.i1491.i, align 4, !dbg !5771
  call void @printDDep(i32 1590, i32 1592), !dbg !5771
  call void @printDDep(i32 1591, i32 1592), !dbg !5771
  call void @printDDep(i32 1592, i32 1592), !dbg !5771
  %2106 = load i32, i32* @Inst_Counter, !dbg !5772
  %2107 = add i32 1, %2106, !dbg !5772
  store i32 %2107, i32* @Inst_Counter, !dbg !5772
  %2108 = load i32, i32* @Inst_Counter, !dbg !5772
  call void @printCounter(i32 %2108), !dbg !5772
  %2109 = ptrtoint i8* %n.addr.i28.i1492.i to i64, !dbg !5772
  call void @printLoadAddr(i64 %2109, i32 1593, i32 92, i32 18), !dbg !5772
  %2110 = load i8, i8* %n.addr.i28.i1492.i, align 1, !dbg !5772
  call void @printDDep(i32 1591, i32 1593), !dbg !5772
  call void @printDDep(i32 1591, i32 1593), !dbg !5772
  call void @printDDep(i32 1593, i32 1593), !dbg !5772
  %conv.i29.i1544.i = zext i8 %2110 to i32, !dbg !5772
  %shl.i30.i1545.i = shl i32 %2105, %conv.i29.i1544.i, !dbg !5773
  %2111 = load i32, i32* @Inst_Counter, !dbg !5774
  %2112 = add i32 3, %2111, !dbg !5774
  store i32 %2112, i32* @Inst_Counter, !dbg !5774
  %2113 = load i32, i32* @Inst_Counter, !dbg !5774
  call void @printCounter(i32 %2113), !dbg !5774
  %2114 = ptrtoint i32* %a.addr.i27.i1491.i to i64, !dbg !5774
  call void @printLoadAddr(i64 %2114, i32 1596, i32 92, i32 24), !dbg !5774
  %2115 = load i32, i32* %a.addr.i27.i1491.i, align 4, !dbg !5774
  call void @printDDep(i32 1590, i32 1596), !dbg !5774
  call void @printDDep(i32 1591, i32 1596), !dbg !5774
  call void @printDDep(i32 1596, i32 1596), !dbg !5774
  %2116 = load i32, i32* @Inst_Counter, !dbg !5775
  %2117 = add i32 1, %2116, !dbg !5775
  store i32 %2117, i32* @Inst_Counter, !dbg !5775
  %2118 = load i32, i32* @Inst_Counter, !dbg !5775
  call void @printCounter(i32 %2118), !dbg !5775
  %2119 = ptrtoint i8* %n.addr.i28.i1492.i to i64, !dbg !5775
  call void @printLoadAddr(i64 %2119, i32 1597, i32 92, i32 35), !dbg !5775
  %2120 = load i8, i8* %n.addr.i28.i1492.i, align 1, !dbg !5775
  call void @printDDep(i32 1591, i32 1597), !dbg !5775
  call void @printDDep(i32 1591, i32 1597), !dbg !5775
  call void @printDDep(i32 1597, i32 1597), !dbg !5775
  %conv1.i31.i1546.i = zext i8 %2120 to i32, !dbg !5775
  %sub.i32.i1547.i = sub nsw i32 32, %conv1.i31.i1546.i, !dbg !5776
  %shr.i33.i1548.i = lshr i32 %2115, %sub.i32.i1547.i, !dbg !5777
  %or.i34.i1549.i = or i32 %shl.i30.i1545.i, %shr.i33.i1548.i, !dbg !5778
  %xor26.i1550.i = xor i32 %xor24.i1543.i, %or.i34.i1549.i, !dbg !5779
  %2121 = load i32, i32* @Inst_Counter, !dbg !5515
  %2122 = add i32 6, %2121, !dbg !5515
  store i32 %2122, i32* @Inst_Counter, !dbg !5515
  %2123 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %2123), !dbg !5515
  %2124 = ptrtoint i32* %B3.i to i64, !dbg !5515
  call void @printLoadAddr(i64 %2124, i32 1603, i32 200, i32 5), !dbg !5515
  %2125 = load i32, i32* %B3.i, align 4, !dbg !5515
  call void @printDDep(i32 1149, i32 1603), !dbg !5515
  call void @printDDep(i32 1605, i32 1603), !dbg !5515
  call void @printDDep(i32 1909, i32 1603), !dbg !5515
  call void @printDDep(i32 2213, i32 1603), !dbg !5515
  call void @printDDep(i32 2517, i32 1603), !dbg !5515
  call void @printDDep(i32 2821, i32 1603), !dbg !5515
  call void @printDDep(i32 3125, i32 1603), !dbg !5515
  call void @printDDep(i32 3429, i32 1603), !dbg !5515
  call void @printDDep(i32 3885, i32 1603), !dbg !5515
  call void @printDDep(i32 1149, i32 1603), !dbg !5515
  call void @printDDep(i32 1603, i32 1603), !dbg !5515
  %xor29.i = xor i32 %2125, %xor26.i1550.i, !dbg !5515
  %2126 = load i32, i32* @Inst_Counter, !dbg !5515
  %2127 = add i32 2, %2126, !dbg !5515
  store i32 %2127, i32* @Inst_Counter, !dbg !5515
  %2128 = load i32, i32* @Inst_Counter, !dbg !5515
  call void @printCounter(i32 %2128), !dbg !5515
  %2129 = ptrtoint i32* %B3.i to i64, !dbg !5515
  call void @printStoreAddr(i64 %2129, i32 1605, i32 200, i32 5), !dbg !5515
  store i32 %xor29.i, i32* %B3.i, align 4, !dbg !5515
  call void @printDDep(i32 1149, i32 1605), !dbg !5515
  call void @printDDep(i32 1546, i32 1605), !dbg !5515
  call void @printDDep(i32 1550, i32 1605), !dbg !5515
  call void @printDDep(i32 1551, i32 1605), !dbg !5515
  call void @printDDep(i32 1554, i32 1605), !dbg !5515
  call void @printDDep(i32 1555, i32 1605), !dbg !5515
  call void @printDDep(i32 1564, i32 1605), !dbg !5515
  call void @printDDep(i32 1565, i32 1605), !dbg !5515
  call void @printDDep(i32 1568, i32 1605), !dbg !5515
  call void @printDDep(i32 1569, i32 1605), !dbg !5515
  call void @printDDep(i32 1578, i32 1605), !dbg !5515
  call void @printDDep(i32 1579, i32 1605), !dbg !5515
  call void @printDDep(i32 1582, i32 1605), !dbg !5515
  call void @printDDep(i32 1583, i32 1605), !dbg !5515
  call void @printDDep(i32 1592, i32 1605), !dbg !5515
  call void @printDDep(i32 1593, i32 1605), !dbg !5515
  call void @printDDep(i32 1596, i32 1605), !dbg !5515
  call void @printDDep(i32 1597, i32 1605), !dbg !5515
  call void @printDDep(i32 1603, i32 1605), !dbg !5515
  call void @printDDep(i32 1605, i32 1605), !dbg !5515
  call void @printDDep(i32 1909, i32 1605), !dbg !5515
  call void @printDDep(i32 2213, i32 1605), !dbg !5515
  call void @printDDep(i32 2517, i32 1605), !dbg !5515
  call void @printDDep(i32 2821, i32 1605), !dbg !5515
  call void @printDDep(i32 3125, i32 1605), !dbg !5515
  call void @printDDep(i32 3429, i32 1605), !dbg !5515
  call void @printDDep(i32 3885, i32 1605), !dbg !5515
  call void @printDDep(i32 1591, i32 1605), !dbg !5515
  call void @printDDep(i32 1605, i32 1605), !dbg !5515
  %2130 = load i32, i32* @Inst_Counter, !dbg !5780
  %2131 = add i32 1, %2130, !dbg !5780
  store i32 %2131, i32* @Inst_Counter, !dbg !5780
  %2132 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2132), !dbg !5780
  %2133 = ptrtoint i32* %B1.i to i64, !dbg !5780
  call void @printLoadAddr(i64 %2133, i32 1606, i32 201, i32 5), !dbg !5780
  %2134 = load i32, i32* %B1.i, align 4, !dbg !5780
  call void @printDDep(i32 1067, i32 1606), !dbg !5780
  call void @printDDep(i32 1377, i32 1606), !dbg !5780
  call void @printDDep(i32 1757, i32 1606), !dbg !5780
  call void @printDDep(i32 2061, i32 1606), !dbg !5780
  call void @printDDep(i32 2365, i32 1606), !dbg !5780
  call void @printDDep(i32 2669, i32 1606), !dbg !5780
  call void @printDDep(i32 2973, i32 1606), !dbg !5780
  call void @printDDep(i32 3277, i32 1606), !dbg !5780
  call void @printDDep(i32 3657, i32 1606), !dbg !5780
  call void @printDDep(i32 1377, i32 1606), !dbg !5780
  call void @printDDep(i32 1606, i32 1606), !dbg !5780
  %2135 = load i32, i32* @Inst_Counter, !dbg !5780
  %2136 = add i32 1, %2135, !dbg !5780
  store i32 %2136, i32* @Inst_Counter, !dbg !5780
  %2137 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2137), !dbg !5780
  %2138 = ptrtoint i32* %B2.i to i64, !dbg !5780
  call void @printLoadAddr(i64 %2138, i32 1607, i32 201, i32 5), !dbg !5780
  %2139 = load i32, i32* %B2.i, align 4, !dbg !5780
  call void @printDDep(i32 1108, i32 1607), !dbg !5780
  call void @printDDep(i32 1491, i32 1607), !dbg !5780
  call void @printDDep(i32 1833, i32 1607), !dbg !5780
  call void @printDDep(i32 2137, i32 1607), !dbg !5780
  call void @printDDep(i32 2441, i32 1607), !dbg !5780
  call void @printDDep(i32 2745, i32 1607), !dbg !5780
  call void @printDDep(i32 3049, i32 1607), !dbg !5780
  call void @printDDep(i32 3353, i32 1607), !dbg !5780
  call void @printDDep(i32 3771, i32 1607), !dbg !5780
  call void @printDDep(i32 1491, i32 1607), !dbg !5780
  call void @printDDep(i32 1607, i32 1607), !dbg !5780
  %xor31.i = xor i32 %2134, %2139, !dbg !5780
  %2140 = load i32, i32* @Inst_Counter, !dbg !5780
  %2141 = add i32 2, %2140, !dbg !5780
  store i32 %2141, i32* @Inst_Counter, !dbg !5780
  %2142 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2142), !dbg !5780
  %2143 = ptrtoint i32* %B3.i to i64, !dbg !5780
  call void @printLoadAddr(i64 %2143, i32 1609, i32 201, i32 5), !dbg !5780
  %2144 = load i32, i32* %B3.i, align 4, !dbg !5780
  call void @printDDep(i32 1149, i32 1609), !dbg !5780
  call void @printDDep(i32 1605, i32 1609), !dbg !5780
  call void @printDDep(i32 1909, i32 1609), !dbg !5780
  call void @printDDep(i32 2213, i32 1609), !dbg !5780
  call void @printDDep(i32 2517, i32 1609), !dbg !5780
  call void @printDDep(i32 2821, i32 1609), !dbg !5780
  call void @printDDep(i32 3125, i32 1609), !dbg !5780
  call void @printDDep(i32 3429, i32 1609), !dbg !5780
  call void @printDDep(i32 3885, i32 1609), !dbg !5780
  call void @printDDep(i32 1605, i32 1609), !dbg !5780
  call void @printDDep(i32 1609, i32 1609), !dbg !5780
  %xor32.i = xor i32 %xor31.i, %2144, !dbg !5780
  %2145 = load i32, i32* @Inst_Counter, !dbg !5780
  %2146 = add i32 2, %2145, !dbg !5780
  store i32 %2146, i32* @Inst_Counter, !dbg !5780
  %2147 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2147), !dbg !5780
  %2148 = ptrtoint %struct.SM4_KEY_st** %ks.addr.i24 to i64, !dbg !5780
  call void @printLoadAddr(i64 %2148, i32 1611, i32 201, i32 5), !dbg !5780
  %2149 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr.i24, align 8, !dbg !5780
  call void @printDDep(i32 983, i32 1611), !dbg !5780
  call void @printDDep(i32 985, i32 1611), !dbg !5780
  call void @printDDep(i32 1611, i32 1611), !dbg !5780
  %rk33.i = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %2149, i32 0, i32 0, !dbg !5780
  %arrayidx34.i = getelementptr inbounds [32 x i32], [32 x i32]* %rk33.i, i64 0, i64 4, !dbg !5780
  %2150 = load i32, i32* @Inst_Counter, !dbg !5780
  %2151 = add i32 3, %2150, !dbg !5780
  store i32 %2151, i32* @Inst_Counter, !dbg !5780
  %2152 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2152), !dbg !5780
  %2153 = ptrtoint i32* %arrayidx34.i to i64, !dbg !5780
  call void @printLoadAddr(i64 %2153, i32 1614, i32 201, i32 5), !dbg !5780
  %2154 = load i32, i32* %arrayidx34.i, align 4, !dbg !5780
  call void @printDDep(i32 1611, i32 1614), !dbg !5780
  call void @printDDep(i32 1605, i32 1614), !dbg !5780
  call void @printDDep(i32 1614, i32 1614), !dbg !5780
  %xor35.i = xor i32 %xor32.i, %2154, !dbg !5780
  %2155 = load i32, i32* @Inst_Counter
  %2156 = add i32 2, %2155
  store i32 %2156, i32* @Inst_Counter
  %2157 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2157)
  %2158 = ptrtoint i32* %X.addr.i1450.i to i64
  call void @printStoreAddr(i64 %2158, i32 1616, i32 0, i32 0)
  store i32 %xor35.i, i32* %X.addr.i1450.i, align 4
  call void @printDDep(i32 1606, i32 1616)
  call void @printDDep(i32 1607, i32 1616)
  call void @printDDep(i32 1609, i32 1616)
  call void @printDDep(i32 1614, i32 1616)
  call void @printDDep(i32 1616, i32 1616)
  call void @printDDep(i32 1605, i32 1616)
  call void @printDDep(i32 1616, i32 1616)
  %2159 = load i32, i32* @Inst_Counter, !dbg !5781
  %2160 = add i32 1, %2159, !dbg !5781
  store i32 %2160, i32* @Inst_Counter, !dbg !5781
  %2161 = load i32, i32* @Inst_Counter, !dbg !5781
  call void @printCounter(i32 %2161), !dbg !5781
  %2162 = ptrtoint i32* %X.addr.i1450.i to i64, !dbg !5781
  call void @printLoadAddr(i64 %2162, i32 1617, i32 128, i32 33), !dbg !5781
  %2163 = load i32, i32* %X.addr.i1450.i, align 4, !dbg !5781
  call void @printDDep(i32 1616, i32 1617), !dbg !5781
  call void @printDDep(i32 1616, i32 1617), !dbg !5781
  call void @printDDep(i32 1617, i32 1617), !dbg !5781
  %shr.i1451.i = lshr i32 %2163, 24, !dbg !5782
  %conv.i1452.i = trunc i32 %shr.i1451.i to i8, !dbg !5783
  %idxprom.i1453.i = zext i8 %conv.i1452.i to i64, !dbg !5784
  %arrayidx.i1454.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1453.i, !dbg !5784
  %2164 = load i32, i32* @Inst_Counter, !dbg !5784
  %2165 = add i32 5, %2164, !dbg !5784
  store i32 %2165, i32* @Inst_Counter, !dbg !5784
  %2166 = load i32, i32* @Inst_Counter, !dbg !5784
  call void @printCounter(i32 %2166), !dbg !5784
  %2167 = ptrtoint i32* %arrayidx.i1454.i to i64, !dbg !5784
  %2168 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5784
  call void @printSymLoadAddr(i64 %2167, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 1622, i32 128, i32 12), !dbg !5784
  %2169 = load i32, i32* %arrayidx.i1454.i, align 4, !dbg !5784
  call void @printDDep(i32 1617, i32 1622), !dbg !5784
  call void @printDDep(i32 1622, i32 1622), !dbg !5784
  %2170 = load i32, i32* @Inst_Counter, !dbg !5785
  %2171 = add i32 1, %2170, !dbg !5785
  store i32 %2171, i32* @Inst_Counter, !dbg !5785
  %2172 = load i32, i32* @Inst_Counter, !dbg !5785
  call void @printCounter(i32 %2172), !dbg !5785
  %2173 = ptrtoint i32* %X.addr.i1450.i to i64, !dbg !5785
  call void @printLoadAddr(i64 %2173, i32 1623, i32 129, i32 38), !dbg !5785
  %2174 = load i32, i32* %X.addr.i1450.i, align 4, !dbg !5785
  call void @printDDep(i32 1616, i32 1623), !dbg !5785
  call void @printDDep(i32 1616, i32 1623), !dbg !5785
  call void @printDDep(i32 1623, i32 1623), !dbg !5785
  %shr1.i1455.i = lshr i32 %2174, 16, !dbg !5786
  %conv2.i1456.i = trunc i32 %shr1.i1455.i to i8, !dbg !5787
  %idxprom3.i1457.i = zext i8 %conv2.i1456.i to i64, !dbg !5788
  %arrayidx4.i1458.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1457.i, !dbg !5788
  %2175 = load i32, i32* @Inst_Counter, !dbg !5788
  %2176 = add i32 5, %2175, !dbg !5788
  store i32 %2176, i32* @Inst_Counter, !dbg !5788
  %2177 = load i32, i32* @Inst_Counter, !dbg !5788
  call void @printCounter(i32 %2177), !dbg !5788
  %2178 = ptrtoint i32* %arrayidx4.i1458.i to i64, !dbg !5788
  %2179 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5788
  call void @printSymLoadAddr(i64 %2178, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 1628, i32 129, i32 17), !dbg !5788
  %2180 = load i32, i32* %arrayidx4.i1458.i, align 4, !dbg !5788
  call void @printDDep(i32 1623, i32 1628), !dbg !5788
  call void @printDDep(i32 1628, i32 1628), !dbg !5788
  %2181 = load i32, i32* @Inst_Counter
  %2182 = add i32 1, %2181
  store i32 %2182, i32* @Inst_Counter
  %2183 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2183)
  %2184 = ptrtoint i32* %a.addr.i.i1448.i to i64
  call void @printStoreAddr(i64 %2184, i32 1629, i32 0, i32 0)
  store i32 %2180, i32* %a.addr.i.i1448.i, align 4
  call void @printDDep(i32 1628, i32 1629)
  call void @printDDep(i32 1629, i32 1629)
  call void @printDDep(i32 1616, i32 1629)
  call void @printDDep(i32 1629, i32 1629)
  %2185 = load i32, i32* @Inst_Counter
  %2186 = add i32 1, %2185
  store i32 %2186, i32* @Inst_Counter
  %2187 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2187)
  %2188 = ptrtoint i8* %n.addr.i.i1449.i to i64
  call void @printStoreAddr(i64 %2188, i32 1630, i32 0, i32 0)
  store i8 24, i8* %n.addr.i.i1449.i, align 1
  call void @printDDep(i32 1630, i32 1630)
  call void @printDDep(i32 1629, i32 1630)
  call void @printDDep(i32 1630, i32 1630)
  %2189 = load i32, i32* @Inst_Counter, !dbg !5789
  %2190 = add i32 1, %2189, !dbg !5789
  store i32 %2190, i32* @Inst_Counter, !dbg !5789
  %2191 = load i32, i32* @Inst_Counter, !dbg !5789
  call void @printCounter(i32 %2191), !dbg !5789
  %2192 = ptrtoint i32* %a.addr.i.i1448.i to i64, !dbg !5789
  call void @printLoadAddr(i64 %2192, i32 1631, i32 92, i32 13), !dbg !5789
  %2193 = load i32, i32* %a.addr.i.i1448.i, align 4, !dbg !5789
  call void @printDDep(i32 1629, i32 1631), !dbg !5789
  call void @printDDep(i32 1630, i32 1631), !dbg !5789
  call void @printDDep(i32 1631, i32 1631), !dbg !5789
  %2194 = load i32, i32* @Inst_Counter, !dbg !5790
  %2195 = add i32 1, %2194, !dbg !5790
  store i32 %2195, i32* @Inst_Counter, !dbg !5790
  %2196 = load i32, i32* @Inst_Counter, !dbg !5790
  call void @printCounter(i32 %2196), !dbg !5790
  %2197 = ptrtoint i8* %n.addr.i.i1449.i to i64, !dbg !5790
  call void @printLoadAddr(i64 %2197, i32 1632, i32 92, i32 18), !dbg !5790
  %2198 = load i8, i8* %n.addr.i.i1449.i, align 1, !dbg !5790
  call void @printDDep(i32 1630, i32 1632), !dbg !5790
  call void @printDDep(i32 1630, i32 1632), !dbg !5790
  call void @printDDep(i32 1632, i32 1632), !dbg !5790
  %conv.i.i1459.i = zext i8 %2198 to i32, !dbg !5790
  %shl.i.i1460.i = shl i32 %2193, %conv.i.i1459.i, !dbg !5791
  %2199 = load i32, i32* @Inst_Counter, !dbg !5792
  %2200 = add i32 3, %2199, !dbg !5792
  store i32 %2200, i32* @Inst_Counter, !dbg !5792
  %2201 = load i32, i32* @Inst_Counter, !dbg !5792
  call void @printCounter(i32 %2201), !dbg !5792
  %2202 = ptrtoint i32* %a.addr.i.i1448.i to i64, !dbg !5792
  call void @printLoadAddr(i64 %2202, i32 1635, i32 92, i32 24), !dbg !5792
  %2203 = load i32, i32* %a.addr.i.i1448.i, align 4, !dbg !5792
  call void @printDDep(i32 1629, i32 1635), !dbg !5792
  call void @printDDep(i32 1630, i32 1635), !dbg !5792
  call void @printDDep(i32 1635, i32 1635), !dbg !5792
  %2204 = load i32, i32* @Inst_Counter, !dbg !5793
  %2205 = add i32 1, %2204, !dbg !5793
  store i32 %2205, i32* @Inst_Counter, !dbg !5793
  %2206 = load i32, i32* @Inst_Counter, !dbg !5793
  call void @printCounter(i32 %2206), !dbg !5793
  %2207 = ptrtoint i8* %n.addr.i.i1449.i to i64, !dbg !5793
  call void @printLoadAddr(i64 %2207, i32 1636, i32 92, i32 35), !dbg !5793
  %2208 = load i8, i8* %n.addr.i.i1449.i, align 1, !dbg !5793
  call void @printDDep(i32 1630, i32 1636), !dbg !5793
  call void @printDDep(i32 1630, i32 1636), !dbg !5793
  call void @printDDep(i32 1636, i32 1636), !dbg !5793
  %conv1.i.i1461.i = zext i8 %2208 to i32, !dbg !5793
  %sub.i.i1462.i = sub nsw i32 32, %conv1.i.i1461.i, !dbg !5794
  %shr.i.i1463.i = lshr i32 %2203, %sub.i.i1462.i, !dbg !5795
  %or.i.i1464.i = or i32 %shl.i.i1460.i, %shr.i.i1463.i, !dbg !5796
  %xor.i1465.i = xor i32 %2169, %or.i.i1464.i, !dbg !5797
  %2209 = load i32, i32* @Inst_Counter, !dbg !5798
  %2210 = add i32 6, %2209, !dbg !5798
  store i32 %2210, i32* @Inst_Counter, !dbg !5798
  %2211 = load i32, i32* @Inst_Counter, !dbg !5798
  call void @printCounter(i32 %2211), !dbg !5798
  %2212 = ptrtoint i32* %X.addr.i1450.i to i64, !dbg !5798
  call void @printLoadAddr(i64 %2212, i32 1642, i32 130, i32 38), !dbg !5798
  %2213 = load i32, i32* %X.addr.i1450.i, align 4, !dbg !5798
  call void @printDDep(i32 1616, i32 1642), !dbg !5798
  call void @printDDep(i32 1630, i32 1642), !dbg !5798
  call void @printDDep(i32 1642, i32 1642), !dbg !5798
  %shr5.i1466.i = lshr i32 %2213, 8, !dbg !5799
  %conv6.i1467.i = trunc i32 %shr5.i1466.i to i8, !dbg !5800
  %idxprom7.i1468.i = zext i8 %conv6.i1467.i to i64, !dbg !5801
  %arrayidx8.i1469.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1468.i, !dbg !5801
  %2214 = load i32, i32* @Inst_Counter, !dbg !5801
  %2215 = add i32 5, %2214, !dbg !5801
  store i32 %2215, i32* @Inst_Counter, !dbg !5801
  %2216 = load i32, i32* @Inst_Counter, !dbg !5801
  call void @printCounter(i32 %2216), !dbg !5801
  %2217 = ptrtoint i32* %arrayidx8.i1469.i to i64, !dbg !5801
  %2218 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5801
  call void @printSymLoadAddr(i64 %2217, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 1647, i32 130, i32 17), !dbg !5801
  %2219 = load i32, i32* %arrayidx8.i1469.i, align 4, !dbg !5801
  call void @printDDep(i32 1642, i32 1647), !dbg !5801
  call void @printDDep(i32 1647, i32 1647), !dbg !5801
  %2220 = load i32, i32* @Inst_Counter
  %2221 = add i32 1, %2220
  store i32 %2221, i32* @Inst_Counter
  %2222 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2222)
  %2223 = ptrtoint i32* %a.addr.i24.i1444.i to i64
  call void @printStoreAddr(i64 %2223, i32 1648, i32 0, i32 0)
  store i32 %2219, i32* %a.addr.i24.i1444.i, align 4
  call void @printDDep(i32 1647, i32 1648)
  call void @printDDep(i32 1648, i32 1648)
  call void @printDDep(i32 1630, i32 1648)
  call void @printDDep(i32 1648, i32 1648)
  %2224 = load i32, i32* @Inst_Counter
  %2225 = add i32 1, %2224
  store i32 %2225, i32* @Inst_Counter
  %2226 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2226)
  %2227 = ptrtoint i8* %n.addr.i25.i1445.i to i64
  call void @printStoreAddr(i64 %2227, i32 1649, i32 0, i32 0)
  store i8 16, i8* %n.addr.i25.i1445.i, align 1
  call void @printDDep(i32 1649, i32 1649)
  call void @printDDep(i32 1648, i32 1649)
  call void @printDDep(i32 1649, i32 1649)
  %2228 = load i32, i32* @Inst_Counter, !dbg !5802
  %2229 = add i32 1, %2228, !dbg !5802
  store i32 %2229, i32* @Inst_Counter, !dbg !5802
  %2230 = load i32, i32* @Inst_Counter, !dbg !5802
  call void @printCounter(i32 %2230), !dbg !5802
  %2231 = ptrtoint i32* %a.addr.i24.i1444.i to i64, !dbg !5802
  call void @printLoadAddr(i64 %2231, i32 1650, i32 92, i32 13), !dbg !5802
  %2232 = load i32, i32* %a.addr.i24.i1444.i, align 4, !dbg !5802
  call void @printDDep(i32 1648, i32 1650), !dbg !5802
  call void @printDDep(i32 1649, i32 1650), !dbg !5802
  call void @printDDep(i32 1650, i32 1650), !dbg !5802
  %2233 = load i32, i32* @Inst_Counter, !dbg !5803
  %2234 = add i32 1, %2233, !dbg !5803
  store i32 %2234, i32* @Inst_Counter, !dbg !5803
  %2235 = load i32, i32* @Inst_Counter, !dbg !5803
  call void @printCounter(i32 %2235), !dbg !5803
  %2236 = ptrtoint i8* %n.addr.i25.i1445.i to i64, !dbg !5803
  call void @printLoadAddr(i64 %2236, i32 1651, i32 92, i32 18), !dbg !5803
  %2237 = load i8, i8* %n.addr.i25.i1445.i, align 1, !dbg !5803
  call void @printDDep(i32 1649, i32 1651), !dbg !5803
  call void @printDDep(i32 1649, i32 1651), !dbg !5803
  call void @printDDep(i32 1651, i32 1651), !dbg !5803
  %conv.i26.i1470.i = zext i8 %2237 to i32, !dbg !5803
  %shl.i27.i1471.i = shl i32 %2232, %conv.i26.i1470.i, !dbg !5804
  %2238 = load i32, i32* @Inst_Counter, !dbg !5805
  %2239 = add i32 3, %2238, !dbg !5805
  store i32 %2239, i32* @Inst_Counter, !dbg !5805
  %2240 = load i32, i32* @Inst_Counter, !dbg !5805
  call void @printCounter(i32 %2240), !dbg !5805
  %2241 = ptrtoint i32* %a.addr.i24.i1444.i to i64, !dbg !5805
  call void @printLoadAddr(i64 %2241, i32 1654, i32 92, i32 24), !dbg !5805
  %2242 = load i32, i32* %a.addr.i24.i1444.i, align 4, !dbg !5805
  call void @printDDep(i32 1648, i32 1654), !dbg !5805
  call void @printDDep(i32 1649, i32 1654), !dbg !5805
  call void @printDDep(i32 1654, i32 1654), !dbg !5805
  %2243 = load i32, i32* @Inst_Counter, !dbg !5806
  %2244 = add i32 1, %2243, !dbg !5806
  store i32 %2244, i32* @Inst_Counter, !dbg !5806
  %2245 = load i32, i32* @Inst_Counter, !dbg !5806
  call void @printCounter(i32 %2245), !dbg !5806
  %2246 = ptrtoint i8* %n.addr.i25.i1445.i to i64, !dbg !5806
  call void @printLoadAddr(i64 %2246, i32 1655, i32 92, i32 35), !dbg !5806
  %2247 = load i8, i8* %n.addr.i25.i1445.i, align 1, !dbg !5806
  call void @printDDep(i32 1649, i32 1655), !dbg !5806
  call void @printDDep(i32 1649, i32 1655), !dbg !5806
  call void @printDDep(i32 1655, i32 1655), !dbg !5806
  %conv1.i28.i1472.i = zext i8 %2247 to i32, !dbg !5806
  %sub.i29.i1473.i = sub nsw i32 32, %conv1.i28.i1472.i, !dbg !5807
  %shr.i30.i1474.i = lshr i32 %2242, %sub.i29.i1473.i, !dbg !5808
  %or.i31.i1475.i = or i32 %shl.i27.i1471.i, %shr.i30.i1474.i, !dbg !5809
  %xor10.i1476.i = xor i32 %xor.i1465.i, %or.i31.i1475.i, !dbg !5810
  %2248 = load i32, i32* @Inst_Counter, !dbg !5811
  %2249 = add i32 6, %2248, !dbg !5811
  store i32 %2249, i32* @Inst_Counter, !dbg !5811
  %2250 = load i32, i32* @Inst_Counter, !dbg !5811
  call void @printCounter(i32 %2250), !dbg !5811
  %2251 = ptrtoint i32* %X.addr.i1450.i to i64, !dbg !5811
  call void @printLoadAddr(i64 %2251, i32 1661, i32 131, i32 37), !dbg !5811
  %2252 = load i32, i32* %X.addr.i1450.i, align 4, !dbg !5811
  call void @printDDep(i32 1616, i32 1661), !dbg !5811
  call void @printDDep(i32 1649, i32 1661), !dbg !5811
  call void @printDDep(i32 1661, i32 1661), !dbg !5811
  %conv11.i1477.i = trunc i32 %2252 to i8, !dbg !5812
  %idxprom12.i1478.i = zext i8 %conv11.i1477.i to i64, !dbg !5813
  %arrayidx13.i1479.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1478.i, !dbg !5813
  %2253 = load i32, i32* @Inst_Counter, !dbg !5813
  %2254 = add i32 4, %2253, !dbg !5813
  store i32 %2254, i32* @Inst_Counter, !dbg !5813
  %2255 = load i32, i32* @Inst_Counter, !dbg !5813
  call void @printCounter(i32 %2255), !dbg !5813
  %2256 = ptrtoint i32* %arrayidx13.i1479.i to i64, !dbg !5813
  %2257 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5813
  call void @printSymLoadAddr(i64 %2256, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 1665, i32 131, i32 17), !dbg !5813
  %2258 = load i32, i32* %arrayidx13.i1479.i, align 4, !dbg !5813
  call void @printDDep(i32 1661, i32 1665), !dbg !5813
  call void @printDDep(i32 1665, i32 1665), !dbg !5813
  %2259 = load i32, i32* @Inst_Counter
  %2260 = add i32 1, %2259
  store i32 %2260, i32* @Inst_Counter
  %2261 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2261)
  %2262 = ptrtoint i32* %a.addr.i16.i1446.i to i64
  call void @printStoreAddr(i64 %2262, i32 1666, i32 0, i32 0)
  store i32 %2258, i32* %a.addr.i16.i1446.i, align 4
  call void @printDDep(i32 1665, i32 1666)
  call void @printDDep(i32 1666, i32 1666)
  call void @printDDep(i32 1649, i32 1666)
  call void @printDDep(i32 1666, i32 1666)
  %2263 = load i32, i32* @Inst_Counter
  %2264 = add i32 1, %2263
  store i32 %2264, i32* @Inst_Counter
  %2265 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2265)
  %2266 = ptrtoint i8* %n.addr.i17.i1447.i to i64
  call void @printStoreAddr(i64 %2266, i32 1667, i32 0, i32 0)
  store i8 8, i8* %n.addr.i17.i1447.i, align 1
  call void @printDDep(i32 1667, i32 1667)
  call void @printDDep(i32 1666, i32 1667)
  call void @printDDep(i32 1667, i32 1667)
  %2267 = load i32, i32* @Inst_Counter, !dbg !5814
  %2268 = add i32 1, %2267, !dbg !5814
  store i32 %2268, i32* @Inst_Counter, !dbg !5814
  %2269 = load i32, i32* @Inst_Counter, !dbg !5814
  call void @printCounter(i32 %2269), !dbg !5814
  %2270 = ptrtoint i32* %a.addr.i16.i1446.i to i64, !dbg !5814
  call void @printLoadAddr(i64 %2270, i32 1668, i32 92, i32 13), !dbg !5814
  %2271 = load i32, i32* %a.addr.i16.i1446.i, align 4, !dbg !5814
  call void @printDDep(i32 1666, i32 1668), !dbg !5814
  call void @printDDep(i32 1667, i32 1668), !dbg !5814
  call void @printDDep(i32 1668, i32 1668), !dbg !5814
  %2272 = load i32, i32* @Inst_Counter, !dbg !5815
  %2273 = add i32 1, %2272, !dbg !5815
  store i32 %2273, i32* @Inst_Counter, !dbg !5815
  %2274 = load i32, i32* @Inst_Counter, !dbg !5815
  call void @printCounter(i32 %2274), !dbg !5815
  %2275 = ptrtoint i8* %n.addr.i17.i1447.i to i64, !dbg !5815
  call void @printLoadAddr(i64 %2275, i32 1669, i32 92, i32 18), !dbg !5815
  %2276 = load i8, i8* %n.addr.i17.i1447.i, align 1, !dbg !5815
  call void @printDDep(i32 1667, i32 1669), !dbg !5815
  call void @printDDep(i32 1667, i32 1669), !dbg !5815
  call void @printDDep(i32 1669, i32 1669), !dbg !5815
  %conv.i18.i1480.i = zext i8 %2276 to i32, !dbg !5815
  %shl.i19.i1481.i = shl i32 %2271, %conv.i18.i1480.i, !dbg !5816
  %2277 = load i32, i32* @Inst_Counter, !dbg !5817
  %2278 = add i32 3, %2277, !dbg !5817
  store i32 %2278, i32* @Inst_Counter, !dbg !5817
  %2279 = load i32, i32* @Inst_Counter, !dbg !5817
  call void @printCounter(i32 %2279), !dbg !5817
  %2280 = ptrtoint i32* %a.addr.i16.i1446.i to i64, !dbg !5817
  call void @printLoadAddr(i64 %2280, i32 1672, i32 92, i32 24), !dbg !5817
  %2281 = load i32, i32* %a.addr.i16.i1446.i, align 4, !dbg !5817
  call void @printDDep(i32 1666, i32 1672), !dbg !5817
  call void @printDDep(i32 1667, i32 1672), !dbg !5817
  call void @printDDep(i32 1672, i32 1672), !dbg !5817
  %2282 = load i32, i32* @Inst_Counter, !dbg !5818
  %2283 = add i32 1, %2282, !dbg !5818
  store i32 %2283, i32* @Inst_Counter, !dbg !5818
  %2284 = load i32, i32* @Inst_Counter, !dbg !5818
  call void @printCounter(i32 %2284), !dbg !5818
  %2285 = ptrtoint i8* %n.addr.i17.i1447.i to i64, !dbg !5818
  call void @printLoadAddr(i64 %2285, i32 1673, i32 92, i32 35), !dbg !5818
  %2286 = load i8, i8* %n.addr.i17.i1447.i, align 1, !dbg !5818
  call void @printDDep(i32 1667, i32 1673), !dbg !5818
  call void @printDDep(i32 1667, i32 1673), !dbg !5818
  call void @printDDep(i32 1673, i32 1673), !dbg !5818
  %conv1.i20.i1482.i = zext i8 %2286 to i32, !dbg !5818
  %sub.i21.i1483.i = sub nsw i32 32, %conv1.i20.i1482.i, !dbg !5819
  %shr.i22.i1484.i = lshr i32 %2281, %sub.i21.i1483.i, !dbg !5820
  %or.i23.i1485.i = or i32 %shl.i19.i1481.i, %shr.i22.i1484.i, !dbg !5821
  %xor15.i1486.i = xor i32 %xor10.i1476.i, %or.i23.i1485.i, !dbg !5822
  %2287 = load i32, i32* @Inst_Counter, !dbg !5780
  %2288 = add i32 6, %2287, !dbg !5780
  store i32 %2288, i32* @Inst_Counter, !dbg !5780
  %2289 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2289), !dbg !5780
  %2290 = ptrtoint i32* %B0.i to i64, !dbg !5780
  call void @printLoadAddr(i64 %2290, i32 1679, i32 201, i32 5), !dbg !5780
  %2291 = load i32, i32* %B0.i, align 4, !dbg !5780
  call void @printDDep(i32 1026, i32 1679), !dbg !5780
  call void @printDDep(i32 1263, i32 1679), !dbg !5780
  call void @printDDep(i32 1681, i32 1679), !dbg !5780
  call void @printDDep(i32 1985, i32 1679), !dbg !5780
  call void @printDDep(i32 2289, i32 1679), !dbg !5780
  call void @printDDep(i32 2593, i32 1679), !dbg !5780
  call void @printDDep(i32 2897, i32 1679), !dbg !5780
  call void @printDDep(i32 3201, i32 1679), !dbg !5780
  call void @printDDep(i32 3543, i32 1679), !dbg !5780
  call void @printDDep(i32 1263, i32 1679), !dbg !5780
  call void @printDDep(i32 1679, i32 1679), !dbg !5780
  %xor37.i = xor i32 %2291, %xor15.i1486.i, !dbg !5780
  %2292 = load i32, i32* @Inst_Counter, !dbg !5780
  %2293 = add i32 2, %2292, !dbg !5780
  store i32 %2293, i32* @Inst_Counter, !dbg !5780
  %2294 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2294), !dbg !5780
  %2295 = ptrtoint i32* %B0.i to i64, !dbg !5780
  call void @printStoreAddr(i64 %2295, i32 1681, i32 201, i32 5), !dbg !5780
  store i32 %xor37.i, i32* %B0.i, align 4, !dbg !5780
  call void @printDDep(i32 1026, i32 1681), !dbg !5780
  call void @printDDep(i32 1263, i32 1681), !dbg !5780
  call void @printDDep(i32 1622, i32 1681), !dbg !5780
  call void @printDDep(i32 1631, i32 1681), !dbg !5780
  call void @printDDep(i32 1632, i32 1681), !dbg !5780
  call void @printDDep(i32 1635, i32 1681), !dbg !5780
  call void @printDDep(i32 1636, i32 1681), !dbg !5780
  call void @printDDep(i32 1650, i32 1681), !dbg !5780
  call void @printDDep(i32 1651, i32 1681), !dbg !5780
  call void @printDDep(i32 1654, i32 1681), !dbg !5780
  call void @printDDep(i32 1655, i32 1681), !dbg !5780
  call void @printDDep(i32 1668, i32 1681), !dbg !5780
  call void @printDDep(i32 1669, i32 1681), !dbg !5780
  call void @printDDep(i32 1672, i32 1681), !dbg !5780
  call void @printDDep(i32 1673, i32 1681), !dbg !5780
  call void @printDDep(i32 1679, i32 1681), !dbg !5780
  call void @printDDep(i32 1681, i32 1681), !dbg !5780
  call void @printDDep(i32 1985, i32 1681), !dbg !5780
  call void @printDDep(i32 2289, i32 1681), !dbg !5780
  call void @printDDep(i32 2593, i32 1681), !dbg !5780
  call void @printDDep(i32 2897, i32 1681), !dbg !5780
  call void @printDDep(i32 3201, i32 1681), !dbg !5780
  call void @printDDep(i32 3543, i32 1681), !dbg !5780
  call void @printDDep(i32 1667, i32 1681), !dbg !5780
  call void @printDDep(i32 1681, i32 1681), !dbg !5780
  %2296 = load i32, i32* @Inst_Counter, !dbg !5780
  %2297 = add i32 1, %2296, !dbg !5780
  store i32 %2297, i32* @Inst_Counter, !dbg !5780
  %2298 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2298), !dbg !5780
  %2299 = ptrtoint i32* %B0.i to i64, !dbg !5780
  call void @printLoadAddr(i64 %2299, i32 1682, i32 201, i32 5), !dbg !5780
  %2300 = load i32, i32* %B0.i, align 4, !dbg !5780
  call void @printDDep(i32 1026, i32 1682), !dbg !5780
  call void @printDDep(i32 1263, i32 1682), !dbg !5780
  call void @printDDep(i32 1681, i32 1682), !dbg !5780
  call void @printDDep(i32 1985, i32 1682), !dbg !5780
  call void @printDDep(i32 2289, i32 1682), !dbg !5780
  call void @printDDep(i32 2593, i32 1682), !dbg !5780
  call void @printDDep(i32 2897, i32 1682), !dbg !5780
  call void @printDDep(i32 3201, i32 1682), !dbg !5780
  call void @printDDep(i32 3543, i32 1682), !dbg !5780
  call void @printDDep(i32 1681, i32 1682), !dbg !5780
  call void @printDDep(i32 1682, i32 1682), !dbg !5780
  %2301 = load i32, i32* @Inst_Counter, !dbg !5780
  %2302 = add i32 1, %2301, !dbg !5780
  store i32 %2302, i32* @Inst_Counter, !dbg !5780
  %2303 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2303), !dbg !5780
  %2304 = ptrtoint i32* %B2.i to i64, !dbg !5780
  call void @printLoadAddr(i64 %2304, i32 1683, i32 201, i32 5), !dbg !5780
  %2305 = load i32, i32* %B2.i, align 4, !dbg !5780
  call void @printDDep(i32 1108, i32 1683), !dbg !5780
  call void @printDDep(i32 1491, i32 1683), !dbg !5780
  call void @printDDep(i32 1833, i32 1683), !dbg !5780
  call void @printDDep(i32 2137, i32 1683), !dbg !5780
  call void @printDDep(i32 2441, i32 1683), !dbg !5780
  call void @printDDep(i32 2745, i32 1683), !dbg !5780
  call void @printDDep(i32 3049, i32 1683), !dbg !5780
  call void @printDDep(i32 3353, i32 1683), !dbg !5780
  call void @printDDep(i32 3771, i32 1683), !dbg !5780
  call void @printDDep(i32 1491, i32 1683), !dbg !5780
  call void @printDDep(i32 1683, i32 1683), !dbg !5780
  %xor38.i = xor i32 %2300, %2305, !dbg !5780
  %2306 = load i32, i32* @Inst_Counter, !dbg !5780
  %2307 = add i32 2, %2306, !dbg !5780
  store i32 %2307, i32* @Inst_Counter, !dbg !5780
  %2308 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2308), !dbg !5780
  %2309 = ptrtoint i32* %B3.i to i64, !dbg !5780
  call void @printLoadAddr(i64 %2309, i32 1685, i32 201, i32 5), !dbg !5780
  %2310 = load i32, i32* %B3.i, align 4, !dbg !5780
  call void @printDDep(i32 1149, i32 1685), !dbg !5780
  call void @printDDep(i32 1605, i32 1685), !dbg !5780
  call void @printDDep(i32 1909, i32 1685), !dbg !5780
  call void @printDDep(i32 2213, i32 1685), !dbg !5780
  call void @printDDep(i32 2517, i32 1685), !dbg !5780
  call void @printDDep(i32 2821, i32 1685), !dbg !5780
  call void @printDDep(i32 3125, i32 1685), !dbg !5780
  call void @printDDep(i32 3429, i32 1685), !dbg !5780
  call void @printDDep(i32 3885, i32 1685), !dbg !5780
  call void @printDDep(i32 1605, i32 1685), !dbg !5780
  call void @printDDep(i32 1685, i32 1685), !dbg !5780
  %xor39.i = xor i32 %xor38.i, %2310, !dbg !5780
  %2311 = load i32, i32* @Inst_Counter, !dbg !5780
  %2312 = add i32 2, %2311, !dbg !5780
  store i32 %2312, i32* @Inst_Counter, !dbg !5780
  %2313 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2313), !dbg !5780
  %2314 = ptrtoint %struct.SM4_KEY_st** %ks.addr.i24 to i64, !dbg !5780
  call void @printLoadAddr(i64 %2314, i32 1687, i32 201, i32 5), !dbg !5780
  %2315 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr.i24, align 8, !dbg !5780
  call void @printDDep(i32 983, i32 1687), !dbg !5780
  call void @printDDep(i32 985, i32 1687), !dbg !5780
  call void @printDDep(i32 1687, i32 1687), !dbg !5780
  %rk40.i = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %2315, i32 0, i32 0, !dbg !5780
  %arrayidx41.i = getelementptr inbounds [32 x i32], [32 x i32]* %rk40.i, i64 0, i64 5, !dbg !5780
  %2316 = load i32, i32* @Inst_Counter, !dbg !5780
  %2317 = add i32 3, %2316, !dbg !5780
  store i32 %2317, i32* @Inst_Counter, !dbg !5780
  %2318 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2318), !dbg !5780
  %2319 = ptrtoint i32* %arrayidx41.i to i64, !dbg !5780
  call void @printLoadAddr(i64 %2319, i32 1690, i32 201, i32 5), !dbg !5780
  %2320 = load i32, i32* %arrayidx41.i, align 4, !dbg !5780
  call void @printDDep(i32 1687, i32 1690), !dbg !5780
  call void @printDDep(i32 1681, i32 1690), !dbg !5780
  call void @printDDep(i32 1690, i32 1690), !dbg !5780
  %xor42.i = xor i32 %xor39.i, %2320, !dbg !5780
  %2321 = load i32, i32* @Inst_Counter
  %2322 = add i32 2, %2321
  store i32 %2322, i32* @Inst_Counter
  %2323 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2323)
  %2324 = ptrtoint i32* %X.addr.i1407.i to i64
  call void @printStoreAddr(i64 %2324, i32 1692, i32 0, i32 0)
  store i32 %xor42.i, i32* %X.addr.i1407.i, align 4
  call void @printDDep(i32 1682, i32 1692)
  call void @printDDep(i32 1683, i32 1692)
  call void @printDDep(i32 1685, i32 1692)
  call void @printDDep(i32 1690, i32 1692)
  call void @printDDep(i32 1692, i32 1692)
  call void @printDDep(i32 1681, i32 1692)
  call void @printDDep(i32 1692, i32 1692)
  %2325 = load i32, i32* @Inst_Counter, !dbg !5823
  %2326 = add i32 1, %2325, !dbg !5823
  store i32 %2326, i32* @Inst_Counter, !dbg !5823
  %2327 = load i32, i32* @Inst_Counter, !dbg !5823
  call void @printCounter(i32 %2327), !dbg !5823
  %2328 = ptrtoint i32* %X.addr.i1407.i to i64, !dbg !5823
  call void @printLoadAddr(i64 %2328, i32 1693, i32 128, i32 33), !dbg !5823
  %2329 = load i32, i32* %X.addr.i1407.i, align 4, !dbg !5823
  call void @printDDep(i32 1692, i32 1693), !dbg !5823
  call void @printDDep(i32 1692, i32 1693), !dbg !5823
  call void @printDDep(i32 1693, i32 1693), !dbg !5823
  %shr.i1408.i = lshr i32 %2329, 24, !dbg !5824
  %conv.i1409.i = trunc i32 %shr.i1408.i to i8, !dbg !5825
  %idxprom.i1410.i = zext i8 %conv.i1409.i to i64, !dbg !5826
  %arrayidx.i1411.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1410.i, !dbg !5826
  %2330 = load i32, i32* @Inst_Counter, !dbg !5826
  %2331 = add i32 5, %2330, !dbg !5826
  store i32 %2331, i32* @Inst_Counter, !dbg !5826
  %2332 = load i32, i32* @Inst_Counter, !dbg !5826
  call void @printCounter(i32 %2332), !dbg !5826
  %2333 = ptrtoint i32* %arrayidx.i1411.i to i64, !dbg !5826
  %2334 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5826
  call void @printSymLoadAddr(i64 %2333, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 1698, i32 128, i32 12), !dbg !5826
  %2335 = load i32, i32* %arrayidx.i1411.i, align 4, !dbg !5826
  call void @printDDep(i32 1693, i32 1698), !dbg !5826
  call void @printDDep(i32 1698, i32 1698), !dbg !5826
  %2336 = load i32, i32* @Inst_Counter, !dbg !5827
  %2337 = add i32 1, %2336, !dbg !5827
  store i32 %2337, i32* @Inst_Counter, !dbg !5827
  %2338 = load i32, i32* @Inst_Counter, !dbg !5827
  call void @printCounter(i32 %2338), !dbg !5827
  %2339 = ptrtoint i32* %X.addr.i1407.i to i64, !dbg !5827
  call void @printLoadAddr(i64 %2339, i32 1699, i32 129, i32 38), !dbg !5827
  %2340 = load i32, i32* %X.addr.i1407.i, align 4, !dbg !5827
  call void @printDDep(i32 1692, i32 1699), !dbg !5827
  call void @printDDep(i32 1692, i32 1699), !dbg !5827
  call void @printDDep(i32 1699, i32 1699), !dbg !5827
  %shr1.i1412.i = lshr i32 %2340, 16, !dbg !5828
  %conv2.i1413.i = trunc i32 %shr1.i1412.i to i8, !dbg !5829
  %idxprom3.i1414.i = zext i8 %conv2.i1413.i to i64, !dbg !5830
  %arrayidx4.i1415.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1414.i, !dbg !5830
  %2341 = load i32, i32* @Inst_Counter, !dbg !5830
  %2342 = add i32 5, %2341, !dbg !5830
  store i32 %2342, i32* @Inst_Counter, !dbg !5830
  %2343 = load i32, i32* @Inst_Counter, !dbg !5830
  call void @printCounter(i32 %2343), !dbg !5830
  %2344 = ptrtoint i32* %arrayidx4.i1415.i to i64, !dbg !5830
  %2345 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5830
  call void @printSymLoadAddr(i64 %2344, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 1704, i32 129, i32 17), !dbg !5830
  %2346 = load i32, i32* %arrayidx4.i1415.i, align 4, !dbg !5830
  call void @printDDep(i32 1699, i32 1704), !dbg !5830
  call void @printDDep(i32 1704, i32 1704), !dbg !5830
  %2347 = load i32, i32* @Inst_Counter
  %2348 = add i32 1, %2347
  store i32 %2348, i32* @Inst_Counter
  %2349 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2349)
  %2350 = ptrtoint i32* %a.addr.i.i1405.i to i64
  call void @printStoreAddr(i64 %2350, i32 1705, i32 0, i32 0)
  store i32 %2346, i32* %a.addr.i.i1405.i, align 4
  call void @printDDep(i32 1704, i32 1705)
  call void @printDDep(i32 1705, i32 1705)
  call void @printDDep(i32 1692, i32 1705)
  call void @printDDep(i32 1705, i32 1705)
  %2351 = load i32, i32* @Inst_Counter
  %2352 = add i32 1, %2351
  store i32 %2352, i32* @Inst_Counter
  %2353 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2353)
  %2354 = ptrtoint i8* %n.addr.i.i1406.i to i64
  call void @printStoreAddr(i64 %2354, i32 1706, i32 0, i32 0)
  store i8 24, i8* %n.addr.i.i1406.i, align 1
  call void @printDDep(i32 1706, i32 1706)
  call void @printDDep(i32 1705, i32 1706)
  call void @printDDep(i32 1706, i32 1706)
  %2355 = load i32, i32* @Inst_Counter, !dbg !5831
  %2356 = add i32 1, %2355, !dbg !5831
  store i32 %2356, i32* @Inst_Counter, !dbg !5831
  %2357 = load i32, i32* @Inst_Counter, !dbg !5831
  call void @printCounter(i32 %2357), !dbg !5831
  %2358 = ptrtoint i32* %a.addr.i.i1405.i to i64, !dbg !5831
  call void @printLoadAddr(i64 %2358, i32 1707, i32 92, i32 13), !dbg !5831
  %2359 = load i32, i32* %a.addr.i.i1405.i, align 4, !dbg !5831
  call void @printDDep(i32 1705, i32 1707), !dbg !5831
  call void @printDDep(i32 1706, i32 1707), !dbg !5831
  call void @printDDep(i32 1707, i32 1707), !dbg !5831
  %2360 = load i32, i32* @Inst_Counter, !dbg !5832
  %2361 = add i32 1, %2360, !dbg !5832
  store i32 %2361, i32* @Inst_Counter, !dbg !5832
  %2362 = load i32, i32* @Inst_Counter, !dbg !5832
  call void @printCounter(i32 %2362), !dbg !5832
  %2363 = ptrtoint i8* %n.addr.i.i1406.i to i64, !dbg !5832
  call void @printLoadAddr(i64 %2363, i32 1708, i32 92, i32 18), !dbg !5832
  %2364 = load i8, i8* %n.addr.i.i1406.i, align 1, !dbg !5832
  call void @printDDep(i32 1706, i32 1708), !dbg !5832
  call void @printDDep(i32 1706, i32 1708), !dbg !5832
  call void @printDDep(i32 1708, i32 1708), !dbg !5832
  %conv.i.i1416.i = zext i8 %2364 to i32, !dbg !5832
  %shl.i.i1417.i = shl i32 %2359, %conv.i.i1416.i, !dbg !5833
  %2365 = load i32, i32* @Inst_Counter, !dbg !5834
  %2366 = add i32 3, %2365, !dbg !5834
  store i32 %2366, i32* @Inst_Counter, !dbg !5834
  %2367 = load i32, i32* @Inst_Counter, !dbg !5834
  call void @printCounter(i32 %2367), !dbg !5834
  %2368 = ptrtoint i32* %a.addr.i.i1405.i to i64, !dbg !5834
  call void @printLoadAddr(i64 %2368, i32 1711, i32 92, i32 24), !dbg !5834
  %2369 = load i32, i32* %a.addr.i.i1405.i, align 4, !dbg !5834
  call void @printDDep(i32 1705, i32 1711), !dbg !5834
  call void @printDDep(i32 1706, i32 1711), !dbg !5834
  call void @printDDep(i32 1711, i32 1711), !dbg !5834
  %2370 = load i32, i32* @Inst_Counter, !dbg !5835
  %2371 = add i32 1, %2370, !dbg !5835
  store i32 %2371, i32* @Inst_Counter, !dbg !5835
  %2372 = load i32, i32* @Inst_Counter, !dbg !5835
  call void @printCounter(i32 %2372), !dbg !5835
  %2373 = ptrtoint i8* %n.addr.i.i1406.i to i64, !dbg !5835
  call void @printLoadAddr(i64 %2373, i32 1712, i32 92, i32 35), !dbg !5835
  %2374 = load i8, i8* %n.addr.i.i1406.i, align 1, !dbg !5835
  call void @printDDep(i32 1706, i32 1712), !dbg !5835
  call void @printDDep(i32 1706, i32 1712), !dbg !5835
  call void @printDDep(i32 1712, i32 1712), !dbg !5835
  %conv1.i.i1418.i = zext i8 %2374 to i32, !dbg !5835
  %sub.i.i1419.i = sub nsw i32 32, %conv1.i.i1418.i, !dbg !5836
  %shr.i.i1420.i = lshr i32 %2369, %sub.i.i1419.i, !dbg !5837
  %or.i.i1421.i = or i32 %shl.i.i1417.i, %shr.i.i1420.i, !dbg !5838
  %xor.i1422.i = xor i32 %2335, %or.i.i1421.i, !dbg !5839
  %2375 = load i32, i32* @Inst_Counter, !dbg !5840
  %2376 = add i32 6, %2375, !dbg !5840
  store i32 %2376, i32* @Inst_Counter, !dbg !5840
  %2377 = load i32, i32* @Inst_Counter, !dbg !5840
  call void @printCounter(i32 %2377), !dbg !5840
  %2378 = ptrtoint i32* %X.addr.i1407.i to i64, !dbg !5840
  call void @printLoadAddr(i64 %2378, i32 1718, i32 130, i32 38), !dbg !5840
  %2379 = load i32, i32* %X.addr.i1407.i, align 4, !dbg !5840
  call void @printDDep(i32 1692, i32 1718), !dbg !5840
  call void @printDDep(i32 1706, i32 1718), !dbg !5840
  call void @printDDep(i32 1718, i32 1718), !dbg !5840
  %shr5.i1423.i = lshr i32 %2379, 8, !dbg !5841
  %conv6.i1424.i = trunc i32 %shr5.i1423.i to i8, !dbg !5842
  %idxprom7.i1425.i = zext i8 %conv6.i1424.i to i64, !dbg !5843
  %arrayidx8.i1426.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1425.i, !dbg !5843
  %2380 = load i32, i32* @Inst_Counter, !dbg !5843
  %2381 = add i32 5, %2380, !dbg !5843
  store i32 %2381, i32* @Inst_Counter, !dbg !5843
  %2382 = load i32, i32* @Inst_Counter, !dbg !5843
  call void @printCounter(i32 %2382), !dbg !5843
  %2383 = ptrtoint i32* %arrayidx8.i1426.i to i64, !dbg !5843
  %2384 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5843
  call void @printSymLoadAddr(i64 %2383, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 1723, i32 130, i32 17), !dbg !5843
  %2385 = load i32, i32* %arrayidx8.i1426.i, align 4, !dbg !5843
  call void @printDDep(i32 1718, i32 1723), !dbg !5843
  call void @printDDep(i32 1723, i32 1723), !dbg !5843
  %2386 = load i32, i32* @Inst_Counter
  %2387 = add i32 1, %2386
  store i32 %2387, i32* @Inst_Counter
  %2388 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2388)
  %2389 = ptrtoint i32* %a.addr.i24.i1401.i to i64
  call void @printStoreAddr(i64 %2389, i32 1724, i32 0, i32 0)
  store i32 %2385, i32* %a.addr.i24.i1401.i, align 4
  call void @printDDep(i32 1723, i32 1724)
  call void @printDDep(i32 1724, i32 1724)
  call void @printDDep(i32 1706, i32 1724)
  call void @printDDep(i32 1724, i32 1724)
  %2390 = load i32, i32* @Inst_Counter
  %2391 = add i32 1, %2390
  store i32 %2391, i32* @Inst_Counter
  %2392 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2392)
  %2393 = ptrtoint i8* %n.addr.i25.i1402.i to i64
  call void @printStoreAddr(i64 %2393, i32 1725, i32 0, i32 0)
  store i8 16, i8* %n.addr.i25.i1402.i, align 1
  call void @printDDep(i32 1725, i32 1725)
  call void @printDDep(i32 1724, i32 1725)
  call void @printDDep(i32 1725, i32 1725)
  %2394 = load i32, i32* @Inst_Counter, !dbg !5844
  %2395 = add i32 1, %2394, !dbg !5844
  store i32 %2395, i32* @Inst_Counter, !dbg !5844
  %2396 = load i32, i32* @Inst_Counter, !dbg !5844
  call void @printCounter(i32 %2396), !dbg !5844
  %2397 = ptrtoint i32* %a.addr.i24.i1401.i to i64, !dbg !5844
  call void @printLoadAddr(i64 %2397, i32 1726, i32 92, i32 13), !dbg !5844
  %2398 = load i32, i32* %a.addr.i24.i1401.i, align 4, !dbg !5844
  call void @printDDep(i32 1724, i32 1726), !dbg !5844
  call void @printDDep(i32 1725, i32 1726), !dbg !5844
  call void @printDDep(i32 1726, i32 1726), !dbg !5844
  %2399 = load i32, i32* @Inst_Counter, !dbg !5845
  %2400 = add i32 1, %2399, !dbg !5845
  store i32 %2400, i32* @Inst_Counter, !dbg !5845
  %2401 = load i32, i32* @Inst_Counter, !dbg !5845
  call void @printCounter(i32 %2401), !dbg !5845
  %2402 = ptrtoint i8* %n.addr.i25.i1402.i to i64, !dbg !5845
  call void @printLoadAddr(i64 %2402, i32 1727, i32 92, i32 18), !dbg !5845
  %2403 = load i8, i8* %n.addr.i25.i1402.i, align 1, !dbg !5845
  call void @printDDep(i32 1725, i32 1727), !dbg !5845
  call void @printDDep(i32 1725, i32 1727), !dbg !5845
  call void @printDDep(i32 1727, i32 1727), !dbg !5845
  %conv.i26.i1427.i = zext i8 %2403 to i32, !dbg !5845
  %shl.i27.i1428.i = shl i32 %2398, %conv.i26.i1427.i, !dbg !5846
  %2404 = load i32, i32* @Inst_Counter, !dbg !5847
  %2405 = add i32 3, %2404, !dbg !5847
  store i32 %2405, i32* @Inst_Counter, !dbg !5847
  %2406 = load i32, i32* @Inst_Counter, !dbg !5847
  call void @printCounter(i32 %2406), !dbg !5847
  %2407 = ptrtoint i32* %a.addr.i24.i1401.i to i64, !dbg !5847
  call void @printLoadAddr(i64 %2407, i32 1730, i32 92, i32 24), !dbg !5847
  %2408 = load i32, i32* %a.addr.i24.i1401.i, align 4, !dbg !5847
  call void @printDDep(i32 1724, i32 1730), !dbg !5847
  call void @printDDep(i32 1725, i32 1730), !dbg !5847
  call void @printDDep(i32 1730, i32 1730), !dbg !5847
  %2409 = load i32, i32* @Inst_Counter, !dbg !5848
  %2410 = add i32 1, %2409, !dbg !5848
  store i32 %2410, i32* @Inst_Counter, !dbg !5848
  %2411 = load i32, i32* @Inst_Counter, !dbg !5848
  call void @printCounter(i32 %2411), !dbg !5848
  %2412 = ptrtoint i8* %n.addr.i25.i1402.i to i64, !dbg !5848
  call void @printLoadAddr(i64 %2412, i32 1731, i32 92, i32 35), !dbg !5848
  %2413 = load i8, i8* %n.addr.i25.i1402.i, align 1, !dbg !5848
  call void @printDDep(i32 1725, i32 1731), !dbg !5848
  call void @printDDep(i32 1725, i32 1731), !dbg !5848
  call void @printDDep(i32 1731, i32 1731), !dbg !5848
  %conv1.i28.i1429.i = zext i8 %2413 to i32, !dbg !5848
  %sub.i29.i1430.i = sub nsw i32 32, %conv1.i28.i1429.i, !dbg !5849
  %shr.i30.i1431.i = lshr i32 %2408, %sub.i29.i1430.i, !dbg !5850
  %or.i31.i1432.i = or i32 %shl.i27.i1428.i, %shr.i30.i1431.i, !dbg !5851
  %xor10.i1433.i = xor i32 %xor.i1422.i, %or.i31.i1432.i, !dbg !5852
  %2414 = load i32, i32* @Inst_Counter, !dbg !5853
  %2415 = add i32 6, %2414, !dbg !5853
  store i32 %2415, i32* @Inst_Counter, !dbg !5853
  %2416 = load i32, i32* @Inst_Counter, !dbg !5853
  call void @printCounter(i32 %2416), !dbg !5853
  %2417 = ptrtoint i32* %X.addr.i1407.i to i64, !dbg !5853
  call void @printLoadAddr(i64 %2417, i32 1737, i32 131, i32 37), !dbg !5853
  %2418 = load i32, i32* %X.addr.i1407.i, align 4, !dbg !5853
  call void @printDDep(i32 1692, i32 1737), !dbg !5853
  call void @printDDep(i32 1725, i32 1737), !dbg !5853
  call void @printDDep(i32 1737, i32 1737), !dbg !5853
  %conv11.i1434.i = trunc i32 %2418 to i8, !dbg !5854
  %idxprom12.i1435.i = zext i8 %conv11.i1434.i to i64, !dbg !5855
  %arrayidx13.i1436.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1435.i, !dbg !5855
  %2419 = load i32, i32* @Inst_Counter, !dbg !5855
  %2420 = add i32 4, %2419, !dbg !5855
  store i32 %2420, i32* @Inst_Counter, !dbg !5855
  %2421 = load i32, i32* @Inst_Counter, !dbg !5855
  call void @printCounter(i32 %2421), !dbg !5855
  %2422 = ptrtoint i32* %arrayidx13.i1436.i to i64, !dbg !5855
  %2423 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5855
  call void @printSymLoadAddr(i64 %2422, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 1741, i32 131, i32 17), !dbg !5855
  %2424 = load i32, i32* %arrayidx13.i1436.i, align 4, !dbg !5855
  call void @printDDep(i32 1737, i32 1741), !dbg !5855
  call void @printDDep(i32 1741, i32 1741), !dbg !5855
  %2425 = load i32, i32* @Inst_Counter
  %2426 = add i32 1, %2425
  store i32 %2426, i32* @Inst_Counter
  %2427 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2427)
  %2428 = ptrtoint i32* %a.addr.i16.i1403.i to i64
  call void @printStoreAddr(i64 %2428, i32 1742, i32 0, i32 0)
  store i32 %2424, i32* %a.addr.i16.i1403.i, align 4
  call void @printDDep(i32 1741, i32 1742)
  call void @printDDep(i32 1742, i32 1742)
  call void @printDDep(i32 1725, i32 1742)
  call void @printDDep(i32 1742, i32 1742)
  %2429 = load i32, i32* @Inst_Counter
  %2430 = add i32 1, %2429
  store i32 %2430, i32* @Inst_Counter
  %2431 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2431)
  %2432 = ptrtoint i8* %n.addr.i17.i1404.i to i64
  call void @printStoreAddr(i64 %2432, i32 1743, i32 0, i32 0)
  store i8 8, i8* %n.addr.i17.i1404.i, align 1
  call void @printDDep(i32 1743, i32 1743)
  call void @printDDep(i32 1742, i32 1743)
  call void @printDDep(i32 1743, i32 1743)
  %2433 = load i32, i32* @Inst_Counter, !dbg !5856
  %2434 = add i32 1, %2433, !dbg !5856
  store i32 %2434, i32* @Inst_Counter, !dbg !5856
  %2435 = load i32, i32* @Inst_Counter, !dbg !5856
  call void @printCounter(i32 %2435), !dbg !5856
  %2436 = ptrtoint i32* %a.addr.i16.i1403.i to i64, !dbg !5856
  call void @printLoadAddr(i64 %2436, i32 1744, i32 92, i32 13), !dbg !5856
  %2437 = load i32, i32* %a.addr.i16.i1403.i, align 4, !dbg !5856
  call void @printDDep(i32 1742, i32 1744), !dbg !5856
  call void @printDDep(i32 1743, i32 1744), !dbg !5856
  call void @printDDep(i32 1744, i32 1744), !dbg !5856
  %2438 = load i32, i32* @Inst_Counter, !dbg !5857
  %2439 = add i32 1, %2438, !dbg !5857
  store i32 %2439, i32* @Inst_Counter, !dbg !5857
  %2440 = load i32, i32* @Inst_Counter, !dbg !5857
  call void @printCounter(i32 %2440), !dbg !5857
  %2441 = ptrtoint i8* %n.addr.i17.i1404.i to i64, !dbg !5857
  call void @printLoadAddr(i64 %2441, i32 1745, i32 92, i32 18), !dbg !5857
  %2442 = load i8, i8* %n.addr.i17.i1404.i, align 1, !dbg !5857
  call void @printDDep(i32 1743, i32 1745), !dbg !5857
  call void @printDDep(i32 1743, i32 1745), !dbg !5857
  call void @printDDep(i32 1745, i32 1745), !dbg !5857
  %conv.i18.i1437.i = zext i8 %2442 to i32, !dbg !5857
  %shl.i19.i1438.i = shl i32 %2437, %conv.i18.i1437.i, !dbg !5858
  %2443 = load i32, i32* @Inst_Counter, !dbg !5859
  %2444 = add i32 3, %2443, !dbg !5859
  store i32 %2444, i32* @Inst_Counter, !dbg !5859
  %2445 = load i32, i32* @Inst_Counter, !dbg !5859
  call void @printCounter(i32 %2445), !dbg !5859
  %2446 = ptrtoint i32* %a.addr.i16.i1403.i to i64, !dbg !5859
  call void @printLoadAddr(i64 %2446, i32 1748, i32 92, i32 24), !dbg !5859
  %2447 = load i32, i32* %a.addr.i16.i1403.i, align 4, !dbg !5859
  call void @printDDep(i32 1742, i32 1748), !dbg !5859
  call void @printDDep(i32 1743, i32 1748), !dbg !5859
  call void @printDDep(i32 1748, i32 1748), !dbg !5859
  %2448 = load i32, i32* @Inst_Counter, !dbg !5860
  %2449 = add i32 1, %2448, !dbg !5860
  store i32 %2449, i32* @Inst_Counter, !dbg !5860
  %2450 = load i32, i32* @Inst_Counter, !dbg !5860
  call void @printCounter(i32 %2450), !dbg !5860
  %2451 = ptrtoint i8* %n.addr.i17.i1404.i to i64, !dbg !5860
  call void @printLoadAddr(i64 %2451, i32 1749, i32 92, i32 35), !dbg !5860
  %2452 = load i8, i8* %n.addr.i17.i1404.i, align 1, !dbg !5860
  call void @printDDep(i32 1743, i32 1749), !dbg !5860
  call void @printDDep(i32 1743, i32 1749), !dbg !5860
  call void @printDDep(i32 1749, i32 1749), !dbg !5860
  %conv1.i20.i1439.i = zext i8 %2452 to i32, !dbg !5860
  %sub.i21.i1440.i = sub nsw i32 32, %conv1.i20.i1439.i, !dbg !5861
  %shr.i22.i1441.i = lshr i32 %2447, %sub.i21.i1440.i, !dbg !5862
  %or.i23.i1442.i = or i32 %shl.i19.i1438.i, %shr.i22.i1441.i, !dbg !5863
  %xor15.i1443.i = xor i32 %xor10.i1433.i, %or.i23.i1442.i, !dbg !5864
  %2453 = load i32, i32* @Inst_Counter, !dbg !5780
  %2454 = add i32 6, %2453, !dbg !5780
  store i32 %2454, i32* @Inst_Counter, !dbg !5780
  %2455 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2455), !dbg !5780
  %2456 = ptrtoint i32* %B1.i to i64, !dbg !5780
  call void @printLoadAddr(i64 %2456, i32 1755, i32 201, i32 5), !dbg !5780
  %2457 = load i32, i32* %B1.i, align 4, !dbg !5780
  call void @printDDep(i32 1067, i32 1755), !dbg !5780
  call void @printDDep(i32 1377, i32 1755), !dbg !5780
  call void @printDDep(i32 1757, i32 1755), !dbg !5780
  call void @printDDep(i32 2061, i32 1755), !dbg !5780
  call void @printDDep(i32 2365, i32 1755), !dbg !5780
  call void @printDDep(i32 2669, i32 1755), !dbg !5780
  call void @printDDep(i32 2973, i32 1755), !dbg !5780
  call void @printDDep(i32 3277, i32 1755), !dbg !5780
  call void @printDDep(i32 3657, i32 1755), !dbg !5780
  call void @printDDep(i32 1377, i32 1755), !dbg !5780
  call void @printDDep(i32 1755, i32 1755), !dbg !5780
  %xor44.i = xor i32 %2457, %xor15.i1443.i, !dbg !5780
  %2458 = load i32, i32* @Inst_Counter, !dbg !5780
  %2459 = add i32 2, %2458, !dbg !5780
  store i32 %2459, i32* @Inst_Counter, !dbg !5780
  %2460 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2460), !dbg !5780
  %2461 = ptrtoint i32* %B1.i to i64, !dbg !5780
  call void @printStoreAddr(i64 %2461, i32 1757, i32 201, i32 5), !dbg !5780
  store i32 %xor44.i, i32* %B1.i, align 4, !dbg !5780
  call void @printDDep(i32 1067, i32 1757), !dbg !5780
  call void @printDDep(i32 1377, i32 1757), !dbg !5780
  call void @printDDep(i32 1698, i32 1757), !dbg !5780
  call void @printDDep(i32 1707, i32 1757), !dbg !5780
  call void @printDDep(i32 1708, i32 1757), !dbg !5780
  call void @printDDep(i32 1711, i32 1757), !dbg !5780
  call void @printDDep(i32 1712, i32 1757), !dbg !5780
  call void @printDDep(i32 1726, i32 1757), !dbg !5780
  call void @printDDep(i32 1727, i32 1757), !dbg !5780
  call void @printDDep(i32 1730, i32 1757), !dbg !5780
  call void @printDDep(i32 1731, i32 1757), !dbg !5780
  call void @printDDep(i32 1744, i32 1757), !dbg !5780
  call void @printDDep(i32 1745, i32 1757), !dbg !5780
  call void @printDDep(i32 1748, i32 1757), !dbg !5780
  call void @printDDep(i32 1749, i32 1757), !dbg !5780
  call void @printDDep(i32 1755, i32 1757), !dbg !5780
  call void @printDDep(i32 1757, i32 1757), !dbg !5780
  call void @printDDep(i32 2061, i32 1757), !dbg !5780
  call void @printDDep(i32 2365, i32 1757), !dbg !5780
  call void @printDDep(i32 2669, i32 1757), !dbg !5780
  call void @printDDep(i32 2973, i32 1757), !dbg !5780
  call void @printDDep(i32 3277, i32 1757), !dbg !5780
  call void @printDDep(i32 3657, i32 1757), !dbg !5780
  call void @printDDep(i32 1743, i32 1757), !dbg !5780
  call void @printDDep(i32 1757, i32 1757), !dbg !5780
  %2462 = load i32, i32* @Inst_Counter, !dbg !5780
  %2463 = add i32 1, %2462, !dbg !5780
  store i32 %2463, i32* @Inst_Counter, !dbg !5780
  %2464 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2464), !dbg !5780
  %2465 = ptrtoint i32* %B0.i to i64, !dbg !5780
  call void @printLoadAddr(i64 %2465, i32 1758, i32 201, i32 5), !dbg !5780
  %2466 = load i32, i32* %B0.i, align 4, !dbg !5780
  call void @printDDep(i32 1026, i32 1758), !dbg !5780
  call void @printDDep(i32 1263, i32 1758), !dbg !5780
  call void @printDDep(i32 1681, i32 1758), !dbg !5780
  call void @printDDep(i32 1985, i32 1758), !dbg !5780
  call void @printDDep(i32 2289, i32 1758), !dbg !5780
  call void @printDDep(i32 2593, i32 1758), !dbg !5780
  call void @printDDep(i32 2897, i32 1758), !dbg !5780
  call void @printDDep(i32 3201, i32 1758), !dbg !5780
  call void @printDDep(i32 3543, i32 1758), !dbg !5780
  call void @printDDep(i32 1681, i32 1758), !dbg !5780
  call void @printDDep(i32 1758, i32 1758), !dbg !5780
  %2467 = load i32, i32* @Inst_Counter, !dbg !5780
  %2468 = add i32 1, %2467, !dbg !5780
  store i32 %2468, i32* @Inst_Counter, !dbg !5780
  %2469 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2469), !dbg !5780
  %2470 = ptrtoint i32* %B1.i to i64, !dbg !5780
  call void @printLoadAddr(i64 %2470, i32 1759, i32 201, i32 5), !dbg !5780
  %2471 = load i32, i32* %B1.i, align 4, !dbg !5780
  call void @printDDep(i32 1067, i32 1759), !dbg !5780
  call void @printDDep(i32 1377, i32 1759), !dbg !5780
  call void @printDDep(i32 1757, i32 1759), !dbg !5780
  call void @printDDep(i32 2061, i32 1759), !dbg !5780
  call void @printDDep(i32 2365, i32 1759), !dbg !5780
  call void @printDDep(i32 2669, i32 1759), !dbg !5780
  call void @printDDep(i32 2973, i32 1759), !dbg !5780
  call void @printDDep(i32 3277, i32 1759), !dbg !5780
  call void @printDDep(i32 3657, i32 1759), !dbg !5780
  call void @printDDep(i32 1757, i32 1759), !dbg !5780
  call void @printDDep(i32 1759, i32 1759), !dbg !5780
  %xor45.i = xor i32 %2466, %2471, !dbg !5780
  %2472 = load i32, i32* @Inst_Counter, !dbg !5780
  %2473 = add i32 2, %2472, !dbg !5780
  store i32 %2473, i32* @Inst_Counter, !dbg !5780
  %2474 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2474), !dbg !5780
  %2475 = ptrtoint i32* %B3.i to i64, !dbg !5780
  call void @printLoadAddr(i64 %2475, i32 1761, i32 201, i32 5), !dbg !5780
  %2476 = load i32, i32* %B3.i, align 4, !dbg !5780
  call void @printDDep(i32 1149, i32 1761), !dbg !5780
  call void @printDDep(i32 1605, i32 1761), !dbg !5780
  call void @printDDep(i32 1909, i32 1761), !dbg !5780
  call void @printDDep(i32 2213, i32 1761), !dbg !5780
  call void @printDDep(i32 2517, i32 1761), !dbg !5780
  call void @printDDep(i32 2821, i32 1761), !dbg !5780
  call void @printDDep(i32 3125, i32 1761), !dbg !5780
  call void @printDDep(i32 3429, i32 1761), !dbg !5780
  call void @printDDep(i32 3885, i32 1761), !dbg !5780
  call void @printDDep(i32 1605, i32 1761), !dbg !5780
  call void @printDDep(i32 1761, i32 1761), !dbg !5780
  %xor46.i = xor i32 %xor45.i, %2476, !dbg !5780
  %2477 = load i32, i32* @Inst_Counter, !dbg !5780
  %2478 = add i32 2, %2477, !dbg !5780
  store i32 %2478, i32* @Inst_Counter, !dbg !5780
  %2479 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2479), !dbg !5780
  %2480 = ptrtoint %struct.SM4_KEY_st** %ks.addr.i24 to i64, !dbg !5780
  call void @printLoadAddr(i64 %2480, i32 1763, i32 201, i32 5), !dbg !5780
  %2481 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr.i24, align 8, !dbg !5780
  call void @printDDep(i32 983, i32 1763), !dbg !5780
  call void @printDDep(i32 985, i32 1763), !dbg !5780
  call void @printDDep(i32 1763, i32 1763), !dbg !5780
  %rk47.i = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %2481, i32 0, i32 0, !dbg !5780
  %arrayidx48.i = getelementptr inbounds [32 x i32], [32 x i32]* %rk47.i, i64 0, i64 6, !dbg !5780
  %2482 = load i32, i32* @Inst_Counter, !dbg !5780
  %2483 = add i32 3, %2482, !dbg !5780
  store i32 %2483, i32* @Inst_Counter, !dbg !5780
  %2484 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2484), !dbg !5780
  %2485 = ptrtoint i32* %arrayidx48.i to i64, !dbg !5780
  call void @printLoadAddr(i64 %2485, i32 1766, i32 201, i32 5), !dbg !5780
  %2486 = load i32, i32* %arrayidx48.i, align 4, !dbg !5780
  call void @printDDep(i32 1763, i32 1766), !dbg !5780
  call void @printDDep(i32 1757, i32 1766), !dbg !5780
  call void @printDDep(i32 1766, i32 1766), !dbg !5780
  %xor49.i59 = xor i32 %xor46.i, %2486, !dbg !5780
  %2487 = load i32, i32* @Inst_Counter
  %2488 = add i32 2, %2487
  store i32 %2488, i32* @Inst_Counter
  %2489 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2489)
  %2490 = ptrtoint i32* %X.addr.i1364.i to i64
  call void @printStoreAddr(i64 %2490, i32 1768, i32 0, i32 0)
  store i32 %xor49.i59, i32* %X.addr.i1364.i, align 4
  call void @printDDep(i32 1758, i32 1768)
  call void @printDDep(i32 1759, i32 1768)
  call void @printDDep(i32 1761, i32 1768)
  call void @printDDep(i32 1766, i32 1768)
  call void @printDDep(i32 1768, i32 1768)
  call void @printDDep(i32 1757, i32 1768)
  call void @printDDep(i32 1768, i32 1768)
  %2491 = load i32, i32* @Inst_Counter, !dbg !5865
  %2492 = add i32 1, %2491, !dbg !5865
  store i32 %2492, i32* @Inst_Counter, !dbg !5865
  %2493 = load i32, i32* @Inst_Counter, !dbg !5865
  call void @printCounter(i32 %2493), !dbg !5865
  %2494 = ptrtoint i32* %X.addr.i1364.i to i64, !dbg !5865
  call void @printLoadAddr(i64 %2494, i32 1769, i32 128, i32 33), !dbg !5865
  %2495 = load i32, i32* %X.addr.i1364.i, align 4, !dbg !5865
  call void @printDDep(i32 1768, i32 1769), !dbg !5865
  call void @printDDep(i32 1768, i32 1769), !dbg !5865
  call void @printDDep(i32 1769, i32 1769), !dbg !5865
  %shr.i1365.i = lshr i32 %2495, 24, !dbg !5866
  %conv.i1366.i = trunc i32 %shr.i1365.i to i8, !dbg !5867
  %idxprom.i1367.i = zext i8 %conv.i1366.i to i64, !dbg !5868
  %arrayidx.i1368.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1367.i, !dbg !5868
  %2496 = load i32, i32* @Inst_Counter, !dbg !5868
  %2497 = add i32 5, %2496, !dbg !5868
  store i32 %2497, i32* @Inst_Counter, !dbg !5868
  %2498 = load i32, i32* @Inst_Counter, !dbg !5868
  call void @printCounter(i32 %2498), !dbg !5868
  %2499 = ptrtoint i32* %arrayidx.i1368.i to i64, !dbg !5868
  %2500 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5868
  call void @printSymLoadAddr(i64 %2499, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 1774, i32 128, i32 12), !dbg !5868
  %2501 = load i32, i32* %arrayidx.i1368.i, align 4, !dbg !5868
  call void @printDDep(i32 1769, i32 1774), !dbg !5868
  call void @printDDep(i32 1774, i32 1774), !dbg !5868
  %2502 = load i32, i32* @Inst_Counter, !dbg !5869
  %2503 = add i32 1, %2502, !dbg !5869
  store i32 %2503, i32* @Inst_Counter, !dbg !5869
  %2504 = load i32, i32* @Inst_Counter, !dbg !5869
  call void @printCounter(i32 %2504), !dbg !5869
  %2505 = ptrtoint i32* %X.addr.i1364.i to i64, !dbg !5869
  call void @printLoadAddr(i64 %2505, i32 1775, i32 129, i32 38), !dbg !5869
  %2506 = load i32, i32* %X.addr.i1364.i, align 4, !dbg !5869
  call void @printDDep(i32 1768, i32 1775), !dbg !5869
  call void @printDDep(i32 1768, i32 1775), !dbg !5869
  call void @printDDep(i32 1775, i32 1775), !dbg !5869
  %shr1.i1369.i = lshr i32 %2506, 16, !dbg !5870
  %conv2.i1370.i = trunc i32 %shr1.i1369.i to i8, !dbg !5871
  %idxprom3.i1371.i = zext i8 %conv2.i1370.i to i64, !dbg !5872
  %arrayidx4.i1372.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1371.i, !dbg !5872
  %2507 = load i32, i32* @Inst_Counter, !dbg !5872
  %2508 = add i32 5, %2507, !dbg !5872
  store i32 %2508, i32* @Inst_Counter, !dbg !5872
  %2509 = load i32, i32* @Inst_Counter, !dbg !5872
  call void @printCounter(i32 %2509), !dbg !5872
  %2510 = ptrtoint i32* %arrayidx4.i1372.i to i64, !dbg !5872
  %2511 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5872
  call void @printSymLoadAddr(i64 %2510, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 1780, i32 129, i32 17), !dbg !5872
  %2512 = load i32, i32* %arrayidx4.i1372.i, align 4, !dbg !5872
  call void @printDDep(i32 1775, i32 1780), !dbg !5872
  call void @printDDep(i32 1780, i32 1780), !dbg !5872
  %2513 = load i32, i32* @Inst_Counter
  %2514 = add i32 1, %2513
  store i32 %2514, i32* @Inst_Counter
  %2515 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2515)
  %2516 = ptrtoint i32* %a.addr.i.i1362.i to i64
  call void @printStoreAddr(i64 %2516, i32 1781, i32 0, i32 0)
  store i32 %2512, i32* %a.addr.i.i1362.i, align 4
  call void @printDDep(i32 1780, i32 1781)
  call void @printDDep(i32 1781, i32 1781)
  call void @printDDep(i32 1768, i32 1781)
  call void @printDDep(i32 1781, i32 1781)
  %2517 = load i32, i32* @Inst_Counter
  %2518 = add i32 1, %2517
  store i32 %2518, i32* @Inst_Counter
  %2519 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2519)
  %2520 = ptrtoint i8* %n.addr.i.i1363.i to i64
  call void @printStoreAddr(i64 %2520, i32 1782, i32 0, i32 0)
  store i8 24, i8* %n.addr.i.i1363.i, align 1
  call void @printDDep(i32 1782, i32 1782)
  call void @printDDep(i32 1781, i32 1782)
  call void @printDDep(i32 1782, i32 1782)
  %2521 = load i32, i32* @Inst_Counter, !dbg !5873
  %2522 = add i32 1, %2521, !dbg !5873
  store i32 %2522, i32* @Inst_Counter, !dbg !5873
  %2523 = load i32, i32* @Inst_Counter, !dbg !5873
  call void @printCounter(i32 %2523), !dbg !5873
  %2524 = ptrtoint i32* %a.addr.i.i1362.i to i64, !dbg !5873
  call void @printLoadAddr(i64 %2524, i32 1783, i32 92, i32 13), !dbg !5873
  %2525 = load i32, i32* %a.addr.i.i1362.i, align 4, !dbg !5873
  call void @printDDep(i32 1781, i32 1783), !dbg !5873
  call void @printDDep(i32 1782, i32 1783), !dbg !5873
  call void @printDDep(i32 1783, i32 1783), !dbg !5873
  %2526 = load i32, i32* @Inst_Counter, !dbg !5874
  %2527 = add i32 1, %2526, !dbg !5874
  store i32 %2527, i32* @Inst_Counter, !dbg !5874
  %2528 = load i32, i32* @Inst_Counter, !dbg !5874
  call void @printCounter(i32 %2528), !dbg !5874
  %2529 = ptrtoint i8* %n.addr.i.i1363.i to i64, !dbg !5874
  call void @printLoadAddr(i64 %2529, i32 1784, i32 92, i32 18), !dbg !5874
  %2530 = load i8, i8* %n.addr.i.i1363.i, align 1, !dbg !5874
  call void @printDDep(i32 1782, i32 1784), !dbg !5874
  call void @printDDep(i32 1782, i32 1784), !dbg !5874
  call void @printDDep(i32 1784, i32 1784), !dbg !5874
  %conv.i.i1373.i = zext i8 %2530 to i32, !dbg !5874
  %shl.i.i1374.i = shl i32 %2525, %conv.i.i1373.i, !dbg !5875
  %2531 = load i32, i32* @Inst_Counter, !dbg !5876
  %2532 = add i32 3, %2531, !dbg !5876
  store i32 %2532, i32* @Inst_Counter, !dbg !5876
  %2533 = load i32, i32* @Inst_Counter, !dbg !5876
  call void @printCounter(i32 %2533), !dbg !5876
  %2534 = ptrtoint i32* %a.addr.i.i1362.i to i64, !dbg !5876
  call void @printLoadAddr(i64 %2534, i32 1787, i32 92, i32 24), !dbg !5876
  %2535 = load i32, i32* %a.addr.i.i1362.i, align 4, !dbg !5876
  call void @printDDep(i32 1781, i32 1787), !dbg !5876
  call void @printDDep(i32 1782, i32 1787), !dbg !5876
  call void @printDDep(i32 1787, i32 1787), !dbg !5876
  %2536 = load i32, i32* @Inst_Counter, !dbg !5877
  %2537 = add i32 1, %2536, !dbg !5877
  store i32 %2537, i32* @Inst_Counter, !dbg !5877
  %2538 = load i32, i32* @Inst_Counter, !dbg !5877
  call void @printCounter(i32 %2538), !dbg !5877
  %2539 = ptrtoint i8* %n.addr.i.i1363.i to i64, !dbg !5877
  call void @printLoadAddr(i64 %2539, i32 1788, i32 92, i32 35), !dbg !5877
  %2540 = load i8, i8* %n.addr.i.i1363.i, align 1, !dbg !5877
  call void @printDDep(i32 1782, i32 1788), !dbg !5877
  call void @printDDep(i32 1782, i32 1788), !dbg !5877
  call void @printDDep(i32 1788, i32 1788), !dbg !5877
  %conv1.i.i1375.i = zext i8 %2540 to i32, !dbg !5877
  %sub.i.i1376.i = sub nsw i32 32, %conv1.i.i1375.i, !dbg !5878
  %shr.i.i1377.i = lshr i32 %2535, %sub.i.i1376.i, !dbg !5879
  %or.i.i1378.i = or i32 %shl.i.i1374.i, %shr.i.i1377.i, !dbg !5880
  %xor.i1379.i = xor i32 %2501, %or.i.i1378.i, !dbg !5881
  %2541 = load i32, i32* @Inst_Counter, !dbg !5882
  %2542 = add i32 6, %2541, !dbg !5882
  store i32 %2542, i32* @Inst_Counter, !dbg !5882
  %2543 = load i32, i32* @Inst_Counter, !dbg !5882
  call void @printCounter(i32 %2543), !dbg !5882
  %2544 = ptrtoint i32* %X.addr.i1364.i to i64, !dbg !5882
  call void @printLoadAddr(i64 %2544, i32 1794, i32 130, i32 38), !dbg !5882
  %2545 = load i32, i32* %X.addr.i1364.i, align 4, !dbg !5882
  call void @printDDep(i32 1768, i32 1794), !dbg !5882
  call void @printDDep(i32 1782, i32 1794), !dbg !5882
  call void @printDDep(i32 1794, i32 1794), !dbg !5882
  %shr5.i1380.i = lshr i32 %2545, 8, !dbg !5883
  %conv6.i1381.i = trunc i32 %shr5.i1380.i to i8, !dbg !5884
  %idxprom7.i1382.i = zext i8 %conv6.i1381.i to i64, !dbg !5885
  %arrayidx8.i1383.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1382.i, !dbg !5885
  %2546 = load i32, i32* @Inst_Counter, !dbg !5885
  %2547 = add i32 5, %2546, !dbg !5885
  store i32 %2547, i32* @Inst_Counter, !dbg !5885
  %2548 = load i32, i32* @Inst_Counter, !dbg !5885
  call void @printCounter(i32 %2548), !dbg !5885
  %2549 = ptrtoint i32* %arrayidx8.i1383.i to i64, !dbg !5885
  %2550 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5885
  call void @printSymLoadAddr(i64 %2549, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 1799, i32 130, i32 17), !dbg !5885
  %2551 = load i32, i32* %arrayidx8.i1383.i, align 4, !dbg !5885
  call void @printDDep(i32 1794, i32 1799), !dbg !5885
  call void @printDDep(i32 1799, i32 1799), !dbg !5885
  %2552 = load i32, i32* @Inst_Counter
  %2553 = add i32 1, %2552
  store i32 %2553, i32* @Inst_Counter
  %2554 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2554)
  %2555 = ptrtoint i32* %a.addr.i24.i1358.i to i64
  call void @printStoreAddr(i64 %2555, i32 1800, i32 0, i32 0)
  store i32 %2551, i32* %a.addr.i24.i1358.i, align 4
  call void @printDDep(i32 1799, i32 1800)
  call void @printDDep(i32 1800, i32 1800)
  call void @printDDep(i32 1782, i32 1800)
  call void @printDDep(i32 1800, i32 1800)
  %2556 = load i32, i32* @Inst_Counter
  %2557 = add i32 1, %2556
  store i32 %2557, i32* @Inst_Counter
  %2558 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2558)
  %2559 = ptrtoint i8* %n.addr.i25.i1359.i to i64
  call void @printStoreAddr(i64 %2559, i32 1801, i32 0, i32 0)
  store i8 16, i8* %n.addr.i25.i1359.i, align 1
  call void @printDDep(i32 1801, i32 1801)
  call void @printDDep(i32 1800, i32 1801)
  call void @printDDep(i32 1801, i32 1801)
  %2560 = load i32, i32* @Inst_Counter, !dbg !5886
  %2561 = add i32 1, %2560, !dbg !5886
  store i32 %2561, i32* @Inst_Counter, !dbg !5886
  %2562 = load i32, i32* @Inst_Counter, !dbg !5886
  call void @printCounter(i32 %2562), !dbg !5886
  %2563 = ptrtoint i32* %a.addr.i24.i1358.i to i64, !dbg !5886
  call void @printLoadAddr(i64 %2563, i32 1802, i32 92, i32 13), !dbg !5886
  %2564 = load i32, i32* %a.addr.i24.i1358.i, align 4, !dbg !5886
  call void @printDDep(i32 1800, i32 1802), !dbg !5886
  call void @printDDep(i32 1801, i32 1802), !dbg !5886
  call void @printDDep(i32 1802, i32 1802), !dbg !5886
  %2565 = load i32, i32* @Inst_Counter, !dbg !5887
  %2566 = add i32 1, %2565, !dbg !5887
  store i32 %2566, i32* @Inst_Counter, !dbg !5887
  %2567 = load i32, i32* @Inst_Counter, !dbg !5887
  call void @printCounter(i32 %2567), !dbg !5887
  %2568 = ptrtoint i8* %n.addr.i25.i1359.i to i64, !dbg !5887
  call void @printLoadAddr(i64 %2568, i32 1803, i32 92, i32 18), !dbg !5887
  %2569 = load i8, i8* %n.addr.i25.i1359.i, align 1, !dbg !5887
  call void @printDDep(i32 1801, i32 1803), !dbg !5887
  call void @printDDep(i32 1801, i32 1803), !dbg !5887
  call void @printDDep(i32 1803, i32 1803), !dbg !5887
  %conv.i26.i1384.i = zext i8 %2569 to i32, !dbg !5887
  %shl.i27.i1385.i = shl i32 %2564, %conv.i26.i1384.i, !dbg !5888
  %2570 = load i32, i32* @Inst_Counter, !dbg !5889
  %2571 = add i32 3, %2570, !dbg !5889
  store i32 %2571, i32* @Inst_Counter, !dbg !5889
  %2572 = load i32, i32* @Inst_Counter, !dbg !5889
  call void @printCounter(i32 %2572), !dbg !5889
  %2573 = ptrtoint i32* %a.addr.i24.i1358.i to i64, !dbg !5889
  call void @printLoadAddr(i64 %2573, i32 1806, i32 92, i32 24), !dbg !5889
  %2574 = load i32, i32* %a.addr.i24.i1358.i, align 4, !dbg !5889
  call void @printDDep(i32 1800, i32 1806), !dbg !5889
  call void @printDDep(i32 1801, i32 1806), !dbg !5889
  call void @printDDep(i32 1806, i32 1806), !dbg !5889
  %2575 = load i32, i32* @Inst_Counter, !dbg !5890
  %2576 = add i32 1, %2575, !dbg !5890
  store i32 %2576, i32* @Inst_Counter, !dbg !5890
  %2577 = load i32, i32* @Inst_Counter, !dbg !5890
  call void @printCounter(i32 %2577), !dbg !5890
  %2578 = ptrtoint i8* %n.addr.i25.i1359.i to i64, !dbg !5890
  call void @printLoadAddr(i64 %2578, i32 1807, i32 92, i32 35), !dbg !5890
  %2579 = load i8, i8* %n.addr.i25.i1359.i, align 1, !dbg !5890
  call void @printDDep(i32 1801, i32 1807), !dbg !5890
  call void @printDDep(i32 1801, i32 1807), !dbg !5890
  call void @printDDep(i32 1807, i32 1807), !dbg !5890
  %conv1.i28.i1386.i = zext i8 %2579 to i32, !dbg !5890
  %sub.i29.i1387.i = sub nsw i32 32, %conv1.i28.i1386.i, !dbg !5891
  %shr.i30.i1388.i = lshr i32 %2574, %sub.i29.i1387.i, !dbg !5892
  %or.i31.i1389.i = or i32 %shl.i27.i1385.i, %shr.i30.i1388.i, !dbg !5893
  %xor10.i1390.i = xor i32 %xor.i1379.i, %or.i31.i1389.i, !dbg !5894
  %2580 = load i32, i32* @Inst_Counter, !dbg !5895
  %2581 = add i32 6, %2580, !dbg !5895
  store i32 %2581, i32* @Inst_Counter, !dbg !5895
  %2582 = load i32, i32* @Inst_Counter, !dbg !5895
  call void @printCounter(i32 %2582), !dbg !5895
  %2583 = ptrtoint i32* %X.addr.i1364.i to i64, !dbg !5895
  call void @printLoadAddr(i64 %2583, i32 1813, i32 131, i32 37), !dbg !5895
  %2584 = load i32, i32* %X.addr.i1364.i, align 4, !dbg !5895
  call void @printDDep(i32 1768, i32 1813), !dbg !5895
  call void @printDDep(i32 1801, i32 1813), !dbg !5895
  call void @printDDep(i32 1813, i32 1813), !dbg !5895
  %conv11.i1391.i = trunc i32 %2584 to i8, !dbg !5896
  %idxprom12.i1392.i = zext i8 %conv11.i1391.i to i64, !dbg !5897
  %arrayidx13.i1393.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1392.i, !dbg !5897
  %2585 = load i32, i32* @Inst_Counter, !dbg !5897
  %2586 = add i32 4, %2585, !dbg !5897
  store i32 %2586, i32* @Inst_Counter, !dbg !5897
  %2587 = load i32, i32* @Inst_Counter, !dbg !5897
  call void @printCounter(i32 %2587), !dbg !5897
  %2588 = ptrtoint i32* %arrayidx13.i1393.i to i64, !dbg !5897
  %2589 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5897
  call void @printSymLoadAddr(i64 %2588, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 1817, i32 131, i32 17), !dbg !5897
  %2590 = load i32, i32* %arrayidx13.i1393.i, align 4, !dbg !5897
  call void @printDDep(i32 1813, i32 1817), !dbg !5897
  call void @printDDep(i32 1817, i32 1817), !dbg !5897
  %2591 = load i32, i32* @Inst_Counter
  %2592 = add i32 1, %2591
  store i32 %2592, i32* @Inst_Counter
  %2593 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2593)
  %2594 = ptrtoint i32* %a.addr.i16.i1360.i to i64
  call void @printStoreAddr(i64 %2594, i32 1818, i32 0, i32 0)
  store i32 %2590, i32* %a.addr.i16.i1360.i, align 4
  call void @printDDep(i32 1817, i32 1818)
  call void @printDDep(i32 1818, i32 1818)
  call void @printDDep(i32 1801, i32 1818)
  call void @printDDep(i32 1818, i32 1818)
  %2595 = load i32, i32* @Inst_Counter
  %2596 = add i32 1, %2595
  store i32 %2596, i32* @Inst_Counter
  %2597 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2597)
  %2598 = ptrtoint i8* %n.addr.i17.i1361.i to i64
  call void @printStoreAddr(i64 %2598, i32 1819, i32 0, i32 0)
  store i8 8, i8* %n.addr.i17.i1361.i, align 1
  call void @printDDep(i32 1819, i32 1819)
  call void @printDDep(i32 1818, i32 1819)
  call void @printDDep(i32 1819, i32 1819)
  %2599 = load i32, i32* @Inst_Counter, !dbg !5898
  %2600 = add i32 1, %2599, !dbg !5898
  store i32 %2600, i32* @Inst_Counter, !dbg !5898
  %2601 = load i32, i32* @Inst_Counter, !dbg !5898
  call void @printCounter(i32 %2601), !dbg !5898
  %2602 = ptrtoint i32* %a.addr.i16.i1360.i to i64, !dbg !5898
  call void @printLoadAddr(i64 %2602, i32 1820, i32 92, i32 13), !dbg !5898
  %2603 = load i32, i32* %a.addr.i16.i1360.i, align 4, !dbg !5898
  call void @printDDep(i32 1818, i32 1820), !dbg !5898
  call void @printDDep(i32 1819, i32 1820), !dbg !5898
  call void @printDDep(i32 1820, i32 1820), !dbg !5898
  %2604 = load i32, i32* @Inst_Counter, !dbg !5899
  %2605 = add i32 1, %2604, !dbg !5899
  store i32 %2605, i32* @Inst_Counter, !dbg !5899
  %2606 = load i32, i32* @Inst_Counter, !dbg !5899
  call void @printCounter(i32 %2606), !dbg !5899
  %2607 = ptrtoint i8* %n.addr.i17.i1361.i to i64, !dbg !5899
  call void @printLoadAddr(i64 %2607, i32 1821, i32 92, i32 18), !dbg !5899
  %2608 = load i8, i8* %n.addr.i17.i1361.i, align 1, !dbg !5899
  call void @printDDep(i32 1819, i32 1821), !dbg !5899
  call void @printDDep(i32 1819, i32 1821), !dbg !5899
  call void @printDDep(i32 1821, i32 1821), !dbg !5899
  %conv.i18.i1394.i = zext i8 %2608 to i32, !dbg !5899
  %shl.i19.i1395.i = shl i32 %2603, %conv.i18.i1394.i, !dbg !5900
  %2609 = load i32, i32* @Inst_Counter, !dbg !5901
  %2610 = add i32 3, %2609, !dbg !5901
  store i32 %2610, i32* @Inst_Counter, !dbg !5901
  %2611 = load i32, i32* @Inst_Counter, !dbg !5901
  call void @printCounter(i32 %2611), !dbg !5901
  %2612 = ptrtoint i32* %a.addr.i16.i1360.i to i64, !dbg !5901
  call void @printLoadAddr(i64 %2612, i32 1824, i32 92, i32 24), !dbg !5901
  %2613 = load i32, i32* %a.addr.i16.i1360.i, align 4, !dbg !5901
  call void @printDDep(i32 1818, i32 1824), !dbg !5901
  call void @printDDep(i32 1819, i32 1824), !dbg !5901
  call void @printDDep(i32 1824, i32 1824), !dbg !5901
  %2614 = load i32, i32* @Inst_Counter, !dbg !5902
  %2615 = add i32 1, %2614, !dbg !5902
  store i32 %2615, i32* @Inst_Counter, !dbg !5902
  %2616 = load i32, i32* @Inst_Counter, !dbg !5902
  call void @printCounter(i32 %2616), !dbg !5902
  %2617 = ptrtoint i8* %n.addr.i17.i1361.i to i64, !dbg !5902
  call void @printLoadAddr(i64 %2617, i32 1825, i32 92, i32 35), !dbg !5902
  %2618 = load i8, i8* %n.addr.i17.i1361.i, align 1, !dbg !5902
  call void @printDDep(i32 1819, i32 1825), !dbg !5902
  call void @printDDep(i32 1819, i32 1825), !dbg !5902
  call void @printDDep(i32 1825, i32 1825), !dbg !5902
  %conv1.i20.i1396.i = zext i8 %2618 to i32, !dbg !5902
  %sub.i21.i1397.i = sub nsw i32 32, %conv1.i20.i1396.i, !dbg !5903
  %shr.i22.i1398.i = lshr i32 %2613, %sub.i21.i1397.i, !dbg !5904
  %or.i23.i1399.i = or i32 %shl.i19.i1395.i, %shr.i22.i1398.i, !dbg !5905
  %xor15.i1400.i = xor i32 %xor10.i1390.i, %or.i23.i1399.i, !dbg !5906
  %2619 = load i32, i32* @Inst_Counter, !dbg !5780
  %2620 = add i32 6, %2619, !dbg !5780
  store i32 %2620, i32* @Inst_Counter, !dbg !5780
  %2621 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2621), !dbg !5780
  %2622 = ptrtoint i32* %B2.i to i64, !dbg !5780
  call void @printLoadAddr(i64 %2622, i32 1831, i32 201, i32 5), !dbg !5780
  %2623 = load i32, i32* %B2.i, align 4, !dbg !5780
  call void @printDDep(i32 1108, i32 1831), !dbg !5780
  call void @printDDep(i32 1491, i32 1831), !dbg !5780
  call void @printDDep(i32 1833, i32 1831), !dbg !5780
  call void @printDDep(i32 2137, i32 1831), !dbg !5780
  call void @printDDep(i32 2441, i32 1831), !dbg !5780
  call void @printDDep(i32 2745, i32 1831), !dbg !5780
  call void @printDDep(i32 3049, i32 1831), !dbg !5780
  call void @printDDep(i32 3353, i32 1831), !dbg !5780
  call void @printDDep(i32 3771, i32 1831), !dbg !5780
  call void @printDDep(i32 1491, i32 1831), !dbg !5780
  call void @printDDep(i32 1831, i32 1831), !dbg !5780
  %xor51.i = xor i32 %2623, %xor15.i1400.i, !dbg !5780
  %2624 = load i32, i32* @Inst_Counter, !dbg !5780
  %2625 = add i32 2, %2624, !dbg !5780
  store i32 %2625, i32* @Inst_Counter, !dbg !5780
  %2626 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2626), !dbg !5780
  %2627 = ptrtoint i32* %B2.i to i64, !dbg !5780
  call void @printStoreAddr(i64 %2627, i32 1833, i32 201, i32 5), !dbg !5780
  store i32 %xor51.i, i32* %B2.i, align 4, !dbg !5780
  call void @printDDep(i32 1108, i32 1833), !dbg !5780
  call void @printDDep(i32 1491, i32 1833), !dbg !5780
  call void @printDDep(i32 1774, i32 1833), !dbg !5780
  call void @printDDep(i32 1783, i32 1833), !dbg !5780
  call void @printDDep(i32 1784, i32 1833), !dbg !5780
  call void @printDDep(i32 1787, i32 1833), !dbg !5780
  call void @printDDep(i32 1788, i32 1833), !dbg !5780
  call void @printDDep(i32 1802, i32 1833), !dbg !5780
  call void @printDDep(i32 1803, i32 1833), !dbg !5780
  call void @printDDep(i32 1806, i32 1833), !dbg !5780
  call void @printDDep(i32 1807, i32 1833), !dbg !5780
  call void @printDDep(i32 1820, i32 1833), !dbg !5780
  call void @printDDep(i32 1821, i32 1833), !dbg !5780
  call void @printDDep(i32 1824, i32 1833), !dbg !5780
  call void @printDDep(i32 1825, i32 1833), !dbg !5780
  call void @printDDep(i32 1831, i32 1833), !dbg !5780
  call void @printDDep(i32 1833, i32 1833), !dbg !5780
  call void @printDDep(i32 2137, i32 1833), !dbg !5780
  call void @printDDep(i32 2441, i32 1833), !dbg !5780
  call void @printDDep(i32 2745, i32 1833), !dbg !5780
  call void @printDDep(i32 3049, i32 1833), !dbg !5780
  call void @printDDep(i32 3353, i32 1833), !dbg !5780
  call void @printDDep(i32 3771, i32 1833), !dbg !5780
  call void @printDDep(i32 1819, i32 1833), !dbg !5780
  call void @printDDep(i32 1833, i32 1833), !dbg !5780
  %2628 = load i32, i32* @Inst_Counter, !dbg !5780
  %2629 = add i32 1, %2628, !dbg !5780
  store i32 %2629, i32* @Inst_Counter, !dbg !5780
  %2630 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2630), !dbg !5780
  %2631 = ptrtoint i32* %B0.i to i64, !dbg !5780
  call void @printLoadAddr(i64 %2631, i32 1834, i32 201, i32 5), !dbg !5780
  %2632 = load i32, i32* %B0.i, align 4, !dbg !5780
  call void @printDDep(i32 1026, i32 1834), !dbg !5780
  call void @printDDep(i32 1263, i32 1834), !dbg !5780
  call void @printDDep(i32 1681, i32 1834), !dbg !5780
  call void @printDDep(i32 1985, i32 1834), !dbg !5780
  call void @printDDep(i32 2289, i32 1834), !dbg !5780
  call void @printDDep(i32 2593, i32 1834), !dbg !5780
  call void @printDDep(i32 2897, i32 1834), !dbg !5780
  call void @printDDep(i32 3201, i32 1834), !dbg !5780
  call void @printDDep(i32 3543, i32 1834), !dbg !5780
  call void @printDDep(i32 1681, i32 1834), !dbg !5780
  call void @printDDep(i32 1834, i32 1834), !dbg !5780
  %2633 = load i32, i32* @Inst_Counter, !dbg !5780
  %2634 = add i32 1, %2633, !dbg !5780
  store i32 %2634, i32* @Inst_Counter, !dbg !5780
  %2635 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2635), !dbg !5780
  %2636 = ptrtoint i32* %B1.i to i64, !dbg !5780
  call void @printLoadAddr(i64 %2636, i32 1835, i32 201, i32 5), !dbg !5780
  %2637 = load i32, i32* %B1.i, align 4, !dbg !5780
  call void @printDDep(i32 1067, i32 1835), !dbg !5780
  call void @printDDep(i32 1377, i32 1835), !dbg !5780
  call void @printDDep(i32 1757, i32 1835), !dbg !5780
  call void @printDDep(i32 2061, i32 1835), !dbg !5780
  call void @printDDep(i32 2365, i32 1835), !dbg !5780
  call void @printDDep(i32 2669, i32 1835), !dbg !5780
  call void @printDDep(i32 2973, i32 1835), !dbg !5780
  call void @printDDep(i32 3277, i32 1835), !dbg !5780
  call void @printDDep(i32 3657, i32 1835), !dbg !5780
  call void @printDDep(i32 1757, i32 1835), !dbg !5780
  call void @printDDep(i32 1835, i32 1835), !dbg !5780
  %xor52.i = xor i32 %2632, %2637, !dbg !5780
  %2638 = load i32, i32* @Inst_Counter, !dbg !5780
  %2639 = add i32 2, %2638, !dbg !5780
  store i32 %2639, i32* @Inst_Counter, !dbg !5780
  %2640 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2640), !dbg !5780
  %2641 = ptrtoint i32* %B2.i to i64, !dbg !5780
  call void @printLoadAddr(i64 %2641, i32 1837, i32 201, i32 5), !dbg !5780
  %2642 = load i32, i32* %B2.i, align 4, !dbg !5780
  call void @printDDep(i32 1108, i32 1837), !dbg !5780
  call void @printDDep(i32 1491, i32 1837), !dbg !5780
  call void @printDDep(i32 1833, i32 1837), !dbg !5780
  call void @printDDep(i32 2137, i32 1837), !dbg !5780
  call void @printDDep(i32 2441, i32 1837), !dbg !5780
  call void @printDDep(i32 2745, i32 1837), !dbg !5780
  call void @printDDep(i32 3049, i32 1837), !dbg !5780
  call void @printDDep(i32 3353, i32 1837), !dbg !5780
  call void @printDDep(i32 3771, i32 1837), !dbg !5780
  call void @printDDep(i32 1833, i32 1837), !dbg !5780
  call void @printDDep(i32 1837, i32 1837), !dbg !5780
  %xor53.i60 = xor i32 %xor52.i, %2642, !dbg !5780
  %2643 = load i32, i32* @Inst_Counter, !dbg !5780
  %2644 = add i32 2, %2643, !dbg !5780
  store i32 %2644, i32* @Inst_Counter, !dbg !5780
  %2645 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2645), !dbg !5780
  %2646 = ptrtoint %struct.SM4_KEY_st** %ks.addr.i24 to i64, !dbg !5780
  call void @printLoadAddr(i64 %2646, i32 1839, i32 201, i32 5), !dbg !5780
  %2647 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr.i24, align 8, !dbg !5780
  call void @printDDep(i32 983, i32 1839), !dbg !5780
  call void @printDDep(i32 985, i32 1839), !dbg !5780
  call void @printDDep(i32 1839, i32 1839), !dbg !5780
  %rk54.i = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %2647, i32 0, i32 0, !dbg !5780
  %arrayidx55.i = getelementptr inbounds [32 x i32], [32 x i32]* %rk54.i, i64 0, i64 7, !dbg !5780
  %2648 = load i32, i32* @Inst_Counter, !dbg !5780
  %2649 = add i32 3, %2648, !dbg !5780
  store i32 %2649, i32* @Inst_Counter, !dbg !5780
  %2650 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2650), !dbg !5780
  %2651 = ptrtoint i32* %arrayidx55.i to i64, !dbg !5780
  call void @printLoadAddr(i64 %2651, i32 1842, i32 201, i32 5), !dbg !5780
  %2652 = load i32, i32* %arrayidx55.i, align 4, !dbg !5780
  call void @printDDep(i32 1839, i32 1842), !dbg !5780
  call void @printDDep(i32 1833, i32 1842), !dbg !5780
  call void @printDDep(i32 1842, i32 1842), !dbg !5780
  %xor56.i = xor i32 %xor53.i60, %2652, !dbg !5780
  %2653 = load i32, i32* @Inst_Counter
  %2654 = add i32 2, %2653
  store i32 %2654, i32* @Inst_Counter
  %2655 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2655)
  %2656 = ptrtoint i32* %X.addr.i1321.i to i64
  call void @printStoreAddr(i64 %2656, i32 1844, i32 0, i32 0)
  store i32 %xor56.i, i32* %X.addr.i1321.i, align 4
  call void @printDDep(i32 1834, i32 1844)
  call void @printDDep(i32 1835, i32 1844)
  call void @printDDep(i32 1837, i32 1844)
  call void @printDDep(i32 1842, i32 1844)
  call void @printDDep(i32 1844, i32 1844)
  call void @printDDep(i32 1833, i32 1844)
  call void @printDDep(i32 1844, i32 1844)
  %2657 = load i32, i32* @Inst_Counter, !dbg !5907
  %2658 = add i32 1, %2657, !dbg !5907
  store i32 %2658, i32* @Inst_Counter, !dbg !5907
  %2659 = load i32, i32* @Inst_Counter, !dbg !5907
  call void @printCounter(i32 %2659), !dbg !5907
  %2660 = ptrtoint i32* %X.addr.i1321.i to i64, !dbg !5907
  call void @printLoadAddr(i64 %2660, i32 1845, i32 128, i32 33), !dbg !5907
  %2661 = load i32, i32* %X.addr.i1321.i, align 4, !dbg !5907
  call void @printDDep(i32 1844, i32 1845), !dbg !5907
  call void @printDDep(i32 1844, i32 1845), !dbg !5907
  call void @printDDep(i32 1845, i32 1845), !dbg !5907
  %shr.i1322.i = lshr i32 %2661, 24, !dbg !5908
  %conv.i1323.i = trunc i32 %shr.i1322.i to i8, !dbg !5909
  %idxprom.i1324.i = zext i8 %conv.i1323.i to i64, !dbg !5910
  %arrayidx.i1325.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1324.i, !dbg !5910
  %2662 = load i32, i32* @Inst_Counter, !dbg !5910
  %2663 = add i32 5, %2662, !dbg !5910
  store i32 %2663, i32* @Inst_Counter, !dbg !5910
  %2664 = load i32, i32* @Inst_Counter, !dbg !5910
  call void @printCounter(i32 %2664), !dbg !5910
  %2665 = ptrtoint i32* %arrayidx.i1325.i to i64, !dbg !5910
  %2666 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5910
  call void @printSymLoadAddr(i64 %2665, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 1850, i32 128, i32 12), !dbg !5910
  %2667 = load i32, i32* %arrayidx.i1325.i, align 4, !dbg !5910
  call void @printDDep(i32 1845, i32 1850), !dbg !5910
  call void @printDDep(i32 1850, i32 1850), !dbg !5910
  %2668 = load i32, i32* @Inst_Counter, !dbg !5911
  %2669 = add i32 1, %2668, !dbg !5911
  store i32 %2669, i32* @Inst_Counter, !dbg !5911
  %2670 = load i32, i32* @Inst_Counter, !dbg !5911
  call void @printCounter(i32 %2670), !dbg !5911
  %2671 = ptrtoint i32* %X.addr.i1321.i to i64, !dbg !5911
  call void @printLoadAddr(i64 %2671, i32 1851, i32 129, i32 38), !dbg !5911
  %2672 = load i32, i32* %X.addr.i1321.i, align 4, !dbg !5911
  call void @printDDep(i32 1844, i32 1851), !dbg !5911
  call void @printDDep(i32 1844, i32 1851), !dbg !5911
  call void @printDDep(i32 1851, i32 1851), !dbg !5911
  %shr1.i1326.i = lshr i32 %2672, 16, !dbg !5912
  %conv2.i1327.i = trunc i32 %shr1.i1326.i to i8, !dbg !5913
  %idxprom3.i1328.i = zext i8 %conv2.i1327.i to i64, !dbg !5914
  %arrayidx4.i1329.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1328.i, !dbg !5914
  %2673 = load i32, i32* @Inst_Counter, !dbg !5914
  %2674 = add i32 5, %2673, !dbg !5914
  store i32 %2674, i32* @Inst_Counter, !dbg !5914
  %2675 = load i32, i32* @Inst_Counter, !dbg !5914
  call void @printCounter(i32 %2675), !dbg !5914
  %2676 = ptrtoint i32* %arrayidx4.i1329.i to i64, !dbg !5914
  %2677 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5914
  call void @printSymLoadAddr(i64 %2676, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 1856, i32 129, i32 17), !dbg !5914
  %2678 = load i32, i32* %arrayidx4.i1329.i, align 4, !dbg !5914
  call void @printDDep(i32 1851, i32 1856), !dbg !5914
  call void @printDDep(i32 1856, i32 1856), !dbg !5914
  %2679 = load i32, i32* @Inst_Counter
  %2680 = add i32 1, %2679
  store i32 %2680, i32* @Inst_Counter
  %2681 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2681)
  %2682 = ptrtoint i32* %a.addr.i.i1319.i to i64
  call void @printStoreAddr(i64 %2682, i32 1857, i32 0, i32 0)
  store i32 %2678, i32* %a.addr.i.i1319.i, align 4
  call void @printDDep(i32 1856, i32 1857)
  call void @printDDep(i32 1857, i32 1857)
  call void @printDDep(i32 1844, i32 1857)
  call void @printDDep(i32 1857, i32 1857)
  %2683 = load i32, i32* @Inst_Counter
  %2684 = add i32 1, %2683
  store i32 %2684, i32* @Inst_Counter
  %2685 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2685)
  %2686 = ptrtoint i8* %n.addr.i.i1320.i to i64
  call void @printStoreAddr(i64 %2686, i32 1858, i32 0, i32 0)
  store i8 24, i8* %n.addr.i.i1320.i, align 1
  call void @printDDep(i32 1858, i32 1858)
  call void @printDDep(i32 1857, i32 1858)
  call void @printDDep(i32 1858, i32 1858)
  %2687 = load i32, i32* @Inst_Counter, !dbg !5915
  %2688 = add i32 1, %2687, !dbg !5915
  store i32 %2688, i32* @Inst_Counter, !dbg !5915
  %2689 = load i32, i32* @Inst_Counter, !dbg !5915
  call void @printCounter(i32 %2689), !dbg !5915
  %2690 = ptrtoint i32* %a.addr.i.i1319.i to i64, !dbg !5915
  call void @printLoadAddr(i64 %2690, i32 1859, i32 92, i32 13), !dbg !5915
  %2691 = load i32, i32* %a.addr.i.i1319.i, align 4, !dbg !5915
  call void @printDDep(i32 1857, i32 1859), !dbg !5915
  call void @printDDep(i32 1858, i32 1859), !dbg !5915
  call void @printDDep(i32 1859, i32 1859), !dbg !5915
  %2692 = load i32, i32* @Inst_Counter, !dbg !5916
  %2693 = add i32 1, %2692, !dbg !5916
  store i32 %2693, i32* @Inst_Counter, !dbg !5916
  %2694 = load i32, i32* @Inst_Counter, !dbg !5916
  call void @printCounter(i32 %2694), !dbg !5916
  %2695 = ptrtoint i8* %n.addr.i.i1320.i to i64, !dbg !5916
  call void @printLoadAddr(i64 %2695, i32 1860, i32 92, i32 18), !dbg !5916
  %2696 = load i8, i8* %n.addr.i.i1320.i, align 1, !dbg !5916
  call void @printDDep(i32 1858, i32 1860), !dbg !5916
  call void @printDDep(i32 1858, i32 1860), !dbg !5916
  call void @printDDep(i32 1860, i32 1860), !dbg !5916
  %conv.i.i1330.i = zext i8 %2696 to i32, !dbg !5916
  %shl.i.i1331.i = shl i32 %2691, %conv.i.i1330.i, !dbg !5917
  %2697 = load i32, i32* @Inst_Counter, !dbg !5918
  %2698 = add i32 3, %2697, !dbg !5918
  store i32 %2698, i32* @Inst_Counter, !dbg !5918
  %2699 = load i32, i32* @Inst_Counter, !dbg !5918
  call void @printCounter(i32 %2699), !dbg !5918
  %2700 = ptrtoint i32* %a.addr.i.i1319.i to i64, !dbg !5918
  call void @printLoadAddr(i64 %2700, i32 1863, i32 92, i32 24), !dbg !5918
  %2701 = load i32, i32* %a.addr.i.i1319.i, align 4, !dbg !5918
  call void @printDDep(i32 1857, i32 1863), !dbg !5918
  call void @printDDep(i32 1858, i32 1863), !dbg !5918
  call void @printDDep(i32 1863, i32 1863), !dbg !5918
  %2702 = load i32, i32* @Inst_Counter, !dbg !5919
  %2703 = add i32 1, %2702, !dbg !5919
  store i32 %2703, i32* @Inst_Counter, !dbg !5919
  %2704 = load i32, i32* @Inst_Counter, !dbg !5919
  call void @printCounter(i32 %2704), !dbg !5919
  %2705 = ptrtoint i8* %n.addr.i.i1320.i to i64, !dbg !5919
  call void @printLoadAddr(i64 %2705, i32 1864, i32 92, i32 35), !dbg !5919
  %2706 = load i8, i8* %n.addr.i.i1320.i, align 1, !dbg !5919
  call void @printDDep(i32 1858, i32 1864), !dbg !5919
  call void @printDDep(i32 1858, i32 1864), !dbg !5919
  call void @printDDep(i32 1864, i32 1864), !dbg !5919
  %conv1.i.i1332.i = zext i8 %2706 to i32, !dbg !5919
  %sub.i.i1333.i = sub nsw i32 32, %conv1.i.i1332.i, !dbg !5920
  %shr.i.i1334.i = lshr i32 %2701, %sub.i.i1333.i, !dbg !5921
  %or.i.i1335.i = or i32 %shl.i.i1331.i, %shr.i.i1334.i, !dbg !5922
  %xor.i1336.i = xor i32 %2667, %or.i.i1335.i, !dbg !5923
  %2707 = load i32, i32* @Inst_Counter, !dbg !5924
  %2708 = add i32 6, %2707, !dbg !5924
  store i32 %2708, i32* @Inst_Counter, !dbg !5924
  %2709 = load i32, i32* @Inst_Counter, !dbg !5924
  call void @printCounter(i32 %2709), !dbg !5924
  %2710 = ptrtoint i32* %X.addr.i1321.i to i64, !dbg !5924
  call void @printLoadAddr(i64 %2710, i32 1870, i32 130, i32 38), !dbg !5924
  %2711 = load i32, i32* %X.addr.i1321.i, align 4, !dbg !5924
  call void @printDDep(i32 1844, i32 1870), !dbg !5924
  call void @printDDep(i32 1858, i32 1870), !dbg !5924
  call void @printDDep(i32 1870, i32 1870), !dbg !5924
  %shr5.i1337.i = lshr i32 %2711, 8, !dbg !5925
  %conv6.i1338.i = trunc i32 %shr5.i1337.i to i8, !dbg !5926
  %idxprom7.i1339.i = zext i8 %conv6.i1338.i to i64, !dbg !5927
  %arrayidx8.i1340.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1339.i, !dbg !5927
  %2712 = load i32, i32* @Inst_Counter, !dbg !5927
  %2713 = add i32 5, %2712, !dbg !5927
  store i32 %2713, i32* @Inst_Counter, !dbg !5927
  %2714 = load i32, i32* @Inst_Counter, !dbg !5927
  call void @printCounter(i32 %2714), !dbg !5927
  %2715 = ptrtoint i32* %arrayidx8.i1340.i to i64, !dbg !5927
  %2716 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5927
  call void @printSymLoadAddr(i64 %2715, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 1875, i32 130, i32 17), !dbg !5927
  %2717 = load i32, i32* %arrayidx8.i1340.i, align 4, !dbg !5927
  call void @printDDep(i32 1870, i32 1875), !dbg !5927
  call void @printDDep(i32 1875, i32 1875), !dbg !5927
  %2718 = load i32, i32* @Inst_Counter
  %2719 = add i32 1, %2718
  store i32 %2719, i32* @Inst_Counter
  %2720 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2720)
  %2721 = ptrtoint i32* %a.addr.i24.i1315.i to i64
  call void @printStoreAddr(i64 %2721, i32 1876, i32 0, i32 0)
  store i32 %2717, i32* %a.addr.i24.i1315.i, align 4
  call void @printDDep(i32 1875, i32 1876)
  call void @printDDep(i32 1876, i32 1876)
  call void @printDDep(i32 1858, i32 1876)
  call void @printDDep(i32 1876, i32 1876)
  %2722 = load i32, i32* @Inst_Counter
  %2723 = add i32 1, %2722
  store i32 %2723, i32* @Inst_Counter
  %2724 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2724)
  %2725 = ptrtoint i8* %n.addr.i25.i1316.i to i64
  call void @printStoreAddr(i64 %2725, i32 1877, i32 0, i32 0)
  store i8 16, i8* %n.addr.i25.i1316.i, align 1
  call void @printDDep(i32 1877, i32 1877)
  call void @printDDep(i32 1876, i32 1877)
  call void @printDDep(i32 1877, i32 1877)
  %2726 = load i32, i32* @Inst_Counter, !dbg !5928
  %2727 = add i32 1, %2726, !dbg !5928
  store i32 %2727, i32* @Inst_Counter, !dbg !5928
  %2728 = load i32, i32* @Inst_Counter, !dbg !5928
  call void @printCounter(i32 %2728), !dbg !5928
  %2729 = ptrtoint i32* %a.addr.i24.i1315.i to i64, !dbg !5928
  call void @printLoadAddr(i64 %2729, i32 1878, i32 92, i32 13), !dbg !5928
  %2730 = load i32, i32* %a.addr.i24.i1315.i, align 4, !dbg !5928
  call void @printDDep(i32 1876, i32 1878), !dbg !5928
  call void @printDDep(i32 1877, i32 1878), !dbg !5928
  call void @printDDep(i32 1878, i32 1878), !dbg !5928
  %2731 = load i32, i32* @Inst_Counter, !dbg !5929
  %2732 = add i32 1, %2731, !dbg !5929
  store i32 %2732, i32* @Inst_Counter, !dbg !5929
  %2733 = load i32, i32* @Inst_Counter, !dbg !5929
  call void @printCounter(i32 %2733), !dbg !5929
  %2734 = ptrtoint i8* %n.addr.i25.i1316.i to i64, !dbg !5929
  call void @printLoadAddr(i64 %2734, i32 1879, i32 92, i32 18), !dbg !5929
  %2735 = load i8, i8* %n.addr.i25.i1316.i, align 1, !dbg !5929
  call void @printDDep(i32 1877, i32 1879), !dbg !5929
  call void @printDDep(i32 1877, i32 1879), !dbg !5929
  call void @printDDep(i32 1879, i32 1879), !dbg !5929
  %conv.i26.i1341.i = zext i8 %2735 to i32, !dbg !5929
  %shl.i27.i1342.i = shl i32 %2730, %conv.i26.i1341.i, !dbg !5930
  %2736 = load i32, i32* @Inst_Counter, !dbg !5931
  %2737 = add i32 3, %2736, !dbg !5931
  store i32 %2737, i32* @Inst_Counter, !dbg !5931
  %2738 = load i32, i32* @Inst_Counter, !dbg !5931
  call void @printCounter(i32 %2738), !dbg !5931
  %2739 = ptrtoint i32* %a.addr.i24.i1315.i to i64, !dbg !5931
  call void @printLoadAddr(i64 %2739, i32 1882, i32 92, i32 24), !dbg !5931
  %2740 = load i32, i32* %a.addr.i24.i1315.i, align 4, !dbg !5931
  call void @printDDep(i32 1876, i32 1882), !dbg !5931
  call void @printDDep(i32 1877, i32 1882), !dbg !5931
  call void @printDDep(i32 1882, i32 1882), !dbg !5931
  %2741 = load i32, i32* @Inst_Counter, !dbg !5932
  %2742 = add i32 1, %2741, !dbg !5932
  store i32 %2742, i32* @Inst_Counter, !dbg !5932
  %2743 = load i32, i32* @Inst_Counter, !dbg !5932
  call void @printCounter(i32 %2743), !dbg !5932
  %2744 = ptrtoint i8* %n.addr.i25.i1316.i to i64, !dbg !5932
  call void @printLoadAddr(i64 %2744, i32 1883, i32 92, i32 35), !dbg !5932
  %2745 = load i8, i8* %n.addr.i25.i1316.i, align 1, !dbg !5932
  call void @printDDep(i32 1877, i32 1883), !dbg !5932
  call void @printDDep(i32 1877, i32 1883), !dbg !5932
  call void @printDDep(i32 1883, i32 1883), !dbg !5932
  %conv1.i28.i1343.i = zext i8 %2745 to i32, !dbg !5932
  %sub.i29.i1344.i = sub nsw i32 32, %conv1.i28.i1343.i, !dbg !5933
  %shr.i30.i1345.i = lshr i32 %2740, %sub.i29.i1344.i, !dbg !5934
  %or.i31.i1346.i = or i32 %shl.i27.i1342.i, %shr.i30.i1345.i, !dbg !5935
  %xor10.i1347.i = xor i32 %xor.i1336.i, %or.i31.i1346.i, !dbg !5936
  %2746 = load i32, i32* @Inst_Counter, !dbg !5937
  %2747 = add i32 6, %2746, !dbg !5937
  store i32 %2747, i32* @Inst_Counter, !dbg !5937
  %2748 = load i32, i32* @Inst_Counter, !dbg !5937
  call void @printCounter(i32 %2748), !dbg !5937
  %2749 = ptrtoint i32* %X.addr.i1321.i to i64, !dbg !5937
  call void @printLoadAddr(i64 %2749, i32 1889, i32 131, i32 37), !dbg !5937
  %2750 = load i32, i32* %X.addr.i1321.i, align 4, !dbg !5937
  call void @printDDep(i32 1844, i32 1889), !dbg !5937
  call void @printDDep(i32 1877, i32 1889), !dbg !5937
  call void @printDDep(i32 1889, i32 1889), !dbg !5937
  %conv11.i1348.i = trunc i32 %2750 to i8, !dbg !5938
  %idxprom12.i1349.i = zext i8 %conv11.i1348.i to i64, !dbg !5939
  %arrayidx13.i1350.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1349.i, !dbg !5939
  %2751 = load i32, i32* @Inst_Counter, !dbg !5939
  %2752 = add i32 4, %2751, !dbg !5939
  store i32 %2752, i32* @Inst_Counter, !dbg !5939
  %2753 = load i32, i32* @Inst_Counter, !dbg !5939
  call void @printCounter(i32 %2753), !dbg !5939
  %2754 = ptrtoint i32* %arrayidx13.i1350.i to i64, !dbg !5939
  %2755 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5939
  call void @printSymLoadAddr(i64 %2754, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 1893, i32 131, i32 17), !dbg !5939
  %2756 = load i32, i32* %arrayidx13.i1350.i, align 4, !dbg !5939
  call void @printDDep(i32 1889, i32 1893), !dbg !5939
  call void @printDDep(i32 1893, i32 1893), !dbg !5939
  %2757 = load i32, i32* @Inst_Counter
  %2758 = add i32 1, %2757
  store i32 %2758, i32* @Inst_Counter
  %2759 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2759)
  %2760 = ptrtoint i32* %a.addr.i16.i1317.i to i64
  call void @printStoreAddr(i64 %2760, i32 1894, i32 0, i32 0)
  store i32 %2756, i32* %a.addr.i16.i1317.i, align 4
  call void @printDDep(i32 1893, i32 1894)
  call void @printDDep(i32 1894, i32 1894)
  call void @printDDep(i32 1877, i32 1894)
  call void @printDDep(i32 1894, i32 1894)
  %2761 = load i32, i32* @Inst_Counter
  %2762 = add i32 1, %2761
  store i32 %2762, i32* @Inst_Counter
  %2763 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2763)
  %2764 = ptrtoint i8* %n.addr.i17.i1318.i to i64
  call void @printStoreAddr(i64 %2764, i32 1895, i32 0, i32 0)
  store i8 8, i8* %n.addr.i17.i1318.i, align 1
  call void @printDDep(i32 1895, i32 1895)
  call void @printDDep(i32 1894, i32 1895)
  call void @printDDep(i32 1895, i32 1895)
  %2765 = load i32, i32* @Inst_Counter, !dbg !5940
  %2766 = add i32 1, %2765, !dbg !5940
  store i32 %2766, i32* @Inst_Counter, !dbg !5940
  %2767 = load i32, i32* @Inst_Counter, !dbg !5940
  call void @printCounter(i32 %2767), !dbg !5940
  %2768 = ptrtoint i32* %a.addr.i16.i1317.i to i64, !dbg !5940
  call void @printLoadAddr(i64 %2768, i32 1896, i32 92, i32 13), !dbg !5940
  %2769 = load i32, i32* %a.addr.i16.i1317.i, align 4, !dbg !5940
  call void @printDDep(i32 1894, i32 1896), !dbg !5940
  call void @printDDep(i32 1895, i32 1896), !dbg !5940
  call void @printDDep(i32 1896, i32 1896), !dbg !5940
  %2770 = load i32, i32* @Inst_Counter, !dbg !5941
  %2771 = add i32 1, %2770, !dbg !5941
  store i32 %2771, i32* @Inst_Counter, !dbg !5941
  %2772 = load i32, i32* @Inst_Counter, !dbg !5941
  call void @printCounter(i32 %2772), !dbg !5941
  %2773 = ptrtoint i8* %n.addr.i17.i1318.i to i64, !dbg !5941
  call void @printLoadAddr(i64 %2773, i32 1897, i32 92, i32 18), !dbg !5941
  %2774 = load i8, i8* %n.addr.i17.i1318.i, align 1, !dbg !5941
  call void @printDDep(i32 1895, i32 1897), !dbg !5941
  call void @printDDep(i32 1895, i32 1897), !dbg !5941
  call void @printDDep(i32 1897, i32 1897), !dbg !5941
  %conv.i18.i1351.i = zext i8 %2774 to i32, !dbg !5941
  %shl.i19.i1352.i = shl i32 %2769, %conv.i18.i1351.i, !dbg !5942
  %2775 = load i32, i32* @Inst_Counter, !dbg !5943
  %2776 = add i32 3, %2775, !dbg !5943
  store i32 %2776, i32* @Inst_Counter, !dbg !5943
  %2777 = load i32, i32* @Inst_Counter, !dbg !5943
  call void @printCounter(i32 %2777), !dbg !5943
  %2778 = ptrtoint i32* %a.addr.i16.i1317.i to i64, !dbg !5943
  call void @printLoadAddr(i64 %2778, i32 1900, i32 92, i32 24), !dbg !5943
  %2779 = load i32, i32* %a.addr.i16.i1317.i, align 4, !dbg !5943
  call void @printDDep(i32 1894, i32 1900), !dbg !5943
  call void @printDDep(i32 1895, i32 1900), !dbg !5943
  call void @printDDep(i32 1900, i32 1900), !dbg !5943
  %2780 = load i32, i32* @Inst_Counter, !dbg !5944
  %2781 = add i32 1, %2780, !dbg !5944
  store i32 %2781, i32* @Inst_Counter, !dbg !5944
  %2782 = load i32, i32* @Inst_Counter, !dbg !5944
  call void @printCounter(i32 %2782), !dbg !5944
  %2783 = ptrtoint i8* %n.addr.i17.i1318.i to i64, !dbg !5944
  call void @printLoadAddr(i64 %2783, i32 1901, i32 92, i32 35), !dbg !5944
  %2784 = load i8, i8* %n.addr.i17.i1318.i, align 1, !dbg !5944
  call void @printDDep(i32 1895, i32 1901), !dbg !5944
  call void @printDDep(i32 1895, i32 1901), !dbg !5944
  call void @printDDep(i32 1901, i32 1901), !dbg !5944
  %conv1.i20.i1353.i = zext i8 %2784 to i32, !dbg !5944
  %sub.i21.i1354.i = sub nsw i32 32, %conv1.i20.i1353.i, !dbg !5945
  %shr.i22.i1355.i = lshr i32 %2779, %sub.i21.i1354.i, !dbg !5946
  %or.i23.i1356.i = or i32 %shl.i19.i1352.i, %shr.i22.i1355.i, !dbg !5947
  %xor15.i1357.i = xor i32 %xor10.i1347.i, %or.i23.i1356.i, !dbg !5948
  %2785 = load i32, i32* @Inst_Counter, !dbg !5780
  %2786 = add i32 6, %2785, !dbg !5780
  store i32 %2786, i32* @Inst_Counter, !dbg !5780
  %2787 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2787), !dbg !5780
  %2788 = ptrtoint i32* %B3.i to i64, !dbg !5780
  call void @printLoadAddr(i64 %2788, i32 1907, i32 201, i32 5), !dbg !5780
  %2789 = load i32, i32* %B3.i, align 4, !dbg !5780
  call void @printDDep(i32 1149, i32 1907), !dbg !5780
  call void @printDDep(i32 1605, i32 1907), !dbg !5780
  call void @printDDep(i32 1909, i32 1907), !dbg !5780
  call void @printDDep(i32 2213, i32 1907), !dbg !5780
  call void @printDDep(i32 2517, i32 1907), !dbg !5780
  call void @printDDep(i32 2821, i32 1907), !dbg !5780
  call void @printDDep(i32 3125, i32 1907), !dbg !5780
  call void @printDDep(i32 3429, i32 1907), !dbg !5780
  call void @printDDep(i32 3885, i32 1907), !dbg !5780
  call void @printDDep(i32 1605, i32 1907), !dbg !5780
  call void @printDDep(i32 1907, i32 1907), !dbg !5780
  %xor58.i = xor i32 %2789, %xor15.i1357.i, !dbg !5780
  %2790 = load i32, i32* @Inst_Counter, !dbg !5780
  %2791 = add i32 2, %2790, !dbg !5780
  store i32 %2791, i32* @Inst_Counter, !dbg !5780
  %2792 = load i32, i32* @Inst_Counter, !dbg !5780
  call void @printCounter(i32 %2792), !dbg !5780
  %2793 = ptrtoint i32* %B3.i to i64, !dbg !5780
  call void @printStoreAddr(i64 %2793, i32 1909, i32 201, i32 5), !dbg !5780
  store i32 %xor58.i, i32* %B3.i, align 4, !dbg !5780
  call void @printDDep(i32 1149, i32 1909), !dbg !5780
  call void @printDDep(i32 1605, i32 1909), !dbg !5780
  call void @printDDep(i32 1850, i32 1909), !dbg !5780
  call void @printDDep(i32 1859, i32 1909), !dbg !5780
  call void @printDDep(i32 1860, i32 1909), !dbg !5780
  call void @printDDep(i32 1863, i32 1909), !dbg !5780
  call void @printDDep(i32 1864, i32 1909), !dbg !5780
  call void @printDDep(i32 1878, i32 1909), !dbg !5780
  call void @printDDep(i32 1879, i32 1909), !dbg !5780
  call void @printDDep(i32 1882, i32 1909), !dbg !5780
  call void @printDDep(i32 1883, i32 1909), !dbg !5780
  call void @printDDep(i32 1896, i32 1909), !dbg !5780
  call void @printDDep(i32 1897, i32 1909), !dbg !5780
  call void @printDDep(i32 1900, i32 1909), !dbg !5780
  call void @printDDep(i32 1901, i32 1909), !dbg !5780
  call void @printDDep(i32 1907, i32 1909), !dbg !5780
  call void @printDDep(i32 1909, i32 1909), !dbg !5780
  call void @printDDep(i32 2213, i32 1909), !dbg !5780
  call void @printDDep(i32 2517, i32 1909), !dbg !5780
  call void @printDDep(i32 2821, i32 1909), !dbg !5780
  call void @printDDep(i32 3125, i32 1909), !dbg !5780
  call void @printDDep(i32 3429, i32 1909), !dbg !5780
  call void @printDDep(i32 3885, i32 1909), !dbg !5780
  call void @printDDep(i32 1895, i32 1909), !dbg !5780
  call void @printDDep(i32 1909, i32 1909), !dbg !5780
  %2794 = load i32, i32* @Inst_Counter, !dbg !5949
  %2795 = add i32 1, %2794, !dbg !5949
  store i32 %2795, i32* @Inst_Counter, !dbg !5949
  %2796 = load i32, i32* @Inst_Counter, !dbg !5949
  call void @printCounter(i32 %2796), !dbg !5949
  %2797 = ptrtoint i32* %B1.i to i64, !dbg !5949
  call void @printLoadAddr(i64 %2797, i32 1910, i32 202, i32 5), !dbg !5949
  %2798 = load i32, i32* %B1.i, align 4, !dbg !5949
  call void @printDDep(i32 1067, i32 1910), !dbg !5949
  call void @printDDep(i32 1377, i32 1910), !dbg !5949
  call void @printDDep(i32 1757, i32 1910), !dbg !5949
  call void @printDDep(i32 2061, i32 1910), !dbg !5949
  call void @printDDep(i32 2365, i32 1910), !dbg !5949
  call void @printDDep(i32 2669, i32 1910), !dbg !5949
  call void @printDDep(i32 2973, i32 1910), !dbg !5949
  call void @printDDep(i32 3277, i32 1910), !dbg !5949
  call void @printDDep(i32 3657, i32 1910), !dbg !5949
  call void @printDDep(i32 1757, i32 1910), !dbg !5949
  call void @printDDep(i32 1910, i32 1910), !dbg !5949
  %2799 = load i32, i32* @Inst_Counter, !dbg !5949
  %2800 = add i32 1, %2799, !dbg !5949
  store i32 %2800, i32* @Inst_Counter, !dbg !5949
  %2801 = load i32, i32* @Inst_Counter, !dbg !5949
  call void @printCounter(i32 %2801), !dbg !5949
  %2802 = ptrtoint i32* %B2.i to i64, !dbg !5949
  call void @printLoadAddr(i64 %2802, i32 1911, i32 202, i32 5), !dbg !5949
  %2803 = load i32, i32* %B2.i, align 4, !dbg !5949
  call void @printDDep(i32 1108, i32 1911), !dbg !5949
  call void @printDDep(i32 1491, i32 1911), !dbg !5949
  call void @printDDep(i32 1833, i32 1911), !dbg !5949
  call void @printDDep(i32 2137, i32 1911), !dbg !5949
  call void @printDDep(i32 2441, i32 1911), !dbg !5949
  call void @printDDep(i32 2745, i32 1911), !dbg !5949
  call void @printDDep(i32 3049, i32 1911), !dbg !5949
  call void @printDDep(i32 3353, i32 1911), !dbg !5949
  call void @printDDep(i32 3771, i32 1911), !dbg !5949
  call void @printDDep(i32 1833, i32 1911), !dbg !5949
  call void @printDDep(i32 1911, i32 1911), !dbg !5949
  %xor61.i = xor i32 %2798, %2803, !dbg !5949
  %2804 = load i32, i32* @Inst_Counter, !dbg !5949
  %2805 = add i32 2, %2804, !dbg !5949
  store i32 %2805, i32* @Inst_Counter, !dbg !5949
  %2806 = load i32, i32* @Inst_Counter, !dbg !5949
  call void @printCounter(i32 %2806), !dbg !5949
  %2807 = ptrtoint i32* %B3.i to i64, !dbg !5949
  call void @printLoadAddr(i64 %2807, i32 1913, i32 202, i32 5), !dbg !5949
  %2808 = load i32, i32* %B3.i, align 4, !dbg !5949
  call void @printDDep(i32 1149, i32 1913), !dbg !5949
  call void @printDDep(i32 1605, i32 1913), !dbg !5949
  call void @printDDep(i32 1909, i32 1913), !dbg !5949
  call void @printDDep(i32 2213, i32 1913), !dbg !5949
  call void @printDDep(i32 2517, i32 1913), !dbg !5949
  call void @printDDep(i32 2821, i32 1913), !dbg !5949
  call void @printDDep(i32 3125, i32 1913), !dbg !5949
  call void @printDDep(i32 3429, i32 1913), !dbg !5949
  call void @printDDep(i32 3885, i32 1913), !dbg !5949
  call void @printDDep(i32 1909, i32 1913), !dbg !5949
  call void @printDDep(i32 1913, i32 1913), !dbg !5949
  %xor62.i = xor i32 %xor61.i, %2808, !dbg !5949
  %2809 = load i32, i32* @Inst_Counter, !dbg !5949
  %2810 = add i32 2, %2809, !dbg !5949
  store i32 %2810, i32* @Inst_Counter, !dbg !5949
  %2811 = load i32, i32* @Inst_Counter, !dbg !5949
  call void @printCounter(i32 %2811), !dbg !5949
  %2812 = ptrtoint %struct.SM4_KEY_st** %ks.addr.i24 to i64, !dbg !5949
  call void @printLoadAddr(i64 %2812, i32 1915, i32 202, i32 5), !dbg !5949
  %2813 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr.i24, align 8, !dbg !5949
  call void @printDDep(i32 983, i32 1915), !dbg !5949
  call void @printDDep(i32 985, i32 1915), !dbg !5949
  call void @printDDep(i32 1915, i32 1915), !dbg !5949
  %rk63.i = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %2813, i32 0, i32 0, !dbg !5949
  %arrayidx64.i = getelementptr inbounds [32 x i32], [32 x i32]* %rk63.i, i64 0, i64 8, !dbg !5949
  %2814 = load i32, i32* @Inst_Counter, !dbg !5949
  %2815 = add i32 3, %2814, !dbg !5949
  store i32 %2815, i32* @Inst_Counter, !dbg !5949
  %2816 = load i32, i32* @Inst_Counter, !dbg !5949
  call void @printCounter(i32 %2816), !dbg !5949
  %2817 = ptrtoint i32* %arrayidx64.i to i64, !dbg !5949
  call void @printLoadAddr(i64 %2817, i32 1918, i32 202, i32 5), !dbg !5949
  %2818 = load i32, i32* %arrayidx64.i, align 4, !dbg !5949
  call void @printDDep(i32 1915, i32 1918), !dbg !5949
  call void @printDDep(i32 1909, i32 1918), !dbg !5949
  call void @printDDep(i32 1918, i32 1918), !dbg !5949
  %xor65.i = xor i32 %xor62.i, %2818, !dbg !5949
  %2819 = load i32, i32* @Inst_Counter
  %2820 = add i32 2, %2819
  store i32 %2820, i32* @Inst_Counter
  %2821 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2821)
  %2822 = ptrtoint i32* %X.addr.i1278.i to i64
  call void @printStoreAddr(i64 %2822, i32 1920, i32 0, i32 0)
  store i32 %xor65.i, i32* %X.addr.i1278.i, align 4
  call void @printDDep(i32 1910, i32 1920)
  call void @printDDep(i32 1911, i32 1920)
  call void @printDDep(i32 1913, i32 1920)
  call void @printDDep(i32 1918, i32 1920)
  call void @printDDep(i32 1920, i32 1920)
  call void @printDDep(i32 1909, i32 1920)
  call void @printDDep(i32 1920, i32 1920)
  %2823 = load i32, i32* @Inst_Counter, !dbg !5950
  %2824 = add i32 1, %2823, !dbg !5950
  store i32 %2824, i32* @Inst_Counter, !dbg !5950
  %2825 = load i32, i32* @Inst_Counter, !dbg !5950
  call void @printCounter(i32 %2825), !dbg !5950
  %2826 = ptrtoint i32* %X.addr.i1278.i to i64, !dbg !5950
  call void @printLoadAddr(i64 %2826, i32 1921, i32 128, i32 33), !dbg !5950
  %2827 = load i32, i32* %X.addr.i1278.i, align 4, !dbg !5950
  call void @printDDep(i32 1920, i32 1921), !dbg !5950
  call void @printDDep(i32 1920, i32 1921), !dbg !5950
  call void @printDDep(i32 1921, i32 1921), !dbg !5950
  %shr.i1279.i = lshr i32 %2827, 24, !dbg !5951
  %conv.i1280.i = trunc i32 %shr.i1279.i to i8, !dbg !5952
  %idxprom.i1281.i = zext i8 %conv.i1280.i to i64, !dbg !5953
  %arrayidx.i1282.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1281.i, !dbg !5953
  %2828 = load i32, i32* @Inst_Counter, !dbg !5953
  %2829 = add i32 5, %2828, !dbg !5953
  store i32 %2829, i32* @Inst_Counter, !dbg !5953
  %2830 = load i32, i32* @Inst_Counter, !dbg !5953
  call void @printCounter(i32 %2830), !dbg !5953
  %2831 = ptrtoint i32* %arrayidx.i1282.i to i64, !dbg !5953
  %2832 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5953
  call void @printSymLoadAddr(i64 %2831, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 1926, i32 128, i32 12), !dbg !5953
  %2833 = load i32, i32* %arrayidx.i1282.i, align 4, !dbg !5953
  call void @printDDep(i32 1921, i32 1926), !dbg !5953
  call void @printDDep(i32 1926, i32 1926), !dbg !5953
  %2834 = load i32, i32* @Inst_Counter, !dbg !5954
  %2835 = add i32 1, %2834, !dbg !5954
  store i32 %2835, i32* @Inst_Counter, !dbg !5954
  %2836 = load i32, i32* @Inst_Counter, !dbg !5954
  call void @printCounter(i32 %2836), !dbg !5954
  %2837 = ptrtoint i32* %X.addr.i1278.i to i64, !dbg !5954
  call void @printLoadAddr(i64 %2837, i32 1927, i32 129, i32 38), !dbg !5954
  %2838 = load i32, i32* %X.addr.i1278.i, align 4, !dbg !5954
  call void @printDDep(i32 1920, i32 1927), !dbg !5954
  call void @printDDep(i32 1920, i32 1927), !dbg !5954
  call void @printDDep(i32 1927, i32 1927), !dbg !5954
  %shr1.i1283.i = lshr i32 %2838, 16, !dbg !5955
  %conv2.i1284.i = trunc i32 %shr1.i1283.i to i8, !dbg !5956
  %idxprom3.i1285.i = zext i8 %conv2.i1284.i to i64, !dbg !5957
  %arrayidx4.i1286.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1285.i, !dbg !5957
  %2839 = load i32, i32* @Inst_Counter, !dbg !5957
  %2840 = add i32 5, %2839, !dbg !5957
  store i32 %2840, i32* @Inst_Counter, !dbg !5957
  %2841 = load i32, i32* @Inst_Counter, !dbg !5957
  call void @printCounter(i32 %2841), !dbg !5957
  %2842 = ptrtoint i32* %arrayidx4.i1286.i to i64, !dbg !5957
  %2843 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5957
  call void @printSymLoadAddr(i64 %2842, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 1932, i32 129, i32 17), !dbg !5957
  %2844 = load i32, i32* %arrayidx4.i1286.i, align 4, !dbg !5957
  call void @printDDep(i32 1927, i32 1932), !dbg !5957
  call void @printDDep(i32 1932, i32 1932), !dbg !5957
  %2845 = load i32, i32* @Inst_Counter
  %2846 = add i32 1, %2845
  store i32 %2846, i32* @Inst_Counter
  %2847 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2847)
  %2848 = ptrtoint i32* %a.addr.i.i1276.i to i64
  call void @printStoreAddr(i64 %2848, i32 1933, i32 0, i32 0)
  store i32 %2844, i32* %a.addr.i.i1276.i, align 4
  call void @printDDep(i32 1932, i32 1933)
  call void @printDDep(i32 1933, i32 1933)
  call void @printDDep(i32 1920, i32 1933)
  call void @printDDep(i32 1933, i32 1933)
  %2849 = load i32, i32* @Inst_Counter
  %2850 = add i32 1, %2849
  store i32 %2850, i32* @Inst_Counter
  %2851 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2851)
  %2852 = ptrtoint i8* %n.addr.i.i1277.i to i64
  call void @printStoreAddr(i64 %2852, i32 1934, i32 0, i32 0)
  store i8 24, i8* %n.addr.i.i1277.i, align 1
  call void @printDDep(i32 1934, i32 1934)
  call void @printDDep(i32 1933, i32 1934)
  call void @printDDep(i32 1934, i32 1934)
  %2853 = load i32, i32* @Inst_Counter, !dbg !5958
  %2854 = add i32 1, %2853, !dbg !5958
  store i32 %2854, i32* @Inst_Counter, !dbg !5958
  %2855 = load i32, i32* @Inst_Counter, !dbg !5958
  call void @printCounter(i32 %2855), !dbg !5958
  %2856 = ptrtoint i32* %a.addr.i.i1276.i to i64, !dbg !5958
  call void @printLoadAddr(i64 %2856, i32 1935, i32 92, i32 13), !dbg !5958
  %2857 = load i32, i32* %a.addr.i.i1276.i, align 4, !dbg !5958
  call void @printDDep(i32 1933, i32 1935), !dbg !5958
  call void @printDDep(i32 1934, i32 1935), !dbg !5958
  call void @printDDep(i32 1935, i32 1935), !dbg !5958
  %2858 = load i32, i32* @Inst_Counter, !dbg !5959
  %2859 = add i32 1, %2858, !dbg !5959
  store i32 %2859, i32* @Inst_Counter, !dbg !5959
  %2860 = load i32, i32* @Inst_Counter, !dbg !5959
  call void @printCounter(i32 %2860), !dbg !5959
  %2861 = ptrtoint i8* %n.addr.i.i1277.i to i64, !dbg !5959
  call void @printLoadAddr(i64 %2861, i32 1936, i32 92, i32 18), !dbg !5959
  %2862 = load i8, i8* %n.addr.i.i1277.i, align 1, !dbg !5959
  call void @printDDep(i32 1934, i32 1936), !dbg !5959
  call void @printDDep(i32 1934, i32 1936), !dbg !5959
  call void @printDDep(i32 1936, i32 1936), !dbg !5959
  %conv.i.i1287.i = zext i8 %2862 to i32, !dbg !5959
  %shl.i.i1288.i = shl i32 %2857, %conv.i.i1287.i, !dbg !5960
  %2863 = load i32, i32* @Inst_Counter, !dbg !5961
  %2864 = add i32 3, %2863, !dbg !5961
  store i32 %2864, i32* @Inst_Counter, !dbg !5961
  %2865 = load i32, i32* @Inst_Counter, !dbg !5961
  call void @printCounter(i32 %2865), !dbg !5961
  %2866 = ptrtoint i32* %a.addr.i.i1276.i to i64, !dbg !5961
  call void @printLoadAddr(i64 %2866, i32 1939, i32 92, i32 24), !dbg !5961
  %2867 = load i32, i32* %a.addr.i.i1276.i, align 4, !dbg !5961
  call void @printDDep(i32 1933, i32 1939), !dbg !5961
  call void @printDDep(i32 1934, i32 1939), !dbg !5961
  call void @printDDep(i32 1939, i32 1939), !dbg !5961
  %2868 = load i32, i32* @Inst_Counter, !dbg !5962
  %2869 = add i32 1, %2868, !dbg !5962
  store i32 %2869, i32* @Inst_Counter, !dbg !5962
  %2870 = load i32, i32* @Inst_Counter, !dbg !5962
  call void @printCounter(i32 %2870), !dbg !5962
  %2871 = ptrtoint i8* %n.addr.i.i1277.i to i64, !dbg !5962
  call void @printLoadAddr(i64 %2871, i32 1940, i32 92, i32 35), !dbg !5962
  %2872 = load i8, i8* %n.addr.i.i1277.i, align 1, !dbg !5962
  call void @printDDep(i32 1934, i32 1940), !dbg !5962
  call void @printDDep(i32 1934, i32 1940), !dbg !5962
  call void @printDDep(i32 1940, i32 1940), !dbg !5962
  %conv1.i.i1289.i = zext i8 %2872 to i32, !dbg !5962
  %sub.i.i1290.i = sub nsw i32 32, %conv1.i.i1289.i, !dbg !5963
  %shr.i.i1291.i = lshr i32 %2867, %sub.i.i1290.i, !dbg !5964
  %or.i.i1292.i = or i32 %shl.i.i1288.i, %shr.i.i1291.i, !dbg !5965
  %xor.i1293.i = xor i32 %2833, %or.i.i1292.i, !dbg !5966
  %2873 = load i32, i32* @Inst_Counter, !dbg !5967
  %2874 = add i32 6, %2873, !dbg !5967
  store i32 %2874, i32* @Inst_Counter, !dbg !5967
  %2875 = load i32, i32* @Inst_Counter, !dbg !5967
  call void @printCounter(i32 %2875), !dbg !5967
  %2876 = ptrtoint i32* %X.addr.i1278.i to i64, !dbg !5967
  call void @printLoadAddr(i64 %2876, i32 1946, i32 130, i32 38), !dbg !5967
  %2877 = load i32, i32* %X.addr.i1278.i, align 4, !dbg !5967
  call void @printDDep(i32 1920, i32 1946), !dbg !5967
  call void @printDDep(i32 1934, i32 1946), !dbg !5967
  call void @printDDep(i32 1946, i32 1946), !dbg !5967
  %shr5.i1294.i = lshr i32 %2877, 8, !dbg !5968
  %conv6.i1295.i = trunc i32 %shr5.i1294.i to i8, !dbg !5969
  %idxprom7.i1296.i = zext i8 %conv6.i1295.i to i64, !dbg !5970
  %arrayidx8.i1297.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1296.i, !dbg !5970
  %2878 = load i32, i32* @Inst_Counter, !dbg !5970
  %2879 = add i32 5, %2878, !dbg !5970
  store i32 %2879, i32* @Inst_Counter, !dbg !5970
  %2880 = load i32, i32* @Inst_Counter, !dbg !5970
  call void @printCounter(i32 %2880), !dbg !5970
  %2881 = ptrtoint i32* %arrayidx8.i1297.i to i64, !dbg !5970
  %2882 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5970
  call void @printSymLoadAddr(i64 %2881, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 1951, i32 130, i32 17), !dbg !5970
  %2883 = load i32, i32* %arrayidx8.i1297.i, align 4, !dbg !5970
  call void @printDDep(i32 1946, i32 1951), !dbg !5970
  call void @printDDep(i32 1951, i32 1951), !dbg !5970
  %2884 = load i32, i32* @Inst_Counter
  %2885 = add i32 1, %2884
  store i32 %2885, i32* @Inst_Counter
  %2886 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2886)
  %2887 = ptrtoint i32* %a.addr.i24.i1272.i to i64
  call void @printStoreAddr(i64 %2887, i32 1952, i32 0, i32 0)
  store i32 %2883, i32* %a.addr.i24.i1272.i, align 4
  call void @printDDep(i32 1951, i32 1952)
  call void @printDDep(i32 1952, i32 1952)
  call void @printDDep(i32 1934, i32 1952)
  call void @printDDep(i32 1952, i32 1952)
  %2888 = load i32, i32* @Inst_Counter
  %2889 = add i32 1, %2888
  store i32 %2889, i32* @Inst_Counter
  %2890 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2890)
  %2891 = ptrtoint i8* %n.addr.i25.i1273.i to i64
  call void @printStoreAddr(i64 %2891, i32 1953, i32 0, i32 0)
  store i8 16, i8* %n.addr.i25.i1273.i, align 1
  call void @printDDep(i32 1953, i32 1953)
  call void @printDDep(i32 1952, i32 1953)
  call void @printDDep(i32 1953, i32 1953)
  %2892 = load i32, i32* @Inst_Counter, !dbg !5971
  %2893 = add i32 1, %2892, !dbg !5971
  store i32 %2893, i32* @Inst_Counter, !dbg !5971
  %2894 = load i32, i32* @Inst_Counter, !dbg !5971
  call void @printCounter(i32 %2894), !dbg !5971
  %2895 = ptrtoint i32* %a.addr.i24.i1272.i to i64, !dbg !5971
  call void @printLoadAddr(i64 %2895, i32 1954, i32 92, i32 13), !dbg !5971
  %2896 = load i32, i32* %a.addr.i24.i1272.i, align 4, !dbg !5971
  call void @printDDep(i32 1952, i32 1954), !dbg !5971
  call void @printDDep(i32 1953, i32 1954), !dbg !5971
  call void @printDDep(i32 1954, i32 1954), !dbg !5971
  %2897 = load i32, i32* @Inst_Counter, !dbg !5972
  %2898 = add i32 1, %2897, !dbg !5972
  store i32 %2898, i32* @Inst_Counter, !dbg !5972
  %2899 = load i32, i32* @Inst_Counter, !dbg !5972
  call void @printCounter(i32 %2899), !dbg !5972
  %2900 = ptrtoint i8* %n.addr.i25.i1273.i to i64, !dbg !5972
  call void @printLoadAddr(i64 %2900, i32 1955, i32 92, i32 18), !dbg !5972
  %2901 = load i8, i8* %n.addr.i25.i1273.i, align 1, !dbg !5972
  call void @printDDep(i32 1953, i32 1955), !dbg !5972
  call void @printDDep(i32 1953, i32 1955), !dbg !5972
  call void @printDDep(i32 1955, i32 1955), !dbg !5972
  %conv.i26.i1298.i = zext i8 %2901 to i32, !dbg !5972
  %shl.i27.i1299.i = shl i32 %2896, %conv.i26.i1298.i, !dbg !5973
  %2902 = load i32, i32* @Inst_Counter, !dbg !5974
  %2903 = add i32 3, %2902, !dbg !5974
  store i32 %2903, i32* @Inst_Counter, !dbg !5974
  %2904 = load i32, i32* @Inst_Counter, !dbg !5974
  call void @printCounter(i32 %2904), !dbg !5974
  %2905 = ptrtoint i32* %a.addr.i24.i1272.i to i64, !dbg !5974
  call void @printLoadAddr(i64 %2905, i32 1958, i32 92, i32 24), !dbg !5974
  %2906 = load i32, i32* %a.addr.i24.i1272.i, align 4, !dbg !5974
  call void @printDDep(i32 1952, i32 1958), !dbg !5974
  call void @printDDep(i32 1953, i32 1958), !dbg !5974
  call void @printDDep(i32 1958, i32 1958), !dbg !5974
  %2907 = load i32, i32* @Inst_Counter, !dbg !5975
  %2908 = add i32 1, %2907, !dbg !5975
  store i32 %2908, i32* @Inst_Counter, !dbg !5975
  %2909 = load i32, i32* @Inst_Counter, !dbg !5975
  call void @printCounter(i32 %2909), !dbg !5975
  %2910 = ptrtoint i8* %n.addr.i25.i1273.i to i64, !dbg !5975
  call void @printLoadAddr(i64 %2910, i32 1959, i32 92, i32 35), !dbg !5975
  %2911 = load i8, i8* %n.addr.i25.i1273.i, align 1, !dbg !5975
  call void @printDDep(i32 1953, i32 1959), !dbg !5975
  call void @printDDep(i32 1953, i32 1959), !dbg !5975
  call void @printDDep(i32 1959, i32 1959), !dbg !5975
  %conv1.i28.i1300.i = zext i8 %2911 to i32, !dbg !5975
  %sub.i29.i1301.i = sub nsw i32 32, %conv1.i28.i1300.i, !dbg !5976
  %shr.i30.i1302.i = lshr i32 %2906, %sub.i29.i1301.i, !dbg !5977
  %or.i31.i1303.i = or i32 %shl.i27.i1299.i, %shr.i30.i1302.i, !dbg !5978
  %xor10.i1304.i = xor i32 %xor.i1293.i, %or.i31.i1303.i, !dbg !5979
  %2912 = load i32, i32* @Inst_Counter, !dbg !5980
  %2913 = add i32 6, %2912, !dbg !5980
  store i32 %2913, i32* @Inst_Counter, !dbg !5980
  %2914 = load i32, i32* @Inst_Counter, !dbg !5980
  call void @printCounter(i32 %2914), !dbg !5980
  %2915 = ptrtoint i32* %X.addr.i1278.i to i64, !dbg !5980
  call void @printLoadAddr(i64 %2915, i32 1965, i32 131, i32 37), !dbg !5980
  %2916 = load i32, i32* %X.addr.i1278.i, align 4, !dbg !5980
  call void @printDDep(i32 1920, i32 1965), !dbg !5980
  call void @printDDep(i32 1953, i32 1965), !dbg !5980
  call void @printDDep(i32 1965, i32 1965), !dbg !5980
  %conv11.i1305.i = trunc i32 %2916 to i8, !dbg !5981
  %idxprom12.i1306.i = zext i8 %conv11.i1305.i to i64, !dbg !5982
  %arrayidx13.i1307.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1306.i, !dbg !5982
  %2917 = load i32, i32* @Inst_Counter, !dbg !5982
  %2918 = add i32 4, %2917, !dbg !5982
  store i32 %2918, i32* @Inst_Counter, !dbg !5982
  %2919 = load i32, i32* @Inst_Counter, !dbg !5982
  call void @printCounter(i32 %2919), !dbg !5982
  %2920 = ptrtoint i32* %arrayidx13.i1307.i to i64, !dbg !5982
  %2921 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5982
  call void @printSymLoadAddr(i64 %2920, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 1969, i32 131, i32 17), !dbg !5982
  %2922 = load i32, i32* %arrayidx13.i1307.i, align 4, !dbg !5982
  call void @printDDep(i32 1965, i32 1969), !dbg !5982
  call void @printDDep(i32 1969, i32 1969), !dbg !5982
  %2923 = load i32, i32* @Inst_Counter
  %2924 = add i32 1, %2923
  store i32 %2924, i32* @Inst_Counter
  %2925 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2925)
  %2926 = ptrtoint i32* %a.addr.i16.i1274.i to i64
  call void @printStoreAddr(i64 %2926, i32 1970, i32 0, i32 0)
  store i32 %2922, i32* %a.addr.i16.i1274.i, align 4
  call void @printDDep(i32 1969, i32 1970)
  call void @printDDep(i32 1970, i32 1970)
  call void @printDDep(i32 1953, i32 1970)
  call void @printDDep(i32 1970, i32 1970)
  %2927 = load i32, i32* @Inst_Counter
  %2928 = add i32 1, %2927
  store i32 %2928, i32* @Inst_Counter
  %2929 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2929)
  %2930 = ptrtoint i8* %n.addr.i17.i1275.i to i64
  call void @printStoreAddr(i64 %2930, i32 1971, i32 0, i32 0)
  store i8 8, i8* %n.addr.i17.i1275.i, align 1
  call void @printDDep(i32 1971, i32 1971)
  call void @printDDep(i32 1970, i32 1971)
  call void @printDDep(i32 1971, i32 1971)
  %2931 = load i32, i32* @Inst_Counter, !dbg !5983
  %2932 = add i32 1, %2931, !dbg !5983
  store i32 %2932, i32* @Inst_Counter, !dbg !5983
  %2933 = load i32, i32* @Inst_Counter, !dbg !5983
  call void @printCounter(i32 %2933), !dbg !5983
  %2934 = ptrtoint i32* %a.addr.i16.i1274.i to i64, !dbg !5983
  call void @printLoadAddr(i64 %2934, i32 1972, i32 92, i32 13), !dbg !5983
  %2935 = load i32, i32* %a.addr.i16.i1274.i, align 4, !dbg !5983
  call void @printDDep(i32 1970, i32 1972), !dbg !5983
  call void @printDDep(i32 1971, i32 1972), !dbg !5983
  call void @printDDep(i32 1972, i32 1972), !dbg !5983
  %2936 = load i32, i32* @Inst_Counter, !dbg !5984
  %2937 = add i32 1, %2936, !dbg !5984
  store i32 %2937, i32* @Inst_Counter, !dbg !5984
  %2938 = load i32, i32* @Inst_Counter, !dbg !5984
  call void @printCounter(i32 %2938), !dbg !5984
  %2939 = ptrtoint i8* %n.addr.i17.i1275.i to i64, !dbg !5984
  call void @printLoadAddr(i64 %2939, i32 1973, i32 92, i32 18), !dbg !5984
  %2940 = load i8, i8* %n.addr.i17.i1275.i, align 1, !dbg !5984
  call void @printDDep(i32 1971, i32 1973), !dbg !5984
  call void @printDDep(i32 1971, i32 1973), !dbg !5984
  call void @printDDep(i32 1973, i32 1973), !dbg !5984
  %conv.i18.i1308.i = zext i8 %2940 to i32, !dbg !5984
  %shl.i19.i1309.i = shl i32 %2935, %conv.i18.i1308.i, !dbg !5985
  %2941 = load i32, i32* @Inst_Counter, !dbg !5986
  %2942 = add i32 3, %2941, !dbg !5986
  store i32 %2942, i32* @Inst_Counter, !dbg !5986
  %2943 = load i32, i32* @Inst_Counter, !dbg !5986
  call void @printCounter(i32 %2943), !dbg !5986
  %2944 = ptrtoint i32* %a.addr.i16.i1274.i to i64, !dbg !5986
  call void @printLoadAddr(i64 %2944, i32 1976, i32 92, i32 24), !dbg !5986
  %2945 = load i32, i32* %a.addr.i16.i1274.i, align 4, !dbg !5986
  call void @printDDep(i32 1970, i32 1976), !dbg !5986
  call void @printDDep(i32 1971, i32 1976), !dbg !5986
  call void @printDDep(i32 1976, i32 1976), !dbg !5986
  %2946 = load i32, i32* @Inst_Counter, !dbg !5987
  %2947 = add i32 1, %2946, !dbg !5987
  store i32 %2947, i32* @Inst_Counter, !dbg !5987
  %2948 = load i32, i32* @Inst_Counter, !dbg !5987
  call void @printCounter(i32 %2948), !dbg !5987
  %2949 = ptrtoint i8* %n.addr.i17.i1275.i to i64, !dbg !5987
  call void @printLoadAddr(i64 %2949, i32 1977, i32 92, i32 35), !dbg !5987
  %2950 = load i8, i8* %n.addr.i17.i1275.i, align 1, !dbg !5987
  call void @printDDep(i32 1971, i32 1977), !dbg !5987
  call void @printDDep(i32 1971, i32 1977), !dbg !5987
  call void @printDDep(i32 1977, i32 1977), !dbg !5987
  %conv1.i20.i1310.i = zext i8 %2950 to i32, !dbg !5987
  %sub.i21.i1311.i = sub nsw i32 32, %conv1.i20.i1310.i, !dbg !5988
  %shr.i22.i1312.i = lshr i32 %2945, %sub.i21.i1311.i, !dbg !5989
  %or.i23.i1313.i = or i32 %shl.i19.i1309.i, %shr.i22.i1312.i, !dbg !5990
  %xor15.i1314.i = xor i32 %xor10.i1304.i, %or.i23.i1313.i, !dbg !5991
  %2951 = load i32, i32* @Inst_Counter, !dbg !5949
  %2952 = add i32 6, %2951, !dbg !5949
  store i32 %2952, i32* @Inst_Counter, !dbg !5949
  %2953 = load i32, i32* @Inst_Counter, !dbg !5949
  call void @printCounter(i32 %2953), !dbg !5949
  %2954 = ptrtoint i32* %B0.i to i64, !dbg !5949
  call void @printLoadAddr(i64 %2954, i32 1983, i32 202, i32 5), !dbg !5949
  %2955 = load i32, i32* %B0.i, align 4, !dbg !5949
  call void @printDDep(i32 1026, i32 1983), !dbg !5949
  call void @printDDep(i32 1263, i32 1983), !dbg !5949
  call void @printDDep(i32 1681, i32 1983), !dbg !5949
  call void @printDDep(i32 1985, i32 1983), !dbg !5949
  call void @printDDep(i32 2289, i32 1983), !dbg !5949
  call void @printDDep(i32 2593, i32 1983), !dbg !5949
  call void @printDDep(i32 2897, i32 1983), !dbg !5949
  call void @printDDep(i32 3201, i32 1983), !dbg !5949
  call void @printDDep(i32 3543, i32 1983), !dbg !5949
  call void @printDDep(i32 1681, i32 1983), !dbg !5949
  call void @printDDep(i32 1983, i32 1983), !dbg !5949
  %xor67.i = xor i32 %2955, %xor15.i1314.i, !dbg !5949
  %2956 = load i32, i32* @Inst_Counter, !dbg !5949
  %2957 = add i32 2, %2956, !dbg !5949
  store i32 %2957, i32* @Inst_Counter, !dbg !5949
  %2958 = load i32, i32* @Inst_Counter, !dbg !5949
  call void @printCounter(i32 %2958), !dbg !5949
  %2959 = ptrtoint i32* %B0.i to i64, !dbg !5949
  call void @printStoreAddr(i64 %2959, i32 1985, i32 202, i32 5), !dbg !5949
  store i32 %xor67.i, i32* %B0.i, align 4, !dbg !5949
  call void @printDDep(i32 1026, i32 1985), !dbg !5949
  call void @printDDep(i32 1263, i32 1985), !dbg !5949
  call void @printDDep(i32 1681, i32 1985), !dbg !5949
  call void @printDDep(i32 1926, i32 1985), !dbg !5949
  call void @printDDep(i32 1935, i32 1985), !dbg !5949
  call void @printDDep(i32 1936, i32 1985), !dbg !5949
  call void @printDDep(i32 1939, i32 1985), !dbg !5949
  call void @printDDep(i32 1940, i32 1985), !dbg !5949
  call void @printDDep(i32 1954, i32 1985), !dbg !5949
  call void @printDDep(i32 1955, i32 1985), !dbg !5949
  call void @printDDep(i32 1958, i32 1985), !dbg !5949
  call void @printDDep(i32 1959, i32 1985), !dbg !5949
  call void @printDDep(i32 1972, i32 1985), !dbg !5949
  call void @printDDep(i32 1973, i32 1985), !dbg !5949
  call void @printDDep(i32 1976, i32 1985), !dbg !5949
  call void @printDDep(i32 1977, i32 1985), !dbg !5949
  call void @printDDep(i32 1983, i32 1985), !dbg !5949
  call void @printDDep(i32 1985, i32 1985), !dbg !5949
  call void @printDDep(i32 2289, i32 1985), !dbg !5949
  call void @printDDep(i32 2593, i32 1985), !dbg !5949
  call void @printDDep(i32 2897, i32 1985), !dbg !5949
  call void @printDDep(i32 3201, i32 1985), !dbg !5949
  call void @printDDep(i32 3543, i32 1985), !dbg !5949
  call void @printDDep(i32 1971, i32 1985), !dbg !5949
  call void @printDDep(i32 1985, i32 1985), !dbg !5949
  %2960 = load i32, i32* @Inst_Counter, !dbg !5949
  %2961 = add i32 1, %2960, !dbg !5949
  store i32 %2961, i32* @Inst_Counter, !dbg !5949
  %2962 = load i32, i32* @Inst_Counter, !dbg !5949
  call void @printCounter(i32 %2962), !dbg !5949
  %2963 = ptrtoint i32* %B0.i to i64, !dbg !5949
  call void @printLoadAddr(i64 %2963, i32 1986, i32 202, i32 5), !dbg !5949
  %2964 = load i32, i32* %B0.i, align 4, !dbg !5949
  call void @printDDep(i32 1026, i32 1986), !dbg !5949
  call void @printDDep(i32 1263, i32 1986), !dbg !5949
  call void @printDDep(i32 1681, i32 1986), !dbg !5949
  call void @printDDep(i32 1985, i32 1986), !dbg !5949
  call void @printDDep(i32 2289, i32 1986), !dbg !5949
  call void @printDDep(i32 2593, i32 1986), !dbg !5949
  call void @printDDep(i32 2897, i32 1986), !dbg !5949
  call void @printDDep(i32 3201, i32 1986), !dbg !5949
  call void @printDDep(i32 3543, i32 1986), !dbg !5949
  call void @printDDep(i32 1985, i32 1986), !dbg !5949
  call void @printDDep(i32 1986, i32 1986), !dbg !5949
  %2965 = load i32, i32* @Inst_Counter, !dbg !5949
  %2966 = add i32 1, %2965, !dbg !5949
  store i32 %2966, i32* @Inst_Counter, !dbg !5949
  %2967 = load i32, i32* @Inst_Counter, !dbg !5949
  call void @printCounter(i32 %2967), !dbg !5949
  %2968 = ptrtoint i32* %B2.i to i64, !dbg !5949
  call void @printLoadAddr(i64 %2968, i32 1987, i32 202, i32 5), !dbg !5949
  %2969 = load i32, i32* %B2.i, align 4, !dbg !5949
  call void @printDDep(i32 1108, i32 1987), !dbg !5949
  call void @printDDep(i32 1491, i32 1987), !dbg !5949
  call void @printDDep(i32 1833, i32 1987), !dbg !5949
  call void @printDDep(i32 2137, i32 1987), !dbg !5949
  call void @printDDep(i32 2441, i32 1987), !dbg !5949
  call void @printDDep(i32 2745, i32 1987), !dbg !5949
  call void @printDDep(i32 3049, i32 1987), !dbg !5949
  call void @printDDep(i32 3353, i32 1987), !dbg !5949
  call void @printDDep(i32 3771, i32 1987), !dbg !5949
  call void @printDDep(i32 1833, i32 1987), !dbg !5949
  call void @printDDep(i32 1987, i32 1987), !dbg !5949
  %xor68.i = xor i32 %2964, %2969, !dbg !5949
  %2970 = load i32, i32* @Inst_Counter, !dbg !5949
  %2971 = add i32 2, %2970, !dbg !5949
  store i32 %2971, i32* @Inst_Counter, !dbg !5949
  %2972 = load i32, i32* @Inst_Counter, !dbg !5949
  call void @printCounter(i32 %2972), !dbg !5949
  %2973 = ptrtoint i32* %B3.i to i64, !dbg !5949
  call void @printLoadAddr(i64 %2973, i32 1989, i32 202, i32 5), !dbg !5949
  %2974 = load i32, i32* %B3.i, align 4, !dbg !5949
  call void @printDDep(i32 1149, i32 1989), !dbg !5949
  call void @printDDep(i32 1605, i32 1989), !dbg !5949
  call void @printDDep(i32 1909, i32 1989), !dbg !5949
  call void @printDDep(i32 2213, i32 1989), !dbg !5949
  call void @printDDep(i32 2517, i32 1989), !dbg !5949
  call void @printDDep(i32 2821, i32 1989), !dbg !5949
  call void @printDDep(i32 3125, i32 1989), !dbg !5949
  call void @printDDep(i32 3429, i32 1989), !dbg !5949
  call void @printDDep(i32 3885, i32 1989), !dbg !5949
  call void @printDDep(i32 1909, i32 1989), !dbg !5949
  call void @printDDep(i32 1989, i32 1989), !dbg !5949
  %xor69.i = xor i32 %xor68.i, %2974, !dbg !5949
  %2975 = load i32, i32* @Inst_Counter, !dbg !5949
  %2976 = add i32 2, %2975, !dbg !5949
  store i32 %2976, i32* @Inst_Counter, !dbg !5949
  %2977 = load i32, i32* @Inst_Counter, !dbg !5949
  call void @printCounter(i32 %2977), !dbg !5949
  %2978 = ptrtoint %struct.SM4_KEY_st** %ks.addr.i24 to i64, !dbg !5949
  call void @printLoadAddr(i64 %2978, i32 1991, i32 202, i32 5), !dbg !5949
  %2979 = load %struct.SM4_KEY_st*, %struct.SM4_KEY_st** %ks.addr.i24, align 8, !dbg !5949
  call void @printDDep(i32 983, i32 1991), !dbg !5949
  call void @printDDep(i32 985, i32 1991), !dbg !5949
  call void @printDDep(i32 1991, i32 1991), !dbg !5949
  %rk70.i = getelementptr inbounds %struct.SM4_KEY_st, %struct.SM4_KEY_st* %2979, i32 0, i32 0, !dbg !5949
  %arrayidx71.i = getelementptr inbounds [32 x i32], [32 x i32]* %rk70.i, i64 0, i64 9, !dbg !5949
  %2980 = load i32, i32* @Inst_Counter, !dbg !5949
  %2981 = add i32 3, %2980, !dbg !5949
  store i32 %2981, i32* @Inst_Counter, !dbg !5949
  %2982 = load i32, i32* @Inst_Counter, !dbg !5949
  call void @printCounter(i32 %2982), !dbg !5949
  %2983 = ptrtoint i32* %arrayidx71.i to i64, !dbg !5949
  call void @printLoadAddr(i64 %2983, i32 1994, i32 202, i32 5), !dbg !5949
  %2984 = load i32, i32* %arrayidx71.i, align 4, !dbg !5949
  call void @printDDep(i32 1991, i32 1994), !dbg !5949
  call void @printDDep(i32 1985, i32 1994), !dbg !5949
  call void @printDDep(i32 1994, i32 1994), !dbg !5949
  %xor72.i = xor i32 %xor69.i, %2984, !dbg !5949
  %2985 = load i32, i32* @Inst_Counter
  %2986 = add i32 2, %2985
  store i32 %2986, i32* @Inst_Counter
  %2987 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %2987)
  %2988 = ptrtoint i32* %X.addr.i1235.i to i64
  call void @printStoreAddr(i64 %2988, i32 1996, i32 0, i32 0)
  store i32 %xor72.i, i32* %X.addr.i1235.i, align 4
  call void @printDDep(i32 1986, i32 1996)
  call void @printDDep(i32 1987, i32 1996)
  call void @printDDep(i32 1989, i32 1996)
  call void @printDDep(i32 1994, i32 1996)
  call void @printDDep(i32 1996, i32 1996)
  call void @printDDep(i32 1985, i32 1996)
  call void @printDDep(i32 1996, i32 1996)
  %2989 = load i32, i32* @Inst_Counter, !dbg !5992
  %2990 = add i32 1, %2989, !dbg !5992
  store i32 %2990, i32* @Inst_Counter, !dbg !5992
  %2991 = load i32, i32* @Inst_Counter, !dbg !5992
  call void @printCounter(i32 %2991), !dbg !5992
  %2992 = ptrtoint i32* %X.addr.i1235.i to i64, !dbg !5992
  call void @printLoadAddr(i64 %2992, i32 1997, i32 128, i32 33), !dbg !5992
  %2993 = load i32, i32* %X.addr.i1235.i, align 4, !dbg !5992
  call void @printDDep(i32 1996, i32 1997), !dbg !5992
  call void @printDDep(i32 1996, i32 1997), !dbg !5992
  call void @printDDep(i32 1997, i32 1997), !dbg !5992
  %shr.i1236.i = lshr i32 %2993, 24, !dbg !5993
  %conv.i1237.i = trunc i32 %shr.i1236.i to i8, !dbg !5994
  %idxprom.i1238.i = zext i8 %conv.i1237.i to i64, !dbg !5995
  %arrayidx.i1239.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom.i1238.i, !dbg !5995
  %2994 = load i32, i32* @Inst_Counter, !dbg !5995
  %2995 = add i32 5, %2994, !dbg !5995
  store i32 %2995, i32* @Inst_Counter, !dbg !5995
  %2996 = load i32, i32* @Inst_Counter, !dbg !5995
  call void @printCounter(i32 %2996), !dbg !5995
  %2997 = ptrtoint i32* %arrayidx.i1239.i to i64, !dbg !5995
  %2998 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5995
  call void @printSymLoadAddr(i64 %2997, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 2002, i32 128, i32 12), !dbg !5995
  %2999 = load i32, i32* %arrayidx.i1239.i, align 4, !dbg !5995
  call void @printDDep(i32 1997, i32 2002), !dbg !5995
  call void @printDDep(i32 2002, i32 2002), !dbg !5995
  %3000 = load i32, i32* @Inst_Counter, !dbg !5996
  %3001 = add i32 1, %3000, !dbg !5996
  store i32 %3001, i32* @Inst_Counter, !dbg !5996
  %3002 = load i32, i32* @Inst_Counter, !dbg !5996
  call void @printCounter(i32 %3002), !dbg !5996
  %3003 = ptrtoint i32* %X.addr.i1235.i to i64, !dbg !5996
  call void @printLoadAddr(i64 %3003, i32 2003, i32 129, i32 38), !dbg !5996
  %3004 = load i32, i32* %X.addr.i1235.i, align 4, !dbg !5996
  call void @printDDep(i32 1996, i32 2003), !dbg !5996
  call void @printDDep(i32 1996, i32 2003), !dbg !5996
  call void @printDDep(i32 2003, i32 2003), !dbg !5996
  %shr1.i1240.i = lshr i32 %3004, 16, !dbg !5997
  %conv2.i1241.i = trunc i32 %shr1.i1240.i to i8, !dbg !5998
  %idxprom3.i1242.i = zext i8 %conv2.i1241.i to i64, !dbg !5999
  %arrayidx4.i1243.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom3.i1242.i, !dbg !5999
  %3005 = load i32, i32* @Inst_Counter, !dbg !5999
  %3006 = add i32 5, %3005, !dbg !5999
  store i32 %3006, i32* @Inst_Counter, !dbg !5999
  %3007 = load i32, i32* @Inst_Counter, !dbg !5999
  call void @printCounter(i32 %3007), !dbg !5999
  %3008 = ptrtoint i32* %arrayidx4.i1243.i to i64, !dbg !5999
  %3009 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !5999
  call void @printSymLoadAddr(i64 %3008, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 2008, i32 129, i32 17), !dbg !5999
  %3010 = load i32, i32* %arrayidx4.i1243.i, align 4, !dbg !5999
  call void @printDDep(i32 2003, i32 2008), !dbg !5999
  call void @printDDep(i32 2008, i32 2008), !dbg !5999
  %3011 = load i32, i32* @Inst_Counter
  %3012 = add i32 1, %3011
  store i32 %3012, i32* @Inst_Counter
  %3013 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %3013)
  %3014 = ptrtoint i32* %a.addr.i.i1233.i to i64
  call void @printStoreAddr(i64 %3014, i32 2009, i32 0, i32 0)
  store i32 %3010, i32* %a.addr.i.i1233.i, align 4
  call void @printDDep(i32 2008, i32 2009)
  call void @printDDep(i32 2009, i32 2009)
  call void @printDDep(i32 1996, i32 2009)
  call void @printDDep(i32 2009, i32 2009)
  %3015 = load i32, i32* @Inst_Counter
  %3016 = add i32 1, %3015
  store i32 %3016, i32* @Inst_Counter
  %3017 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %3017)
  %3018 = ptrtoint i8* %n.addr.i.i1234.i to i64
  call void @printStoreAddr(i64 %3018, i32 2010, i32 0, i32 0)
  store i8 24, i8* %n.addr.i.i1234.i, align 1
  call void @printDDep(i32 2010, i32 2010)
  call void @printDDep(i32 2009, i32 2010)
  call void @printDDep(i32 2010, i32 2010)
  %3019 = load i32, i32* @Inst_Counter, !dbg !6000
  %3020 = add i32 1, %3019, !dbg !6000
  store i32 %3020, i32* @Inst_Counter, !dbg !6000
  %3021 = load i32, i32* @Inst_Counter, !dbg !6000
  call void @printCounter(i32 %3021), !dbg !6000
  %3022 = ptrtoint i32* %a.addr.i.i1233.i to i64, !dbg !6000
  call void @printLoadAddr(i64 %3022, i32 2011, i32 92, i32 13), !dbg !6000
  %3023 = load i32, i32* %a.addr.i.i1233.i, align 4, !dbg !6000
  call void @printDDep(i32 2009, i32 2011), !dbg !6000
  call void @printDDep(i32 2010, i32 2011), !dbg !6000
  call void @printDDep(i32 2011, i32 2011), !dbg !6000
  %3024 = load i32, i32* @Inst_Counter, !dbg !6001
  %3025 = add i32 1, %3024, !dbg !6001
  store i32 %3025, i32* @Inst_Counter, !dbg !6001
  %3026 = load i32, i32* @Inst_Counter, !dbg !6001
  call void @printCounter(i32 %3026), !dbg !6001
  %3027 = ptrtoint i8* %n.addr.i.i1234.i to i64, !dbg !6001
  call void @printLoadAddr(i64 %3027, i32 2012, i32 92, i32 18), !dbg !6001
  %3028 = load i8, i8* %n.addr.i.i1234.i, align 1, !dbg !6001
  call void @printDDep(i32 2010, i32 2012), !dbg !6001
  call void @printDDep(i32 2010, i32 2012), !dbg !6001
  call void @printDDep(i32 2012, i32 2012), !dbg !6001
  %conv.i.i1244.i = zext i8 %3028 to i32, !dbg !6001
  %shl.i.i1245.i = shl i32 %3023, %conv.i.i1244.i, !dbg !6002
  %3029 = load i32, i32* @Inst_Counter, !dbg !6003
  %3030 = add i32 3, %3029, !dbg !6003
  store i32 %3030, i32* @Inst_Counter, !dbg !6003
  %3031 = load i32, i32* @Inst_Counter, !dbg !6003
  call void @printCounter(i32 %3031), !dbg !6003
  %3032 = ptrtoint i32* %a.addr.i.i1233.i to i64, !dbg !6003
  call void @printLoadAddr(i64 %3032, i32 2015, i32 92, i32 24), !dbg !6003
  %3033 = load i32, i32* %a.addr.i.i1233.i, align 4, !dbg !6003
  call void @printDDep(i32 2009, i32 2015), !dbg !6003
  call void @printDDep(i32 2010, i32 2015), !dbg !6003
  call void @printDDep(i32 2015, i32 2015), !dbg !6003
  %3034 = load i32, i32* @Inst_Counter, !dbg !6004
  %3035 = add i32 1, %3034, !dbg !6004
  store i32 %3035, i32* @Inst_Counter, !dbg !6004
  %3036 = load i32, i32* @Inst_Counter, !dbg !6004
  call void @printCounter(i32 %3036), !dbg !6004
  %3037 = ptrtoint i8* %n.addr.i.i1234.i to i64, !dbg !6004
  call void @printLoadAddr(i64 %3037, i32 2016, i32 92, i32 35), !dbg !6004
  %3038 = load i8, i8* %n.addr.i.i1234.i, align 1, !dbg !6004
  call void @printDDep(i32 2010, i32 2016), !dbg !6004
  call void @printDDep(i32 2010, i32 2016), !dbg !6004
  call void @printDDep(i32 2016, i32 2016), !dbg !6004
  %conv1.i.i1246.i = zext i8 %3038 to i32, !dbg !6004
  %sub.i.i1247.i = sub nsw i32 32, %conv1.i.i1246.i, !dbg !6005
  %shr.i.i1248.i = lshr i32 %3033, %sub.i.i1247.i, !dbg !6006
  %or.i.i1249.i = or i32 %shl.i.i1245.i, %shr.i.i1248.i, !dbg !6007
  %xor.i1250.i = xor i32 %2999, %or.i.i1249.i, !dbg !6008
  %3039 = load i32, i32* @Inst_Counter, !dbg !6009
  %3040 = add i32 6, %3039, !dbg !6009
  store i32 %3040, i32* @Inst_Counter, !dbg !6009
  %3041 = load i32, i32* @Inst_Counter, !dbg !6009
  call void @printCounter(i32 %3041), !dbg !6009
  %3042 = ptrtoint i32* %X.addr.i1235.i to i64, !dbg !6009
  call void @printLoadAddr(i64 %3042, i32 2022, i32 130, i32 38), !dbg !6009
  %3043 = load i32, i32* %X.addr.i1235.i, align 4, !dbg !6009
  call void @printDDep(i32 1996, i32 2022), !dbg !6009
  call void @printDDep(i32 2010, i32 2022), !dbg !6009
  call void @printDDep(i32 2022, i32 2022), !dbg !6009
  %shr5.i1251.i = lshr i32 %3043, 8, !dbg !6010
  %conv6.i1252.i = trunc i32 %shr5.i1251.i to i8, !dbg !6011
  %idxprom7.i1253.i = zext i8 %conv6.i1252.i to i64, !dbg !6012
  %arrayidx8.i1254.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom7.i1253.i, !dbg !6012
  %3044 = load i32, i32* @Inst_Counter, !dbg !6012
  %3045 = add i32 5, %3044, !dbg !6012
  store i32 %3045, i32* @Inst_Counter, !dbg !6012
  %3046 = load i32, i32* @Inst_Counter, !dbg !6012
  call void @printCounter(i32 %3046), !dbg !6012
  %3047 = ptrtoint i32* %arrayidx8.i1254.i to i64, !dbg !6012
  %3048 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !6012
  call void @printSymLoadAddr(i64 %3047, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 2027, i32 130, i32 17), !dbg !6012
  %3049 = load i32, i32* %arrayidx8.i1254.i, align 4, !dbg !6012
  call void @printDDep(i32 2022, i32 2027), !dbg !6012
  call void @printDDep(i32 2027, i32 2027), !dbg !6012
  %3050 = load i32, i32* @Inst_Counter
  %3051 = add i32 1, %3050
  store i32 %3051, i32* @Inst_Counter
  %3052 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %3052)
  %3053 = ptrtoint i32* %a.addr.i24.i1229.i to i64
  call void @printStoreAddr(i64 %3053, i32 2028, i32 0, i32 0)
  store i32 %3049, i32* %a.addr.i24.i1229.i, align 4
  call void @printDDep(i32 2027, i32 2028)
  call void @printDDep(i32 2028, i32 2028)
  call void @printDDep(i32 2010, i32 2028)
  call void @printDDep(i32 2028, i32 2028)
  %3054 = load i32, i32* @Inst_Counter
  %3055 = add i32 1, %3054
  store i32 %3055, i32* @Inst_Counter
  %3056 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %3056)
  %3057 = ptrtoint i8* %n.addr.i25.i1230.i to i64
  call void @printStoreAddr(i64 %3057, i32 2029, i32 0, i32 0)
  store i8 16, i8* %n.addr.i25.i1230.i, align 1
  call void @printDDep(i32 2029, i32 2029)
  call void @printDDep(i32 2028, i32 2029)
  call void @printDDep(i32 2029, i32 2029)
  %3058 = load i32, i32* @Inst_Counter, !dbg !6013
  %3059 = add i32 1, %3058, !dbg !6013
  store i32 %3059, i32* @Inst_Counter, !dbg !6013
  %3060 = load i32, i32* @Inst_Counter, !dbg !6013
  call void @printCounter(i32 %3060), !dbg !6013
  %3061 = ptrtoint i32* %a.addr.i24.i1229.i to i64, !dbg !6013
  call void @printLoadAddr(i64 %3061, i32 2030, i32 92, i32 13), !dbg !6013
  %3062 = load i32, i32* %a.addr.i24.i1229.i, align 4, !dbg !6013
  call void @printDDep(i32 2028, i32 2030), !dbg !6013
  call void @printDDep(i32 2029, i32 2030), !dbg !6013
  call void @printDDep(i32 2030, i32 2030), !dbg !6013
  %3063 = load i32, i32* @Inst_Counter, !dbg !6014
  %3064 = add i32 1, %3063, !dbg !6014
  store i32 %3064, i32* @Inst_Counter, !dbg !6014
  %3065 = load i32, i32* @Inst_Counter, !dbg !6014
  call void @printCounter(i32 %3065), !dbg !6014
  %3066 = ptrtoint i8* %n.addr.i25.i1230.i to i64, !dbg !6014
  call void @printLoadAddr(i64 %3066, i32 2031, i32 92, i32 18), !dbg !6014
  %3067 = load i8, i8* %n.addr.i25.i1230.i, align 1, !dbg !6014
  call void @printDDep(i32 2029, i32 2031), !dbg !6014
  call void @printDDep(i32 2029, i32 2031), !dbg !6014
  call void @printDDep(i32 2031, i32 2031), !dbg !6014
  %conv.i26.i1255.i = zext i8 %3067 to i32, !dbg !6014
  %shl.i27.i1256.i = shl i32 %3062, %conv.i26.i1255.i, !dbg !6015
  %3068 = load i32, i32* @Inst_Counter, !dbg !6016
  %3069 = add i32 3, %3068, !dbg !6016
  store i32 %3069, i32* @Inst_Counter, !dbg !6016
  %3070 = load i32, i32* @Inst_Counter, !dbg !6016
  call void @printCounter(i32 %3070), !dbg !6016
  %3071 = ptrtoint i32* %a.addr.i24.i1229.i to i64, !dbg !6016
  call void @printLoadAddr(i64 %3071, i32 2034, i32 92, i32 24), !dbg !6016
  %3072 = load i32, i32* %a.addr.i24.i1229.i, align 4, !dbg !6016
  call void @printDDep(i32 2028, i32 2034), !dbg !6016
  call void @printDDep(i32 2029, i32 2034), !dbg !6016
  call void @printDDep(i32 2034, i32 2034), !dbg !6016
  %3073 = load i32, i32* @Inst_Counter, !dbg !6017
  %3074 = add i32 1, %3073, !dbg !6017
  store i32 %3074, i32* @Inst_Counter, !dbg !6017
  %3075 = load i32, i32* @Inst_Counter, !dbg !6017
  call void @printCounter(i32 %3075), !dbg !6017
  %3076 = ptrtoint i8* %n.addr.i25.i1230.i to i64, !dbg !6017
  call void @printLoadAddr(i64 %3076, i32 2035, i32 92, i32 35), !dbg !6017
  %3077 = load i8, i8* %n.addr.i25.i1230.i, align 1, !dbg !6017
  call void @printDDep(i32 2029, i32 2035), !dbg !6017
  call void @printDDep(i32 2029, i32 2035), !dbg !6017
  call void @printDDep(i32 2035, i32 2035), !dbg !6017
  %conv1.i28.i1257.i = zext i8 %3077 to i32, !dbg !6017
  %sub.i29.i1258.i = sub nsw i32 32, %conv1.i28.i1257.i, !dbg !6018
  %shr.i30.i1259.i = lshr i32 %3072, %sub.i29.i1258.i, !dbg !6019
  %or.i31.i1260.i = or i32 %shl.i27.i1256.i, %shr.i30.i1259.i, !dbg !6020
  %xor10.i1261.i = xor i32 %xor.i1250.i, %or.i31.i1260.i, !dbg !6021
  %3078 = load i32, i32* @Inst_Counter, !dbg !6022
  %3079 = add i32 6, %3078, !dbg !6022
  store i32 %3079, i32* @Inst_Counter, !dbg !6022
  %3080 = load i32, i32* @Inst_Counter, !dbg !6022
  call void @printCounter(i32 %3080), !dbg !6022
  %3081 = ptrtoint i32* %X.addr.i1235.i to i64, !dbg !6022
  call void @printLoadAddr(i64 %3081, i32 2041, i32 131, i32 37), !dbg !6022
  %3082 = load i32, i32* %X.addr.i1235.i, align 4, !dbg !6022
  call void @printDDep(i32 1996, i32 2041), !dbg !6022
  call void @printDDep(i32 2029, i32 2041), !dbg !6022
  call void @printDDep(i32 2041, i32 2041), !dbg !6022
  %conv11.i1262.i = trunc i32 %3082 to i8, !dbg !6023
  %idxprom12.i1263.i = zext i8 %conv11.i1262.i to i64, !dbg !6024
  %arrayidx13.i1264.i = getelementptr inbounds [256 x i32], [256 x i32]* @SM4_SBOX_T, i64 0, i64 %idxprom12.i1263.i, !dbg !6024
  %3083 = load i32, i32* @Inst_Counter, !dbg !6024
  %3084 = add i32 4, %3083, !dbg !6024
  store i32 %3084, i32* @Inst_Counter, !dbg !6024
  %3085 = load i32, i32* @Inst_Counter, !dbg !6024
  call void @printCounter(i32 %3085), !dbg !6024
  %3086 = ptrtoint i32* %arrayidx13.i1264.i to i64, !dbg !6024
  %3087 = load [256 x i32], [256 x i32]* @SM4_SBOX_T, !dbg !6024
  call void @printSymLoadAddr(i64 %3086, i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 add (i64 ptrtoint ([256 x i32]* @SM4_SBOX_T to i64), i64 1020), i32 4, i32 2045, i32 131, i32 17), !dbg !6024
  %3088 = load i32, i32* %arrayidx13.i1264.i, align 4, !dbg !6024
  call void @printDDep(i32 2041, i32 2045), !dbg !6024
  call void @printDDep(i32 2045, i32 2045), !dbg !6024
  %3089 = load i32, i32* @Inst_Counter
  %3090 = add i32 1, %3089
  store i32 %3090, i32* @Inst_Counter
  %3091 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %3091)
  %3092 = ptrtoint i32* %a.addr.i16.i1231.i to i64
  call void @printStoreAddr(i64 %3092, i32 2046, i32 0, i32 0)
  store i32 %3088, i32* %a.addr.i16.i1231.i, align 4
  call void @printDDep(i32 2045, i32 2046)
  call void @printDDep(i32 2046, i32 2046)
  call void @printDDep(i32 2029, i32 2046)
  call void @printDDep(i32 2046, i32 2046)
  %3093 = load i32, i32* @Inst_Counter
  %3094 = add i32 1, %3093
  store i32 %3094, i32* @Inst_Counter
  %3095 = load i32, i32* @Inst_Counter
  call void @printCounter(i32 %3095)
  %3096 = ptrtoint i8* %n.addr.i17.i1232.i to i64
