#!/bin/bash

clang-10 -O0 -emit-llvm -c -g Cipher/aes.c -o bc/Cipher/aes.bc
llvm-link-10 bc/Cipher/aes.bc bc/TRACE_test.bc -o bc/Cipher/aes-trace.bc

clang-10 -O0 -emit-llvm -c -g Cipher/des_enc.c -o bc/Cipher/des_enc.bc
clang-10 -O0 -emit-llvm -c -g Cipher/des_set_key.c -o bc/Cipher/des_set_key.bc
llvm-link-10 bc/Cipher/des_set_key.bc bc/Cipher/des_enc.bc bc/TRACE_test.bc -o bc/Cipher/des-trace.bc

clang-10 -O0 -emit-llvm -c -g Cipher/seed.c -o bc/Cipher/seed.bc
llvm-link-10 bc/Cipher/seed.bc bc/TRACE_test.bc -o bc/Cipher/seed-trace.bc

clang-10 -O0 -emit-llvm -c -g Cipher/camellia.c -o bc/Cipher/camellia.bc
llvm-link-10 bc/Cipher/camellia.bc bc/TRACE_test.bc -o bc/Cipher/camellia-trace.bc

clang-10 -O0 -emit-llvm -c -g Cipher/chacha_enc_ctr32.c -o bc/Cipher/chacha20.bc
llvm-link-10 bc/Cipher/chacha20.bc bc/TRACE_test.bc -o bc/Cipher/chacha20-trace.bc

clang-10 -O0 -emit-llvm -c -g Cipher/idea.c -o bc/Cipher/idea.bc
llvm-link-10 bc/Cipher/idea.bc bc/TRACE_test.bc -o bc/Cipher/idea-trace.bc

clang-10 -O0 -emit-llvm -c -g Cipher/aria.c -o bc/Cipher/aria.bc
llvm-link-10 bc/Cipher/aria.bc bc/TRACE_test.bc -o bc/Cipher/aria-trace.bc

clang-10 -O0 -emit-llvm -c -g Cipher/sm4.c -o bc/Cipher/sm4.bc
llvm-link-10 bc/Cipher/sm4.bc bc/TRACE_test.bc -o bc/Cipher/sm4-trace.bc

clang-10 -O0 -emit-llvm -c -g Hash/md5_dgst.c -o bc/Hash/md5_dgst.bc
clang-10 -O0 -emit-llvm -c -g Hash/md5_one.c -o bc/Hash/md5_one.bc
llvm-link-10 bc/Hash/md5_dgst.bc bc/Hash/md5_one.bc bc/TRACE_test.bc -o bc/Hash/md5-trace.bc

clang-10 -O0 -emit-llvm -c -g Hash/sha256.c -o bc/Hash/sha256.bc
llvm-link-10 bc/Hash/sha256.bc bc/TRACE_test.bc -o bc/Hash/sha256-trace.bc

clang-10 -O0 -emit-llvm -c -g Hash/wp_dgst.c -o bc/Hash/wp_dgst.bc
clang-10 -O0 -emit-llvm -c -g Hash/wp_block.c -o bc/Hash/wp_block.bc
llvm-link-10 bc/Hash/wp_dgst.bc bc/Hash/wp_block.bc bc/TRACE_test.bc -o bc/Hash/whirlpool-trace.bc

clang-10 -O0 -emit-llvm -c -g Hash/blake2b.c -o bc/Hash/blake2b.bc
llvm-link-10 bc/Hash/blake2b.bc bc/TRACE_test.bc -o bc/Hash/blake2-trace.bc
