% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{setConfigElement}
\alias{setConfigElement}
\title{setConfigElement}
\usage{
setConfigElement(name, value)
}
\arguments{
\item{name}{name of the config item}

\item{value}{value of the config item}
}
\value{
nothing of particular interest.
}
\description{
Set a configuration item to a given value
}
\section{Options used by the package}{

\describe{
  \item{\bold{\code{tmpDir}}\code{ = temdir()}}{
       Directory for temporary files. Must be existing.
  }
  \item{\bold{\code{cleanMem}}\code{ = TRUE}}{
       During runtime, regularly clean-out the memory in order to reduce memory overuse
  }
  \item{\bold{\code{colorSchemes}}}{
      named \code{list} of DISCRETE color schemes to be used for plotting. Each element should be a named vector specifying colors for groups/annotations.
  }
  \item{\bold{\code{colorSchemesCont}}}{
      named \code{list} of CONTINOUS color schemes to be used for plotting. Each element should be a vector specifying a range of colors.
  }
  \item{\bold{\code{geneModelVersions}}}{
      Gene model versions to be used for various genomes
  }
  \item{\bold{\code{analysisName}}\code{ = "ChrAccR analysis"}}{
      A title for the analysis (a string).
  }
  \item{\bold{\code{regionTypes}}}{
      Region types to be used in the analysis
  }
  \item{\bold{\code{chromVarRegionTypes}}\code{ = NULL}}{
      Region types to be used for chromVar analysis. If \code{NULL} (default), ChrAccR will automatically look for region types with the keyword \code{"peak"} in their name.
  }
	 \item{\bold{\code{chromVarMotifs}}\code{ = "jaspar_vert"}}{
      Character vector of names of TF motif sets to be used in ChromVAR analyses. By default the vertebrate set of the JASPAR database will be used.
  }
  \item{\bold{\code{chromVarMotifNamesForDimRed}}}{
      Names of motifs to be used for dimension reduction plots in the reports. [only relevant for single-cell data]
  }
  \item{\bold{\code{genesOfInterest}}}{
      Names of genes of interest to be highlighted in the reports (e.g. dimension reduction) in the reports.
      [currently only relevant for single-cell data and only when \code{scGeneActivity} is activated]
  }
  \item{\bold{\code{annotationColumns}}}{
      Sample annotation columns to be used for reporting
  }
  \item{\bold{\code{annotationMinGroupSize}}\code{ = 2}}{
      Minimum size of a group to be used in the reports. Influences which annotation columns are automatically selected for reporting.
  }
  \item{\bold{\code{annotationMaxGroupCount}}\code{ = 20}}{
      Maximum number of groups to be used in the reports. Influences which annotation columns are automatically selected for reporting.
  }
  \item{\bold{\code{doPeakCalling}}\code{ = FALSE}}{
      Perform per-sample peak calling and retrieve consensus peak set. Requires that \code{macs2} is installed and can be called from the command line. [for bulk data analysis only]
  }
  \item{\bold{\code{annotationPeakGroupColumn}}}{
      Annotation column to base the consensus peak set replication filtering on.
  }
  \item{\bold{\code{annotationPeakGroupAgreePerc}}\code{ = 1.0}}{
      Percent of samples that have to agree to identify consensus peaks. See \code{\link{getConsensusPeakSet}} for details.
  }
  \item{\bold{\code{filteringCovgCount}}\code{ = 1L}}{
      Minimum insertion count to filter count matrices by. See \code{\link{filterLowCovg,DsATAC-method}} for details. [for bulk data analysis only]
  }
  \item{\bold{\code{filteringCovgReqSamples}}\code{ = 0.75}}{
      Minimum required samples to apply low coverage filtering to. See \code{\link{filterLowCovg,DsATAC-method}} for details. [for bulk data analysis only]
  }
  \item{\bold{\code{filteringSexChroms}}\code{ = FALSE}}{
      Flag indicating whether to remove sex chromosomes.
  }
  \item{\bold{\code{filteringScMinFragmentsPerCell}}\code{ = 1000L}}{
      Minimum number of fragments per cell to retain a cell in the analysis. [for single-cell data analysis only]
  }
  \item{\bold{\code{filteringScMaxFragmentsPerCell}}\code{ = Inf}}{
      Maximum number of fragments allowed per cell to retain a cell in the analysis. [for single-cell data analysis only]
  }
  \item{\bold{\code{filteringScMinTssEnrichment}}\code{ = 6}}{
      Minimum TSS enrichment score per cell to retain a cell in the analysis. [for single-cell data analysis only]
  }
  \item{\bold{\code{normalizationMethod}}\code{ = "quantile"}}{
      Normalization method to use for count normalization. Allowed methods include the ones listed in \code{\link{transformCounts,DsATAC-method}}. [for bulk data analysis only]
  }
  \item{\bold{\code{exploratoryLogNormCounts}}\code{ = TRUE}}{
      Should a log-normalization be applied in the exploratory plot sections of the reports (dimension reduction, heatmaps)
  }
  \item{\bold{\code{exploratoryNSubsample}}\code{ = 2e6}}{
      Number of regions to subsample in exploratory analysis in order to increase computational performance.
  }
  \item{\bold{\code{differentialColumns}}}{
      Sample annotation columns to be used for differential testing and reporting
  }
  \item{\bold{\code{differentialColumns1vsAll}}}{
      Sample annotation columns to be used for differential testing and reporting in a 1-vs-all group setting. Should be a subset of \code{differentialColumns}.
  }
  \item{\bold{\code{differentialCompNames}}}{
      Comparison names from which comparison information is derived. Must be in the format of "$GRP1_NAME vs $GRP2_NAME [$ANNOTATION_COLUMN]".
  }
  \item{\bold{\code{differentialAdjColumns}}}{
      Sample annotation columns to be adjusted for in differential testing
  }
  \item{\bold{\code{lolaDbPaths}}}{
      Precomputed LOLA databases to be used for enrichment analysis. If \code{NULL} (default), ChrAccR will download an apropriate core database.
  }
  \item{\bold{\code{scIterativeLsiRegType}}}{
      For single-cell analysis only: region type to be used for clustering and dimension reduction using iterative LSI. By default (\code{NULL}),
      ChrAccR will look for a region type named \code{"tiling"}.
  }
  \item{\bold{\code{scIterativeLsiClusterResolution}}\code{ = 0.4}}{
      For single-cell analysis only: Cluster resolution to use for iterative LSI.
  }
  \item{\bold{\code{scIterativeLsiUmapParams}}\code{ = list(distMethod="euclidean", min_dist=0.5, n_neighbors=25)}}{
      For single-cell analysis only: UMAP parameters to use for iterative LSI (final embedding).
  }
  \item{\bold{\code{scGeneActivity}}\code{ = FALSE}}{
      For single-cell analysis only: Compute gene activity from accessibility.
      Possible options are \code{"RBF"} for radial-basis-function-weighted count aggregation (default when set to \code{TRUE}) or 
      \code{"Cicero"} for Cicero correlation-based aggregation
  }
}
}

\author{
Fabian Mueller
}
