% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow.R
\name{run_atac}
\alias{run_atac}
\title{run_atac}
\usage{
run_atac(
  anaDir,
  input = NULL,
  sampleAnnot = NULL,
  genome = NULL,
  sampleIdCol = NULL,
  regionSets = NULL,
  startStage = "raw",
  resetStage = NULL
)
}
\arguments{
\item{anaDir}{analysis directory}

\item{input}{Input object. Can be either \code{NULL}, a character string, a \code{DsATAC}. Set to \code{NULL} when you want to continue a previous analysis}

\item{sampleAnnot}{sample annotation table (\code{data.frame}) or \code{NULL} if continuing existing analysis or input is a \code{DsATAC} object}

\item{genome}{genome assembly. Only relevant if not continuing existing analysis and input is not a \code{DsATAC} object}

\item{sampleIdCol}{column name in the sample annotation table containing unique sample Only relevant if not continuing existing analysis and input is not a \code{DsATAC} object}

\item{regionSets}{a list of GRanges objects which contain region sets over which count data will be aggregated. Only relevant if not continuing existing analysis and input is not a \code{DsATAC} object}

\item{startStage}{stage where to start the analysis from. can be one of \code{"raw"}, \code{"filtered"}, \code{"processed"}. Only relevant if not continuing existing analysis.}

\item{resetStage}{flag indicating whether to reset the analysis directory (i.e. deleting previously generated reports and datasets), when continuing previous analyses (\code{input} argument is \code{NULL}).}
}
\value{
\code{\linkS4class{DsATAC}} object (invisible)
}
\description{
Run the complete ChrAccR analysis for ATAC-seq data
}
\author{
Fabian Mueller
}
