% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DsNOMe-class.R
\docType{methods}
\name{regionAggregation,DsNOMe-method}
\alias{regionAggregation,DsNOMe-method}
\alias{regionAggregation}
\title{regionAggregation-methods}
\usage{
\S4method{regionAggregation}{DsNOMe}(
  .object,
  regGr,
  type,
  methAggrFun = "weightedMean",
  dropEmpty = TRUE
)
}
\arguments{
\item{.object}{\code{\linkS4class{DsNOMe}} object}

\item{regGr}{\code{GRanges} object containing regions to summarize}

\item{type}{character string specifying a name for the region type}

\item{methAggrFun}{aggregation function for methylation levels.
Currently \code{mean}, \code{median}
and \code{weightedMean} (default) are supported.}

\item{dropEmpty}{discard all regions with no observed methylation levels}
}
\value{
a new \code{\linkS4class{DsNOMe}} object with aggregated regions
}
\description{
Aggregate methylation levels and coverage values accross a set of regions
}
\details{
Coverage values are aggregated by summing up coverage values for individual GCs
while the aggregation function for methylation levels is specified by the
\code{methAggrFun} parameter.
}
\author{
Fabian Mueller
}
