% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DsATAC-class.R
\docType{methods}
\name{getQuickTssEnrichment,DsATAC-method}
\alias{getQuickTssEnrichment,DsATAC-method}
\alias{getQuickTssEnrichment}
\title{getQuickTssEnrichment-methods}
\usage{
\S4method{getQuickTssEnrichment}{DsATAC}(
  .object,
  tssGr = NULL,
  sampleIds = getSamples(.object),
  tssW = 201L,
  distBg = 1900L
)
}
\arguments{
\item{.object}{\code{\linkS4class{DsATAC}} object}

\item{tssGr}{\code{GRanges} object containing TSS coordinates}

\item{sampleIds}{sampleIds for which TSS enrichment should be computed}

\item{tssW}{width to consider arount the TSS}

\item{distBg}{number of bases flanking each TSS that will be added on each side}
}
\value{
a vector of TSS enrichment values for each sample/cell in the dataset
}
\description{
[Experimental] Quick, heuristic version of TSS enrichment to just get scores for each
sample in the dataset. Useful, e.g. for single cells.
}
\details{
Computes TSS enrichment
as the ratio of total insertion sites at a window (of width \code{tssW} bp) directly at the TSS and 2 background regions
symmetrically located (\code{distBg} bp) upstream and downstream of the TSS
}
\author{
Fabian Mueller
}
