% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_atac.R
\name{getPeakSet.snakeATAC}
\alias{getPeakSet.snakeATAC}
\title{getPeakSet.snakeATAC}
\usage{
getPeakSet.snakeATAC(
  sampleAnnot,
  filePrefixCol,
  genome,
  dataDir,
  sampleIdCol = filePrefixCol,
  type = "summits_no_fw",
  unifWidth = 500L,
  replicateCol = NA,
  replicatePercReq = 1,
  replicateConsSelect = FALSE,
  keepOvInfo = FALSE
)
}
\arguments{
\item{sampleAnnot}{data.frame specifying the sample annotation table}

\item{filePrefixCol}{column name specifying the file prefix for each sample in the sample annotation table}

\item{genome}{genome assembly}

\item{dataDir}{directory where the files are located}

\item{sampleIdCol}{column name or index in the sample annotation table containing unique sample identifiers}

\item{type}{input data type. Currently only "summits_no_fw" (non-overlapping, fixed-width peaks deduced from summits)}

\item{unifWidth}{width of the peaks if the results have uniform peak lengths}

\item{replicateCol}{column name specifying the replicate group for cross-checking coverage across replicates}

\item{replicatePercReq}{percentile of replicates in a group required to contain a peak in order to keep it.
E.g. a value of 1 (default) means that all replicates in a group are required to contain that peak in order
to keep it.}

\item{replicateConsSelect}{if set, the peak set will also be checked for consistency, i.e. in order to retain a peak
it has to be consistently be present or absent in each replicate group (as specified in \code{replicatePercReq} percent of samples)}

\item{keepOvInfo}{keep annotation columns in the elementMetadata of the results specifying whether a consensus peak overlaps with a
peak in each sample}
}
\value{
\code{GRanges} object containing consensus peak set
}
\description{
Retrieve a consensus set of ATAC peaks from the snakeATAC pipline run
}
\author{
Fabian Mueller
}
