% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DsATAC-class.R
\docType{methods}
\name{getDiffAcc,DsATAC-method}
\alias{getDiffAcc,DsATAC-method}
\alias{getDiffAcc}
\title{getDiffAcc-methods}
\usage{
\S4method{getDiffAcc}{DsATAC}(
  .object,
  regionType,
  comparisonCol,
  grp1Name = NULL,
  grp2Name = NULL,
  adjustCols = character(0),
  method = "DESeq2",
  diffObj = NULL
)
}
\arguments{
\item{.object}{\code{\linkS4class{DsATAC}} object}

\item{regionType}{character string specifying the region type}

\item{comparisonCol}{column name in the sample annotation table to base the comparison on}

\item{grp1Name}{name of the first group in the comparison. if not specified, it will be taken as the first factor level specified in the 
sample annotation table in \code{'comparisonCol'}.}

\item{grp2Name}{name of the second group (reference) in the comparison. if not specified, it will be taken as the first factor level specified in the 
sample annotation table in \code{'comparisonCol'}.}

\item{adjustCols}{column names in the sample annotation potentially used to create the design matrix}

\item{method}{Method for determining differential accessibility. Currently only \code{'DESeq2'} is supported}

\item{diffObj}{optional differential object to avoid computing it for each comparison and thus reduce runtime}
}
\value{
a \code{data.frame} containing differential accessibility information
}
\description{
Compute differential accessibility
}
\examples{
\dontrun{
dsa <- ChrAccRex::loadExample("dsAtac_ia_example")
daTab <- getDiffAcc(dsa, "IA_prog_peaks", "stimulus", grp1Name="S", grp2Name="U", adjustCols=c("cellType", "donor"))
}
}
\author{
Fabian Mueller
}
