% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_atac.R
\name{getConsensusPeakSet}
\alias{getConsensusPeakSet}
\title{getConsensusPeakSet}
\usage{
getConsensusPeakSet(
  grl,
  mode = "no_by_score",
  grouping = NULL,
  groupAgreePerc = 1,
  groupConsSelect = FALSE,
  scoreCol = "score",
  keepOvInfo = FALSE
)
}
\arguments{
\item{grl}{list or \code{GRangesList} object containing the peak sets for each sample}

\item{mode}{consensus mode. Currently only "no_by_score" (non-overlapping; i.e. select the peak with the highest score from each set of
overlapping peaks) is supported.}

\item{grouping}{vector of group memberships (numeric, character or factor). must be of the same length as \code{grl}}

\item{groupAgreePerc}{percentile of members in a group required to contain a peak in order to keep it.
E.g. a value of 1 (default) means that all replicates in a group are required to contain that peak in order
to keep it.}

\item{groupConsSelect}{if set, the peak set will also be checked for consistency, i.e. in order to retain a peak
it has to be consistently be present or absent in each group (as specified in \code{groupAgreePerc} percent of samples)}

\item{scoreCol}{name of the column to be used as score in the \code{elementMetadata} of the peak sets. This will determine which peak is selected
if multiple peaks overlap}

\item{keepOvInfo}{keep annotation columns in the elementMetadata of the results specifying whether a consensus peak overlaps with a
peak in each sample}
}
\value{
\code{GRanges} object the containing consensus peak set
}
\description{
Retrieve a consensus peak set from a set of peak lists
}
\author{
Fabian Mueller
}
