% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DsATAC-class.R
\docType{methods}
\name{filterLowCovg,DsATAC-method}
\alias{filterLowCovg,DsATAC-method}
\alias{filterLowCovg}
\title{filterLowCovg-methods}
\usage{
\S4method{filterLowCovg}{DsATAC}(
  .object,
  thresh = 1L,
  reqSamples = 0.75,
  regionTypes = getRegionTypes(.object)
)
}
\arguments{
\item{.object}{\code{\linkS4class{DsATAC}} object}

\item{thresh}{regions with read counts below this threshold will be considered lowly covered regions (default: regions with fewer than 1 read will be discarded)}

\item{reqSamples}{the percentile of samples required to meet or exceed the threshold in order for a region to be retained.
must be in the interval [0, 1) (default: 0.75 = 75 percent)}

\item{regionTypes}{character vector specifying the names of the region types to which filtering should be applied (default: all region types)}
}
\value{
a new \code{\linkS4class{DsATAC}} object with low coverage regions removed
}
\description{
Filter regions with low read counts
}
\author{
Fabian Mueller
}
