% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DsATACsc-class.R
\docType{methods}
\name{dimRed_UMAP,DsATACsc-method}
\alias{dimRed_UMAP,DsATACsc-method}
\alias{dimRed_UMAP}
\title{dimRed_UMAP-methods}
\usage{
\S4method{dimRed_UMAP}{DsATACsc}(
  .object,
  regions,
  tfidf = TRUE,
  pcs = 1:50,
  normPcs = FALSE,
  umapParams = list(distMethod = "euclidean", min_dist = 0.5, n_neighbors = 25)
)
}
\arguments{
\item{.object}{\code{\linkS4class{DsATACsc}} object}

\item{regions}{character string specifying the region type to retrieve the UMAP coordinates from. Alternatively, a \code{GRanges} object specifying coordinates that fragment counts will be aggregated over}

\item{tfidf}{normalize the counts using TF-IDF transformation}

\item{pcs}{components to use to compute the SVD}

\item{normPcs}{flag indicating whether to apply z-score normalization to PCs for each cell}

\item{umapParams}{parameters to compute UMAP coordinates (passed on to \code{muRtools::getDimRedCoords.umap} and further to \code{uwot::umap})}
}
\value{
an \code{S3} object containing dimensionality reduction results
}
\description{
Retrieve dimension reduction embedding and object using UMAP
}
\details{
The output object includes the final singular values/principal components (\code{result$pcaCoord}), the low-dimensional coordinates (\code{result$umapCoord}) as well as region set that provided the basis for the dimension reduction (\code{result$regionGr}).
}
\author{
Fabian Mueller
}
