% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_atac_differential.R
\docType{methods}
\name{createReport_differential,DsATAC-method}
\alias{createReport_differential,DsATAC-method}
\alias{createReport_differential}
\title{createReport_differential-methods}
\usage{
\S4method{createReport_differential}{DsATAC}(.object, reportDir)
}
\arguments{
\item{.object}{\code{\linkS4class{DsATAC}} object}

\item{reportDir}{directory in which the report will be created}
}
\value{
(invisible) \code{muReportR::Report} object containing the report
}
\description{
Create a report summarizing differential accessibility analysis
}
\examples{
\dontrun{
dsa <- ChrAccRex::loadExample("dsAtac_ia_example")
reportDir <- file.path(".", "ChrAccR_reports")
setConfigElement("regionTypes", setdiff(getRegionTypes(dsa), c("promoters_gc_protein_coding", "t10k")))
setConfigElement("differentialColumns", c("stimulus", "cellType"))
# adjust for the donor annotation in the differential test
setConfigElement("differentialAdjColumns", c("donor"))
# create the report
createReport_differential(dsa, reportDir)
}
}
\author{
Fabian Mueller
}
