% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_motifs.R
\name{collapseMotifMatrix}
\alias{collapseMotifMatrix}
\title{collapseMotifMatrix}
\usage{
collapseMotifMatrix(
  X,
  motifClust = NULL,
  assembly = "hg38",
  motifs = "jaspar",
  aggrFun = mean
)
}
\arguments{
\item{X}{matrix to be collapsed. Must have the motif names as rownames. E.g. matrix obtained by \code{chromVAR::deviationScores}}

\item{motifClust}{optional: motif clustering computed by \code{\link{getMotifClustering}}. If \code{NULL} (default) the default clustering will be retrieved}

\item{assembly}{genome assembly for which the motif clustering should be retrieved. Only required if for automatic mode (i.e. \code{motifClust=NULL}).}

\item{motifs}{a character string specifying the motif set (currently only "jaspar" is supported)}

\item{aggrFun}{function to use to aggregate values}
}
\value{
list containing two elements: \code{X}: Collapsed matrix containing motif cluster aggregated values;
        \code{clustering}: clustering result used for aggregation (see\code{\link{getMotifClustering}} for details)
}
\description{
Collapse TF motif matrix of arbitrary values by aggregating values over motif cluster assignment
}
\author{
Fabian Mueller
}
