% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_atac_10x.R
\name{DsATACsc.fragments}
\alias{DsATACsc.fragments}
\title{DsATACsc.fragments}
\usage{
DsATACsc.fragments(
  sampleAnnot,
  fragmentFiles,
  genome,
  regionSets = NULL,
  sampleIdCol = NULL,
  minFragsPerBarcode = 500L,
  maxFragsPerBarcode = Inf,
  cellAnnot = NULL,
  keepInsertionInfo = FALSE,
  diskDump.fragments = keepInsertionInfo,
  cellQcStats = TRUE
)
}
\arguments{
\item{sampleAnnot}{data.frame specifying the sample annotation table}

\item{fragmentFiles}{vector of fragment files or the column name in the sample annotation table containing thse file names.
fragment files must be tab-separated with columns "chrom", "chromStart", "chromEnd", "barcode" and "duplicateCount"
and must not contain a header line}

\item{genome}{genome assembly}

\item{regionSets}{a list of GRanges objects which contain region sets over which count data will be aggregated}

\item{sampleIdCol}{column name or index in the sample annotation table containing unique sample identifiers}

\item{minFragsPerBarcode}{minimum number of fragments required for a barcode to be kept. [Only relevant if \code{cellAnnot==NULL}]}

\item{maxFragsPerBarcode}{maximum number of fragments per barcode. Only barcodes with fewer fragments will be kept. [Only relevant if \code{cellAnnot==NULL}]}

\item{cellAnnot}{(optional) annotation table of all cells in the dataset. Must contain a \code{'cellId'} and \code{'cellBarcode'} columns.}

\item{keepInsertionInfo}{flag indicating whether to maintain the insertion information in the resulting object.}

\item{diskDump.fragments}{Keep fragment coordinates stored on disk rather than in main memory. This saves memory, but increases runtime and I/O.}

\item{cellQcStats}{flag indicating whether to compute additional cell QC statistics (TSS enrichment, etc.).}
}
\value{
\code{\linkS4class{DsATACsc}} object
}
\description{
Create a DsATACsc dataset from multiple input fragment files
}
\author{
Fabian Mueller
}
