% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_atac.R
\name{DsATAC.snakeATAC}
\alias{DsATAC.snakeATAC}
\title{DsATAC.snakeATAC}
\usage{
DsATAC.snakeATAC(
  sampleAnnot,
  filePrefixCol,
  genome,
  dataDir = "",
  regionSets = NULL,
  sampleIdCol = filePrefixCol,
  type = "insBam",
  diskDump = FALSE,
  keepInsertionInfo = TRUE,
  bySample = FALSE,
  pairedEnd = TRUE
)
}
\arguments{
\item{sampleAnnot}{data.frame specifying the sample annotation table}

\item{filePrefixCol}{column name specifying the file prefix for each sample in the sample annotation table. If \code{dataDir} is not empty (i.e. not \code{""})
filenames are assumed to be relative to that directory and  a corresponding filename suffix will be appended}

\item{genome}{genome assembly}

\item{dataDir}{directory where the files are located. If it is the empty character (\code{""}; default) it is assumed that \code{filePrefixCol} specifies the full path to the input files}

\item{regionSets}{a list of GRanges objects which contain region sets over which count data will be aggregated}

\item{sampleIdCol}{column name or index in the sample annotation table containing unique sample identifiers}

\item{type}{input data type. Currently only "insBed" (insertion beds), "insBam" (insertion info inferred from bam files (aligned reads); default) and "bam" (aligned reads) are supported}

\item{diskDump}{should large data objects (count matrices, fragment data, ...) be disk-backed to save main memory}

\item{keepInsertionInfo}{flag indicating whether to maintain the insertion information in the resulting object. Only relevant when \code{type=="insBam"}.}

\item{bySample}{process sample-by-sample to save memory (currently only has an effect for \code{type=="insBam"})}

\item{pairedEnd}{is the input data paired-end? Only relevant when \code{type=="insBam"}.}
}
\value{
\code{\linkS4class{DsATAC}} object
}
\description{
Create a DsATAC dataset from multiple input files output by snakeATAC
}
\author{
Fabian Mueller
}
