% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_atac.R
\name{DsATAC.fragmentBed}
\alias{DsATAC.fragmentBed}
\title{DsATAC.fragmentBed}
\usage{
DsATAC.fragmentBed(
  sampleAnnot,
  bedFiles,
  genome,
  regionSets = NULL,
  sampleIdCol = NULL,
  diskDump = FALSE,
  keepInsertionInfo = TRUE
)
}
\arguments{
\item{sampleAnnot}{data.frame specifying the sample annotation table}

\item{bedFiles}{either a character vector of the same length as sampleAnnot has rows, specifying the file paths of the bed files for each
sample or a single character string specifying the column name in \code{sampleAnnot} where the file paths can be found}

\item{genome}{genome assembly}

\item{regionSets}{a list of GRanges objects which contain region sets over which count data will be aggregated}

\item{sampleIdCol}{column name in the sample annotation table containing unique sample identifiers. If \code{NULL} (default), the function will look for a column that contains the word "sample"}

\item{diskDump}{should large data objects (count matrices, fragment data, ...) be disk-backed to save main memory}

\item{keepInsertionInfo}{flag indicating whether to maintain the insertion information in the resulting object. Only relevant when \code{type=="insBam"}.}
}
\value{
\code{\linkS4class{DsATAC}} object
}
\description{
Create a DsATAC dataset from multiple input fragment bed files
}
\author{
Fabian Mueller
}
