% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_atac_10x.R
\name{DsATAC.cellranger}
\alias{DsATAC.cellranger}
\title{DsATAC.cellranger}
\usage{
DsATAC.cellranger(
  sampleAnnot,
  sampleDirPrefixCol,
  genome,
  dataDir = "",
  regionSets = NULL,
  addPeakRegions = TRUE,
  sampleIdCol = sampleDirPrefixCol,
  keepInsertionInfo = FALSE,
  diskDump.fragments = keepInsertionInfo
)
}
\arguments{
\item{sampleAnnot}{data.frame specifying the sample annotation table}

\item{sampleDirPrefixCol}{column name specifying the directory prefix for each sample in the sample annotation table}

\item{genome}{genome assembly}

\item{dataDir}{directory where the files are located}

\item{regionSets}{a list of GRanges objects which contain region sets over which count data will be aggregated}

\item{addPeakRegions}{should a merged set of peaks be created as one of the region sets (merged, non-overlapping peaks of width=500bp from the peaks of individual samples)}

\item{sampleIdCol}{column name or index in the sample annotation table containing unique sample identifiers}

\item{keepInsertionInfo}{flag indicating whether to maintain the insertion information in the resulting object.}

\item{diskDump.fragments}{Keep fragment coordinates stored on disk rather than in main memory. This saves memory, but increases runtime and I/O.}
}
\value{
\code{\linkS4class{DsATAC}} object
}
\description{
Create a DsATAC dataset from multiple input files output by 10x cellranger
}
\author{
Fabian Mueller
}
