% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_motifs.R
\name{hmSeqLogo}
\alias{hmSeqLogo}
\title{hmSeqLogo}
\usage{
hmSeqLogo(
  pwm,
  x = unit(0.5, "npc"),
  y = unit(0.5, "npc"),
  width = 1,
  height = 1,
  ic.scale = TRUE
)
}
\arguments{
\item{pwm}{PWM (from TFBSTools package)}

\item{x}{x center coordinate where the motif should be drawn}

\item{y}{y center coordinate where the motif should be drawn}

\item{width}{drawing width}

\item{height}{drawing height}

\item{ic.scale}{\code{logical} If TRUE, the height of each column is proportional to its information content. Otherwise, all columns have the same height.}
}
\value{
Draws the motif
}
\description{
Draw a sequence motif logo in a Complex Heatmap using grid.
adapted from \code{seqLogo::seqLogo()}
}
\examples{
\dontrun{
hmSeqLogo(prepareMotifmatchr("hg38", "jaspar")$motifs[["MA0137.3_STAT1"]], unit(0.5, "npc"), unit(0.5, "npc"), 0.5, 0.5, ic.scale=TRUE)
}
}
\author{
Fabian Mueller
}
