% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential.R
\name{getComparisonInfo}
\alias{getComparisonInfo}
\title{getComparisonInfo}
\usage{
getComparisonInfo(
  dsa,
  cmpNames = NULL,
  regionTypes = getRegionTypes(dsa),
  allPairs = TRUE,
  adjPairCols = NULL,
  minGrpSize = 1L,
  maxGrpCount = NULL
)
}
\arguments{
\item{dsa}{\code{\linkS4class{DsAcc}} object}

\item{cmpNames}{column names of the sample annotation of the dataset that will be used for comparison}

\item{regionTypes}{which region types should be processed for differential analysis.}

\item{allPairs}{Logical indicating whether all pairwise comparisons should be conducted, when more than 2 groups are present}

\item{adjPairCols}{argument passed on to \code{rnb.sample.groups}. See its documentation for details.}

\item{minGrpSize}{Minimum number of samples required to form a group in comparison}

\item{maxGrpCount}{maximum number of groups to consider for comparisons}
}
\value{
a list containing one element for each comparison to be conducted. Each element is again a list containing:
\describe{
  \item{\code{comparison}}{the name of the comparison}
  \item{\code{pheno.colname}}{the column name of the sample annotation table the comparison is derived from}
  \item{\code{group.names}}{the names of the two groups being compared}
  \item{\code{group.inds}}{the sample indices of the samples belonging to the two groups}
  \item{\code{paired}}{flag indicating whether paired analysis is conducted}
  \item{\code{adj.sva}}{flag indicating whether adjustment for SVA is conducted}
  \item{\code{adj.celltype}}{flag indicating whether adjustment for cell type is conducted}
  \item{\code{adjustment.table}}{the covariate adjustment table. \code{NULL} if the comparison is not adjusted}
  \item{\code{region.types}}{the region types applicable to the analysis}
}
}
\description{
retrieve the comparison information for an DsAcc object. Analogous to \code{RnBeads::get.comparison.info}
}
\author{
Fabian Mueller
}
