% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_atac_exploratory.R
\docType{methods}
\name{createReport_exploratory,DsATAC-method}
\alias{createReport_exploratory,DsATAC-method}
\alias{createReport_exploratory}
\title{createReport_exploratory-methods}
\usage{
\S4method{createReport_exploratory}{DsATAC}(.object, reportDir, itLsiObj = NULL, geneActSe = NULL)
}
\arguments{
\item{.object}{\code{\linkS4class{DsATAC}} object}

\item{reportDir}{directory in which the report will be created}

\item{itLsiObj}{[for single-cell only; optional] pre-computed result of a call to \code{iterativeLSI(.object, ...)}}

\item{geneActSe}{[for single-cell only; optional] pre-computed result of a call to \code{getCiceroGeneActivities(.object, ...)}}
}
\value{
(invisible) \code{muReportR::Report} object containing the report
}
\description{
Create a report summarizing exploratory analyses of an accessibility dataset
}
\examples{
\dontrun{
dsa <- ChrAccRex::loadExample("dsAtac_ia_example")
dsa_qnorm <- transformCounts(dsa, method="quantile")
setConfigElement("annotationColumns", c("cellType", "donor", "stimulus"))
setConfigElement("regionTypes", setdiff(getRegionTypes(dsa), c("promoters_gc_protein_coding", "t10k")))
reportDir <- file.path(".", "ChrAccR_reports")
createReport_exploratory(dsa_qnorm, reportDir)
}
}
\author{
Fabian Mueller
}
