% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_nome.R
\name{computeDiffAcc.rnb.nome}
\alias{computeDiffAcc.rnb.nome}
\alias{rnb.execute.computeDiffMeth}
\title{computeDiffAcc.rnb.nome}
\usage{
computeDiffAcc.rnb.nome(
  dsn,
  cmpCols,
  regionTypes = getRegionTypes(dsn),
  covgThres = 5L,
  allPairs = TRUE,
  adjPairCols = NULL,
  adjCols = NULL,
  skipSites = FALSE,
  disk.dump = rnb.getOption("disk.dump.big.matrices"),
  disk.dump.dir = tempfile(pattern = "diffMethTables_"),
  ...
)
}
\arguments{
\item{dsn}{\code{\linkS4class{DsNOMe}} object}

\item{cmpCols}{column names of the sample annotation of the dataset that will be used for comparison}

\item{regionTypes}{which region types should be processed for differential analysis.}

\item{covgThres}{coverage threshold for computing the summary statistics. See \code{RnBeads::computeDiffTab.extended.site} for details.}

\item{allPairs}{Logical indicating whether all pairwise comparisons should be conducted, when more than 2 groups are present}

\item{adjPairCols}{argument passed on to \code{rnb.sample.groups}. See its documentation for details.}

\item{adjCols}{not used yet}

\item{skipSites}{flag indicating whether differential methylation in regions should be computed directly and not from sites. This leads to skipping of site-specific differential methylation}

\item{disk.dump}{Flag indicating whether the resulting differential methylation object should be file backed, ie.e the matrices dumped to disk}

\item{disk.dump.dir}{disk location for file backing of the resulting differential methylation object. Only meaningful if \code{disk.dump=TRUE}.
must be a character specifying an NON-EXISTING valid directory.}

\item{...}{arguments passed on to binary differential methylation calling. See \code{RnBeads::computeDiffTab.extended.site} for details.}
}
\value{
an \code{RnBDiffMeth} object. See class description for details.
}
\description{
computes differential accessibility for NOMe datasets using \code{RnBeads} functionality
}
\author{
Fabian Mueller

Fabian Mueller
}
