% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DsATAC-class.R
\docType{methods}
\name{aggregateRegionCounts,DsATAC-method}
\alias{aggregateRegionCounts,DsATAC-method}
\alias{aggregateRegionCounts}
\title{aggregateRegionCounts-methods}
\usage{
\S4method{aggregateRegionCounts}{DsATAC}(
  .object,
  regionGr,
  samples = getSamples(.object),
  countAggrFun = "sum",
  norm = "tailMean",
  normTailW = 0.1,
  kmerBiasAdj = TRUE,
  k = 6,
  sampleCovg = NULL,
  sampleKmerFreqM = NULL,
  regionKmerFreqM = NULL,
  silent = FALSE
)
}
\arguments{
\item{.object}{\code{\linkS4class{DsATAC}} object}

\item{regionGr}{\code{GRanges} object specifying the regions to aggregate over}

\item{samples}{sample identifiers}

\item{countAggrFun}{aggration function to be used for summarizing the insertion counts at each position. Possible values include \code{"sum"}, \code{"mean"}, and \code{"median"}}

\item{norm}{method used for normalizing the resulting position-wise counts.
Currently only \code{'tailMean'} is supported, which computes normalization factors as the mean signal in the tails of the window}

\item{normTailW}{fraction of the region window to be used on each side of the window to be used for normalization if \code{norm} is one of \code{'tailMean'}}

\item{kmerBiasAdj}{compute Tn5 bias and use it to adjust the counts as in Corces, et al., Science, (2018)}

\item{k}{length of the kmer to be used for sequence bias correction. Only relevant if \code{kmerBiasAdj==TRUE}.}

\item{sampleCovg}{to save compute time, a sample coverage track list (as computed by \code{getCoverage(.object)}) can be supplied. If not, it will be computed on the fly.}

\item{sampleKmerFreqM}{to save compute time, a matrix of sample kmer frequency at insertion sites (as computed by \code{getInsertionKmerFreq(.object, ...)}) can be supplied.
If not, it will be computed on the fly. Only relevant if \code{kmerBiasAdj==TRUE}.}

\item{regionKmerFreqM}{to save compute time, a matrix of region kmer frequencies (kmers X window width).
Must have the same number of rows as the specified (or computed) \code{sampleKmerFreqM} (kmers)
and the same number of columns as the window width (median width of \code{regionGr}).
Only relevant if \code{kmerBiasAdj==TRUE}.}

\item{silent}{limit log messages}
}
\value{
a \code{data.frame} containing position-wise counts (raw, normalized and optionally Tn5-bias-corrected) for each sample
}
\description{
Agregate counts across a set of regions, e.g. for footprinting analysis
}
\author{
Fabian Mueller
}
