% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DsATAC-class.R
\docType{class}
\name{DsATAC-class}
\alias{DsATAC-class}
\title{DsATAC}
\description{
A class for storing ATAC-seq accessibility data
inherits from \code{\linkS4class{DsAcc}}
}
\section{Slots}{

\describe{
  \item{\code{fragments}}{
	\code{GRanges} object storing sequencing fragments. Alternativily pointers to files in which this data is stored
     as R data object
  }
  \item{\code{counts}}{
	List of count matrices for each summarized region type (dimension: regions X samples).
     Depending on the settings for the slots \code{diskDump} and \code{sparseCounts}, the matrices are
     either (a) regular matrices, (b) \code{HDF5Array}/\code{DelayedArray} or (c) sparse matrices.
  }
  \item{\code{countTransform}}{
	list of character vectors specifying which transformations have been applied to the count matrices
  }
  \item{\code{sparseCounts}}{
	Flag indicating whether count data will be stored as sparse matrices rather than regular matrices
  }
  \item{\code{diskDump.fragments}}{
	Flag indicating whether fragment data will be kept on disk rather than in main memory.
  }
}
}

\author{
Fabian Mueller
}
