;+
;========================================================================
;;;
;;; FILE NAME:    $Id: timedmessage.pro 5342 2018-12-11 15:04:17Z psb6 $
;;;
;;; DESCRIPTION:  Timed Message Widget
;;;
;;;               Used to display a message in a non-modal dialog box.
;;;
;;; AUTHOR:       Pat Broos (patrick.broos@icloud.com)
;;;               Scott Koch (tsk@astro.psu.edu)
;;;               Copyright (C) 1996, Pennsylvania State University
;;;
;;; NOTES:        Use the POSITIONING_PARENT keyword to supply the widget ID
;;;               of the caller.  When this is done, the non-modal message
;;;               widget will be displayed on top of the caller with a slight
;;;               offset.
;;;
;-
;==========================================================================
PRO TimedMsgEvent, event


;; Get the state structure. 
top_base = Event.handler
widget_control, top_base, GET_UVALUE=st

if (event.ID EQ top_base) || (event.ID EQ st.quit_id) then widget_control, event.handler, /DESTROY, BAD_ID=bad_id
return
end

PRO TimedMessage, base, message, GROUP_LEADER=group, UVALUE=uvalue, $
			  TITLE=title, CENTER=center, XOFFSET=xoffset, YOFFSET=yoffset, FONT=font, $
			  XSIZE=xsize, YSIZE=ysize, POSITIONING_PARENT=pp, $
			  LIFETIME=lifetime,$
			  NO_QUIT=no_quit, QUIT_LABEL=quit_label, BUTTON_LABEL=button_label,$
			  ; OUTPUT PARAMETERS:
			  QUIT_ID   =quit_id,$
			  BUTTON_ID =button_id,$
			  PRESSED_ID=pressed_id

if NOT keyword_set(uvalue) then uvalue = 0
if NOT keyword_set(group)  then group = 0
if NOT keyword_set(title)  then title=' '

screen_center = ScreenCenter()
if keyword_set(center) then begin
  xoffset = screen_center[0]
  yoffset = screen_center[1]
endif

if (n_elements(xoffset) EQ 0) then begin
  xoffset= screen_center(0) - 150
endif
if (n_elements(yoffset) EQ 0) then begin
  yoffset= 0
endif

if NOT keyword_set(xsize) then begin
  xsize = max( [strlen(message)+1, strlen(title)+3] )
endif

if NOT keyword_set(ysize) then begin
  ysize = n_elements(message) +2
endif

if ~keyword_set(font) then font = '-adobe-helvetica-bold-r-*-*-14-*-*-*-*-*-*-*'

; The positioning parent keywords overrides any x or y offsets.
if keyword_set(pp) then begin
  this_widget=pp
  parent = 1
  xoffset = 0
  yoffset = 0
  while (this_widget NE 0) do begin
    geometry=widget_info(this_widget, /GEOMETRY)
    xoffset = xoffset + geometry.xoffset
    yoffset = yoffset + geometry.yoffset
    parent=widget_info(this_widget, /PARENT)
    this_widget=parent
  endwhile
endif

; Create the widget if necessary.
if (n_elements(base) EQ 0) then base = -1L
if (widget_info(base, /VALID_ID) EQ 0) then begin
  base =    widget_base(TITLE=title, UVALUE=uvalue, $
		      GROUP_LEADER=group, /COLUMN,  $
		      XOFFSET=xoffset, YOFFSET=yoffset)

  ;msgtxt =  WIDGET_TEXT(base, VAL = message, EDITABLE=0, /SCROLL, $
  ;		      YSIZE=20<n_elements(message))

  msgtxt =  WIDGET_TEXT(base, EDITABLE=0, XSIZ=xsize, YSIZ=2, FONT=font)

  active_buttons = !NULL
  
  if keyword_set(button_label) then begin
    button_id = widget_button(base, VALUE=button_label, FONT=font)
    active_buttons = [active_buttons,button_id]
  endif else button_id =  0L
  
  if ~keyword_set(no_quit) then begin
    quit_id =  widget_button(base, VALUE=keyword_set(quit_label) ? quit_label : 'Dismiss', FONT=font)
    active_buttons = [active_buttons,quit_id]
  endif else quit_id =  0L

  ;; Save state structure.
  state = {button_id:button_id, quit_id:quit_id}
  widget_control, base, SET_UVALUE=state

  WIDGET_CONTROL, base, /REALIZE

  xmanager, 'TimedMessage', base, GROUP_LEADER=group, /NO_BLOCK, /JUST_REG,$
	    EVENT_HANDLER='TimedMsgEvent'
endif

; Update the text widget.
msgtxt = widget_info( base, /CHILD )
msgtxt_geom = widget_info( msgtxt, /GEOMETRY )
widget_control, msgtxt, XSIZ=xsize > msgtxt_geom.xsize, YSIZ=ysize, SET_VALUE=message

; Schedule a timer event to destroy widget if desired.
if keyword_set(lifetime) then $
  widget_control, base, /CLEAR_EVENTS, TIMER=lifetime

if ARG_PRESENT(pressed_id) && keyword_set(active_buttons) then begin
 ;print, 'Waiting for button press'
  repeat begin
    event          = widget_event(active_buttons, NOWAIT=0)
    pressed_id = event.ID
  endrep until (pressed_id EQ button_id) || (pressed_id EQ quit_id)
  widget_control, base, /DESTROY
endif ; Returning pressed_id

return

END
