;;; $Id: version_string_compare.pro 5279 2018-06-19 17:50:35Z psb6 $
;;;
;;; This function compares "version number" string with the simple form 
;;;    <integer>.<integer>.<integer> ...
;;; where no integers are allowed to have leading zeros.
;;; 
;;; Correct behavior is not guaranteed if the strings contain characters other than {0-9.}.

FUNCTION version_string_compare, version_string1, version_string2, LESSTHAN=lessthan, GREATERTHAN=greaterthan, EQUALTO=equalto

if ~(keyword_set(lessthan) XOR keyword_set(greaterthan) XOR keyword_set(equalto)) then begin
  print, 'version_compare: ERROR, one of /LT, /EQ, /GT must be supplied.'
  retall
endif

t1 = fix(strsplit(/EXTRACT, version_string1, '.', COUNT=N1))
t2 = fix(strsplit(/EXTRACT, version_string2, '.', COUNT=N2))

; Pad the a token list (as needed) with zeros to make both the same length.
num_tokens = N1 > N2
tokens1 = replicate(0, num_tokens)
tokens2 = replicate(0, num_tokens)

tokens1[0] = t1
tokens2[0] = t2

;forprint, tokens1, tokens2, F='(I5, I5)'
;help,  tokens1, tokens2

if keyword_set(equalto) then return, array_equal(tokens1, tokens2)
; Note that array_equal() is false if the arrays have different lengths.

; For LT or GT options, compare each pair of tokens, left to right.
for ii=0,num_tokens-1 do begin
  if (tokens1[ii] LT tokens2[ii]) then return, keyword_set(lessthan) 
  if (tokens1[ii] GT tokens2[ii]) then return, keyword_set(greaterthan) 
endfor ; ii
; To get here, the two version strings must be equal.
return, 0

end

