;;; $Id: temporary_directory.pro 5322 2018-10-26 14:12:24Z psb6 $
;;; Patrick Broos, 2014

;========================================================================
;;; Tool to create a scratch directory with a unique name.
;;; The path returned is absolute, not relative.

;;; The environment variable $TMPDIR controls where the scratch directory is created.
;;; The optional inputs 'prefix' and 'suffix' are used in naming the scratch directory.

;;; If SUBDIR1 is supplied, a sub-directory of that name is made in the scratch directory, and its full path is returned in SUBDIR1.

;========================================================================
FUNCTION temporary_directory, prefix, suffix, SUBDIR1=subdir1, SUBDIR2=subdir2, SUBDIR3=subdir3, VERBOSE=verbose, $
           SESSION_NAME=session_name

;; Create a randomly named scratch directory that will not conflict with another instance of IDL.

if n_elements(prefix) EQ 0 then prefix = ''
if n_elements(suffix) EQ 0 then suffix = '.noindex'

; Try to obtain the IDL process ID.
catch, error_code
if (error_code NE 0) then begin
  print, 'temporary_directory: Cannot obtain process ID, directory name generated from random().'
  pid = round( random()*1E7 )
endif else pid = call_external(!dlm_path+'/libidl.dylib', 'getpid', /CDECL)
catch, /CANCEL


ii=0L
repeat begin
  session_name = string(pid, ii++, F='(%"%7.7d.%d")')
  
  temp_base = prefix + session_name 
  
  temp_root = filepath(temp_base + suffix + '/', /TMP)

  if (ii GE 1000) then message, 'ERROR: cannot build a unique directory of the form '+temp_root
endrep until ~file_test(temp_root)

file_mkdir, temp_root
if keyword_set(verbose) then print, temp_root, F='(%"\nUsing temporary directory: %s")' 

if keyword_set(subdir1) then begin
  subdir1 = temp_root+subdir1+ '/'
  file_mkdir, subdir1
endif

if keyword_set(subdir2) then begin
  subdir2 = temp_root+subdir2+ '/'
  file_mkdir, subdir2
endif

if keyword_set(subdir3) then begin
  subdir3 = temp_root+subdir3+ '/'
  file_mkdir, subdir3
endif

return, temp_root
end

