;+
;============================================================================
;;; $Id: random.pro 5019 2016-09-22 12:48:50Z psb6 $
;;;
;;;
;;; DESCRIPTION:  This routine hides the caller from the inelegant and 
;;;		  ever-changing interface of RSI's RANDOMU & RANDOMN routines.
;;;		  Keywords are passed on to RANDOMU via the _extra mechanism.
;;;		  For example, to get normal deviates use random(/NORMAL).
;;;
;;; AUTHOR:       Pat Broos (patrick.broos@icloud.com)
;;;               Copyright (C) 1999, Pennsylvania State University
;;;
;============================================================================
;-

FUNCTION random, n1, n2, n3, GENERATE_SEED=generate_seed, NEW_SEED=new_seed, _EXTRA=extra

COMMON random_seed, seed

if (n_elements(seed) EQ 0) || keyword_set(generate_seed) then begin
  ; Try to obtain the IDL process ID.
  catch, error_code
  if (error_code NE 0) then begin
    print, 'Random seed generated from systime() only (cannot obtain process ID).'
    pid = 0
  endif else pid = call_external(!dlm_path+'/libidl.dylib', 'getpid', /CDECL)
  catch, /CANCEL

  ; Generate a seed using the 7 digits to the right of the decimal in the current time.
  seed = pid + floor((systime(1) mod 1)*1E7)
 ;print, seed, F='("Random seed chosen from system time: ",I0)'
endif

if keyword_set(new_seed) then begin
  seed = long(new_seed)
  ;print, seed, F='("Random seed set to: ",I0)'
endif

case n_params() of
     0: return, randomu(seed,          _EXTRA=extra)
     1: return, randomu(seed,n1,       _EXTRA=extra)
     2: return, randomu(seed,n1,n2,    _EXTRA=extra)
     3: return, randomu(seed,n1,n2,n3, _EXTRA=extra)
endcase

end



