;;; Tool to convert a shell command with complex quoting to a form that the shell will accept.

; Input is a string that needs to be passed to a shell single-quoted, so that the shell will not parse it (break it into words, perform variable subsitution, interpret special characters, etc.).
; This input string is allowed to contain a mix of single-quote and double-quote characters, e.g.

;    cmd=select 'equals(trim(Bandpass),"K")'

;This tool returns a string that is properly formatted for a shell, by converting the input to a set of abutted single-quoted string with escaped single-quote characters in between, i.e. 
;
;    'cmd=select '\''equals(trim(Bandpass),"K")'\'''

; This is achieved by the following algorithm:
;   Replace each ' character in the input string with four characters: '\''
;   Add a ' character to the head and tail of the string.


FUNCTION quote_for_shell, string_to_quote 

single_quote             = "'"
single_quote_replacement = "'\''"

num_strings = n_elements(string_to_quote)

result = strarr(num_strings)

for ii=0,num_strings-1 do $
  result[ii] = "'" +mg_streplace(/GLOBAL, string_to_quote[ii], single_quote, single_quote_replacement)+ "'" 
; Note that mg_streplace function is from https://raw.github.com/mgalloy/mglib/master/src/strings/mg_streplace.pro
return, result
end
