;;; $Id: psb_xaddpar.pro 5074 2017-01-23 14:29:33Z psb6 $
;;; A wrapper for the AstroLib, designed to allow representations of IEEE 754 special values in FITS keywords.

;;; The FITS standard does not allow FLOAT keywords to repesent IEEE 754 special values, such as  NaN, Inf, -Inf.
;;; The wrappers psb_xaddpar.pro and psb_xaddpar.pro reserve certain string values to represent these IEEE 754 special values.         
;;; The resulting FITS files conform to the syntax of the FITS standard, but of course these reserved strings will not be recognized by other FITS readers.

;;; Patrick Broos & Leisa Townsley, Penn State University, 2016
;;; patrick.broos@icloud.com   townsley@astro.psu.edu

PRO psb_xaddpar, HEADER, NAME, VALUE_p, COMMENT,    _REF_EXTRA=extra

; Do not allow this routine to alter a variable in the caller.
VALUE = VALUE_p

tname = size(VALUE, /TNAME)
if (tname EQ 'FLOAT' || tname EQ 'DOUBLE') then begin
  ; Convert IEEE 754 special values to "reserved" strings.
  
  case 1 of 
    finite(VALUE, /NAN              ) : VALUE =  'NaN'
    finite(VALUE, /INFINITY, SIGN=+1) : VALUE =  'Inf'
    finite(VALUE, /INFINITY, SIGN=-1) : VALUE = '-Inf'
    else:
  endcase
endif ; FLOAT or DOUBLE passed

; As of Aug 19, 2016 fxaddpar has a bug that ignores the "VALUE" input when its type is BYTE or BOOLEAN.
; We work around this bug by casting BYTE values to INTEGER.
if (tname EQ 'BYTE') then VALUE = fix(VALUE)


; Historically I've used fxaddpar.pro instead of sxaddpar.pro, but the logic behind that choice has been forgotten.
if keyword_set(COMMENT) then $
  fxaddpar,      HEADER, NAME, VALUE, COMMENT, _STRICT_EXTRA=extra $
else $
  fxaddpar,      HEADER, NAME, VALUE,          _STRICT_EXTRA=extra 

return
end

