;========================================================================
;;;
;;; Replacement for binomial.pro: $Id: binomial_nr.pro 5053 2016-11-18 18:15:05Z psb6 $
;;;
;;; Patrick Broos (patrick.broos@icloud.com)
;;;

;;; As of IDL v8.5.1, binomial.pro (distributed with IDL) has serious flaws.
;;; See email to Harris Inc. on Oct 22, 2016.
;;; This replacement for binomial.pro uses the algorithm recommended by Numerical Recipes (Chapter 6.4).
;;; This tool does NOT allow vector inputs.
;========================================================================


FUNCTION binomial_nr, V, N, P 

on_error, 2  ;Return to caller if error occurs.

if P LT 0 OR P GT 1 then message, 'P must be in the interval [0.0, 1.0]'
if V LT 0           then message, 'V must be nonnegative.'
if N LT 0           then message, 'N must be nonnegative.'

if (V EQ 0) then return, 1D
if (V GT N) then return, 0D

result = IBETA( V, N - V + 1, P, /DOUBLE )

if finite(result, /INFINITY) then message, 'binomial_nr produced Inf or -Inf.'

if finite(result, /NAN     ) then message, 'binomial_nr produced NaN.'

return, result
end


