;;; $Id: almost_equal.pro 4918 2016-01-15 16:32:09Z psb6 $


FUNCTION almost_equal, data, target, NAN=ignore_nan, TOLERANCE=tolerance, DATA_RANGE=data_range

if n_elements(tolerance) EQ 0 then tolerance = 1e-6

case n_elements(target) of 
  1:$
    begin
    minval     = min(data, NAN=ignore_nan, MAX=maxval)
    data_range = [minval,maxval]
    return, array_equal( ~(abs(data_range - target) GT tolerance), 1 )
    end

  n_elements(data):return, array_equal( ~(abs(data       - target) GT tolerance), 1 )

  else:$
    begin
    print, 'almost_equal: ERROR: parameter "target" must be scaler or same dimension as parameter "data".'
    retall
    end
endcase

end






