PRO WVT_TEMPERATUREMAP
; Here, you should give the name of your evt2 file
evtfile='evt2.fits'

mask=mrdfits('mask.fits',0) ; mask specifying good (1), bad (0) data
ctsimage=mrdfits('cts.fits',0,header)  ; the counts image
image=ctsimage                         ; is also our signal 
noise=sqrt(image)                      ; true for Poissonian data
origdim=size(image,/dimension)         ; get dimension of image for later
max_area=total(mask)/10.               ; Make sure you get at least 10 bins
file_delete, 'stopmenow',/quiet        ; Avoid stopping at the first iteration

targetSN=30d0   ; 900 counts -> increase this number if you think this is not
                ; sufficient to obtain your type of spectral fit? It is 
                ; recommended to bin spectra to 20 pixels per spectral bin
                ; before fitting, i.e. 900 cts corresponds to 45 spectral bins

; Adaptively bin your image
wvt_image, image, noise, targetSN, binnedimage, xnode, ynode, weight, $
    snbin=snbin, mask=mask, ctsimage=ctsimage, binnumber=binnumber, $
    binvalue=binvalue, save_all=save_all, max_area=max_area

; Use the binned image to extract new evt2 files for all bins. The files will
; be named "evt2.fits.XXX" with XXX indicating the bin number.
WVT_EVTSPLIT, evtfile, binnumber, header, root='evt2.fits.' 


; Save the output
file_delete, ['abinned.fits', 'abinned_snr.fits', 'abinned_data.fits', 'abinned_binnum.fits'],/quiet
mwrfits, binnedimage, 'abinned.fits', header
snbin=[0,snbin]
mwrfits, mask*(snbin[binnumber]), 'abinned_snr.fits', header
mwrfits, save_all, 'abinned_data.fits'
mwrfits, mask*binnumber, 'abinned_binnum.fits', header

; Save the number of bins in a file called nbins.dat (needed the csh script)
openw, 3, 'nbins.dat'
printf, 3, max(fix(binnumber))
close, 3

END



