PRO WVT_EVALTEMPERATUREMAP, binnumber, extension=extension, lineno=lineno, outfile=outfile, interpol=interpol

; Specify the extension that should get evaluated. If there is more than one line with data, specify
; the number of the line with "lineno".
IF n_elements(extension) EQ 0 THEN extension='.temp'
IF n_elements(outfile) EQ 0 THEN outfile='tempmap.fits'
IF n_elements(lineno) EQ 0 THEN lineno=1

;binnumber=mrdfits('abinned_binnum.fits', 0)
mask=mrdfits('outmask.fits',0)
inmask=mrdfits('mask.fits',0)

IF n_elements(binnumber) EQ 0 THEN BEGIN
  data=mrdfits('abinned_data.fits',1)
  max_area=total(inmask)/10.
  IF tag_exist(data, 'weight') THEN weight=data.weight ELSE BEGIN
    area = HISTOGRAM(data.class, REVERSE_INDICES=r ,min=min(data.class), max=max(data.class))
    weight=sqrt(data.snbin/(area<max_area))
    IF min(data.xnode) LT 0 or min(data.ynode) lt 0 THEN BEGIN
      data.xnode=data.xnode+data.center[0]
      data.ynode=data.ynode+data.center[1]
    ENDIF
  ENDELSE
  WVT_GENERATEBINNING, data.xnode, data.ynode, weight, binnumber, mask
ENDIF

; Loop through all bins, evaluate the spectral parameter for that bin and store it in temp
nbins=max(binnumber)
temp=dblarr(nbins+1) &$
FOR i=1L, nbins DO BEGIN &$
  file=strcompress('evt2.fits.'+string(i)+extension, /remove_all) &$
  IF file_test(file) THEN readcol, file, a, skipline=lineno-1, numline=1 ELSE a=-1. &$
  temp[i]=a &$
ENDFOR

; Get the header to preserve WCS information
c=mrdfits('abinned.fits',0,header)

; Produce the temperature map, binnumber starts at 1, therefore, temp[0]=0
tempmap=temp[binnumber]

; Save the temperature map
file_delete, outfile, /quiet
mwrfits, tempmap, outfile, header

IF keyword_set(interpol) THEN BEGIN
; Linearly interpolate between bin generators to get a smooth temperature map
triangulate,data.xnode,data.ynode,trbin, b
origdim=size(c,/dimensions)
dimx=origdim[0]
dimy=origdim[1]
bingrid=trigrid(data.xnode,data.ynode,data.binvalue,trbin, [0,0], [0,0,dimx,dimy], nx=dimx, ny=dimy, missing=0)
gridnat = GRIDDATA(data.xnode, data.ynode, temp[1:nbins]>.6,dimension=origdim, start=0,/natural_neighbor, triangle=trbin, delta=1., missing=0.6)

; Save the interpolated temperature map. Looks cute, but shouldn't be used, as it could create artifacts
file_delete, 'tempmap_interpol.fits',/quiet
mwrfits, gridnat* (bingrid GT 0)<1.6>.6, 'tempmap_interpol.fits', header
ENDIF

END
;exit

