#!/bin/tcsh -fe

# $Id: setup_AE_for_obsid_data.csh 5531 2020-05-02 20:21:59Z psb6 $

# Script to set up AE obsXXXX directories to point to data representing the full field of view of an observation. 
#
# The first parameter is a glob pattern in double quotes that finds obsid_XXXX directories,
# e.g.  "../../../*/pointing_*/obsid_*".  
# THIS MUST BE A RELATIVE PATH, NOT AN ABSOLUTE PATH!

# The second parameter is the name of a subdirectory of those obsid_XXXX directories where the files needed by AE lie.
# The L1_2_L2_emaps.pro tool puts these files in a subdirectory named "AE".


set echo_style=both
set pushdsilent

set combine_flag=0
if ("$1" == "-COMBINE_FI_AND_BI") then
  shift
  echo 'Combining FI and BI data.  This is suitable only for astrometry analysis.'
  set combine_flag=1
endif

foreach obsid_dir ($1)
  printf '\nExamining %s/ ...\n' ${obsid_dir}/${2}
  set dir=`basename $obsid_dir | sed -e "s/obsid_/obs/"`

  set AE_directory_created=0
  
  if ($combine_flag == 1) then
    if (! -e ${dir})          mkdir ${dir}
    pushd                           ${dir}
    printf "\nCreated AE ObsID %s/\n" ${dir}
    set AE_directory_created=1
    
    # Look for FI+BI data products.
    set source_files = ($2/obs.AI.full.emap $2/validation.AI.evt $2/spectral.AI.evt $2/stowed.AI.full.emap $2/stowed.AI.evt $2/stowed.AI.scale.scale_map acis.astrometric.asol1 asphist obsid_\*_ardlib.par acis.pbk0    acis.msk1   acis.eph0 $2/totalbackground.AI.full.density $2/totalbackground.AI.vhard.density $2/totalbackground.AI.hard.density $2/totalbackground.AI.soft.density $2/obs.AI.full.emap $2/obs.AI.vhard.emap $2/obs.AI.hard.emap $2/obs.AI.soft.emap $2/obs.AI.soft_hi.emap $2/obs.AI.soft_med.emap $2/obs.AI.soft_low.emap $2/obs.AI.1300eV.emap $2/obs.AI.1700eV.emap  )
    set target_files = (           obs.emap       validation.evt       spectral.evt            stowed.emap       stowed.evt          diffuse.bkg.scaling obs.asol  asphist          ardlib.par  obs.pbkfile  obs.mskfile obs.eph        totalbackground.full.density       totalbackground.vhard.density       totalbackground.hard.density       totalbackground.soft.density       obs.full.emap       obs.vhard.emap       obs.hard.emap       obs.soft.emap       obs.soft_hi.emap       obs.soft_med.emap       obs.soft_low.emap       obs.1300eV.emap       obs.1700eV.emap  )

    @ index=1
    while ( $index <= ${#source_files} )
      
      # Start by removing a broken symlink.
      if ( -l ${target_files[$index]} && ! -e ${target_files[$index]}) then
        printf "Removing broken symlink %s.\n" ${target_files[$index]}
        ('rm' ${target_files[$index]} |& cat > /dev/null )
      endif
    
      if ( ! -e ${target_files[$index]} ) then
        # Target does not exist, so try to make the symlink.
        if ( -e ../$obsid_dir/${source_files[$index]} ) then
          ln -sv      ../$obsid_dir/${source_files[$index]} ${target_files[$index]}
        endif
    
      else if ( ! -l ${target_files[$index]} ) then
        # Target is an existing regular file (not symlink).
        printf "WARNING: a regular file named %s was found; cannot make the usual symlink.\n" ${target_files[$index]}
        
      else if (   -l ${target_files[$index]} ) then
        # Target is a valid symlink.
        #printf "Retaining symlink %s.\n"  ${target_files[$index]}
        
      else
        printf "ERROR IN LOGIC."
        exit 1
      endif
    
      @ index++
    end

    # If a Level 1 ephemeris file is available, then it should be used instead of the Level 0 ephemeris.
    if ( -e ../$obsid_dir/acis.eph1 ) then
     ('rm'                          obs.eph |& cat > /dev/null )
      ln -s ../$obsid_dir/acis.eph1 obs.eph
    endif

    popd

    continue
  endif


  # Look for FI data products.
  
  if (-e ${obsid_dir}/${2}/FI_data_present) then
    if (! -e ${dir}_FI)       mkdir ${dir}_FI
    pushd                           ${dir}_FI
    printf "\nCreated AE ObsID %s/\n" ${dir}_FI
    set AE_directory_created=1

    set source_files = ($2/obs.FI.full.emap $2/validation.FI.evt $2/spectral.FI.evt $2/stowed.FI.full.emap $2/stowed.FI.evt $2/stowed.FI.scale.scale_map acis.astrometric.asol1 asphist obsid_\*_ardlib.par acis.pbk0    acis.msk1   acis.eph0 $2/totalbackground.FI.full.density $2/totalbackground.FI.vhard.density $2/totalbackground.FI.hard.density $2/totalbackground.FI.soft.density $2/obs.FI.full.emap $2/obs.FI.vhard.emap $2/obs.FI.hard.emap $2/obs.FI.soft.emap $2/obs.FI.soft_hi.emap $2/obs.FI.soft_med.emap $2/obs.FI.soft_low.emap $2/obs.FI.1300eV.emap $2/obs.FI.1700eV.emap  )
    set target_files = (           obs.emap       validation.evt       spectral.evt            stowed.emap       stowed.evt          diffuse.bkg.scaling              obs.asol  asphist          ardlib.par  obs.pbkfile  obs.mskfile obs.eph        totalbackground.full.density       totalbackground.vhard.density       totalbackground.hard.density       totalbackground.soft.density       obs.full.emap       obs.vhard.emap       obs.hard.emap       obs.soft.emap       obs.soft_hi.emap       obs.soft_med.emap       obs.soft_low.emap       obs.1300eV.emap       obs.1700eV.emap  )

    @ index=1
    while ( $index <= ${#source_files} )

      # Start by removing a broken symlink.
      if ( -l ${target_files[$index]} && ! -e ${target_files[$index]}) then
        printf "Removing broken symlink %s.\n" ${target_files[$index]}
        ('rm' ${target_files[$index]} |& cat > /dev/null )
      endif
    
      if ( ! -e ${target_files[$index]} ) then
        # Target does not exist, so try to make the symlink.
        if ( -e ../$obsid_dir/${source_files[$index]} ) then
          ln -sv      ../$obsid_dir/${source_files[$index]} ${target_files[$index]}
        endif
    
      else if ( ! -l ${target_files[$index]} ) then
        # Target is an existing regular file (not symlink).
        printf "WARNING: a regular file named %s was found; cannot make the usual symlink.\n" ${target_files[$index]}
        
      else if (   -l ${target_files[$index]} ) then
        # Target is a valid symlink.
        #printf "Retaining symlink %s.\n"  ${target_files[$index]}
        
      else
        printf "ERROR IN LOGIC."
        exit 1
      endif
      
      @ index++
    end
    
    # If a Level 1 ephemeris file is available, then it should be used instead of the Level 0 ephemeris.
    if ( -e ../$obsid_dir/acis.eph1 ) then
     ('rm'                          obs.eph |& cat > /dev/null )
      ln -s ../$obsid_dir/acis.eph1 obs.eph
    endif

    popd
  endif


  # Look for BI data products.
  
  if (-e ${obsid_dir}/${2}/BI_data_present) then
    if (! -e ${dir}_BI)       mkdir ${dir}_BI
    pushd                           ${dir}_BI
    printf "\nCreated AE ObsID %s/\n" ${dir}_BI
    set AE_directory_created=1
    
    set source_files = ($2/obs.BI.full.emap $2/validation.BI.evt $2/spectral.BI.evt $2/stowed.BI.full.emap $2/stowed.BI.evt $2/stowed.BI.scale.scale_map acis.astrometric.asol1 asphist obsid_\*_ardlib.par acis.pbk0    acis.msk1    acis.eph0 $2/totalbackground.BI.full.density $2/totalbackground.BI.vhard.density $2/totalbackground.BI.hard.density $2/totalbackground.BI.soft.density $2/obs.BI.full.emap $2/obs.BI.vhard.emap $2/obs.BI.hard.emap $2/obs.BI.soft.emap $2/obs.BI.soft_hi.emap $2/obs.BI.soft_med.emap $2/obs.BI.soft_low.emap $2/obs.BI.1300eV.emap $2/obs.BI.1700eV.emap  )
    set target_files = (           obs.emap       validation.evt       spectral.evt            stowed.emap       stowed.evt          diffuse.bkg.scaling              obs.asol  asphist          ardlib.par  obs.pbkfile  obs.mskfile  obs.eph        totalbackground.full.density       totalbackground.vhard.density       totalbackground.hard.density       totalbackground.soft.density       obs.full.emap       obs.vhard.emap       obs.hard.emap       obs.soft.emap       obs.soft_hi.emap       obs.soft_med.emap       obs.soft_low.emap       obs.1300eV.emap       obs.1700eV.emap  )
    
    @ index=1
    while ( $index <= ${#source_files} )
      
      # Start by removing a broken symlink.
      if ( -l ${target_files[$index]} && ! -e ${target_files[$index]}) then
        printf "Removing broken symlink %s.\n" ${target_files[$index]}
        ('rm' ${target_files[$index]} |& cat > /dev/null )
      endif
    
      if ( ! -e ${target_files[$index]} ) then
        # Target does not exist, so try to make the symlink.
        if ( -e ../$obsid_dir/${source_files[$index]} ) then
          ln -sv      ../$obsid_dir/${source_files[$index]} ${target_files[$index]}
        endif
    
      else if ( ! -l ${target_files[$index]} ) then
        # Target is an existing regular file (not symlink).
        printf "WARNING: a regular file named %s was found; cannot make the usual symlink.\n" ${target_files[$index]}
        
      else if (   -l ${target_files[$index]} ) then
        # Target is a valid symlink.
        #printf "Retaining symlink %s.\n"  ${target_files[$index]}
        
      else
        printf "ERROR IN LOGIC."
        exit 1
      endif
      
      @ index++
    end
    
    # If a Level 1 ephemeris file is available, then it should be used instead of the Level 0 ephemeris.
    if ( -e ../$obsid_dir/acis.eph1 ) then
     ('rm'                          obs.eph |& cat > /dev/null )
      ln -s ../$obsid_dir/acis.eph1 obs.eph
    endif

    popd
  endif

  
  # Report problems
  if ( ${AE_directory_created} == 0 ) printf '\nERROR: No AE data found in ObsID directory %s.\n ' ${obsid_dir}/${2}

end
  
setenv OBS_LIST ""
foreach dir (obs*)
  set obs=`basename $dir | sed -e "s/obs//"`
  setenv OBS_LIST "$obs $OBS_LIST"
  end
printf "\n\nObsId list: %s\n" "$OBS_LIST"  

