;;; $Id: psb_xpar.pro 4993 2016-09-18 20:35:33Z psb6 $
;;; A wrapper for the AstroLib, designed to allow representations of IEEE 754 special values in FITS keywords.

;;; THIS TOOL DOES NOT SUPPORT "name" parameters of the form 'keyword*'.

;;; The FITS standard does not allow FLOAT keywords to repesent IEEE 754 special values, such as  NaN, Inf, -Inf.
;;; The wrappers psb_xaddpar.pro and psb_xpar.pro reserve certain string values to represent these IEEE 754 special values.
;;; The resulting FITS files conform to the syntax of the FITS standard, but of course these reserved strings will not be recognized by other FITS readers.

;;; Patrick Broos & Leisa Townsley, Penn State University, 2016
;;; patrick.broos@icloud.com   townsley@astro.psu.edu

FUNCTION psb_xpar, hdr, name, abort, COUNT=matches,    _REF_EXTRA=extra

; Historically I've used sxpar() instead of fxpar(), because fxpar() reads the historical representation of IEEE 754 special values (which violates the FITS standard) as strings, rather than as floats.
; I am continuing to use sxpar() in case there is some other vital difference between the two tools that I can't recall.
if N_params() GE 3 then $
  result = sxpar(    hdr, name, abort, COUNT=matches, _STRICT_EXTRA=extra) $
else $
  result = sxpar(    hdr, name,        COUNT=matches, _STRICT_EXTRA=extra)

; Abort if keyword not found.
if (matches EQ 0) then return, result

if (matches EQ 1) && (size(result, /TNAME) EQ 'STRING') then begin
  ; Convert certain "reserved" strings to IEEE 754 special values
  result = strtrim(result,2)

  if strmatch(/FOLD_CASE, result,  'NaN') then result =  !VALUES.F_NAN
  if strmatch(/FOLD_CASE, result,  'Inf') then result =  !VALUES.F_INFINITY
  if strmatch(/FOLD_CASE, result, '-Inf') then result = -!VALUES.F_INFINITY
endif ; STRING returned by sxpar()

return, result
end

