#!/usr/bin/perl
# $Id: plot_spectra.pl 5643 2021-12-14 14:31:38Z psb6 $
# plot_spectra.pl - print 12 large .EPS images to a sheet with latex commands
#
# Usage: plot_spectra.pl 182*/grp0_wabs_apec_cstat_3free.ps
#

use Getopt::Long;

my $doc_name = 'spectra';      # option variable with default value
my $angle_param = '-90';       # option variable with default value
my $num_per_page = 6;          # option variable with default value
GetOptions ('doc_name=s' => \$doc_name, 'angle_param=s' => \$angle_param, 'num_per_page=i' => \$num_per_page);

printf STDERR "angle=$angle_param \n";
printf STDERR "num_per_page=$num_per_page \n";


@epsfile = (@ARGV);


$i = 0;
open (FOO, ">$doc_name.tex") || die "Can't open $doc_name.tex: $!\n";
printf STDERR "opened file $doc_name.tex\n";
printf FOO "% Latex form to plot multiple figures per page\n";
printf FOO "% $Id: plot_spectra.pl 5643 2021-12-14 14:31:38Z psb6 $\n\n";

# We need the aastex class to get includegraphics below to not complain
printf FOO "\\documentclass{aastex62}\n";

printf FOO "\\setlength{\\headheight}{0in}\n";
printf FOO "\\setlength{\\headsep}   {0.1in}\n";
printf FOO "\\setlength{\\textheight}{10.0in}\n";
printf FOO "\\setlength{\\footskip}  {0.35in}\n";
printf FOO "\\setlength{\\evensidemargin}{-0.5in}\n";
printf FOO "\\setlength{\\oddsidemargin}{-0.5in}\n";
printf FOO "\\setlength{\\textwidth}    {8in}\n";

printf FOO "\\begin{document}\n\n";


while ($epsfile[$i]) {
  if ($i != 0) {printf FOO "\\clearpage\n";}
  printf FOO "\\begin{figure*}[!ht]\n";
  printf FOO "\\centering\n";
  
  $num_this_page = scalar(@epsfile) - $i;
  if ($num_this_page > $num_per_page) {$num_this_page = $num_per_page;}
  print "$num_this_page \n";
  
  for ($jj=0; $jj < $num_this_page; $jj++) {
	# The rotation spec MUST come before the width spec!
    printf FOO "\\includegraphics[angle=$angle_param,width=0.49\\textwidth]{$epsfile[$i]}";$i++;
    if( $jj%2 == 0) {printf FOO " \\hfill";}
  # if( $jj%2 == 1) {printf FOO " \\hfill";}
    if( $jj%2 == 1) {printf FOO " \\\\";}
    printf FOO " \n";
	  if( $jj%2 == 1) {printf FOO "\\vspace*{0.5in}\n";}
  }

  printf FOO "\\end{figure*}\n";
}
#printf FOO "\\scriptsize\n";
#printf FOO "\\noindent\n";
#printf FOO "THE END\n";
printf FOO "\\end{document}\n";
close(FOO);


# The dvips options are supposed to embed the fonts.
system("latex $doc_name.tex;latex $doc_name.tex;dvips -Ppdf -G0 $doc_name -o $doc_name.ps; open -a Preview $doc_name.ps");
