# Quantum Fourier Transform Benchmark

The Quantum Fourier Transform is used as a subroutine in many quantum
algorithms and thus constitutes an example with great practical importance.
The gates used in this circuit are `H`, `CU1`, and `SWAP`,
all of which are available in Qibo and other used libraries,
except QCGPU where `SWAP` was implemented using three `CNOT` gates.


## Single precision (`complex64`)

`nqubits` | Qibo (GPU) | Qibo (multi-GPU) | QCGPU (GPU) | Qibo (CPU) | Qibo (CPU-1) | QCGPU (CPU) | Cirq (CPU) | TFQ (CPU)
-- | -- | -- | -- | -- | -- | -- | -- | --
25 | 0.15088 | 1.7333 | 0.33926 | 1.75593 | 28.983 | 2.81661 | 20.04615 | 27.31083
26 | 0.26269 | 2.09426 | 0.70485 | 3.68007 | 62.33386 | 5.98906 | 42.59027 | 57.70737
27 | 0.48103 | 2.79575 | 1.4615 | 7.71366 | 133.49707 | 12.57996 | 88.89556 | 123.62698
28 | 0.93884 | 3.9641 | 3.04468 | 16.36245 | 285.99587 | 26.39612 | 185.83514 | 264.49645
29 | 1.88652 | 6.53928 | 6.32165 | 34.66599 | 616.35557 | 54.92496 | 383.06087 | 558.00182
30 | 3.90816 | 11.76768 | 13.16367 | 73.43444 | 1328.38914 | 116.36015 | 805.87551 | 1179.73661
31 | 8.08614 | 21.9935 | 27.39081 | 155.01974 | 2863.07021 | 245.91649 | 1689.20272 | core dumped
32 | 67.08172 (2x)  | 42.51865 | OOM | 329.56916 | 6170.86231 | fails | 3550.67372 |
33 | 182.26496 (4x) | 70.30869 |         | 694.67844 | 13300.37152 |         | fails |
34 | 464.34191 (8x) | 160.39392 |         | 1465.81645 | 28667.11473 |         |         |

![qft-64](../images/qft_c64.png)


## Double precision (`complex128`)

`nqubits` | Qibo (GPU) | Qibo (multi-GPU) | Qulacs (GPU) | Qibo (CPU) | Qibo (CPU-1) | Qulacs (CPU) | IntelQS (CPU) | Qiskit (CPU) | PyQuil (CPU)
-- | -- | -- | -- | -- | -- | -- | -- | -- | --
25 | 0.25463 | 2.06511 | 0.87435 | 2.68645 | 31.42569 | 5.41102 | 17.2777 | 267.32462 | 116.83364
26 | 0.47597 | 2.7348 | 1.78204 | 5.60514 | 67.51781 | 11.11646 | 37.10058 | 537.95522 | 244.95282
27 | 0.93437 | 3.86462 | 3.64287 | 11.78381 | 144.42056 | 23.01487 | 78.81581 | 1075.48524 | 518.42093
28 | 1.87903 | 6.34791 | 7.45497 | 24.84334 | 309.06432 | 47.82596 | 166.74768 | 2156.63058 | 1084.50795
29 | 3.8849 | 11.05362 | 15.27099 | 52.47754 | 663.96249 | 99.40361 | 350.3245 | 4290.20236 | fails
30 | 8.10977 | 21.21188 | 31.42752 | 110.6095 | 1426.46899 | 207.96072 | 744.3759 | 8564.4294 |
31 | 68.09852 (2x) | 41.26969 | OOM | 232.35723 | 3064.75608 | 435.65923 | 1553.70923 | fails  |
32 | 182.78114 (4x) | 66.40625 |         | 488.00321 | 6584.73906 | 912.57703 | 3279.90343 |         |
33 | 468.13457 (8x) | 161.33294 |         | 1021.06619 | 14147.73073 | fails | 6867.85147 |         |

![qft-c128](../images/qft_c128.png)
