# Tutorials

In this folder we present some examples of quantum circuits applied to specific
physics problems.

- [Scaling of variational quantum circuit depth for condensed matter systems](aavqe/README.md)
- [Grover’s Algorithm for solving Satisfiability Problems](grover3sat/README.md)
- [Grover's Algorithm for solving a Toy Sponge Hash function](hash-grover/README.md)
- [Variational Quantum Classifier](variational_classifier/README.md)
- [Data reuploading for a universal quantum classifier](reuploading_classifier/README.md)
- [Quantum autoenconder for data compression](autoencoder/README.md)
- [Quantum Singular Value Decomposer](qsvd/README.md)
- [Measuring the tangle of three-qubit states](3_tangle/README.md)
- [Quantum unary approach to option pricing](unary/README.md)
- [Simple Adiabatic Evolution Examples](adiabatic/README.md)
- [Adiabatic evolution for solving an Exact Cover problem](adiabatic-3SAT/README.md)
- [Quantum autoencoders with enhanced data encoding](EF_QAE/README.md)
- [Shor's factorization algorithm](shor/README.md)
- [Determining the proton content with proton with a quantum computer](qPDF/qPDF.ipynb)
- [Maximal violation of Bell inequalities variationally](bell-variational/README.md)
- [Feedback-based ALgorithm for Quantum OptimizatioN - FALQON](falqon/README.md)
- [A general Grover model](grover/README.md)

In the `benchmarks` folder we have included examples concerning:
- A generic benchmark script for multiple circuits (`benchmarks/main.py`)
- Variational Quantum Eigensolver (`benchmarks/vqe.py`)
- Adiabatic evolution for the Ising Hamiltonian using linear scaling (`benchmarks/evolution.py`)
- Quantum approximate optimization algorithm model (`benchmarks/qaoa.py`)
