### 3.1. General process model
One of the main goals of the Metadata4Ing ontology is to enable researchers to document the provenance of data and material objects created or modified during research processes. Metadata4Ing accomplishes this with the help of a generalized process model centered around the class [_processing step_](#http://w3id.org/nfdi4ing/metadata4ing#ProcessingStep). The aforementioned data and material objects are described as output of the [_processing step_](#http://w3id.org/nfdi4ing/metadata4ing#ProcessingStep). Other relevant information like, e.g., the methods or tools used in a research process, are described in separate classes that can be linked to [_processing step_](#http://w3id.org/nfdi4ing/metadata4ing#ProcessingStep). A series of [_processing step_](#http://w3id.org/nfdi4ing/metadata4ing#ProcessingStep)s can be used to represent complex research processes (cf. [Section "Specifying complex setups and processes by using composition"](#38-specifying-complex-setups-and-processes-by-using-composition)). Metadata4Ing can therefore be seen as a system of building blocks that can be referred to by [_processing step_](#http://w3id.org/nfdi4ing/metadata4ing#ProcessingStep) and in their totality enable a complete description of the provenance of a dataset or material object.

![Overview of the central classes and their connections](https://git.rwth-aachen.de/nfdi4ing/metadata4ing/metadata4ing/-/raw/master/visualizations/Metadata4IngBaseClassesAll.png)

### 3.2. Processing step as central element
The central class of Metadata4Ing is [_processing step_](#http://w3id.org/nfdi4ing/metadata4ing#ProcessingStep) that can be used to describe all kinds of processes and does not distinguish between different types of processing steps. The pattern formed by [_processing step_](#http://w3id.org/nfdi4ing/metadata4ing#ProcessingStep) and its admissible object properties is therefore considered universal for all kinds of processes.
A distinction between processes is achieved by adding further information as described in the following subsections.

### 3.3. Specifying in- and output
One of the major roles of [_processing step_](#http://w3id.org/nfdi4ing/metadata4ing#ProcessingStep) is to connect data and material objects to the processing step they were created in or modified by. It is usually good practice to treat modified datasets and material objects as newly created instances of their respective classes instead of reusing the original instance with altered attributes. This may seem unintuitive especially for material objects that continue to exist after modification. But it is a necessity to be able to unambiguously refer to each "state" of modified entities. Each state may have been the subject of investigation or the in- or output in previous processing steps and therefore needs to persist as an unaltered node in the knowledge graph. For processing steps representing modifications of entities, the state before the modification would therefore be specified via [_has input_](#http://purl.obolibrary.org/obo/RO_0002233), whereas the resulting modified state of entity would be modelled as a new instance that is specified via [_has output_](#http://purl.obolibrary.org/obo/RO_0002234).

[_Has input_](#http://purl.obolibrary.org/obo/RO_0002233) can also be used to indicate other things that acted as input in a processing step, e.g. chemical substances or datasets (cf. [Section "Specifying datasets"](#310-specifying-datasets-a)). Both [_has input_](#http://purl.obolibrary.org/obo/RO_0002233) and [_has output_](#http://purl.obolibrary.org/obo/RO_0002234) can refer to all kinds of entites, regardless of whether they are material (e.g. physical objects) or immaterial (e.g. datasets). Note, however, that [_has input_](#http://purl.obolibrary.org/obo/RO_0002233) should not be used for specifying tools used in a processing step or the investigated object (e.g. for a measurement), both of which can be indicated with more specific properties described in the next subsections (cf. [_has employed tool_](#http://w3id.org/nfdi4ing/metadata4ing#hasEmployedTool) and [_investigates_](#http://w3id.org/nfdi4ing/metadata4ing#investigates)).

### 3.4. Specifying the investigated object and property
Many processes (e.g. measurements or simulations) performed during research aim to investigate an object. In Metadata4Ing, this object of investigation can be specified with the [_investigates_](#http://w3id.org/nfdi4ing/metadata4ing#investigates) property, by which an arbitrary entity (both material and immaterial) can be connected to a [_processing step_](#http://w3id.org/nfdi4ing/metadata4ing#ProcessingStep). In addition to the object itself, a specific property that is investigated (e.g. temperature, pressure) can be specified via [_investigates property_](#http://w3id.org/nfdi4ing/metadata4ing#investigatesProperty).

### 3.5. Specifying employed tools and methods
Another essential element for documenting a process is information on what has been done. For this, Metadata4Ing includes the classes [_method_](#http://w3id.org/nfdi4ing/metadata4ing#Method) and [_tool_](#http://w3id.org/nfdi4ing/metadata4ing#Tool). [_Method_](#http://w3id.org/nfdi4ing/metadata4ing#Method) describes the method that has been realized in the processing step (e.g. heating, numerical simulation) along with relevant parameters and can be added to the [_processing step_](#http://w3id.org/nfdi4ing/metadata4ing#ProcessingStep) via the [_realizes method_](#http://w3id.org/nfdi4ing/metadata4ing#realizesMethod) property. In a similar fashion, [_tool_](#http://w3id.org/nfdi4ing/metadata4ing#Tool) is used to describe a tool used to perform the processing step (e.g. water bath, simulation software) and can be linked to the [_processing step_](#http://w3id.org/nfdi4ing/metadata4ing#ProcessingStep) via the [_has employed tool_](#http://w3id.org/nfdi4ing/metadata4ing#hasEmployedTool) property.

In addition, Metadata4Ing includes the [_implements_](#http://w3id.org/nfdi4ing/metadata4ing#implements) property that can be used to indicate that a specific [_tool_](#http://w3id.org/nfdi4ing/metadata4ing#Tool) implements a certain [_method_](#http://w3id.org/nfdi4ing/metadata4ing#Method), as well as the inverse relation [_implemented by_](#http://w3id.org/nfdi4ing/metadata4ing#implementedBy). It is recommended that at least two sides of the information triangle formed by [_realizes method_](#http://w3id.org/nfdi4ing/metadata4ing#realizesMethod), [_has employed tool_](#http://w3id.org/nfdi4ing/metadata4ing#hasEmployedTool) and [_implements_](#http://w3id.org/nfdi4ing/metadata4ing#implements) are included when documenting a processing step.

Depending on the granularity of the processing step described, multiple methods and tools may be added to a single processing step (cf. [Section "Specifying complex setups and processes by using composition"](#38-specifying-complex-setups-and-processes-by-using-composition)).

### 3.6. Specifying parameters
For both [_method_](#http://w3id.org/nfdi4ing/metadata4ing#Method) and [_tool_](#http://w3id.org/nfdi4ing/metadata4ing#Tool), relevant parameters (e.g. duration for the method "heating" or temperature for the tool "water bath") can be specified with the [_has parameter_](#http://w3id.org/nfdi4ing/metadata4ing#hasParameter) property as a [_variable_](#http://www.molmod.info/semantics/pims-ii.ttl#Variable). For further information on the description of variables, cf. [Section Representation of variables](variables).

### 3.7. Specifying persons and projects

Any [_person_](#http://xmlns.com/foaf/Person) can most prominently be identified via an [_ORCiD Id_](#http://w3id.org/nfdi4ing/metadata4ing#orcidId) but also via characteristics like [_first name_](#http://xmlns.com/foaf/firstName), [_last name_](#http://xmlns.com/foaf/lastName), [_personal mailbox_](#http://xmlns.com/foaf/mbox), or [_title_](#http://xmlns.com/foaf/title).

A [_person_](#http://xmlns.com/foaf/Person) typically is affiliated with [_affiliation_](#https://schema.org/affiliation) to an [_organization_](#http://xmlns.com/foaf/Organization), which in turn can be identified via a ROR ID (use property [_has research organization registry id_](#http://w3id.org/nfdi4ing/metadata4ing#hasRorId)).

An [_organization_](#http://xmlns.com/foaf/Organization) may conduct [_research projects_](#https://schema.org/ResearchProject). These projects may be [_funded by_](#https://schema.org/funder) other [_organizations_](#http://xmlns.com/foaf/Organization). A [_research project_](#https://schema.org/ResearchProject) is usually limited in time and has a specific  [_start date_](#http://w3id.org/nfdi4ing/metadata4ing#startOfProject) and [_end date_](#http://w3id.org/nfdi4ing/metadata4ing#endOfProject). It  usually has a unique [_project reference ID_](#http://w3id.org/nfdi4ing/metadata4ing#projectReferenceID), especially when it is funded by third parties like the _Deutsche Forschungsgemeinschaft_ (DFG). A project usually has several [_project participants_](#http://w3id.org/nfdi4ing/metadata4ing#projectParticipant) which are [_organizations_](#http://xmlns.com/foaf/Organization).

A [_processing step_](#http://w3id.org/nfdi4ing/metadata4ing#ProcessingStep) may be part of such a [_research project_](#https://schema.org/ResearchProject). In any particular [_processing step_](#http://w3id.org/nfdi4ing/metadata4ing#ProcessingStep) several agents (e.g. people, organizations, software agents) can be involved [_taking on a particular role_](#http://www.w3.org/ns/prov#hadRole) in the processing step, e.g. [_data collector_](#http://w3id.org/nfdi4ing/metadata4ing#DataCollector).

The overall connection between these classes can be summarized as shown in the next figure.

![Participation in processing steps](https://git.rwth-aachen.de/nfdi4ing/metadata4ing/metadata4ing/-/raw/master/visualizations/Participation.png)

### 3.8. Specifying complex setups and processes by using composition
Oftentimes, a process performed during research consists of several substeps performed in sequence or parallel, or a tool consists of multiple components (e.g. a hardware assembly). In Metadata4Ing, these situations can be described via composition. A complex processing step and its substeps can both be modelled as instances of [_processing step_](#http://w3id.org/nfdi4ing/metadata4ing#ProcessingStep), and the substeps can be declared as such by giving them the [_part of_](#http://purl.obolibrary.org/obo/BFO_0000050) property pointing to the instance of the complex processing step. With the properties [_starts with_](#http://purl.obolibrary.org/obo/RO_0002224), [_ends with_](#http://purl.obolibrary.org/obo/RO_0002230) and [_precedes_](#http://purl.obolibrary.org/obo/BFO_0000063) an ordering of steps is possible.
In a similar fashion, [_part of_](#http://purl.obolibrary.org/obo/BFO_0000050) can be used to combine components into a multi-component tool, all of which can be modelled as instances of [_tool_](#http://w3id.org/nfdi4ing/metadata4ing#Tool).

![Using isStepInAction to describe substeps of a processing step](https://git.rwth-aachen.de/nfdi4ing/metadata4ing/metadata4ing/-/raw/master/visualizations/Metadata4IngProcessDecomposition.png)

Since each substep in the composed step can be given all attributes of a [_processing step_](#http://w3id.org/nfdi4ing/metadata4ing#ProcessingStep) (including [_investigates_](#http://w3id.org/nfdi4ing/metadata4ing#investigates), [_has employed tool_](#http://w3id.org/nfdi4ing/metadata4ing#hasEmployedTool), [_has input_](#http://purl.obolibrary.org/obo/RO_0002233) and [_has output_](#http://purl.obolibrary.org/obo/RO_0002234)), it becomes possible to provide a detailled description, including relations between the in- and output of specific components and substeps of a complex setup.

![Using composition to describe complex setups and processes](https://git.rwth-aachen.de/nfdi4ing/metadata4ing/metadata4ing/-/raw/master/visualizations/Complex_Setup.png)

### 3.9. Specifying parameters by variables
A building element in all quantitative sciences is the concept of [_variable_](#http://www.molmod.info/semantics/pims-ii.ttl#Variable). A [_variable_](#http://www.molmod.info/semantics/pims-ii.ttl#Variable) can be assigned a value (numerical, literal or logical) and can be attributed to a research object (as an intrinsic property), to a process (as technical parameter, independent regulated variable or result) or to the content of a dataset. Thus, a variable is the result of evalutating an expression, in both the mathematical and computer-science meaning of the word. A [_method_](#http://w3id.org/nfdi4ing/metadata4ing#Method) or a [_tool_](#http://w3id.org/nfdi4ing/metadata4ing#Tool) can  refer to a variable as its [_parameter_](#http://w3id.org/nfdi4ing/metadata4ing#hasParameter); a [_processing step_](#http://w3id.org/nfdi4ing/metadata4ing#ProcessingStep) can [_investigate_](#http://w3id.org/nfdi4ing/metadata4ing#investigates) it. Special attention is devoted to numerical variables.

A [_variable_](#http://www.molmod.info/semantics/pims-ii.ttl#Variable) arising in the context of a research activity is an instance of a more generally defined [_kind of quantity_](#http://w3id.org/nfdi4ing/metadata4ing#KindOfQuantity), which is usually normed within well-established vocabularies (ISO 80000, IEC, QUDT, EMMO); the recommended way to express the [_kind of quantity_](#http://w3id.org/nfdi4ing/metadata4ing#KindOfQuantity) is via a persistent URI to the corresponding vocabulary entry. A [_kind of quantity_](#http://w3id.org/nfdi4ing/metadata4ing#KindOfQuantity) and consequently a [_variable_](#http://www.molmod.info/semantics/pims-ii.ttl#Variable) can be associated to a limited set of admissible [_measurement units_](#http://emmo.info/emmo#EMMO_b081b346_7279_46ef_9a3d_2c088fcd79f). Within a research activity, a variable can receive a [_quantity value_](#http://www.molmod.info/semantics/pims-ii.ttl#QuantityValue) in the context of a [_numerical assignment_](#http://w3id.org/nfdi4ing/metadata4ing#NumericalAssignment), which includes a time stamp and the creation date.

This [_quantity value_](#http://www.molmod.info/semantics/pims-ii.ttl#QuantityValue) by itself is a multi-component object which contains all information for the rigorous description of a numerical value. This is presently implemented by an object of the form [_Real_](#https://ptb.de/si/Real), which includes the core metrological information describing a scalar quantity value: a numerical value, a [_measurement unit_](#http://emmo.info/emmo#EMMO_b081b346_7279_46ef_9a3d_2c088fcd79f4) and an [_uncertainty declaration_](#http://w3id.org/nfdi4ing/metadata4ing#UncertaintyDeclaration), in the form of either a [_coverage interval_](#https://ptb.de/si/CoverageInterval) or an [_expanded uncertainty_](#https://ptb.de/si/ExpandedUnc) containing the uncertainty value, a [_coverage factor_](#https://ptb.de/si/hasCoverageFactor), the [_coverage probability_](#https://ptb.de/si/hasCoverageProbability) and optionally the underlying [_probability density distribution_](#https://ptb.de/si/hasDistribution).

![Darstellung numerischer Variablen](https://git.rwth-aachen.de/nfdi4ing/metadata4ing/metadata4ing/-/raw/master/visualizations/Metadata4IngVariableAssignment.png)

### 3.10. Specifying datasets  </a>
One possible output or input of a [_processing step_](#http://w3id.org/nfdi4ing/metadata4ing#ProcessingStep) is a [_Dataset_](#http://www.w3.org/ns/dcat#Dataset) that represents a set of data. We use the concepts of DCAT (v2 and v3) to describe datasets. A [_Dataset_](#http://www.w3.org/ns/dcat#Dataset) can be serialized in one or several [_Distribution_](#http://www.w3.org/ns/dcat#Distribution)s. A distribution stands for a digital file that is available under a [_download URL_](#http://www.w3.org/ns/dcat#downloadURL) and can be characterized by [_byte size_](#http://www.w3.org/ns/dcat#byteSize). A [_Dataset_](#http://www.w3.org/ns/dcat#Dataset) can also be part of a [_DatasetSeries_](#http://www.w3.org/ns/dcat#DatasetSeries). 

![Datasets and their relations](https://git.rwth-aachen.de/nfdi4ing/metadata4ing/metadata4ing/-/raw/master/visualizations/Dataset.png)

### 3.11. Specifying related publications
The data acquired during research activities may become part of an analysis and a concluding interpretation. Traditionally, these activities are summed up in monographs or journal articles. Scientific publications and their metadata are fortunately online and persistently identified these days, their metadata provided as a [_bibliographic record_](#http://purl.org/spar/biro/BibliographicRecord). To connect a [_Dataset_](#http://www.w3.org/ns/dcat#Dataset) to a related publication, it [_references_](http://purl.org/dc/terms/references) a [_bibliographic record_](#http://purl.org/spar/biro/BibliographicRecord) or [_is referenced by_](http://purl.org/dc/terms/isReferencedBy) one.

![Publication](https://git.rwth-aachen.de/nfdi4ing/metadata4ing/metadata4ing/-/raw/master/visualizations/Publication.png)

