# import the necessary packages
import os

# define the base path to the *original* input dataset and then use
# the base path to derive the image and annotations directories
ORIG_BASE_PATH = "raccoons"
ORIG_IMAGES = os.path.sep.join([ORIG_BASE_PATH, "images"])
ORIG_ANNOTS = os.path.sep.join([ORIG_BASE_PATH, "annotations"])  # contains xml files.

# define the base path to the *new* dataset after running our dataset
# builder scripts and then use the base path to derive the paths to
# our output class label directories
BASE_PATH = "dataset"
POSITVE_PATH = os.path.sep.join([BASE_PATH, "raccoon"])
NEGATIVE_PATH = os.path.sep.join([BASE_PATH, "no_raccoon"])

# define the number of max proposals used when running selective
# search for (1) gathering training data and (2) performing inference
MAX_PROPOSALS = 2000  # spend computation here
MAX_PROPOSALS_INFER = 200  # inferenece - we do not want to spend a lot of time here

# define the maximum number of positive and negative images to be
# generated from each image - it created them
MAX_POSITIVE = 30  # balance number of positive
MAX_NEGATIVE = 10  # balance number of non positice - max similar

# initialize the input dimensions to the network
INPUT_DIMS = (224, 224)  # width and height of convolutional

# define the path to the output model and label binarizer
MODEL_PATH = "keras_model.h5"
ENCODER_PATH = "label_encoder.pickle"  # human readable

# define the minimum probability required for a positive prediction
# (used to filter out false-positive predictions)
MIN_PROBA = 0.99  # we expecting really high accurancy - might be lowered for other applications.
