# Disaster Detection
Disaster classifier for detecting fire, flood and building disasters. The data that was used were taken from images from the internet, YouTube, Kaggle and from various missions that KIOS captured using UAVs (mostly for fires). These data were trained using https://teachablemachine.withgoogle.com/,  Google’s online classifier. A TensorFlow model was exported and further used for detecting where exactly in the image or video frames a disaster is found. 
In order to convert the classifier to an object detector, upon capturing video frames, the image is rescaled to smaller images like a pyramid. Then, for each rescaled  frame a sliding window with a fixed size is passed through the image and classifying each region of interest.  These classifications are converted to boxes, therefore having multiple sized boxes depending on frame size. Finally, non-maxima suppression is used on these boxes to get the final detection boxes on the original frame.

## Package Requirments
- Numpy
- OpenCV
- Imutils
- Tensorflow 
- Pillow

## Run the Code
```sh
>python "Disaster_detection.py" --video "videofile.mp4" --model disaster.h5 --size "(200,200)" -v 1 -o video3.avi
```
# Parameters
- -v/--video : input video file
- -m/--model : classification model in tensorflow
- -s/--size : Region of Interest Size eg. "(200,200)"
- -o/--output : Output video filename
- -c/--min-conf : Minimum probability to filter weak detections
- -v/--visualize :Disable or enable the results visualizations

