# Title:  Figure 2

# Purpose : This script was created for the
#           article "Freedoms and free-market
#           capitalism beyond utopias and
#           dystopias — A World Without Money
#           revised"

# Project number: #0010

# Author: Fabio A. Telarico
# Contact details: fatelatico@gmail.com

# Date script created: Sat Jan 29 2022

# Libraries
if(!required(ggplot2))install.packages("ggplot2")
if(!required(ggthemes))install.packages("ggthemes")
if(!required(tidyr))install.packages("tidyr")

library(ggplot2)
library(ggthemes)
library(tidyr)

# Data input
Figure2Data<-
  data.frame(Year=c(1990,1993,1996,1999,2002,2005,2008,2010,2011,2012,2013,2015),
             RelativePoor=c(2351000000,2363000000,2318000000,2394000000,2387000000,2301000000,2275000000,2247000000,2193000000,2181000000,2120000000,2086000000),
             AbsolutePoor=c(1903000000,1876000000,1698000000,1728000000,1609000000,1351000000,1222000000,1089000000,962000000,907000000,803000000,734000000)
             )

# Data manipulation
Figure2<-data.frame(
  pivot_longer(
    data = Figure2Data,
    cols = c("RelativePoor","AbsolutePoor"),
    names_to = "Data")
)

pattern <- unique(Figure2$Data)
Figure2$Data<-gsub(pattern = "RelativePoor",
                   replacement = "In relative poverty",
                   x = Figure2$Data)
Figure2$Data<-gsub(pattern = "AbsolutePoor",
                   replacement = "In absolute poverty",
                   x = Figure2$Data)

# Plot

base_text_size<-22

path<-getwd()

themes<-
  theme_wsj()+
  # theme_fivethirtyeight(base_size = base_text_size)+
  # theme_stata(scheme = "s2mono")+
  theme(text = element_text(family = "serif"),
        plot.title=element_text(size=base_text_size, face="bold"),
        axis.text.x=element_text(size=2*base_text_size, margin = margin(b=.8*base_text_size,t=.25*base_text_size),angle = 90,vjust = 0.5),
        axis.text.y.left=element_text(size=2*base_text_size, margin = margin(l=.8*base_text_size, r=.4*base_text_size),hjust = 1),
        axis.title.x=element_text(size=2.5*base_text_size,margin=margin(b=.1*base_text_size)),
        axis.title.y.left=element_text(size=2.5*base_text_size),
        legend.text = element_text(size=1.5*base_text_size),
        # legend.margin = margin(l=40*base_text_size,t=.1*base_text_size),
        legend.title = element_text(size=1.5*base_text_size,face = "bold"),
        legend.position="bottom",
        legend.direction = "vertical",
        legend.box = "horizontal",
        legend.box.margin = margin(b=.1*base_text_size),
        panel.grid.major.y = element_line(size = .02*base_text_size,colour = "gray",linetype = "solid"),
        plot.margin = unit(c(.1,.1,0,.1),units = "cm")
        
  )

Plot2<-
  ggplot(data = Figure2, aes(x = Year,y=value/1000000))+
  geom_line(aes(fill=Data,color=Data,linetype="Data"),
                  size=.13*base_text_size)+
  geom_smooth(aes(fill=Data,color=Data,linetype="Trend"),
              se = F, size=.13*base_text_size)+
  geom_jitter(aes(fill=Data,color=Data),
              size=.3*base_text_size,
              shape=21)+
  scale_y_continuous(
    name = "Millions of people",
    n.breaks = 10
  )+
  scale_x_continuous(
    name = "",
    breaks = seq(1990,2015,1)
  )+
  scale_color_brewer("Colour",palette = "Dark2",
                     aesthetics = c("color","fill"),direction = 1)+
  scale_linetype_manual("Line",values = c(1,3))+
  themes

# Print plot

png(filename = paste0(path,"/Plot2.png"),
    width = 1920,height = 1080,units = "px")
plot(Plot2)
dev.off()

# Export data
saveRDS(object = Figure2,
        file = paste0(path,"/Figure2.RDS"))

saveRDS(object = Figure2Data,
        file = paste0(path,"/Figure2_Data.RDS"))
