/****************************************************************************
 *
 *   (c) 2009-2016 QGROUNDCONTROL PROJECT <http://www.qgroundcontrol.org>
 *
 * QGroundControl is licensed according to the terms in the file
 * COPYING.md in the root of the source code directory.
 *
 ****************************************************************************/


#ifndef GENERICAUTOPILOT_H
#define GENERICAUTOPILOT_H

#include "AutoPilotPlugin.h"

/// @file
///     @brief This is the generic implementation of the AutoPilotPlugin class for mavs
///             we do not have a specific AutoPilotPlugin implementation.
///     @author Don Gagne <don@thegagnes.com>

class GenericAutoPilotPlugin : public AutoPilotPlugin
{
    Q_OBJECT

public:
    GenericAutoPilotPlugin(Vehicle* vehicle, QObject* parent = NULL);
    
    // Overrides from AutoPilotPlugin
    virtual const QVariantList& vehicleComponents(void);
    
public slots:
    // FIXME: This is public until we restructure AutoPilotPlugin/FirmwarePlugin/Vehicle
    void _parametersReadyPreChecks(bool missingParameters);
};

#endif
