function [features, featureMetrics, varargout] = exampleBagOfFeaturesExtractor_KAZE(I)

%% Step 1: Convert I to grayscale if required.
[~,~,numChannels] = size(I);
if numChannels > 1
    grayImage = rgb2gray(I);
else
    grayImage = I;
end

%% Step 2: Select Point Locations for Feature Extraction
KAZEPoints = detectKAZEFeatures(grayImage);

%% Step 3: Extract features
features = extractFeatures(grayImage, KAZEPoints,'Upright',true);

%% Step 4: Compute the Feature Metric
% Use the variance of the KAZE features as the feature metric.
featureMetrics = var(features,[],2);

% Optionally return the feature location information. The feature location
% information is used for image search applications. See the retrieveImages
% and indexImages functions.
if nargout > 2
    % Return feature location information
    varargout{1} = KAZEPoints.Location;
end