clear all

% List of PNGs files / image distance metrics
IMGlist=dir('./img/*.png');
IMGid=strcat({IMGlist.name})';

%7308 images / distance matrices
imgSet = imageDatastore('./img/','FileExtensions',{'.png'}); 
extractorFcn = @exampleBagOfFeaturesExtractor_KAZE; % KAZE CustomExtractor

% Create Bag of Features   / Vocabulary size  1000 (change vocabulary size to 2000, 3000,... and check accuracy)
bag = bagOfFeatures(imgSet, 'VocabularySize', 1000, 'CustomExtractor',extractorFcn,'UseParallel',true,'StrongestFeatures',1.0);                      
%Create an image search index and add images.
imageIndex = invertedImageIndex(bag);
addImages(imageIndex, imgSet);

% read list of SCOPe ENT files
SCOPe_ENT=importdata('./entlist/SCOPe_ENT');
% read list of SCOPe Classe
SCOPe_Class=importdata('./entlist/SCOPe_Class');

%%%%%%%%%%%% calculate accuracay: 1th nearest neghbour
ACCU=[]; %Accuracy at Class, Fold, Superf. and Famaly level > Columns 1, 2, 3, 4
NN=[]; % Nearest Neighbor
for i=1:size(IMGid,1)
    I=imread(cell2mat(imgSet.Files(i)));
    [imageIDs, score, ~] = retrieveImages(I,imageIndex,'NumResults',2);
    % (i) is query image
    FAM1=SCOPe_Class(i,1);
    temp=split(FAM1,'.'); % split and construct class, fold and superf.
    SUPF1=strcat(temp{1},'.',temp{2},'.',temp{3});
    FOLD1=strcat(temp{1},'.',temp{2});
    CLAS1=strcat(temp{1});
    % (2) nearest neighbor
    FAM2=SCOPe_Class(imageIDs(2)); % 1st score = 1 (comparing to itself), 2nd is nearest neighbor
    temp=split(FAM2,'.'); % split and construct class, fold and superf.
    SUPF2=strcat(temp{1},'.',temp{2},'.',temp{3});
    FOLD2=strcat(temp{1},'.',temp{2});
    CLAS2=strcat(temp{1});
    %
    NN=[NN;FAM2];
    %Accuracy at Class, Fold, Superf. and Famaly level > Columns 1, 2, 3, 4
    ACCU=[ACCU;strcmp(CLAS1,CLAS2),strcmp(FOLD1,FOLD2),strcmp(SUPF1,SUPF2),strcmp(FAM1,FAM2)];
    fprintf('%4i%8.4f%8.4f%8.4f%8.4f\n',i,sum(ACCU,1)./size(ACCU,1));
end

%Columns of M 
%(1) SCOPe entry
%(2) image file PNG
%(3) SCOPe class of query
%(4) nearest neighbor SCOPe class - predicted
M=[SCOPe_ENT,IMGid,SCOPe_Class,NN];

