/*
 * Copyright (C) 2009-2011 by Benedict Paten (benedictpaten@gmail.com)
 *
 * Released under the MIT license, see LICENSE.txt
 */

/*
 * MERGE POTENTIALLY OVERLAPPING FASTA FILES GENERATED BY
 * cactus_batch_chunkSequences INTO A SINGLE FASTA FILE, reads fasta files from stdin, writes them merged to stdout.
 */

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <float.h>
#include <ctype.h>
#include <errno.h>

#include "bioioC.h"
#include "commonC.h"

/* Read fasta sequence from files into the "cur" variables.
 * Then merge into the outputFile (stdout)
 */
static void readFastaCallback(void* destination, const char *fastaHeader, const char *sequence, int64_t length) {
    stList *attributes = fastaDecodeHeader(fastaHeader);
    int64_t offset;
    int64_t i = sscanf(stList_peek(attributes), "%" PRIi64 "", &offset);
    (void) i;
    assert(i == 1);
    assert(offset >= 0);
    if (offset == 0) {
        free(stList_pop(attributes));
        char *cA = fastaEncodeHeader(attributes);
        fprintf(stdout, ">%s\n", cA);
        free(cA);
    }
    stList_destruct(attributes);
    fprintf(stdout, "%s\n", sequence);
}

int main(int argc, char *argv[]) {
    char *line = stFile_getLineFromFile(stdin);
    if(line != NULL) {
        stList *files = stString_split(line);
        for(int64_t i=0; i<stList_length(files); i++) {
            FILE* chunkFile = fopen(stList_get(files, i), "r");
            fastaReadToFunction(chunkFile, NULL, readFastaCallback);
            fclose(chunkFile);
        }
        stList_destruct(files);
        free(line);
    }
    return 0;
}
