/*
 * Copyright (C) 2009-2011 by Benedict Paten (benedictpaten@gmail.com)
 *
 * Released under the MIT license, see LICENSE.txt
 */

#ifndef CACTUS_GLOBALS_PRIVATE_H_
#define CACTUS_GLOBALS_PRIVATE_H_

#include <stdlib.h>
#include <stdbool.h>
#include <stdint.h>
#include <assert.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sys/stat.h>
#include <sys/types.h>

#include "CuTest.h"
#include "sonLib.h"
#include "commonC.h"

#define NAME_STRING "%" PRIi64 ""

#include "cactusGroup.h"
#include "cactusGroupPrivate.h"
#include "cactusBlock.h"
#include "cactusSegment.h"
#include "cactusSegmentPrivate.h"
#include "cactusBlockPrivate.h"
#include "cactusChain.h"
#include "cactusChainPrivate.h"
#include "cactusEnd.h"
#include "cactusCap.h"
#include "cactusCapPrivate.h"
#include "cactusEndPrivate.h"
#include "cactusEvent.h"
#include "cactusEventPrivate.h"
#include "cactusEventTree.h"
#include "cactusEventTreePrivate.h"
#include "cactusGlobals.h"
#include "cactusLink.h"
#include "cactusLinkPrivate.h"
#include "cactusSequence.h"
#include "cactusSequencePrivate.h"
#include "cactusFlower.h"
#include "cactusDisk.h"
#include "cactusDiskPrivate.h"
#include "cactusMisc.h"
#include "cactusFlowerPrivate.h"
#include "cactusTestCommon.h"

#endif
