/* SPDX-License-Identifier: ISC */
/*
 * Authors: Dan Williams
 *          Martin Lucina
 *          Felipe Huici <felipe.huici@neclab.eu>
 *          Florian Schmidt <florian.schmidt@neclab.eu>
 *          Simon Kuenzer <simon.kuenzer@neclab.eu>
 *
 * Copyright (c) 2015-2017 IBM
 * Copyright (c) 2016-2017 Docker, Inc.
 * Copyright (c) 2017-2019 NEC Laboratories Europe GmbH, NEC Corporation
 *
 * Permission to use, copy, modify, and/or distribute this software
 * for any purpose with or without fee is hereby granted, provided
 * that the above copyright notice and this permission notice appear
 * in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/* Taken from solo5 */
/*
 * For simplicity we currently use the exact same setup as ukvm, 2MB pages with
 * a 3-level page hierarchy. We only map the first 1GB, if you want a unikernel
 * bigger than that, feel free to fix.
 */

#define PAGETABLE_RO         0x1
#define PAGETABLE_RW         0x3
#define PAGETABLE_LARGEPAGE  0x80

.align 0x1000
cpu_zeropt:
	/* the first 1M is inaccessible, except for:
	   0x09000 - 0x09fff -> multiboot info @ 0x09500 (read-only)
	   0xb8000 - 0xbffff -> VGA buffer (read+write)
	 */
	.fill 0x9, 0x8, 0x0
	.quad 0x0000000000009000 + PAGETABLE_RO
	.quad 0x000000000000a000 + PAGETABLE_RO
	.quad 0x000000000000b000 + PAGETABLE_RO
	.quad 0x000000000000c000 + PAGETABLE_RO
	.quad 0x000000000000d000 + PAGETABLE_RO
	.quad 0x000000000000e000 + PAGETABLE_RO
	.quad 0x000000000000f000 + PAGETABLE_RO
	.quad 0x0000000000010000 + PAGETABLE_RO
	.fill 0xa7, 0x8, 0x0
	.quad 0x00000000000b8000 + PAGETABLE_RW
	.quad 0x00000000000b9000 + PAGETABLE_RW
	.quad 0x00000000000ba000 + PAGETABLE_RW
	.quad 0x00000000000bb000 + PAGETABLE_RW
	.quad 0x00000000000bc000 + PAGETABLE_RW
	.quad 0x00000000000bd000 + PAGETABLE_RW
	.quad 0x00000000000be000 + PAGETABLE_RW
	.quad 0x00000000000bf000 + PAGETABLE_RW
	.fill 0x40, 0x8, 0x0
	.quad 0x00000000000100000 + PAGETABLE_RW
	.quad 0x00000000000101000 + PAGETABLE_RW
	.quad 0x00000000000102000 + PAGETABLE_RW
	.quad 0x00000000000103000 + PAGETABLE_RW
	.quad 0x00000000000104000 + PAGETABLE_RW
	.quad 0x00000000000105000 + PAGETABLE_RW
	.quad 0x00000000000106000 + PAGETABLE_RW
	.quad 0x00000000000107000 + PAGETABLE_RW
	.quad 0x00000000000108000 + PAGETABLE_RW
	.quad 0x00000000000109000 + PAGETABLE_RW
	.quad 0x0000000000010a000 + PAGETABLE_RW
	.quad 0x0000000000010b000 + PAGETABLE_RW
	.quad 0x0000000000010c000 + PAGETABLE_RW
	.quad 0x0000000000010d000 + PAGETABLE_RW
	.quad 0x0000000000010e000 + PAGETABLE_RW
	.quad 0x0000000000010f000 + PAGETABLE_RW
	.quad 0x00000000000110000 + PAGETABLE_RW
	.quad 0x00000000000111000 + PAGETABLE_RW
	.quad 0x00000000000112000 + PAGETABLE_RW
	.quad 0x00000000000113000 + PAGETABLE_RW
	.quad 0x00000000000114000 + PAGETABLE_RW
	.quad 0x00000000000115000 + PAGETABLE_RW
	.quad 0x00000000000116000 + PAGETABLE_RW
	.quad 0x00000000000117000 + PAGETABLE_RW
	.quad 0x00000000000118000 + PAGETABLE_RW
	.quad 0x00000000000119000 + PAGETABLE_RW
	.quad 0x0000000000011a000 + PAGETABLE_RW
	.quad 0x0000000000011b000 + PAGETABLE_RW
	.quad 0x0000000000011c000 + PAGETABLE_RW
	.quad 0x0000000000011d000 + PAGETABLE_RW
	.quad 0x0000000000011e000 + PAGETABLE_RW
	.quad 0x0000000000011f000 + PAGETABLE_RW
	.quad 0x00000000000120000 + PAGETABLE_RW
	.quad 0x00000000000121000 + PAGETABLE_RW
	.quad 0x00000000000122000 + PAGETABLE_RW
	.quad 0x00000000000123000 + PAGETABLE_RW
	.quad 0x00000000000124000 + PAGETABLE_RW
	.quad 0x00000000000125000 + PAGETABLE_RW
	.quad 0x00000000000126000 + PAGETABLE_RW
	.quad 0x00000000000127000 + PAGETABLE_RW
	.quad 0x00000000000128000 + PAGETABLE_RW
	.quad 0x00000000000129000 + PAGETABLE_RW
	.quad 0x0000000000012a000 + PAGETABLE_RW
	.quad 0x0000000000012b000 + PAGETABLE_RW
	.quad 0x0000000000012c000 + PAGETABLE_RW
	.quad 0x0000000000012d000 + PAGETABLE_RW
	.quad 0x0000000000012e000 + PAGETABLE_RW
	.quad 0x0000000000012f000 + PAGETABLE_RW
	.quad 0x00000000000130000 + PAGETABLE_RW
	.quad 0x00000000000131000 + PAGETABLE_RW
	.quad 0x00000000000132000 + PAGETABLE_RW
	.quad 0x00000000000133000 + PAGETABLE_RW
	.quad 0x00000000000134000 + PAGETABLE_RW
	.quad 0x00000000000135000 + PAGETABLE_RW
	.quad 0x00000000000136000 + PAGETABLE_RW
	.quad 0x00000000000137000 + PAGETABLE_RW
	.quad 0x00000000000138000 + PAGETABLE_RW
	.quad 0x00000000000139000 + PAGETABLE_RW
	.quad 0x0000000000013a000 + PAGETABLE_RW
	.quad 0x0000000000013b000 + PAGETABLE_RW
	.quad 0x0000000000013c000 + PAGETABLE_RW
	.quad 0x0000000000013d000 + PAGETABLE_RW
	.quad 0x0000000000013e000 + PAGETABLE_RW
	.quad 0x0000000000013f000 + PAGETABLE_RW
	.quad 0x00000000000140000 + PAGETABLE_RW
	.quad 0x00000000000141000 + PAGETABLE_RW
	.quad 0x00000000000142000 + PAGETABLE_RW
	.quad 0x00000000000143000 + PAGETABLE_RW
	.quad 0x00000000000144000 + PAGETABLE_RW
	.quad 0x00000000000145000 + PAGETABLE_RW
	.quad 0x00000000000146000 + PAGETABLE_RW
	.quad 0x00000000000147000 + PAGETABLE_RW
	.quad 0x00000000000148000 + PAGETABLE_RW
	.quad 0x00000000000149000 + PAGETABLE_RW
	.quad 0x0000000000014a000 + PAGETABLE_RW
	.quad 0x0000000000014b000 + PAGETABLE_RW
	.quad 0x0000000000014c000 + PAGETABLE_RW
	.quad 0x0000000000014d000 + PAGETABLE_RW
	.quad 0x0000000000014e000 + PAGETABLE_RW
	.quad 0x0000000000014f000 + PAGETABLE_RW
	.quad 0x00000000000150000 + PAGETABLE_RW
	.quad 0x00000000000151000 + PAGETABLE_RW
	.quad 0x00000000000152000 + PAGETABLE_RW
	.quad 0x00000000000153000 + PAGETABLE_RW
	.quad 0x00000000000154000 + PAGETABLE_RW
	.quad 0x00000000000155000 + PAGETABLE_RW
	.quad 0x00000000000156000 + PAGETABLE_RW
	.quad 0x00000000000157000 + PAGETABLE_RW
	.quad 0x00000000000158000 + PAGETABLE_RW
	.quad 0x00000000000159000 + PAGETABLE_RW
	.quad 0x0000000000015a000 + PAGETABLE_RW
	.quad 0x0000000000015b000 + PAGETABLE_RW
	.quad 0x0000000000015c000 + PAGETABLE_RW
	.quad 0x0000000000015d000 + PAGETABLE_RW
	.quad 0x0000000000015e000 + PAGETABLE_RW
	.quad 0x0000000000015f000 + PAGETABLE_RW
	.quad 0x00000000000160000 + PAGETABLE_RW
	.quad 0x00000000000161000 + PAGETABLE_RW
	.quad 0x00000000000162000 + PAGETABLE_RW
	.quad 0x00000000000163000 + PAGETABLE_RW
	.quad 0x00000000000164000 + PAGETABLE_RW
	.quad 0x00000000000165000 + PAGETABLE_RW
	.quad 0x00000000000166000 + PAGETABLE_RW
	.quad 0x00000000000167000 + PAGETABLE_RW
	.quad 0x00000000000168000 + PAGETABLE_RW
	.quad 0x00000000000169000 + PAGETABLE_RW
	.quad 0x0000000000016a000 + PAGETABLE_RW
	.quad 0x0000000000016b000 + PAGETABLE_RW
	.quad 0x0000000000016c000 + PAGETABLE_RW
	.quad 0x0000000000016d000 + PAGETABLE_RW
	.quad 0x0000000000016e000 + PAGETABLE_RW
	.quad 0x0000000000016f000 + PAGETABLE_RW
	.quad 0x00000000000170000 + PAGETABLE_RW
	.quad 0x00000000000171000 + PAGETABLE_RW
	.quad 0x00000000000172000 + PAGETABLE_RW
	.quad 0x00000000000173000 + PAGETABLE_RW
	.quad 0x00000000000174000 + PAGETABLE_RW
	.quad 0x00000000000175000 + PAGETABLE_RW
	.quad 0x00000000000176000 + PAGETABLE_RW
	.quad 0x00000000000177000 + PAGETABLE_RW
	.quad 0x00000000000178000 + PAGETABLE_RW
	.quad 0x00000000000179000 + PAGETABLE_RW
	.quad 0x0000000000017a000 + PAGETABLE_RW
	.quad 0x0000000000017b000 + PAGETABLE_RW
	.quad 0x0000000000017c000 + PAGETABLE_RW
	.quad 0x0000000000017d000 + PAGETABLE_RW
	.quad 0x0000000000017e000 + PAGETABLE_RW
	.quad 0x0000000000017f000 + PAGETABLE_RW
	.quad 0x00000000000180000 + PAGETABLE_RW
	.quad 0x00000000000181000 + PAGETABLE_RW
	.quad 0x00000000000182000 + PAGETABLE_RW
	.quad 0x00000000000183000 + PAGETABLE_RW
	.quad 0x00000000000184000 + PAGETABLE_RW
	.quad 0x00000000000185000 + PAGETABLE_RW
	.quad 0x00000000000186000 + PAGETABLE_RW
	.quad 0x00000000000187000 + PAGETABLE_RW
	.quad 0x00000000000188000 + PAGETABLE_RW
	.quad 0x00000000000189000 + PAGETABLE_RW
	.quad 0x0000000000018a000 + PAGETABLE_RW
	.quad 0x0000000000018b000 + PAGETABLE_RW
	.quad 0x0000000000018c000 + PAGETABLE_RW
	.quad 0x0000000000018d000 + PAGETABLE_RW
	.quad 0x0000000000018e000 + PAGETABLE_RW
	.quad 0x0000000000018f000 + PAGETABLE_RW
	.quad 0x00000000000190000 + PAGETABLE_RW
	.quad 0x00000000000191000 + PAGETABLE_RW
	.quad 0x00000000000192000 + PAGETABLE_RW
	.quad 0x00000000000193000 + PAGETABLE_RW
	.quad 0x00000000000194000 + PAGETABLE_RW
	.quad 0x00000000000195000 + PAGETABLE_RW
	.quad 0x00000000000196000 + PAGETABLE_RW
	.quad 0x00000000000197000 + PAGETABLE_RW
	.quad 0x00000000000198000 + PAGETABLE_RW
	.quad 0x00000000000199000 + PAGETABLE_RW
	.quad 0x0000000000019a000 + PAGETABLE_RW
	.quad 0x0000000000019b000 + PAGETABLE_RW
	.quad 0x0000000000019c000 + PAGETABLE_RW
	.quad 0x0000000000019d000 + PAGETABLE_RW
	.quad 0x0000000000019e000 + PAGETABLE_RW
	.quad 0x0000000000019f000 + PAGETABLE_RW
	.quad 0x000000000001a0000 + PAGETABLE_RW
	.quad 0x000000000001a1000 + PAGETABLE_RW
	.quad 0x000000000001a2000 + PAGETABLE_RW
	.quad 0x000000000001a3000 + PAGETABLE_RW
	.quad 0x000000000001a4000 + PAGETABLE_RW
	.quad 0x000000000001a5000 + PAGETABLE_RW
	.quad 0x000000000001a6000 + PAGETABLE_RW
	.quad 0x000000000001a7000 + PAGETABLE_RW
	.quad 0x000000000001a8000 + PAGETABLE_RW
	.quad 0x000000000001a9000 + PAGETABLE_RW
	.quad 0x000000000001aa000 + PAGETABLE_RW
	.quad 0x000000000001ab000 + PAGETABLE_RW
	.quad 0x000000000001ac000 + PAGETABLE_RW
	.quad 0x000000000001ad000 + PAGETABLE_RW
	.quad 0x000000000001ae000 + PAGETABLE_RW
	.quad 0x000000000001af000 + PAGETABLE_RW
	.quad 0x000000000001b0000 + PAGETABLE_RW
	.quad 0x000000000001b1000 + PAGETABLE_RW
	.quad 0x000000000001b2000 + PAGETABLE_RW
	.quad 0x000000000001b3000 + PAGETABLE_RW
	.quad 0x000000000001b4000 + PAGETABLE_RW
	.quad 0x000000000001b5000 + PAGETABLE_RW
	.quad 0x000000000001b6000 + PAGETABLE_RW
	.quad 0x000000000001b7000 + PAGETABLE_RW
	.quad 0x000000000001b8000 + PAGETABLE_RW
	.quad 0x000000000001b9000 + PAGETABLE_RW
	.quad 0x000000000001ba000 + PAGETABLE_RW
	.quad 0x000000000001bb000 + PAGETABLE_RW
	.quad 0x000000000001bc000 + PAGETABLE_RW
	.quad 0x000000000001bd000 + PAGETABLE_RW
	.quad 0x000000000001be000 + PAGETABLE_RW
	.quad 0x000000000001bf000 + PAGETABLE_RW
	.quad 0x000000000001c0000 + PAGETABLE_RW
	.quad 0x000000000001c1000 + PAGETABLE_RW
	.quad 0x000000000001c2000 + PAGETABLE_RW
	.quad 0x000000000001c3000 + PAGETABLE_RW
	.quad 0x000000000001c4000 + PAGETABLE_RW
	.quad 0x000000000001c5000 + PAGETABLE_RW
	.quad 0x000000000001c6000 + PAGETABLE_RW
	.quad 0x000000000001c7000 + PAGETABLE_RW
	.quad 0x000000000001c8000 + PAGETABLE_RW
	.quad 0x000000000001c9000 + PAGETABLE_RW
	.quad 0x000000000001ca000 + PAGETABLE_RW
	.quad 0x000000000001cb000 + PAGETABLE_RW
	.quad 0x000000000001cc000 + PAGETABLE_RW
	.quad 0x000000000001cd000 + PAGETABLE_RW
	.quad 0x000000000001ce000 + PAGETABLE_RW
	.quad 0x000000000001cf000 + PAGETABLE_RW
	.quad 0x000000000001d0000 + PAGETABLE_RW
	.quad 0x000000000001d1000 + PAGETABLE_RW
	.quad 0x000000000001d2000 + PAGETABLE_RW
	.quad 0x000000000001d3000 + PAGETABLE_RW
	.quad 0x000000000001d4000 + PAGETABLE_RW
	.quad 0x000000000001d5000 + PAGETABLE_RW
	.quad 0x000000000001d6000 + PAGETABLE_RW
	.quad 0x000000000001d7000 + PAGETABLE_RW
	.quad 0x000000000001d8000 + PAGETABLE_RW
	.quad 0x000000000001d9000 + PAGETABLE_RW
	.quad 0x000000000001da000 + PAGETABLE_RW
	.quad 0x000000000001db000 + PAGETABLE_RW
	.quad 0x000000000001dc000 + PAGETABLE_RW
	.quad 0x000000000001dd000 + PAGETABLE_RW
	.quad 0x000000000001de000 + PAGETABLE_RW
	.quad 0x000000000001df000 + PAGETABLE_RW
	.quad 0x000000000001e0000 + PAGETABLE_RW
	.quad 0x000000000001e1000 + PAGETABLE_RW
	.quad 0x000000000001e2000 + PAGETABLE_RW
	.quad 0x000000000001e3000 + PAGETABLE_RW
	.quad 0x000000000001e4000 + PAGETABLE_RW
	.quad 0x000000000001e5000 + PAGETABLE_RW
	.quad 0x000000000001e6000 + PAGETABLE_RW
	.quad 0x000000000001e7000 + PAGETABLE_RW
	.quad 0x000000000001e8000 + PAGETABLE_RW
	.quad 0x000000000001e9000 + PAGETABLE_RW
	.quad 0x000000000001ea000 + PAGETABLE_RW
	.quad 0x000000000001eb000 + PAGETABLE_RW
	.quad 0x000000000001ec000 + PAGETABLE_RW
	.quad 0x000000000001ed000 + PAGETABLE_RW
	.quad 0x000000000001ee000 + PAGETABLE_RW
	.quad 0x000000000001ef000 + PAGETABLE_RW
	.quad 0x000000000001f0000 + PAGETABLE_RW
	.quad 0x000000000001f1000 + PAGETABLE_RW
	.quad 0x000000000001f2000 + PAGETABLE_RW
	.quad 0x000000000001f3000 + PAGETABLE_RW
	.quad 0x000000000001f4000 + PAGETABLE_RW
	.quad 0x000000000001f5000 + PAGETABLE_RW
	.quad 0x000000000001f6000 + PAGETABLE_RW
	.quad 0x000000000001f7000 + PAGETABLE_RW
	.quad 0x000000000001f8000 + PAGETABLE_RW
	.quad 0x000000000001f9000 + PAGETABLE_RW
	.quad 0x000000000001fa000 + PAGETABLE_RW
	.quad 0x000000000001fb000 + PAGETABLE_RW
	.quad 0x000000000001fc000 + PAGETABLE_RW
	.quad 0x000000000001fd000 + PAGETABLE_RW
	.quad 0x000000000001fe000 + PAGETABLE_RW
	.quad 0x000000000001ff000 + PAGETABLE_RW

.align 0x1000
cpu_pd:
	.quad cpu_zeropt + PAGETABLE_RW
	.quad 0x0000000000200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000000400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000000600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000000800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000000a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000000c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000000e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000001000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000001200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000001400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000001600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000001800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000001a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000001c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000001e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000002000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000002200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000002400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000002600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000002800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000002a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000002c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000002e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000003000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000003200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000003400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000003600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000003800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000003a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000003c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000003e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000004000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000004200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000004400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000004600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000004800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000004a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000004c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000004e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000005000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000005200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000005400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000005600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000005800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000005a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000005c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000005e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000006000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000006200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000006400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000006600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000006800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000006a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000006c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000006e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000007000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000007200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000007400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000007600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000007800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000007a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000007c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000007e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000008000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000008200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000008400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000008600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000008800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000008a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000008c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000008e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000009000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000009200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000009400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000009600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000009800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000009a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000009c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000009e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000a000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000a200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000a400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000a600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000a800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000aa00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000ac00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000ae00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000b000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000b200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000b400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000b600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000b800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000ba00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000bc00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000be00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000c000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000c200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000c400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000c600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000c800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000ca00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000cc00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000ce00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000d000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000d200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000d400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000d600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000d800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000da00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000dc00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000de00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000e000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000e200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000e400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000e600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000e800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000ea00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000ec00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000ee00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000f000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000f200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000f400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000f600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000f800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000fa00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000fc00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000000fe00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000010000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000010200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000010400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000010600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000010800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000010a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000010c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000010e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000011000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000011200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000011400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000011600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000011800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000011a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000011c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000011e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000012000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000012200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000012400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000012600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000012800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000012a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000012c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000012e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000013000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000013200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000013400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000013600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000013800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000013a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000013c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000013e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000014000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000014200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000014400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000014600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000014800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000014a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000014c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000014e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000015000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000015200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000015400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000015600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000015800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000015a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000015c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000015e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000016000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000016200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000016400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000016600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000016800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000016a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000016c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000016e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000017000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000017200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000017400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000017600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000017800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000017a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000017c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000017e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000018000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000018200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000018400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000018600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000018800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000018a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000018c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000018e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000019000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000019200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000019400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000019600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000019800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000019a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000019c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000019e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001a000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001a200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001a400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001a600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001a800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001aa00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001ac00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001ae00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001b000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001b200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001b400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001b600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001b800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001ba00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001bc00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001be00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001c000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001c200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001c400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001c600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001c800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001ca00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001cc00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001ce00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001d000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001d200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001d400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001d600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001d800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001da00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001dc00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001de00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001e000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001e200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001e400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001e600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001e800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001ea00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001ec00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001ee00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001f000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001f200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001f400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001f600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001f800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001fa00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001fc00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000001fe00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000020000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000020200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000020400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000020600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000020800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000020a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000020c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000020e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000021000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000021200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000021400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000021600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000021800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000021a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000021c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000021e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000022000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000022200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000022400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000022600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000022800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000022a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000022c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000022e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000023000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000023200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000023400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000023600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000023800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000023a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000023c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000023e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000024000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000024200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000024400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000024600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000024800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000024a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000024c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000024e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000025000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000025200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000025400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000025600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000025800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000025a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000025c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000025e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000026000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000026200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000026400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000026600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000026800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000026a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000026c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000026e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000027000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000027200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000027400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000027600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000027800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000027a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000027c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000027e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000028000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000028200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000028400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000028600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000028800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000028a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000028c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000028e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000029000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000029200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000029400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000029600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000029800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000029a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000029c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000029e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002a000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002a200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002a400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002a600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002a800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002aa00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002ac00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002ae00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002b000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002b200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002b400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002b600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002b800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002ba00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002bc00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002be00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002c000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002c200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002c400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002c600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002c800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002ca00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002cc00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002ce00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002d000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002d200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002d400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002d600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002d800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002da00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002dc00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002de00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002e000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002e200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002e400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002e600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002e800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002ea00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002ec00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002ee00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002f000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002f200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002f400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002f600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002f800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002fa00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002fc00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000002fe00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000030000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000030200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000030400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000030600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000030800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000030a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000030c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000030e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000031000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000031200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000031400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000031600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000031800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000031a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000031c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000031e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000032000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000032200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000032400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000032600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000032800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000032a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000032c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000032e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000033000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000033200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000033400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000033600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000033800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000033a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000033c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000033e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000034000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000034200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000034400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000034600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000034800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000034a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000034c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000034e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000035000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000035200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000035400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000035600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000035800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000035a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000035c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000035e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000036000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000036200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000036400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000036600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000036800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000036a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000036c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000036e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000037000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000037200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000037400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000037600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000037800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000037a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000037c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000037e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000038000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000038200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000038400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000038600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000038800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000038a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000038c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000038e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000039000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000039200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000039400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000039600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000039800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000039a00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000039c00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x0000000039e00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003a000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003a200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003a400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003a600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003a800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003aa00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003ac00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003ae00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003b000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003b200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003b400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003b600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003b800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003ba00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003bc00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003be00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003c000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003c200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003c400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003c600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003c800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003ca00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003cc00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003ce00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003d000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003d200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003d400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003d600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003d800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003da00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003dc00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003de00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003e000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003e200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003e400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003e600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003e800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003ea00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003ec00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003ee00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003f000000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003f200000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003f400000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003f600000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003f800000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003fa00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003fc00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE
	.quad 0x000000003fe00000 + PAGETABLE_RW + PAGETABLE_LARGEPAGE

.align 0x1000
cpu_pdpt:
	.quad cpu_pd + PAGETABLE_RW
	.fill 0x1ff, 0x8, 0x0

.align 0x1000
cpu_pml4:
	.quad cpu_pdpt + PAGETABLE_RW
	.fill 0x1ff, 0x8, 0x0
