# SPDX-License-Identifier: BSD-3-Clause
#
# Authors: Alexander Jung <alexander.jung@neclab.eu>
#
# Copyright (c) 2020, NEC Europe Ltd., NEC Corporation. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. Neither the name of the copyright holder nor the names of its
#    contributors may be used to endorse or promote products derived from
#    this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
from __future__ import absolute_import
from __future__ import unicode_literals

from setuptools import find_packages
from setuptools import setup

from kraft import __description__
from kraft import __version__

with open('requirements.txt') as f:
    required = [x for x in f.read().splitlines() if not x.startswith("#")]

setup(
    name='unikraft-tools',
    version=__version__,
    packages=find_packages(exclude=['tests.*', 'tests']),
    description=__description__,
    license='',
    url='https://github.com/unikraft/kraft.git',
    author='Alexander Jung',
    author_email='a.jung@lancs.ac.uk',
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Science/Research',
        'Intended Audience :: Developers',
        'Topic :: Scientific/Engineering',
        'Topic :: Software Development :: Build Tools',
        'License :: OSI Approved :: BSD License',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],
    python_requires='>=3.5, <4',
    entry_points="""
        [console_scripts]
        kraft=kraft.kraft:kraft
        """,
    scripts=[
        'scripts/qemu-guest',
        'scripts/xen-guest',
        'scripts/kraft-net'
    ],
    package_data={
        'kraft.cmd.build' :  [
            'coccinelle-rules/gatereplacer.cocci.in',
            'coccinelle-rules/callbackreplacer.cocci.in',
            'coccinelle-rules/heap-localvars-1.cocci.in',
            'coccinelle-rules/heap-localvars-2.cocci.in',
            'coccinelle-rules/mallocreplacer.cocci',
            'coccinelle-rules/dss-localvars.cocci',
            'coccinelle-rules/globalvars.cocci',
            'misc-replacements/linkerscript_data.in',
            'misc-replacements/linkerscript_bss.in',
            'misc-replacements/localextra.ld.in',
            'misc-replacements/ukboot_decl_sections.in',
            'misc-replacements/ukboot_init_sections.in',
            'misc-replacements/flexos_core_tsb_decls.in',
            'misc-replacements/flexos_core_tsb_hdecls.in',
            'misc-replacements/flexos_core_alloc_decls.in',
            'misc-replacements/ukalloc_getdefault.in',
            'misc-replacements/ukthread_initdecl.in',
            'misc-replacements/ukthread_initcall.in',
            'misc-replacements/uksched_initstacks.in',
            'misc-replacements/ukthread_installstacks.in',
            'misc-replacements/uksched_idleinit_nulls.in'
        ]
    },
    keywords=[],
    tests_require=['pytest', 'coveralls'],
    zip_safe=False,
    install_requires=required,
    include_package_data=True
)
